////////////////////////////////////////////////////////////////////////////////
//
//    List Manager - Header file
//
//  (c) Copyright 2003 Point Mad. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _LIST_H_INCLUDED_
#define _LIST_H_INCLUDED_

typedef struct TListItem *PListItem;
typedef struct TListItem
{
	PListItem Next;
	PListItem Prev;

	l_ulong DataType;
	l_ulong DataSize;

	void *Data;
	char *Key;

	void (*FreeData) (void*);
} TListItem;

typedef struct TList *PList;
typedef struct TList
{
	PListItem Last;
	PListItem Current;
} TList;

PListItem  NewListItemEx   ( char *Key, void *Data, void (*FreeData) (void*), l_ulong DataType, l_ulong DataSize );
PListItem  NewListItem     ( char *Key, void *Data, void (*FreeData) (void*) );
PListItem  ListAddItem     ( PList o, PListItem i );
PListItem  ListAdd         ( PList o, char *Key, void *Data, void (*FreeData) (void*) );
char       ListRemoveItem  ( PList o, PListItem i );
PListItem  ListAtItem      ( PList o, unsigned long Index );
void      *ListAt          ( PList o, unsigned long Index );
PListItem  ListKeyItem     ( PList o, char *Key );
void      *ListKey         ( PList o, char *Key );
PListItem  ListKeyCaseItem     ( PList o, char *Key );
void      *ListKeyCase         ( PList o, char *Key );
PListItem  ListFoundItem   ( PList o, void *Data );
PList      NewList         ( void );
unsigned long ListFoundIndex ( PList o, void *Data );

// /!\ This 2 functions dot no order Items in List, but Data /!\ ->-> To be improved ...
char       ListOrderByData ( PList o, long (*comparator) ( void*,void*) );
char       ListOrderByItem ( PList o, long (*comparator) ( PListItem,PListItem) );

void FreeList ( PList o );
void KickList ( PList o );

#endif /* _LIST_H_INCLUDED_ */
