//
//    MARAUDER
//
//    genepool.h: genetic evolution object definition
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.



#define ALIEN_COUNT  16


struct infoitem
{
    int dist;
    int dir;
};



struct info
{
    infoitem treasure;
    infoitem planet;
    infoitem ship;
    infoitem player;
    infoitem laser;
    infoitem missile;
    int buy_planet;
    int sell_planet;
    int money;
    int cargo;
    int damage;
    int v1, v2;
};



#define TREASURE_DIR    0      // 0-7, clockwise
#define PLANET_DIR      1
#define SHIP_DIR        2
#define PLAYER_DIR      3
#define LASER_DIR       4
#define MISSILE_DIR     5
#define TREASURE_DIST   6      // in pixels
#define PLANET_DIST     7
#define SHIP_DIST       8
#define PLAYER_DIST     9
#define LASER_DIST      10
#define MISSILE_DIST    11
#define BUY_PLANET      12     // -1 = true, 0 = false
#define SELL_PLANET     13
#define MONEY           14     // infinite
#define CARGO           15     // 0-100
#define DAMAGE          16     // 0-100
#define V1              17
#define V2              18

#define UNUSED          0
#define EQUAL           1
#define NOT_EQUAL       2
#define GREATER         3
#define LESS            4
#define GREAT_OR_EQUAL  5
#define LESS_OR_EQUAL   6
#define APPROXIMATE     7



struct action
{
    int left;
    int right;
    int forwards;
    int fire;
};



struct rule
{
    int is_value1;
    int is_value2;
    int value1;
    int value2;
    int op;
};



class gene
{
public:
    gene();
    int read_action(char *buf, int len, int *amount_read);
    int read(char *buf, int len, int *amount_read);
    void evaluate(struct info *inf, action *a);
private:
    rule rule1, rule2; 
    action act;
    int towards;
    int to_angle;
    int to_priority;
    int set_v1;
    int set_v2;
};



class geneinstance
{
public:
    geneinstance();
    geneinstance(geneinstance *other);
    ~geneinstance();
    int read(char *buf, int len, int *amount_read);
    void evaluate(struct info *inf, action *act);
    int get_speed() { return speed; }
    int get_turn_speed() { return turn_speed; }
    int get_shields() { return shields; }
    int get_weapon() { return weapon; }
private:
    int speed;
    int turn_speed;
    int weapon;
    int shields;
    int rule_count;
    gene *rules;
};



class genepool
{
public:
    genepool();
    ~genepool();
    int load_genes();
    geneinstance *get_genes(multidir **spr, int *col);
private:
    int read(char *buf, int len);
    char filename[80];
    geneinstance *g[ALIEN_COUNT];
    int gene_pos;
};


