//
//    MARAUDER
//
//    game.cpp: main game loop
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <allegro.h>
#include "marauder.h"
#include "sprite.h"
#include "genes.h"
#include "mgr.h"
#include "alien.h"
#include "bullet.h"

extern DATAFILE *dat;
extern BITMAP *s2;

void remove_screen();
void draw_stats();

int hide, cheat;
int have_cheated;
char hide_str[] = "hideme";
char rich_str[] = "makemerich";
char cheat_str[] = "shawniscool";

char *msg_str = NULL;

int dead;

extern int profile;
int frame_count;
volatile int time_count;


SHIP_STATE default_ship_state = {
    1000,   // money
    0,      // cargo
    0,      // shields
    0,      // missiles
    0,      // torpedoes
    0,      // mines
    0,      // proton gun
    0,      // matter cannon
    0       // afterburner
};


genepool *genes = NULL;
playership *ship = NULL;
alienmgr *aliens = NULL;
spritemgr *planets = NULL;
spritemgr *bullets = NULL;
exploder *explode = NULL;
spritemgr *explosions = NULL;
spritemgr *treasures = NULL;
multidir *bullet1 = NULL, *bullet2 = NULL, *bullet3 = NULL,
	 *bullet4 = NULL, *bullet5 = NULL, *bullet6 = NULL;
int bound1, bound2, bound3, bound4, bound5, bound6;
multidir *treasure_sprite = NULL;
int treasure_bound;
multidir *go = NULL, *still = NULL, *burn = NULL;
multidir *alien_pics[ALIEN_COUNT];
int alien_col[ALIEN_COUNT];


int radar_flag = 0;
int move_count = 0;
int paused;


dirty_list dirty, old_dirty;



dirty_list::dirty_list()
{
    size = count = 0;
    data = NULL;
}



dirty_list::~dirty_list()
{
    if (data)
	free(data);
}



void dirty_list::resize(int s)
{
    count = s;
    if (count > size)
	data = (RECT *)realloc(data, sizeof(RECT)*s);
}



void dirty_list::reset()
{
    resize(1);
    data[0].x = 0;
    data[0].y = 0;
    data[0].w = SCREEN_W-80;
    data[0].h = SCREEN_H;
}



void dirty_list::empty()
{
    count = 0;
}



void dirty_list::add(int x, int y, int w, int h)
{
    if ((w <= 0) || (h <= 0))
	return;

    resize(count+1);
    data[count-1].x = x;
    data[count-1].y = y;
    data[count-1].w = w;
    data[count-1].h = h;
}



void dirty_list::add(dirty_list *other)
{
    for (int c=0; c<other->count; c++)
	add(other->data[c].x, other->data[c].y, other->data[c].w, other->data[c].h);
}



void dirty_list::copy(dirty_list *other)
{
    resize(other->count);

    for (int c=0; c<count; c++) {
	data[c].x = other->data[c].x;
	data[c].y = other->data[c].y;
	data[c].w = other->data[c].w;
	data[c].h = other->data[c].h;
    }
}



void dirty_list::sort()
{
    RECT tmp;

    for (int c=0; c<count; c++) {
	for (int c2=c+1; c2<count; c2++) {
	    if ((data[c].x > -100) &&
		(myabs(data[c].x-data[c2].x) < 32) &&
		(myabs(data[c].y-data[c2].y) < 32)) {

		int x = MIN(data[c].x, data[c2].x);
		int y = MIN(data[c].y, data[c2].y);
		int w = MAX(data[c].x+data[c].w, data[c2].x+data[c2].w) - x;
		int h = MAX(data[c].y+data[c].h, data[c2].y+data[c2].h) - y;
		data[c].x = x;
		data[c].y = y;
		data[c].w = w;
		data[c].h = h;
		data[c2].x = data[c2].y = -256;
		data[c2].w = data[c2].h = 0;
	    }
	    else {
		if (data[c].y > data[c2].y) {
		    tmp = data[c];
		    data[c] = data[c2];
		    data[c2] = tmp;
		}
	    }
	}
    }
}



void dirty_list::do_clear(BITMAP *b)
{
    for (int c=0; c<count; c++) {
	if ((data[c].w == 1) && (data[c].h == 1))
	    putpixel(b, data[c].x, data[c].y, 0);
	else if ((data[c].w > 0) || (data[c].h > 0))
	    rectfill(b, data[c].x, data[c].y, data[c].x+data[c].w, 
					      data[c].y+data[c].h, 0);
    }
}



void dirty_list::do_blit(BITMAP *src, BITMAP *dest)
{
    for (int c=0; c<count; c++) {
	if ((data[c].w == 1) && (data[c].h == 1))
	    putpixel(dest, data[c].x, data[c].y, getpixel(src, data[c].x, data[c].y));
	else if ((data[c].w > 0) || (data[c].h > 0))
	    blit(src, dest, data[c].x, data[c].y, 
			    data[c].x, data[c].y, data[c].w, data[c].h);
    }
}



void game_control(void)
{
    if (!paused) {
	move_count++;
	time_count++;
    }
}



void move_everyone(int x)
{
    static int count = 0;

    if (ship->get_damage() < 100) {
	if (count & 1)
	    bullets->collision_check(ship);
	else {
	    treasures->collision_check(ship);
	    if (count & 2)
		aliens->check_ship_collision(ship);
	    else
		planets->collision_check(ship);
	}
	count++;
	ship->item::move(x);
    }

    aliens->move(x);
    bullets->move(x);
    explosions->move(x);
    treasures->move(x);
    radar_flag++;
}



void draw_screen()
{
    if (ship->draw_stat_flag) {
	ship->draw_stat_flag = FALSE;
	draw_stats();
	blit(s2, screen, SCREEN_W-80, 75, SCREEN_W-80, 75, 80, SCREEN_H-75);
    }

    set_clip(s2, 0, 0, SCREEN_W-81, SCREEN_H-1);

    dirty.do_clear(s2);
    dirty.empty();

    ship->draw_stars(s2);

    planets->draw(s2, ship); 
    aliens->draw(s2, ship); 
    explosions->draw(s2, ship);
    if (ship->get_damage() < 100)
	ship->draw(s2, (SCREEN_W-80)/2, SCREEN_H/2);
    bullets->draw(s2, ship); 
    treasures->draw(s2, ship); 

    if (hide) {
	circlefill(s2, (SCREEN_W-80)/2, SCREEN_H/2, 10, 0);
    }
    if (have_cheated) {
	text_mode(-1);
	textout(s2, (FONT *)dat[MYFONT].dat, "cheat!", 0, 0, 32);
	dirty.add(0, 0, 48, 8);
    }
    if (msg_str) {
	text_mode(-1);
	int x = strlen(msg_str)*8;
	textout(s2, (FONT *)dat[MYFONT].dat, msg_str, (SCREEN_W-80-x)/2, 12, 60);
	dirty.add((SCREEN_W-80-x)/2, 12, x, 8);
    }

    set_clip(s2, 0, 0, SCREEN_W-1, SCREEN_H-1);
}



void draw_stats()
{
    char buf[80];

    blit((BITMAP *)dat[STATS_BMP].dat, s2, 0, 75, SCREEN_W-80, 75, 80, SCREEN_H-75);

    text_mode(-1);

    sprintf(buf, "$%d", ship->state.money);
    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 81, 234);

    sprintf(buf, "carg:%d%%", ship->state.cargo);
    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 92, 234);

    sprintf(buf, "damg:%d%%", ship->get_damage());
    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 103, 234);

    sprintf(buf, "shld:%d", ship->state.shields);
    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 114, 234);

    textout(s2, (FONT *)dat[MYFONT].dat, "1:laser", SCREEN_W-74, 125, 234);
    textout(s2, (FONT *)dat[MYFONT].dat, "2:ptn.gun", SCREEN_W-74, 136, ship->state.proton_gun ? 234 : 240);
    textout(s2, (FONT *)dat[MYFONT].dat, "3:cannon", SCREEN_W-74, 147, ship->state.matter_cannon ? 234 : 240);
    textout(s2, (FONT *)dat[MYFONT].dat, "4:missile", SCREEN_W-74, 158, ship->state.missiles ? 234 : 240);
    textout(s2, (FONT *)dat[MYFONT].dat, "5:torpedo", SCREEN_W-74, 169, ship->state.torpedoes ? 234 : 240);
    textout(s2, (FONT *)dat[MYFONT].dat, "6:mine", SCREEN_W-74, 180, ship->state.mines ? 234 : 240);

    circlefill(s2, SCREEN_W-63, 128+ship->get_wpn()*11, 2, 234);
    circlefill(s2, SCREEN_W-63, 129+ship->get_wpn()*11, 2, 234);

    switch (ship->get_wpn()) {

	case WEAPON_MISSILE:
	    sprintf(buf, "ammo:%d", ship->state.missiles);
	    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 191, 234);
	    break;

	case WEAPON_TORPEDO:
	    sprintf(buf, "ammo:%d", ship->state.torpedoes);
	    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 191, 234);
	    break;

	case WEAPON_MINE:
	    sprintf(buf, "ammo:%d", ship->state.mines);
	    textout(s2, (FONT *)dat[MYFONT].dat, buf, SCREEN_W-74, 191, 234);
	    break;
    }
}



void draw_radar()
{
    static int scan = 1;

    rectfill(s2, SCREEN_W-72, 8, SCREEN_W-9, 71, 0);

    circle(s2, SCREEN_W-40, 40, scan*2, 233);
    if (++scan >= 16)
	scan = 1;

    planets->draw_radar(s2, ship);
    aliens->draw_radar(s2, ship);
    hline(s2, SCREEN_W-41, 40, SCREEN_W-39, ship->get_radar_color());
    vline(s2, SCREEN_W-40, 39, 41, ship->get_radar_color());
}



void fade_in_bitmap(BITMAP *b)
{
    set_clip(screen, 0, 0, SCREEN_W, SCREEN_H);
    blit(b, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}



void fade_from_white(PALLETE p)
{
    PALLETE temp;
    int i;
    int done = FALSE;

    get_pallete(temp);

    while (!done) {
	done = TRUE;
	for (i=0; i < PAL_SIZE; i++) { 
	    if (temp[i].r > p[i].r) {
		temp[i].r--;
		done = FALSE;
	    }
	    if (temp[i].g > p[i].g) {
		temp[i].g--;
		done = FALSE;
	    }
	    if (temp[i].b > p[i].b) {
		temp[i].b--;
		done = FALSE;
	    }
	}
	set_pallete(temp);
    }
}



void draw_number(BITMAP *b, int x, int y, char init, int number, char end)
{
    char buf[10];
    char *p = buf;

    if (init)
	*(p++) = init;

    sprintf(p, "%d", number);

    while (*p)
	p++;

    if (end) {
	*(p++) = end;
	*p = 0;
    }

    textout(b, (FONT *)dat[BIG_FONT].dat, buf, x, y, 160);
}



void draw_shipyard(BITMAP *b, int sel, int cp, char *m)
{
    int xo = (SCREEN_W-320)/2;
    int yo = (SCREEN_H-200)/2;

    text_mode(-1);
    blit((BITMAP *)dat[SHIPYARD].dat, b, 0, 0, xo, yo, 320, 200);

    draw_number(b, xo+108, yo+57, '$', ship->state.money, 0);
    draw_number(b, xo+248, yo+57, 0, ship->state.cargo, '%');
    draw_number(b, xo+108, yo+81, 0, ship->get_damage(), '%');
    draw_number(b, xo+248, yo+81, 0, ship->state.shields, 0);
    draw_number(b, xo+108, yo+105, 0, ship->state.missiles, 0);
    draw_number(b, xo+248, yo+105, 0, ship->state.torpedoes, 0);
    draw_number(b, xo+108, yo+129, 0, ship->state.mines, 0);
    textout(b, (FONT *)dat[BIG_FONT].dat, (ship->state.proton_gun ? "Yes" : "No"), xo+248, yo+129, 160);
    textout(b, (FONT *)dat[BIG_FONT].dat, (ship->state.matter_cannon ? "Yes" : "No"), xo+108, yo+153, 160);
    textout(b, (FONT *)dat[BIG_FONT].dat, (ship->state.afterburner ? "Yes" : "No"), xo+248, yo+153, 160);

    hline(b, (sel&1) ? xo+245 : xo+105, yo+73+(sel>>1)*24, (sel&1) ? xo+275 : xo+135, 70);
    hline(b, (sel&1) ? xo+246 : xo+106, yo+74+(sel>>1)*24, (sel&1) ? xo+274 : xo+134, 70);

    char msg[80];

    if (m)
	strcpy(msg, m);

    else { 
	switch(sel) {

	    case 0:         // money
		msg[0] = 0;
		break;

	    case 1:         // cargo
		sprintf(msg, "Cargo is $%d per 10%%: b=buy, s=sell", cp);
		break;

	    case 2:         // damage
		if (ship->get_damage())
		    sprintf(msg, "Repairs cost $%d per 10%%: b=buy", REPAIR_PRICE);
		else
		    strcpy(msg, "No damage to repair");
		break;

	    case 3:         // shields
		sprintf(msg, "Shields cost $%d each: b=buy", SHIELD_PRICE);
		break;

	    case 4:         // missiles
		sprintf(msg, "Missiles cost $%d each: b=buy", MISSILE_PRICE);
		break;

	    case 5:         // torpedoes
		sprintf(msg, "Torpedoes cost $%d each: b=buy", TORPEDO_PRICE);
		break;

	    case 6:         // mines
		sprintf(msg, "Mines cost $%d each: b=buy", MINE_PRICE);
		break;

	    case 7:         // proton gun
		sprintf(msg, "Proton gun costs $%d: b=buy", PROTON_GUN_PRICE);
		break;

	    case 8:         // matter cannon
		sprintf(msg, "Matter cannon costs $%d: b=buy", MATTER_CANNON_PRICE);
		break;

	    case 9:         // afterburner 
		sprintf(msg, "Afterburner costs $%d: b=buy", AFTERBURNER_PRICE);
		break;
	}
    }

    text_mode(-1);
    textout(b, font, msg, xo+160-strlen(msg)*4, yo+192, 70);
}



void do_shipyard(int cargo_price)
{
    int sel = 0;
    int k;
    char *m = NULL;
    static char poor_str[] = "You can't afford that";
    int joy_on = TRUE;

    set_clip(s2, 0, 0, SCREEN_W, SCREEN_H);
    blit((BITMAP *)dat[BACKGROUND_BMP].dat, s2, 0, 0, 0, 0, 640, 480);
    draw_shipyard(s2, sel, cargo_price, NULL);
    fade_in_bitmap(s2);
    do {
    } while ((key[KEY_SPACE]) || (key[KEY_ENTER]));
    clear_keybuf();

    for(;;) {
	if (keypressed())
	    k = readkey();
	else
	    k = 0;

	if (joy_on)
	    rest(20);

	poll_joystick();

	if (joy_on) {
	    if ((!joy_left) && (!joy_right) && (!joy_up) && (!joy_down) &&
		(!joy_b1) && (!joy_b2)) {
	       joy_on = FALSE;
	       rest(20);
	    }
	}
	else {
	    if (joy_left) {
		k = KEY_LEFT << 8;
		joy_on = TRUE;
	    }
	    else if (joy_right) {
		k = KEY_RIGHT << 8;
		joy_on = TRUE;
	    }
	    else if (joy_up) {
		k = KEY_UP << 8;
		joy_on = TRUE;
	    }
	    else if (joy_down) {
		k = KEY_DOWN << 8;
		joy_on = TRUE;
	    }
	    else if (joy_b1) {
		k = KEY_B << 8;
		joy_on = TRUE;
	    }
	    else if (joy_b2) {
		k = KEY_ESC << 8;
		joy_on = TRUE;
	    }
	}

	if (k) {
	    switch (k >> 8) {

		case KEY_LEFT:
		    if (sel > 0) 
			sel--;
		    break;

		case KEY_RIGHT:
		    if (sel < 9)
			sel++;
		    break;

		case KEY_UP:
		    sel-=2;
		    if (sel<0)
			sel=0;
		    break;

		case KEY_DOWN:
		    sel+=2;
		    if (sel>9)
			sel=9;
		    break;

		case KEY_ESC:
		case KEY_SPACE:
		case KEY_ENTER:
		    return;

		case KEY_S:
		    if (sel==1) {
			if (ship->state.cargo) {
			    ship->state.money += cargo_price;
			    ship->state.cargo -= 10;
			    if (ship->state.cargo < 0)
				ship->state.cargo = 0;
			}
			else
			    m = "You don't have any cargo to sell";
		    }
		    else
			m = "Can't sell that"; 
		    break;

		case KEY_B:
		    switch(sel) {

			case 0:         // money
			    m = "You can't buy money, stupid!";
			    break;

			case 1:         // cargo
			    if (ship->state.money < cargo_price)
				m = poor_str;
			    else {
				if (ship->state.cargo >= 100)
				    m = "Your cargo hold is full";
				else {
				    ship->state.money -= cargo_price;
				    ship->state.cargo += 10;
				    if (ship->state.cargo > 100)
					ship->state.cargo = 100;
				}
			    }
			    break;

			case 2:         // damage
			    if (ship->get_damage())
				if (ship->state.money < REPAIR_PRICE)
				    m = poor_str;
				else {
				    ship->set_damage(ship->get_damage() - 10);
				    if (ship->get_damage() < 0)
					ship->set_damage(0);
				    ship->state.money -= REPAIR_PRICE;
				}
			    break;

			case 3:         // shields
			    if (ship->state.money < SHIELD_PRICE)
				m = poor_str;
			    else {
				ship->state.shields++;
				ship->state.money -= SHIELD_PRICE;
			    }
			    break;

			case 4:         // missiles
			    if (ship->state.money < MISSILE_PRICE)
				m = poor_str;
			    else {
				ship->state.missiles++;
				ship->state.money -= MISSILE_PRICE;
			    }
			    break;

			case 5:         // torpedoes
			    if (ship->state.money < TORPEDO_PRICE)
				m = poor_str;
			    else {
				ship->state.torpedoes++;
				ship->state.money -= TORPEDO_PRICE;
			    }
			    break;

			case 6:         // mines
			    if (ship->state.money < MINE_PRICE)
				m = poor_str;
			    else {
				ship->state.mines++;
				ship->state.money -= MINE_PRICE;
			    }
			    break;

			case 7:         // proton gun
			    if (!ship->state.proton_gun) {
				if (ship->state.money < PROTON_GUN_PRICE)
				    m = poor_str;
				else {
				    ship->state.proton_gun = TRUE;
				    ship->state.money -= PROTON_GUN_PRICE;
				}
			    }
			    else
				m = "You already have a proton gun";
			    break;

			case 8:         // matter cannon
			    if (!ship->state.matter_cannon) {
				if (ship->state.money < MATTER_CANNON_PRICE)
				    m = poor_str;
				else {
				    ship->state.matter_cannon = TRUE;
				    ship->state.money -= MATTER_CANNON_PRICE;
				}
			    }
			    else
				m = "You already have a matter cannon";
			    break;

			case 9:         // afterburner 
			    if (!ship->state.afterburner) {
				if (ship->state.money < AFTERBURNER_PRICE)
				    m = poor_str;
				else {
				    ship->state.afterburner = TRUE;
				    ship->state.money -= AFTERBURNER_PRICE;
				}
			    }
			    else
				m = "You already have an afterburner";
			    break;
		    }
		    break;
	    } 

	    draw_shipyard(s2, sel, cargo_price, m);
	    blit(s2, screen, (SCREEN_W-320)/2, (SCREEN_H-200)/2, 
			     (SCREEN_W-320)/2, (SCREEN_H-200)/2, 320, 200);
	    m = NULL;
	}
    }
}



void di_callback()
{
    putchar('.');
    fflush(stdout);
}



void data_init()
{
    printf("Rotating bitmaps"); fflush(stdout);
    still = new multidir((BITMAP *)dat[SHIP_STILL].dat, 32, di_callback);
    go = new multidir((BITMAP *)dat[SHIP_GO].dat, 32, di_callback);
    burn = new multidir((BITMAP *)dat[SHIP_BURN].dat, 32, di_callback);
    bullet1 = new multidir((BITMAP *)dat[BULLET1].dat, 32, di_callback);
    bullet2 = new multidir((BITMAP *)dat[BULLET2].dat, 32, di_callback);
    bullet3 = new multidir((BITMAP *)dat[BULLET3].dat, 32, di_callback);
    bullet4 = new multidir((BITMAP *)dat[BULLET4].dat, 32, di_callback);
    bullet5 = new multidir((BITMAP *)dat[BULLET5].dat, 32, di_callback);
    bullet6 = new multidir((BITMAP *)dat[BULLET6].dat, 32, di_callback);
    bound1 = calculate_bound(bullet1->sprite(0));
    bound2 = calculate_bound(bullet2->sprite(0));
    bound3 = calculate_bound(bullet3->sprite(0));
    bound4 = calculate_bound(bullet4->sprite(0));
    bound5 = calculate_bound(bullet5->sprite(0));
    bound6 = calculate_bound(bullet6->sprite(0));
    treasure_sprite = new multidir((BITMAP *)dat[TREASURE].dat, 32, di_callback);
    treasure_bound = calculate_bound(treasure_sprite->sprite(0));
    printf("\nDrawing enemies"); fflush(stdout);
    for (int c=0; c<ALIEN_COUNT; c++)
	alien_pics[c] = draw_alien(alien_col+c, di_callback);
    printf("\nDrawing explosions"); fflush(stdout);
    explode = new exploder(64, 80, di_callback);
    printf("\n");
}



void data_cleanup()
{
    delete go;
    go = NULL;
    delete burn;
    burn = NULL;
    delete still;
    still = NULL;
    delete explode;
    explode = NULL;
    delete bullet1;
    bullet1 = NULL;
    delete bullet2;
    bullet2 = NULL;
    delete bullet3;
    bullet3 = NULL;
    delete bullet4;
    bullet4 = NULL;
    delete bullet5;
    bullet5 = NULL;
    delete bullet6;
    bullet6 = NULL;
    delete treasure_sprite;
    treasure_sprite = NULL;
    for (int c=0; c<ALIEN_COUNT; c++)
	delete alien_pics[c];
}



PALLETE die_pal;
int dying;


void play_game()
{
    int c;

    genes = new genepool;
    if (!genes->load_genes()) {
	delete genes;
	genes = NULL;
	clear(screen);
	return;
    }
    aliens = new alienmgr;
    planets = new spritemgr;
    bullets = new spritemgr;
    explosions = new spritemgr;
    treasures = new spritemgr;
    ship = new playership(&default_ship_state, go, burn, still);

    hide = cheat = have_cheated = FALSE;
    int hide_pos = 0;
    int rich_pos = 0;
    int cheat_pos = 0;

    dying = FALSE;
    get_pallete(die_pal);

    msg_str = NULL;

    for (c=0; c<32; c++)
	planets->add(new planet, ship);

    while (aliens->get_count()<ALIEN_COUNT)
	aliens->add(new alien(genes), ship);

    play_midi((MIDI *)dat[GAME_MID].dat, TRUE);
    for (c=0; c<16; c++)    // kill off any active samples
	play_sample((SAMPLE *)dat[L1_WAV].dat, 0, 0, 10000, FALSE);

    dirty.reset();
    old_dirty.reset();

    draw_screen();
    blit((BITMAP *)dat[STATS_BMP].dat, s2, 0, 0, SCREEN_W-80, 0, 80, 75);
    draw_stats();
    draw_radar();
    fade_in_bitmap(s2);

    time_count = frame_count = 0;

    paused = dead = FALSE;
    move_count = 0;
    install_int_ex(game_control, BPS_TO_TIMER(50));

    while (!ship->esc && (!dead)) {

	poll_joystick();

	if (move_count) {
	    int store = move_count;
	    move_count = 0;
	    if (store > 32) {
		clear(screen);
		text_mode(0);
		textout(screen, font, "Look mate, I'm sorry but this just", 16, 20, 255);
		textout(screen, font, "isn't working. I'm doing my best,", 16, 30, 255);
		textout(screen, font, "but your computer is too slow.", 16, 40, 255);
		textout(screen, font, "Sorry and all that.", 16, 50, 255);
		do {
		} while ((key[KEY_SPACE]) || (key[KEY_ENTER]));
		do {
		} while (!(key[KEY_SPACE]) && (!key[KEY_ENTER]));
		clear_keybuf();
		goto get_out; 
	    }
	    if (dying) {
		static int flipflop = 0;
		if (!flipflop) {
		    play_sample((SAMPLE *)dat[EXPLODE_WAV].dat, 255, 128, 1000, FALSE);
		    flipflop = 2;
		}
		else
		    flipflop--;

		for (int c2=store; c2 > 0; c2--) {
		    for (c=0; c<PAL_SIZE; c++) {
			if (die_pal[c].r < 62) {
			    die_pal[c].r+=2;
			    if (die_pal[c].r & 2) {
				if (die_pal[c].g < 63)
				    die_pal[c].g++;
			    }
			    else {
				if (die_pal[c].b < 63)
				    die_pal[c].b++;
			    }
			}
			else {
			    if (die_pal[c].g < 63)
				die_pal[c].g++;
			    if (die_pal[c].b < 63)
				die_pal[c].b++;
			}
		    }
		}
		set_pallete(die_pal);
	    }
	    move_everyone(store);
	}

	if (aliens->get_count()<ALIEN_COUNT)
	    aliens->add(new alien(genes), ship);

	acquire_screen();

	frame_count++;
	draw_screen();

	old_dirty.add(&dirty);
	old_dirty.sort();

	set_clip(screen, 0, 0, SCREEN_W-81, SCREEN_H-1);
	old_dirty.do_blit(s2, screen);
	set_clip(screen, 0, 0, SCREEN_W-1, SCREEN_H-1);

	old_dirty.copy(&dirty);

	msg_str = NULL;

	if (radar_flag>8) {
	    draw_radar();
	    blit(s2, screen, SCREEN_W-72, 8, SCREEN_W-72, 8, 64, 64);
	    radar_flag=0;
	}

	release_screen();

	if (keypressed()) {

	    int c = readkey()&0xff;

	    if (hide_str[hide_pos]==c) {
		hide_pos++;
		if (hide_str[hide_pos]==0) {
		    hide_pos = 0;
		    hide = !hide;
		    have_cheated = TRUE;
		}
	    }
	    else
		hide_pos = 0;

	    if (rich_str[rich_pos]==c) {
		rich_pos++;
		if (rich_str[rich_pos]==0) {
		    rich_pos = 0;
		    ship->state.money = 100000;
		    ship->draw_stat_flag = TRUE;
		    have_cheated = TRUE;
		}
	    }
	    else
		rich_pos = 0;

	    if (cheat_str[cheat_pos]==c) {
		cheat_pos++;
		if (cheat_str[cheat_pos]==0) {
		    cheat_pos = 0;
		    cheat = !cheat;
		    have_cheated = TRUE;
		}
	    }
	    else
		cheat_pos = 0;
	}

	if (key[KEY_P]) {
	    paused = TRUE;
	    draw_screen();
	    blit(s2, screen, 0, 0, 0, 0, SCREEN_W-80, SCREEN_H);
	    text_mode(-1);
	    textout_centre(screen, (FONT *)dat[MYFONT].dat, "Game Paused", (SCREEN_W-80)/2, 12, 64);
	    do {
	    } while (key[KEY_P]); 
	    do {
	    } while (!key[KEY_SPACE] && !key[KEY_P]);
	    dirty.reset();
	    old_dirty.reset();
	    draw_screen();
	    blit(s2, screen, 0, 0, 0, 0, SCREEN_W-80, SCREEN_H);
	    do {
	    } while (key[KEY_SPACE] || key[KEY_P]);
	    paused = FALSE;
	}

	if ((key[KEY_ENTER]) || (joy_b2)) {
	    planet *i = (planet *)planets->find_within(ship->getx(),
						ship->gety(), 0x1f00000);
	    if (i) {
		if (i->price()) {
		    paused = TRUE;
		    do_shipyard(i->price());
		    dirty.reset();
		    old_dirty.reset();
		    draw_screen();
		    blit((BITMAP *)dat[STATS_BMP].dat, s2, 0, 0, SCREEN_W-80, 0, 80, 75);
		    draw_stats();
		    draw_radar();
		    fade_in_bitmap(s2);
		    do {
			poll_joystick();
		    } while ((key[KEY_SPACE]) || (key[KEY_ENTER]) || 
			     (key[KEY_ESC]) || (joy_b1) || (joy_b2));
		    paused = FALSE;
		}
		else
		    msg_str = "No shipyards here";
	    }
	    else
		msg_str = "No planet within range";
	}
    }

    get_out: 

    remove_int(game_control);

    if (dead) {
	set_clip(s2, 0, 0, SCREEN_W, SCREEN_H);
	clear(s2);
	for (c=0; c<48; c++)
	    putpixel(s2, rand()%SCREEN_W, rand()%SCREEN_H, 135 + rand()%32);

	blit(s2, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	draw_sprite(screen, (BITMAP *)dat[END_GAME].dat, 
		   SCREEN_W/2-((BITMAP *)dat[END_GAME].dat)->w / 2, SCREEN_H/6);

	textout(screen, (FONT *)dat[BIG_FONT].dat, "Kills:", SCREEN_W/3, SCREEN_H/2+32, 160);
	draw_number(screen, SCREEN_W/3+64, SCREEN_H/2+32, 0, ship->kill_count, 0);

	textout(screen, (FONT *)dat[BIG_FONT].dat, "Money:", SCREEN_W/3, SCREEN_H/2+64, 160);
	draw_number(screen, SCREEN_W/3+64, SCREEN_H/2+64, '$', ship->state.money, 0);

	fade_from_white((RGB *)dat[PAL].dat);

	if (profile) {
	    char buf[80];
	    time_count /= 50;
	    if (time_count <= 0)
		time_count = 1;
	    sprintf(buf, "%d fps", frame_count / time_count);
	    alert("Profile information:", buf, NULL, "Huh", NULL, 13, 0);
	}

	do {
	    poll_joystick();
	} while ((joy_b1) || (joy_b2));

	rest(20);

	do {
	    poll_joystick();
	} while ((!key[KEY_ENTER]) && (!key[KEY_SPACE]) && (!key[KEY_ESC]) &&
		 (!joy_b1) && (!joy_b2));
    }
    else
	remove_screen();

    delete genes;
    genes = NULL;
    delete aliens;
    aliens = NULL;
    delete planets;
    planets = NULL;
    delete bullets;
    bullets = NULL;
    delete explosions;
    explosions = NULL;
    delete treasures;
    treasures = NULL;
    delete ship;
    ship = NULL;
}

