//
//    MARAUDER
//
//    fire.cpp: burner object and animation routines
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <allegro.h>
#include "fire.h"


extern DATAFILE *dat;



static inline int myabs(int x) 
{
    return (x<0) ? -x : x;
}



burner::burner(BITMAP *b, int w, int h)
{
    int i;

    dest = b;
    hs_count = 2;
    hs_delay = 0;

    width = w;
    height = h;

    bmp = create_bitmap(width,height);
    if (bmp)
	clear(bmp);

    for (i=0; i<FIRE_HOTSPOTS; i++)
	hotspot[i] = rand() % width;
}



burner::~burner()
{
    if (bmp)
	destroy_bitmap(bmp);
}



static void move_fire(BITMAP *bmp, int height, int width)
{
   #ifdef ALLEGRO_GCC

    asm (
	"   movl $1, %%edx ; "                      /* y = 1 */

	"   .align 4, 0x90 ; "
	" fire_y_loop: "
	"   cmpl %%edx, %1 ; "                      /* compare y with height */
	"   jl fire_done ; "

	"   movl 64(%0, %%edx, 4), %%edi ; "        /* edi = bmp->line[y] */
	"   movl 68(%0, %%edx, 4), %%esi ; "        /* esi = bmp->line[y+1] */
	"   movl %2, %%ecx ; "                      /* x loop counter */

	"   .align 4, 0x90 ; "
	" fire_x_loop: "
	"   movb (%%esi), %%al ; "
	"   testb %%al, %%al ; "
	"   jz fire_val_ok ; "
	"   subb $2, %%al ; "
	" fire_val_ok: "
	"   movb %%al, (%%edi) ; "
	"   incl %%esi ; "
	"   incl %%edi ; "
	"   loop fire_x_loop ; "                    /* another x? */

	"   incl %%edx ; "
	"   jmp fire_y_loop ; "                     /* another y? */

	"   .align 4, 0x90 ; "
	" fire_done: "

    :                                               /* no outputs */
    : "b" (bmp), "m" (height-2), "m" (width)        /* inputs */
    : "eax", "ecx", "edx", "esi", "edi" );          /* clobbered registers */

   #else

      unsigned char *s, *d;
      int y, x, c;

      for (y=2; y<height; y++) {
	 s = bmp->line[y];
	 d = bmp->line[y-1];

	 for (x=0; x<width; x++) {
	    c = *(s++);
	    if (c)
	       c -= 2;
	    *(d++) = c;
	 }
      }

   #endif
}



void burner::animate()
{
    unsigned char *d;
    int x, x2;
    int c;

    if (bmp) {
	move_fire(bmp, height, width);

	d = bmp->line[height-1];                    // clear bottom line
	for (x=0; x<width; x++)
	    *(d++) = 0;

	d = bmp->line[height-1];

	for (x=0; x<hs_count; x++) {                // show hotspots
	    for (x2=hotspot[x]-24; x2<hotspot[x]+24; x2++) {
		if ((x2 >= 0) && (x2 < width)) {
		    c = d[x2];
		    c += myabs(hotspot[x]-x2) * 2;
		    d[x2] = MIN(c, 255) & 0xFE;
		}
	    }
	    hotspot[x] += (rand() & 7) - 3;       // move hotspots
	    if (hotspot[x] < 0)
		hotspot[x] += width;
	    else
		if (hotspot[x] >= width)
		    hotspot[x] -= width;
	}

	blit(bmp, dest, 0, 0, 0, SCREEN_H-height, width, height);
    }

    if (hs_count < MIN(dest->w/16, FIRE_HOTSPOTS)) {
	if (--hs_delay < 0) {
	    hs_count++;
	    hs_delay = 8;
	}
    }
}

