//
//    MARAUDER
//
//    bullet.cpp: for shooting people
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <allegro.h>
#include "marauder.h"
#include "sprite.h"
#include "bullet.h"
#include "mgr.h"


extern DATAFILE *dat;

extern multidir *bullet1, *bullet2, *bullet3, *bullet4, *bullet5, *bullet6;
extern int bound1, bound2, bound3, bound4, bound5, bound6;



bullet::bullet(item *p, multidir *m, int d)
{
    parent=p;
    itemtype=ITEM_BULLET;
    life=48;
    mdir = m;
    dir = d;
    current_sprite = m->sprite(d);
    set_dim();
}



laser::laser(int dir, int x, int y, item *p) : bullet(p, bullet1, dir)
{
    harm = 8;
    dir = (dir+4)&0xf8;
    bound = bound1;
    xc = x + fsin(itofix(dir)) * 64;
    yc = y + -fcos(itofix(dir)) * 64;
    is_missile = FALSE;
}



proton_gun::proton_gun(int dir, int x, int y, item *p) : bullet(p, bullet2, dir)
{
    harm = 8;
    dir = (dir+4)&0xf8;
    bound = bound2;
    xc = x + fsin(itofix(dir)) * 64;
    yc = y + -fcos(itofix(dir)) * 64;
    is_missile = FALSE;
}



matter_cannon::matter_cannon(int dir, int x, int y, item *p) : bullet(p, bullet3, dir)
{
    harm = 35;
    dir = (dir+4)&0xf8;
    bound = bound3;
    xc = x + fsin(itofix(dir)) * 64;
    yc = y + -fcos(itofix(dir)) * 64;
    is_missile = FALSE;
}



missile::missile(int dir, int x, int y, item *p) : bullet(p, bullet4, dir)
{
    x = x;
    y = y;

    harm = 100;
    dir = (dir+4)&0xf8;
    bound = bound4;
    xc = 0;
    yc = 0;
    life *= 2;
    is_missile = TRUE;
    dev = (rand()&1) ? 1 : -1;
    dev_speed = 8 + rand()&7;
    dev_count = 0;
}



int missile::move() 
{ 
    x+=xc; 
    y+=yc; 
    xc+=fsin(itofix(dir)) * 2;
    yc+=-fcos(itofix(dir)) * 2;
    if (++dev_count >= dev_speed) {
	dir+=dev;
	dev_count = 0;
    }
    current_sprite = mdir->sprite(dir);
    return (--life>0) ? 0 : -1; 
}



torpedo::torpedo(int dir, int x, int y, item *p) : bullet(p, bullet5, dir)
{
    x = x;
    y = y;

    harm = 100;
    dir = (dir+4)&0xf8;
    bound = bound5;
    xc = 0;
    yc = 0;
    xcadd = fsin(itofix(dir)) * 6;
    ycadd = -fcos(itofix(dir)) * 6;
    is_missile = TRUE;
}



int torpedo::move()
{ 
    x+=xc; 
    y+=yc; 
    xc+=xcadd; 
    yc+=ycadd; 
    return (--life>0) ? 0 : -1; 
}



mine::mine(int dir, int x, int y) : bullet(NULL, bullet6, dir)
{
    x = x;
    y = y;

    harm = 100;
    dir = xc = yc = 0;
    bound = bound6;
    is_missile = TRUE;
}



