//-----------------------------------------------------------------------------
// MEKA - keysname.h
// Keyboard Keys Names - Headers
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Data
//-----------------------------------------------------------------------------

#define KEY_INFO_PRINTABLE    (0x01)
#define KEY_INFO_ALLOW_USE    (0x02)

typedef struct
{
    int     scancode;
    char *  name;
    char    printable_char;
    int     flags;
} t_key_info;

extern   t_key_info     KeyInfo_Table [];

//-----------------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------------

t_key_info *    KeyInfo_FindByScancode(int scancode);
t_key_info *    KeyInfo_FindByName(char *name);

//-----------------------------------------------------------------------------

