' вспомогательная функция для процедуры CursorInLeft для перехода на предыдущую строку
sub CursorLeftOnPrevLine(iCurMinusPrev as Long)
	
	' индекс для предыдущей строки
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
	
	' получим длину предыдущей строки
	dim as Long iLen = pObj.pList.GetValueLenIndex(iIndex)
	
	dim as wstring ptr pWstr = pObj.pList.GetValueIndex(iIndex)
	
	' получаем длину предыдущей строки с учетом табуляции и других знаков
	dim as Long iLenTab = GetLenStringWithTab(pWstr , iTabSpace)
	
	' текущую позицию в строке ставим на самый конец предыдущей строки
	pObj.iCurentPosInRow = iLen+2
	
	' курсор на самый конец строки на экране
	pObj.iCurentCursorPosInWindow = iLenTab + pObj.iLenghtNumbers+2
	
	if pObj.iCurentCursorPosInWindow > pObj.iWidthSimbols then ' если курсор за пределами экрана
		
		dim as Long iPos = 1 ' первая позиция в строке буфера
		
		pObj.iScrollWidth = 1 ' прокрутку на начало
		
		while pObj.iCurentCursorPosInWindow > pObj.iWidthSimbols ' пока курсор не окажется в области видимости экрана
			
			' получить текущую позицию с учетом табуляций
			dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pWStr , iPos)
			
			' получить предыдущую позицию с учетом табуляций
			dim as Long iNextPos = GetTabStopPositionFromRealPosition(pWStr , iPos+1)
			
			iCurentPos = (iNextPos - iCurentPos) ' получим шаг между позициями
			
			pObj.iScrollWidth += iCurentPos ' увеличим прокрутку
			
			pObj.iCurentCursorPosInWindow -= iCurentPos ' уменьшим позицию курсора
			
			iPos+=1 ' увеличим позицию в строке буфера
			
		Wend
		
	EndIf
	
End Sub

' Перемещение курсора влево
sub CursorInLeft()
	
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2 ' позиция (индекс) в списке для получения и установки значения
	
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex) ' получить строку по индексу
	
	' получить текущую позицию с учетом табуляций
	dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow)
	
	' получить предыдущую позицию с учетом табуляций
	dim as Long iPrevPos = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow-1)
	
	' получим длину шага
	dim as long iCurMinusPrev = (iCurentPos-iPrevPos)
	
	' если курсор может двигаться по текущей строке влево
	if iCurMinusPrev andalso pObj.iCurentCursorPosInWindow-iCurMinusPrev > pObj.iLenghtNumbers+1 then
		
		pObj.iCurentCursorPosInWindow -= iCurMinusPrev ' сдвигаем курсор влево
		
		if pObj.iMarkerSelectionStart = 0 then ' если нет выделения
			
			SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
			
		else
			
			SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовывать только 1 строку
			
			bLeftOrRightMove(0) = 1 ' будем перерисовывать только "пару" символов , флаг ставим , что двжение курсора было влево
			bLeftOrRightMove(1) = iCurMinusPrev ' на сколько знакомест сдвинулся курсор
			
		EndIf
		
		' если стоим на 2 позиции и 1 позиция скрыта скроллингом 	
	elseif iPrevPos = 1 andalso iCurMinusPrev andalso pObj.iScrollWidth > 1 then
		
		pObj.iScrollWidth = 1 ' прокрутку сбрасываем
		
		pObj.iCurentCursorPosInWindow = pObj.iLenghtNumbers+2 ' курсор на начало
		
		pObj.iCurentPosInRow = 1 ' позицию в строке на начало
		
		SetDrawsRowsFlags(-1,0) ' все перерисовать
		
	else ' если курсор в самом начале (сразу после номеров строк)
		
		if pObj.iScrollWidth > 1 then ' если строка была прокручена влево
			
			pObj.iScrollWidth -= iCurMinusPrev ' уменьшаем счетчик прокрутки на экране по ширине
			
			if pObj.iScrollWidth < 1 then 
				
				pObj.iCurentCursorPosInWindow += pObj.iScrollWidth - 1
				
				pObj.iScrollWidth = 1
				
			EndIf
			
			SetDrawsRowsFlags(-1,0) ' все перерисовать
			
		elseif pObj.iCurentPosInRow = 1 then ' строка не была прокручена
			
			if pObj.iCurentCursorRowInWindow > 1 then ' если курсор не на 1 строке экрана
				
				pObj.iCurentCursorRowInWindow -=1 ' позиция курсора на предыдущую строку
				
				dim as Long iPrevScroll = pObj.iScrollWidth ' запомним прокрутку
				
				CursorLeftOnPrevLine(iCurMinusPrev) ' вызовем вспомогательную функцию для установки курсора
				
				' если установлено выделение или был скроллинг текста
				if pObj.iMarkerSelectionStart orelse  iPrevScroll <> pObj.iScrollWidth then
					
					SetDrawsRowsFlags(-1 , 0) ' все перерисовать
					
				else
					
					SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow , pObj.iCurentCursorRowInWindow-1) ' перерисовать 2 строки
					
				EndIf
				
			elseif pObj.iStartRowInWindow > 1 then ' если текст прокручен вниз
				
				pObj.iStartRowInWindow -=1 ' уменьшаем первую видимую строку на экране
				
				SetLenghtNumbers() ' устанавливаем размер номеров строк
				
				CursorLeftOnPrevLine(iCurMinusPrev) ' вызовем вспомогательную функцию для установки курсора
				
				SetDrawsRowsFlags(-1 , 0) ' все перерисовать
				
			else ' на первой позиции
				
				SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
				
				bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
				
			EndIf
			
		EndIf
		
	EndIf
	
	' если после уменьшения позиции в строке , она в пределах буфера , 
	' то уменьшаем позицию
	if pObj.iCurentPosInRow-1 then pObj.iCurentPosInRow -= 1
	
End Sub

' вспомогательная функция для процедуры CursorInRight для перехода на следующую строку
sub CursorRightOnNextLine()
	
	' если есть возможность прокрутить вниз
	if pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1 < pObj.pList.GetSize() then
		
		if pObj.iCurentCursorRowInWindow >= pObj.iHeightRows-1 then ' если курсор на последней строке
			
			pObj.iStartRowInWindow+=1 ' увеличиваем первую видимую строку на экране
			
			SetLenghtNumbers ' устанавливаем размер номеров строк
			
			SetDrawsRowsFlags(-1 , 0) ' все перерисовать
			
		else ' если курсор не на последней строке
			
			pObj.iCurentCursorRowInWindow +=1 ' перемещаем курсор на следующую строку
			
			' если установлено выделение или был скроллинг текста
			if pObj.iMarkerSelectionStart orelse pObj.iScrollWidth > 1 then
				
				SetDrawsRowsFlags(-1 , 0) ' все перерисовать
				
			else
				
				SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-2 , pObj.iCurentCursorRowInWindow-1) ' перерисовать 2 строки
				
			EndIf
			
		EndIf
		
		pObj.iCurentPosInRow = 1 ' позицию в строке на начало
		
		pObj.iCurentCursorPosInWindow = pObj.iLenghtNumbers+2 ' позицию курсора на начало (сразу за номерами строк)
		
		pObj.iScrollWidth = 1 ' прокрутку сбрасываем (строка не прокручена)
		
	else ' если в самом конце текста
		
		SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
End Sub

' Перемещение курсора вправо
sub CursorInRight()
	
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2 ' позиция (индекс) в списке для получения и установки значения
	
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex) ' получить строку по индексу
	
	' получить текущую позицию с учетом табуляций
	dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow)
	
	' получить следующую позицию с учетом табуляций
	dim as Long iNextPos = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow+1)
	
	' получим длину шага
	dim as long iNextMinusCur = (iNextPos-iCurentPos)
	
	' длина текущей строки
	dim as Long iLen = pObj.pList.GetValueLenIndex(pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2)
	
	' если курсор после шага вправо в окне не достиг конца и позиция в строке не достигла конца
	if pObj.iCurentCursorPosInWindow + iNextMinusCur < pObj.iWidthSimbols andalso pObj.iCurentPosInRow <= iLen then
		
		pObj.iCurentCursorPosInWindow += iNextMinusCur ' увеличиваем позицию курсора на экране
		
		if pObj.iMarkerSelectionStart = 0 then ' если нет выделения
			
			SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
			
		else
			
			SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовывать только 1 строку
			
			bLeftOrRightMove(0) = 2 ' будем перерисовывать только "пару" символов , флаг ставим , что двжение курсора было вправо
			bLeftOrRightMove(1) = iNextMinusCur ' на сколько сдвинулся курсор
			
		EndIf
		
		' если курсор после шага вправо за пределами экрана или на последней позиции экрана
	elseif pObj.iCurentCursorPosInWindow + iNextMinusCur >= pObj.iWidthSimbols then 
		
		if pObj.iCurentPosInRow <= iLen then ' если позиция в строке не выйдет за пределы
			
			dim as Long iPrevScroll = pObj.iScrollWidth ' запомним прокрутку
			
			' цикл , пока символ не окажется в видимой части экран
			while pObj.iCurentCursorPosInWindow + iNextMinusCur >= pObj.iWidthSimbols
				
				dim as Long iLeftTotal ' длина шага
				
				dim as Long iTempScroll = pObj.iScrollWidth ' сохраним позицию скроллинга
				
				' цикл пока не получим шаг больше нуля (нужен из-за символов с нулевым знакоместом)
				while 1
					
					' получим первую видимую позицию слева 
					dim as Long iPosAfterScroll = GetStartPosAfterScroll(pWStr , iTempScroll , pObj.pList.GetValueLenIndex(iIndex) )
					
					' получить текущую позицию с учетом табуляций
					dim as Long iLeftDispPos1 = GetTabStopPositionFromRealPosition(pWStr , iPosAfterScroll)
					
					' получить текущую позицию с учетом табуляций и сразу посчитать разность позиций
					iLeftTotal = GetTabStopPositionFromRealPosition(pWStr , iPosAfterScroll+1) - iLeftDispPos1
					
					if iLeftTotal then ' если длина шага ненулевая
						
						exit while ' выходим
						
					else
						
						iTempScroll+=1 ' увеличим временную прокрутку
						
					EndIf
					
				wend
				
				' прокручиваем влево на разность позиций 2-1
				pObj.iScrollWidth += iLeftTotal
				
				' посчитаем новую позицию курсора на экране справа
				pObj.iCurentCursorPosInWindow -= iLeftTotal
				
			wend
			
			' если установлено выделение или был скроллинг текста
			if pObj.iMarkerSelectionStart orelse  iPrevScroll <> pObj.iScrollWidth then
				
				SetDrawsRowsFlags(-1 , 0) ' все перерисовать
				
			else
				
				SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовать 1 строку
				
			EndIf
			
			pObj.iCurentCursorPosInWindow += iNextMinusCur ' увеличиваем позицию курсора на экране
			
		else ' если строка закончилась
			
			CursorRightOnNextLine() ' вызовем вспомогательную функцию для установки курсора на следующую строку
			
			exit sub
			
		EndIf
		
	else
		
		CursorRightOnNextLine() ' вызовем вспомогательную функцию для установки курсора на следующую строку
		
		exit sub
		
	EndIf
	
	' если есть возможность переместить позицию в строке вперед
	if pObj.iCurentPosInRow <= pObj.pList.GetValueLenIndex(pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2) then
		
		pObj.iCurentPosInRow += 1 ' увеличиваем позицию в строке
		
	EndIf
	
End Sub

' Перемещение курсора вверх
sub CursorInUp()
	
	' если возможна прокрутка вверх (то есть текущая строка не является первой)
	if pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow - 1 > 1 then
		
		' если не сохранена или сброшена прошлая позиция в строке
		if pObj.iCursorSafePosForUpDown = 0 then 
			
			' сохраняем текущую позицию для того , 
			' чтобы при перемещении позиция была такая же или ближайшая в предыдущей строке
			pObj.iCursorSafePosForUpDown = pObj.iCurentPosInRow
			
			' сохраняем текущую позицию курсора в окне для того , 
			' чтобы при перемещении курсор попадал на такую же или ближайшую позицию в предыдущей строке на экране			
			pObj.iCursorSafePosInWindowForUpDown = pObj.iCurentCursorPosInWindow
			
			pObj.iBackupLenghtNumbers = pObj.iLenghtNumbers ' сохраним длину номеров строк
			
		EndIf
		
		dim as Long iCurRowInWin ' позиция курсора в окне (по высоте)
		
		dim as Byte bFlagUpdate ' флаг , нужно ли обновлять экран
		
		if pObj.iCurentCursorRowInWindow = 1 then ' если курсор стоит на первой экранной строке
			
			pObj.iStartRowInWindow -=1 ' уменьшаем первую видимую строку на экране
			
			SetLenghtNumbers() ' подсчитаем длину номеров строк
			
			iCurRowInWin = pObj.iCurentCursorRowInWindow ' сохраним позицию курсора в окне (по высоте)
			
			bFlagUpdate = 1
			
		else
			
			iCurRowInWin = pObj.iCurentCursorRowInWindow - 1 ' уменьшим и сохраним позицию курсора в окне (по высоте)
			
		EndIf
		
		' высчитаем приблизительную экранную позицию
		dim as Long iPosInWindow = pObj.iCursorSafePosInWindowForUpDown - (pObj.iBackupLenghtNumbers - pObj.iLenghtNumbers)
		
		dim as Long iPrevScroll = pObj.iScrollWidth ' запомним прокрутку
		
		' устанавливаем позицию на предыдущей строке
		SetPositionWithPosAndRow(pObj.iCursorSafePosForUpDown , iCurRowInWin , pObj.iStartRowInWindow , iPosInWindow)
		
		if bFlagUpdate orelse iPrevScroll <> pObj.iScrollWidth then
			
			SetDrawsRowsFlags(-1 , 0) ' все перерисовать
			
		elseif pObj.iMarkerSelectionStart then
			
			SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow , pObj.iCurentCursorRowInWindow-1) ' перерисовать 2 строки
			
		else
			
			SetDrawsRowsFlags(0 , -1) ' ничего не надо перерисовывать
			
		EndIf
		
	else ' то первая строка в тексте
		
		SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
End Sub

' Перемещение курсора вниз
sub CursorInDown()
	
	' если возможна прокрутка вниз (то есть текущая строка не является последней)
	if pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow < pObj.pList.GetSize()+1 then
		
		' если не сохранена или сброшена прошлая позиция в строке
		if pObj.iCursorSafePosForUpDown = 0 then
			
			' сохраняем текущую позицию для того , 
			' чтобы при перемещении позиция была такая же или ближайшая в следующей строке
			pObj.iCursorSafePosForUpDown = pObj.iCurentPosInRow
			
			' сохраняем текущую позицию курсора в окне для того , 
			' чтобы при перемещении курсор попадал на такую же или ближайшую позицию в следующей строке на экране
			pObj.iCursorSafePosInWindowForUpDown = pObj.iCurentCursorPosInWindow
			
			pObj.iBackupLenghtNumbers = pObj.iLenghtNumbers ' сохраним длину номеров строк
			
		EndIf
		
		dim as Long iCurRowInWin ' позиция курсора в окне (по высоте)
		
		dim as Byte bFlagUpdate ' флаг , нужно ли обновлять экран
		
		if pObj.iCurentCursorRowInWindow+1 = pObj.iHeightRows then ' если курсор стоит на последней экранной строке
			
			pObj.iStartRowInWindow +=1 ' увеличиваем первую видимую строку на экране
			
			SetLenghtNumbers() ' подсчитаем длину номеров строк
			
			iCurRowInWin = pObj.iCurentCursorRowInWindow ' сохраним позицию курсора в окне (по высоте)
			
			bFlagUpdate=1
			
		else
			
			iCurRowInWin = pObj.iCurentCursorRowInWindow + 1 ' уменьшим и сохраним позицию курсора в окне (по высоте)
			
		EndIf
		
		' высчитаем приблизительную экранную позицию
		dim as Long iPosInWindow = pObj.iCursorSafePosInWindowForUpDown + (pObj.iLenghtNumbers - pObj.iBackupLenghtNumbers)
		
		dim as Long iPrevScroll = pObj.iScrollWidth ' запомним прокрутку
		
		' устанавливаем позицию на следующей строке
		SetPositionWithPosAndRow(pObj.iCursorSafePosForUpDown , iCurRowInWin , pObj.iStartRowInWindow , iPosInWindow)
		
		if bFlagUpdate orelse iPrevScroll <> pObj.iScrollWidth then
			
			SetDrawsRowsFlags(-1 , 0) ' все перерисовать
			
		elseif pObj.iMarkerSelectionStart then
			
			SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-2) ' перерисовать 2 строки
			
		else
			
			SetDrawsRowsFlags(0 , -1) ' ничего не надо перерисовывать
			
		EndIf
		
	else ' то последняя строка в тексте
		
		SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
End Sub

' перелистывание страницы вверх
sub CursorPageUp()
	
	' текущая строка
	dim as Long iCurentRow = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1
	
	' высчитываем остаток строк после прокрутки
	dim as Long iRest = iCurentRow - pObj.iHeightRows + 1
	
	' если прокрутка вообще возможна
	if iRest > 0 then
		
		' если не сохранена или сброшена прошлая позиция в строке
		if pObj.iCursorSafePosForUpDown = 0 then
			
			' сохраняем текущую позицию для того , 
			' чтобы при перемещении позиция была такая же или ближайшая в следующей строке
			pObj.iCursorSafePosForUpDown = pObj.iCurentPosInRow
			
			' сохраняем текущую позицию курсора в окне для того , 
			' чтобы при перемещении курсор попадал на такую же или ближайшую позицию в следующей строке на экране
			pObj.iCursorSafePosInWindowForUpDown = pObj.iCurentCursorPosInWindow
			
			pObj.iBackupLenghtNumbers = pObj.iLenghtNumbers ' сохраним длину номеров строк
			
		EndIf
		
		' если величина остатка больше размера строк на экране
		if iRest+2 > pObj.iHeightRows then
			
			' ставим величину , равную размеру строк на экране
			iRest = pObj.iHeightRows-1
			
		EndIf
		
		' уменьшаем начальную строку вывода на величину остатка
		pObj.iStartRowInWindow -=iRest
		
		SetLenghtNumbers() ' подсчитаем длину номеров строк
		
		' высчитаем приблизительную экранную позицию
		dim as Long iPosInWindow = pObj.iCursorSafePosInWindowForUpDown - (pObj.iBackupLenghtNumbers - pObj.iLenghtNumbers)
		
		' устанавливаем позицию в соответствии с прокруткой
		SetPositionWithPosAndRow(pObj.iCursorSafePosForUpDown , pObj.iCurentCursorRowInWindow ,pObj.iStartRowInWindow , iPosInWindow)
		
		SetDrawsRowsFlags(-1 , 0) ' все перерисовать
		
	else
		
		if GetPosition() > 1 then
			
			SetPosition(1) ' переход на начало текста
			
			SetDrawsRowsFlags(-1 , 0) ' все перерисовать
			
		else
			
			SetDrawsRowsFlags(0,-1) ' ничего не надо перерисовывать
			
			bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
			
		EndIf
		
	EndIf
	
End Sub

' перелистывание страницы вниз
sub CursorPageDown()
	
	' текущая строка
	dim as Long iCurentRow = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1
	
	' высчитываем остаток строк после прокрутки
	dim as Long iRest = pObj.pList.GetSize()+2 - (iCurentRow + pObj.iHeightRows)
	
	' если прокрутка вообще возможна
	if iRest > 0 then
		
		' если не сохранена или сброшена прошлая позиция в строке
		if pObj.iCursorSafePosForUpDown = 0 then
			
			' сохраняем текущую позицию для того , 
			' чтобы при перемещении позиция была такая же или ближайшая в следующей строке
			pObj.iCursorSafePosForUpDown = pObj.iCurentPosInRow
			
			' сохраняем текущую позицию курсора в окне для того , 
			' чтобы при перемещении курсор попадал на такую же или ближайшую позицию в следующей строке на экране
			pObj.iCursorSafePosInWindowForUpDown = pObj.iCurentCursorPosInWindow
			
			pObj.iBackupLenghtNumbers = pObj.iLenghtNumbers ' сохраним длину номеров строк
			
		EndIf
		
		' если величина остатка больше размера строк на экране
		if iRest+2 > pObj.iHeightRows then
			
			' ставим величину , равную размеру строк на экране
			iRest = pObj.iHeightRows-1
			
		EndIf
		
		' увеличиваем начальную строку вывода на величину остатка
		pObj.iStartRowInWindow +=iRest
		
		SetLenghtNumbers() ' подсчитаем длину номеров строк
		
		' высчитаем приблизительную экранную позицию
		dim as Long iPosInWindow = pObj.iCursorSafePosInWindowForUpDown + (pObj.iLenghtNumbers - pObj.iBackupLenghtNumbers)
		
		' устанавливаем позицию в соответствии с прокруткой
		SetPositionWithPosAndRow(pObj.iCursorSafePosForUpDown , pObj.iCurentCursorRowInWindow ,pObj.iStartRowInWindow , iPosInWindow)
		
		SetDrawsRowsFlags(-1 , 0) ' все перерисовать
		
	else
		
		dim as Long iLastPos = GetLastPosition()
		
		dim as Long iCurentPos = GetPosition()
		
		if iLastPos <> iCurentPos then
			
			SetPosition(iLastPos) ' переход на конец текста
			
			SetDrawsRowsFlags(-1 , 0) ' все перерисовать
			
		else
			
			SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
			
			bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
			
		EndIf
		
	EndIf
	
End Sub

' Перемещение курсора на следующую строку (нажатие Enter)
sub CursorInNewLine(iKeyFlag as Long = 0)
	
	' получаем индекс для списка (для текущей экранной строки)
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
	
	' получаем указатель на строку из списка 
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex)
	
	' если позиция не в самом конце строки , строка будет разрезана на 2 части  ( 123 ENTER 45678 )
	if pObj.iCurentPosInRow <= pObj.pList.GetValueLenIndex(iIndex) then
		
		if iKeyFlag then ' если была нажата клавиша ENTER
			
			' вставим строку в буфер откатов
			tUd.AddInBuf(chr(10) , E_INS_TEXT , GetPosition())
			
		endif
		
		' вставляем новую строку с остатками символов из текущей строки  (45678)
		pObj.pList.InsertItemIndex(iIndex+1 , mid(*pWStr , pObj.iCurentPosInRow))
		
		' редактируем текущую строку и заносим в нее первую часть (123)
		pObj.pList.SetValueIndex(iIndex , mid(*pWStr , 1 , pObj.iCurentPosInRow-1))
		
	else ' позиция в самом конце строки (12345678 ENTER)
		
		if iKeyFlag then ' если была нажата клавиша ENTER
			
			' вставим строку в буфер откатов
			tUd.AddInBuf(chr(10) , E_ADD_SYMBOL , GetPosition())
			
		endif		
		
		' вставляем новую пустую строку
		pObj.pList.InsertItemIndex(pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1 , 0)
		
	EndIf
	
	if pObj.iCurentCursorRowInWindow >= pObj.iHeightRows-1 then ' если курсор в самом низу экрана
		
		pObj.iStartRowInWindow+=1 ' увеличиваем первую видимую строку на экране
		
	else
		
		pObj.iCurentCursorRowInWindow+=1 ' перемещаем курсор на следующую строку
		
	EndIf
	
	SetLenghtNumbers() ' устанавливаем размер номеров строк
	
	pObj.iCurentCursorPosInWindow = pObj.iLenghtNumbers+2 ' позицию курсора на начало (сразу за номерами строк)
	
	pObj.iCurentPosInRow = 1 ' позицию в строке на начало
	
	pObj.iScrollWidth = 1 ' прокрутку сбрасываем (строка не прокручена)
	
	SetDrawsRowsFlags(-1 , 0) ' все перерисовать
	
End Sub

' включение или отключение курсора
' параметр:
' iOn (1 - вкл ; 0 - выкл)
sub CursorOnOff(iOn as long)
	
	#ifdef __UNIX_SYSTEM__
		
		if iOn then ' если надо включить
			
			printf(!"\027[?25h") ' включаем
			fflush(stdout)
		else ' если надо выключить
			
			printf(!"\027[?25l") ' выключаем
			fflush(stdout)
		EndIf
		
	#EndIf
	
	#ifdef __FB_win32__
		
		dim as w32CONSOLE_CURSOR_INFO CCI
		
		if iOn then ' если надо включить
			
			CCI.bVisible = 1 ' включаем
			
		else ' если надо выключить
			
			CCI.bVisible = 0 ' выключаем
			
		EndIf
		
		CCI.dwSize = 25 ' параметр высоты курсора
		
		' задаем параметры курсора
		w32SetConsoleCursorInfo(pTConsole.hNewStdOut , @CCI)
		
	#EndIf
	
	#ifdef __FB_DOS__
		
		if iOn then ' если надо включить
			
			locate ,,1
			
		else ' если надо выключить	
			
			locate ,,0
			
		EndIf
		
	#EndIf
	
End Sub