'подсчет многострочных комментариев
sub CalcMultiComments()
	
	' очищаем массив
	redim pMultiComment(10) as TMultiComments
	
	' переменные для обозначения начала и конца комментария
	dim as string sMb  = "/'", sMe = "'/"
	
	dim as Long iMcFlag ' флаг , если найдено начало комментария
	
	dim as Long iIndex ' индекс для массива при удачном поиске
	
	' цикл по числу строк
	for i as Long = 0 to pObj.pList.GetSize() - 1
		
		' если длина строки не нулевая
		if pObj.pList.GetValueLenIndex(i) then
			
			' получим строку
			#ifdef __UNIX_SYSTEM__
				dim as string sTemp = *(pObj.pList.GetValueIndex(i))
			#else
				dim as wstring ptr pwsTemp = pObj.pList.GetValueIndex(i)
			#EndIf
			
			
			dim as Long iBegin ' стартовая позиция для поиска
			
			' ищем в цикле в этой строке
			do
				
				' если начало комментария уже раньше было найдено
				if iMcFlag then
					
					' ищем конец комментария
					#ifdef __UNIX_SYSTEM__
						iBegin = instr(iBegin+1 , sTemp , sMe)
					#else
						iBegin = instr(iBegin+1 , *pwsTemp , sMe)
					#endif
					
				else ' если ищем начало комментария
					
					' ищем начало комментария
					#ifdef __UNIX_SYSTEM__
						iBegin = instr(iBegin+1 , sTemp , sMb)
					#else
						iBegin = instr(iBegin+1 , *pwsTemp , sMb)
					#endif
					
				EndIf
				
				if iBegin then ' если что-то нашли
					
					' проверяем не вылез ли индекс за пределы размера массива
					if iIndex > uBound(pMultiComment) then
						
						redim preserve pMultiComment(iIndex+10) as TMultiComments
						
					EndIf
					
					' если нашли конец комментария
					if iMcFlag then
						
						' заносим конечный номер строки в массив
						pMultiComment(iIndex).iEndRow = i
						
						' заносим конечную позицию в строке в массив
						pMultiComment(iIndex).iEndPos = iBegin
						
						' флаг обнуляем , в следующий раз
						' будем искать начальную позицию комментария 
						iMcFlag = 0
						
						' увеличиваем индекс в массиве
						iIndex+=1
						
					else ' если нашли начало комментария
						
						' заносим начальный номер строки в массив
						pMultiComment(iIndex).iBeginRow = i
						
						' заносим начальную позицию в строке в массив
						pMultiComment(iIndex).iBeginPos = iBegin - 1
						
						' флаг активируем , в следующий раз
						' будем искать конечную позицию комментария 						
						iMcFlag = 1
						
					EndIf
					
				else ' если ничего в строке не нашли
					
					exit do ' выходим из цикла
					
				EndIf
				
			Loop
			
		EndIf
		
	Next
	
	' если конечный комментарий не был найден (не успели записать)
	if iMcFlag then 
		
		' заносим конечный номер строки в массив самой последней строки
		pMultiComment(iIndex).iEndRow = pObj.pList.GetSize() - 1
		
		' заносим конечную позицию в строке в массив самого последнего символа
		pMultiComment(iIndex).iEndPos = pObj.pList.GetValueLenIndex(pMultiComment(iIndex).iEndRow)
		
	EndIf
	
	iCountMultiComments = iIndex
	
End Sub

' установка курсора в окне и если необходимо скроллинг
' параметры:
' iIndex - индекс элемента в списке , для получения строки
' iReal - позиция с учетом табуляций до вставки
sub SetPosAndScroll_ForAddInsert(iIndex as Long , iReal as Long)
	
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex) ' получить строку с добавленным символом по индексу
	
	' получим позицию с учетом табуляций после вставки
	dim as long iReal1 = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow)
	
	' получим разницу (шаг)
	dim as Long iNextMinusCur = iReal1 - iReal
	
	if iNextMinusCur then ' если позиция будет меняться
		
		if (pObj.iCurentCursorPosInWindow + iNextMinusCur) >= pObj.iWidthSimbols then ' если курсор в конце видимого экрана
			
			dim as Long iPos = 1 ' первая позиция в строке буфера
			
			pObj.iScrollWidth = 1 ' прокрутку на начало
			
			pObj.iCurentCursorPosInWindow = iReal1 + pObj.iLenghtNumbers + 1
			
			while pObj.iCurentCursorPosInWindow >= pObj.iWidthSimbols ' пока курсор не окажется в области видимости экрана
				
				' получить текущую позицию с учетом табуляций
				dim as Long iCurentPos = GetTabStopPositionFromRealPosition(pWStr , iPos)
				
				' получить предыдущую позицию с учетом табуляций
				dim as Long iNextPos = GetTabStopPositionFromRealPosition(pWStr , iPos+1)
				
				iCurentPos = (iNextPos - iCurentPos) ' получим шаг между позициями
				
				pObj.iScrollWidth += iCurentPos ' увеличим прокрутку
				
				pObj.iCurentCursorPosInWindow -= iCurentPos ' уменьшим позицию курсора
				
				iPos+=1 ' увеличим позицию в строке буфера
				
			Wend
			
			bRepaintAnyway = 1 ' обновим весь экран
			
		else
			
			pObj.iCurentCursorPosInWindow += iNextMinusCur ' сдвинем курсор на величину шага
			
			SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовать 1 строку
			
		EndIf
		
	else
	
		SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовать 1 строку
		
	endif
	
End Sub

' Добавление символов в одну из строк связного списка
' и попутно установка настроек позиций в строке и на экране
' параметр:
' wSymbols - символ для добавления
sub AddSymBols(wSymbols as Wstring ptr)
	
	if pObj.iMarkerSelectionStart then ' если есть выделение
		
		BackSpace() ' удаляем текст выделения
		
	EndIf
	
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2 ' позиция (индекс) в списке для получения и установки значения
	
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex) ' получить строку по индексу
	
	dim as long iRest = 1 ' переменная для определения приращения с учетом табуляции
	
	if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
		
		' занесем символ в буфер откатов
		tUd.AddInBuf(*wSymbols , E_ADD_SYMBOL , GetPosition())
		
	endif
	
	' получаем реальную позицию с учетом табуляции
	dim as long iReal = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow)
	
	if pObj.iCurentPosInRow > pObj.pList.GetValueLenIndex(iIndex) then ' если текущая позиция в самом конце строки
		
		pObj.pList.SetValueIndex(iIndex , *pWStr & *wSymbols) ' переписать строку с добавлением нового символа
		
	else ' любая другая позиция в строке
		
		if pObj.iInsertMode = 0 then ' если включен режим замены
			
			' переписать строку с заменой символа
			(*pWStr)[pObj.iCurentPosInRow-1] = *wSymbols
			
		else
			
			'переписать строку с добавлением нового символа
			pObj.pList.SetValueIndex(iIndex , mid(*pWStr , 1 , pObj.iCurentPosInRow-1) & *wSymbols & mid(*pWStr , pObj.iCurentPosInRow))	
			
		EndIf
		
	EndIf
	
	pObj.iCurentPosInRow+=1 ' увеличиваем текущую позицию в строке
	
	' установим позицию в окне и скроллинг если необходимо
	SetPosAndScroll_ForAddInsert(iIndex , iReal)
	
	if *wSymbols = 39 orelse *wSymbols = 47 then ' если символы для многострочных комментариев
	    
	    bRepaintAnyway = 1 ' обновим весь экран
	    
	EndIf
	
	if pObj.iFlagHighlight then ' если подсветка включена
		
		' Подсчитаем многострочные комментарии
		CalcMultiComments()
		
	EndIf
	
End Sub

' вставка текста в строку 
' параметр:
' pwsText - текст для вставки
sub InsertLineText(pwsText as wstring ptr)
	
	dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2 ' позиция (индекс) в списке для получения и установки значения
	
	dim as wstring ptr pWStr = pObj.pList.GetValueIndex(iIndex) ' получить строку по индексу
	
	if pwsText andalso pWStr then
		
		dim as Long iLen = len(*pwsText) ' длина вставляемой строки
		
		' получаем реальную позицию с учетом табуляции
		dim as long iReal = GetTabStopPositionFromRealPosition(pWStr , pObj.iCurentPosInRow)
		
		if pObj.iCurentPosInRow > pObj.pList.GetValueLenIndex(iIndex) then ' если текущая позиция в самом конце строки
			
			pObj.pList.SetValueIndex(iIndex , *pWStr & *pwsText) ' переписать строку с добавлением нового текста
			
		else ' любая другая позиция в строке
			
			' переписать строку с добавлением нового текста
			pObj.pList.SetValueIndex(iIndex , mid(*pWStr , 1 , pObj.iCurentPosInRow-1) & *pwsText & mid(*pWStr , pObj.iCurentPosInRow))
			
		EndIf
		
		pObj.iCurentPosInRow+=iLen ' увеличиваем текущую позицию в строке
		
		' установим позицию в окне и скроллинг если необходимо
		SetPosAndScroll_ForAddInsert(iIndex , iReal)
		
	endif
	
End Sub

' вставка любого текста , в том числе с символами окончания строк
' параметр:
' pwsText - текст для вставки
sub InsertText(pwsText as wstring ptr)
	
	if pwsText andalso len(*pwsText) then ' если есть что вставлять
		
		if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
			
			' занесем строку в буфер откатов
			tUd.AddInBuf(*pwsText , E_INS_TEXT , GetPosition())
			
		EndIf
		
		dim as Long iFind , iPrevFind ' для поиска символов окончания строки и разделения строк
		
		dim as wstring*2 wchr10 = wchr(10) ' искомый символ
		
		do
			
			iPrevFind = iFind +1 ' новая позиция для поиска
			
			' в данном случае Instr с большими UNICODE буферами работает очень медленно
			' поэтому заменил ее на СИ вариант
			' в DOS нет ссылки на wcsstr (хотя в заголовках есть) , поэтому используем strstr ,
			' все равно в DOS тип WSTRING однобайтовый
			#ifdef __FB_DOS__
				dim as wstring ptr p = strstr(@(pwsText[iPrevFind-1]) , @wchr10)
			#else
				dim as wstring ptr p = wcsstr(@(pwsText[iPrevFind-1]) , @wchr10)
			#EndIf
			
			if p then ' если указатель не пустой
				
				iFind = (p-pwsText)+1 ' посчитаем позицию вхождения
				
			else
				
				iFind = 0 ' тогда запишем ноль , что ничего не нашли
				
			EndIf
			
			if iFind then ' если символ окончания строки найден
				
				(*pwsText)[iFind-1] = 0 ' занесем ноль по позиции chr(10)
				
				InsertLineText( @(pwsText[iPrevFind-1])) ' вставляем строку в список
				
				(*pwsText)[iFind-1] = 10 ' вернем обратно chr(10)
				
				' курсор на новую строку
				CursorInNewLine()
				
			else ' если символ окончания строки не найден
				
				' вырезаем строку из текста и вставляем в список
				InsertLineText(mid(*pwsText , iPrevFind , iFind - iPrevFind ))
				
				' выходим из цикла
				exit do
				
			EndIf
			
		Loop
		
		if pObj.iFlagHighlight then ' если подсветка включена
			
			' Подсчитаем многострочные комментарии
			CalcMultiComments()
			
		EndIf
		
	EndIf
	
End Sub

' удаляет фрагмент выделенного текста 
sub DeleteSelection()
	
	dim as Long iMarkerStart = pObj.iMarkerSelectionStart ' сохраняем начальный маркер
	
	dim as Long iMarkerEnd = GetPosition() ' сохраняем конечный маркер
	
	if iMarkerStart > iMarkerEnd then ' если выделение снизу-вверх
		
		swap iMarkerStart , iMarkerEnd ' меняем местами значения сохраненных маркеров
		
	EndIf
	
	' ставим позицию на позицию начального маркера на случай , если его перемещали
	SetPosition(iMarkerStart)
	
	' начальная и конечная строка выделения , а так же 
	' начальная и конечная позиция в строке выделения
	dim as Long iRowStart , iRowEnd , iPosStart , iPosEnd , iPosStartTab , iPosEndTab
	
	' получаем начальную строку выделения и 
	' начальную позицию в строке выделения
	GetRowsAndPosFromPosition(iMarkerStart , iRowStart , iPosStart , iPosStartTab)
	
	' получаем конечную строку выделения и 
	' конечную позицию в строке выделения
	GetRowsAndPosFromPosition(iMarkerEnd , iRowEnd , iPosEnd , iPosEndTab)
	
	if iRowStart = iRowEnd then ' если выделение на одной строке
		
		' получаем указатель на строку
		dim as wstring ptr pws = pObj.pList.GetValueIndex(iRowStart-1)
		
		if pws then
			
			if pObj.bFlagExecuteUndo = 0 then ' если не в режиме откатов
				
				' выделим память для буфера удаляемой строки
				dim as wstring ptr pws0 = callocate((pObj.pList.GetValueLenIndex(iRowStart-1)+1)*sizeof(wstring))
				
				if pws0 then
					
					' получим удаляемую строку
					*pws0 = mid(*pws , iPosStart , iPosEnd-iPosStart+1)
					
					if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
						
						' занесем строку в буфер откатов
						tUd.AddInBuf(*pws0 , E_DEL_TEXT , iMarkerStart)
						
					endif
					
					' освободим память
					deallocate(pws0)
					
				else
					
					DrawErrorMemory() ' выводим ошибку памяти
					
				endif
				
			endif
			
			' вырезаем нужный участок и сохраняем строку в списке
			pObj.pList.SetValueIndex(iRowStart-1 , left(*pws , iPosStart-1) & mid(*pws , iPosEnd+1))
			
		endif
		
	else ' если выделение не на одной строке
		
		' получаем указатель на строку начального маркера
		dim as wstring ptr pws1 = pObj.pList.GetValueIndex(iRowStart-1)
		
		' получаем указатель на строку конечного маркера
		dim as wstring ptr pws2 = pObj.pList.GetValueIndex(iRowEnd-1)
		
		if pws1 andalso pws2 then
			
			if pObj.bFlagExecuteUndo = 0 then ' если не в режиме откатов
				
				dim as Long iAllLen ' общая длина всех строк
				
				dim as wstring*2 wchr10 = wchr(10)
				
				for i as Long = iRowStart-1 to iRowEnd-1 ' проходим по всем выделенным строкам
					
					iAllLen+= (pObj.pList.GetValueLenIndex(i)+1) ' складываем длину всех строк
					
				Next
				
				dim as wstring ptr pws0 = callocate((iAllLen+1)*sizeof(wstring)) ' выделим память для буфера откатов
				
				if pws0 then
					
					*pws0 = mid(*pws1 , iPosStart) & wchr10 ' занесем в нее часть из первой строки
					
					dim as long iLenTemp = len(*pws0)
					
					for i as Long = iRowStart to iRowEnd-2 ' цикл по всем строкам , кроме первой и последней
						
						' *** такая операция слишком медленная , поэтому переписал с помощью memcpy
						' *pws0 &= *(pObj.pList.GetValueIndex(i)) & wchr10 ' все данные из строк в общий буфер
						' ***
						
						dim as long iLen0 = pObj.pList.GetValueLenIndex(i) ' получим длину строки
						
						if iLen0 then ' если длина ненулевая
							
							' копируем строку в общий буфер
							memcpy(@(pws0[iLenTemp]) , pObj.pList.GetValueIndex(i) , iLen0*sizeof(wstring))
							
						endif
						
						' копируем символ переноса строки в общий буфер
						memcpy(@(pws0[iLenTemp+iLen0]) , @wchr10 , sizeof(wstring))
						
						' увеличиваем длину , то есть смещение для буфера pws0
						iLenTemp+=(iLen0+1)
						
					Next
					
					*pws0 &= left(*pws2 , iPosEnd) ' занесем остаток из последней строки
					
					if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
						
						tUd.AddInBuf(*pws0 , E_DEL_TEXT , iMarkerStart) ' занесем строку в буфер откатов
						
					endif
					
					deallocate(pws0) ' освободим память
					
				else
					
					DrawErrorMemory() ' выводим ошибку памяти
					
				endif
				
			endif
			
			' вырезаем нужный участок и сохраняем в строке начального маркера
			pObj.pList.SetValueIndex(iRowStart-1 , left(*pws1 , iPosStart-1) & mid(*pws2 , iPosEnd+1))
			
			' все остальные строки (кроме строки начального маркера) удаляем в цикле
			for i as Long = iRowStart to iRowEnd-1
				
				' удаление строки в списке
				pObj.pList.DeleteItemIndex(iRowStart)
				
			Next
			
		endif
		
	EndIf
	
	if pObj.iCurentCursorPosInWindow = pObj.iWidthSimbols then ' если курсор оказался на последней ячейке экрана
		
		dim as wstring ptr pws = pObj.pList.GetValueIndex(iRowStart-1) ' получим строку из списка
		
		if pws andalso len(*pws) then ' проверим на всякий случай валидность строки
			
			if GetWidthSymbol((*pws)[iMarkerStart-1]) = 2 then ' если символ разрывается
				
				' заново поставим на нужную позицию
				' все пересчитается
				SetPosition(iMarkerStart)
				
			EndIf
			
		EndIf
		
	EndIf
	
	' сбрасываем маркер (выделения больше нет)
	SetMarkerSelection(1)
	
End Sub

' удаление по клавише "BackSpace"
sub BackSpace()
	
	if pObj.iMarkerSelectionStart then ' если есть выделение
		
		' удалить выделенный текст
		DeleteSelection()
		
	else ' если выделения текста нет
		
		' если после удаления , курсор останется на этой же строке
		if pObj.iCurentPosInRow > 1 then
			
			' получим индекс текущей строки
			dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
			
			' получим текст в текущей строке
			dim as wstring ptr pws = pObj.pList.GetValueIndex(iIndex)
			
			' получаем реальную текущую позицию с учетом табуляции
			dim as long iReal0 = GetTabStopPositionFromRealPosition(pws , pObj.iCurentPosInRow)
			
			' получаем реальную позицию-1 с учетом табуляции
			dim as long iReal1 = GetTabStopPositionFromRealPosition(pws , pObj.iCurentPosInRow-1)
			
			' получаем реальную позицию-2 с учетом табуляции
			dim as long iReal2 = GetTabStopPositionFromRealPosition(pws , pObj.iCurentPosInRow-2)
			
			' получаем реальную позицию-3 с учетом табуляции
			dim as long iReal3 = GetTabStopPositionFromRealPosition(pws , pObj.iCurentPosInRow-3)
			
			' если на первой позиции и текст прокручен влево
			if pObj.iScrollWidth > 1 andalso pObj.iCurentCursorPosInWindow - (iReal0 - iReal1) <= pObj.iLenghtNumbers+1 then
				
				if pObj.iCurentPosInRow = 2 then ' если позиция в строке = 2
					
					pObj.iScrollWidth = 1 ' прокрутку сбрасываем
					
					pObj.iCurentCursorPosInWindow = pObj.iLenghtNumbers+2 ' установим позицию в окне сразу после номеров строк
					
				elseif pObj.iCurentPosInRow >= 3 then ' если позиция в строке >= 3
					
					' прокручиваем текст вправо на 2
					pObj.iScrollWidth-=(iReal1-iReal3)
					
					' переместим курсор на вторую позицию , чтобы было видно следующий удаляемый символ
					pObj.iCurentCursorPosInWindow = pObj.iCurentCursorPosInWindow + (iReal1-iReal3) - (iReal0-iReal1)
					
				EndIf
				
				bRepaintAnyway = 1 ' обновить весь экран
				
				' если на второй позиции и текст прокручен влево	
			elseif pObj.iScrollWidth > 1 andalso pObj.iCurentCursorPosInWindow - (iReal0 - iReal2) <= pObj.iLenghtNumbers+1 then
				
				if pObj.iCurentPosInRow > 3 then
					
					' прокручиваем текст вправо на 1 символ (1 символ может быть от 1 до размера табуляции)
					pObj.iScrollWidth -= (iReal1-iReal2)
					
					' пересчитаем положение курсора для 2 позиции
					pObj.iCurentCursorPosInWindow = pObj.iCurentCursorPosInWindow + (iReal1-iReal2) - (iReal0-iReal1)
					
				else
					
					pObj.iScrollWidth = 1
					
					pObj.iCurentCursorPosInWindow = (iReal1-iReal2) + pObj.iLenghtNumbers+2
					
				endif
				
				bRepaintAnyway = 1 ' обновить весь экран
				
			else ' если текст не прокручен или курсор не на 1 или 2 позиции
				
				' переместим курсор на предыдущую позицию 
				pObj.iCurentCursorPosInWindow-=(iReal0-iReal1)
				
				dim as Long iSymbol = (*pws)[pObj.iCurentPosInRow-2]
				
				if iSymbol = 39 orelse iSymbol = 47 then
				    
				    bRepaintAnyway = 1 ' обновим весь экран
				    
				else    
				    
				    SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисовать текущую строку
				    
				EndIf
				
			EndIf
			
			if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
				
				' добавим символ в буфер наполнения откатов
				tUd.AddInBuf(mid(*pws , pObj.iCurentPosInRow-1 ,1) , E_BS_SYMBOL , GetPosition()-1)
				
			endif
			
			' обрежем строку на один удаляемый символ 
			pObj.pList.SetValueIndex(iIndex , left(*pws , pObj.iCurentPosInRow-2) & mid(*pws , pObj.iCurentPosInRow))			
			
			' переместим позицию в строке на предыдущую
			pObj.iCurentPosInRow-=1
			
			' курсор при удалении переместится на предыдущую строку
		elseif pObj.pList.GetSize() > 1 andalso (pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1) > 1 then
			
			' получим индекс текущей строки (назовем ее "B" для понимания комментариев)
			dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
			
			' получим длину строки "B"
			dim as Long iLen = pObj.pList.GetValueLenIndex(iIndex)
			
			' получим текущую позицию
			dim as long iPos = GetPosition()
			
			if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
				
				' добавим символ в буфер наполнения откатов
				tUd.AddInBuf(chr(10), E_BS_SYMBOL , iPos-1)
				
			endif
			
			' сдвинем курсор влево на предыдущую строку (назовем ее "A" для понимания комментариев)
			CursorInLeft()
			
			' если в строке "B" что-то было
			if iLen then
				
				' вставляем эту часть на предыдущую строку "A"
				InsertLineText(pObj.pList.GetValueIndex(iIndex))
				
				' позицию уменьшаем на 1
				SetPosition(iPos-1)
				
			EndIf
			
			' удаляем строку "B"
			pObj.pList.DeleteItemIndex(iIndex)
			
			bRepaintAnyway = 1 ' обновить весь экран
			
		else
		
			SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
			
			bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
			
		EndIf
		
	EndIf
	
	if pObj.iFlagHighlight then ' если подсветка включена
		
		' Подсчитаем многострочные комментарии
		CalcMultiComments()
		
	EndIf
	
End Sub

' удаление по клавише "Delete"
sub DeleteKey()
	
	if pObj.iMarkerSelectionStart then ' если есть выделение
		
		' удалить выделенный текст
		DeleteSelection()
		
	else ' если выделения нет
		
		' получим индекс текущей строки
		dim as Long iIndex = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-2
		
		' получим длину строки
		dim as Long iLen = pObj.pList.GetValueLenIndex(iIndex)
		
		' получим текст в текущей строке
		dim as wstring ptr pws = pObj.pList.GetValueIndex(iIndex)
		
		' если после удаления , курсор останется на этой же строке
		if pObj.iCurentPosInRow <= iLen then
			
			if pws then ' если указатель существует
				
				if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
					
					' добавим символ в буфер наполнения откатов
					tUd.AddInBuf(mid(*pws , pObj.iCurentPosInRow ,1) , E_DEL_SYMBOL , GetPosition())
					
				endif
				
				dim as Long iSymbol = (*pws)[pObj.iCurentPosInRow-1]
				
				' обрежем строку на один удаляемый символ 
				pObj.pList.SetValueIndex(iIndex , left(*pws , pObj.iCurentPosInRow-1) & mid(*pws , pObj.iCurentPosInRow+1))
				
				if iSymbol = 39 orelse iSymbol = 47 then
				    
				    bRepaintAnyway = 1 ' обновим весь экран
				    
				else    
				    
				    SetDrawsRowsFlags(pObj.iCurentCursorRowInWindow-1 , pObj.iCurentCursorRowInWindow-1) ' перерисуем текущую строку
				    
				EndIf
				
			else
			
				SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
				
			endif
			
		else
			
			' получим индекс текущей строки
			dim as Long iIndexNext = pObj.iStartRowInWindow+pObj.iCurentCursorRowInWindow-1
			
			if iIndexNext < pObj.pList.GetSize() then
				
				' получим текст в следующей строке
				dim as wstring ptr pwsNext = pObj.pList.GetValueIndex(iIndexNext)
				
				if pwsNext then ' если указатель существует
					
					if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
						
						' добавим символ переноса строки в буфер наполнения откатов
						tUd.AddInBuf(chr(10) , E_DEL_SYMBOL , GetPosition())
						
					endif
					
					' следующую cтроку соединяем с текущей строкой 
					pObj.pList.SetValueIndex(iIndex , left(*pws , pObj.iCurentPosInRow-1) & *pwsNext)
					
					' удаляем следующую строку
					pObj.pList.DeleteItemIndex(iIndexNext)
					
					bRepaintAnyway = 1 ' обновим весь экран
					
				else
				
					SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
					
				EndIf
				
			else
			
				SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
				
			EndIf
			
		EndIf
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
    if pObj.iFlagHighlight then ' если подсветка включена
        
        ' Подсчитаем многострочные комментарии
        CalcMultiComments()
        
    EndIf
	
End Sub

' выделение всего текста по клавише CTRL+A
sub SelectAll()
	
	pObj.iMarkerSelectionStart = 1 ' начальный маркер на 1 позицию
	
	SetPosition(100000000) ' переходим в самый конец текста
	
	bRepaintAnyway = 1
	
End Sub

' для получения всего текста из списка
function GetAllBuffer() as string
	
	dim as string sRet ' буфер для возвращаемого значения
	
	for i as Long = 0 to pObj.pList.GetSize()-1 ' цикл по всем строкам в списке
		
		sRet &= Unicodetoutf8(pObj.pList.GetValueIndex(i)) ' получаем строку и преобразуем в UTF8
		
		if i <> pObj.pList.GetSize()-1 then ' если не полседняя строка в списке
			
			sRet &= sCHR10 ' добавляем символ окончания строки
			
		EndIf
		
	Next
	
	return sRet ' вернем весь буфер
	
End Function

' общая процедура для комментирования или раскомментирования
' параметры:
' pSavedUndoRows - массив с сохраненными строками , которые нужно
'       комментировать при операциях UNDO|REDO
' iSavedPrevPos - сохраненная позиция курсора при операциях UNDO|REDO
' iComOrUnCom - что делать (комментировать или раскомментировать) 
sub CommentOrUncomment(pSavedUndoRows as TypeCommentsArraySavedRows ptr = 0 , iSavedPrevPos as Long = 1 , iComOrUnCom as Long = 0)
	
	dim as Long iStartRow ' начальная строка выделения
	
	dim as Long iEndRow ' конечная строка выделения
	
	dim as Long iPrevPos ' позиция до операции Comment|Uncomment
	
	dim as TypeCommentsArraySavedRows ptr pUndoRows ' массив для строк , с которыми будет проводится операция Comment|Uncomment 
	
	dim as Long iIndexUndoRows ' индекс для массива pUndoRows
	
	dim as Long iCountOperationWithRows ' кол-во строк , с которыми были проделаны операции
	
	dim as Long iLenUndoRows ' длина строки pSavedUndoRows
	
	dim as Long iSwap ' указывает, будут ли поменяны местами координаты iStartRow и iEndRow
	
	iPrevPos = GetPosition() ' получим позицию
	
	if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
		
		' получим строки , с которыми нужно работать
		GetRowsFromPosition(iStartRow , iEndRow , iSwap)

		' комментарировать|раскомментировать можно только максимум до 65535 строки
		' сделано для того чтобы можно было уместить номер строки в один символ WSTRING (на windows 65535)
		' да и глупо работать с исходными файлами BAS с таким большим кол-вом строк
		if iEndRow > &hFFFF then iEndRow = &hFFFF
		if iStartRow > &hFFFF then iStartRow = &hFFFF

		pUndoRows = callocate((iEndRow - iStartRow + 2) * sizeof(TypeCommentsArraySavedRows))
		
		if pUndoRows = 0 then ' если проблемы выделения памяти
		
			DrawErrorMemory() ' выводим ошибку памяти
			
			exit sub 'выходим
			
		endif
		
	else
	
		if pSavedUndoRows = 0 then exit sub ' если указатель не валидный , выходим из процедуры
		
		#ifdef __FB_DOS__
			
			iLenUndoRows = LenShortBuf(pSavedUndoRows) ' посчитаем длину строки
			
		#else
		
			iLenUndoRows = len(*pSavedUndoRows) ' посчитаем длину строки
			
		#EndIf
		
		select case iLenUndoRows 'какова длина строки
			
			Case 0 ' если длина строки нулевая
			
				exit sub ' выходим из процедуры
			
			case 1 ' если длина строки один символ
				#ifdef __FB_DOS__
					' в диапазоне только одна строка
					iStartRow = (pSavedUndoRows)[0]
					iEndRow = (pSavedUndoRows)[0]
				#else
					' в диапазоне только одна строка
					iStartRow = (*pSavedUndoRows)[0]
					iEndRow = (*pSavedUndoRows)[0]
				#EndIf				
			case else
				#ifdef __FB_DOS__
					' установим диапазон строк из первого и последнего символа
					iStartRow = (pSavedUndoRows)[0]
					iEndRow = (pSavedUndoRows)[iLenUndoRows-1]
				#else
					' установим диапазон строк из первого и последнего символа
					iStartRow = (*pSavedUndoRows)[0]
					iEndRow = (*pSavedUndoRows)[iLenUndoRows-1]
				#EndIf
		End Select
		
	EndIf
	
	SetMarkerSelection(1) ' сбросим выделение
	
	for i as long = iStartRow to iEndRow ' проходим по всем заданным строкам
		
		if pObj.bFlagExecuteUndo then ' если это откаты назад!
			
			dim as Long iContinue = 1 ' по умолчанию пропускаем строку
			
			' поиск в цикле строки , с которой надо работать 
			for j as Long  = 0 to iLenUndoRows-1
				
				if pSavedUndoRows[j] = i then ' если с такой строкой надо работать
					
					iContinue = 0 ' обнуляем флаг
					
					exit for ' выходим из цикла
					
				EndIf
				
			Next
			
			if iContinue then continue for ' такой строки нет в буфере , поэтому пропускаем итерацию
			
		EndIf
		
		dim as wstring ptr pWstr = pObj.pList.GetValueIndex(i-1) ' получаем указатель на строку из связного списка
		
		if pWstr then ' если валидный указатель
			
			dim as long iLen = len(*pWstr)-1 ' получим длину для цикла
			
			for j as Long = 0 to iLen ' проходимся по строке
				
				select case (*pWstr)[j] ' что за символ
						
					Case 32 , 9
						
						if iComOrUnCom = E_COMMENT then ' если операция комментирования
						
							' пропускаем все кроме последнего символа
							if j = iLen then
								
								' добавляем в буфер комментарий
								pObj.pList.SetValueIndex(i-1 , *pWstr & "'")
								
								if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
									#ifdef __FB_DOS__
										(pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
									#else
										(*pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
									#EndIf
									
									iIndexUndoRows+=1 ' увеличим смещение
									
								EndIf
								
								iCountOperationWithRows+=1 ' увеличим счетчик строк , с которыми проделана операция
								
								' флаг сохранения сбрасываем (теперь файл не сохранен)
								pObjFB.iFlagSave = 0
								
								exit for ' выходим из цикла
								
							EndIf
						
						endif
						
					case else
						
						' если операция UNCOMMENT и найден символ комментария
						if iComOrUnCom = E_UNCOMMENT andalso (*pWstr)[j] = 39 then
							
							' удаляем комментарий
							pObj.pList.SetValueIndex(i-1 , left(*pWstr , j) & mid(*pWstr , j+2))

							if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
								#ifdef __FB_DOS__
									(pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
								#else
									(*pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
								#EndIf
								
								iIndexUndoRows+=1 ' увеличим смещение
								
							EndIf
							
							iCountOperationWithRows+=1 ' увеличим счетчик строк , с которыми проделана операция
							
							' флаг сохранения сбрасываем (теперь файл не сохранен)
							pObjFB.iFlagSave = 0
							
						elseif iComOrUnCom = E_COMMENT then ' если операция COMMENT
						
							' добавляем в буфер комментарий
							pObj.pList.SetValueIndex(i-1 , left(*pWstr , j) & "'" & mid(*pWstr , j+1))
							
							if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
								#ifdef __FB_DOS__
									(pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
								#else
									(*pUndoRows)[iIndexUndoRows] = i ' добавим номер строки
								#EndIf
								iIndexUndoRows+=1 ' увеличим смещение
								
							EndIf
							
							iCountOperationWithRows+=1 ' увеличим счетчик строк , с которыми проделана операция
							
							' флаг сохранения сбрасываем (теперь файл не сохранен)
							pObjFB.iFlagSave = 0
							
						EndIf
						
						exit for ' выходим из цикла
						
				End Select
				
			Next
			
		endif
		
	Next
	
	if pObj.bFlagExecuteUndo = 0 then ' если это не откаты назад
		
		' добавим массив со строками в буфер наполнения откатов
		tUd.AddInBuf(cast(any ptr , pUndoRows), iComOrUnCom , iPrevPos)
		
	else
		
		if pObj.bFlagExecuteUndo = 1 then ' операция UNDO
			
			SetPosition(iSavedPrevPos) ' установим позицию
			
		else ' операция REDO
		
			' новая позиция с учетом вводимых или удаляемых символов комментария
			dim as Long iNewPos
			
			' для получения строки и позиции в строке из общей позиции
			dim as Long iRow , iPosInLine , iPosInLineTab
			
			' получаем строку из сохраненной позиции
			' чтобы узнать в какую сторону было выделение до откатов
			GetRowsAndPosFromPosition(iSavedPrevPos , iRow , iPosInLine , iPosInLineTab)
			
			' получим позицию при откатах (разница может быть при добавлении или удалении комментариев)
			iNewPos = GetPositionWithUndoRedo(iSavedPrevPos , iComOrUnCom , iCountOperationWithRows , iRow <> iStartRow)
			
			SetPosition(iNewPos) ' установим позицию
			
		EndIf
		
		exit sub
		
	EndIf
	
	' новая позиция с учетом вводимых или удаляемых символов комментария
	'присвоим по умолчанию старую позицию
	dim as Long iNewPos = iPrevPos
	
	iNewPos = GetPositionWithUndoRedo(iPrevPos , iComOrUnCom , iCountOperationWithRows , iSwap = 0)
	
	SetPosition(iNewPos) ' установим позицию
	
End Sub

' комментирование строки или совокупности выделенных строк
' параметры:
' pSavedUndoRows - массив с сохраненными строками , которые нужно
'       комментировать при операциях UNDO|REDO
' iSavedPrevPos - сохраненная позиция курсора при операциях UNDO|REDO
sub Comment(pSavedUndoRows as TypeCommentsArraySavedRows ptr = 0 , iSavedPrevPos as Long = 1)
	
	' начинаем операцию Comment
	CommentOrUncomment(pSavedUndoRows , iSavedPrevPos , E_COMMENT)
	
End Sub

' раскомментирование строки или совокупности выделенных строк
' параметры:
' pSavedUndoRows - массив с сохраненными строками , которые нужно
'       раскомментировать при операциях UNDO|REDO
' iSavedPrevPos - сохраненная позиция курсора при операциях UNDO|REDO
sub UnComment(pSavedUndoRows as TypeCommentsArraySavedRows ptr = 0 , iSavedPrevPos as Long = 1)
	
	' начинаем операцию UnComment
	CommentOrUncomment(pSavedUndoRows , iSavedPrevPos , E_UNCOMMENT)
	
End Sub

#ifdef __UNIX_SYSTEM__
	
	' получение части строки с заданными параметрами начала и длины
	function GetPartStringAndLen(pWstr as Wstring ptr  , iStartPos as Long , byref iLen as Long) as STRING
		
		' выделим память под буфер
		dim as wstring ptr pwsTemp0 = callocate((iLen+1)*sizeof(wstring))
		
		if pwsTemp0 = 0 then
			
			DrawErrorMemory() ' выводим ошибку памяти
			
			iLen = 0
			
			return ""
			
		EndIf
		
		' получаем буфер для данной строки
		*pwsTemp0 = mid(*pWstr , iStartPos , iLen)
		
		' преобразуем в UTF8
		dim as string sTemp = Unicodetoutf8(pwsTemp0)
		
		' получаем реальную длину буфера
		iLen = len(*pwsTemp0)
		
		' очищаем память
		deallocate(pwsTemp0)
		
		return sTemp
		
	End Function
	
#else
	
	' получение части строки с заданными параметрами начала и длины
	function GetPartStringAndLen(pWstr as Wstring ptr  , iStartPos as Long , byref iLen as Long) as wSTRING ptr
		
		' выделим память под буфер
		dim as wstring ptr pwsTemp0 = callocate((iLen+1)*sizeof(wstring))
		
		if pwsTemp0 = 0 then
			
			DrawErrorMemory() ' выводим ошибку памяти
			
			iLen = 0
			
			return 0
			
		EndIf
		
		' получаем буфер для данной строки
		*pwsTemp0 = mid(*pWstr , iStartPos , iLen)
		
		' получаем реальную длину буфера
		iLen = len(*pwsTemp0)
		
		return pwsTemp0
		
	End Function
	
#endif

' получение стартовой позиции после скроллинга
function GetStartPosAfterScroll(pWstr as Wstring ptr  , iStartPos as Long , iLenWStr as long) as LONG
	
	dim as Long iVirtualStart , i , iResult
	
	' если стартовая позиция в нужном пределе
	if iStartPos > 1 then
		
		' цикл , пока кол-во знакомест не сравняется с позицией скроллинга
		for i = 0 to iStartPos-1
			
			' если смещение больше возможного , выходим
			' такого быть не должно , но на всякий случай проверяем
			if iResult > iLenWStr then exit for
			
			' если это окажется символ конца строки , выходим
			if (*pWstr)[iResult] = 0 then
				
				' если кол-во знакомест меньше позиции скроллинга
				if iVirtualStart < iStartPos then
					
					iResult+=1 ' увеличим кол-во реальных символов
					
				endif
				
				exit for
				
			EndIf
			
			' проверим кол-во знакомест для символа
			select case GetWidthSymbol((*pWstr)[iResult])
					
				case 0 ' если символ не занимает места на экране
					
					if iVirtualStart < iStartPos then ' если кол-во знакомест меньше позиции скроллинга
						
						i-=1 ' переменную цикла назад (заставляем пройти еще одну итерацию)
						
					else
						
						'iResult-=1 ' уменьшим на 1 результат , чтобы символ нулевого знакоместа не вошел
						
						exit for
						
					EndIf
					
				case 1 ' если символ занимает одно место на экране
					
					if iVirtualStart < iStartPos then ' если кол-во знакомест меньше позиции скроллинга
						
						iVirtualStart+=1 ' увеличим виртуальнную позицию на единицу
						
						if (*pWstr)[iResult] = 9 then ' если это табуляция
							
							' пока не будет равно сегменту , равному длине табуляции
							while (iVirtualStart mod iTabSpace <> 0)
								
								iVirtualStart+=1 ' увеличим виртуальнную позицию
								
							Wend
							
						endif
						
					else
						
						exit for
						
					EndIf
					
				case 2 ' если символ занимает два места на экране
					
					if iVirtualStart+1 < iStartPos then ' если кол-во знакомест меньше позиции скроллинга
						
						iVirtualStart+=2 ' увеличим виртуальнную позицию на 2
						
					else
						
						if iVirtualStart < iStartPos then ' если кол-во знакомест меньше позиции скроллинга
							
							iResult+=1 ' увеличим кол-во реальных символов
							
						EndIf
						
						exit for
						
					EndIf
					
			End Select
			
			iResult+=1 ' увеличим кол-во реальных символов
			
		Next
		
	else
		
		iResult = iStartPos ' кол-во реальных символов будет равно 1
		
	endif
	
	return iResult ' вернем кол-во реальных символов
	
End Function

' получение длины строки с учетом символов различающихся по длине знакоместа
' функция вернет длину с учетом всех знакомест
' в iMaxLen запишется длина без учета нулевых знакомест
function GetLenAfterScrollPos(pWstr as Wstring ptr  , iStartPos as Long ,  byref iMaxLen as Long , iLen_pWstr as Long) as LONG
	
	dim as Long iVirtualWides ,  j , iLen , iLenWithoutNullsymbols
	
	' цикл в диапазоне строки , начиная с iStartPos
	for j = iStartPos-1 to iLen_pWstr-1
		
		select case GetWidthSymbol((*pWstr)[j]) ' какова ширина знакоместа?
				
			case 0
				
				iLenWithoutNullsymbols-=1 ' символы с нулевым знакоместом не учитываем
				
			case 1
				
				' если при подсчете не достигаем виртуальной заданной ширины iMaxLen
				' обычно iMaxLen это ширина в ячейках экрана
				if iVirtualWides < iMaxLen then 
					
					iVirtualWides+=1 ' увеличим виртуальную ширину на единицу
					
				else ' достигли виртуальной заданной ширины iMaxLen
					
					exit for ' выходим из цикла
					
				EndIf
				
			case 2
				
				' если при подсчете не достигаем виртуальной заданной ширины iMaxLen
				' обычно iMaxLen это ширина в ячейках экрана				
				if iVirtualWides + 1 < iMaxLen then
					
					iVirtualWides+=2 ' увеличим виртуальную ширину на двойку
					
					iLenWithoutNullsymbols+=1 ' так же увеличиваем длину , которая не учитывает нулевые знакоместа
					
				else
					
					exit for ' выходим из цикла
					
				EndIf
				
		End Select
		
		iLen +=1 'увеличиваем длину , которая учитывает все знакоместа
		
		iLenWithoutNullsymbols+=1 'увеличиваем длину , которая не учитывает нулевые знакоместа
		
	Next
	
	iMaxLen = iLenWithoutNullsymbols ' сохраним длину , которая не учитывает нулевые знакоместа
	
	return iLen ' сохраним длину , которая учитывает все знакоместа
	
End Function

#ifdef __UNIX_SYSTEM__
	
	' получение части строки для рисования
	function GetPartStringForDraw(pWstr as Wstring ptr  , iStartPos as Long , byref iMaxLen as Long , iSpaces as Long , iLen_pWstr as Long) as STRING
		
		dim as Long i , iLen
		
		' получим позицию после скроллинга
		i = GetStartPosAfterScroll(pWstr , iStartPos , iLen_pWstr)
		
		' получим длину от конца скроллинга до конца экрана
		iLen = GetLenAfterScrollPos(pWstr , i , iMaxLen , iLen_pWstr)
		
		dim as string sTemp
		
		' если перед началом строки символ с нулевым знакоместом 
		if i > 1 andalso GetWidthSymbol((*pWstr)[i-2]) = 0 then
			
			' получим строку для экрана с символом нулевого знакоместа , для того
			' чтобы они были приклеплены к символу при рисовании
			sTemp = GetPartStringAndLen(pWstr , i-1 , iLen+1)
			
		else
			
			' получим строку для экрана
			sTemp = GetPartStringAndLen(pWstr , i , iLen)		
			
		EndIf
		
		' если задан параметр для заполнения остальной части пробелами
		if iSpaces then
			
			' если длина строки меньше длины экранного буфера по ширине 
			if iMaxLen + pObj.iLenghtNumbers + 1 < pObj.iWidthSimbols then
				
				' заполняем остальную часть пробелами
				sTemp &= space(pObj.iWidthSimbols-(iMaxLen+pObj.iLenghtNumbers+1))
				
			EndIf
			
		endif
		
		return sTemp ' вернем строку
		
	End Function
	
#else
	
	' получение части строки для рисования
	function GetPartStringForDraw(pWstr as Wstring ptr  , iStartPos as Long , byref iMaxLen as Long , iSpaces as Long , iLen_pWstr as Long) as wSTRING ptr
		
		dim as Long i , iLen
		
		' получим позицию после скроллинга
		i = GetStartPosAfterScroll(pWstr , iStartPos , iLen_pWstr)

		' получим длину от конца скроллинга до конца экрана
		iLen = GetLenAfterScrollPos(pWstr , i , iMaxLen , iLen_pWstr)
		
		dim as wstring ptr pwsTemp
		
		' если перед началом строки символ с нулевым знакоместом 
		if i > 1 andalso GetWidthSymbol((*pWstr)[i-2]) = 0 then
			
			' получим строку для экрана с символом нулевого знакоместа , для того
			' чтобы они были приклеплены к символу при рисовании
			pwsTemp = GetPartStringAndLen(pWstr , i-1 , iLen+1)
			
		else
			
			' получим строку для экрана
			pwsTemp = GetPartStringAndLen(pWstr , i , iLen)		
			
		EndIf
		
		' если задан параметр для заполнения остальной части пробелами
		if iSpaces then
			
			' если длина строки меньше длины экранного буфера по ширине 
			if iMaxLen + pObj.iLenghtNumbers + 1 < pObj.iWidthSimbols then
				
				pwsTemp = reallocate(pwsTemp , (pObj.iWidthSimbols+1)*sizeof(wstring))
				
				if pwsTemp = 0 then
					
					DrawErrorMemory() ' выводим ошибку памяти
					
					iMaxLen = 0
					
					return 0
					
				EndIf
				
				' заполняем остальную часть пробелами
				*pwsTemp &= wspace(pObj.iWidthSimbols-(iMaxLen+pObj.iLenghtNumbers+1))
				
			EndIf
			
		endif
		
		return pwsTemp ' вернем строку
		
	End Function
	
#endif
