/*
 *  lmremutl.h  LAN Manager remote utility functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _LMREMUTL_
#define _LMREMUTL_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Description character */
#ifndef DESC_CHAR_UNICODE
typedef CHAR    DESC_CHAR;
typedef LPSTR   LPDESC;
#else
typedef WCHAR   DESC_CHAR;
typedef LPWSTR  LPDESC;
#endif

/* NetRemoteComputerSupports() flags */
#define SUPPORTS_REMOTE_ADMIN_PROTOCOL  0x00000002L
#define SUPPORTS_RPC                    0x00000004L
#define SUPPORTS_SAM_PROTOCOL           0x00000008L
#define SUPPORTS_UNICODE                0x00000010L
#define SUPPORTS_LOCAL                  0x00000020L
#define SUPPORTS_ANY                    0xFFFFFFFFL

/* RxRemoteApi() flags */
#define NO_PERMISSION_REQUIRED  0x00000001L
#define ALLOCATE_RESPONSE       0x00000002L
#define USE_SPECIFIC_TRANSPORT  0x80000000L

/* Time of day information */
typedef struct _TIME_OF_DAY_INFO {
    DWORD   tod_elapsedt;
    DWORD   tod_msecs;
    DWORD   tod_hours;
    DWORD   tod_mins;
    DWORD   tod_secs;
    DWORD   tod_hunds;
    LONG    tod_timezone;
    DWORD   tod_tinterval;
    DWORD   tod_day;
    DWORD   tod_month;
    DWORD   tod_year;
    DWORD   tod_weekday;
} TIME_OF_DAY_INFO;
typedef TIME_OF_DAY_INFO    *PTIME_OF_DAY_INFO;
typedef TIME_OF_DAY_INFO    *LPTIME_OF_DAY_INFO;

/* Functions in NETAPI32.DLL */
NET_API_STATUS NET_API_FUNCTION NetRemoteComputerSupports( LPCWSTR, DWORD, LPDWORD );
NET_API_STATUS NET_API_FUNCTION NetRemoteTOD( LPCWSTR, LPBYTE * );
NET_API_STATUS __cdecl          RxRemoteApi( DWORD, LPCWSTR, LPDESC, LPDESC, LPDESC, LPDESC, LPDESC, LPDESC, LPDESC, DWORD, ... );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _LMREMUTL_ */
