/*
 *  wincrypt.h  Win32 cryptographic functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __WINCRYPT_H__
#define __WINCRYPT_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify cryptographic functions */
#define WINCRYPT32API       DECLSPEC_IMPORT
#define WINCRYPT32STRINGAPI DECLSPEC_IMPORT

/* Algorithm identifier data type */
#ifndef ALGIDDEF
#define ALGIDDEF
typedef unsigned int    ALG_ID;
#endif

/* Cryptographic primitive data types */
typedef ULONG_PTR       HCRYPTHASH;
typedef ULONG_PTR       HCRYPTKEY;
typedef ULONG_PTR       HCRYPTPROV;
typedef ULONG_PTR       HCRYPTPROV_LEGACY;
typedef ULONG_PTR       HCRYPTPROV_OR_NCRYPT_KEY_HANDLE;
typedef void            *HCRYPTOIDFUNCSET;
typedef void            *HCRYPTOIDFUNCADDR;
typedef void            *HCRYPTMSG;
typedef void            *HCERTSTORE;
typedef void            *HCERTSTOREPROV;
typedef void            *HCRYPTDEFAULTCONTEXT;
typedef HANDLE          HCRYPTASYNC;
typedef HANDLE          *PHCRYPTASYNC;
typedef HANDLE          HCERTCHAINENGINE;
#if (NTDDI_VERSION >= 0x06000000)
typedef VOID            *HCERT_SERVER_OCSP_RESPONSE;
#endif

#include <bcrypt.h>
#include <ncrypt.h>

/* Macros to manipulate algorithm identifiers */
#define GET_ALG_CLASS( x )  (x & (7 << 13))
#define GET_ALG_TYPE( x )   (x & (15 << 9))
#define GET_ALG_SID( x )    (x & 511)

/* Algorithm classes */
#define ALG_CLASS_ANY           (0 << 13)
#define ALG_CLASS_SIGNATURE     (1 << 13)
#define ALG_CLASS_MSG_ENCRYPT   (2 << 13)
#define ALG_CLASS_DATA_ENCRYPT  (3 << 13)
#define ALG_CLASS_HASH          (4 << 13)
#define ALG_CLASS_KEY_EXCHANGE  (5 << 13)
#define ALG_CLASS_ALL           (7 << 13)

/* Algorithm types */
#define ALG_TYPE_ANY            (0 << 9)
#define ALG_TYPE_DSS            (1 << 9)
#define ALG_TYPE_RSA            (2 << 9)
#define ALG_TYPE_BLOCK          (3 << 9)
#define ALG_TYPE_STREAM         (4 << 9)
#define ALG_TYPE_DH             (5 << 9)
#define ALG_TYPE_SECURECHANNEL  (6 << 9)

/* Algorithm subidentifiers */
#define ALG_SID_ANY                     0
#define ALG_SID_RSA_ANY                 0
#define ALG_SID_RSA_PKCS                1
#define ALG_SID_RSA_MSATWORK            2
#define ALG_SID_RSA_ENTRUST             3
#define ALG_SID_RSA_PGP                 4
#define ALG_SID_DSS_ANY                 0
#define ALG_SID_DSS_PKCS                1
#define ALG_SID_DSS_DMS                 2
#if (NTDDI_VERSION >= 0x06000000)
    #define ALG_SID_ECDSA               3
#endif
#define ALG_SID_DES                     1
#define ALG_SID_3DES                    3
#define ALG_SID_DESX                    4
#define ALG_SID_IDEA                    5
#define ALG_SID_CAST                    6
#define ALG_SID_SAFERSK64               7
#define ALG_SID_SAFERSK128              8
#define ALG_SID_3DES_112                9
#define ALG_SID_CYLINK_MEK              12
#define ALG_SID_RC5                     13
#if (NTDDI_VERSION >= 0x05010000)
    #define ALG_SID_AES_128             14
    #define ALG_SID_AES_192             15
    #define ALG_SID_AES_256             16
    #define ALG_SID_AES                 17
#endif
#define ALG_SID_SKIPJACK                10
#define ALG_SID_TEK                     11
#define ALG_SID_RC2                     2
#define ALG_SID_RC4                     1
#define ALG_SID_SEAL                    2
#define ALG_SID_DH_SANDF                1
#define ALG_SID_DH_EPHEM                2
#define ALG_SID_AGREED_KEY_ANY          3
#define ALG_SID_KEA                     4
#if (NTDDI_VERSION >= 0x06000000)
    #define ALG_SID_ECDH                5
#endif
#define ALG_SID_MD2                     1
#define ALG_SID_MD4                     2
#define ALG_SID_MD5                     3
#define ALG_SID_SHA                     4
#define ALG_SID_SHA1                    4
#define ALG_SID_MAC                     5
#define ALG_SID_RIPEMD                  6
#define ALG_SID_RIPEMD160               7
#define ALG_SID_SSL3SHAMD5              8
#define ALG_SID_HMAC                    9
#define ALG_SID_TLS1PRF                 10
#if (NTDDI_VERSION >= 0x05010000)
    #define ALG_SID_HASH_REPLACE_OWF    11
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define ALG_SID_SHA_256             12
    #define ALG_SID_SHA_384             13
    #define ALG_SID_SHA_512             14
#endif
#define ALG_SID_SSL3_MASTER             1
#define ALG_SID_SCHANNEL_MASTER_HASH    2
#define ALG_SID_SCHANNEL_MAC_KEY        3
#define ALG_SID_PCT1_MASTER             4
#define ALG_SID_SSL2_MASTER             5
#define ALG_SID_TLS1_MASTER             6
#define ALG_SID_SCHANNEL_ENC_KEY        7
#if (NTDDI_VERSION >= 0x06000000)
    #define ALG_SID_ECMQV               1
#endif
#define ALG_SID_EXAMPLE                 80

/* Cryptographic modes */
#define CRYPT_MODE_CBCI     6
#define CRYPT_MODE_CFBP     7
#define CRYPT_MODE_OFBP     8
#define CRYPT_MODE_CBCOFM   9
#define CRYPT_MODE_CBCOFMI  10

/* Algorithm identifiers */
#define CALG_MD2            (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD2)
#define CALG_MD4            (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD4)
#define CALG_MD5            (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD5)
#define CALG_SHA            (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA)
#define CALG_SHA1           (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA1)
#define CALG_MAC            (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MAC)
#define CALG_RSA_SIGN       (ALG_CLASS_SIGNATURE | ALG_TYPE_RSA | ALG_SID_RSA_ANY)
#define CALG_DSS_SIGN       (ALG_CLASS_SIGNATURE | ALG_TYPE_DSS | ALG_SID_DSS_ANY)
#if (NTDDI_VERSION >= 0x05010000)
    #define CALG_NO_SIGN    (ALG_CLASS_SIGNATURE | ALG_TYPE_ANY | ALG_SID_ANY)
#endif
#define CALG_RSA_KEYX       (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_RSA | ALG_SID_RSA_ANY)
#define CALG_DES            (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_DES)
#define CALG_3DES_112       (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_3DES_112)
#define CALG_3DES           (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_3DES)
#define CALG_DESX           (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_DESX)
#define CALG_RC2            (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_RC2)
#define CALG_RC4            (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_STREAM | ALG_SID_RC4)
#define CALG_SEAL           (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_STREAM | ALG_SID_SEAL)
#define CALG_DH_SF          (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_DH | ALG_SID_DH_SANDF)
#define CALG_DH_EPHEM       (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_DH | ALG_SID_DH_EPHEM)
#define CALG_AGREEDKEY_ANY \
    (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_DH | ALG_SID_AGREED_KEY_ANY)
#define CALG_KEA_KEYX       (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_DH | ALG_SID_KEA)
#define CALG_HUGHES_MD5     (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_ANY | ALG_SID_MD5)
#define CALG_SKIPJACK       (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_SKIPJACK)
#define CALG_TEK            (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_TEK)
#define CALG_CYLINK_MEK \
    (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_CYLINK_MEK)
#define CALG_SSL3_SHAMD5    (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SSL3SHAMD5)
#define CALG_SSL3_MASTER \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_SSL3_MASTER)
#define CALG_SCHANNEL_MASTER_HASH \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_SCHANNEL_MASTER_HASH)
#define CALG_SCHANNEL_MAC_KEY \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_SCHANNEL_MAC_KEY)
#define CALG_SCHANNEL_ENC_KEY \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_SCHANNEL_ENC_KEY)
#define CALG_PCT1_MASTER \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_PCT1_MASTER)
#define CALG_SSL2_MASTER \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_SSL2_MASTER)
#define CALG_TLS1_MASTER \
    (ALG_CLASS_MSG_ENCRYPT | ALG_TYPE_SECURECHANNEL | ALG_SID_TLS1_MASTER)
#define CALG_RC5            (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_RC5)
#define CALG_HMAC           (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_HMAC)
#define CALG_TLS1PRF        (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_TLS1PRF)
#if (NTDDI_VERSION >= 0x05010000)
    #define CALG_HASH_REPLACE_OWF \
        (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_HASH_REPLACE_OWF)
    #define CALG_AES_128    (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_AES_128)
    #define CALG_AES_192    (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_AES_192)
    #define CALG_AES_256    (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_AES_256)
    #define CALG_AES        (ALG_CLASS_DATA_ENCRYPT | ALG_TYPE_BLOCK | ALG_SID_AES)
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define CALG_SHA_256    (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA_256)
    #define CALG_SHA_384    (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA_384)
    #define CALG_SHA_512    (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA_512)
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define CALG_ECDH       (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_DH | ALG_SID_ECDH)
    #define CALG_ECMQV      (ALG_CLASS_KEY_EXCHANGE | ALG_TYPE_ANY | ALG_SID_ECMQV)
    #define CALG_ECDSA      (ALG_CLASS_SIGNATURE | ALG_TYPE_DSS | ALG_SID_ECDSA)
#endif

/* CryptAcquireContext() flags */
#define CRYPT_VERIFYCONTEXT                     0xF0000000L
#define CRYPT_NEWKEYSET                         0x00000008L
#define CRYPT_DELETEKEYSET                      0x00000010L
#define CRYPT_MACHINE_KEYSET                    0x00000020L
#define CRYPT_SILENT                            0x00000040L
#if (NTDDI_VERSION >= 0x06000000)
    #define CRYPT_DEFAULT_CONTAINER_OPTIONAL    0x00000080L
#endif

/* CryptGenKey() flags */
#define CRYPT_EXPORTABLE                    0x00000001L
#define CRYPT_USER_PROTECTED                0x00000002L
#define CRYPT_CREATE_SALT                   0x00000004L
#define CRYPT_UPDATE_KEY                    0x00000008L
#define CRYPT_NO_SALT                       0x00000010L
#define CRYPT_PREGEN                        0x00000040L
#define CRYPT_RECIPIENT                     0x00000010L
#define CRYPT_INITIATOR                     0x00000040L
#define CRYPT_ONLINE                        0x00000080L
#define CRYPT_SF                            0x00000100L
#define CRYPT_CREATE_IV                     0x00000200L
#define CRYPT_KEK                           0x00000400L
#define CRYPT_DATA_KEY                      0x00000800L
#define CRYPT_VOLATILE                      0x00001000L
#define CRYPT_SGCKEY                        0x00002000L
#if (NTDDI_VERSION >= 0x05010000)
    #define CRYPT_ARCHIVABLE                0x00004000L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define CRYPT_FORCE_KEY_PROTECTION_HIGH 0x00008000L
#endif

/* CryptDeriveKey() flags */
#define CRYPT_SERVER    0x00000400L

/* CryptExportKey() flags */
#define CRYPT_Y_ONLY                            0x00000001L
#define CRYPT_SSL2_FALLBACK                     0x00000002L
#define CRYPT_DESTROYKEY                        0x00000004L
#define CRYPT_OAEP                              0x00000040L
#define CRYPT_BLOB_VER3                         0x00000080L
#if (NTDDI_VERSION >= 0x05010000)
    #define CRYPT_IPSEC_HMAC_KEY                0x00000100L
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define CRYPT_DESTROY_RSA_NO_PADDING_CHECK  0x00000020L
#endif

/* CryptCreateHash() flags */
#define CRYPT_SECRETDIGEST  0x00000001L

/* CryptHashData() flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define CRYPT_OWF_REPL_LM_HASH  0x00000001L
#endif

/* CryptHashSessionKey() flags */
#define CRYPT_LITTLE_ENDIAN 0x00000001L

/* CryptSignHash() and CryptVerifySignature() flags */
#define CRYPT_NOHASHOID     0x00000001L
#define CRYPT_TAPE2_FORMAT  0x00000002L
#define CRYPT_X931_FORMAT   0x00000004L

/* CryptSetProviderEx() and CryptGetDefaultProvider() flags */
#define CRYPT_MACHINE_DEFAULT   0x00000001L
#define CRYPT_USER_DEFAULT      0x00000002L
#define CRYPT_DELETE_DEFAULT    0x00000004L

/* Blob types */
#define SIMPLEBLOB              0x00000001L
#define PUBLICKEYBLOB           0x00000006L
#define PRIVATEKEYBLOB          0x00000007L
#define PLAINTEXTKEYBLOB        0x00000008L
#define OPAQUEKEYBLOB           0x00000009L
#define PUBLICKEYBLOBEX         0x0000000AL
#define SYMMETRICWRAPKEYBLOB    0x0000000BL
#if (NTDDI_VERSION >= 0x05020000)
    #define KEYSTATEBLOB        0x0000000CL
#endif

/* Algorithm types */
#define AT_KEYEXCHANGE  1
#define AT_SIGNATURE    2

/* Key parameters */
#define KP_IV                   1L
#define KP_SALT                 2L
#define KP_PADDING              3L
#define KP_MODE                 4L
#define KP_MODE_BITS            5L
#define KP_PERMISSIONS          6L
#define KP_ALGID                7L
#define KP_BLOCKLEN             8L
#define KP_KEYLEN               9L
#define KP_SALT_EX              10L
#define KP_P                    11L
#define KP_G                    12L
#define KP_Q                    13L
#define KP_X                    14L
#define KP_Y                    15L
#define KP_RA                   16L
#define KP_RB                   17L
#define KP_INFO                 18L
#define KP_EFFECTIVE_KEYLEN     19L
#define KP_SCHANNEL_ALG         20L
#define KP_CLIENT_RANDOM        21L
#define KP_SERVER_RANDOM        22L
#define KP_RP                   23L
#define KP_PRECOMP_MD5          24L
#define KP_PRECOMP_SHA          25L
#define KP_CERTIFICATE          26L
#define KP_CLEAR_KEY            27L
#define KP_PUB_EX_LEN           28L
#define KP_PUB_EX_VAL           29L
#define KP_KEYVAL               30L
#define KP_ADMIN_PIN            31L
#define KP_KEYEXCHANGE_PIN      32L
#define KP_SIGNATURE_PIN        33L
#define KP_PREHASH              34L
#if (NTDDI_VERSION >= 0x05020000)
    #define KP_ROUNDS           35L
#endif
#define KP_OAEP_PARAMS          36L
#define KP_CMS_KEY_INFO         37L
#define KP_CMS_DH_KEY_INFO      38L
#define KP_PUB_PARAMS           39L
#define KP_VERIFY_PARAMS        40L
#define KP_HIGHEST_VERSION      41L
#if (NTDDI_VERSION >= 0x05020000)
    #define KP_GET_USE_COUNT    42L
#endif
#define KP_PIN_ID               43L
#define KP_PIN_INFO             44L

/* Paddings values */
#define PKCS5_PADDING   1L
#define RANDOM_PADDING  2L
#define ZERO_PADDING    3L

/* Cryptographic modes */
#define CRYPT_MODE_CBC  1L
#define CRYPT_MODE_ECB  2L
#define CRYPT_MODE_OFB  3L
#define CRYPT_MODE_CFB  4L
#define CRYPT_MODE_CTS  5L

/* Cryptographic permissions */
#define CRYPT_ENCRYPT       0x00000001L
#define CRYPT_DECRYPT       0x00000002L
#define CRYPT_EXPORT        0x00000004L
#define CRYPT_READ          0x00000008L
#define CRYPT_WRITE         0x00000010L
#define CRYPT_MAC           0x00000020L
#define CRYPT_EXPORT_KEY    0x00000040L
#define CRYPT_IMPORT_KEY    0x00000080L
#if (NTDDI_VERSION >= 0x05010000)
    #define CRYPT_ARCHIVE   0x00000100L
#endif

/* Hash parameters */
#define HP_ALGID            0x00000001L
#define HP_HASHVAL          0x00000002L
#define HP_HASHSIZE         0x00000004L
#define HP_HMAC_INFO        0x00000005L
#define HP_TLS1PRF_LABEL    0x00000006L
#define HP_TLS1PRF_SEED     0x00000007L

/* Cryptographic return values */
#define CRYPT_FAILED    FALSE
#define CRYPT_SUCCEED   TRUE

/* Macros to test for success and failure */
#define RCRYPT_SUCCEEDED( x )   ((x) == CRYPT_SUCCEED)
#define RCRYPT_FAILED( x )      ((x) == CRYPT_FAILED)

/* Provider parameters */
#define PP_ENUMALGS                 1L
#define PP_ENUMCONTAINERS           2L
#define PP_IMPTYPE                  3L
#define PP_NAME                     4L
#define PP_VERSION                  5L
#define PP_CONTAINER                6L
#define PP_CHANGE_PASSWORD          7L
#define PP_KEYSET_SET_DESCR         8L
#define PP_CERTCHAIN                9L
#define PP_KEY_TYPE_SUBTYPE         10L
#define PP_PROVTYPE                 16L
#define PP_KEYSTORAGE               17L
#define PP_APPLI_CERT               18L
#define PP_SYM_KEYSIZE              19L
#define PP_SESSION_KEYSIZE          20L
#define PP_UI_PROMPT                21L
#define PP_ENUMALGS_EX              22L
#define PP_ENUMMANDROOTS            25L
#define PP_ENUMELECTROOTS           26L
#define PP_KEYSET_TYPE              27L
#define PP_ADMIN_PIN                31L
#define PP_KEYEXCHANGE_PIN          32L
#define PP_SIGNATURE_PIN            33L
#define PP_SIG_KEYSIZE_INC          34L
#define PP_KEYX_KEYSIZE_INC         35L
#define PP_UNIQUE_CONTAINER         36L
#define PP_SGC_INFO                 37L
#define PP_USE_HARDWARE_RNG         38L
#define PP_KEYSPEC                  39L
#define PP_ENUMEX_SIGNING_PROT      40L
#if (NTDDI_VERSION >= 0x05020000)
    #define PP_CRYPT_COUNT_KEY_USE  41L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define PP_USER_CERTSTORE       42L
    #define PP_SMARTCARD_READER     43L
    #define PP_SMARTCARD_GUID       45L
    #define PP_ROOT_CERTSTORE       46L
#endif

/* CryptGetProvParam() flags */
#define CRYPT_FIRST     1L
#define CRYPT_NEXT      2L
#define CRYPT_SGC_ENUM  4L

/* Provider implementation types */
#define CRYPT_IMPL_HARDWARE     1L
#define CRYPT_IMPL_SOFTWARE     2L
#define CRYPT_IMPL_MIXED        3L
#define CRYPT_IMPL_UNKNOWN      4L
#define CRYPT_IMPL_REMOVABLE    8L

/* Key storage types */
#define CRYPT_SEC_DESCR     0x00000001L
#define CRYPT_PSTORE        0x00000002L
#define CRYPT_UI_PROMPT     0x00000004L

/* Protocols */
#define CRYPT_FLAG_PCT1     0x00000001L
#define CRYPT_FLAG_SSL2     0x00000002L
#define CRYPT_FLAG_SSL3     0x00000004L
#define CRYPT_FLAG_TLS1     0x00000008L
#define CRYPT_FLAG_IPSEC    0x00000010L
#define CRYPT_FLAG_SIGNING  0x00000020L

/* SGC flags */
#define CRYPT_SGC       0x00000001L
#define CRYPT_FASTSGC   0x00000002L

/* Settable provider parameters */
#define PP_CLIENT_HWND                  1L
#define PP_CONTEXT_INFO                 11L
#define PP_KEYEXCHANGE_KEYSIZE          12L
#define PP_SIGNATURE_KEYSIZE            13L
#define PP_KEYEXCHANGE_ALG              14L
#define PP_SIGNATURE_ALG                15L
#define PP_DELETEKEY                    24L
#if (NTDDI_VERSION >= 0x06000000)
    #define PP_PIN_PROMPT_STRING        44L
    #define PP_SECURE_KEYEXCHANGE_PIN   47L
    #define PP_SECURE_SIGNATURE_PIN     48L
#endif

/* Provider types */
#define PROV_RSA_FULL           1L
#define PROV_RSA_SIG            2L
#define PROV_DSS                3L
#define PROV_FORTEZZA           4L
#define PROV_MS_EXCHANGE        5L
#define PROV_SSL                6L
#define PROV_RSA_SCHANNEL       12L
#define PROV_DSS_DH             13L
#define PROV_EC_ECDSA_SIG       14L
#define PROV_EC_ECNRA_SIG       15L
#define PROV_EC_ECDSA_FULL      16L
#define PROV_EC_ECNRA_FULL      17L
#define PROV_DH_SCHANNEL        18L
#define PROV_SPYRUS_LYNKS       20L
#define PROV_RNG                21L
#define PROV_INTEL_SEC          22L
#if (NTDDI_VERSION >= 0x05010000)
    #define PROV_REPLACE_OWF    23L
    #define PROV_RSA_AES        24L
#endif
#if (NTDDI_VERSION <= 0x05010000)
    #define PROV_STI_MER        7L
    #define PROV_STI_ACQ        8L
    #define PROV_STI_BRND       9L
    #define PROV_STI_ROOT       10L
    #define PROV_STI_ISS        11L
#endif

/* Friendly names of provider types */
#define MS_DEF_PROV_A               "Microsoft Base Cryptographic Provider v1.0"
#define MS_DEF_PROV_W               L"Microsoft Base Cryptographic Provider v1.0"
#define MS_ENHANCED_PROV_A          "Microsoft Enhanced Cryptographic Provider v1.0"
#define MS_ENHANCED_PROV_W          L"Microsoft Enhanced Cryptographic Provider v1.0"
#define MS_STRONG_PROV_A            "Microsoft Strong Cryptographic Provider"
#define MS_STRONG_PROV_W            L"Microsoft Strong Cryptographic Provider"
#define MS_DEF_RSA_SIG_PROV_A       "Microsoft RSA Signature Cryptographic Provider"
#define MS_DEF_RSA_SIG_PROV_W       L"Microsoft RSA Signature Cryptographic Provider"
#define MS_DEF_RSA_SCHANNEL_PROV_A  "Microsoft RSA SChannel Cryptographic Provider"
#define MS_DEF_RSA_SCHANNEL_PROV_W  L"Microsoft RSA SChannel Cryptographic Provider"
#define MS_DEF_DSS_PROV_A           "Microsoft Base DSS Cryptographic Provider"
#define MS_DEF_DSS_PROV_W           L"Microsoft Base DSS Cryptographic Provider"
#define MS_DEF_DSS_DH_PROV_A \
    "Microsoft Base DSS and Diffie-Hellman Cryptographic Provider"
#define MS_DEF_DSS_DH_PROV_W \
    L"Microsoft Base DSS and Diffie-Hellman Cryptographic Provider"
#define MS_ENH_DSS_DH_PROV_A \
    "Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider"
#define MS_ENH_DSS_DH_PROV_W \
    L"Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider"
#define MS_DEF_DH_SCHANNEL_PROV_A   "Microsoft DH SChannel Cryptographic Provider"
#define MS_DEF_DH_SCHANNEL_PROV_W   L"Microsoft DH SChannel Cryptographic Provider"
#define MS_SCARD_PROV_A             "Microsoft Base Smart Card Crypto Provider"
#define MS_SCARD_PROV_W             L"Microsoft Base Smart Card Crypto Provider"
#if (NTDDI_VERSION >= 0x05010000)
    #define MS_ENH_RSA_AES_PROV_A \
        "Microsoft Enhanced RSA and AES Cryptographic Provider"
    #define MS_ENH_RSA_AES_PROV_W \
        L"Microsoft Enhanced RSA and AES Cryptographic Provider"
    #define MS_ENH_RSA_AES_PROV_XP_A \
        "Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)"
    #define MS_ENH_RSA_AES_PROV_XP_W \
        L"Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)"
#endif
#ifdef UNICODE
    #define MS_DEF_PROV                 MS_DEF_PROV_W
    #define MS_ENHANCED_PROV            MS_ENHANCED_PROV_W
    #define MS_STRONG_PROV              MS_STRONG_PROV_W
    #define MS_DEF_RSA_SIG_PROV         MS_DEF_RSA_SIG_PROV_W
    #define MS_DEF_RSA_SCHANNEL_PROV    MS_DEF_RSA_SCHANNEL_PROV_W
    #define MS_DEF_DSS_PROV             MS_DEF_DSS_PROV_W
    #define MS_DEF_DSS_DH_PROV          MS_DEF_DSS_DH_PROV_W
    #define MS_ENH_DSS_DH_PROV          MS_ENH_DSS_DH_PROV_W
    #define MS_DEF_DH_SCHANNEL_PROV     MS_DEF_DH_SCHANNEL_PROV_W
    #define MS_SCARD_PROV               MS_SCARD_PROV_W
    #if (NTDDI_VERSION >= 0x05010000)
        #define MS_ENH_RSA_AES_PROV     MS_ENH_RSA_AES_PROV_W
        #define MS_ENH_RSA_AES_PROV_XP  MS_ENH_RSA_AES_PROV_XP_W
    #endif
#else
    #define MS_DEF_PROV                 MS_DEF_PROV_A
    #define MS_ENHANCED_PROV            MS_ENHANCED_PROV_A
    #define MS_STRONG_PROV              MS_STRONG_PROV_A
    #define MS_DEF_RSA_SIG_PROV         MS_DEF_RSA_SIG_PROV_A
    #define MS_DEF_RSA_SCHANNEL_PROV    MS_DEF_RSA_SCHANNEL_PROV_A
    #define MS_DEF_DSS_PROV             MS_DEF_DSS_PROV_A
    #define MS_DEF_DSS_DH_PROV          MS_DEF_DSS_DH_PROV_A
    #define MS_ENH_DSS_DH_PROV          MS_ENH_DSS_DH_PROV_A
    #define MS_DEF_DH_SCHANNEL_PROV     MS_DEF_DH_SCHANNEL_PROV_A
    #define MS_SCARD_PROV               MS_SCARD_PROV_A
    #if (NTDDI_VERSION >= 0x05010000)
        #define MS_ENH_RSA_AES_PROV     MS_ENH_RSA_AES_PROV_A
        #define MS_ENH_RSA_AES_PROV_XP  MS_ENH_RSA_AES_PROV_XP_A
    #endif
#endif

/* Registry key used for cryptography */
#define szKEY_CRYPTOAPI_PRIVATE_KEY_OPTIONS "Software\\Policies\\Microsoft\\Cryptography"

/* Registry values used for cryptography */
#define szFORCE_KEY_PROTECTION                      "ForceKeyProtection"
#define szKEY_CACHE_ENABLED                         "CachePrivateKeys"
#define szKEY_CACHE_SECONDS                         "PrivateKeyLifetimeSeconds"
#if (NTDDI_VERSION >= 0x05010000)
    #define szPRIV_KEY_CACHE_MAX_ITEMS              "PrivKeyCacheMaxItems"
    #define szPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS "PrivKeyCachePurgeIntervalSeconds"
#endif

/* Force key protection values */
#define dwFORCE_KEY_PROTECTION_DISABLED     0x00000000L
#define dwFORCE_KEY_PROTECTION_USER_SELECT  0x00000001L
#define dwFORCE_KEY_PROTECTION_HIGH         0x00000002L

/* Default values for various settings */
#if (NTDDI_VERSION >= 0x05010000)
    #define cPRIV_KEY_CACHE_MAX_ITEMS_DEFAULT               20
    #define cPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS_DEFAULT  864000
#endif

/* SChannel algorithm uses */
#define SCHANNEL_MAC_KEY    0x00000000L
#define SCHANNEL_ENC_KEY    0x00000001L

/* SChannel algorithm flags */
#define INTERNATIONAL_USAGE 0x00000001L

/* Cryptographic key limit request flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define CRYPTLIMIT_USING_PCT    0x00000001L
    #define CRYPTLIMIT_USING_SGC    0x00000002L
#endif

/* Object identifiers */
#define szOID_RSA                                   "1.2.840.113549"
#define szOID_PKCS                                  "1.2.840.113549.1"
#define szOID_RSA_HASH                              "1.2.840.113549.2"
#define szOID_RSA_ENCRYPT                           "1.2.840.113549.3"
#define szOID_PKCS_1                                "1.2.840.113549.1.1"
#define szOID_PKCS_2                                "1.2.840.113549.1.2"
#define szOID_PKCS_3                                "1.2.840.113549.1.3"
#define szOID_PKCS_4                                "1.2.840.113549.1.4"
#define szOID_PKCS_5                                "1.2.840.113549.1.5"
#define szOID_PKCS_6                                "1.2.840.113549.1.6"
#define szOID_PKCS_7                                "1.2.840.113549.1.7"
#define szOID_PKCS_8                                "1.2.840.113549.1.8"
#define szOID_PKCS_9                                "1.2.840.113549.1.9"
#define szOID_PKCS_10                               "1.2.840.113549.1.10"
#define szOID_PKCS_12                               "1.2.840.113549.1.12"
#define szOID_RSA_RSA                               "1.2.840.113549.1.1.1"
#define szOID_RSA_MD2RSA                            "1.2.840.113549.1.1.2"
#define szOID_RSA_MD4RSA                            "1.2.840.113549.1.1.3"
#define szOID_RSA_MD5RSA                            "1.2.840.113549.1.1.4"
#define szOID_RSA_SHA1RSA                           "1.2.840.113549.1.1.5"
#define szOID_RSA_SETOAEP_RSA                       "1.2.840.113549.1.1.6"
#define szOID_RSAES_OAEP                            "1.2.840.113549.1.1.7"
#define szOID_RSA_MGF1                              "1.2.840.113549.1.1.8"
#define szOID_RSA_PSPECIFIED                        "1.2.840.113549.1.1.9"
#define szOID_RSA_SSA_PSS                           "1.2.840.113549.1.1.10"
#define szOID_RSA_SHA256RSA                         "1.2.840.113549.1.1.11"
#define szOID_RSA_SHA384RSA                         "1.2.840.113549.1.1.12"
#define szOID_RSA_SHA512RSA                         "1.2.840.113549.1.1.13"
#define szOID_DH                                    "1.2.840.113549.1.3.1"
#define szOID_RSA_data                              "1.2.840.113549.1.7.1"
#define szOID_RSA_signedData                        "1.2.840.113549.1.7.2"
#define szOID_RSA_envelopedData                     "1.2.840.113549.1.7.3"
#define szOID_RSA_signEnvData                       "1.2.840.113549.1.7.4"
#define szOID_RSA_digestedData                      "1.2.840.113549.1.7.5"
#define szOID_RSA_hashedData                        "1.2.840.113549.1.7.5"
#define szOID_RSA_encryptedData                     "1.2.840.113549.1.7.6"
#define szOID_RSA_emailAddr                         "1.2.840.113549.1.9.1"
#define szOID_RSA_unstructName                      "1.2.840.113549.1.9.2"
#define szOID_RSA_contentType                       "1.2.840.113549.1.9.3"
#define szOID_RSA_messageDigest                     "1.2.840.113549.1.9.4"
#define szOID_RSA_signingTime                       "1.2.840.113549.1.9.5"
#define szOID_RSA_counterSign                       "1.2.840.113549.1.9.6"
#define szOID_RSA_challengePwd                      "1.2.840.113549.1.9.7"
#define szOID_RSA_unstructAddr                      "1.2.840.113549.1.9.8"
#define szOID_RSA_extCertAttrs                      "1.2.840.113549.1.9.9"
#define szOID_RSA_certExtensions                    "1.2.840.113549.1.9.14"
#define szOID_RSA_SMIMECapabilities                 "1.2.840.113549.1.9.15"
#define szOID_RSA_preferSignedData                  "1.2.840.113549.1.9.15.1"
#define szOID_TIMESTAMP_TOKEN                       "1.2.840.113549.1.9.16.1.4"
#define szOID_RFC3161_counterSign                   "1.3.6.1.4.1.311.3.3.1"
#define szOID_RSA_SMIMEalg                          "1.2.840.113549.1.9.16.3"
#define szOID_RSA_SMIMEalgESDH                      "1.2.840.113549.1.9.16.3.5"
#define szOID_RSA_SMIMEalgCMS3DESwrap               "1.2.840.113549.1.9.16.3.6"
#define szOID_RSA_SMIMEalgCMSRC2wrap                "1.2.840.113549.1.9.16.3.7"
#define szOID_RSA_MD2                               "1.2.840.113549.2.2"
#define szOID_RSA_MD4                               "1.2.840.113549.2.4"
#define szOID_RSA_MD5                               "1.2.840.113549.2.5"
#define szOID_RSA_RC2CBC                            "1.2.840.113549.3.2"
#define szOID_RSA_RC4                               "1.2.840.113549.3.4"
#define szOID_RSA_DES_EDE3_CBC                      "1.2.840.113549.3.7"
#define szOID_RSA_RC5_CBCPad                        "1.2.840.113549.3.9"
#define szOID_ANSI_X942                             "1.2.840.10046"
#define szOID_ANSI_X942_DH                          "1.2.840.10046.2.1"
#define szOID_X957                                  "1.2.840.10040"
#define szOID_X957_DSA                              "1.2.840.10040.4.1"
#define szOID_X947_SHA1DSA                          "1.2.840.10040.4.3"
#define szOID_ECC_PUBLIC_KEY                        "1.2.840.10045.2.1"
#define szOID_ECC_CURVE_P256                        "1.2.840.10045.3.1.7"
#define szOID_ECC_CURVE_P384                        "1.3.132.0.34"
#define szOID_ECC_CURVE_P521                        "1.3.132.0.35"
#define szOID_ECDSA_SHA1                            "1.2.840.10045.4.1"
#define szOID_ECDSA_SPECIFIED                       "1.2.840.10045.4.3"
#define szOID_ECDSA_SHA256                          "1.2.840.10045.4.3.2"
#define szOID_ECDSA_SHA384                          "1.2.840.10045.4.3.3"
#define szOID_ECDSA_SHA512                          "1.2.840.10045.4.3.4"
#define szOID_NIST_AES128_CBC                       "2.16.840.1.101.3.4.1.2"
#define szOID_NIST_AES192_CBC                       "2.16.840.1.101.3.4.1.22"
#define szOID_NIST_AES256_CBC                       "2.16.840.1.101.3.4.1.42"
#define szOID_NIST_AES128_WRAP                      "2.16.840.1.101.3.4.1.5"
#define szOID_NIST_AES192_WRAP                      "2.16.840.1.101.3.4.1.25"
#define szOID_NIST_AES256_WRAP                      "2.16.840.1.101.3.4.1.45"
#define szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF         "1.3.133.16.840.63.0.2"
#define szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF       "1.3.132.1.11.1"
#define szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF       "1.3.132.1.11.2"
#define szOID_DS                                    "2.5"
#define szOID_DSALG                                 "2.5.8"
#define szOID_DSALG_CRPT                            "2.5.8.1"
#define szOID_DSALG_HASH                            "2.5.8.2"
#define szOID_DSALG_SIGN                            "2.5.8.3"
#define szOID_DSALG_RSA                             "2.5.8.1.1"
#define szOID_OIW                                   "1.3.14"
#define szOID_OIWSEC                                "1.3.14.3.2"
#define szOID_OIWSEC_md4RSA                         "1.3.14.3.2.2"
#define szOID_OIWSEC_md5RSA                         "1.3.14.3.2.3"
#define szOID_OIWSEC_md4RSA2                        "1.3.14.3.2.4"
#define szOID_OIWSEC_desECB                         "1.3.14.3.2.6"
#define szOID_OIWSEC_desCBC                         "1.3.14.3.2.7"
#define szOID_OIWSEC_desOFB                         "1.3.14.3.2.8"
#define szOID_OIWSEC_desCFB                         "1.3.14.3.2.9"
#define szOID_OIWSEC_desMAC                         "1.3.14.3.2.10"
#define szOID_OIWSEC_rsaSign                        "1.3.14.3.2.11"
#define szOID_OIWSEC_dsa                            "1.3.14.3.2.12"
#define szOID_OIWSEC_shaDSA                         "1.3.14.3.2.13"
#define szOID_OIWSEC_mdc2RSA                        "1.3.14.3.2.14"
#define szOID_OIWSEC_shaRSA                         "1.3.14.3.2.15"
#define szOID_OIWSEC_dhCommMod                      "1.3.14.3.2.16"
#define szOID_OIWSEC_desEDE                         "1.3.14.3.2.17"
#define szOID_OIWSEC_sha                            "1.3.14.3.2.18"
#define szOID_OIWSEC_mdc2                           "1.3.14.3.2.19"
#define szOID_OIWSEC_dsaComm                        "1.3.14.3.2.20"
#define szOID_OIWSEC_dsaCommSHA                     "1.3.14.3.2.21"
#define szOID_OIWSEC_rsaXchg                        "1.3.14.3.2.22"
#define szOID_OIWSEC_keyHashSeal                    "1.3.14.3.2.23"
#define szOID_OIWSEC_md2RSASign                     "1.3.14.3.2.24"
#define szOID_OIWSEC_md5RSASign                     "1.3.14.3.2.25"
#define szOID_OIWSEC_sha1                           "1.3.14.3.2.26"
#define szOID_OIWSEC_dsaSHA1                        "1.3.14.3.2.27"
#define szOID_OIWSEC_dsaCommSHA1                    "1.3.14.3.2.28"
#define szOID_OIWSEC_sha1RSASign                    "1.3.14.3.2.29"
#define szOID_OIWDIR                                "1.3.14.7.2"
#define szOID_OIWDIR_CRPT                           "1.3.14.7.2.1"
#define szOID_OIWDIR_HASH                           "1.3.14.7.2.2"
#define szOID_OIWDIR_SIGN                           "1.3.14.7.2.3"
#define szOID_OIWDIR_md2                            "1.3.14.7.2.2.1"
#define szOID_OIWDIR_md2RSA                         "1.3.14.7.2.3.1"
#define szOID_INFOSEC                               "2.16.840.1.101.2.1"
#define szOID_INFOSEC_sdnsSignature                 "2.16.840.1.101.2.1.1.1"
#define szOID_INFOSEC_mosaicSignature               "2.16.840.1.101.2.1.1.2"
#define szOID_INFOSEC_sdnsConfidentiality           "2.16.840.1.101.2.1.1.3"
#define szOID_INFOSEC_mosaicConfidentiality         "2.16.840.1.101.2.1.1.4"
#define szOID_INFOSEC_sdnsIntegrity                 "2.16.840.1.101.2.1.1.5"
#define szOID_INFOSEC_mosaicIntegrity               "2.16.840.1.101.2.1.1.6"
#define szOID_INFOSEC_sdnsTokenProtection           "2.16.840.1.101.2.1.1.7"
#define szOID_INFOSEC_mosaicTokenProtection         "2.16.840.1.101.2.1.1.8"
#define szOID_INFOSEC_sdnsKeyManagement             "2.16.840.1.101.2.1.1.9"
#define szOID_INFOSEC_mosaicKeyManagement           "2.16.840.1.101.2.1.1.10"
#define szOID_INFOSEC_sdnsKMandSig                  "2.16.840.1.101.2.1.1.11"
#define szOID_INFOSEC_mosaicKMandSig                "2.16.840.1.101.2.1.1.12"
#define szOID_INFOSEC_SuiteASignature               "2.16.840.1.101.2.1.1.13"
#define szOID_INFOSEC_SuiteAConfidentiality         "2.16.840.1.101.2.1.1.14"
#define szOID_INFOSEC_SuiteAIntegrity               "2.16.840.1.101.2.1.1.15"
#define szOID_INFOSEC_SuiteATokenProtection         "2.16.840.1.101.2.1.1.16"
#define szOID_INFOSEC_SuiteAKeyManagement           "2.16.840.1.101.2.1.1.17"
#define szOID_INFOSEC_SuiteAKMandSig                "2.16.840.1.101.2.1.1.18"
#define szOID_INFOSEC_mosaicUpdatedSig              "2.16.840.1.101.2.1.1.19"
#define szOID_INFOSEC_mosaicKMandUpdSig             "2.16.840.1.101.2.1.1.20"
#define szOID_INFOSEC_mosaicUpdatedInteg            "2.16.840.1.101.2.1.1.21"
#define szOID_NIST_sha256                           "2.16.840.1.101.3.4.2.1"
#define szOID_NIST_sha384                           "2.16.840.1.101.3.4.2.2"
#define szOID_NIST_sha512                           "2.16.840.1.101.3.4.2.3"
#define szOID_COMMON_NAME                           "2.5.4.3"
#define szOID_SUR_NAME                              "2.5.4.4"
#define szOID_DEVICE_SERIAL_NUMBER                  "2.5.4.5"
#define szOID_COUNTRY_NAME                          "2.5.4.6"
#define szOID_LOCALITY_NAME                         "2.5.4.7"
#define szOID_STATE_OR_PROVINCE_NAME                "2.5.4.8"
#define szOID_STREET_ADDRESS                        "2.5.4.9"
#define szOID_ORGANIZATION_NAME                     "2.5.4.10"
#define szOID_ORGANIZATIONAL_UNIT_NAME              "2.5.4.11"
#define szOID_TITLE                                 "2.5.4.12"
#define szOID_DESCRIPTION                           "2.5.4.13"
#define szOID_SEARCH_GUIDE                          "2.5.4.14"
#define szOID_BUSINESS_CATEGORY                     "2.5.4.15"
#define szOID_POSTAL_ADDRESS                        "2.5.4.16"
#define szOID_POSTAL_CODE                           "2.5.4.17"
#define szOID_POST_OFFICE_BOX                       "2.5.4.18"
#define szOID_PHYSICAL_DELIVERY_OFFICE_NAME         "2.5.4.19"
#define szOID_TELEPHONE_NUMBER                      "2.5.4.20"
#define szOID_TELEX_NUMBER                          "2.5.4.21"
#define szOID_TELETEXT_TERMINAL_IDENTIFIER          "2.5.4.22"
#define szOID_FACSIMILE_TELEPHONE_NUMBER            "2.5.4.23"
#define szOID_X21_ADDRESS                           "2.5.4.24"
#define szOID_INTERNATIONAL_ISDN_NUMBER             "2.5.4.25"
#define szOID_REGISTERED_ADDRESS                    "2.5.4.26"
#define szOID_DESTINATION_INDICATOR                 "2.5.4.27"
#define szOID_PREFERRED_DELIVERY_METHOD             "2.5.4.28"
#define szOID_PRESENTATION_ADDRESS                  "2.5.4.29"
#define szOID_SUPPORTED_APPLICATION_CONTEXT         "2.5.4.30"
#define szOID_MEMBER                                "2.5.4.31"
#define szOID_OWNER                                 "2.5.4.32"
#define szOID_ROLE_OCCUPANT                         "2.5.4.33"
#define szOID_SEE_ALSO                              "2.5.4.34"
#define szOID_USER_PASSWORD                         "2.5.4.35"
#define szOID_USER_CERTIFICATE                      "2.5.4.36"
#define szOID_CA_CERTIFICATE                        "2.5.4.37"
#define szOID_AUTHORITY_REVOCATION_LIST             "2.5.4.38"
#define szOID_CERTIFICATE_REVOCATION_LIST           "2.5.4.39"
#define szOID_CROSS_CERTIFICATE_PAIR                "2.5.4.40"
#define szOID_GIVEN_NAME                            "2.5.4.42"
#define szOID_INITIALS                              "2.5.4.43"
#define szOID_DN_QUALIFIER                          "2.5.4.46"
#define szOID_DOMAIN_COMPONENT                      "0.9.2342.19200300.100.1.25"
#define szOID_PKCS_12_FRIENDLY_NAME_ATTR            "1.2.840.113549.1.9.20"
#define szOID_PKCS_12_LOCAL_KEY_ID                  "1.2.840.113549.1.9.21"
#define szOID_PKCS_12_KEY_PROVIDER_NAME_ATTR        "1.3.6.1.4.1.311.17.1"
#define szOID_LOCAL_MACHINE_KEYSET                  "1.3.6.1.4.1.311.17.2"
#define szOID_PKCS_12_EXTENDED_ATTRIBUTES           "1.3.6.1.4.1.311.17.3"
#define szOID_KEYID_RDN                             "1.3.6.1.4.1.311.10.7.1"
#define szOID_EV_RDN_LOCALE                         "1.3.6.1.4.1.311.60.2.1.1"
#define szOID_EV_RDN_STATE_OR_PROVINCE              "1.3.6.1.4.1.311.60.2.1.2"
#define szOID_EV_RDN_COUNTRY                        "1.3.6.1.4.1.311.60.2.1.3"
#define szOID_AUTHORITY_KEY_IDENTIFIER              "2.5.29.1"
#define szOID_KEY_ATTRIBUTES                        "2.5.29.2"
#define szOID_CERT_POLICIES_95                      "2.5.29.3"
#define szOID_KEY_USAGE_RESTRICTION                 "2.5.29.4"
#define szOID_SUBJECT_ALT_NAME                      "2.5.29.7"
#define szOID_ISSUER_ALT_NAME                       "2.5.29.8"
#define szOID_BASIC_CONSTRAINTS                     "2.5.29.10"
#define szOID_KEY_USAGE                             "2.5.29.15"
#define szOID_PRIVATEKEY_USAGE_PERIOD               "2.5.29.16"
#define szOID_BASIC_CONSTRAINTS2                    "2.5.29.19"
#define szOID_CERT_POLICIES                         "2.5.29.32"
#define szOID_ANY_CERT_POLICY                       "2.5.29.32.0"
#define szOID_INHIBIT_ANY_POLICY                    "2.5.29.54"
#define szOID_AUTHORITY_KEY_IDENTIFIER2             "2.5.29.35"
#define szOID_SUBJECT_KEY_IDENTIFIER                "2.5.29.14"
#define szOID_SUBJECT_ALT_NAME2                     "2.5.29.17"
#define szOID_ISSUER_ALT_NAME2                      "2.5.29.18"
#define szOID_CRL_REASON_CODE                       "2.5.29.21"
#define szOID_REASON_CODE_HOLD                      "2.5.29.23"
#define szOID_CRL_DIST_POINTS                       "2.5.29.31"
#define szOID_ENHANCED_KEY_USAGE                    "2.5.29.37"
#define szOID_ANY_ENHANCED_KEY_USAGE                "2.5.29.37.0"
#define szOID_CRL_NUMBER                            "2.5.29.20"
#define szOID_DELTA_CRL_INDICATOR                   "2.5.29.27"
#define szOID_ISSUING_DIST_POINT                    "2.5.29.28"
#define szOID_FRESHEST_CRL                          "2.5.29.46"
#define szOID_NAME_CONSTRAINTS                      "2.5.29.30"
#define szOID_POLICY_MAPPINGS                       "2.5.29.33"
#define szOID_LEGACY_POLICY_MAPPINGS                "2.5.29.5"
#define szOID_POLICY_CONSTRAINTS                    "2.5.29.36"
#define szOID_RENEWAL_CERTIFICATE                   "1.3.6.1.4.1.311.13.1"
#define szOID_ENROLLMENT_NAME_VALUE_PAIR            "1.3.6.1.4.1.311.13.2.1"
#define szOID_ENROLLMENT_CSP_PROVIDER               "1.3.6.1.4.1.311.13.2.2"
#define szOID_OS_VERSION                            "1.3.6.1.4.1.311.13.2.3"
#define szOID_ENROLLMENT_AGENT                      "1.3.6.1.4.1.311.20.2.1"
#define szOID_PKIX                                  "1.3.6.1.5.5.7"
#define szOID_PKIX_PE                               "1.3.6.1.5.5.7.1"
#define szOID_AUTHORITY_INFO_ACCESS                 "1.3.6.1.5.5.7.1.1"
#define szOID_SUBJECT_INFO_ACCESS                   "1.3.6.1.5.5.7.1.11"
#define szOID_BIOMETRIC_EXT                         "1.3.6.1.5.5.7.1.2"
#define szOID_QC_STATEMENTS_EXT                     "1.3.6.1.5.5.7.1.3"
#define szOID_LOGOTYPE_EXT                          "1.3.6.1.5.5.7.1.12"
#define szOID_CERT_EXTENSIONS                       "1.3.6.1.4.1.311.2.1.14"
#define szOID_NEXT_UPDATE_LOCATION                  "1.3.6.1.4.1.311.10.2"
#define szOID_REMOVE_CERTIFICATE                    "1.3.6.1.4.1.311.10.8.1"
#define szOID_CROSS_CERT_DIST_POINTS                "1.3.6.1.4.1.311.10.9.1"
#define szOID_CTL                                   "1.3.6.1.4.1.311.10.1"
#define szOID_SORTED_CTL                            "1.3.6.1.4.1.311.10.1.1"
#define szOID_SERIALIZED                            "1.3.6.1.4.1.311.10.3.3.1"
#define szOID_NT_PRINCIPAL_NAME                     "1.3.6.1.4.1.311.20.2.3"
#define szOID_PRODUCT_UPDATE                        "1.3.6.1.4.1.311.31.1"
#define szOID_ANY_APPLICATION_POLICY                "1.3.6.1.4.1.311.10.12.1"
#define szOID_AUTO_ENROLL_CTL_USAGE                 "1.3.6.1.4.1.311.20.1"
#define szOID_ENROLL_CERTTYPE_EXTENSION             "1.3.6.1.4.1.311.20.2"
#define szOID_CERT_MANIFOLD                         "1.3.6.1.4.1.311.20.3"
#define szOID_CERTSRV_CA_VERSION                    "1.3.6.1.4.1.311.21.1"
#define szOID_CERTSRV_PREVIOUS_CERT_HASH            "1.3.6.1.4.1.311.21.2"
#define szOID_CRL_VIRTUAL_BASE                      "1.3.6.1.4.1.311.21.3"
#define szOID_CRL_NEXT_PUBLISH                      "1.3.6.1.4.1.311.21.4"
#define szOID_KP_CA_EXCHANGE                        "1.3.6.1.4.1.311.21.5"
#define szOID_KP_KEY_RECOVERY_AGENT                 "1.3.6.1.4.1.311.21.6"
#define szOID_CERTIFICATION_TEMPLATE                "1.3.6.1.4.1.311.21.7"
#define szOID_ENTERPRISE_OID_ROOT                   "1.3.6.1.4.1.311.21.8"
#define szOID_RDN_DUMMY_SIGNER                      "1.3.6.1.4.1.311.21.9"
#define szOID_APPLICATION_CERT_POLICIES             "1.3.6.1.4.1.311.21.10"
#define szOID_APPLICATION_POLICY_MAPPINGS           "1.3.6.1.4.1.311.21.11"
#define szOID_APPLICATION_POLICY_CONSTRAINTS        "1.3.6.1.4.1.311.21.12"
#define szOID_ARCHIVED_KEY_ATTR                     "1.3.6.1.4.1.311.21.13"
#define szOID_CRL_SELF_CDP                          "1.3.6.1.4.1.311.21.14"
#define szOID_REQUIRE_CERT_CHAIN_POLICY             "1.3.6.1.4.1.311.21.15"
#define szOID_ARCHIVED_KEY_CERT_HASH                "1.3.6.1.4.1.311.21.16"
#define szOID_ISSUED_CERT_HASH                      "1.3.6.1.4.1.311.21.17"
#define szOID_DS_EMAIL_REPLICATION                  "1.3.6.1.4.1.311.21.19"
#define szOID_REQUEST_CLIENT_INFO                   "1.3.6.1.4.1.311.21.20"
#define szOID_ENCRYPTED_KEY_HASH                    "1.3.6.1.4.1.311.21.21"
#define szOID_CERTSRV_CROSSCA_VERSION               "1.3.6.1.4.1.311.21.22"
#define szOID_NTDS_REPLICATION                      "1.3.6.1.4.1.311.25.1"
#define szOID_SUBJECT_DIR_ATTRS                     "2.5.29.9"
#define szOID_PKIX_KP                               "1.3.6.1.5.5.7.3"
#define szOID_PKIX_KP_SERVER_AUTH                   "1.3.6.1.5.5.7.3.1"
#define szOID_PKIX_KP_CLIENT_AUTH                   "1.3.6.1.5.5.7.3.2"
#define szOID_PKIX_KP_CODE_SIGNING                  "1.3.6.1.5.5.7.3.3"
#define szOID_PKIX_KP_EMAIL_PROTECTION              "1.3.6.1.5.5.7.3.4"
#define szOID_PKIX_KP_IPSEC_END_SYSTEM              "1.3.6.1.5.5.7.3.5"
#define szOID_PKIX_KP_IPSEC_TUNNEL                  "1.3.6.1.5.5.7.3.6"
#define szOID_PKIX_KP_IPSEC_USER                    "1.3.6.1.5.5.7.3.7"
#define szOID_PKIX_KP_TIMESTAMP_SIGNING             "1.3.6.1.5.5.7.3.8"
#define szOID_PKIX_KP_OCSP_SIGNING                  "1.3.6.1.5.5.7.3.9"
#define szOID_PKIX_OCSP_NOCHECK                     "1.3.6.1.5.5.7.48.1.5"
#define szOID_PKIX_OCSP_NONCE                       "1.3.6.1.5.5.7.48.1.2"
#define szOID_IPSEC_KP_IKE_INTERMEDIATE             "1.3.6.1.5.5.8.2.2"
#define szOID_PKINIT_KP_KDC                         "1.3.6.1.5.2.3.5"
#define szOID_KP_CTL_USAGE_SIGNING                  "1.3.6.1.4.1.311.10.3.1"
#define szOID_KP_TIME_STAMP_SIGNING                 "1.3.6.1.4.1.311.10.3.2"
#define szOID_SERVER_GATED_CRYPTO                   "1.3.6.1.4.1.311.10.3.3"
#define szOID_SGC_NETSCAPE                          "2.16.840.1.113730.4.1"
#define szOID_KP_EFS                                "1.3.6.1.4.1.311.10.3.4"
#define szOID_EFS_RECOVERY                          "1.3.6.1.4.1.311.10.3.4.1"
#define szOID_WHQL_CRYPTO                           "1.3.6.1.4.1.311.10.3.5"
#define szOID_NT5_CRYPTO                            "1.3.6.1.4.1.311.10.3.6"
#define szOID_OEM_WHQL_CRYPTO                       "1.3.6.1.4.1.311.10.3.7"
#define szOID_EMBEDDED_NT_CRYPTO                    "1.3.6.1.4.1.311.10.3.8"
#define szOID_ROOT_LIST_SIGNER                      "1.3.6.1.4.1.311.10.3.9"
#define szOID_KP_QUALIFIED_SUBORDINATION            "1.3.6.1.4.1.311.10.3.10"
#define szOID_KP_KEY_RECOVERY                       "1.3.6.1.4.1.311.10.3.11"
#define szOID_KP_DOCUMENT_SIGNING                   "1.3.6.1.4.1.311.10.3.12"
#define szOID_KP_LIFETIME_SIGNING                   "1.3.6.1.4.1.311.10.3.13"
#define szOID_KP_MOBILE_DEVICE_SOFTWARE             "1.3.6.1.4.1.311.10.3.14"
#define szOID_KP_SMART_DISPLAY                      "1.3.6.1.4.1.311.10.3.15"
#define szOID_KP_CSP_SIGNATURE                      "1.3.6.1.4.1.311.10.3.16"
#define szOID_DRM                                   "1.3.6.1.4.1.311.10.5.1"
#define szOID_DRM_INDIVIDUALIZATION                 "1.3.6.1.4.1.311.10.5.2"
#define szOID_LICENSES                              "1.3.6.1.4.1.311.10.6.1"
#define szOID_LICENSE_SERVER                        "1.3.6.1.4.1.311.10.6.2"
#define szOID_KP_SMARTCARD_LOGON                    "1.3.6.1.4.1.311.20.2.2"
#define szOID_KP_KERNEL_MODE_CODE_SIGNING           "1.3.6.1.4.1.311.61.1.1"
#define szOID_REVOKED_LIST_SIGNER                   "1.3.6.1.4.1.311.10.3.19"
#define szOID_YESNO_TRUST_ATTR                      "1.3.6.1.4.1.311.10.4.1"
#define szOID_PKIX_POLICY_QUALIFIER_CPS             "1.3.6.1.5.5.7.2.1"
#define szOID_PKIX_POLICY_QUALIFIER_USERNOTICE      "1.3.6.1.5.5.7.2.2"
#define szOID_ROOT_PROGRAM_FLAGS                    "1.3.6.1.4.1.311.60.1.1"
#define szOID_CERT_POLICIES_95_QUALIFIER1           "2.16.840.1.113733.1.7.1.1"
#define szOID_PKIX_ACC_DESCR                        "1.3.6.1.5.5.7.48"
#define szOID_PKIX_OCSP                             "1.3.6.1.5.5.7.48.1"
#define szOID_PKIX_CA_ISSUERS                       "1.3.6.1.5.5.7.48.2"
#define szOID_PKIX_TIME_STAMPING                    "1.3.6.1.5.5.7.48.3"
#define szOID_PKIX_CA_REPOSITORY                    "1.3.6.1.5.5.7.48.5"
#define szOID_QC_EU_COMPLIANCE                      "0.4.0.1862.1.1"
#define szOID_QC_SSCD                               "0.4.0.1862.1.4"
#define szOID_VERSION_PRIVATE_6_9                   "2.16.840.1.113733.1.6.9"
#define szOID_VERSION_ONSITE_JURISDICTION_HASH      "2.16.840.1.113733.1.6.11"
#define szOID_VERSION_BITSTRING_6_13                "2.16.840.1.113733.1.6.13"
#define szOID_VERSION_ISS_STRONG_CRYPTO             "2.16.840.1.113733.1.8.1"
#define szOID_NETSCAPE                              "2.16.840.1.113730"
#define szOID_NETSCAPE_CERT_EXTENSION               "2.16.840.1.113730.1"
#define szOID_NETSCAPE_CERT_TYPE                    "2.16.840.1.113730.1.1"
#define szOID_NETSCAPE_BASE_URL                     "2.16.840.1.113730.1.2"
#define szOID_NETSCAPE_REVOCATION_URL               "2.16.840.1.113730.1.3"
#define szOID_NETSCAPE_CA_REVOCATION_URL            "2.16.840.1.113730.1.4"
#define szOID_NETSCAPE_CERT_RENEWAL_URL             "2.16.840.1.113730.1.7"
#define szOID_NETSCAPE_CA_POLICY_URL                "2.16.840.1.113730.1.8"
#define szOID_NETSCAPE_SSL_SERVER_NAME              "2.16.840.1.113730.1.12"
#define szOID_NETSCAPE_COMMENT                      "2.16.840.1.113730.1.13"
#define szOID_NETSCAPE_DATA_TYPE                    "2.16.840.1.113730.2"
#define szOID_NETSCAPE_CERT_SEQUENCE                "2.16.840.1.113730.2.5"
#define szOID_CT_PKI_DATA                           "1.3.6.1.5.5.7.12.2"
#define szOID_CT_PKI_RESPONSE                       "1.3.6.1.5.5.7.12.3"
#define szOID_PKIX_NO_SIGNATURE                     "1.3.6.1.5.5.7.6.2"
#define szOID_CMC                                   "1.3.6.1.5.5.7.7"
#define szOID_CMC_STATUS_INFO                       "1.3.6.1.5.5.7.7.1"
#define szOID_CMC_IDENTIFICATION                    "1.3.6.1.5.5.7.7.2"
#define szOID_CMC_IDENTITY_PROOF                    "1.3.6.1.5.5.7.7.3"
#define szOID_CMC_DATA_RETURN                       "1.3.6.1.5.5.7.7.4"
#define szOID_CMC_TRANSACTION_ID                    "1.3.6.1.5.5.7.7.5"
#define szOID_CMC_SENDER_NONCE                      "1.3.6.1.5.5.7.7.6"
#define szOID_CMC_RECIPIENT_NONCE                   "1.3.6.1.5.5.7.7.7"
#define szOID_CMC_ADD_EXTENSIONS                    "1.3.6.1.5.5.7.7.8"
#define szOID_CMC_ENCRYPTED_POP                     "1.3.6.1.5.5.7.7.9"
#define szOID_CMC_DECRYPTED_POP                     "1.3.6.1.5.5.7.7.10"
#define szOID_CMC_LRA_POP_WITNESS                   "1.3.6.1.5.5.7.7.11"
#define szOID_CMC_GET_CERT                          "1.3.6.1.5.5.7.7.15"
#define szOID_CMC_GET_CRL                           "1.3.6.1.5.5.7.7.16"
#define szOID_CMC_REVOKE_REQUEST                    "1.3.6.1.5.5.7.7.17"
#define szOID_CMC_REG_INFO                          "1.3.6.1.5.5.7.7.18"
#define szOID_CMC_RESPONSE_INFO                     "1.3.6.1.5.5.7.7.19"
#define szOID_CMC_QUERY_PENDING                     "1.3.6.1.5.5.7.7.21"
#define szOID_CMC_ID_POP_LINK_RANDOM                "1.3.6.1.5.5.7.7.22"
#define szOID_CMC_ID_POP_LINK_WITNESS               "1.3.6.1.5.5.7.7.23"
#define szOID_CMC_ID_CONFIRM_CERT_ACCEPTANCE        "1.3.6.1.5.5.7.7.24"
#define szOID_CMC_ADD_ATTRIBUTES                    "1.3.6.1.4.1.311.10.10.1"
#define szOID_LOYALTY_OTHER_LOGOTYPE                "1.3.6.1.5.5.7.20.1"
#define szOID_BACKGROUND_OTHER_LOGOTYPE             "1.3.6.1.5.5.7.20.2"
#define szOID_PKIX_OCSP_BASIC_SIGNED_RESPONSE       "1.3.6.1.5.5.7.48.1.1"
#define szOID_PKCS_7_DATA                           "1.2.840.113549.1.7.1"
#define szOID_PKCS_7_SIGNED                         "1.2.840.113549.1.7.2"
#define szOID_PKCS_7_ENVELOPED                      "1.2.840.113549.1.7.3"
#define szOID_PKCS_7_SIGNEDANDENVELOPED             "1.2.840.113549.1.7.4"
#define szOID_PKCS_7_DIGESTED                       "1.2.840.113549.1.7.5"
#define szOID_PKCS_7_ENCRYPTED                      "1.2.840.113549.1.7.6"
#define szOID_PKCS_9_CONTENT_TYPE                   "1.2.840.113549.1.9.3"
#define szOID_PKCS_9_MESSAGE_DIGEST                 "1.2.840.113549.1.9.4"
#define szOID_PKCS_12_PbeIds                        "1.2.840.113549.1.12.1"
#define szOID_PKCS_12_pbeWithSHA1And128BitRC4       "1.2.840.113549.1.12.1.1"
#define szOID_PKCS_12_pbeWithSHA1And40BitRC4        "1.2.840.113549.1.12.1.2"
#define szOID_PKCS_12_pbeWithSHA1And3KeyTripleDES   "1.2.840.113549.1.12.1.3"
#define szOID_PKCS_12_pbeWithSHA1And2KeyTripleDES   "1.2.840.113549.1.12.1.4"
#define szOID_PKCS_12_pbeWithSHA1And128BitRC2       "1.2.840.113549.1.12.1.5"
#define szOID_PKCS_12_pbeWithSHA1And40BitRC2        "1.2.840.113549.1.12.1.6"

/* Certificate Relative Distinguished Name (RDN) attribute value types */
#define CERT_RDN_ANY_TYPE           0
#define CERT_RDN_ENCODED_BLOB       1
#define CERT_RDN_OCTET_STRING       2
#define CERT_RDN_NUMERIC_STRING     3
#define CERT_RDN_PRINTABLE_STRING   4
#define CERT_RDN_TELETEX_STRING     5
#define CERT_RDN_T61_STRING         5
#define CERT_RDN_VIDEOTEX_STRING    6
#define CERT_RDN_IA5_STRING         7
#define CERT_RDN_GRAPHIC_STRING     8
#define CERT_RDN_VISIBLE_STRING     9
#define CERT_RDN_ISO646_STRING      9
#define CERT_RDN_GENERAL_STRING     10
#define CERT_RDN_UNIVERSAL_STRING   11
#define CERT_RDN_INT4_STRING        11
#define CERT_RDN_BMP_STRING         12
#define CERT_RDN_UNICODE_STRING     12
#define CERT_RDN_UTF8_STRING        13

/* Certificate RDN attribute value types flags */
#define CERT_RDN_TYPE_MASK                  0x000000FFL
#define CERT_RDN_FLAGS_MASK                 0xFF000000L
#define CERT_RDN_ENABLE_T61_UNICODE_FLAG    0x80000000L
#define CERT_RDN_ENABLE_UTF8_UNICODE_FLAG   0x20000000L
#define CERT_RDN_FORCE_UTF8_UNICODE_FLAG    0x10000000L
#define CERT_RDN_DISABLE_CHECK_TYPE_FLAG    0x40000000L
#define CERT_RDN_DISABLE_IE4_UTF8_FLAG      0x01000000L
#define CERT_RDN_ENABLE_PUNYCODE_FLAG       0x02000000L

/* Macro to check if an RDN is a charcter string */
#define IS_CERT_RDN_CHAR_STRING( x ) \
    ((x) & CERT_RDN_TYPE_MASK) >= CERT_RDN_NUMERIC_STRING)

/* Certificate object identifiers */
#define CERT_RSA_PUBLIC_KEY_OBJID           szOID_RSA_RSA
#define CERT_DEFAULT_OID_PUBLIC_KEY_SIGN    szOID_RSA_RSA
#define CERT_DEFAULT_OID_PUBLIC_KEY_XCHG    szOID_RSA_RSA

/* Certificate information version numbers */
#define CERT_V1 0L
#define CERT_V2 1L
#define CERT_V3 2L

/* Certificate information flags */
#define CERT_INFO_VERSION_FLAG                  1L
#define CERT_INFO_SERIAL_NUMBER_FLAG            2L
#define CERT_INFO_SIGNATURE_ALGORITHM_FLAG      3L
#define CERT_INFO_ISSUER_FLAG                   4L
#define CERT_INFO_NOT_BEFORE_FLAG               5L
#define CERT_INFO_NOT_AFTER_FLAG                6L
#define CERT_INFO_SUBJECT_FLAG                  7L
#define CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG  8L
#define CERT_INFO_ISSUER_UNIQUE_ID_FLAG         9L
#define CERT_INFO_SUBJECT_UNIQUE_ID_FLAG        10L
#define CERT_INFO_EXTENSION_FLAG                11L

/* Certificate Revocation List (CRL) information version numbers */
#define CRL_V1  0L
#define CRL_V2  1L

/* Certificate bundle item types */
#define CERT_BUNDLE_CERTIFICATE 0L
#define CERT_BUNDLE_CRL         1L

/* Certificate request version numbers */
#define CERT_REQUEST_V1 0L

/* Certificate Keygen request version numbers */
#define CERT_KEYGEN_REQUEST_V1  0L

/* Certificate Trust List (CTL) information version numbers */
#define CTL_V1  0L

/* Macros to get certificate and message encoding types */
#define CERT_ENCODING_TYPE_MASK     0x0000FFFFL
#define CMSG_ENCODING_TYPE_MASK     0xFFFF0000L
#define GET_CERT_ENCODING_TYPE( x ) (x & CERT_ENCODING_TYPE_MASK)
#define GET_CMSG_ENCODING_TYPE( x ) (x & CMSG_ENCODING_TYPE_MASK)

/* Certificate encoding types */
#define CRYPT_ASN_ENCODING      0x00000001L
#define CRYPT_NDR_ENCODING      0x00000002L
#define X509_ASN_ENCODING       0x00000001L
#define X509_NDR_ENCODING       0x00000002L

/* Message encoding types */
#define PKCS_7_ASN_ENCODING     0x00010000L
#define PKCS_7_NDR_ENCODING     0x00020000L

/* CryptFormatObject() format string types */
#define CRYPT_FORMAT_STR_MULTI_LINE 0x00000001L
#define CRYPT_FORMAT_STR_NO_HEX     0x00000002L

/* CryptFormatObject() format types */
#define CRYPT_FORMAT_SIMPLE         0x00000001L
#define CRYPT_FORMAT_X509           0x00000002L
#define CRYPT_FORMAT_OID            0x00000004L
#define CRYPT_FORMAT_RDN_SEMICOLON  0x00000100L
#define CRYPT_FORMAT_RDN_CRLF       0x00000200L
#define CRYPT_FORMAT_RDN_UNQUOTE    0x00000400L
#define CRYPT_FORMAT_RDN_REVERSE    0x00000800L
#define CRYPT_FORMAT_COMMA          0x00001000L
#define CRYPT_FORMAT_SEMICOLON      CRYPT_FORMAT_RDN_SEMICOLON
#define CRYPT_FORMAT_CRLF           CRYPT_FORMAT_RDN_CRLF

/* CryptEncodeObject() flags */
#define CRYPT_ENCODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG            0x00000008L
#define CRYPT_ENCODE_ALLOC_FLAG                                 0x00008000L
#define CRYPT_UNICODE_NAME_ENCODE_ENABLE_T61_UNICODE_FLAG \
    CERT_RDN_ENABLE_T61_UNICODE_FLAG
#define CRYPT_UNICODE_NAME_ENCODE_ENABLE_UTF8_UNICODE_FLAG \
    CERT_RDN_ENABLE_UTF8_UNICODE_FLAG
#define CRYPT_UNICODE_NAME_ENCODE_FORCE_UTF8_UNICODE_FLAG \
    CERT_RDN_FORCE_UTF8_UNICODE_FLAG
#define CRYPT_UNICODE_NAME_ENCODE_DISABLE_CHECK_TYPE_FLAG \
    CERT_RDN_DISABLE_CHECK_TYPE_FLAG
#define CRYPT_SORTED_CTL_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG  0x00010000L
#define CRYPT_ENCODE_ENABLE_PUNYCODE_FLAG                       0x00020000L

/* CryptDecodeObject() flags */
#define CRYPT_DECODE_NOCOPY_FLAG                        0x00000001L
#define CRYPT_DECODE_TO_BE_SIGNED_FLAG                  0x00000002L
#define CRYPT_DECODE_SHARE_OID_STRING_FLAG              0x00000004L
#define CRYPT_DECODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG    0x00000008L
#define CRYPT_DECODE_ALLOC_FLAG                         0x00008000L
#define CRYPT_UNICODE_NAME_DECODE_DISABLE_IE4_UTF8_FLAG \
    CERT_RDN_DISABLE_IE4_UTF8_FLAG
#define CRYPT_DECODE_ENABLE_PUNYCODE_FLAG               0x02000000L

/* Data structure identifiers for CryptEncodeObject(), etc. */
#define CRYPT_ENCODE_DECODE_NONE                ((LPCSTR)0)
#define X509_CERT                               ((LPCSTR)1)
#define X509_CERT_TO_BE_SIGNED                  ((LPCSTR)2)
#define X509_CERT_CRL_TO_BE_SIGNED              ((LPCSTR)3)
#define X509_CERT_REQUEST_TO_BE_SIGNED          ((LPCSTR)4)
#define X509_EXTENSIONS                         ((LPCSTR)5)
#define X509_NAME_VALUE                         ((LPCSTR)6)
#define X509_NAME                               ((LPCSTR)7)
#define X509_PUBLIC_KEY_INFO                    ((LPCSTR)8)
#define X509_AUTHORITY_KEY_ID                   ((LPCSTR)9)
#define X509_KEY_ATTRIBUTES                     ((LPCSTR)10)
#define X509_KEY_USAGE_RESTRICTION              ((LPCSTR)11)
#define X509_ALTERNATE_NAME                     ((LPCSTR)12)
#define X509_BASIC_CONSTRAINTS                  ((LPCSTR)13)
#define X509_KEY_USAGE                          ((LPCSTR)14)
#define X509_BASIC_CONSTRAINTS2                 ((LPCSTR)15)
#define X509_CERT_POLICIES                      ((LPCSTR)16)
#define PKCS_UTC_TIME                           ((LPCSTR)17)
#define PKCS_TIME_REQUEST                       ((LPCSTR)18)
#define RSA_CSP_PUBLICKEYBLOB                   ((LPCSTR)19)
#define X509_UNICODE_NAME                       ((LPCSTR)20)
#define X509_KEYGEN_REQUEST_TO_BE_SIGNED        ((LPCSTR)21)
#define PKCS_ATTRIBUTE                          ((LPCSTR)22)
#define PKCS_CONTENT_INFO_SEQUENCE_OF_ANY       ((LPCSTR)23)
#define X509_UNICODE_NAME_VALUE                 ((LPCSTR)24)
#define X509_ANY_STRING                         X509_NAME_VALUE
#define X509_UNICODE_ANY_STRING                 X509_UNICODE_NAME_VALUE
#define X509_OCTET_STRING                       ((LPCSTR)25)
#define X509_BITS                               ((LPCSTR)26)
#define X509_INTEGER                            ((LPCSTR)27)
#define X509_MULTI_BYTE_INTEGER                 ((LPCSTR)28)
#define X509_ENUMERATED                         ((LPCSTR)29)
#define X509_CHOICE_OF_TIME                     ((LPCSTR)30)
#define X509_AUTHORITY_KEY_ID2                  ((LPCSTR)31)
#define X509_AUTHORITY_INFO_ACCESS              ((LPCSTR)32)
#define X509_SUBJECT_INFO_ACCESS                X509_AUTHORITY_INFO_ACCESS
#define X509_CRL_REASON_CODE                    X509_ENUMERATED
#define PKCS_CONTENT_INFO                       ((LPCSTR)33)
#define X509_SEQUENCE_OF_ANY                    ((LPCSTR)34)
#define X509_CRL_DIST_POINTS                    ((LPCSTR)35)
#define X509_ENHANCED_KEY_USAGE                 ((LPCSTR)36)
#define PKCS_CTL                                ((LPCSTR)37)
#define X509_MULTI_BYTE_UINT                    ((LPCSTR)38)
#define X509_DSS_PUBLICKEY                      X509_MULTI_BYTE_UINT
#define X509_DSS_PARAMETERS                     ((LPCSTR)39)
#define X509_DSS_SIGNATURE                      ((LPCSTR)40)
#define PKCS_RC2_CBC_PARAMETERS                 ((LPCSTR)41)
#define PKCS_SMIME_CAPABILITIES                 ((LPCSTR)42)
#define X509_QC_STATEMENTS_EXT                  ((LPCSTR)42)
#define PKCS_RSA_PRIVATE_KEY                    ((LPCSTR)43)
#define PKCS_PRIVATE_KEY_INFO                   ((LPCSTR)44)
#define PKCS_ENCRYPTED_PRIVATE_KEY_INFO         ((LPCSTR)45)
#define X509_PKIX_POLICY_QUALIFIER_USERNOTICE   ((LPCSTR)46)
#define X509_DH_PUBLICKEY                       X509_MULTI_BYTE_UINT
#define X509_DH_PARAMETERS                      ((LPCSTR)47)
#define PKCS_ATTRIBUTES                         ((LPCSTR)48)
#define PKCS_SORTED_CTL                         ((LPCSTR)49)
#define X509_ECC_SIGNATURE                      ((LPCSTR)47)
#define X942_DH_PARAMETERS                      ((LPCSTR)50)
#define X509_BITS_WITHOUT_TRAILING_ZEROES       ((LPCSTR)51)
#define X942_OTHER_INFO                         ((LPCSTR)52)
#define X509_CERT_PAIR                          ((LPCSTR)53)
#define X509_ISSUING_DIST_POINT                 ((LPCSTR)54)
#define X509_NAME_CONSTRAINTS                   ((LPCSTR)55)
#define X509_POLICY_MAPPINGS                    ((LPCSTR)56)
#define X509_POLICY_CONSTRAINTS                 ((LPCSTR)57)
#define X509_CROSS_CERT_DIST_POINTS             ((LPCSTR)58)
#define CMC_DATA                                ((LPCSTR)59)
#define CMC_RESPONSE                            ((LPCSTR)60)
#define CMC_STATUS                              ((LPCSTR)61)
#define CMC_ADD_EXTENSIONS                      ((LPCSTR)62)
#define CMC_ADD_ATTRIBUTES                      ((LPCSTR)63)
#define X509_CERTIFICATE_TEMPLATE               ((LPCSTR)64)
#define OCSP_SIGNED_REQUEST                     ((LPCSTR)65)
#define OCSP_REQUEST                            ((LPCSTR)66)
#define OCSP_RESPONSE                           ((LPCSTR)67)
#define OCSP_BASIC_SIGNED_RESPONSE              ((LPCSTR)68)
#define OCSP_BASIC_RESPONSE                     ((LPCSTR)69)
#define X509_LOGOTYPE_EXT                       ((LPCSTR)70)
#define X509_BIOMETRIC_EXT                      ((LPCSTR)71)
#define CNG_RSA_PUBLIC_KEY_BLOB                 ((LPCSTR)72)
#define X509_OBJECT_IDENTIFIER                  ((LPCSTR)73)
#define X509_ALGORITHM_IDENTIFIER               ((LPCSTR)74)
#define PKCS_RSA_SSA_PSS_PARAMETERS             ((LPCSTR)75)
#define PKCS_RSAES_OAEP_PARAMETERS              ((LPCSTR)76)
#define ECC_CMS_SHARED_INFO                     ((LPCSTR)77)
#define TIMESTAMP_REQUEST                       ((LPCSTR)78)
#define TIMESTAMP_RESPONSE                      ((LPCSTR)79)
#define TIMESTAMP_INFO                          ((LPCSTR)80)
#define X509_CERT_BUNDLE                        ((LPCSTR)81)
#define PKCS7_SIGNER_INFO                       ((LPCSTR)500)
#define CMS_SIGNER_INFO                         ((LPCSTR)501)

/* Certificate root program flags */
#define CERT_ROOT_PROGRAM_FLAG_ORG          0x80
#define CERT_ROOT_PROGRAM_FLAG_LSC          0x40
#define CERT_ROOT_PROGRAM_FLAG_SUBJECT_LOGO 0x20
#define CERT_ROOT_PROGRAM_FLAG_OU           0x10
#define CERT_ROOT_PROGRAM_FLAG_ADDRESS      0x08

/* Error location constants and macros */
#define CERT_UNICODE_RDN_ERR_INDEX_MASK     0x000003FFL
#define CERT_UNICODE_RDN_ERR_INDEX_SHIFT    22
#define CERT_UNICODE_ATTR_ERR_INDEX_MASK    0x0000003FL
#define CERT_UNICODE_ATTR_ERR_INDEX_SHIFT   16
#define CERT_UNICODE_VALUE_ERR_INDEX_MASK   0x0000FFFFL
#define CERT_UNICODE_VALUE_ERR_INDEX_SHIFT  0
#define GET_CERT_UNICODE_RDN_ERR_INDEX( x ) \
    ((x >> CERT_UNICODE_RDN_ERR_INDEX_SHIFT) & CERT_UNICODE_RDN_ERR_INDEX_MASK)
#define GET_CERT_UNICODE_ATTR_ERR_INDEX( x ) \
    ((x >> CERT_UNICODE_ATTR_ERR_INDEX_SHIFT) & CERT_UNICODE_ATTR_ERR_INDEX_MASK)
#define GET_CERT_UNICODE_VALUE_ERR_INDEX( x ) \
    ((x >> CERT_UNICODE_VALUE_ERR_INDEX_SHIFT) & CERT_UNICODE_VALUE_ERR_INDEX_MASK)

/* Key usages */
#define CERT_DIGITAL_SIGNATURE_KEY_USAGE    0x80
#define CERT_NON_REPUDIATION_KEY_USAGE      0x40
#define CERT_KEY_ENCIPHERMENT_KEY_USAGE     0x20
#define CERT_DATA_ENCIPHERMENT_KEY_USAGE    0x10
#define CERT_KEY_AGREEMENT_KEY_USAGE        0x08
#define CERT_KEY_CERT_SIGN_KEY_USAGE        0x04
#define CERT_OFFLINE_CRL_SIGN_KEY_USAGE     0x02
#define CERT_CRL_SIGN_KEY_USAGE             0x02
#define CERT_ENCIPHER_ONLY_KEY_USAGE        0x01
#define CERT_DECIPHER_ONLY_KEY_USAGE        0x80

/* Certificate alternate name types */
#define CERT_ALT_NAME_OTHER_NAME        1L
#define CERT_ALT_NAME_RFC822_NAME       2L
#define CERT_ALT_NAME_DNS_NAME          3L
#define CERT_ALT_NAME_X400_ADDRESS      4L
#define CERT_ALT_NAME_DIRECTORY_NAME    5L
#define CERT_ALT_NAME_EDI_PARTY_NAME    6L
#define CERT_ALT_NAME_URL               7L
#define CERT_ALT_NAME_IP_ADDRESS        8L
#define CERT_ALT_NAME_REGISTERED_ID     9L

/* Certificate alternate name error location constants and macros */
#define CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK  0x000000FFL
#define CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT 16
#define CERT_ALT_NAME_VALUE_ERR_INDEX_MASK  0x0000FFFFL
#define CERT_ALT_NAME_VALUE_ERR_INDEX_SHIFT 0
#define GET_CERT_ALT_NAME_ENTRY_ERR_INDEX( x ) \
    ((x >> CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT) & CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK)
#define GET_CERT_ALT_NAME_VALUE_ERR_INDEX( x ) \
    ((x >> CERT_ALT_NAME_VALUE_ERR_INDEX_SHIFT) & CERT_ALT_NAME_VALUE_ERR_INDEX_MASK)

/* Certificate subject flags */
#define CERT_CA_SUBJECT_FLAG            0x80
#define CERT_END_ENTITY_SUBJECT_FLAG    0x40

/* Certificate Revocation List (CRL) reason codes */
#define CRL_REASON_UNSPECIFIED              0
#define CRL_REASON_KEY_COMPROMISE           1
#define CRL_REASON_CA_COMPROMISE            2
#define CRL_REASON_AFFILIATION_CHANGE       3
#define CRL_REASON_SUPERSEDED               4
#define CRL_REASON_CESSATION_OF_OPERATION   5
#define CRL_REASON_CERTIFICATE_HOLD         6
#define CRL_REASON_REMOVE_FROM_CRL          8

/* CRL distribution point name types */
#define CRL_DIST_POINT_NO_NAME          0
#define CRL_DIST_POINT_FULL_NAME        1
#define CRL_DIST_POINT_ISSUER_RDN_NAME  2

/* CRL reason flags */
#define CRL_REASON_UNUSED_FLAG                  0x80
#define CRL_REASON_KEY_COMPROMISE_FLAG          0x40
#define CRL_REASON_CA_COMPROMISE_FLAG           0x20
#define CRL_REASON_AFFILIATION_CHANGE_FLAG      0x10
#define CRL_REASON_SUPERSEDED_FLAG              0x08
#define CRL_REASON_CESSATION_OF_OPERATION_FLAG  0x04
#define CRL_REASON_CERTIFICATE_HOLD_FLAG        0x02

/* CRL distribution point error location constants and macros */
#define CRL_DIST_POINT_ERR_INDEX_MASK       0x0000007FL
#define CRL_DIST_POINT_ERR_INDEX_SHIFT      24
#define CRL_DIST_POINT_ERR_CRL_ISSUER_BIT   0x80000000L
#define GET_CRL_DIST_POINT_ERR_INDEX( x ) \
    ((x >> CRL_DIST_POINT_ERR_INDEX_SHIFT) & CRL_DIST_POINT_ERR_INDEX_MASK)
#define IS_CRL_DIST_POINT_ERR_CRL_ISSUER( x ) \
    ((x & CRL_DIST_POINT_ERR_CRL_ISSUER_BIT) != 0)

/* Cross certificate distribution point error location constants and macros */
#define CROSS_CERT_DIST_POINT_ERR_INDEX_MASK    0x000000FFL
#define CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT   24
#define GET_CROSS_CERT_DIST_POINT_ERR_INDEX( x ) \
    ((x >> CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT) & CROSS_CERT_DIST_POINT_ERR_INDEX_MASK)

/* Certificate excluded subtree bit */
#define CERT_EXCLUDED_SUBTREE_BIT       0x80000000L
#define IS_CERT_EXCLUDED_SUBTREE( x ) \
    ((x & CERT_EXCLUDED_SUBTREE_BIT) != 0)

/* Sorted Certificate Trust List (CTL) extension offsets */
#define SORTED_CTL_EXT_FLAGS_OFFSET         (0 * 4)
#define SORTED_CTL_EXT_COUNT_OFFSET         (1 * 4)
#define SORTED_CTL_EXT_MAX_COLLISION_OFFSET (2 * 4)
#define SORTED_CTL_EXT_HASH_BUCKET_OFFSET   (3 * 4)

/* Sorted CTL flags */
#define SORTED_CTL_EXT_HASHED_SUBJECT_IDENTIFIER_FLAG   0x00000001L

/* Certificate DSS signature constants */
#define CERT_DSS_R_LEN                          20
#define CERT_DSS_S_LEN                          20
#define CERT_DSS_SIGNATURE_LEN                  (CERT_DSS_R_LEN + CERTT_DSS_S_LEN)
#define CERT_MAX_ASN_ENCODED_DSS_SIGNATURE_LEN  (2 + 2 * (2 + 20 + 1))

/* X942 byte lengths */
#define CRYPT_X942_COUNTER_BYTE_LENGTH      4
#define CRYPT_X942_KEY_LENGTH_BYTE_LENGTH   4
#define CRYPT_X942_PUB_INFO_BYTE_LENGTH     (512 / 8)

/* ECC byte lengths */
#define CRYPT_ECC_CMS_SHARED_INFO_SUPPPUBINFO_BYTE_LENGTH   4

/* Cryptographic RC2 version numbers */
#define CRYPT_RC2_40BIT_VERSION     160
#define CRYPT_RC2_56BIT_VERSION     52
#define CRYPT_RC2_64BIT_VERSION     120
#define CRYPT_RC2_128BIT_VERSION    58

/* RSA SSA PSS trailer field value */
#define PKCS_RSA_SSA_PSS_TRAILER_FIELD_BC   1L

/* Netscape certificate types */
#define NETSCAPE_SSL_CLIENT_AUTH_CERT_TYPE  0x80
#define NETSCAPE_SSL_SERVER_AUTH_CERT_TYPE  0x40
#define NETSCAPE_SMIME_CERT_TYPE            0x20
#define NETSCAPE_SIGN_CERT_TYPE             0x10
#define NETSCAPE_SSL_CA_CERT_TYPE           0x04
#define NETSCAPE_SMIME_CA_CERT_TYPE         0x02
#define NETSCAPE_SIGN_CA_CERT_TYPE          0x01

/* CMC tagged request choices */
#define CMC_TAGGED_CERT_REQUEST_CHOICE  1L

/* CMC other information choices */
#define CMC_OTHER_INFO_NO_CHOICE    0L
#define CMC_OTHER_INFO_FAIL_CHOICE  1L
#define CMC_OTHER_INFO_PEND_CHOICE  2L

/* CMC status values */
#define CMC_STATUS_SUCCESS          0L
#define CMC_STATUS_FAILED           2L
#define CMC_STATUS_PENDING          3L
#define CMC_STATUS_NO_SUPPORT       4L
#define CMC_STATUS_CONFIRM_REQUEST  5L

/* CMC failure codes */
#define CMC_FAIL_BAD_ALG            0L
#define CMC_FAIL_BAD_MESSAGE_CHECK  1L
#define CMC_FAIL_BAD_REQUEST        2L
#define CMC_FAIL_BAD_TIME           3L
#define CMC_FAIL_BAD_CERT_ID        4L
#define CMC_FAIL_UNSUPPORTED_EXT    5L
#define CMC_FAIL_MUST_ARCHIVE_KEYS  6L
#define CMC_FAIL_BAD_IDENTITY       7L
#define CMC_FAIL_POP_REQUIRED       8L
#define CMC_FAIL_POP_FAILED         9L
#define CMC_FAIL_NO_KEY_REUSE       10L
#define CMC_FAIL_INTERNAL_CA_ERROR  11L
#define CMC_FAIL_TRY_LATER          12L

/* Certificate logotype image information choices */
#define CERT_LOGOTYPE_GRAY_SCALE_IMAGE_INFO_CHOICE          1L
#define CERT_LOGOTYPE_COLOR_IMAGE_INFO_CHOICE               2L
#define CERT_LOGOTYPE_NO_IMAGE_RESOLUTION_CHOICE            0L
#define CERT_LOGOTYPE_BITS_IMAGE_RESOLUTION_CHOICE          1L
#define CERT_LOGOTYPE_TABLE_SIZE_IMAGE_RESOLUTION_CHOICE    2L

/* Certificate logotype information choices */
#define CERT_LOGOTYPE_DIRECT_INFO_CHOICE    1L
#define CERT_LOGOTYPE_INDIRECT_INFO_CHOICE  2L

/* Certificate biometric data choices */
#define CERT_BIOMETRIC_PREDEFINED_DATA_CHOICE   1L
#define CERT_BIOMETRIC_OID_DATA_CHOICE          2L

/* Certificate biometric types */
#define CERT_BIOMETRIC_PICTURE_TYPE     0L
#define CERT_BIOMETRIC_SIGNATURE_TYPE   1L

/* Online Certificate Status Protocol (OCSP) request version numbers */
#define OCSP_REQUEST_V1 0L

/* OCSP reponse status values */
#define OCSP_SUCCESSFUL_RESPONSE        0L
#define OCSP_MALFORMED_REQUEST_RESPONSE 1L
#define OCSP_INTERNAL_ERROR_RESPONSE    2L
#define OCSP_TRY_LATER_RESPONSE         3L
#define OCSP_SIG_REQUIRED_RESPONSE      5L
#define OCSP_UNAUTHORIZED_RESPONSE      6L

/* OCSP basic response status values */
#define OCSP_BASIC_GOOD_CERT_STATUS     0L
#define OCSP_BASIC_REVOKED_CERT_STATUS  1L
#define OCSP_BASIC_UNKNOWN_CERT_STATUS  2L

/* OCSP basic response version numbers */
#define OCSP_BASIC_RESPONSE_V1  0L

/* OCSP basic responder identifier choices */
#define OCSP_BASIC_BY_NAME_RESPONDER_ID 1L
#define OCSP_BASIC_BY_KEY_RESPONDER_ID  2L

/* Object Identifier (OID) functions */
#define CRYPT_OID_ENCODE_OBJECT_FUNC        "CryptDllEncodeObject"
#define CRYPT_OID_DECODE_OBJECT_FUNC        "CryptDllDecodeObject"
#define CRYPT_OID_ENCODE_OBJECT_EX_FUNC     "CryptDllEncodeObjectEx"
#define CRYPT_OID_DECODE_OBJECT_EX_FUNC     "CryptDllDecodeObjectEx"
#define CRYPT_OID_CREATE_COM_OBJECT_FUNC    "CryptDllCreateCOMObject"
#define CRYPT_OID_VERIFY_REVOCATION_FUNC    "CertDllVerifyRevocation"
#define CRYPT_OID_VERIFY_CTL_USAGE_FUNC     "CertDllVerifyCTLUsage"
#define CRYPT_OID_FORMAT_OBJECT_FUNC        "CryptDllFormatObject"
#define CRYPT_OID_FIND_OID_INFO_FUNC        "CryptDllFindOIDInfo"
#define CRYPT_OID_FIND_LOCALIZED_NAME_FUNC  "CryptDllFindLocalizedName"

/* OID function registry keys and values */
#define CRYPT_OID_REG_PATH                      "Software\\Microsoft\\Cryptography\\OID"
#define CRYPT_OID_REG_ENCODING_TYPE_PREFIX      "EncodingType"
#define CRYPT_OID_REG_DLL_VALUE_NAME            L"Dll"
#define CRYPT_OID_REG_FUNC_NAME_VALUE_NAME      L"FuncName"
#define CRYPT_OID_REG_FUNC_NAME_VALUE_NAME_A    "FuncName"
#define CRYPT_OID_REG_FLAGS_VALUE_NAME          L"CryptFlags"

/* Default OID */
#define CRYPT_DEFAULT_OID   "DEFAULT"

/* CryptInstallOIDFunctionAddress() flags */
#define CRYPT_INSTALL_OID_FUNC_BEFORE_FLAG  0x00000001L

/* CryptGetOIDFunctionAddress() flags */
#define CRYPT_GET_INSTALLED_OID_FUNC_FLAG   0x00000001L

/* CryptRegisterDefaultOIDFunction() indices */
#define CRYPT_REGISTER_FIRST_INDEX  0x00000000L
#define CRYPT_REGISTER_LAST_INDEX   0xFFFFFFFFL

/* CryptEnumOIDFunction() flags */
#define CRYPT_MATCH_ANY_ENCODING_TYPE   0xFFFFFFFFL

/* Special algorithm identifier values */
#define CALG_OID_INFO_CNG_ONLY      0xFFFFFFFFL
#define CALG_OID_INFO_PARAMETERS    0xFFFFFFFEL

/* Macro to check for special algorithm identifier values */
#define IS_SPECIAL_OID_INFO_ALGID( x )  (x >= CALG_OID_INFO_PARAMETERS)

/* Special CNG algorithms */
#define CRYPT_OID_INFO_HASH_PARAMETERS_ALGORITHM        L"CryptOIDInfoHashParameters"
#define CRYPT_OID_INFO_ECC_PARAMETERS_ALGORITHM         L"CryptOIDInfoECCParameters"
#define CRYPT_OID_INFO_MGF1_PARAMETERS_ALGORITHM        L"CryptOIDInfoMgf1Parameters"
#define CRYPT_OID_INFO_NO_SIGN_ALGORITHM                L"CryptOIDInfoNoSign"
#define CRYPT_OID_INFO_OAEP_PARAMETERS_ALGORITHM        L"CryptOIDInfoOAEPParameters"
#define CRYPT_OID_INFO_ECC_WRAP_PARAMETERS_ALGORITHM    L"CryptOIDInfoECCWrapParameters"

/* OID group identifiers */
#define CRYPT_HASH_ALG_OID_GROUP_ID     1L
#define CRYPT_ENCRYPT_ALG_OID_GROUP_ID  2L
#define CRYPT_PUBKEY_ALG_OID_GROUP_ID   3L
#define CRYPT_SIGN_ALG_OID_GROUP_ID     4L
#define CRYPT_RDN_ATTR_OID_GROUP_ID     5L
#define CRYPT_EXT_OR_ATTR_OID_GROUP_ID  6L
#define CRYPT_ENHKEY_USAGE_OID_GROUP_ID 7L
#define CRYPT_POLICY_OID_GROUP_ID       8L
#define CRYPT_TEMPLATE_OID_GROUP_ID     9L
#define CRYPT_KDF_OID_GROUP_ID          10L
#define CRYPT_LAST_OID_GROUP_ID         10L
#define CRYPT_FIRST_ALG_OID_GROUP_ID    CRYPT_HASH_ALG_OID_GROUP_ID
#define CRYPT_LAST_ALG_OID_GROUP_ID     CRYPT_SIGN_ALG_OID_GROUP_ID

/* Public key algorithm flags */
#define CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG     0x00000001L
#define CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG    0x00000002L
#define CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG       0x00000004L
#define CRYPT_OID_PUBKEY_SIGN_ONLY_FLAG             0x80000000L
#define CRYPT_OID_PUBKEY_ENCRYPT_ONLY_FLAG          0x40000000L

/* CryptFindOIDInfo() key types */
#define CRYPT_OID_INFO_OID_KEY          1L
#define CRYPT_OID_INFO_NAME_KEY         2L
#define CRYPT_OID_INFO_ALGID_KEY        3L
#define CRYPT_OID_INFO_SIGN_KEY         4L
#define CRYPT_OID_INFO_CNG_ALGID_KEY    5L
#define CRYPT_OID_INFO_CNG_SIGN_KEY     6L

/* CryptFindOIDInfo() key type flags */
#define CRYPT_OID_INFO_OID_KEY_FLAGS_MASK       0xFFFF0000L
#define CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAG     0x80000000L
#define CRYPT_OID_INFO_PUBKEY_ENCRYPT_KEY_FLAG  0x40000000L

/* CryptFindOIDInfo() group identifier flags */
#define CRYPT_OID_DISABLE_SEARCH_DS_FLAG    0x80000000L
#ifdef CRYPT_OID_INFO_HAS_EXTRA_FIELDS
    #define CRYPT_OID_PREFER_CNG_ALGID_FLAG 0x40000000L
#endif

/* Constants to handle bit lengths */
#define CRYPT_OID_INFO_OID_GROUP_BIT_LEN_MASK   0x0FFF0000L
#define CRYPT_OID_INFO_OID_GROUP_BIT_LEN_SHIFT  16

/* CryptRegisterOIDInfo() flags */
#define CRYPT_INSTALL_OID_INFO_BEFORE_FLAG  0x00000001L

/* Localized name special values */
#define CRYPT_LOCALIZED_NAME_ENCODING_TYPE  0
#define CRYPT_LOCALIZED_NAME_OID            "LocalizedNames"

/* Cryptographic message types */
#define CMSG_DATA                   1L
#define CMSG_SIGNED                 2L
#define CMSG_ENVELOPED              3L
#define CMSG_SIGNED_AND_ENVELOPED   4L
#define CMSG_HASHED                 5L
#define CMSG_ENCRYPTED              6L

/* Cryptographic message type flags */
#define CMSG_ALL_FLAGS                  0xFFFFFFFFL
#define CMSG_DATA_FLAG                  (1 << CMSG_DATA)
#define CMSG_SIGNED_FLAG                (1 << CMSG_SIGNED)
#define CMSG_ENVELOPED_FLAG             (1 << CMSG_ENVELOPED)
#define CMSG_SIGNED_AND_ENVELOPED_FLAG  (1 << CMSG_SIGNED_AND_ENVELOPED)
#define CMSG_HASHED_FLAG                (1 << CMSG_HASHED)
#define CMSG_ENCRYPTED_FLAG             (1 << CMSG_ENCRYPTED)

/* Certificate identifier choices */
#define CERT_ID_ISSUER_SERIAL_NUMBER    1L
#define CERT_ID_KEY_IDENTIFIER          2L
#define CERT_ID_SHA1_HASH               3L

/* Cryptographic message key agreement key choices */
#define CMSG_KEY_AGREE_EPHEMERAL_KEY_CHOICE 1L
#define CMSG_KEY_AGREE_STATIC_KEY_CHOICE    2L

/* Cryptographic message mail list key choices */
#define CMSG_MAIL_LIST_HANDLE_KEY_CHOICE    1L

/* Cryptographic message recipient choices */
#define CMSG_KEY_TRANS_RECIPIENT    1L
#define CMSG_KEY_AGREE_RECIPIENT    2L
#define CMSG_MAIL_LIST_RECIPIENT    3L

/* Cryptographic message SP3-compatible flags */
#define CMSG_SP3_COMPATIBLE_ENCRYPT_FLAGS   0x80000000L

/* Cryptographic message RC4 flags */
#define CMSG_RC4_NO_SALT_FLAG   0x80000000L

/* Cryptographic message special value */
#define CMSG_INDEFINITE_LENGTH  0xFFFFFFFFL

/* Cryptographic message flags */
#define CMSG_BARE_CONTENT_FLAG              0x00000001L
#define CMSG_LENGTH_ONLY_FLAG               0x00000002L
#define CMSG_DETACHED_FLAG                  0x00000004L
#define CMSG_AUTHENTICATED_ATTRIBUTES_FLAG  0x00000008L
#define CMSG_CONTENTS_OCTETS_FLAG           0x00000010L
#define CMSG_MAX_LENGTH_FLAG                0x00000020L
#define CMSG_CMS_ENCAPSULATED_CONTENT_FLAG  0x00000040L
#define CMSG_CRYPT_RELEASE_CONTEXT_FLAG     0x00008000L

/* Cryptographic message parameter types */
#define CMSG_TYPE_PARAM                     1L
#define CMSG_CONTENT_PARAM                  2L
#define CMSG_BARE_CONTENT_PARAM             3L
#define CMSG_INNER_CONTENT_TYPE_PARAM       4L
#define CMSG_SIGNER_COUNT_PARAM             5L
#define CMSG_SIGNER_INFO_PARAM              6L
#define CMSG_SIGNER_CERT_INFO_PARAM         7L
#define CMSG_SIGNER_HASH_ALGORITHM_PARAM    8L
#define CMSG_SIGNER_AUTH_ATTR_PARAM         9L
#define CMSG_SIGNER_UNAUTH_ATTR_PARAM       10L
#define CMSG_CERT_COUNT_PARAM               11L
#define CMSG_CERT_PARAM                     12L
#define CMSG_CRL_COUNT_PARAM                13L
#define CMSG_CRL_PARAM                      14L
#define CMSG_ENVELOPE_ALGORITHM_PARAM       15L
#define CMSG_RECIPIENT_COUNT_PARAM          17L
#define CMSG_RECIPIENT_INDEX_PARAM          18L
#define CMSG_RECIPIENT_INFO_PARAM           19L
#define CMSG_HASH_ALGORITHM_PARAM           20L
#define CMSG_HASH_DATA_PARAM                21L
#define CMSG_COMPUTED_HASH_PARAM            22L
#define CMSG_ENCRYPT_PARAM                  26L
#define CMSG_ENCRYPTED_DIGEST               27L
#define CMSG_ENCODED_SIGNER                 28L
#define CMSG_ENCODED_MESSAGE                29L
#define CMSG_VERSION_PARAM                  30L
#define CMSG_ATTR_CERT_COUNT_PARAM          31L
#define CMSG_ATTR_CERT_PARAM                32L
#define CMSG_CMS_RECIPIENT_COUNT_PARAM      33L
#define CMSG_CMS_RECIPIENT_INDEX_PARAM      34L
#define CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM    35L
#define CMSG_CMS_RECIPIENT_INFO_PARAM       36L
#define CMSG_UNPROTECTED_ATTR_PARAM         37L
#define CMSG_SIGNER_CERT_ID_PARAM           38L
#define CMSG_CMS_SIGNER_INFO_PARAM          39L

/* Cryptographic message version numbers */
#define CMSG_SIGNED_DATA_V1                     1L
#define CMSG_SIGNED_DATA_V3                     3L
#define CMSG_SIGNED_DATA_PKCS_1_5_VERSION       CMSG_SIGNED_DATA_V1
#define CMSG_SIGNED_DATA_CMS_VERSION            CMSG_SIGNED_DATA_V3
#define CMSG_SIGNER_INFO_V1                     1L
#define CMSG_SIGNER_INFO_V3                     3L
#define CMSG_SIGNER_INFO_PKCS_1_5_VERSION       CMSG_SIGNER_INFO_V1
#define CMSG_SIGNER_INFO_CMS_VERSION            CMSG_SIGNER_INFO_V3
#define CMSG_HASHED_DATA_V0                     0L
#define CMSG_HASHED_DATA_V2                     2L
#define CMSG_HASHED_DATA_PKCS_1_5_VERSION       CMSG_HASHED_DATA_V0
#define CMSG_HASHED_DATA_CMS_VERSION            CMSG_HASHED_DATA_V2
#define CMSG_ENVELOPED_DATA_V0                  0L
#define CMSG_ENVELOPED_DATA_V2                  2L
#define CMSG_ENVELOPED_DATA_PKCS_1_5_VERSION    CMSG_ENVELOPED_DATA_V0
#define CMSG_ENVELOPED_DATA_CMS_VERSION         CMSG_ENVELOPED_DATA_V2
#define CMSG_ENVELOPED_RECIPIENT_V0             0L
#define CMSG_ENVELOPED_RECIPIENT_V2             2L
#define CMSG_ENVELOPED_RECIPIENT_V3             3L
#define CMSG_ENVELOPED_RECIPIENT_V4             4L
#define CMSG_KEY_TRANS_PKCS_1_5_VERSION         CMSG_ENVELOPED_RECIPIENT_V0
#define CMSG_KEY_TRANS_CMS_VERSION              CMSG_ENVELOPED_RECIPIENT_V2
#define CMSG_KEY_AGREE_VERSION                  CMSG_ENVELOPED_RECIPIENT_V3
#define CMSG_MAIL_LIST_VERSION                  CMSG_ENVELOPED_RECIPIENT_V4

/* Key agreement originator choices */
#define CMSG_KEY_AGREE_ORIGINATOR_CERT          1L
#define CMSG_KEY_AGREE_ORIGINATOR_PUBLIC_KEY    2L

/* Cryptographic message control types */
#define CMSG_CTRL_VERIFY_SIGNATURE          1L
#define CMSG_CTRL_DECRYPT                   2L
#define CMSG_CTRL_VERIFY_HASH               5L
#define CMSG_CTRL_ADD_SIGNER                6L
#define CMSG_CTRL_DEL_SIGNER                7L
#define CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR    8L
#define CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR    9L
#define CMSG_CTRL_ADD_CERT                  10L
#define CMSG_CTRL_DEL_CERT                  11L
#define CMSG_CTRL_ADD_CRL                   12L
#define CMSG_CTRL_DEL_CRL                   13L
#define CMSG_CTRL_ADD_ATTR_CERT             14L
#define CMSG_CTRL_DEL_ATTR_CERT             15L
#define CMSG_CTRL_KEY_TRANS_DECRYPT         16L
#define CMSG_CTRL_KEY_AGREE_DECRYPT         17L
#define CMSG_CTRL_MAIL_LIST_DECRYPT         18L
#define CMSG_CTRL_VERIFY_SIGNATURE_EX       19L
#define CMSG_CTRL_ADD_CMS_SIGNER_INFO       20L

/* Cryptographic message signer types */
#define CMSG_VERIFY_SIGNER_PUBKEY   1L
#define CMSG_VERIFY_SIGNER_CERT     2L
#define CMSG_VERIFY_SIGNER_CHAIN    3L
#define CMSG_VERIFY_SIGNER_NULL     4L

/* Cryptographic message function names */
#define CMSG_OID_GEN_ENCRYPT_KEY_FUNC               "CryptMsgDllGenEncryptKey"
#define CMSG_OID_EXPORT_ENCRYPT_KEY_FUNC            "CryptMsgDllExportEncryptKey"
#define CMSG_OID_IMPORT_ENCRYPT_KEY_FUNC            "CryptMsgDllImportEncryptKey"
#define CMSG_OID_GEN_CONTENT_ENCRYPT_KEY_FUNC       "CryptMsgDllGenContentEncryptKey"
#define CMSG_OID_CAPI1_GEN_CONTENT_ENCRYPT_KEY_FUNC CMSG_OID_GEN_CONTENT_ENCRYPT_KEY_FUNC
#define CMSG_OID_CNG_GEN_CONTENT_ENCRYPT_KEY_FUNC   "CryptMsgDllCNGGenContentEncryptKey"
#define CMSG_OID_EXPORT_KEY_TRANS_FUNC              "CryptMsgDllExportKeyTrans"
#define CMSG_OID_CAPI1_EXPORT_KEY_TRANS_FUNC        CMSG_OID_EXPORT_KEY_TRANS_FUNC
#define CMSG_OID_CNG_EXPORT_KEY_TRANS_FUNC          "CryptMsgDllCNGExportKeyTrans"
#define CMSG_OID_EXPORT_KEY_AGREE_FUNC              "CryptMsgDllExportKeyAgree"
#define CMSG_OID_CAPI1_EXPORT_KEY_AGREE_FUNC        CMSG_OID_EXPORT_KEY_AGREE_FUNC
#define CMSG_OID_CNG_EXPORT_KEY_AGREE_FUNC          "CryptMsgDllCNGExportKeyAgree"
#define CMSG_OID_EXPORT_MAIL_LIST_FUNC              "CryptMsgDllExportMailList"
#define CMSG_OID_CAPI1_EXPORT_MAIL_LIST_FUNC        CMSG_OID_EXPORT_MAIL_LIST_FUNC
#define CMSG_OID_IMPORT_KEY_TRANS_FUNC              "CryptMsgDllImportKeyTrans"
#define CMSG_OID_CAPI1_IMPORT_KEY_TRANS_FUNC        CMSG_OID_IMPORT_KEY_TRANS_FUNC
#define CMSG_OID_IMPORT_KEY_AGREE_FUNC              "CryptMsgDllImportKeyAgree"
#define CMSG_OID_CAPI1_IMPORT_KEY_AGREE_FUNC        CMSG_OID_IMPORT_KEY_AGREE_FUNC
#define CMSG_OID_IMPORT_MAIL_LIST_FUNC              "CryptMsgDllImportMailList"
#define CMSG_OID_CAPI1_IMPORT_MAIL_LIST_FUNC        CMSG_OID_IMPORT_MAIL_LIST_FUNC
#define CMSG_OID_CNG_IMPORT_KEY_TRANS_FUNC          "CryptMsgDllCNGImportKeyTrans"
#define CMSG_OID_CNG_IMPORT_KEY_AGREE_FUNC          "CryptMsgDllCNGImportKeyAgree"
#define CMSG_OID_CNG_IMPORT_CONTENT_ENCRYPT_KEY_FUNC    "CryptMsgDllCNGImportContentEncryptKey"

/* Special OID value for use with CryptGetOIDFunctionAddress() */
#define CMSG_DEFAULT_INSTALLABLE_FUNC_OID   ((LPCSTR)1)

/* Cryptographic message content encryption information flags */
#define CMSG_CONTENT_ENCRYPT_PAD_ENCODED_LEN_FLAG   0x00000001L
#define CMSG_CONTENT_ENCRYPT_FREE_PARA_FLAG         0x00000001L
#define CMSG_CONTENT_ENCRYPT_FREE_OBJID_FLAG        0x00000002L
#define CMSG_CONTENT_ENCRYPT_RELEASE_CONTEXT_FLAG   0x00008000L

/* Cryptographic message key transport encryption information flags */
#define CMSG_KEY_TRANS_ENCRYPT_FREE_PARA_FLAG   0x00000001L
#define CMSG_KEY_TRANS_ENCRYPT_FREE_OBJID_FLAG  0x00000002L

/* Cryptographic message key agreement encryption information flags */
#define CMSG_KEY_AGREE_ENCRYPT_FREE_PARA_FLAG           0x00000001L
#define CMSG_KEY_AGREE_ENCRYPT_FREE_MATERIAL_FLAG       0x00000002L
#define CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_ALG_FLAG     0x00000004L
#define CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_PARA_FLAG    0x00000008L
#define CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_BITS_FLAG    0x00000010L
#define CMSG_KEY_AGREE_ENCRYPT_FREE_OBJID_FLAG          0x00000020L

/* Cryptographic message mail list encryption information flags */
#define CMSG_MAIL_LIST_ENCRYPT_FREE_PARA_FLAG   0x00000001L
#define CMSG_MAIL_LIST_ENCRYPT_FREE_OBJID_FLAG  0x00000002L

/* Property identifiers */
#define CERT_KEY_PROP_HANDLE_PROP_ID                1L
#define CERT_KEY_PROP_INFO_PROP_ID                  2L
#define CERT_SHA1_HASH_PROP_ID                      3L
#define CERT_MD5_HASH_PROP_ID                       4L
#define CERT_HASH_PROP_ID                           CERT_SHA1_HASH_PROP_ID
#define CERT_KEY_CONTEXT_PROP_ID                    5L
#define CERT_KEY_SPEC_PROP_ID                       6L
#define CERT_IE30_RESERVED_PROP_ID                  7L
#define CERT_PUBKEY_HASH_RESERVED_PROP_ID           8L
#define CERT_ENHKEY_USAGE_PROP_ID                   9L
#define CERT_CTL_USAGE_PROP_ID                      CERT_ENHKEY_USAGE_PROP_ID
#define CERT_NEXT_UPDATE_LOCATION_PROP_ID           10L
#define CERT_FRIENDLY_NAME_PROP_ID                  11L
#define CERT_PKV_FILE_PROP_ID                       12L
#define CERT_DESCRIPTION_PROP_ID                    13L
#define CERT_ACCESS_STATE_PROP_ID                   14L
#define CERT_SIGNATURE_HASH_PROP_ID                 15L
#define CERT_SMARD_CARD_DATA_PROP_ID                16L
#define CERT_EFS_PROP_ID                            17L
#define CERT_FORTEZZA_DATA_PROP_ID                  18L
#define CERT_ARCHIVED_PROP_ID                       19L
#define CERT_KEY_IDENTIFIER_PROP_ID                 20L
#define CERT_AUTO_ENROLL_PROP_ID                    21L
#define CERT_PUBKEY_ALG_PARA_PROP_ID                22L
#define CERT_CROSS_CERT_DIST_POINTS_PROP_ID         23L
#define CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID     24L
#define CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID    25L
#define CERT_ENROLLMENT_PROP_ID                     26L
#define CERT_DATE_STAMP_PROP_ID                     27L
#define CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID  28L
#define CERT_SUBJECT_NAME_MD5_HASH_PROP_ID          29L
#define CERT_EXTENDED_ERROR_INFO_PROP_ID            30L
#define CERT_RENEWAL_PROP_ID                        64L
#define CERT_ARCHIVED_KEY_HASH_PROP_ID              65L
#define CERT_AUTO_ENROLL_RETRY_PROP_ID              66L
#define CERT_AIA_URL_RETRIEVED_PROP_ID              67L
#define CERT_AUTHORITY_INFO_ACCESS_PROP_ID          68L
#define CERT_BACKED_UP_PROP_ID                      69L
#define CERT_OCSP_RESPONSE_PROP_ID                  70L
#define CERT_REQUEST_ORIGINATOR_PROP_ID             71L
#define CERT_SOURCE_LOCATION_PROP_ID                72L
#define CERT_SOURCE_URL_PROP_ID                     73L
#define CERT_NEW_KEY_PROP_ID                        74L
#define CERT_OCSP_CACHE_PREFIX_PROP_ID              75L
#define CERT_SMART_CARD_ROOT_INFO_PROP_ID           76L
#define CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID           77L
#define CERT_NCRYPT_KEY_HANDLE_PROP_ID              78L
#define CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID    79L
#define CERT_SUBJECT_INFO_ACCESS_PROP_ID            80L
#define CERT_CA_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID  81L
#define CERT_CA_DISABLE_CRL_PROP_ID                 82L
#define CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID     83L
#define CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID  84L
#define CERT_SUBJECT_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID 85L
#define CERT_SUBJECT_DISABLE_CRL_PROP_ID            86L
#define CERT_CEP_PROP_ID                            87L
#define CERT_SIGN_HASH_CNG_ALG_PROP_ID              89L
#define CERT_SCARD_PIN_ID_PROP_ID                   90L
#define CERT_SCARD_PIN_INFO_PROP_ID                 91L
#define CERT_FIRST_RESERVED_PROP_ID                 92L
#define CERT_LAST_RESERVED_PROP_ID                  0x00007FFFL
#define CERT_FIRST_USER_PROP_ID                     0x00008000L
#define CERT_LAST_USER_PROP_ID                      0x0000FFFFL

/* Macros to identify property identifiers */
#define IS_CERT_HASH_PROP_ID( x ) \
    ((x) == CERT_SHA1_HASH_PROP_ID || (x) == CERT_MD5_HASH_PROP_ID || \
    (x) == CERT_SIGNATURE_HASH_PROP_ID)
#define IS_PUBKEY_HASH_PROP_ID( x ) \
    ((x) == CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID || \
    (x) == CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID)
#define IS_CHAIN_HASH_PROP_ID( x ) \
    ((x) == CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID || \
    (x) == CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID || \
    (x) == CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID || \
    (x) == CERT_SUBJECT_NAME_MD5_HASH_PROP_ID)

/* Property object identifier macros */
#define szOID_CERT_PROP_ID_PREFIX   "1.3.6.1.4.1.311.10.11."
#define _szPROP_ID( x )             #x
#define szOID_CERT_PROP_ID( x )     szOID_CERT_PROP_ID_PREFIX _szPROP_ID( x )
#define __CRYPT32WTEXT( x )         L##x
#define _CRYPT32WTEXT( x )          __CRYPT32WTEXT( x )
#define wszOID_CERT_PROP_ID( x ) \
    _CRYPT32WTEXT( szOID_CERT_PROP_ID_PREFIX ) _CRYPT32WTEXT( _szPROP_ID( x ) )

/* Property object identifiers */
#define szOID_CERT_KEY_IDENTIFIER_PROP_ID                   "1.3.6.1.4.1.311.10.11.20"
#define szOID_CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID    "1.3.6.1.4.1.311.10.11.28"
#define szOID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID            "1.3.6.1.4.1.311.10.11.29"
#define szOID_CERT_MD5_HASH_PROP_ID                         "1.3.6.1.4.1.311.10.11.4"

/* Access state flags */
#define CERT_ACCESS_STATE_WRITE_PERSIST_FLAG    0x00000001L
#define CERT_ACCESS_STATE_SYSTEM_STORE_FLAG     0x00000002L
#define CERT_ACCESS_STATE_LM_SYSTEM_STORE_FLAG  0x00000004L
#define CERT_ACCESS_STATE_GP_SYSTEM_STORE_FLAG  0x00000008L

/* Key provider information flags */
#define CERT_SET_KEY_PROV_HANDLE_PROP_ID    0x00000001L
#define CERT_SET_KEY_CONTEXT_PROP_ID        0x00000002L

/* Special value used to specify a CNG handle */
#define CERT_NCRYPT_KEY_SPEC    0xFFFFFFFFL

/* Certificate store provider types */
#define CERT_STORE_PROV_MSG                     ((LPCSTR)1)
#define CERT_STORE_PROV_MEMORY                  ((LPCSTR)2)
#define CERT_STORE_PROV_FILE                    ((LPCSTR)3)
#define CERT_STORE_PROV_REG                     ((LPCSTR)4)
#define CERT_STORE_PROV_PKCS7                   ((LPCSTR)5)
#define CERT_STORE_PROV_SERIALIZED              ((LPCSTR)6)
#define CERT_STORE_PROV_FILENAME_A              ((LPCSTR)7)
#define CERT_STORE_PROV_FILENAME_W              ((LPCSTR)8)
#define CERT_STORE_PROV_FILENAME                CERT_STORE_PROV_FILENAME_W
#define CERT_STORE_PROV_SYSTEM_A                ((LPCSTR)9)
#define CERT_STORE_PROV_SYSTEM_W                ((LPCSTR)10)
#define CERT_STORE_PROV_SYSTEM                  CERT_STORE_PROV_SYSTEM_W
#define CERT_STORE_PROV_COLLISION               ((LPCSTR)11)
#define CERT_STORE_PROV_SYSTEM_REGISTRY_A       ((LPCSTR)12)
#define CERT_STORE_PROV_SYSTEM_REGISTRY_W       ((LPCSTR)13)
#define CERT_STORE_PROV_SYSTEM_REGISTRY         CERT_STORE_PROV_SYSTEM_REGISTRY_W
#define CERT_STORE_PROV_PHYSICAL_W              ((LPCSTR)14)
#define CERT_STORE_PROV_PHYSICAL                CERT_STORE_PROV_PHYSICAL_W
#define CERT_STORE_PROV_SMART_CARD_W            ((LPCSTR)15)
#define CERT_STORE_PROV_SMART_CARD              CERT_STORE_PROV_SMART_CARD_W
#define CERT_STORE_PROV_LDAP_W                  ((LPCSTR)16)
#define CERT_STORE_PROV_LDAP                    CERT_STORE_PROV_LDAP_W
#define CERT_STORE_PROV_PKCS12                  ((LPCSTR)17)
#define sz_CERT_STORE_PROV_MEMORY               "Memory"
#define sz_CERT_STORE_PROV_FILENAME_W           "File"
#define sz_CERT_STORE_PROV_FILENAME             sz_CERT_STORE_PROV_FILENAME_W
#define sz_CERT_STORE_PROV_SYSTEM_W             "System"
#define sz_CERT_STORE_PROV_SYSTEM               sz_CERT_STORE_PROV_SYSTEM
#define sz_CERT_STORE_PROV_PKCS7                "PKCS7"
#define sz_CERT_STORE_PROV_PKCS12               "PKCS12"
#define sz_CERT_STORE_PROV_SERIALIZED           "Serialized"
#define sz_CERT_STORE_PROV_COLLECTION           "Collection"
#define sz_CERT_STORE_PROV_SYSTEM_REGISTRY_W    "SystemRegistry"
#define sz_CERT_STORE_PROV_SYSTEM_REGISTRY      sz_CERT_STORE_PROV_SYSTEM_REGISTRY_W
#define sz_CERT_STORE_PROV_PHYSICAL_W           "Physical"
#define sz_CERT_STORE_PROV_PHYSICAL             sz_CERT_STORE_PROV_PHYSICAL_W
#define sz_CERT_STORE_PROV_SMART_CARD_W         "SmartCard"
#define sz_CERT_STORE_PROV_SMART_CARD           sz_CERT_STORE_PROV_SMART_CARD_W
#define sz_CERT_STORE_PROV_LDAP_W               "Ldap"
#define sz_CERT_STORE_PROV_LDAP                 sz_CERT_STORE_PROV_LDAP_W

/* Certificate store verify flags */
#define CERT_STORE_SIGNATURE_FLAG       0x00000001L
#define CERT_STORE_TIME_VALIDITY_FLAG   0x00000002L
#define CERT_STORE_REVOCATION_FLAG      0x00000004L
#define CERT_STORE_NO_CRL_FLAG          0x00010000L
#define CERT_STORE_NO_ISSUER_FLAG       0x00020000L
#define CERT_STORE_BASE_CRL_FLAG        0x00000100L
#define CERT_STORE_DELTA_CRL_FLAG       0x00000200L

/* Certificate store open flags */
#define CERT_STORE_NO_CRYPT_RELEASE_FLAG            0x00000001L
#define CERT_STORE_SET_LOCALIZED_NAME_FLAG          0x00000002L
#define CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG 0x00000004L
#define CERT_STORE_DELETE_FLAG                      0x00000010L
#define CERT_STORE_UNSAFE_PHYSICAL_FLAG             0x00000020L
#define CERT_STORE_SHARE_STORE_FLAG                 0x00000040L
#define CERT_STORE_SHARE_CONTEXT_FLAG               0x00000080L
#define CERT_STORE_MANIFOLD_FLAG                    0x00000100L
#define CERT_STORE_ENUM_ARCHIVED_FLAG               0x00000200L
#define CERT_STORE_UPDATE_KEYID_FLAG                0x00000400L
#define CERT_STORE_BACKUP_RESTORE_FLAG              0x00000800L
#define CERT_STORE_READONLY_FLAG                    0x00008000L
#define CERT_STORE_OPEN_EXISTING_FLAG               0x00004000L
#define CERT_STORE_CREATE_NEW_FLAG                  0x00002000L
#define CERT_STORE_MAXIMUM_ALLOWED_FLAG             0x00001000L

/* Certificate system store flags */
#define CERT_SYSTEM_STORE_MASK              0xFFFF0000L
#define CERT_SYSTEM_STORE_RELOCATE_FLAG     0x80000000L
#define CERT_SYSTEM_STORE_UNPROTECTED_FLAG  0x40000000L

/* Certificate system store location constants */
#define CERT_SYSTEM_STORE_LOCATION_MASK     0x00FF0000L
#define CERT_SYSTEM_STORE_LOCATION_SHIFT    16

/* Certificate system store registry locations */
#define CERT_SYSTEM_STORE_CURRENT_USER_ID               1
#define CERT_SYSTEM_STORE_LOCAL_MACHINE_ID              2
#define CERT_SYSTEM_STORE_CURRENT_SERVICE_ID            4
#define CERT_SYSTEM_STORE_SERVICES_ID                   5
#define CERT_SYSTEM_STORE_USERS_ID                      6
#define CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID  7
#define CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID 8
#define CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID   9
#define CERT_SYSTEM_STORE_CURRENT_USER \
    (CERT_SYSTEM_STORE_CURRENT_USER_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_LOCAL_MACHINE \
    (CERT_SYSTEM_STORE_LOCAL_MACHINE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_CURRENT_SERVICE \
    (CERT_SYSTEM_STORE_CURRENT_SERVICE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_SERVICES \
    (CERT_SYSTEM_STORE_SERVICES_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_USERS \
    (CERT_SYSTEM_STORE_USERS_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY \
    (CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY \
    (CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)
#define CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE \
    (CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT)

/* Registry paths */
#define CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH \
    L"Software\\Policies\\Microsoft\\SystemCertificates"
#define CERT_EFSBLOB_REGPATH \
    CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH L"\\EFS"
#define CERT_EFSBLOB_VALUE_NAME                                 L"EFSBlob"
#define CERT_PROT_ROOT_FLAGS_REGPATH \
    CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH L"\\Root\\ProtectedRoots"
#define CERT_PROT_ROOT_FLAGS_VALUE_NAME                         L"Flags"
#define CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME                   L"PeerUsages"
#define CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME_A                 "PeerUsages"
#define CERT_TRUST_PUB_SAFER_GROUP_POLICY_REGPATH \
    CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH L"\\TrustedPublisher\\Safer"
#define CERT_LOCAL_MACHINE_SYSTEM_STORE_REGPATH \
    L"Software\\Microsoft\\SystemCertificates"
#define CERT_TRUST_PUB_SAFER_LOCAL_MACHINE_REGPATH \
    CERT_LOCAL_MACHINE_SYSTEM_STORE_REGPATH L"\\TrustedPublisher\\Safer"
#define CERT_TRUST_PUB_AUTHENTICODE_FLAGS_VALUE_NAME            L"AuthenticodeFlags"
#define CERT_OCM_SUBCOMPONENTS_LOCAL_MACHINE_REGPATH \
    L"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Setup\\OC Manager\\Subcomponents"
#define CERT_OCM_SUBCOMPONENTS_ROOT_AUTO_UPDATE_VALUE_NAME      L"RootAutoUpdate"
#define CERT_DISABLE_ROOT_AUTO_UPDATE_REGPATH \
    CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH L"\\AuthRoot"
#define CERT_DISABLE_ROOT_AUTO_UPDATE_VALUE_NAME                L"DisableRootAutoUpdate"
#define CERT_AUTH_ROOT_AUTO_UPDATE_LOCAL_MACHINE_REGPATH \
    CERT_LOCAL_MACHINE_SYSTEM_STORE_REGPATH L"\\AuthRoot\\AutoUpdate"
#define CERT_AUTH_ROOT_AUTO_UPDATE_ROOT_DIR_URL_VALUE_NAME      L"RootDirUrl"
#define CERT_AUTH_ROOT_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME   L"SyncDeltaTime"
#define CERT_AUTH_ROOT_AUTO_UPDATE_FLAGS_VALUE_NAME             L"Flags"
#define CERT_IE_DIRTY_FLAGS_REGPATH \
    L"Software\\Microsoft\\Cryptography\\IEDirtyFlags"

/* Protocol root flags */
#define CERT_PROT_ROOT_DISABLE_CURRENT_USER_FLAG                0x00000001L
#define CERT_PROT_ROOT_INHIBIT_ADD_AT_INIT_FLAG                 0x00000002L
#define CERT_PROT_ROOT_INHIBIT_PURGE_LM_FLAG                    0x00000004L
#define CERT_PROT_ROOT_DISABLE_LM_AUTH_FLAG                     0x00000008L
#define CERT_PROT_ROOT_ONLY_LM_GPT_FLAG                         0x00000008L
#define CERT_PROT_ROOT_DISABLE_NT_AUTH_REQUIRED_FLAG            0x00000010L
#define CERT_PROT_ROOT_DISABLE_NOT_DEFINED_NAME_CONSTRAINT_FLAG 0x00000020L
#define CERT_PROT_ROOT_DISABLE_PEER_TRUST                       0x00010000L

/* Peer usages default value */
#define CERT_PROT_ROOT_PEER_USAGES_DEFAULT_A \
    szOID_PKIX_KP_CLIENT_AUTH "\0" szOID_PKIX_KP_EMAIL_PROTECTION "\0" \
    szOID_KP_EFS "\0"

/* Authenticode flags */
#define CERT_TRUST_PUB_ALLOW_TRUST_MASK             0x00000003L
#define CERT_TRUST_PUB_ALLOW_END_USER_TRUST         0x00000000L
#define CERT_TRUST_PUB_ALLOW_MACHINE_ADMIN_TRUST    0x00000001L
#define CERT_TRUST_PUB_ALLOW_ENTERPRISE_ADMIN_TRUST 0x00000002L
#define CERT_TRUST_PUB_CHECK_PUBLISHER_REV_FLAG     0x00000100L
#define CERT_TRUST_PUB_CHECK_TIMESTAMP_REV_FLAG     0x00000200L

/* Automatic update flags */
#define CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_UNTRUSTED_ROOT_LOGGING_FLAG  0x00000001L
#define CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_PARTIAL_CHAIN_LOGGING_FLAG   0x00000002L

/* Automatic update file names */
#define CERT_AUTH_ROOT_CTL_FILENAME     L"authroot.stl"
#define CERT_AUTH_ROOT_CTL_FILENAME_A   "authroot.stl"
#define CERT_AUTH_ROOT_CAB_FILENAME     L"authrootstl.cab"
#define CERT_AUTH_ROOT_SEQ_FILENAME     L"authrootseq.txt"
#define CERT_AUTH_ROOT_CERT_EXT         L".crt"

/* Certificate registry store flags */
#define CERT_REGISTRY_STORE_REMOTE_FLAG         0x00010000L
#define CERT_REGISTRY_STORE_SERIALIZED_FLAG     0x00020000L
#define CERT_REGISTRY_STORE_CLIENT_GPT_FLAG     0x80000000L
#define CERT_REGISTRY_STORE_LM_GPT_FLAG         0x01000000L
#define CERT_REGISTRY_STORE_ROAMING_FLAG        0x00040000L
#define CERT_REGISTRY_STORE_MY_IE_DIRTY_FLAG    0x00080000L

/* Certificate file store flags */
#define CERT_FILE_STORE_COMMIT_ENABLE_FLAG  0x00010000L

/* Certificate LDAP store flags */
#define CERT_LDAP_STORE_SIGN_FLAG           0x00010000L
#define CERT_LDAP_STORE_AREC_EXCLUSIVE_FLAG 0x00020000L
#define CERT_LDAP_STORE_OPENED_FLAG         0x00040000L
#define CERT_LDAP_STORE_UNBIND_FLAG         0x00080000L

/* Certificate store provider function names */
#define CRYPT_OID_OPEN_STORE_PROV_FUNC  "CertDllOpenStoreProv"

/* Certificate store provider flags */
#define CERT_STORE_PROV_EXTERNAL_FLAG           0x00000001L
#define CERT_STORE_PROV_DELETED_FLAG            0x00000002L
#define CERT_STORE_PROV_NO_PERSIST_FLAG         0x00000004L
#define CERT_STORE_PROV_SYSTEM_STORE_FLAG       0x00000008L
#define CERT_STORE_PROV_LM_SYSTEM_STORE_FLAG    0x00000010L
#define CERT_STORE_PROV_GP_SYSTEM_STORE_FLAG    0x00000020L

/* Certificate store provider function indices */
#define CERT_STORE_PROV_CLOSE_FUNC              0
#define CERT_STORE_PROV_READ_CERT_FUNC          1
#define CERT_STORE_PROV_WRITE_CERT_FUNC         2
#define CERT_STORE_PROV_DELETE_CERT_FUNC        3
#define CERT_STORE_PROV_SET_CERT_PROPERTY_FUNC  4
#define CERT_STORE_PROV_READ_CRL_FUNC           5
#define CERT_STORE_PROV_WRITE_CRL_FUNC          6
#define CERT_STORE_PROV_DELETE_CRL_FUNC         7
#define CERT_STORE_PROV_SET_CRL_PROPERTY_FUNC   8
#define CERT_STORE_PROV_READ_CTL_FUNC           9
#define CERT_STORE_PROV_WRITE_CTL_FUNC          10
#define CERT_STORE_PROV_DELETE_CTL_FUNC         11
#define CERT_STORE_PROV_SET_CTL_PROPERTY_FUNC   12
#define CERT_STORE_PROV_CONTROL_FUNC            13
#define CERT_STORE_PROV_FIND_CERT_FUNC          14
#define CERT_STORE_PROV_FREE_FIND_CERT_FUNC     15
#define CERT_STORE_PROV_GET_CERT_PROPERTY_FUNC  16
#define CERT_STORE_PROV_FIND_CRL_FUNC           17
#define CERT_STORE_PROV_FREE_FIND_CRL_FUNC      18
#define CERT_STORE_PROV_GET_CRL_PROPERTY_FUNC   19
#define CERT_STORE_PROV_FIND_CTL_FUNC           20
#define CERT_STORE_PROV_FREE_FIND_CTL_FUNC      21
#define CERT_STORE_PROV_GET_CTL_PROPERTY_FUNC   22

/* Certificate store write flags */
#define CERT_STORE_PROV_WRITE_ADD_FLAG  0x00000001L

/* CertSaveStore() constants */
#define CERT_STORE_SAVE_AS_STORE        1L
#define CERT_STORE_SAVE_AS_PKCS7        2L
#define CERT_STORE_SAVE_AS_PKCS12       3L
#define CERT_STORE_SAVE_TO_FILE         1L
#define CERT_STORE_SAVE_TO_MEMORY       2L
#define CERT_STORE_SAVE_TO_FILENAME_A   3L
#define CERT_STORE_SAVE_TO_FILENAME_W   4L
#define CERT_STORE_SAVE_TO_FILENAME     CERT_STORE_SAVE_TO_FILENAME_W

/* CertCloseStore() flags */
#define CERT_CLOSE_STORE_FORCE_FLAG 0x00000001L
#define CERT_CLOSE_STORE_CHECK_FLAG 0x00000002L

/* Certificate comparison functions */
#define CERT_COMPARE_MASK                   0x0000FFFFL
#define CERT_COMPARE_SHIFT                  16
#define CERT_COMPARE_ANY                    0L
#define CERT_COMPARE_SHA1_HASH              1L
#define CERT_COMPARE_NAME                   2L
#define CERT_COMPARE_ATTR                   3L
#define CERT_COMPARE_MD5_HASH               4L
#define CERT_COMPARE_PROPERTY               5L
#define CERT_COMPARE_PUBLIC_KEY             6L
#define CERT_COMPARE_HASH                   CERT_COMPARE_SHA1_HASH
#define CERT_COMPARE_NAME_STR_A             7L
#define CERT_COMPARE_NAME_STR_W             8L
#define CERT_COMPARE_KEY_SPEC               9L
#define CERT_COMPARE_ENHKEY_USAGE           10L
#define CERT_COMPARE_CTL_USAGE              CERT_COMPARE_ENHKEY_USAGE
#define CERT_COMPARE_SUBJECT_CERT           11L
#define CERT_COMPARE_ISSUER_OF              12L
#define CERT_COMPARE_EXISTING               13L
#define CERT_COMPARE_SIGNATURE_HASH         14L
#define CERT_COMPARE_KEY_IDENTIFIER         15L
#define CERT_COMPARE_CERT_ID                16L
#define CERT_COMPARE_CROSS_CERT_DIST_POINTS 17L
#define CERT_COMPARE_PUBKEY_MD5_HASH        18L
#define CERT_COMPARE_SUBJECT_INFO_ACCESS    19L

/* Certificate find types */
#define CERT_FIND_ANY               (CERT_COMPARE_ANY << CERT_COMPARE_SHIFT)
#define CERT_FIND_SHA1_HASH         (CERT_COMPARE_SHA1_HASH << CERT_COMPARE_SHIFT)
#define CERT_FIND_MD5_HASH          (CERT_COMPARE_MD5_HASH << CERT_COMPARE_SHIFT)
#define CERT_FIND_SIGNATURE_HASH    (CERT_COMPARE_SIGNATURE_HASH << CERT_COMPARE_SHIFT)
#define CERT_FIND_KEY_IDENTIFIER    (CERT_COMAPRE_KEY_IDENTIFIER << CERT_COMPARE_SHIFT)
#define CERT_FIND_HASH              CERT_FIND_SHA1_HASH
#define CERT_FIND_PROPERTY          (CERT_COMPARE_PROPERTY << CERT_COMPARE_SHIFT)
#define CERT_FIND_PUBLIC_KEY        (CERT_COMPARE_PUBLIC_KEY << CERT_COMPARE_SHIFT)
#define CERT_FIND_SUBJECT_NAME \
    (CERT_COMPARE_NAME << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG)
#define CERT_FIND_SUBJECT_ATTR \
    (CERT_COMPARE_ATTR << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG)
#define CERT_FIND_ISSUER_NAME \
    (CERT_COMPARE_NAME << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG)
#define CERT_FIND_ISSUER_ATTR \
    (CERT_COMPARE_ATTR << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG)
#define CERT_FIND_SUBJECT_STR_A \
    (CERT_COMPARE_NAME_STR_A << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG)
#define CERT_FIND_SUBJECT_STR_W \
    (CERT_COMPARE_NAME_STR_W << CERT_COMPARE_SHIFT | CERT_INFO_SUJBECT_FLAG)
#define CERT_FIND_SUBJECT_STR       CERT_FIND_SUBJECT_STR_W
#define CERT_FIND_ISSUER_STR_A \
    (CERT_COMPARE_NAME_STR_A << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG)
#define CERT_FIND_ISSUER_STR_W \
    (CERT_COMPARE_NAME_STR_W << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG)
#define CERT_FIND_ISSUER_STR        CERT_FIND_ISSUER_STR_W
#define CERT_FIND_KEY_SPEC          (CERT_COMPARE_KEY_SPEC << CERT_COMPARE_SHIFT)
#define CERT_FIND_ENHKEY_USAGE      (CERT_COMPARE_ENHKEY_USAGE << CERT_COMPARE_SHIFT)
#define CERT_FIND_CTL_USAGE         CERT_FIND_ENHKEY_USAGE
#define CERT_FIND_SUBJECT_CERT      (CERT_COMPARE_SUBJECT_CERT << CERT_COMPARE_SHIFT)
#define CERT_FIND_ISSUER_OF         (CERT_COMPARE_ISSUER_OF << CERT_COMPARE_SHIFT)
#define CERT_FIND_EXISTING          (CERT_COMPARE_EXISTING << CERT_COMPARE_SHIFT)
#define CERT_FIND_CERT_ID           (CERT_COMPARE_CERT_ID << CERT_COMPARE_SHIFT)
#define CERT_FIND_CROSS_CERT_DIST_POINTS \
    (CERT_COMPARE_CROSS_CERT_DIST_POINTS << CERT_COMPARE_SHIFT)
#define CERT_FIND_PUBKEY_MD5_HASH   (CERT_COMPARE_PUBKEY_MD5_HASH << CERT_COMPARE_SHIFT)
#define CERT_FIND_SUBJECT_INFO_ACCESS \
    (CERT_COMPARE_SUBJECT_INFO_ACCESS << CERT_COMPARE_SHIFT)

/* Enhanced key usage flags */
#define CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG    0x00000001L
#define CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG    0x00000002L
#define CERT_FIND_PROP_ONLY_ENHKEY_USAGE_FLAG   0x00000004L
#define CERT_FIND_NO_ENHKEY_USAGE_FLAG          0x00000008L
#define CERT_FIND_OR_ENHKEY_USAGE_FLAG          0x00000010L
#define CERT_FIND_VALID_ENHKEY_USAGE_FLAG       0x00000020L
#define CERT_FIND_OPTIONAL_CTL_USAGE_FLAG       CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG
#define CERT_FIND_EXT_ONLY_CTL_USAGE_FLAG       CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG
#define CERT_FIND_PROP_ONLY_CTL_USAGE_FLAG      CERT_FIND_PROP_ONLY_ENHKEY_USAGE_FLAG
#define CERT_FIND_NO_CTL_USAGE_FLAG             CERT_FIND_NO_ENHKEY_USAGE_FLAG
#define CERT_FIND_OR_CTL_USAGE_FLAG             CERT_FIND_OR_ENHKEY_USAGE_FLAG
#define CERT_FIND_VALID_CTL_USAGE_FLAG          CERT_FIND_VALID_ENHKEY_USAGE_FLAG

/* CertSetCertificateContextProperty() flags */
#define CERT_SET_PROPERTY_IGNORE_PERSIST_ERROR_FLAG 0x80000000L
#define CERT_SET_PROPERTY_INHIBIT_PERSIST_FLAG      0x40000000L

/* CertCreateCTLEntryFromCertificateContextProperties() flags */
#define CTL_ENTRY_FROM_PROP_CHAIN_FLAG  0x00000001L

/* CertFindCRLInStore() find types */
#define CRL_FIND_ANY        0L
#define CRL_FIND_ISSUED_BY  1L
#define CRL_FIND_EXISTING   2L
#define CRL_FIND_ISSUED_FOR 3L

/* CertFindCRLInStore() flags */
#define CRL_FIND_ISSUED_BY_AKI_FLAG         0x00000001L
#define CRL_FIND_ISSUED_BY_SIGNATURE_FLAG   0x00000002L
#define CRL_FIND_ISSUED_BY_DELTA_FLAG       0x00000004L
#define CRL_FIND_ISSUED_BY_BASE_FLAG        0x00000008L

/* Certificate store add types */
#define CERT_STORE_ADD_NEW                                  1L
#define CERT_STORE_ADD_USE_EXISTING                         2L
#define CERT_STORE_ADD_REPLACE_EXISTING                     3L
#define CERT_STORE_ADD_ALWAYS                               4L
#define CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES  5L
#define CERT_STORE_ADD_NEWER                                6L
#define CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES             7L

/* Certificate store context types */
#define CERT_STORE_CERTIFICATE_CONTEXT  1L
#define CERT_STORE_CRL_CONTEXT          2L
#define CERT_STORE_CTL_CONTEXT          3L

/* Certificate store context type flags */
#define CERT_STORE_ALL_CONTEXT_FLAG         0xFFFFFFFFL
#define CERT_STORE_CERTIFICATE_CONTEXT_FLAG (1 << CERT_STORE_CERTIFICATE_CONTEXT)
#define CERT_STORE_CRL_CONTEXT_FLAG         (1 << CERT_STORE_CRL_CONTEXT)
#define CERT_STORE_CTL_CONTEXT_FLAG         (1 << CERT_STORE_CTL_CONTEXT)

/* CTL subject types */
#define CTL_ANY_SUBJECT_TYPE    1L
#define CTL_CERT_SUBJECT_TYPE   2L

/* CertFindCTLInStore() find types */
#define CTL_FIND_ANY        0L
#define CTL_FIND_SHA1_HASH  1L
#define CTL_FIND_MD5_HASH   2L
#define CTL_FIND_USAGE      3L
#define CTL_FIND_SUBJECT    4L
#define CTL_FIND_EXISTING   5L

/* Constants used with CTL_FIND_USAGE_PARA */
#define CTL_FIND_NO_LIST_ID_CBDATA  0xFFFFFFFFL
#define CTL_FIND_NO_SIGNER_PTR      ((PCERT_INFO)-1)

/* CertFindCTLInStore() flags */
#define CTL_FIND_SAME_USAGE_FLAG    0x00000001L

/* Certificate store control types */
#define CERT_STORE_CTRL_RESYNC          1L
#define CERT_STORE_CTRL_NOTIFY_CHANGE   2L
#define CERT_STORE_CTRL_COMMIT          3L
#define CERT_STORE_CTRL_AUTO_RESYNC     4L
#define CERT_STORE_CTRL_CANCEL_NOTIFY   5L

/* CertControlStore() flags */
#define CERT_STORE_CTRL_INHIBIT_DUPLICATE_HANDLE_FLAG   0x00000001L

/* Certificate store commit flags */
#define CERT_STORE_CTRL_COMMIT_FORCE_FLAG   0x00000001L
#define CERT_STORE_CTRL_COMMIT_CLEAR_FLAG   0x00000002L

/* Certificate store property identifiers */
#define CERT_STORE_LOCALIZED_NAME_PROP_ID   0x00001000L

/* CertCreateContext() flags */
#define CERT_CREATE_CONTEXT_NOCOPY_FLAG         0x00000001L
#define CERT_CREATE_CONTEXT_SORTED_FLAG         0x00000002L
#define CERT_CREATE_CONTEXT_NO_HCRYPTMSG_FLAG   0x00000004L
#define CERT_CREATE_CONTEXT_NO_ENTRY_FLAG       0x00000008L

/* Certificate physical store information flags */
#define CERT_PHYSICAL_STORE_ADD_ENABLE_FLAG                     0x00000001L
#define CERT_PHYSICAL_STORE_OPEN_DISABLE_FLAG                   0x00000002L
#define CERT_PHYSICAL_STORE_REMOTE_OPEN_DISABLE_FLAG            0x00000004L
#define CERT_PHYSICAL_STORE_INSERT_COMPUTER_NAME_ENABLE_FLAG    0x00000008L

/* Certificate phyiscal store enumeration flags */
#define CERT_PHYSICAL_STORE_PREDEFINED_ENUM_FLAG    0x00000001L

/* Predefined physical stores */
#define CERT_PHYSICAL_STORE_DEFAULT_NAME                    L".Default"
#define CERT_PHYSICAL_STORE_GROUP_POLICY_NAME               L".GroupPolicy"
#define CERT_PHYSICAL_STORE_LOCAL_MACHINE_NAME              L".LocalMachine"
#define CERT_PHYSICAL_STORE_DS_USER_CERTIFICATE_NAME        L".UserCertificate"
#define CERT_PHYSICAL_STORE_LOCAL_MACHINE_GROUP_POLICY_NAME L".LocalMachineGroupPolicy"
#define CERT_PHYSICAL_STORE_ENTERPRISE_NAME                 L".Enterprise"
#define CERT_PHYSICAL_STORE_AUTH_ROOT_NAME                  L".AuthRoot"
#define CERT_PHYSICAL_STORE_SMART_CARD_NAME                 L".SmartCard"

/* Certificate system store provider function names */
#define CRYPT_OID_OPEN_SYSTEM_STORE_PROV_FUNC       "CertDllOpenSystemStoreProv"
#define CRYPT_OID_REGISTER_SYSTEM_STORE_FUNC        "CertDllRegisterSystemStore"
#define CRYPT_OID_UNREGISTER_SYSTEM_STORE_FUNC      "CertDllUnregisterSystemStore"
#define CRYPT_OID_ENUM_SYSTEM_STORE_FUNC            "CertDllEnumSystemStore"
#define CRYPT_OID_REGISTER_PHYSICAL_STORE_FUNC      "CertDllRegisterPhysicalStore"
#define CRYPT_OID_UNREGISTER_PHYSICAL_STORE_FUNC    "CertDllUnregisterPhysicalStore"
#define CRYPT_OID_ENUM_PHYSICAL_STORE_FUNC          "CertDllEnumPhysicalStore"

/* Certificate system store location registry value name */
#define CRYPT_OID_SYSTEM_STORE_LOCATION_VALUE_NAME  L"SystemStoreLocation"

/* CryptMsgGetAndVerifySigner() flags */
#define CMSG_TRUSTED_SIGNER_FLAG    0x00000001L
#define CMSG_SIGNER_ONLY_FLAG       0x00000002L
#define CMSG_USE_SIGNER_INDEX_FLAG  0x00000004L

/* CryptMsgSignCTL() flags */
#define CMSG_CMS_ENCAPSULATED_CTL_FLAG  0x00008000L

/* CryptMsgEncodeAndSignCTL() flags */
#define CMSG_ENCODE_SORTED_CTL_FLAG                 0x00000001L
#define CMSG_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG  0x00000002L

/* CertVerifyCTLUsage() flags */
#define CERT_VERIFY_INHIBIT_CTL_UPDATE_FLAG 0x00000001L
#define CERT_VERIFY_TRUSTED_SIGNERS_FLAG    0x00000002L
#define CERT_VERIFY_NO_TIME_CHECK_FLAG      0x00000004L
#define CERT_VERIFY_ALLOW_MORE_USAGE_FLAG   0x00000008L
#define CERT_VERIFY_UPDATED_CTL_FLAG        0x00000001L

/* Certificate revocation types */
#define CERT_CONTEXT_REVOCATION_TYPE    1L

/* CertVerifyRevocation() flags */
#define CERT_VERIFY_REV_CHAIN_FLAG              0x00000001L
#define CERT_VERIFY_CACHE_ONLY_BASED_REVOCATION 0x00000002L
#define CERT_VERIFY_REV_ACCUMULATE_TIMEOUT_FLAG 0x00000004L
#define CERT_VERIFY_REV_SERVER_OCSP_FLAG        0x00000008L

/* CertIsRDNAttrsInCertificateName() flags */
#define CERT_UNICODE_IS_RDN_ATTRS_FLAG          0x00000001L
#define CERT_CASE_INSENSITIVE_IS_RDN_ATTRS_FLAG 0x00000002L

/* Certificate subject types */
#define CRYPT_VERIFY_CERT_SIGN_SUBJECT_BLOB                         1L
#define CRYPT_VERIFY_CERT_SIGN_SUBJECT_CERT                         2L
#define CRYPT_VERIFY_CERT_SIGN_SUBJECT_CRL                          3L
#define CRYPT_VERIFY_CERT_SIGN_SUBJECT_OCSP_BASIC_SIGNED_RESPONSE   4L

/* Certificate issuer types */
#define CRYPT_VERIFY_CERT_SIGN_ISSUER_PUBKEY    1L
#define CRYPT_VERIFY_CERT_SIGN_ISSUER_CERT      2L
#define CRYPT_VERIFY_CERT_SIGN_ISSUER_CHAIN     3L
#define CRYPT_VERIFY_CERT_SIGN_ISSUER_NULL      4L

/* Encoded signature function names */
#define CRYPT_OID_EXTRACT_ENCODED_SIGNATURE_PARAMETERS_FUNC \
    "CryptDllExtractEncodedSignatureParameters"
#define CRYPT_OID_SIGN_AND_ENCODE_HASH_FUNC     "CryptDllSignAndEncodeHash"
#define CRYPT_OID_VERIFY_ENCODED_SIGNATURE_FUNC "CryptDllVerifyEncodedSignature"

/* CryptInstallDefaultContext() flags */
#define CRYPT_DEFAULT_CONTEXT_AUTO_RELEASE_FLAG 0x00000001L
#define CRYPT_DEFAULT_CONTEXT_PROCESS_FLAG      0x00000002L

/* CryptInstallDefaultContext() default types */
#define CRYPT_DEFAULT_CONTEXT_CERT_SIGN_OID         1L
#define CRYPT_DEFAULT_CONTEXT_MULTI_CERT_SIGN_OID   2L

/* Public key import/export function names */
#define CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FUNC           "CryptDllExportPublicKeyInfoEx"
#define CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_EX2_FUNC       "CryptDllExportPublicKeyInfoEx2"
#if (NTDDI_VERSION >= 0x06010000)
    #define CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FROM_BCRYPT_HANDLE_FUNC \
        "CryptDllExportPublicKeyInfoFromBCryptKeyHandle"
#endif
#define CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_FUNC           "CryptDllImportPublicKeyInfoEx"
#if (NTDDI_VERSION >= 0x06000000)
    #define CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_EX2_FUNC   "CryptDllImportPublicKeyInfoEx2"
#endif

/* CryptAcquireCertificatePrivateKey() flags */
#define CRYPT_ACQUIRE_CACHE_FLAG                0x00000001L
#define CRYPT_ACQUIRE_USE_PROV_INFO_FLAG        0x00000002L
#define CRYPT_ACQUIRE_COMPARE_KEY_FLAG          0x00000004L
#define CRYPT_ACQUIRE_NO_HEALING                0x00000008L
#define CRYPT_ACQUIRE_SILENT_FLAG               0x00000040L
#define CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK     0x00070000L
#define CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG     0x00010000L
#define CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG    0x00020000L
#define CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG      0x00040000L

/* CryptFindCertificateKeyProvInfo() flags */
#define CRYPT_FIND_USER_KEYSET_FLAG     0x00000001L
#define CRYPT_FIND_MACHINE_KEYSET_FLAG  0x00000002L
#define CRYPT_FIND_SILENT_KEYSET_FLAG   0x00000040L

/* Private key import/export function names */
#define CRYPT_OID_IMPORT_PRIVATE_KEY_INFO_FUNC  "CryptDllImportPrivateKeyInfoEx"
#define CRYPT_OID_EXPORT_PRIVATE_KEY_INFO_FUNC  "CryptDllExportPrivateKeyInfoEx"

/* Private key export flags */
#define CRYPT_DELETE_KEYSET CRYPT_DELETEKEYSET

/* Certificate name string types */
#define CERT_SIMPLE_NAME_STR    1L
#define CERT_OID_NAME_STR       2L
#define CERT_X500_NAME_STR      3L
#define CERT_XML_NAME_STR       4L

/* Certificate name string type flags */
#define CERT_NAME_STR_SEMICOLON_FLAG            0x40000000L
#define CERT_NAME_STR_NO_PLUS_FLAG              0x20000000L
#define CERT_NAME_STR_NO_QUOTING_FLAG           0x10000000L
#define CERT_NAME_STR_CRLF_FLAG                 0x08000000L
#define CERT_NAME_STR_COMMA_FLAG                0x04000000L
#define CERT_NAME_STR_REVERSE_FLAG              0x02000000L
#define CERT_NAME_STR_FORWARD_FLAG              0x01000000L
#define CERT_NAME_STR_DISABLE_IE4_UTF8_FLAG     0x00010000L
#define CERT_NAME_STR_ENABLE_T61_UNICODE_FLAG   0x00020000L
#define CERT_NAME_STR_ENABLE_UTF8_UNICODE_FLAG  0x00040000L
#define CERT_NAME_STR_FORCE_UTF8_DIR_STR_FLAG   0x00080000L
#define CERT_NAME_STR_DISABLE_UTF8_DIR_STR_FLAG 0x00100000L
#define CERT_NAME_STR_ENABLE_PUNYCODE_FLAG      0x00200000L

/* Certificate name types */
#define CERT_NAME_EMAIL_TYPE            1L
#define CERT_NAME_RDN_TYPE              2L
#define CERT_NAME_ATTR_TYPE             3L
#define CERT_NAME_SIMPLE_DISPLAY_TYPE   4L
#define CERT_NAME_FRIENDLY_DISPLAY_TYPE 5L
#define CERT_NAME_DNS_TYPE              6L
#define CERT_NAME_URL_TYPE              7L
#define CERT_NAME_UPN_TYPE              8L

/* Certificate name flags */
#define CERT_NAME_ISSUER_FLAG           0x00000001L
#define CERT_NAME_DISABLE_IE4_UTF8_FLAG 0x00010000L

/* Cryptographic message signing flags */
#define CRYPT_MESSAGE_BARE_CONTENT_OUT_FLAG         0x00000001L
#define CRYPT_MESSAGE_ENCAPSULATED_CONTENT_OUT_FLAG 0x00000002L
#define CRYPT_MESSAGE_KEYID_SIGNER_FLAG             0x00000004L
#define CRYPT_MESSAGE_SILENT_KEYSET_FLAG            0x00000040L

/* Cryptographic message encryption flags */
#define CRYPT_MESSAGE_KEYID_RECIPIENT_FLAG  0x00000004L

/* CryptQueryObject() object types */
#define CERT_QUERY_OBJECT_FILE  0x00000001L
#define CERT_QUERY_OBJECT_BLOB  0x00000002L

/* CryptQueryObject() content types */
#define CERT_QUERY_CONTENT_CERT                 1L
#define CERT_QUERY_CONTENT_CTL                  2L
#define CERT_QUERY_CONTENT_CRL                  3L
#define CERT_QUERY_CONTENT_SERIALIZED_STORE     4L
#define CERT_QUERY_CONTENT_SERIALIZED_CERT      5L
#define CERT_QUERY_CONTENT_SERIALIZED_CTL       6L
#define CERT_QUERY_CONTENT_SERIALIZED_CRL       7L
#define CERT_QUERY_CONTENT_PKCS7_SIGNED         8L
#define CERT_QUERY_CONTENT_PKCS7_UNSIGNED       9L
#define CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED   10L
#define CERT_QUERY_CONTENT_PKCS10               11L
#define CERT_QUERY_CONTENT_PFX                  12L
#define CERT_QUERY_CONTENT_CERT_PAIR            13L
#define CERT_QUERY_CONTENT_PFX_AND_LOAD         14L

/* CryptQueryObject() expected content type flags */
#define CERT_QUERY_CONTENT_FLAG_CERT            (1 << CERT_QUERY_CONTENT_CERT)
#define CERT_QUERY_CONTENT_FLAG_CTL             (1 << CERT_QUERY_CONTENT_CTL)
#define CERT_QUERY_CONTENT_FLAG_CRL             (1 << CERT_QUERY_CONTENT_CRL)
#define CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE \
    (1 << CERT_QUERY_CONTENT_SERIALIZED_STORE)
#define CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT \
    (1 << CERT_QUERY_CONTENT_SERIALIZED_CERT)
#define CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL \
    (1 << CERT_QUERY_CONTENT_SERIALIZED_CTL)
#define CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL \
    (1 << CERT_QUERY_CONTENT_SERIALIZED_CRL)
#define CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED    (1 << CERT_QUERY_CONTENT_PKCS7_SIGNED)
#define CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED  (1 << CERT_QUERY_CONTENT_PKCS7_UNSIGNED)
#define CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED \
    (1 << CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED)
#define CERT_QUERY_CONTENT_FLAG_PKCS10          (1 << CERT_QUERY_CONTENT_PKCS10)
#define CERT_QUERY_CONTENT_FLAG_PKX             (1 << CERT_QUERY_CONTENT_PFX)
#define CERT_QUERY_CONTENT_FLAG_CERT_PAIR       (1 << CERT_QUERY_CONTENT_CERT_PAIR)
#define CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD    (1 << CERT_QUERY_CONTENT_PFX_AND_LOAD)
#define CERT_QUERY_CONTENT_FLAG_ALL \
    (CERT_QUERY_CONTENT_FLAG_CERT | CERT_QUERY_CONTENT_FLAG_CTL | \
    CERT_QUERY_CONTENT_FLAG_CRL | CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE | \
    CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT | CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL | \
    CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL | CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED | \
    CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED | \
    CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED | CERT_QUERY_CONTENT_FLAG_PFX | \
    CERT_QUERY_CONTENT_FLAG_CERT_PAIR)

/* CryptQueryObject() format types */
#define CERT_QUERY_FORMAT_BINARY                1L
#define CERT_QUERY_FORMAT_BASE64_ENCODED        2L
#define CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED 3L

/* CryptQueryObject() expected format type flags */
#define CERT_QUERY_FORMAT_FLAG_BINARY           (1 << CERT_QUERY_FORMAT_BINARY)
#define CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED   (1 << CERT_QUERY_FORMAT_BASE64_ENCODED)
#define CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED \
    (1 << CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED)
#define CERT_QUERY_FORMAT_FLAG_ALL \
    (CERT_QUERY_FORMAT_FLAG_BINARY | CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED | \
    CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED)

/* Cryptographic credential object identifiers */
#define CREDENTIAL_OID_PASSWORD_CREDENTIALS_A   ((LPCSTR)1)
#define CREDENTIAL_OID_PASSWORD_CREDENTIALS_W   ((LPCSTR)2)
#ifdef UNICODE
    #define CREDENTIAL_OID_PASSWORD_CREDENTIALS CREDENTIAL_OID_PASSWORD_CREDENTIALS_W
#else
    #define CREDENTIAL_OID_PASSWORD_CREDENTIALS CREDENTIAL_OID_PASSWORD_CREDENTIALS_A
#endif

/* Scheme provider function names */
#define SCHEME_OID_RETRIEVE_ENCODED_OBJECT_FUNC     "SchemeDllRetrieveEncodedObject"
#define SCHEME_OID_RETRIEVE_ENCODED_OBJECTW_FUNC    "SchemeDllRetrieveEncodedObjectW"

/* Context provider function names */
#define CONTEXT_OID_CREATE_OBJECT_CONTEXT_FUNC  "ContextDllCreateObjectContext"

/* Context object identifiers */
#define CONTEXT_OID_CERTIFICATE ((LPCSTR)1)
#define CONTEXT_OID_CRL         ((LPCSTR)2)
#define CONTEXT_OID_CTL         ((LPCSTR)3)
#define CONTEXT_OID_PKCS7       ((LPCSTR)4)
#define CONTEXT_OID_CAPI2_ANY   ((LPCSTR)5)
#define CONTEXT_OID_OCSP_RESP   ((LPCSTR)6)

/* Remote object retrieval flags */
#define CRYPT_RETRIEVE_MULTIPLE_OBJECTS         0x00000001L
#define CRYPT_CACHE_ONLY_RETRIEVAL              0x00000002L
#define CRYPT_WIRE_ONLY_RETRIEVAL               0x00000004L
#define CRYPT_DONT_CACHE_RESULT                 0x00000008L
#define CRYPT_ASYNC_RETRIEVAL                   0x00000010L
#define CRYPT_STICKY_CACHE_RETRIEVAL            0x00001000L
#define CRYPT_LDAP_SCOPE_BASE_ONLY_RETRIEVAL    0x00002000L
#define CRYPT_OFFLINE_CHECK_RETRIEVAL           0x00004000L
#define CRYPT_LDAP_INSERT_ENTRY_ATTRIBUTE       0x00008000L
#define CRYPT_LDAP_SIGN_RETRIEVAL               0x00010000L
#define CRYPT_NO_AUTH_RETRIEVAL                 0x00020000L
#define CRYPT_LDAP_AREC_EXCLUSIVE_RETRIEVAL     0x00040000L
#define CRYPT_AIA_RETRIEVAL                     0x00080000L
#define CRYPT_HTTP_POST_RETRIEVAL               0x00100000L
#define CRYPT_PROXY_CACHE_RETRIEVAL             0x00200000L
#define CRYPT_NOT_MODIFIED_RETRIEVAL            0x00400000L
#define CRYPT_VERIFY_CONTEXT_SIGNATURE          0x00000020L
#define CRYPT_VERIFY_DATA_HASH                  0x00000040L
#define CRYPT_KEEP_TIME_VALID                   0x00000080L
#define CRYPT_DONT_VERIFY_SIGNATURE             0x00000100L
#define CRYPT_DONT_CHECK_TIME_VALIDITY          0x00000200L
#define CRYPT_CHECK_FRESHNESS_TIME_VALIDITY     0x00000400L
#define CRYPT_ACCUMULATE_TIMEOUT                0x00000800L
#define CRYPT_OCSP_ONLY_RETRIEVAL               0x01000000L

/* Pre-fetch object types */
#define CRYPTNET_URL_CACHE_PRE_FETCH_NONE           0L
#define CRYPTNET_URL_CACHE_PRE_FETCH_BLOB           1L
#define CRYPTNET_URL_CACHE_PRE_FETCH_CRL            2L
#define CRYPTNET_URL_CACHE_PRE_FETCH_OCSP           3L
#define CRYPTNET_URL_CACHE_PRE_FETCH_AUTOROOT_CAB   5L

/* URL cache exempt seconds special values */
#define CRYPTNET_URL_CACHE_DEFAULT_FLUSH    0x00000000L
#define CRYPTNET_URL_CACHE_DISABLE_FLUSH    0xFFFFFFFFL

/* URL cache response types */
#define CRYPTNET_URL_CACHE_RESPONSE_NONE    0
#define CRYPTNET_URL_CACHE_RESPONSE_HTTP    1

/* URL cache response flags */
#define CRYPTNET_URL_CACHE_RESPONSE_VALIDATED   0x8000

/* Asynchronous handle special values */
#define CRYPT_PARAM_ASYNC_RETRIEVAL_COMPLETION  ((LPCSTR)1)
#define CRYPT_PARAM_CANCEL_ASYNC_RETRIEVAL      ((LPCSTR)2)

/* Cryptographic URL flags */
#define CRYPT_GET_URL_FROM_PROPERTY         0x00000001L
#define CRYPT_GET_URL_FROM_EXTENSION        0x00000002L
#define CRYPT_GET_URL_FROM_UNAUTH_ATTRIBUTE 0x00000004L
#define CRYPT_GET_URL_FROM_AUTH_ATTRIBUTE   0x00000008L

/* Cryptographic URL function names */
#define URL_OID_GET_OBJECT_URL_FUNC "UrlDllGetObjectUrl"

/* Cryptographic URL object identifiers */
#define URL_OID_CERTIFICATE_ISSUER                  ((LPCSTR)1)
#define URL_OID_CERTIFICATE_CRL_DIST_POINT          ((LPCSTR)2)
#define URL_OID_CTL_ISSUER                          ((LPCSTR)3)
#define URL_OID_CTL_NEXT_UPDATE                     ((LPCSTR)4)
#define URL_OID_CRL_ISSUER                          ((LPCSTR)5)
#define URL_OID_CERTIFICATE_FRESHEST_CRL            ((LPCSTR)6)
#define URL_OID_CRL_FRESHEST_CRL                    ((LPCSTR)7)
#define URL_OID_CROSS_CERT_DIST_POINT               ((LPCSTR)8)
#define URL_OID_CERTIFICATE_OCSP                    ((LPCSTR)9)
#define URL_OID_CERTIFICATE_OCSP_AND_CRL_DIST_POINT ((LPCSTR)10)
#define URL_OID_CERTIFICATE_CRL_DIST_POINT_AND_OCSP ((LPCSTR)11)
#define URL_OID_CROSS_CERT_SUBJECT_INFO_ACCESS      ((LPCSTR)12)
#define URL_OID_CERTIFICATE_ONLY_OCSP               ((LPCSTR)13)

/* Time valid object function names */
#define TIME_VALID_OID_GET_OBJECT_FUNC      "TimeValidDllGetObject"
#define TIME_VALID_OID_FLUSH_OBJECT_FUNC    "TimeValidDllFlushObject"

/* Time valid object identifiers */
#define TIME_VALID_OID_GET_CTL                      ((LPCSTR)1)
#define TIME_VALID_OID_GET_CRL                      ((LPCSTR)2)
#define TIME_VALID_OID_GET_CRL_FROM_CERT            ((LPCSTR)3)
#define TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CERT   ((LPCSTR)4)
#define TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CRL    ((LPCSTR)5)
#define TIME_VALID_OID_FLUSH_CTL                    ((LPCSTR)1)
#define TIME_VALID_OID_FLUSH_CRL                    ((LPCSTR)2)
#define TIME_VALID_OID_FLUSH_CRL_FROM_CERT          ((LPCSTR)3)
#define TIME_VALID_OID_FLUSH_FRESHEST_CRL_FROM_CERT ((LPCSTR)4)
#define TIME_VALID_OID_FLUSH_FRESHEST_CRL_FORM_CRL  ((LPCSTR)5)

/* Cryptographic protection default provider */
#define CRYPTPROTECT_DEFAULT_PROVIDER   { 0xDF9D8CD0, 0x1501, 0x11D1, { 0x8C, 0x7A, 0x00, 0xC0, 0x4F, 0xC2, 0x97, 0xEB } }

/* Cryptographic protection prompt flags */
#define CRYPTPROTECT_PROMPT_ON_UNPROTECT    0x00000001L
#define CRYPTPROTECT_PROMPT_ON_PROTECT      0x00000002L
#define CRYPTPROTECT_PROMPT_RESERVED        0x00000004L
#define CRYPTPROTECT_PROMPT_STRONG          0x00000008L
#define CRYPTPROTECT_PROMPT_REQUIRE_STRONG  0x00000010L

/* CryptProtectData() and CryptUnprotectData() flags */
#define CRYPTPROTECT_UI_FORBIDDEN           0x00000001L
#define CRYPTPROTECT_LOCAL_MACHINE          0x00000004L
#define CRYPTPROTECT_CRED_SYNC              0x00000008L
#define CRYPTPROTECT_AUDIT                  0x00000010L
#define CRYPTPROTECT_NO_RECOVERY            0x00000020L
#define CRYPTPROTECT_VERIFY_PROTECTION      0x00000040L
#define CRYPTPROTECT_CRED_REGENERATE        0x00000080L
#define CRYPTPROTECT_FIRST_RESERVED_FLAGVAL 0x0FFFFFFFL
#define CRYPTPROTECT_LAST_RESERVED_FLAGVAL  0xFFFFFFFFL

/* CryptProtectMemory() and CryptUnprotectMemory() buffer length */
#define CRYPTPROTECTMEMORY_BLOCK_SIZE   16

/* CryptProtectMemory() and CryptUnprotectMemory() flags */
#define CRYPTPROTECTMEMORY_SAME_PROCESS     0x00000000L
#define CRYPTPROTECTMEMORY_CROSS_PROCESS    0x00000001L
#define CRYPTPROTECTMEMORY_SAME_LOGON       0x00000002L

/* CertCreateSelfSignCertificate() flags */
#define CERT_CREATE_SELFSIGN_NO_SIGN        0x00000001L
#define CERT_CREATE_SELFSIGN_NO_KEY_INFO    0x00000002L

/* CryptGetKeyIdentifierProperty() flags */
#define CRYPT_KEYID_MACHINE_FLAG    0x00000020L
#define CRYPT_KEYID_ALLOC_FLAG      0x00008000L

/* CryptSetKeyIdentifierProperty() flags */
#define CRYPT_KEYID_DELETE_FLAG     0x00000010L
#define CRYPT_KEYID_SET_NEW_FLAG    0x00002000L

/* Certificate chaining registry paths */
#define CERT_CHAIN_CONFIG_REGPATH \
    L"Software\\Microsoft\\Cryptography\\OID\\EncodingType 0\\CertDllCreateCertificateChainEngine\\Config"
#define CERT_CHAIN_MAX_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME  L"MaxUrlRetrievalByteCount"
#define CERT_CHAIN_MAX_URL_RETRIEVAL_BYTE_COUNT_DEFAULT     (100 * 1024 * 1024)
#define CERT_CHAIN_CACHE_RESYNC_FILETIME_VALUE_NAME         L"ChainCacheResyncFiletime"
#define CERT_CHAIN_DISABLE_MANDATORY_BASIC_CONSTRAINTS_VALUE_NAME \
    L"DisableMandatoryBasicConstraints"
#define CERT_CHAIN_DISABLE_CA_NAME_CONSTRAINTS_VALUE_NAME   L"DisableCANameConstraints"
#define CERT_CHAIN_DISABLE_UNSUPPORTED_CRITICAL_EXTENSIONS_VALUE_NAME \
    L"DisableUnsupportedCriticalExtensions"
#define CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_VALUE_NAME     L"MaxAIAUrlCountInCert"
#define CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_DEFAULT        5L
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_VALUE_NAME \
    L"MaxAIAUrlRetrievalCountPerChain"
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_DEFAULT    10L
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME \
    L"MaxAIAUrlRetrievalByteCount"
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_DEFAULT 100000L
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_VALUE_NAME \
    L"MaxAIAUrlRetrievalCertCount"
#define CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_DEFAULT 3L
#define CERT_CHAIN_OCSP_VALIDITY_SECONDS_VALUE_NAME         L"OcspValiditySeconds"
#define CERT_CHAIN_OCSP_VALIDITY_SECONDS_DEFAULT            (12 * 60 * 60)
#define CERT_SRV_OCSP_RESP_MIN_VALIDITY_SECONDS_VALUE_NAME \
    L"SrvOcspRespMinValiditySeconds"
#define CERT_SRV_OCSP_RESP_MIN_VALIDITY_SECONDS_DEFAULT     (10 * 60)
#define CERT_SRV_OCSP_RESP_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME \
    L"SrvOcspRespUrlRetrievalTimeoutMilliseconds"
#define CERT_SRV_OCSP_RESP_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_DEFAULT   (15 * 1000)
#define CERT_SRV_OCSP_RESP_MAX_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME \
    L"SrvOcspRespMaxBeforeNextUpdateSeconds"
#define CERT_SRV_OCSP_RESP_MAX_BEFORE_NEXT_UPDATE_SECONDS_DEFAULT   (4 * 60 * 60)
#define CERT_SRV_OCSP_RESP_MIN_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME \
    L"SrvOcspRespMinBeforeNextUpdateSeconds"
#define CERT_SRV_OCSP_RESP_MIN_BEFORE_NEXT_UPDATE_SECONDS_DEFAULT   (2 * 60)
#define CERT_SRV_OCSP_RESP_MIN_AFTER_NEXT_UPDATE_SECONDS_VALUE_NAME \
    L"SrvOcspRespMinAfterNextUpdateSeconds"
#define CERT_SRV_OCSP_RESP_MIN_AFTER_NEXT_UPDATE_SECONDS_DEFAULT    (1 * 60)
#define CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_VALUE_NAME \
    L"CryptnetMaxCachedOcspPerCrlCount"
#define CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_DEFAULT      500L
#define CRYPTNET_OCSP_AFTER_CRL_DISABLE                     0xFFFFFFFFL
#define CRYPTNET_URL_CACHE_DEFAULT_FLUSH_EXEMPT_SECONDS_VALUE_NAME \
    L"CryptnetDefaultFlushExemptSeconds"
#define CRYPTNET_URL_CACHE_DEFAULT_FLUSH_EXEMPT_SECONDS_DEFAULT (28 * 24 * 60 * 60)
#define CRYPTNET_PRE_FETCH_MIN_MAX_AGE_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchMinMaxAgeSeconds"
#define CRYPTNET_PRE_FETCH_MIN_MAX_AGE_SECONDS_DEFAULT      (1 * 60 * 60)
#define CRYPTNET_PRE_FETCH_MAX_MAX_AGE_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchMaxMaxAgeSeconds"
#define CRYPTNET_PRE_FETCH_MAX_MAX_AGE_SECONDS_DEFAULT      (14 * 24 * 60 * 60)
#define CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_VALUE_NAME \
    L"CryptnetPreFetchAfterPublishPreFetchDivisor"
#define CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_DEFAULT  10L
#define CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME \
    L"CryptnetPreFetchBeforeNextUpdatePreFetchDivisor"
#define CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT 20L
#define CRYPTNET_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchMinBeforeNextUpdatePreFetchSeconds"
#define CRYPTNET_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_DEFAULT \
    (1 * 60 * 60)
#define CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME \
    L"CryptnetPreFetchValidityPeriodAfterNextUpdatePreFetchDivisor"
#define CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT \
    10L
#define CRYPTNET_PRE_FETCH_MAX_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchMaxAfterNextUpdatePreFetchPeriodSeconds"
#define CRYPTNET_PRE_FETCH_MAX_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_DEFAULT \
    (4 * 60 * 60)
#define CRYPTNET_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchMinAfterNextUpdatePreFetchPeriodSeconds"
#define CRYPTNET_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_DEFAULT \
    (30 * 60)
#define CRYPTNET_PRE_FETCH_AFTER_CURRENT_TIME_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchAfterCurrentTimePreFetchPeriodSeconds"
#define CRYPTNET_PRE_FETCH_AFTER_CURRENT_TIME_PRE_FETCH_PERIOD_SECONDS_DEFAULT \
    (30 * 60)
#define CRYPTNET_PRE_FETCH_TRIGGER_PERIOD_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchTriggerPeriodSeconds"
#define CRYPTNET_PRE_FETCH_TRIGGER_PERIOD_SECONDS_DEFAULT   (10 * 60)
#define CRYPTNET_PRE_FETCH_TRIGGER_DISABLE                  0xFFFFFFFFL
#define CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchScanAfterTriggerDelaySeconds"
#define CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_DEFAULT 30L
#define CRYPTNET_PRE_FETCH_RETRIEVAL_TIMEOUT_SECONDS_VALUE_NAME \
    L"CryptnetPreFetchRetrievalTimeoutSeconds"
#define CRYPTNET_PRE_FETCH_RETRIEVAL_TIMEOUT_SECONDS_DEFAULT    (5 * 60)
#define CERT_GROUP_POLICY_CHAIN_CONFIG_REGPATH \
    CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH L"\\ChainEngine\\Config"
#define CERT_CHAIN_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME \
    L"ChainUrlRetrievalTimeoutMilliseconds"
#define CERT_CHAIN_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_DEFAULT   (15 * 1000)
#define CERT_CHAIN_REV_ACCUMULATIVE_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME \
    L"ChainRevAccumulativeUrlRetrievalTimeoutMilliseconds"
#define CERT_CHAIN_REV_ACCUMULATIVE_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_DEFAULT \
    (20 * 1000)
#define CERT_RETR_BEHAVIOR_INET_AUTH_VALUE_NAME             L"EnableInetUnknownAuth"
#define CERT_RETR_BEHAVIOR_INET_STATUS_VALUE_NAME           L"EnableInetLocal"
#define CERT_RETR_BEHAVIOR_FILE_VALUE_NAME                  L"AllowFileUrlScheme"
#define CERT_RETR_BEHAVIOR_LDAP_VALUE_NAME                  L"DisableLDAPSignAndEncrypt"
#define CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_VALUE_NAME \
    L"CryptnetCachedOcspSwitchToCrlCount"
#define CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_DEFAULT    50L
#define CRYPTNET_CRL_BEFORE_OCSP_ENABLE                     0xFFFFFFFFL
#define CERT_CHAIN_DISABLE_AIA_URL_RETRIEVAL_VALUE_NAME     L"DisableAIAUrlRetrieval"
#define CERT_CHAIN_OPTIONS_VALUE_NAME                       L"Options"
#define CERT_CHAIN_OPTION_DISABLE_AIA_URL_RETRIEVAL         0x00000002L
#define CERT_CHAIN_OPTION_ENABLE_SIA_URL_RETRIEVAL          0x00000004L
#define CERT_CHAIN_CROSS_CERT_DOWNLOAD_INTERVAL_HOURS_VALUE_NAME \
    L"CrossCertDownloadIntervalHours"
#define CERT_CHAIN_CROSS_CERT_DOWNLOAD_INTERVAL_HOURS_DEFAULT   (24 * 7)
#define CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_VALUE_NAME L"CRLValidityExtensionPeriod"
#define CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_DEFAULT    12L

/* Certificate chain engine handle special values */
#define HCCE_CURRENT_USER   ((HCERTCHAINENGINE)0x00000000L)
#define HCCE_LOCAL_MACHINE  ((HCERTCHAINENGINE)0x00000001L)

/* Certificate chain flags */
#define CERT_CHAIN_CACHE_END_CERT           0x00000001L
#define CERT_CHAIN_THREAD_STORE_SYNC        0x00000002L
#define CERT_CHAIN_CACHE_ONLY_URL_RETRIEVAL 0x00000004L
#define CERT_CHAIN_USE_LOCAL_MACHINE_STORE  0x00000008L
#define CERT_CHAIN_ENABLE_CACHE_AUTO_UPDATE 0x00000010L
#define CERT_CHAIN_ENABLE_SHARE_STORE       0x00000020L

/* Certificate trust error status flags */
#define CERT_TRUST_NO_ERROR                             0x00000000L
#define CERT_TRUST_IS_NOT_TIME_VALID                    0x00000001L
#define CERT_TRUST_IS_NOT_TIME_NESTED                   0x00000002L
#define CERT_TRUST_IS_REVOKED                           0x00000004L
#define CERT_TRUST_IS_NOT_SIGNATURE_VALID               0x00000008L
#define CERT_TRUST_IS_NOT_VALID_FOR_USAGE               0x00000010L
#define CERT_TRUST_IS_UNTRUSTED_ROOT                    0x00000020L
#define CERT_TRUST_REVOCATION_STATUS_UNKNOWN            0x00000040L
#define CERT_TRUST_IS_CYCLIC                            0x00000080L
#define CERT_TRUST_INVALID_EXTENSION                    0x00000100L
#define CERT_TRUST_INVALID_POLICY_CONSTRAINTS           0x00000200L
#define CERT_TRUST_INVALID_BASIC_CONSTRAINTS            0x00000400L
#define CERT_TRUST_INVALID_NAME_CONSTRAINTS             0x00000800L
#define CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT    0x00001000L
#define CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT      0x00002000L
#define CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT    0x00004000L
#define CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT         0x00008000L
#define CERT_TRUST_IS_OFFLINE_REVOCATION                0x01000000L
#define CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY             0x02000000L
#define CERT_TRUST_IS_EXPLICIT_DISTRUST                 0x04000000L
#define CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT       0x08000000L
#define CERT_TRUST_IS_PARTIAL_CHAIN                     0x00010000L
#define CERT_TRUST_CTL_IS_NOT_TIME_VALID                0x00020000L
#define CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID           0x00040000L
#define CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE           0x00080000L

/* Certificate trust information status flags */
#define CERT_TRUST_HAS_EXACT_MATCH_ISSUER           0x00000001L
#define CERT_TRUST_HAS_KEY_MATCH_ISSUER             0x00000002L
#define CERT_TRUST_HAS_NAME_MATCH_ISSUER            0x00000004L
#define CERT_TRUST_IS_SELF_SIGNED                   0x00000008L
#define CERT_TRUST_HAS_PREFERRED_ISSUER             0x00000100L
#define CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY        0x00000200L
#define CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS       0x00000400L
#define CERT_TRUST_IS_PEER_TRUSTED                  0x00000800L
#define CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED        0x00001000L
#define CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE    0x00002000L
#define CERT_TRUST_IS_COMPLEX_CHAIN                 0x00010000L

/* Usage match types */
#define USAGE_MATCH_TYPE_AND    0x00000000L
#define USAGE_MATCH_TYPE_OR     0x00000001L

/* Certificate chain flags */
#define CERT_CHAIN_REVOCATION_CHECK_END_CERT            0x10000000L
#define CERT_CHAIN_REVOCATION_CHECK_CHAIN               0x20000000L
#define CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT  0x40000000L
#define CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY          0x80000000L
#define CERT_CHAIN_REVOCATION_ACCUMULATIVE_TIMEOUT      0x08000000L
#define CERT_CHAIN_REVOCATION_CHECK_OCSP_CERT           0x04000000L
#define CERT_CHAIN_DISABLE_PASS1_QUALITY_FILTERING      0x00000040L
#define CERT_CHAIN_RETURN_LOWER_QUALITY_CONTEXTS        0x00000080L
#define CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE        0x00000100L
#define CERT_CHAIN_TIMESTAMP_TIME                       0x00000200L
#define CERT_CHAIN_ENABLE_PEER_TRUST                    0x00000400L
#define CERT_CHAIN_DISABLE_MY_PEER_TRUST                0x00000800L

/* CRL revocation object identifier */
#define REVOCATION_OID_CRL_REVOCATION   ((LPCSTR)1)

/* Certificate chain find types */
#define CERT_CHAIN_FIND_BY_ISSUER   1L

/* Certificate chain find by issuer flags */
#define CERT_CHAIN_FIND_BY_ISSUER_COMPARE_KEY_FLAG      0x00000001L
#define CERT_CHAIN_FIND_BY_ISSUER_COMPLEX_CHAIN_FLAG    0x00000002L
#define CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_URL_FLAG   0x00000004L
#define CERT_CHAIN_FIND_BY_ISSUER_LOCAL_MACHINE_FLAG    0x00000008L
#define CERT_CHAIN_FIND_BY_ISSUER_NO_KEY_FLAG           0x00004000L
#define CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_FLAG       0x00008000L

/* Certificate chain policy flags */
#define CERT_CHAIN_POLICY_IGNORE_NOT_TIME_VALID_FLAG                0x00000001L
#define CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG            0x00000002L
#define CERT_CHAIN_POLICY_IGNORE_NOT_TIME_NESTED_FLAG               0x00000004L
#define CERT_CHAIN_POLICY_IGNORE_INVALID_BASIC_CONSTRAINTS_FLAG     0x00000008L
#define CERT_CHAIN_POLICY_IGNORE_ALL_NOT_TIME_VALID_FLAGS \
    (CERT_CHAIN_POLICY_IGNORE_NOT_TIME_VALID_FLAG | \
    CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG | \
    CERT_CHAIN_POLICY_IGNORE_NOT_TIME_NESTED_FLAG)
#define CERT_CHAIN_POLICY_ALLOW_UNKNOWN_CA_FLAG                     0x00000010L
#define CERT_CHAIN_POLICY_IGNORE_WRONG_USAGE_FLAG                   0x00000020L
#define CERT_CHAIN_POLICY_IGNORE_INVALID_NAME_FLAG                  0x00000040L
#define CERT_CHAIN_POLICY_IGNORE_INVALID_POLICY_FLAG                0x00000080L
#define CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG               0x00000100L
#define CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG        0x00000200L
#define CERT_CHAIN_POLICY_IGNORE_CA_REV_UNKNOWN_FLAG                0x00000400L
#define CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG              0x00000800L
#define CERT_CHAIN_POLICY_IGNORE_ALL_REV_UNKNOWN_FLAGS \
    (CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG | \
    CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG | \
    CERT_CHAIN_POLICY_IGNORE_CA_REV_UNKNOWN_FLAG | \
    CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG)
#define CERT_CHAIN_POLICY_ALLOW_TESTROOT_FLAG                       0x00008000L
#define CERT_CHAIN_POLICY_TRUST_TESTROOT_FLAG                       0x00004000L
#define CERT_CHAIN_POLICY_IGNORE_NOT_SUPPORTED_CRITICAL_EXT_FLAG    0x00002000L
#define CERT_CHAIN_POLICY_IGNORE_PEER_TRUST_FLAG                    0x00001000L

/* Certificate chain policy function names */
#define CRYPT_OID_VERIFY_CERTIFICATE_CHAIN_POLICY_FUNC \
    "CertDllVerifyCertificateChainPolicy"

/* Predefined certificate chain policies */
#define CERT_CHAIN_POLICY_BASE              ((LPCSTR)1)
#define CERT_CHAIN_POLICY_AUTHENTICODE      ((LPCSTR)2)
#define CERT_CHAIN_POLICY_AUTHENTICODE_TS   ((LPCSTR)3)
#define CERT_CHAIN_POLICY_SSL               ((LPCSTR)4)
#define CERT_CHAIN_POLICY_BASIC_CONSTRAINTS ((LPCSTR)5)
#define CERT_CHAIN_POLICY_NT_AUTH           ((LPCSTR)6)
#define CERT_CHAIN_POLICY_MICROSOFT_ROOT    ((LPCSTR)7)
#define CERT_CHAIN_POLICY_EV                ((LPCSTR)8)

/* Authentication types */
#define AUTHTYPE_CLIENT 1L
#define AUTHTYPE_SERVER 2L

/* Certificate chain basic constraints */
#define BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_CA_FLAG         0x80000000L
#define BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_END_ENTITY_FLAG 0x40000000L

/* Microsoft root flags */
#define MICROSOFT_ROOT_CERT_CHAIN_POLICY_ENABLE_TEST_ROOT_FLAG  0x00010000L

/* Cryptographic string/binary conversion flags */
#define CRYPT_STRING_BASE64HEADER           0x00000000L
#define CRYPT_STRING_BASE64                 0x00000001L
#define CRYPT_STRING_BINARY                 0x00000002L
#define CRYPT_STRING_BASE64REQUESTHEADER    0x00000003L
#define CRYPT_STRING_HEX                    0x00000004L
#define CRYPT_STRING_HEXASCII               0x00000005L
#define CRYPT_STRING_BASE64_ANY             0x00000006L
#define CRYPT_STRING_ANY                    0x00000007L
#define CRYPT_STRING_HEX_ANY                0x00000008L
#define CRYPT_STRING_BASE64X509CRLHEADER    0x00000009L
#define CRYPT_STRING_HEXADDR                0x0000000AL
#define CRYPT_STRING_HEXASCIIADDR           0x0000000BL
#define CRYPT_STRING_HEXRAW                 0x0000000CL
#define CRYPT_STRING_HASHDATA               0x10000000L
#define CRYPT_STRING_STRICT                 0x20000000L
#define CRYPT_STRING_NOCRLF                 0x40000000L
#define CRYPT_STRING_NOCR                   0x80000000L

/* PFXImportCertStore() flags */
#define CRYPT_USER_KEYSET           0x00001000L
#define PKCS12_PREFER_CNG_KSP       0x00000100L
#define PKCS12_ALWAYS_CNG_KSP       0x00000200L
#define PKCS12_ALLOW_OVERWRITE_KEY  0x00004000L
#define PKCS12_NO_PERSIST_KEY       0x00008000L
#define PKCS12_IMPORT_RESERVED_MASK 0xFFFF0000L

/* PFXExportCertStoreEx() flags */
#define REPORT_NO_PRIVATE_KEY                   0x00000001L
#define REPORT_NOT_ABLE_TO_EXPORT_PRIVATE_KEY   0x00000002L
#define EXPORT_PRIVATE_KEYS                     0x00000004L
#define PKCS12_INCLUDE_EXTENDED_PROPERTIES      0x00000010L
#define PKCS12_EXPORT_RESERVED_MASK             0xFFFF0000L

/* Predefined logo types */
#define CERT_RETRIEVE_ISSUER_LOGO       ((LPCSTR)1)
#define CERT_RETRIEVE_SUBJECT_LOGO      ((LPCSTR)2)
#define CERT_RETRIEVE_COMMUNITY_LOGO    ((LPCSTR)3)

/* Predefined biometric types */
#define CERT_RETRIEVE_BIOMETRIC_PREDEFINED_BASE_TYPE    ((LPCSTR)1000)
#define CERT_RETRIEVE_BIOMETRIC_PICTURE_TYPE \
    (CERT_RETRIEVE_BIOMETRIC_PREDEFINED_BASE_TYPE + CERT_BIOMETRIC_PICTURE_TYPE)
#define CERT_RETRIEVE_BIOMETRIC_SIGNATURE_TYPE \
    (CERT_RETRIEVE_BIOMETRIC_PREDEFINED_BASE_TYPE + CERT_BIOMETRIC_SIGNATURE_TYPE)

/* Maximum number of certificate selection parameters */
#if (NTDDI_VERSION >= 0x06010000)
    #define CERT_SELECT_MAX_PARA    500
#endif

/* Certificate selection criteria types */
#if (NTDDI_VERSION >= 0x06010000)
    #define CERT_SELECT_BY_ENHKEY_USAGE         1L
    #define CERT_SELECT_BY_KEY_USAGE            2L
    #define CERT_SELECT_BY_POLICY_OID           3L
    #define CERT_SELECT_BY_PROV_NAME            4L
    #define CERT_SELECT_BY_EXTENSION            5L
    #define CERT_SELECT_BY_SUBJECT_HOST_NAME    6L
    #define CERT_SELECT_BY_ISSUER_ATTR          7L
    #define CERT_SELECT_BY_SUBJECT_ATTR         8L
    #define CERT_SELECT_BY_ISSUER_NAME          9L
    #define CERT_SELECT_BY_PUBLIC_KEY           10L
    #define CERT_SELECT_BY_TLS_SIGNATURES       11L
    #define CERT_SELECT_LAST                    CERT_SELECT_BY_TLS_SIGNATURES
    #define CERT_SELECT_MAX                     (CERT_SELECT_LAST * 3)
#endif

/* CertSelectCertificateChains() flags */
#if (NTDDI_VERSION >= 0x06010000)
    #define CERT_SELECT_ALLOW_EXPIRED               0x00000001L
    #define CERT_SELECT_TRUSTED_ROOT                0x00000002L
    #define CERT_SELECT_DISALLOW_SELFSIGNED         0x00000004L
    #define CERT_SELECT_HAS_PRIVATE_KEY             0x00000008L
    #define CERT_SELECT_HAS_KEY_FOR_SIGNATURE       0x00000010L
    #define CERT_SELECT_HAS_KEY_FOR_KEY_EXCHANGE    0x00000020L
    #define CERT_SELECT_HARDWARE_ONLY               0x00000040L
    #define CERT_SELECT_ALLOW_DUPLICATES            0x00000080L
#endif

/* Timestamp version number */
#if (NTDDI_VERSION >= 0x06010000)
    #define TIMESTAMP_VERSION   1L
#endif

/* Timestamp status values */
#if (NTDDI_VERSION >= 0x06010000)
    #define TIMESTAMP_STATUS_GRANTED            0L
    #define TIMESTAMP_STATUS_GRANTED_WITH_MDOS  1L
    #define TIMESTAMP_STATUS_REJECTED           2L
    #define TIMESTAMP_STATUS_WAITING            3L
    #define TIMESTAMP_STATUS_REVOCATION_WARNING 4L
    #define TIMESTAMP_STATUS_REVOKED            5L
#endif

/* Timestamp failure codes */
#if (NTDDI_VERSION >= 0x06010000)
    #define TIMESTAMP_FAILURE_BAD_ALG                   0
    #define TIMESTAMP_FAILURE_BAD_REQUEST               2
    #define TIMESTAMP_FAILURE_BAD_FORMAT                5
    #define TIMESTAMP_FAILURE_TIME_NOT_AVAILABLE        14
    #define TIMESTAMP_FAILURE_POLICY_NOT_SUPPORTED      15
    #define TIMESTAMP_FAILURE_EXTENSION_NOT_SUPPORTED   16
    #define TIMESTAMP_FAILURE_INFO_NOT_AVAILABLE        17
    #define TIMESTAMP_FAILURE_SYSTEM_FEATURE            25
#endif

/* CryptRetrieveTimeStamp() flags */
#if (NTDDI_VERSION >= 0x06010000)
    #define TIMESTAMP_DONT_HASH_DATA            0x00000001L
    #define TIMESTAMP_VERIFY_CONTEXT_SIGNATURE  0x00000020L
    #define TIMESTAMP_NO_AUTH_RETRIEVAL         0x00020000L
#endif

/* Provider vtable */
#if (NTDDI_VERSION < 0x05010000)
typedef struct _VTableProvStruc {
    DWORD   Version;
    FARPROC FuncVerifyImage;
    FARPROC FuncReturnhWnd;
    DWORD   dwProvType;
    BYTE    *pbContextInfo;
    DWORD   cbContextInfo;
    LPSTR   pszProvName;
} VTableProvStruc;
typedef VTableProvStruc *PVTableProvStruc;
#endif

/* CMS key information */
typedef struct _CMS_KEY_INFO {
    DWORD   dwVersion;
    ALG_ID  Algid;
    BYTE    *pbOID;
    DWORD   cbOID;
} CMS_KEY_INFO;
typedef CMS_KEY_INFO    *PCMS_KEY_INFO;

/* HMAC information */
typedef struct _HMAC_Info {
    ALG_ID  HashAlgid;
    BYTE    *pbInnerString;
    DWORD   cbInnerString;
    BYTE    *pbOuterString;
    DWORD   cbOuterString;
} HMAC_INFO;
typedef HMAC_INFO   *PHMAC_INFO;

/* SChannel algorithm information */
typedef struct _SCHANNEL_ALG {
    DWORD   dwUse;
    ALG_ID  Algid;
    DWORD   cBits;
    DWORD   dwFlags;
    DWORD   dwReserved;
} SCHANNEL_ALG;
typedef SCHANNEL_ALG    *PSCHANNEL_ALG;

/* Provider algorithm enumeration arguments */
typedef struct _PROV_ENUMALGS {
    ALG_ID  aiAlgid;
    DWORD   dwBitLen;
    DWORD   dwNameLen;
    CHAR    szName[20];
} PROV_ENUMALGS;

/* Provider algorithm enumeration arguments (extended version) */
typedef struct _PROV_ENUMALGS_EX {
    ALG_ID  aiAlgid;
    DWORD   dwDefaultLen;
    DWORD   dwMinLen;
    DWORD   dwMaxLen;
    DWORD   dwProtocols;
    DWORD   dwNameLen;
    CHAR    szName[20];
    DWORD   dwLongNameLen;
    CHAR    szLongName[20];
} PROV_ENUMALGS_EX;

/* Public key structure */
typedef struct _PUBLICKEYSTRUC {
    BYTE    bType;
    BYTE    bVersion;
    WORD    reserved;
    ALG_ID  aiKeyAlg;
} PUBLICKEYSTRUC;
typedef PUBLICKEYSTRUC  BLOBHEADER;

/* RSA public key */
typedef struct _RSAPUBKEY {
    DWORD   magic;
    DWORD   bitlen;
    DWORD   pubexp;
} RSAPUBKEY;

/* Public key */
typedef struct _PUBKEY {
    DWORD   magic;
    DWORD   bitlen;
} DHPUBKEY;
typedef DHPUBKEY    DSSPUBKEY;
typedef DHPUBKEY    KEAPUBKEY;
typedef DHPUBKEY    TEKPUBKEY;

/* DSS seed */
typedef struct _DSSSEED {
    DWORD   counter;
    BYTE    seed[20];
} DSSSEED;

/* Public key (version 3) */
typedef struct _PUBKEYVER3 {
    DWORD   magic;
    DWORD   bitlenP;
    DWORD   bitlenQ;
    DWORD   bitlenJ;
    DSSSEED DSSSeed;
} DHPUBKEY_VER3;
typedef DHPUBKEY_VER3   DSSPUBKEY_VER3;

/* Private key (version 3) */
typedef struct _PRIVKEYVER3 {
    DWORD   magic;
    DWORD   bitlenP;
    DWORD   bitlenQ;
    DWORD   bitlenJ;
    DWORD   bitlenX;
    DSSSEED DSSSeed;
} DHPRIVKEY_VER3;
typedef DHPRIVKEY_VER3  DSSPRIVKEY_VER3;

/* Key type subtype */
typedef struct _KEY_TYPE_SUBTYPE {
    DWORD   dwKeySpec;
    GUID    Type;
    GUID    Subtype;
} KEY_TYPE_SUBTYPE;
typedef KEY_TYPE_SUBTYPE    *PKEY_TYPE_SUBTYPE;

/* Certificate Fortezza data property */
typedef struct _CERT_FORTEZZA_DATA_PROP {
    unsigned char   SerialNumber[8];
    int             CertIndex;
    unsigned char   CertLabel[36];
} CERT_FORTEZZA_DATA_PROP;

/* Cryptographic RC4 key state */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _CRYPT_RC4_KEY_STATE {
    unsigned char   Key[16];
    unsigned char   SBox[256];
    unsigned char   i;
    unsigned char   j;
} CRYPT_RC4_KEY_STATE;
typedef CRYPT_RC4_KEY_STATE *PCRYPT_RC4_KEY_STATE;
#endif

/* Cryptographic DES key state */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _CRYPT_DES_KEY_STATE {
    unsigned char   Key[8];
    unsigned char   IV[8];
    unsigned char   Feedback[8];
} CRYPT_DES_KEY_STATE;
typedef CRYPT_DES_KEY_STATE *PCRYPT_DES_KEY_STATE;
#endif

/* Cryptographic 3DES key state */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _CRYPT_3DES_KEY_STATE {
    unsigned char   Key[24];
    unsigned char   IV[8];
    unsigned char   Feedback[8];
} CRYPT_3DES_KEY_STATE;
typedef CRYPT_3DES_KEY_STATE    *PCRYPT_3DES_KEY_STATE;
#endif

/* Cryptographic AES 128-bit key state */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _CRYPT_AES_128_KEY_STATE {
    unsigned char   Key[16];
    unsigned char   IV[16];
    unsigned char   EncryptionState[11][16];
    unsigned char   DecryptionState[11][16];
    unsigned char   Feedback[16];
} CRYPT_AES_128_KEY_STATE;
typedef CRYPT_AES_128_KEY_STATE *PCRYPT_AES_128_KEY_STATE;
#endif

/* Cryptographic AES 256-bit key state */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _CRYPT_AES_256_KEY_STATE {
    unsigned char   Key[32];
    unsigned char   IV[16];
    unsigned char   EncryptionState[15][16];
    unsigned char   DecryptionState[15][16];
    unsigned char   Feedback[16];
} CRYPT_AES_256_KEY_STATE;
typedef CRYPT_AES_256_KEY_STATE *PCRYPT_AES_256_KEY_STATE;
#endif

/* Cryptographic blob */
typedef struct _CRYPTOAPI_BLOB {
    DWORD   cbData;
    BYTE    *pbData;
} CRYPT_INTEGER_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_INTEGER_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_UINT_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_UINT_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_OBJID_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_OBJID_BLOB;
typedef CRYPT_INTEGER_BLOB  CERT_NAME_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCERT_NAME_BLOB;
typedef CRYPT_INTEGER_BLOB  CERT_RDN_VALUE_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCERT_RDN_VALUE_BLOB;
typedef CRYPT_INTEGER_BLOB  CERT_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCERT_BLOB;
typedef CRYPT_INTEGER_BLOB  CRL_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRL_BLOB;
typedef CRYPT_INTEGER_BLOB  DATA_BLOB;
typedef CRYPT_INTEGER_BLOB  *PDATA_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_DATA_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_DATA_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_HASH_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_HASH_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_DIGEST_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_DIGEST_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_DER_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_DER_BLOB;
typedef CRYPT_INTEGER_BLOB  CRYPT_ATTR_BLOB;
typedef CRYPT_INTEGER_BLOB  *PCRYPT_ATTR_BLOB;

/* CMS Diffie-Hellman key information */
typedef struct _CMS_DH_KEY_INFO {
    DWORD           dwVersion;
    ALG_ID          Algid;
    LPSTR           pszContentEncObjId;
    CRYPT_DATA_BLOB PubInfo;
    void            *pReserved;
} CMS_DH_KEY_INFO;
typedef CMS_DH_KEY_INFO *PCMS_DH_KEY_INFO;

/* Cryptographic key limits */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    DWORD   dwVersion;
    ALG_ID  algId;
    DWORD   dwMinKeyLength;
    DWORD   dwMaxKeyLength;
    DWORD   dwRequiredFlags;
    DWORD   dwDisallowedFlags;
} _CRYPT_KEY_LIMITS_V01;
typedef _CRYPT_KEY_LIMITS_V01   CRYPT_KEY_LIMITS;
typedef _CRYPT_KEY_LIMITS_V01   *PCRYPT_KEY_LIMITS;
#endif

/* Cryptographic bit blob */
typedef struct _CRYPT_BIT_BLOB {
    DWORD   cbData;
    BYTE    *pbData;
    DWORD   cUnusedBits;
} CRYPT_BIT_BLOB;
typedef CRYPT_BIT_BLOB  *PCRYPT_BIT_BLOB;

/* Cryptographic algorithm identifier */
typedef struct _CRYPT_ALGORITHM_IDENTIFIER {
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Parameters;
} CRYPT_ALGORITHM_IDENTIFIER;
typedef CRYPT_ALGORITHM_IDENTIFIER  *PCRYPT_ALGORITHM_IDENTIFIER;

/* Cryptographic object identifier table */
typedef struct _CRYPT_OBJID_TABLE {
    DWORD   dwAlgId;
    LPCSTR  pszObjId;
} CRYPT_OBJID_TABLE;
typedef CRYPT_OBJID_TABLE   *PCRYPT_OBJID_TABLE;

/* Cryptographic hash information */
typedef struct _CRYPT_HASH_INFO {
     CRYPT_ALGORITHM_IDENTIFIER HashAlgorithm;
     CRYPT_HASH_BLOB            Hash;
} CRYPT_HASH_INFO;
typedef CRYPT_HASH_INFO *PCRYPT_HASH_INFO;

/* Certificate extension */
typedef struct _CERT_EXTENSION {
    LPSTR               pszObjId;
    BOOL                fCritical;
    CRYPT_OBJID_BLOB    Value;
} CERT_EXTENSION;
typedef CERT_EXTENSION          *PCERT_EXTENSION;
typedef const CERT_EXTENSION    *PCCERT_EXTENSION;

/* Cryptographic attribute value types */
typedef struct _CRYPT_ATTRIBUTE_TYPE_VALUE {
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Value;
} CRYPT_ATTRIBUTE_TYPE_VALUE;
typedef CRYPT_ATTRIBUTE_TYPE_VALUE  *PCRYPT_ATTRIBUTE_TYPE_VALUE;

/* Cryptographic attribute */
typedef struct _CRYPT_ATTRIBUTE {
    LPSTR               pszObjId;
    DWORD               cValue;
    PCRYPT_ATTR_BLOB    rgValue;
} CRYPT_ATTRIBUTE;
typedef CRYPT_ATTRIBUTE *PCRYPT_ATTRIBUTE;

/* Cryptographic attributes */
typedef struct _CRYPT_ATTRIBUTES {
    DWORD               cAttr;
    PCRYPT_ATTRIBUTE    rgAttr;
} CRYPT_ATTRIBUTES;
typedef CRYPT_ATTRIBUTES    *PCRYPT_ATTRIBUTES;

/* Certificate Relative Distinguished Name (RDN) attribute */
typedef struct _CERT_RDN_ATTR {
    LPSTR               pszObjId;
    DWORD               dwValueType;
    CERT_RDN_VALUE_BLOB Value;
} CERT_RDN_ATTR;
typedef CERT_RDN_ATTR   *PCERT_RDN_ATTR;

/* Certificate RDN */
typedef struct _CERT_RDN {
    DWORD           cRDNAttr;
    PCERT_RDN_ATTR  rgRDNAttr;
} CERT_RDN;
typedef CERT_RDN    *PCERT_RDN;

/* Certificate name information */
typedef struct _CERT_NAME_INFO {
    DWORD       cRDN;
    PCERT_RDN   rgRDN;
} CERT_NAME_INFO;
typedef CERT_NAME_INFO  *PCERT_NAME_INFO;

/* Certificate name value */
typedef struct _CERT_NAME_VALUE {
    DWORD               dwValueType;
    CERT_RDN_VALUE_BLOB Value;
} CERT_NAME_VALUE;
typedef CERT_NAME_VALUE *PCERT_NAME_VALUE;

/* Certificate public key information */
typedef struct _CERT_PUBLIC_KEY_INFO {
    CRYPT_ALGORITHM_IDENTIFIER  Algorithm;
    CRYPT_BIT_BLOB              PublicKey;
} CERT_PUBLIC_KEY_INFO;
typedef CERT_PUBLIC_KEY_INFO    *PCERT_PUBLIC_KEY_INFO;

/* Cryptographic private key information */
typedef struct _CRYPT_PRIVATE_KEY_INFO {
    DWORD                       Version;
    CRYPT_ALGORITHM_IDENTIFIER  Algorithm;
    CRYPT_DER_BLOB              PrivateKey;
    PCRYPT_ATTRIBUTES           pAttributes;
} CRYPT_PRIVATE_KEY_INFO;
typedef CRYPT_PRIVATE_KEY_INFO  *PCRYPT_PRIVATE_KEY_INFO;

/* Encrypted private key information */
typedef struct _CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    CRYPT_ALGORITHM_IDENTIFIER  EncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedPrivateKey;
} CRYPT_ENCRYPTED_PRIVATE_KEY_INFO;
typedef CRYPT_ENCRYPTED_PRIVATE_KEY_INFO    *PCRYPT_ENCRYPTED_PRIVATE_KEY_INFO;

/* Private key callback functions */
typedef BOOL (CALLBACK *PCRYPT_DECRYPT_PRIVATE_KEY_FUNC)( CRYPT_ALGORITHM_IDENTIFIER, CRYPT_DATA_BLOB, BYTE *, DWORD *, LPVOID );
typedef BOOL (CALLBACK *PCRYPT_ENCRYPT_PRIVATE_KEY_FUNC)( CRYPT_ALGORITHM_IDENTIFIER *, CRYPT_DATA_BLOB *, BYTE *, DWORD *, LPVOID );
typedef BOOL (CALLBACK *PCRYPT_RESOLVE_HCRYPTPROV_FUNC)( CRYPT_PRIVATE_KEY_INFO *, HCRYPTPROV *, LPVOID );

/* Cryptographic PKCS8 import parameters */
typedef struct _CRYPT_PKCS8_IMPORT_PARAMS {
    CRYPT_DIGEST_BLOB               PrivateKey;
    PCRYPT_RESOLVE_HCRYPTPROV_FUNC  pResolvehCryptProvFunc;
    LPVOID                          pVoidResolveFunc;
    PCRYPT_DECRYPT_PRIVATE_KEY_FUNC pDecryptPrivateKeyFunc;
    LPVOID                          pVoidDecryptFunc;
} CRYPT_PKCS8_IMPORT_PARAMS;
typedef CRYPT_PKCS8_IMPORT_PARAMS   *PCRYPT_PKCS8_IMPORT_PARAMS;
typedef CRYPT_PKCS8_IMPORT_PARAMS   CRYPT_PRIVATE_KEY_BLOB_AND_PARAMS;
typedef CRYPT_PKCS8_IMPORT_PARAMS   *PCRYPT_PRIVATE_KEY_BLOB_AND_PARAMS;

/* Cryptographic PKCS8 export parameters */
typedef struct _CRYPT_PKCS8_EXPORT_PARAMS {
    HCRYPTPROV                      hCryptProv;
    DWORD                           dwKeySpec;
    LPSTR                           pszPrivateKeyObjId;
    PCRYPT_ENCRYPT_PRIVATE_KEY_FUNC pEncryptPrivateKeyFunc;
    LPVOID                          pVoidEncryptFunc;
} CRYPT_PKCS8_EXPORT_PARAMS;
typedef CRYPT_PKCS8_EXPORT_PARAMS   *PCRYPT_PKCS8_EXPORT_PARAMS;

/* Certificate information */
typedef struct _CERT_INFO {
    DWORD                       dwVersion;
    CRYPT_INTEGER_BLOB          SerialNumber;
    CRYPT_ALGORITHM_IDENTIFIER  SignatureAlgorithm;
    CERT_NAME_BLOB              Issuer;
    FILETIME                    NotBefore;
    FILETIME                    NotAfter;
    CERT_NAME_BLOB              Subject;
    CERT_PUBLIC_KEY_INFO        SubjectPublicKeyInfo;
    CRYPT_BIT_BLOB              IssuerUniqueId;
    CRYPT_BIT_BLOB              SubjectUniqueId;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} CERT_INFO;
typedef CERT_INFO   *PCERT_INFO;

/* Certificate Revocation List (CRL) entry */
typedef struct _CRL_ENTRY {
    CRYPT_INTEGER_BLOB  SerialNumber;
    FILETIME            RevocationDate;
    DWORD               cExtension;
    PCERT_EXTENSION     rgExtension;
} CRL_ENTRY;
typedef CRL_ENTRY   *PCRL_ENTRY;

/* CRL information */
typedef struct _CRL_INFO {
    DWORD                       dwVersion;
    CRYPT_ALGORITHM_IDENTIFIER  SignatureAlgorithm;
    CERT_NAME_BLOB              Issuer;
    FILETIME                    ThisUpdate;
    FILETIME                    NextUpdate;
    DWORD                       cCRLEntry;
    PCRL_ENTRY                  rgCRLEntry;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} CRL_INFO;
typedef CRL_INFO    *PCRL_INFO;

/* Certificate or CRL blob */
typedef struct _CERT_OR_CRL_BLOB {
    DWORD   dwChoice;
    DWORD   cbEncoded;
    BYTE    *pbEncoded;
} CERT_OR_CRL_BLOB;
typedef CERT_OR_CRL_BLOB    *PCERT_OR_CRL_BLOB;

/* Certificate or CRL bundle */
typedef struct _CERT_OR_CRL_BUNDLE {
    DWORD               cItem;
    PCERT_OR_CRL_BLOB   rgItem;
} CERT_OR_CRL_BUNDLE;
typedef CERT_OR_CRL_BUNDLE  *PCERT_OR_CRL_BUNDLE;

/* Certificate request information */
typedef struct _CERT_REQUEST_INFO {
    DWORD                   dwVersion;
    CERT_NAME_BLOB          Subject;
    CERT_PUBLIC_KEY_INFO    SubjectPublicKeyInfo;
    DWORD                   cAttribute;
    PCRYPT_ATTRIBUTE        rgAttribute;
} CERT_REQUEST_INFO;
typedef CERT_REQUEST_INFO   *PCERT_REQUEST_INFO;

/* Certificate Keygen request information */
typedef struct _CERT_KEYGEN_REQUEST_INFO {
    DWORD                   dwVersion;
    CERT_PUBLIC_KEY_INFO    SubjectPublicKeyInfo;
    LPWSTR                  pwszChallengeString;
} CERT_KEYGEN_REQUEST_INFO;
typedef CERT_KEYGEN_REQUEST_INFO    *PCERT_KEYGEN_REQUEST_INFO;

/* Certificate signed content information */
typedef struct _CERT_SIGNED_CONTENT_INFO {
    CRYPT_DER_BLOB              ToBeSigned;
    CRYPT_ALGORITHM_IDENTIFIER  SignatureAlgorithm;
    CRYPT_BIT_BLOB              Signature;
} CERT_SIGNED_CONTENT_INFO;
typedef CERT_SIGNED_CONTENT_INFO    *PCERT_SIGNED_CONTENT_INFO;

/* Certificate Trust List (CTL) usage */
typedef struct _CTL_USAGE {
    DWORD   cUsageIdentifier;
    LPSTR   *rgpszUsageIdentifier;
} CTL_USAGE;
typedef CTL_USAGE       *PCTL_USAGE;
typedef const CTL_USAGE *PCCTL_USAGE;
typedef CTL_USAGE       CERT_ENHKEY_USAGE;
typedef CTL_USAGE       *PCERT_ENHKEY_USAGE;
typedef const CTL_USAGE *PCCERT_ENHKEY_USAGE;

/* CTL entry */
typedef struct _CTL_ENTRY {
    CRYPT_DATA_BLOB     SubjectIdentifier;
    DWORD               cAttribute;
    PCRYPT_ATTRIBUTE    rgAttribute;
} CTL_ENTRY;
typedef CTL_ENTRY   *PCTL_ENTRY;

/* CTL usage */
typedef struct _CTL_INFO {
    DWORD                       dwVersion;
    CTL_USAGE                   SubjectUsage;
    CRYPT_DATA_BLOB             ListIdentifier;
    CRYPT_INTEGER_BLOB          SequenceNumber;
    FILETIME                    ThisUpdate;
    FILETIME                    NextUpdate;
    CRYPT_ALGORITHM_IDENTIFIER  SubjectAlgorithm;
    DWORD                       cCTLEntry;
    PCTL_ENTRY                  rgCTLEntry;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} CTL_INFO;
typedef CTL_INFO    *PCTL_INFO;

/* Cryptographic time stamp request information */
typedef struct _CRYPT_TIME_STAMP_REQUEST_INFO {
    LPSTR               pszTimeStampAlgorithm;
    LPSTR               pszContentType;
    CRYPT_OBJID_BLOB    Content;
    DWORD               cAttribute;
    PCRYPT_ATTRIBUTE    rgAttribute;
} CRYPT_TIME_STAMP_REQUEST_INFO;
typedef CRYPT_TIME_STAMP_REQUEST_INFO   *PCRYPT_TIME_STAMP_REQUEST_INFO;

/* Cryptographic enrollment name/value pair */
typedef struct _CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    LPWSTR  pwszName;
    LPWSTR  pwszValue;
} CRYPT_ENROLLMENT_NAME_VALUE_PAIR;
typedef CRYPT_ENROLLMENT_NAME_VALUE_PAIR    *PCRYPT_ENROLLMENT_NAME_VALUE_PAIR;

/* Cryptographic Service Provider (CSP) */
typedef struct _CRYPT_CSP_PROVIDER {
    DWORD           dwKeySpec;
    LPWSTR          pwszProviderName;
    CRYPT_BIT_BLOB  Signature;
} CRYPT_CSP_PROVIDER;
typedef CRYPT_CSP_PROVIDER  *PCRYPT_CSP_PROVIDER;

/* Cryptographic memory management callbacks */
typedef LPVOID (WINAPI *PFN_CRYPT_ALLOC)( size_t );
typedef VOID (WINAPI *PFN_CRYPT_FREE)( LPVOID );

/* CryptEncodeObjectEx() parameters */
typedef struct _CRYPT_ENCODE_PARA {
    DWORD           cbSize;
    PFN_CRYPT_ALLOC pfnAlloc;
    PFN_CRYPT_FREE  pfnFree;
} CRYPT_ENCODE_PARA;
typedef CRYPT_ENCODE_PARA   *PCRYPT_ENCODE_PARA;

/* CryptDecodeObjectEx() parameters */
typedef struct _CRYPT_DECODE_PARA {
    DWORD           cbSize;
    PFN_CRYPT_ALLOC pfnAlloc;
    PFN_CRYPT_FREE  pfnFree;
} CRYPT_DECODE_PARA;
typedef CRYPT_DECODE_PARA   *PCRYPT_DECODE_PARA;

/* Certificate extensions */
typedef struct _CERT_EXTENSIONS {
    DWORD           cExtension;
    PCERT_EXTENSION rgExtension;
} CERT_EXTENSIONS;
typedef CERT_EXTENSIONS *PCERT_EXTENSIONS;

/* Certificate authority key identifier information */
typedef struct _CERT_AUTHORITY_KEY_ID_INFO {
    CRYPT_DATA_BLOB     KeyId;
    CERT_NAME_BLOB      CertIssuer;
    CRYPT_INTEGER_BLOB  CertSerialNumber;
} CERT_AUTHORITY_KEY_ID_INFO;
typedef CERT_AUTHORITY_KEY_ID_INFO  *PCERT_AUTHORITY_KEY_ID_INFO;

/* Certificate private key validity */
typedef struct _CERT_PRIVATE_KEY_VALIDITY {
    FILETIME    NotBefore;
    FILETIME    NotAfter;
} CERT_PRIVATE_KEY_VALIDITY;
typedef CERT_PRIVATE_KEY_VALIDITY   *PCERT_PRIVATE_KEY_VALIDITY;

/* Certificate key attributes information */
typedef struct _CERT_KEY_ATTRIBUTES_INFO {
    CRYPT_DATA_BLOB             KeyId;
    CRYPT_BIT_BLOB              IntendedKeyUsage;
    PCERT_PRIVATE_KEY_VALIDITY  pPrivateKeyUsagePeriod;
} CERT_KEY_ATTRIBUTES_INFO;
typedef CERT_KEY_ATTRIBUTES_INFO    *PCERT_KEY_ATTRIBUTES_INFO;

/* Certificate policy identifier */
typedef struct _CERT_POLICY_ID {
    DWORD   cCertPolicyElementId;
    LPSTR   *rgpszCertPolicyElementId;
} CERT_POLICY_ID;
typedef CERT_POLICY_ID  *PCERT_POLICY_ID;

/* Certificate key usage restriction information */
typedef struct _CERT_KEY_USAGE_RESTRICTION_INFO {
    DWORD           cCertPolicyId;
    PCERT_POLICY_ID rgCertPolicyId;
    CRYPT_BIT_BLOB  RestrictedKeyUsage;
} CERT_KEY_USAGE_RESTRICTION_INFO;
typedef CERT_KEY_USAGE_RESTRICTION_INFO *PCERT_KEY_USAGE_RESTRICTION_INFO;

/* Certificate other name */
typedef struct _CERT_OTHER_NAME {
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Value;
} CERT_OTHER_NAME;
typedef CERT_OTHER_NAME *PCERT_OTHER_NAME;

/* Certificate alternate name entry */
typedef struct _CERT_ALT_NAME_ENTRY {
    DWORD   dwAltNameChoice;
    union {
        PCERT_OTHER_NAME    pOtherName;
        LPWSTR              pwszRfc822Name;
        LPWSTR              pwszDNSName;
        CERT_NAME_BLOB      DirectoryName;
        LPWSTR              pwszURL;
        CRYPT_DATA_BLOB     IPAddress;
        LPSTR               pszRegisteredID;
    };
} CERT_ALT_NAME_ENTRY;
typedef CERT_ALT_NAME_ENTRY *PCERT_ALT_NAME_ENTRY;

/* Certificate alternate name information */
typedef struct _CERT_ALT_NAME_INFO {
    DWORD                   cAltEntry;
    PCERT_ALT_NAME_ENTRY    rgAltEntry;
} CERT_ALT_NAME_INFO;
typedef CERT_ALT_NAME_INFO  *PCERT_ALT_NAME_INFO;

/* Certificate basic constraints information */
typedef struct _CERT_BASIC_CONSTRAINTS_INFO {
    CRYPT_BIT_BLOB  SubjectType;
    BOOL            fPathLenConstraint;
    DWORD           dwPathLenConstraint;
    DWORD           cSubtreesConstraint;
    CERT_NAME_BLOB  *rgSubtreesConstraint;
} CERT_BASIC_CONSTRAINTS_INFO;
typedef CERT_BASIC_CONSTRAINTS_INFO *PCERT_BASIC_CONSTRAINTS_INFO;

/* Certificate basic constraints information (version 2) */
typedef struct _CERT_BASIC_CONSTRAINTS2_INFO {
    BOOL    fCA;
    BOOL    fPathLenConstraint;
    DWORD   dwPathLenConstraint;
} CERT_BASIC_CONSTRAINTS2_INFO;
typedef CERT_BASIC_CONSTRAINTS2_INFO    *PCERT_BASIC_CONSTRAINTS2_INFO;

/* Certificate policy qualifier information */
typedef struct _CERT_POLICY_QUALIFIER_INFO {
    LPSTR               pszPolicyQualifierId;
    CRYPT_OBJID_BLOB    Qualifier;
} CERT_POLICY_QUALIFIER_INFO;
typedef CERT_POLICY_QUALIFIER_INFO  *PCERT_POLICY_QUALIFIER_INFO;

/* Certificate policy information */
typedef struct _CERT_POLICY_INFO {
    LPSTR                       pszPolicyIdentifier;
    DWORD                       cPolicyQualifier;
    CERT_POLICY_QUALIFIER_INFO  *rgPolicyQualifier;
} CERT_POLICY_INFO;
typedef CERT_POLICY_INFO    *PCERT_POLICY_INFO;

/* Certificate policies information */
typedef struct _CERT_POLICIES_INFO {
    DWORD               cPolicyInfo;
    CERT_POLICY_INFO    *rgPolicyInfo;
} CERT_POLICIES_INFO;
typedef CERT_POLICIES_INFO  *PCERT_POLICIES_INFO;

/* Certificate policy qualifier notice reference */
typedef struct _CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    LPSTR   pszOrganization;
    DWORD   cNoticeNumbers;
    int     *rgNoticeNumbers;
} CERT_POLICY_QUALIFIER_NOTICE_REFERENCE;
typedef CERT_POLICY_QUALIFIER_NOTICE_REFERENCE  *PCERT_POLICY_QUALIFIER_NOTICE_REFERENCE;

/* Certificate policy qualifier user notice */
typedef struct _CERT_POLICY_QUALIFIER_USER_NOTICE {
    CERT_POLICY_QUALIFIER_NOTICE_REFERENCE  *pNoticeReference;
    LPWSTR                                  pszDisplayText;
} CERT_POLICY_QUALIFIER_USER_NOTICE;
typedef CERT_POLICY_QUALIFIER_USER_NOTICE   *PCERT_POLICY_QUALIFIER_USER_NOTICE;

/* CPS URLs */
typedef struct _CPS_URLS {
    LPWSTR                      pszURL;
    CRYPT_ALGORITHM_IDENTIFIER  *pAlgorithm;
    CRYPT_DATA_BLOB             *pDigest;
} CPS_URLS;
typedef CPS_URLS    *PCPS_URLS;

/* Certificate policy qualifier (version 1) */
typedef struct _CERT_POLICY95_QUALIFIER1 {
    LPWSTR      pszPracticesReference;
    LPSTR       pszNoticeIdentifier;
    LPSTR       pszNSINoticeIdentifier;
    DWORD       cCPSURLs;
    CPS_URLS    *rgCPSURLs;
} CERT_POLICY95_QUALIFIER1;
typedef CERT_POLICY95_QUALIFIER1    *PCERT_POLICY95_QUALIFIER1;

/* Certificate policy mapping */
typedef struct _CERT_POLICY_MAPPING {
    LPSTR   pszIssuerDomainPolicy;
    LPSTR   pszSubjectDomainPolicy;
} CERT_POLICY_MAPPING;
typedef CERT_POLICY_MAPPING *PCERT_POLICY_MAPPING;

/* Certificate policy mappings information */
typedef struct _CERT_POLICY_MAPPINGS_INFO {
    DWORD                   cPolicyMapping;
    PCERT_POLICY_MAPPING    rgPolicyMapping;
} CERT_POLICY_MAPPINGS_INFO;
typedef CERT_POLICY_MAPPINGS_INFO   *PCERT_POLICY_MAPPINGS_INFO;

/* Certificate policy constraints information */
typedef struct _CERT_POLICY_CONSTRAINTS_INFO {
    BOOL    fRequireExplicitPolicy;
    DWORD   dwRequireExplicitPolicySkipCerts;
    BOOL    fInhibitPolicyMapping;
    DWORD   dwInhibitPolicyMappingSkipCerts;
} CERT_POLICY_CONSTRAINTS_INFO;
typedef CERT_POLICY_CONSTRAINTS_INFO    *PCERT_POLICY_CONSTRAINTS_INFO;

/* Cryptographic content information sequence of any */
typedef struct _CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    LPSTR           pszObjId;
    DWORD           cValue;
    PCRYPT_DER_BLOB rgValue;
} CRYPT_CONTENT_SEQUENCE_OF_ANY;
typedef CRYPT_CONTENT_SEQUENCE_OF_ANY   *PCRYPT_CONTENT_SEQUENCE_OF_ANY;

/* Cryptographic content information */
typedef struct _CRYPT_CONTENT_INFO {
    LPSTR           pszObjId;
    CRYPT_DER_BLOB  Content;
} CRYPT_CONTENT_INFO;
typedef CRYPT_CONTENT_INFO  *PCRYPT_CONTENT_INFO;

/* Cryptographic sequence of any */
typedef struct _CRYPT_SEQUENCE_OF_ANY {
    DWORD           cValue;
    PCRYPT_DER_BLOB rgValue;
} CRYPT_SEQUENCE_OF_ANY;
typedef CRYPT_SEQUENCE_OF_ANY   *PCRYPT_SEQUENCE_OF_ANY;

/* Certificate authority key identifier information (version 2) */
typedef struct _CERT_AUTHORITY_KEY_ID2_INFO {
    CRYPT_DATA_BLOB     KeyId;
    CERT_ALT_NAME_INFO  AuthorityCertIssuer;
    CRYPT_INTEGER_BLOB  AuthorityCertSerialNumber;
} CERT_AUTHORITY_KEY_ID2_INFO;

/* Certificate access description */
typedef struct _CERT_ACCESS_DESCRIPTION {
    LPSTR               pszAccessMethod;
    CERT_ALT_NAME_ENTRY AccessLocation;
} CERT_ACCESS_DESCRIPTION;
typedef CERT_ACCESS_DESCRIPTION *PCERT_ACCESS_DESCRIPTION;

/* Certificate authority information access */
typedef struct _CERT_AUTHORITY_INFO_ACCESS {
    DWORD                       cAccDescr;
    PCERT_ACCESS_DESCRIPTION    rgAccDescr;
} CERT_AUTHORITY_INFO_ACCESS;
typedef CERT_AUTHORITY_INFO_ACCESS  *PCERT_AUTHORITY_INFO_ACCESS;
typedef CERT_AUTHORITY_INFO_ACCESS  CERT_SUBJECT_INFO_ACCESS;
typedef CERT_AUTHORITY_INFO_ACCESS  *PCERT_SUBJECT_INFO_ACCESS;

/* Certificate Revocation List (CRL) distribution point name */
typedef struct _CRL_DIST_POINT_NAME {
    DWORD   dwDistPointNameChoice;
    union {
        CERT_ALT_NAME_INFO  FullName;
    };
} CRL_DIST_POINT_NAME;
typedef CRL_DIST_POINT_NAME *PCRL_DIST_POINT_NAME;

/* CRL distribution point */
typedef struct _CRL_DIST_POINT {
    CRL_DIST_POINT_NAME DistPointName;
    CRYPT_BIT_BLOB      ReasonFlags;
    CERT_ALT_NAME_INFO  CRLIssuer;
} CRL_DIST_POINT;
typedef CRL_DIST_POINT  *PCRL_DIST_POINT;

/* CRL distribution points information */
typedef struct _CRL_DIST_POINTS_INFO {
    DWORD           cDistPoint;
    PCRL_DIST_POINT rgDistPoint;
} CRL_DIST_POINTS_INFO;
typedef CRL_DIST_POINTS_INFO    *PCRL_DIST_POINTS_INFO;

/* Cross certificate distribution points information */
typedef struct _CROSS_CERT_DIST_POINTS_INFO {
    DWORD               dwSyncDeltaTime;
    DWORD               cDistPoint;
    PCERT_ALT_NAME_INFO rgDistPoint;
} CROSS_CERT_DIST_POINTS_INFO;
typedef CROSS_CERT_DIST_POINTS_INFO *PCROSS_CERT_DIST_POINTS_INFO;

/* Certificate pair */
typedef struct _CERT_PAIR {
    CERT_BLOB   Forward;
    CERT_BLOB   Reverse;
} CERT_PAIR;
typedef CERT_PAIR   *PCERT_PAIR;

/* CRL issuing distribution point */
typedef struct _CRL_ISSUING_DIST_POINT {
    CRL_DIST_POINT_NAME DistPointName;
    BOOL                fOnlyContainsUserCerts;
    BOOL                fOnlyContainsCACerts;
    CRYPT_BIT_BLOB      OnlySomeReasonFlags;
    BOOL                fIndirectCRL;
} CRL_ISSUING_DIST_POINT;
typedef CRL_ISSUING_DIST_POINT  *PCRL_ISSUING_DIST_POINT;

/* Certificate general subtree */
typedef struct _CERT_GENERAL_SUBTREE {
    CERT_ALT_NAME_ENTRY Base;
    DWORD               dwMinimum;
    BOOL                fMaximum;
    DWORD               dwMaximum;
} CERT_GENERAL_SUBTREE;
typedef CERT_GENERAL_SUBTREE    *PCERT_GENERAL_SUBTREE;

/* Certificate name constraints information */
typedef struct _CERT_NAME_CONSTRAINTS_INFO {
    DWORD                   cPermittedSubtree;
    PCERT_GENERAL_SUBTREE   rgPermittedSubtree;
    DWORD                   cExcludedSubtree;
    PCERT_GENERAL_SUBTREE   rgExcludedSubtree;
} CERT_NAME_CONSTRAINTS_INFO;
typedef CERT_NAME_CONSTRAINTS_INFO  *PCERT_NAME_CONSTRAINTS_INFO;

/* Certificate DSS parameters */
typedef struct _CERT_DSS_PARAMETERS {
    CRYPT_UINT_BLOB p;
    CRYPT_UINT_BLOB q;
    CRYPT_UINT_BLOB g;
} CERT_DSS_PARAMETERS;
typedef CERT_DSS_PARAMETERS *PCERT_DSS_PARAMETERS;

/* Certificate Diffie-Hellman (DH) parameters */
typedef struct _CERT_DH_PARAMETERS {
    CRYPT_UINT_BLOB p;
    CRYPT_UINT_BLOB q;
} CERT_DH_PARAMETERS;
typedef CERT_DH_PARAMETERS  *PCERT_DH_PARAMETERS;

/* Certificate ECC signature */
typedef struct _CERT_ECC_SIGNATURE {
    CRYPT_UINT_BLOB r;
    CRYPT_UINT_BLOB s;
} CERT_ECC_SIGNATURE;
typedef CERT_ECC_SIGNATURE  *PCERT_ECC_SIGNATURE;

/* Certificate X942 DH validation parameters */
typedef struct _CERT_X942_DH_VALIDATION_PARAMS {
    CRYPT_BIT_BLOB  seed;
    DWORD           pgenCounter;
} CERT_X942_DH_VALIDATION_PARAMS;
typedef CERT_X942_DH_VALIDATION_PARAMS  *PCERT_X942_DH_VALIDATION_PARAMS;

/* Certificate X942 DH parameters */
typedef struct _CERT_X942_DH_PARAMETERS {
    CRYPT_UINT_BLOB                 p;
    CRYPT_UINT_BLOB                 g;
    CRYPT_UINT_BLOB                 q;
    CRYPT_UINT_BLOB                 j;
    PCERT_X942_DH_VALIDATION_PARAMS pValidationParams;
} CERT_X942_DH_PARAMETERS;
typedef CERT_X942_DH_PARAMETERS *PCERT_X942_DH_PARAMETERS;

/* Cryptographic X942 other information */
typedef struct _CRYPT_X942_OTHER_INFO {
    LPSTR           pszContentEncryptionObjId;
    BYTE            rgbCounter[CRYPT_X942_COUNTER_BYTE_LENGTH];
    BYTE            rgbKeyLength[CRYPT_X942_KEY_LENGTH_BYTE_LENGTH];
    CRYPT_DATA_BLOB PubInfo;
} CRYPT_X942_OTHER_INFO;
typedef CRYPT_X942_OTHER_INFO   *PCRYPT_X942_OTHER_INFO;

/* Cryptographic ECC CMS shared information */
typedef struct _CRYPT_ECC_CMS_SHARED_INFO {
    CRYPT_ALGORITHM_IDENTIFIER  Algorithm;
    CRYPT_DATA_BLOB             EntityUInfo;
    BYTE                        rgbSuppPubInfo[CRYPT_ECC_CMS_SHARED_INFO_SUPPPUBINFO_BYTE_LENGTH];
} CRYPT_ECC_CMS_SHARED_INFO;
typedef CRYPT_ECC_CMS_SHARED_INFO   *PCRYPT_ECC_CMS_SHARED_INFO;

/* Cryptographic RC2 CBC parameters */
typedef struct _CRYPT_RC2_CBC_PARAMETERS {
    DWORD   dwVersion;
    BOOL    fIV;
    BYTE    rgbIV[8];
} CRYPT_RC2_CBC_PARAMETERS;
typedef CRYPT_RC2_CBC_PARAMETERS    *PCRYPT_RC2_CBC_PARAMETERS;

/* Cryptographic SMIME capability */
typedef struct _CRYPT_SMIME_CAPABILITY {
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Parameters;
} CRYPT_SMIME_CAPABILITY;
typedef CRYPT_SMIME_CAPABILITY  *PCRYPT_SMIME_CAPABILITY;

/* Cryptographic SMIME capabilities */
typedef struct _CRYPT_SMIME_CAPABILITIES {
    DWORD                   cCapability;
    PCRYPT_SMIME_CAPABILITY rgCapability;
} CRYPT_SMIME_CAPABILITIES;
typedef CRYPT_SMIME_CAPABILITIES    *PCRYPT_SMIME_CAPABILITIES;

/* Qualified Certificate (QC) statement */
typedef struct _CERT_QC_STATEMENT {
    LPSTR               pszStatementId;
    CRYPT_OBJID_BLOB    StatementInfo;
} CERT_QC_STATEMENT;
typedef CERT_QC_STATEMENT   *PCERT_QC_STATEMENT;

/* QC statements extended information */
typedef struct _CERT_QC_STATEMENTS_EXT_INFO {
    DWORD               cStatement;
    PCERT_QC_STATEMENT  rgStatement;
} CERT_QC_STATEMENTS_EXT_INFO;
typedef CERT_QC_STATEMENTS_EXT_INFO *PCERT_QC_STATEMENTS_EXT_INFO;

/* Cryptographic mask generation algorithm */
typedef struct _CRYPT_MASK_GEN_ALGORITHM {
    LPSTR                       pszObjId;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
} CRYPT_MASK_GEN_ALGORITHM;
typedef CRYPT_MASK_GEN_ALGORITHM    *PCRYPT_MASK_GEN_ALGORITHM;

/* Cryptographic RSA SSA PSS parameters */
typedef struct _CRYPT_RSA_SSA_PSS_PARAMETERS {
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_MASK_GEN_ALGORITHM    MaskGenAlgorithm;
    DWORD                       dwSaltLength;
    DWORD                       dwTrailerField;
} CRYPT_RSA_SSA_PSS_PARAMETERS;
typedef CRYPT_RSA_SSA_PSS_PARAMETERS    *PCRYPT_RSS_SSA_PSS_PARAMETERS;

/* Cryptographic RSAES-OAEP algorithm */
typedef struct _CRYPT_PSOURCE_ALGORITHM {
    LPSTR           pszObjId;
    CRYPT_DATA_BLOB EncodingParameters;
} CRYPT_PSOURCE_ALGORITHM;
typedef CRYPT_PSOURCE_ALGORITHM *PCRYPT_PSOURCE_ALGORITHM;

/* Cryptographic RSAES-OAEP parameters */
typedef struct _CRYPT_RSAES_OAEP_PARAMETERS {
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_MASK_GEN_ALGORITHM    MaskGenAlgorithm;
    CRYPT_PSOURCE_ALGORITHM     PSourceAlogirthm;
} CRYPT_RSAES_OAEP_PARAMETERS;
typedef CRYPT_RSAES_OAEP_PARAMETERS *PCRYPT_RSAES_OAEP_PARAMETERS;

/* CMC tagged attribute */
typedef struct _CMC_TAGGED_ATTRIBUTE {
    DWORD           dwBodyPartID;
    CRYPT_ATTRIBUTE Attribute;
} CMC_TAGGED_ATTRIBUTE;
typedef CMC_TAGGED_ATTRIBUTE    *PCMC_TAGGED_ATTRIBUTE;

/* CMC tagged certificate request */
typedef struct _CMC_TAGGED_CERT_REQUEST {
    DWORD           dwBodyPartID;
    CRYPT_DER_BLOB  SignedCertRequest;
} CMC_TAGGED_CERT_REQUEST;
typedef CMC_TAGGED_CERT_REQUEST *PCMC_TAGGED_CERT_REQUEST;

/* CMC tagged request */
typedef struct _CMC_TAGGED_REQUEST {
    DWORD   dwTaggedRequestChoice;
    union {
        PCMC_TAGGED_CERT_REQUEST    pTaggedCertRequest;
    };
} CMC_TAGGED_REQUEST;
typedef CMC_TAGGED_REQUEST  *PCMC_TAGGED_REQUEST;

/* CMC tagged content information */
typedef struct _CMC_TAGGED_CONTENT_INFO {
    DWORD           dwBodyPartID;
    CRYPT_DER_BLOB  EncodedContentInfo;
} CMC_TAGGED_CONTENT_INFO;
typedef CMC_TAGGED_CONTENT_INFO *PCMC_TAGGED_CONTENT_INFO;

/* CMC tagged other message */
typedef struct _CMC_TAGGED_OTHER_MSG {
    DWORD               dwBodyPartID;
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Value;
} CMC_TAGGED_OTHER_MSG;
typedef CMC_TAGGED_OTHER_MSG    *PCMC_TAGGED_OTHER_MSG;

/* CMC data information */
typedef struct _CMC_DATA_INFO {
    DWORD                       cTaggedAttribute;
    PCMC_TAGGED_ATTRIBUTE       rgTaggedAttribute;
    DWORD                       cTaggedRequest;
    PCMC_TAGGED_REQUEST         rgTaggedRequest;
    DWORD                       cTaggedContentInfo;
    PCMC_TAGGED_CONTENT_INFO    rgTaggedContentInfo;
    DWORD                       cTaggedOtherMsg;
    PCMC_TAGGED_OTHER_MSG       rgTaggedOtherMsg;
} CMC_DATA_INFO;
typedef CMC_DATA_INFO   *PCMC_DATA_INFO;

/* CMC response information */
typedef struct _CMC_RESPONSE_INFO {
    DWORD                       cTaggedAttribute;
    PCMC_TAGGED_ATTRIBUTE       rgTaggedAttribute;
    DWORD                       cTaggedContentInfo;
    PCMC_TAGGED_CONTENT_INFO    rgTaggedContentInfo;
    DWORD                       cTaggedOtherMsg;
    PCMC_TAGGED_OTHER_MSG       rgTaggedOtherMsg;
} CMC_RESPONSE_INFO;
typedef CMC_RESPONSE_INFO   *PCMC_RESPONSE_INFO;

/* CMC pending information */
typedef struct _CMC_PEND_INFO {
    CRYPT_DATA_BLOB PendToken;
    FILETIME        PendTime;
} CMC_PEND_INFO;
typedef CMC_PEND_INFO   *PCMC_PEND_INFO;

/* CMC status information */
typedef struct _CMC_STATUS_INFO {
    DWORD   dwStatus;
    DWORD   cBodyList;
    DWORD   *rgdwBodyList;
    LPWSTR  pwszStatusString;
    DWORD   dwOtherInfoChoice;
    union {
        DWORD           dwFailInfo;
        PCMC_PEND_INFO  pPendInfo;
    };
} CMC_STATUS_INFO;
typedef CMC_STATUS_INFO *PCMC_STATUS_INFO;

/* CMC add extensions information */
typedef struct _CMC_ADD_EXTENSIONS_INFO {
    DWORD           dwCmcDataReference;
    DWORD           cCertReference;
    DWORD           *rgdwCertReference;
    DWORD           cExtension;
    PCERT_EXTENSION rgExtension;
} CMC_ADD_EXTENSIONS_INFO;
typedef CMC_ADD_EXTENSIONS_INFO *PCMC_ADD_EXTENSIONS_INFO;

/* CMC add attributes information */
typedef struct _CMC_ADD_ATTRIBUTES_INFO {
    DWORD               dwCmcDataReference;
    DWORD               cCertReference;
    DWORD               *rgdwCertReference;
    DWORD               cAttribute;
    PCRYPT_ATTRIBUTE    rgAttribute;
} CMC_ADD_ATTRIBUTES_INFO;
typedef CMC_ADD_ATTRIBUTES_INFO *PCMC_ADD_ATTRIBUTES_INFO;

/* Certificate template extension */
typedef struct _CERT_TEMPLATE_EXT {
    LPSTR   pszObjId;
    DWORD   dwMajorVersion;
    BOOL    fMinorVersion;
    DWORD   dwMinorVersion;
} CERT_TEMPLATE_EXT;
typedef CERT_TEMPLATE_EXT   *PCERT_TEMPLATE_EXT;

/* Certificate hashed URL */
typedef struct _CERT_HASHED_URL {
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_HASH_BLOB             Hash;
    LPWSTR                      pwszUrl;
} CERT_HASHED_URL;
typedef CERT_HASHED_URL *PCERT_HASHED_URL;

/* Certificate logotype details */
typedef struct _CERT_LOGOTYPE_DETAILS {
    LPWSTR              pwszMimeType;
    DWORD               cHashedUrl;
    PCERT_HASHED_URL    rgHashedUrl;
} CERT_LOGOTYPE_DETAILS;
typedef CERT_LOGOTYPE_DETAILS   *PCERT_LOGOTYPE_DETAILS;

/* Certificate logotype reference */
typedef struct _CERT_LOGOTYPE_REFERENCE {
    DWORD               cHashedUrl;
    PCERT_HASHED_URL    rgHashedUrl;
} CERT_LOGOTYPE_REFERENCE;
typedef CERT_LOGOTYPE_REFERENCE *PCERT_LOGOTYPE_REFERENCE;

/* Certificate logotype image information */
typedef struct _CERT_LOGOTYPE_IMAGE_INFO {
    DWORD   dwLogotypeImageInfoChoice;
    DWORD   dwFileSize;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwLogotypeImageResolutionChoice;
    union {
        DWORD   dwNumBits;
        DWORD   dwTableSize;
    };
    LPWSTR  pwszLanguage;
} CERT_LOGOTYPE_IMAGE_INFO;
typedef CERT_LOGOTYPE_IMAGE_INFO    *PCERT_LOGOTYPE_IMAGE_INFO;

/* Certificate logotype image */
typedef struct _CERT_LOGOTYPE_IMAGE {
    CERT_LOGOTYPE_DETAILS       LogotypeDetails;
    PCERT_LOGOTYPE_IMAGE_INFO   pLogotypeImageInfo;
} CERT_LOGOTYPE_IMAGE;
typedef CERT_LOGOTYPE_IMAGE *PCERT_LOGOTYPE_IMAGE;

/* Certificate logotype audio information */
typedef struct _CERT_LOGOTYPE_AUDIO_INFO {
    DWORD   dwFileSize;
    DWORD   dwPlayTime;
    DWORD   dwChannels;
    DWORD   dwSampleRate;
    LPWSTR  pwszLanguage;
} CERT_LOGOTYPE_AUDIO_INFO;
typedef CERT_LOGOTYPE_AUDIO_INFO    *PCERT_LOGOTYPE_AUDIO_INFO;

/* Certificate logotype audio */
typedef struct _CERT_LOGOTYPE_AUDIO {
    CERT_LOGOTYPE_DETAILS       LogotypeDetails;
    PCERT_LOGOTYPE_AUDIO_INFO   pLogotypeAudioInfo;
} CERT_LOGOTYPE_AUDIO;
typedef CERT_LOGOTYPE_AUDIO *PCERT_LOGOTYPE_AUDIO;

/* Certificate logotype data */
typedef struct _CERT_LOGOTYPE_DATA {
    DWORD                   cLogotypeImage;
    PCERT_LOGOTYPE_IMAGE    rgLogotypeImage;
    DWORD                   cLogotypeAudio;
    PCERT_LOGOTYPE_AUDIO    rgLogotypeAudio;
} CERT_LOGOTYPE_DATA;
typedef CERT_LOGOTYPE_DATA  *PCERT_LOGOTYPE_DATA;

/* Certificate logotype information */
typedef struct _CERT_LOGOTYPE_INFO {
    DWORD   dwLogotypeInfoChoice;
    union {
        PCERT_LOGOTYPE_DATA         pLogotypeDirectInfo;
        PCERT_LOGOTYPE_REFERENCE    pLogotypeIndirectInfo;
    };
} CERT_LOGOTYPE_INFO;
typedef CERT_LOGOTYPE_INFO  *PCERT_LOGOTYPE_INFO;

/* Certificate other logotype information */
typedef struct _CERT_OTHER_LOGOTYPE_INFO {
    LPSTR               pszObjId;
    CERT_LOGOTYPE_INFO  LogotypeInfo;
} CERT_OTHER_LOGOTYPE_INFO;
typedef CERT_OTHER_LOGOTYPE_INFO    *PCERT_OTHER_LOGOTYPE_INFO;

/* Certificate logotype extension information */
typedef struct _CERT_LOGOTYPE_EXT_INFO {
    DWORD                       cCommunityLogo;
    PCERT_LOGOTYPE_INFO         rgCommunityLogo;
    PCERT_LOGOTYPE_INFO         pIssuerLogo;
    PCERT_LOGOTYPE_INFO         pSubjectLogo;
    DWORD                       cOtherLogo;
    PCERT_OTHER_LOGOTYPE_INFO   rgOtherLogo;
} CERT_LOGOTYPE_EXT_INFO;
typedef CERT_LOGOTYPE_EXT_INFO  *PCERT_LOGOTYPE_EXT_INFO;

/* Certificate biometric data */
typedef struct _CERT_BIOMETRIC_DATA {
    DWORD           dwTypeOfBiometricDataChoice;
    union {
        DWORD   dwPredefined;
        LPSTR   pszObjId;
    };
    CERT_HASHED_URL HashedUrl;
} CERT_BIOMETRIC_DATA;
typedef CERT_BIOMETRIC_DATA *PCERT_BIOMETRIC_DATA;

/* Certificate biometric extension information */
typedef struct _CERT_BIOMETRIC_EXT_INFO {
    DWORD                   cBiometricData;
    PCERT_BIOMETRIC_DATA    rgBiometricData;
} CERT_BIOMETRIC_EXT_INFO;
typedef CERT_BIOMETRIC_EXT_INFO *PCERT_BIOMETRIC_EXT_INFO;

/* Online Certificate Status Protocol (OCSP) signature information */
typedef struct _OCSP_SIGNATURE_INFO {
    CRYPT_ALGORITHM_IDENTIFIER  SignatureAlgorithm;
    CRYPT_BIT_BLOB              Signature;
    DWORD                       cCertEncoded;
    PCERT_BLOB                  rgCertEncoded;
} OCSP_SIGNATURE_INFO;
typedef OCSP_SIGNATURE_INFO *POCSP_SIGNATURE_INFO;

/* OCSP signed request information */
typedef struct _OCSP_SIGNED_REQUEST_INFO {
    CRYPT_DER_BLOB          ToBeSigned;
    POCSP_SIGNATURE_INFO    pOptionalSignatureInfo;
} OCSP_SIGNED_REQUEST_INFO;
typedef OCSP_SIGNED_REQUEST_INFO    *POCSP_SIGNED_REQUEST_INFO;

/* OCSP certicate identifier */
typedef struct _OCSP_CERT_ID {
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_HASH_BLOB             IssuerNameHash;
    CRYPT_HASH_BLOB             IssuerKeyHash;
    CRYPT_INTEGER_BLOB          SerialNumber;
} OCSP_CERT_ID;
typedef OCSP_CERT_ID    *POCSP_CERT_ID;

/* OCSP request entry */
typedef struct _OCSP_REQUEST_ENTRY {
    OCSP_CERT_ID    CertId;
    DWORD           cExtension;
    PCERT_EXTENSION rgExtension;
} OCSP_REQUEST_ENTRY;
typedef OCSP_REQUEST_ENTRY  *POCSP_REQUEST_ENTRY;

/* OCSP request information */
typedef struct _OCSP_REQUEST_INFO {
    DWORD                   dwVersion;
    PCERT_ALT_NAME_ENTRY    pRequestorName;
    DWORD                   cRequestEntry;
    POCSP_REQUEST_ENTRY     rgRequestEntry;
    DWORD                   cExtension;
    PCERT_EXTENSION         rgExtension;
} OCSP_REQUEST_INFO;
typedef OCSP_REQUEST_INFO   *POCSP_REQUEST_INFO;

/* OCSP response information */
typedef struct _OCSP_RESPONSE_INFO {
    DWORD               dwStatus;
    LPSTR               pszObjId;
    CRYPT_OBJID_BLOB    Value;
} OCSP_RESPONSE_INFO;
typedef OCSP_RESPONSE_INFO  *POCSP_RESPONSE_INFO;

/* OCSP basic signed response information */
typedef struct _OCSP_BASIC_SIGNED_RESPONSE_INFO {
    CRYPT_DER_BLOB      ToBeSigned;
    OCSP_SIGNATURE_INFO SignatureInfo;
} OCSP_BASIC_SIGNED_RESPONSE_INFO;
typedef OCSP_BASIC_SIGNED_RESPONSE_INFO *POCSP_BASIC_SIGNED_RESPONSE_INFO;

/* OCSP basic revoked information */
typedef struct _OCSP_BASIC_REVOKED_INFO {
    FILETIME    RevocationDate;
    DWORD       dwCrlReasonCode;
} OCSP_BASIC_REVOKED_INFO;
typedef OCSP_BASIC_REVOKED_INFO *POCSP_BASIC_REVOKED_INFO;

/* OCSP basic response entry */
typedef struct _OCSP_BASIC_RESPONSE_ENTRY {
    OCSP_CERT_ID    CertId;
    DWORD           dwCertStatus;
    union {
        POCSP_BASIC_REVOKED_INFO    pRevokedInfo;
    };
    FILETIME        ThisUpdate;
    FILETIME        NextUpdate;
    DWORD           cExtension;
    PCERT_EXTENSION rgExtension;
} OCSP_BASIC_RESPONSE_ENTRY;
typedef OCSP_BASIC_RESPONSE_ENTRY   *POCSP_BASIC_RESPONSE_ENTRY;

/* OCSP basic response information */
typedef struct _OCSP_BASIC_RESPONSE_INFO {
    DWORD                       dwVersion;
    DWORD                       dwResponderIdChoice;
    union {
        CERT_NAME_BLOB  ByNameResponderId;
        CRYPT_HASH_BLOB ByKeyResponderId;
    };
    FILETIME                    ProducedAt;
    DWORD                       cResponseEntry;
    POCSP_BASIC_RESPONSE_ENTRY  rgResponseEntry;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} OCSP_BASIC_RESPONSE_INFO;
typedef OCSP_BASIC_RESPONSE_INFO    *POCSP_BASIC_RESPONSE_INFO;

/* Object Identifier (OID) function entry */
typedef struct _CRYPT_OID_FUNC_ENTRY {
    LPCSTR  pszOID;
    void    *pvFuncAddr;
} CRYPT_OID_FUNC_ENTRY;
typedef CRYPT_OID_FUNC_ENTRY    *PCRYPT_OID_FUNC_ENTRY;

/* OID enumeration callback */
typedef BOOL (WINAPI *PFN_CRYPT_ENUM_OID_FUNC)( DWORD, LPCSTR, LPCSTR, DWORD, const DWORD [], LPCWSTR const [], const BYTE * const [], const DWORD [], void * );

/* OID information */
typedef struct _CRYPT_OID_INFO {
    DWORD           cbSize;
    LPCSTR          pszOID;
    LPCWSTR         pwszName;
    DWORD           dwGroupId;
    union {
        DWORD   dwValue;
        ALG_ID  Algid;
        DWORD   dwLength;
    };
    CRYPT_DATA_BLOB ExtraInfo;
#ifdef CRYPT_OID_INFO_HAS_EXTRAS_FIELDS
    LPCWSTR         pwszCNGAlgid;
    LPCWSTR         pwszCNGExtraAlgid;
#endif
} CRYPT_OID_INFO;
typedef CRYPT_OID_INFO          *PCRYPT_OID_INFO;
typedef const CRYPT_OID_INFO    CCRYPT_OID_INFO;
typedef const CRYPT_OID_INFO    *PCCRYPT_OID_INFO;

/* OID information enumeration callback */
typedef BOOL (WINAPI *PFN_CRYPT_ENUM_OID_INFO)( PCCRYPT_OID_INFO, void * );

/* Certificate issuer serial number */
typedef struct _CERT_ISSUER_SERIAL_NUMBER {
    CERT_NAME_BLOB      Issuer;
    CRYPT_INTEGER_BLOB  SerialNumber;
} CERT_ISSUER_SERIAL_NUMBER;
typedef CERT_ISSUER_SERIAL_NUMBER   *PCERT_ISSUER_SERIAL_NUMBER;

/* Certificate identifier */
typedef struct _CERT_ID {
    DWORD   dwIdChoice;
    union {
        CERT_ISSUER_SERIAL_NUMBER   IssuerSerialNumber;
        CRYPT_HASH_BLOB             KeyId;
        CRYPT_HASH_BLOB             HashId;
    };
} CERT_ID;
typedef CERT_ID *PCERT_ID;

/* Cryptographic message signer encode information */
typedef struct _CMSG_SIGNER_ENCODE_INFO {
    DWORD                       cbSize;
    PCERT_INFO                  pCertInfo;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD                       dwKeySpec;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    void                        *pvHashAuxInfo;
    DWORD                       cAuthAttr;
    PCRYPT_ATTRIBUTE            rgAuthAttr;
    DWORD                       cUnauthAttr;
    PCRYPT_ATTRIBUTE            rgUnauthAttr;
#ifdef CMSG_SIGNER_ENCODE_INFO_HAS_CMS_FIELDS
    CERT_ID                     SignerId;
    CRYPT_ALGORITHM_IDENTIFIER  HashEncryptionAlgorithm;
    void                        *pvHashEncryptionAuxInfo;
#endif
} CMSG_SIGNER_ENCODE_INFO;
typedef CMSG_SIGNER_ENCODE_INFO *PCMSG_SIGNER_ENCODE_INFO;

/* Cryptographic message signed encode information */
typedef struct _CMSG_SIGNED_ENCODE_INFO {
    DWORD                       cbSize;
    DWORD                       cSigners;
    PCMSG_SIGNER_ENCODE_INFO    rgSigners;
    DWORD                       cCertEncoded;
    PCERT_BLOB                  rgCertEncoded;
    DWORD                       cCrlEncoded;
    PCRL_BLOB                   rgCrlEncoded;
#ifdef CMSG_SIGNED_ENCODE_INFO_HAS_CMS_FIELDS
    DWORD                       cAttrCertEncoded;
    PCERT_BLOB                  rgAttrCertEncoded;
#endif
} CMSG_SIGNED_ENCODE_INFO;
typedef CMSG_SIGNED_ENCODE_INFO *PCMSG_SIGNED_ENCODE_INFO;

/* Cryptographic message key transport recipient encode information */
typedef struct _CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    DWORD                       cbSize;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    void                        *pvKeyEncryptionAuxInfo;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_BIT_BLOB              RecipientPublicKey;
    CERT_ID                     RecipientId;
} CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO;
typedef CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO    *PCMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO;

/* Cryptographic message recipient encrypted key encode information */
typedef struct _CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    DWORD                       cbSize;
    CRYPT_BIT_BLOB              RecipientPublicKey;
    CERT_ID                     RecipientId;
    FILETIME                    Date;
    PCRYPT_ATTRIBUTE_TYPE_VALUE pOtherAttr;
} CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO;
typedef CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO    *PCMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO;

/* Cryptographic message key agreement recipient encode information */
typedef struct _CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    DWORD                       cbSize;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    void                        *pvKeyEncryptionAuxInfo;
    CRYPT_ALGORITHM_IDENTIFIER  KeyWrapAlgorithm;
    void                        *pvKeyWrapAuxInfo;
    HCRYPTPROV_LEGACY           hCryptProv;
    DWORD                       dwKeySpec;
    DWORD                       dwKeyChoice;
    union {
        PCRYPT_ALGORITHM_IDENTIFIER pEphemeralAlgorithm;
        PCERT_ID                    pSenderId;
    };
    CRYPT_DATA_BLOB             UserKeyingMaterial;
    DWORD                       cRecipientEncryptedKeys;
    PCMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO   *rgpRecipientEncryptedKeys;
} CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO;
typedef CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO    *PCMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO;

/* Cryptographic message mail list recipient encode information */
typedef struct _CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    DWORD                       cbSize;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    void                        *pvKeyEncryptionAuxInfo;
    HCRYPTPROV                  hCryptProv;
    DWORD                       dwKeyChoice;
    union {
        HCRYPTKEY   hKeyEncryptionKey;
        void        *pvKeyEncryptionKey;
    };
    CRYPT_DATA_BLOB             KeyId;
    FILETIME                    Date;
    PCRYPT_ATTRIBUTE_TYPE_VALUE pOtherAttr;
} CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO;
typedef CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO    *PCMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO;

/* Cryptographic message recipient encode information */
typedef struct _CMSG_RECIPIENT_ENCODE_INFO {
    DWORD   dwRecipientChoice;
    union {
        PCMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO   pKeyTrans;
        PCMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO   pKeyAgree;
        PCMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO   pMailList;
    };
} CMSG_RECIPIENT_ENCODE_INFO;
typedef CMSG_RECIPIENT_ENCODE_INFO  *PCMSG_RECIPIENT_ENCODE_INFO;

/* Cryptographic message enveloped encode information */
typedef struct _CMSG_ENVELOPED_ENCODE_INFO {
    DWORD                       cbSize;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_ALGORITHM_IDENTIFIER  ContentEncryptionAlgorithm;
    void                        *pvEncryptionAuxInfo;
    DWORD                       cRecipients;
    PCERT_INFO                  *rgpRecipients;
#ifdef CMSG_ENVELOPED_ENCODE_INFO_HAS_CMS_FIELDS
    PCMSG_RECIPIENT_ENCODE_INFO rgCmsRecipients;
    DWORD                       cCertEncoded;
    PCERT_BLOB                  rgCertEncoded;
    DWORD                       cCrlEncoded;
    PCRL_BLOB                   rgCrlEncoded;
    DWORD                       cAttrCertEncoded;
    PCERT_BLOB                  rgAttrCertEncoded;
    DWORD                       cUnprotectedAttr;
    PCRYPT_ATTRIBUTE            rgUnprotectedAttr;
#endif
} CMSG_ENVELOPED_ENCODE_INFO;
typedef CMSG_ENVELOPED_ENCODE_INFO  *PCMSG_ENVELOPED_ENCODE_INFO;

/* Cryptographic message RC2 auxiliary information */
typedef struct _CMSG_RC2_AUX_INFO {
    DWORD   cbSize;
    DWORD   dwBitLen;
} CMSG_RC2_AUX_INFO;
typedef CMSG_RC2_AUX_INFO   *PCMSG_RC2_AUX_INFO;

/* Cryptographic message SP3-compatible auxiliary information */
typedef struct _CMSG_SP3_COMPATIBLE_AUX_INFO {
    DWORD   cbSize;
    DWORD   dwFlags;
} CMSG_SP3_COMPATIBLE_AUX_INFO;
typedef CMSG_SP3_COMPATIBLE_AUX_INFO *PCMSG_SP3_COMPATIBLE_AUX_INFO;

/* Cryptographic message RC4 auxiliary information */
typedef struct _CMSG_RC4_AUX_INFO {
    DWORD   cbSize;
    DWORD   dwBitLen;
} CMSG_RC4_AUX_INFO;
typedef CMSG_RC4_AUX_INFO   *PCMSG_RC4_AUX_INFO;

/* Cryptographic message signed and enveloped encode information */
typedef struct _CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    DWORD                       cbSize;
    CMSG_SIGNED_ENCODE_INFO     SignedInfo;
    CMSG_ENVELOPED_ENCODE_INFO  EnvelopedInfo;
} CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO;
typedef CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO   *PCMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO;

/* Cryptographic message hashed encode information */
typedef struct _CMSG_HASHED_ENCODE_INFO {
    DWORD                       cbSize;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    void                        *pvHashAuxInfo;
} CMSG_HASHED_ENCODE_INFO;
typedef CMSG_HASHED_ENCODE_INFO *PCMSG_HASHED_ENCODE_INFO;

/* Cryptographic message encrypted encode information */
typedef struct _CMSG_ENCRYPTED_ENCODE_INFO {
    DWORD                       cbSize;
    CRYPT_ALGORITHM_IDENTIFIER  ContentEncryptedAlgorithm;
    void                        *pvEncryptionAuxInfo;
} CMSG_ENCRYPTED_ENCODE_INFO;
typedef CMSG_ENCRYPTED_ENCODE_INFO  *PCMSG_ENCRYPTED_ENCODE_INFO;

/* Cryptographic message stream output callback */
typedef BOOL (WINAPI *PFN_CMSG_STREAM_OUTPUT)( const void *, BYTE *, DWORD, BOOL );

/* Cryptographic message stream information */
typedef struct _CMSG_STREAM_INFO {
    DWORD                   cbContent;
    PFN_CMSG_STREAM_OUTPUT  pfnStreamOutput;
    void                    *pvArg;
} CMSG_STREAM_INFO;
typedef CMSG_STREAM_INFO    *PCMSG_STREAM_INFO;

/* Cryptographic message signer information */
typedef struct _CMSG_SIGNER_INFO {
    DWORD                       dwVersion;
    CERT_NAME_BLOB              Issuer;
    CRYPT_INTEGER_BLOB          SerialNumber;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_ALGORITHM_IDENTIFIER  HashEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedHash;
    CRYPT_ATTRIBUTES            AuthAttrs;
    CRYPT_ATTRIBUTES            UnauthAttrs;
} CMSG_SIGNER_INFO;
typedef CMSG_SIGNER_INFO    *PCMSG_SIGNER_INFO;

/* Cryptographic message CMS signer information */
typedef struct _CMSG_CMS_SIGNER_INFO {
    DWORD                       dwVersion;
    CERT_ID                     SignerId;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_ALGORITHM_IDENTIFIER  HashEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedHash;
    CRYPT_ATTRIBUTES            AuthAttrs;
    CRYPT_ATTRIBUTES            UnauthAttrs;
} CMSG_CMS_SIGNER_INFO;
typedef CMSG_CMS_SIGNER_INFO    *PCMSG_CMS_SIGNER_INFO;

/* Cryptographic message attributes */
typedef CRYPT_ATTRIBUTES    CMSG_ATTR;
typedef CRYPT_ATTRIBUTES    *PCMSG_ATTR;

/* Cryptographic message key transport recipient information */
typedef struct _CMSG_KEY_TRANS_RECIPIENT_INFO {
    DWORD                       dwVersion;
    CERT_ID                     RecipientId;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedKey;
} CMSG_KEY_TRANS_RECIPIENT_INFO;
typedef CMSG_KEY_TRANS_RECIPIENT_INFO   *PCMSG_KEY_TRANS_RECIPIENT_INFO;

/* Cryptographic message recipient encrypted key information */
typedef struct _CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    CERT_ID                     RecipientId;
    CRYPT_DATA_BLOB             EncryptedKey;
    FILETIME                    Date;
    PCRYPT_ATTRIBUTE_TYPE_VALUE pOtherAttr;
} CMSG_RECIPIENT_ENCRYPTED_KEY_INFO;
typedef CMSG_RECIPIENT_ENCRYPTED_KEY_INFO   *PCMSG_RECIPIENT_ENCRYPTED_KEY_INFO;

/* Cryptographic message key agreement recipient information */
typedef struct _CMSG_KEY_AGREE_RECIPIENT_INFO {
    DWORD                               dwVersion;
    DWORD                               dwOriginatorChoice;
    union {
        CERT_ID                 OriginatorCertId;
        CERT_PUBLIC_KEY_INFO    OrginiatorPublicKeyInfo;
    };
    CRYPT_DATA_BLOB                     UserKeyingMaterial;
    CRYPT_ALGORITHM_IDENTIFIER          KeyEncryptionAlgorithm;
    DWORD                               cRecipientEncryptedKeys;
    PCMSG_RECIPIENT_ENCRYPTED_KEY_INFO  *rgpRecipientEncryptedKeys;
} CMSG_KEY_AGREE_RECIPIENT_INFO;
typedef CMSG_KEY_AGREE_RECIPIENT_INFO   *PCMSG_KEY_AGREE_RECIPIENT_INFO;

/* Cryptographic message mail list recipient information */
typedef struct _CMSG_MAIL_LIST_RECIPIENT_INFO {
    DWORD                       dwVersion;
    CRYPT_DATA_BLOB             KeyId;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedKey;
    FILETIME                    Date;
    PCRYPT_ATTRIBUTE_TYPE_VALUE pOtherAttr;
} CMSG_MAIL_LIST_RECIPIENT_INFO;
typedef CMSG_MAIL_LIST_RECIPIENT_INFO   *PCMSG_MAIL_LIST_RECIPIENT_INFO;

/* Cryptographic message CMS recipient information */
typedef struct _CMSG_CMS_RECIPIENT_INFO {
    DWORD   dwRecipientChoice;
    union {
        PCMSG_KEY_TRANS_RECIPIENT_INFO  pKeyTrans;
        PCMSG_KEY_AGREE_RECIPIENT_INFO  pKeyAgree;
        PCMSG_MAIL_LIST_RECIPIENT_INFO  pMailList;
    };
} CMSG_CMS_RECIPIENT_INFO;
typedef CMSG_CMS_RECIPIENT_INFO *PCMSG_CMS_RECIPIENT_INFO;

/* CMSG_CTRL_VERIFY_SIGNATURE_EX parameters */
typedef struct _CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    DWORD               cbSize;
    HCRYPTPROV_LEGACY   hCryptProv;
    DWORD               dwSignerIndex;
    DWORD               dwSignerType;
    void                *pvSigner;
} CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA;
typedef CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA  *PCMSG_CTRL_VERIFY_SIGNATURE_EX_PARA;

/* CMSG_CTRL_DECRYPT parameters */
typedef struct _CMSG_CTRL_DECRYPT_PARA {
    DWORD   cbSize;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD   dwKeySpec;
    DWORD   dwRecipientIndex;
} CMSG_CTRL_DECRYPT_PARA;
typedef CMSG_CTRL_DECRYPT_PARA  *PCMSG_DECRYPT_PARA;

/* CMSG_CTRL_KEY_TRANS_DECRYPT parameters */
typedef struct _CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    DWORD                           cbSize;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD                           dwKeySpec;
    PCMSG_KEY_TRANS_RECIPIENT_INFO  pKeyTrans;
    DWORD                           dwRecipientIndex;
} CMSG_CTRL_KEY_TRANS_DECRYPT_PARA;
typedef CMSG_CTRL_KEY_TRANS_DECRYPT_PARA    *PCMSG_CTRL_KEY_TRANS_DECRYPT_PARA;

/* CMSG_CTRL_KEY_AGREE_DECRYPT parameters */
typedef struct _CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    DWORD                           cbSize;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD                           dwKeySpec;
    PCMSG_KEY_AGREE_RECIPIENT_INFO  pKeyAgree;
    DWORD                           dwRecipientIndex;
    DWORD                           dwRecipientEncryptedKeyIndex;
    CRYPT_BIT_BLOB                  OriginatorPublicKey;
} CMSG_CTRL_KEY_AGREE_DECRYPT_PARA;
typedef CMSG_CTRL_KEY_AGREE_DECRYPT_PARA    *PCMSG_CTRL_KEY_AGREE_DECRYPT_PARA;

/* CMSG_CTRL_MAIL_LIST_DECRYPT parameters */
typedef struct _CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    DWORD                           cbSize;
    HCRYPTPROV                      hCryptProv;
    PCMSG_MAIL_LIST_RECIPIENT_INFO  pMailList;
    DWORD                           dwRecipientIndex;
    DWORD                           dwKeyChoice;
    union {
        HCRYPTKEY   hKeyEncryptionKey;
        void        *pvKeyEncryptionKey;
    };
} CMSG_CTRL_MAIL_LIST_DECRYPT_PARA;
typedef CMSG_CTRL_MAIL_LIST_DECRYPT_PARA    *PCMSG_CTRL_MAIL_LIST_DECRYPT_PARA;

/* CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR parameters */
typedef struct _CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    DWORD           cbSize;
    DWORD           dwSignerIndex;
    CRYPT_DATA_BLOB blob;
} CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA;
typedef CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA   *PCMSG_ADD_SIGNER_UNAUTH_ATTR_PARA;

/* CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR parameters */
typedef struct _CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    DWORD           cbSize;
    DWORD           dwSignerIndex;
    DWORD           dwUnauthAttrIndex;
} CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA;
typedef CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA   *PCMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA;

/* Cryptographic message memory allocation callbacks */
typedef void *(WINAPI *PFN_CMSG_ALLOC)( size_t );
typedef void (WINAPI *PFN_CMSG_FREE)( void * );

/* Cryptographic message content encryption information */
typedef struct _CMSG_CONTENT_ENCRYPT_INFO {
    DWORD                       cbSize;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_ALGORITHM_IDENTIFIER  ContentEncryptionAlgorithm;
    void                        *pvEncryptionAuxInfo;
    DWORD                       cRecipients;
    PCMSG_RECIPIENT_ENCODE_INFO rgCmsRecipients;
    PFN_CMSG_ALLOC              pfnAlloc;
    PFN_CMSG_FREE               pfnFree;
    DWORD                       dwEncryptFlags;
    union {
        HCRYPTKEY           hContentEncryptKey;
        BCRYPT_KEY_HANDLE   hCNGContentEncryptKey;
    };
    DWORD                       dwFlags;
    BOOL                        fCNG;
    BYTE                        *pbCNGContentEncryptKeyObject;
    BYTE                        *pbContentEncryptKey;
    DWORD                       cbContentEncryptKey;
} CMSG_CONTENT_ENCRYPT_INFO;
typedef CMSG_CONTENT_ENCRYPT_INFO   *PCMSG_CONTENT_ENCRYPT_INFO;

/* Cryptographic message key transport encryption information */
typedef struct _CMSG_KEY_TRANS_ENCRYPT_INFO {
    DWORD                       cbSize;
    DWORD                       dwRecipientIndex;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedKey;
    DWORD                       dwFlags;
} CMSG_KEY_TRANS_ENCRYPT_INFO;
typedef CMSG_KEY_TRANS_ENCRYPT_INFO *PCMSG_KEY_TRANS_ENCRYPT_INFO;

/* Cryptographic message key agreement key encryption information */
typedef struct _CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    DWORD           cbSize;
    CRYPT_DATA_BLOB EncryptedKey;
} CMSG_KEY_AGREE_KEY_ENCRYPT_INFO;
typedef CMSG_KEY_AGREE_KEY_ENCRYPT_INFO *PCMSG_KEY_AGREE_KEY_ENCRYPT_INFO;

/* Cryptographic message key agreement encryption information */
typedef struct _CMSG_KEY_AGREE_ENCRYPT_INFO {
    DWORD                               cbSize;
    DWORD                               dwRecipientIndex;
    CRYPT_ALGORITHM_IDENTIFIER          KeyEncryptionAlgorithm;
    CRYPT_DATA_BLOB                     UserKeyingMaterial;
    DWORD                               dwOriginatorChoice;
    union {
        CERT_ID                 OriginatorCertId;
        CERT_PUBLIC_KEY_INFO    OriginatorPublicKeyInfo;
    };
    DWORD                               cKeyAgreeKeyEncryptInfo;
    PCMSG_KEY_AGREE_KEY_ENCRYPT_INFO    *rgpKeyAgreeKeyEncryptInfo;
    DWORD                               dwFlags;
} CMSG_KEY_AGREE_ENCRYPT_INFO;
typedef CMSG_KEY_AGREE_ENCRYPT_INFO *PCMSG_KEY_AGREE_ENCRYPT_INFO;

/* Cryptographic message mail list encryption information */
typedef struct _CMSG_MAIL_LIST_ENCRYPT_INFO {
    DWORD                       cbSize;
    DWORD                       dwRecipientIndex;
    CRYPT_ALGORITHM_IDENTIFIER  KeyEncryptionAlgorithm;
    CRYPT_DATA_BLOB             EncryptedKey;
    DWORD                       dwFlags;
} CMSG_MAIL_LIST_ENCRYPT_INFO;
typedef CMSG_MAIL_LIST_ENCRYPT_INFO *PCMSG_MAIL_LIST_ENCRYPT_INFO;

/* Cryptographic message CNG content decryption information */
typedef struct _CMSG_CNG_CONTENT_DECRYPT_INFO {
    DWORD                       cbSize;
    CRYPT_ALGORITHM_IDENTIFIER  ContentEncryptionAlgorithm;
    PFN_CMSG_ALLOC              pfnAlloc;
    PFN_CMSG_FREE               pfnFree;
    NCRYPT_KEY_HANDLE           hNCryptKey;
    BYTE                        *pbContentEncryptKey;
    DWORD                       cbContentEncryptKey;
    BCRYPT_KEY_HANDLE           hCNGContentEncryptKey;
    BYTE                        *pbCNGContentEncryptKeyObject;
} CMSG_CNG_CONTENT_DECRYPT_INFO;
typedef CMSG_CNG_CONTENT_DECRYPT_INFO   *PCMSG_CNG_CONTENT_DECRYPT_INFO;

/* Cryptographic message function templates */
typedef BOOL (WINAPI *PFN_CMSG_GEN_ENCRYPT_KEY)( HCRYPTPROV *, PCRYPT_ALGORITHM_IDENTIFIER, PVOID, PCERT_PUBLIC_KEY_INFO, PFN_CMSG_ALLOC, HCRYPTKEY *, PBYTE *, PDWORD );
typedef BOOL (WINAPI *PFN_CMSG_EXPORT_ENCRYPT_KEY)( HCRYPTPROV, HCRYPTKEY, PCERT_PUBLIC_KEY_INFO, PBYTE, PDWORD );
typedef BOOL (WINAPI *PFN_CMSG_IMPORT_ENCRYPT_KEY)( HCRYPTPROV, DWORD, PCRYPT_ALGORITHM_IDENTIFIER, PCRYPT_ALGORITHM_IDENTIFIER, PBYTE, DWORD, HCRYPTKEY * );
typedef BOOL (WINAPI *PFN_CMSG_GEN_CONTENT_ENCRYPT_KEY)( PCMSG_CONTENT_ENCRYPT_INFO, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_EXPORT_KEY_TRANS)( PCMSG_CONTENT_ENCRYPT_INFO, PCMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO, PCMSG_KEY_TRANS_ENCRYPT_INFO, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_EXPORT_KEY_AGREE)( PCMSG_CONTENT_ENCRYPT_INFO, PCMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO, PCMSG_KEY_AGREE_ENCRYPT_INFO, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_EXPORT_MAIL_LIST)( PCMSG_CONTENT_ENCRYPT_INFO, PCMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO, PCMSG_MAIL_LIST_ENCRYPT_INFO, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_IMPORT_KEY_TRANS)( PCRYPT_ALGORITHM_IDENTIFIER, PCMSG_CTRL_KEY_TRANS_DECRYPT_PARA, DWORD, void *, HCRYPTKEY * );
typedef BOOL (WINAPI *PFN_CMSG_IMPORT_KEY_AGREE)( PCRYPT_ALGORITHM_IDENTIFIER, PCMSG_CTRL_KEY_AGREE_DECRYPT_PARA, DWORD, void *, HCRYPTKEY * );
typedef BOOL (WINAPI *PFN_CMSG_IMPORT_MAIL_LIST)( PCRYPT_ALGORITHM_IDENTIFIER, PCMSG_CTRL_MAIL_LIST_DECRYPT_PARA, DWORD, void *, HCRYPTKEY * );
typedef BOOL (WINAPI *PFN_CMSG_CNG_IMPORT_KEY_TRANS)( PCMSG_CNG_CONTENT_DECRYPT_INFO, PCMSG_CTRL_KEY_TRANS_DECRYPT_PARA, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_CNG_IMPORT_KEY_AGREE)( PCMSG_CNG_CONTENT_DECRYPT_INFO, PCMSG_CTRL_KEY_AGREE_DECRYPT_PARA, DWORD, void * );
typedef BOOL (WINAPI *PFN_CMSG_CNG_IMPORT_CONTENT_ENCRYPT_KEY)( PCMSG_CNG_CONTENT_DECRYPT_INFO, DWORD, void * );

/* Certificate context */
typedef struct _CERT_CONTEXT {
    DWORD       dwCertEncodingType;
    BYTE        *pbCertEncoded;
    DWORD       cbCertEncoded;
    PCERT_INFO  pCertInfo;
    HCERTSTORE  hCertStore;
} CERT_CONTEXT;
typedef CERT_CONTEXT        *PCERT_CONTEXT;
typedef const CERT_CONTEXT  *PCCERT_CONTEXT;

/* CRL context */
typedef struct _CRL_CONTEXT {
    DWORD       dwCertEncodingType;
    BYTE        *pbCrlEncoded;
    DWORD       cbCrlEncoded;
    PCRL_INFO   pCrlInfo;
    HCERTSTORE  hCertStore;
} CRL_CONTEXT;
typedef CRL_CONTEXT         *PCRL_CONTEXT;
typedef const CRL_CONTEXT   *PCCRL_CONTEXT;

/* CTL context */
typedef struct _CTL_CONTEXT {
    DWORD       dwMsgAndCertEncodingType;
    BYTE        *pbCtlEncoded;
    DWORD       cbCtlEncoded;
    PCTL_INFO   pCtlInfo;
    HCERTSTORE  hCertStore;
    HCRYPTMSG   hCryptMsg;
    BYTE        *pbCtlContent;
    DWORD       cbCtlContent;
} CTL_CONTEXT;
typedef CTL_CONTEXT         *PCTL_CONTEXT;
typedef const CTL_CONTEXT   *PCCTL_CONTEXT;

/* Cryptographic key provider parameters */
typedef struct _CRYPT_KEY_PROV_PARAM {
    DWORD   dwParam;
    BYTE    *pbData;
    DWORD   cbData;
    DWORD   dwFlags;
} CRYPT_KEY_PROV_PARAM;
typedef CRYPT_KEY_PROV_PARAM    *PCRYPT_KEY_PROV_PARAM;

/* Cryptographic key provider information */
typedef struct _CRYPT_KEY_PROV_INFO {
    LPWSTR                  pwszContainerName;
    LPWSTR                  pwszProvName;
    DWORD                   dwProvType;
    DWORD                   dwFlags;
    DWORD                   cProvParam;
    PCRYPT_KEY_PROV_PARAM   rgProvParam;
    DWORD                   dwKeySpec;
} CRYPT_KEY_PROV_INFO;
typedef CRYPT_KEY_PROV_INFO *PCRYPT_KEY_PROV_INFO;

/* Certificate key context */
typedef struct _CERT_KEY_CONTEXT {
    DWORD   cbSize;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD   dwKeySpec;
} CERT_KEY_CONTEXT;
typedef CERT_KEY_CONTEXT    *PCERT_KEY_CONTEXT;

/* Root information LUID */
typedef struct _ROOT_INFO_LUID {
    DWORD   LowPart;
    LONG    HighPart;
} ROOT_INFO_LUID;
typedef ROOT_INFO_LUID  *PROOT_INFO_LUID;

/* Smart card root information */
typedef struct _CRYPT_SMART_CARD_ROOT_INFO {
    BYTE            rgbCardID[16];
    ROOT_INFO_LUID  luid;
} CRYPT_SMART_CARD_ROOT_INFO;
typedef CRYPT_SMART_CARD_ROOT_INFO  *PCRYPT_SMART_CARD_ROOT_INFO;

/* Certificate system store relocate parameters */
typedef struct _CERT_SYSTEM_STORE_RELOCATE_PARA {
    union {
        HKEY    hKeyBase;
        void    *pvBase;
    };
    union {
        void    *pvSystemStore;
        LPCSTR  pszSystemStore;
        LPCWSTR pwszSystemStore;
    };
} CERT_SYSTEM_STORE_RELOCATE_PARA;
typedef CERT_SYSTEM_STORE_RELOCATE_PARA *PCERT_SYSTEM_STORE_RELOCATE_PARA;

/* Certificate registry store client GPT parameters */
typedef struct _CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    HKEY    hKeyBase;
    LPWSTR  pwszRegPath;
} CERT_REGISTRY_STORE_CLIENT_GPT_PARA;
typedef CERT_REGISTRY_STORE_CLIENT_GPT_PARA *PCERT_REGISTRY_STORE_CLIENT_GPT_PARA;

/* Certificate registry store roaming parameters */
typedef struct _CERT_REGISTRY_STORE_ROAMING_PARA {
    HKEY    hKey;
    LPWSTR  pwszStoreDirectory;
} CERT_REGISTRY_STORE_ROAMING_PARA;
typedef CERT_REGISTRY_STORE_ROAMING_PARA    *PCERT_REGISTRY_STORE_ROAMING_PARA;

/* Certificated LDAP store opened parameters */
typedef struct _CERT_LDAP_STORE_OPENED_PARA {
    void    *pvLdapSessionHandle;
    LPCWSTR pwszLdapUrl;
} CERT_LDAP_STORE_OPENED_PARA;
typedef CERT_LDAP_STORE_OPENED_PARA *PCERT_LDAP_STORE_OPENED_PARA;

/* Certificate store provider information */
typedef struct _CERT_STORE_PROV_INFO {
    DWORD               cbSize;
    DWORD               cStoreProvFunc;
    void                **rgpvStoreProvFunc;
    HCERTSTOREPROV      hStoreProv;
    DWORD               dwStoreProvFlags;
    HCRYPTOIDFUNCADDR   hStoreProvFuncAddr2;
} CERT_STORE_PROV_INFO;
typedef CERT_STORE_PROV_INFO    *PCERT_STORE_PROV_INFO;

/* Certificate store provider find information */
typedef struct _CERT_STORE_PROV_FIND_INFO {
    DWORD       cbSize;
    DWORD       dwMsgAndCertEncodingType;
    DWORD       dwFindFlags;
    DWORD       dwFindType;
    const void  *pvFindPara;
} CERT_STORE_PROV_FIND_INFO;
typedef CERT_STORE_PROV_FIND_INFO       *PCERT_STORE_PROV_FIND_INFO;
typedef const CERT_STORE_PROV_FIND_INFO CCERT_STORE_PROV_FIND_INFO;
typedef const CERT_STORE_PROV_FIND_INFO *PCCERT_STORE_PROV_FIND_INFO;

/* Certificate store provider function templates */
typedef BOOL (WINAPI *PFN_CERT_DLL_OPEN_STORE_PROV_FUNC)( LPCSTR, DWORD, HCRYPTPROV_LEGACY, DWORD, const void *, HCERTSTORE, PCERT_STORE_PROV_INFO );
typedef void (WINAPI *PFN_CERT_STORE_PROV_CLOSE)( HCERTSTOREPROV, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_READ_CERT)( HCERTSTOREPROV, PCCERT_CONTEXT, DWORD, PCCERT_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_WRITE_CERT)( HCERTSTOREPROV, PCCERT_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_DELETE_CERT)( HCERTSTOREPROV, PCCERT_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_SET_CERT_PROPERTY)( HCERTSTOREPROV, PCCERT_CONTEXT, DWORD, DWORD, const void * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_READ_CRL)( HCERTSTOREPROV, PCCRL_CONTEXT, DWORD, PCCRL_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_WRITE_CRL)( HCERTSTOREPROV, PCCRL_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_DELETE_CRL)( HCERTSTOREPROV, PCCRL_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_SET_CRL_PROPERTY)( HCERTSTOREPROV, PCCRL_CONTEXT, DWORD, DWORD, const void * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_READ_CTL)( HCERTSTOREPROV, PCCTL_CONTEXT, DWORD, PCCTL_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_WRITE_CTL)( HCERTSTOREPROV, PCCTL_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_DELETE_CTL)( HCERTSTOREPROV, PCCTL_CONTEXT, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_SET_CTL_PROPERTY)( HCERTSTOREPROV, PCCTL_CONTEXT, DWORD, DWORD, const void * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_CONTROL)( HCERTSTOREPROV, DWORD, DWORD, void const * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FIND_CERT)( HCERTSTOREPROV, PCCERT_STORE_PROV_FIND_INFO, PCCERT_CONTEXT, DWORD, void **, PCCERT_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FREE_FIND_CERT)( HCERTSTOREPROV, PCCERT_CONTEXT, void *, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_GET_CERT_PROPERTY)( HCERTSTOREPROV, PCCERT_CONTEXT, DWORD, DWORD, void *, DWORD * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FIND_CRL)( HCERTSTOREPROV, PCCERT_STORE_PROV_FIND_INFO, PCCRL_CONTEXT, DWORD, void **, PCCRL_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FREE_FIND_CRL)( HCERTSTOREPROV, PCCRL_CONTEXT, void *, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_GET_CRL_PROPERTY)( HCERTSTOREPROV, PCCRL_CONTEXT, DWORD, DWORD, void *, DWORD * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FIND_CTL)( HCERTSTOREPROV, PCCERT_STORE_PROV_FIND_INFO, PCCTL_CONTEXT, DWORD, void **, PCCTL_CONTEXT * );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_FREE_FIND_CTL)( HCERTSTOREPROV, PCCTL_CONTEXT, void *, DWORD );
typedef BOOL (WINAPI *PFN_CERT_STORE_PROV_GET_CTL_PROPERTY)( HCERTSTOREPROV, PCCTL_CONTEXT, DWORD, DWORD, void *, DWORD * );

/* CertFindCRLInStore() parameters used with CRL_FIND_ISSUED_FOR */
typedef struct _CRL_FIND_ISSUED_FOR_PARA {
    PCCERT_CONTEXT  pSubjectCert;
    PCCERT_CONTEXT  pIssuerCert;
} CRL_FIND_ISSUED_FOR_PARA;
typedef CRL_FIND_ISSUED_FOR_PARA    *PCRL_FIND_ISSUED_FOR_PARA;

/* CTL any subject information */
typedef struct _CTL_ANY_SUBJECT_INFO {
    CRYPT_ALGORITHM_IDENTIFIER  SubjectAlgorithm;
    CRYPT_DATA_BLOB             SubjectIdentifier;
} CTL_ANY_SUBJECT_INFO;
typedef CTL_ANY_SUBJECT_INFO    *PCTL_ANY_SUBJECT_INFO;

/* CertFindCTLInStore() parameters used with CTL_FIND_USAGE */
typedef struct _CTL_FIND_USAGE_PARA {
    DWORD           cbSize;
    CTL_USAGE       SubjectUsage;
    CRYPT_DATA_BLOB ListIdentifier;
    PCERT_INFO      pSigner;
} CTL_FIND_USAGE_PARA;
typedef CTL_FIND_USAGE_PARA *PCTL_FIND_USAGE_PARA;

/* CertFindCTLInStore() parameters ued with CTL_FIND_SUBJECT */
typedef struct _CTL_FIND_SUBJECT_PARA {
    DWORD                   cbSize;
    PCTL_FIND_USAGE_PARA    pUsagePara;
    DWORD                   dwSubjectType;
    void                    *pvSubject;
} CTL_FIND_SUBJECT_PARA;
typedef CTL_FIND_SUBJECT_PARA   *PCTL_FIND_SUBJECT_PARA;

/* Callback used with CertCreateContext() */
typedef BOOL (WINAPI *PFN_CERT_CREATE_CONTEXT_SORT_FUNC)( DWORD, DWORD, DWORD, void * );

/* CertCreateContext() parameters */
typedef struct _CERT_CREATE_CONTEXT_PARA {
    DWORD                               cbSize;
    PFN_CRYPT_FREE                      pfnFree;
    void                                *pvFree;
    PFN_CERT_CREATE_CONTEXT_SORT_FUNC   pfnSort;
    void                                *pvSort;
} CERT_CREATE_CONTEXT_PARA;
typedef CERT_CREATE_CONTEXT_PARA    *PCERT_CREATE_CONTEXT_PARA;

/* Certificate system store information */
typedef struct _CERT_SYSTEM_STORE_INFO {
    DWORD   cbSize;
} CERT_SYSTEM_STORE_INFO;
typedef CERT_SYSTEM_STORE_INFO  *PCERT_SYSTEM_STORE_INFO;

/* Certificate physical store information */
typedef struct _CERT_PHYSICAL_STORE_INFO {
    DWORD           cbSize;
    LPSTR           pszOpenStorageProvider;
    DWORD           dwOpenEncodingType;
    DWORD           dwOpenFlags;
    CRYPT_DATA_BLOB OpenParameters;
    DWORD           dwFlags;
    DWORD           dwPriority;
} CERT_PHYSICAL_STORE_INFO;
typedef CERT_PHYSICAL_STORE_INFO    *PCERT_PHYSICAL_STORE_INFO;

/* System store enumeration callbacks */
typedef BOOL (WINAPI *PFN_CERT_ENUM_SYSTEM_STORE_LOCATION)( LPCWSTR, DWORD, void *, void * );
typedef BOOL (WINAPI *PFN_CERT_ENUM_SYSTEM_STORE)( const void *, DWORD, PCERT_SYSTEM_STORE_INFO, void *, void * );
typedef BOOL (WINAPI *PFN_CERT_ENUM_PHYSICAL_STORE)( const void *, DWORD, LPCWSTR, PCERT_PHYSICAL_STORE_INFO, void *, void * );

/* CertVerifyCTLUsage() parameters */
typedef struct _CTL_VERIFY_USAGE_PARA {
    DWORD           cbSize;
    CRYPT_DER_BLOB  ListIdentifier;
    DWORD           cCtlStore;
    HCERTSTORE      *rghCtlStore;
    DWORD           cSignerStore;
    HCERTSTORE      *rghSignerStore;
} CTL_VERIFY_USAGE_PARA;
typedef CTL_VERIFY_USAGE_PARA   *PCTL_VERIFY_USAGE_PARA;

/* CertVerifyCTLUsage() status */
typedef struct _CTL_VERIFY_USAGE_STATUS {
    DWORD           cbSize;
    DWORD           dwError;
    DWORD           dwFlags;
    PCCTL_CONTEXT   *ppCtl;
    DWORD           dwCtlEntryIndex;
    PCCERT_CONTEXT  *ppSigner;
    DWORD           dwSignerIndex;
} CTL_VERIFY_USAGE_STATUS;
typedef CTL_VERIFY_USAGE_STATUS *PCTL_VERIFY_USAGE_STATUS;

/* Certificate revocation information */
typedef struct _CERT_REVOCATION_CRL_INFO {
    DWORD           cbSize;
    PCCRL_CONTEXT   pBaseCrlContext;
    PCCRL_CONTEXT   pDeltaCrlContext;
    PCRL_ENTRY      pCrlEntry;
    BOOL            fDeltaCrlEntry;
} CERT_REVOCATION_CRL_INFO;
typedef CERT_REVOCATION_CRL_INFO    *PCERT_REVOCATION_CRL_INFO;

/* Certificate revocation chain parameters */
typedef struct _CERT_REVOCATION_CHAIN_PARA {
    DWORD               cbSize;
    HCERTCHAINENGINE    hChainEngine;
    HCERTSTORE          hAdditionalStore;
    DWORD               dwChainFlags;
    DWORD               dwUrlRetrievalTimeout;
    LPFILETIME          pftCurrentTime;
    LPFILETIME          pftCacheResync;
    DWORD               cbMaxUrlRetrievalByteCount;
} CERT_REVOCATION_CHAIN_PARA;
typedef CERT_REVOCATION_CHAIN_PARA  *PCERT_REVOCATION_CHAIN_PARA;

/* Certificate revocation parameters */
typedef struct _CERT_REVOCATION_PARA {
    DWORD                       cbSize;
    PCCERT_CONTEXT              pIssuerCert;
    DWORD                       cCertStore;
    HCERTSTORE                  *rgCertStore;
    HCERTSTORE                  hCrlStore;
    LPFILETIME                  pftTimeToUse;
#ifdef CERT_REVOCATION_PARA_HAS_EXTRA_FIELDS
    DWORD                       dwUrlRetrievalTimeout;
    BOOL                        fCheckFreshnessTime;
    DWORD                       dwFreshnessTime;
    LPFILETIME                  pftCurrentTime;
    PCERT_REVOCATION_CRL_INFO   pCrlInfo;
    LPFILETIME                  pftCacheResync;
    PCERT_REVOCATION_CHAIN_PARA pChainPara;
#endif
} CERT_REVOCATION_PARA;
typedef CERT_REVOCATION_PARA    *PCERT_REVOCATION_PARA;

/* Certificate revocation status */
typedef struct _CERT_REVOCATION_STATUS {
    DWORD   cbSize;
    DWORD   dwIndex;
    DWORD   dwError;
    DWORD   dwReason;
    BOOL    fHasFreshnessTime;
    DWORD   dwFreshnessTime;
} CERT_REVOCATION_STATUS;
typedef CERT_REVOCATION_STATUS  *PCERT_REVOCATION_STATUS;

/* Encoded signature function templates */
typedef BOOL (WINAPI *PFN_CRYPT_EXTRACT_ENCODED_SIGNATURE_PARAMETERS_FUNC)( DWORD, PCRYPT_ALGORITHM_IDENTIFIER, void **, LPWSTR * );
typedef BOOL (WINAPI *PFN_CRYPT_SIGN_AND_ENCODE_HASH_FUNC)( NCRYPT_KEY_HANDLE, DWORD, PCRYPT_ALGORITHM_IDENTIFIER, void *, LPCWSTR, LPCWSTR, BYTE *, DWORD, BYTE *, DWORD * );
typedef BOOL (WINAPI *PFN_CRYPT_VERIFY_ENCODED_SIGNATURE_FUNC)( DWORD, PCERT_PUBLIC_KEY_INFO, PCRYPT_ALGORITHM_IDENTIFIER, void *, LPCWSTR, LPCWSTR, BYTE *, DWORD, BYTE *, DWORD );

/* Parameters for CRYPT_DEFAULT_CONTEXT_MULTI_CERT_SIGN_OID */
typedef struct _CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    DWORD   cOID;
    LPSTR   *rgpszOID;
} CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA;
typedef CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA    *PCRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA;

/* Public key import/export function templates */
typedef BOOL (WINAPI *PFN_CRYPT_EXPORT_PUBLIC_KEY_INFO_EX2_FUNC)( NCRYPT_KEY_HANDLE, DWORD, LPSTR, DWORD, void *, PCERT_PUBLIC_KEY_INFO, DWORD * );
typedef BOOL (WINAPI *PFN_CRYPT_IMPORT_PUBLIC_KEY_INFO_EX2_FUNC)( DWORD, PCERT_PUBLIC_KEY_INFO, DWORD, void *, BCRYPT_KEY_HANDLE * );
#if (NTDDI_VERSION >= 0x06010000)
typedef BOOL (WINAPI *PFN_CRYPT_EXPORT_PUBLIC_KEY_INFO_FROM_BCRYPT_HANDLE_FUNC)( BCRYPT_KEY_HANDLE, DWORD, LPSTR, DWORD, void *, PCERT_PUBLIC_KEY_INFO, DWORD * );
#endif

/* Private key import/export function templates */
typedef BOOL (WINAPI *PFN_IMPORT_PRIV_KEY_FUNC)( HCRYPTPROV, CRYPT_PRIVATE_KEY_INFO *, DWORD, void * );
typedef BOOL (WINAPI *PFN_EXPORT_PRIV_KEY_FUNC)( HCRYPTPROV, DWORD, LPSTR, DWORD, void *, CRYPT_PRIVATE_KEY_INFO *, DWORD * );

/* Signer certificate callback */
typedef PCCERT_CONTEXT (WINAPI *PFN_CRYPT_GET_SIGNER_CERTIFICATE)( void *, DWORD, PCERT_INFO, HCERTSTORE );

/* Cryptographic message signing parameters */
typedef struct _CRYPT_SIGN_MESSAGE_PARA {
    DWORD                       cbSize;
    DWORD                       dwMsgEncodingType;
    PCCERT_CONTEXT              pSigningCert;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    void                        *pvHashAuxInfo;
    DWORD                       cMsgCert;
    PCCERT_CONTEXT              *rgpMsgCert;
    DWORD                       cMsgCrl;
    PCCRL_CONTEXT               *rgpMsgCrl;
    DWORD                       cAuthAttr;
    PCRYPT_ATTRIBUTE            rgAuthAttr;
    DWORD                       cUnauthAttr;
    PCRYPT_ATTRIBUTE            rgUnauthAttr;
    DWORD                       dwFlags;
    DWORD                       dwInnerContentType;
#ifdef CRYPT_SIGN_MESSAGE_PARA_HAS_CMS_FIELDS
    CRYPT_ALGORITHM_IDENTIFIER  HashEncryptionAlgorithm;
    void                        *pvHashEncryptionAuxInfo;
#endif
} CRYPT_SIGN_MESSAGE_PARA;
typedef CRYPT_SIGN_MESSAGE_PARA *PCRYPT_SIGN_MESSAGE_PARA;

/* Cryptographic message verification parameters */
typedef struct _CRYPT_VERIFY_MESSAGE_PARA {
    DWORD                               cbSize;
    DWORD                               dwMsgAndCertEncodingType;
    HCRYPTPROV_LEGACY                   hCryptProv;
    PFN_CRYPT_GET_SIGNER_CERTIFICATE    pfnGetSignerCertificate;
    void                                *pvGetArg;
} CRYPT_VERIFY_MESSAGE_PARA;
typedef CRYPT_VERIFY_MESSAGE_PARA   *PCRYPT_VERIFY_MESSAGE_PARA;

/* Cryptographic message encryption parameters */
typedef struct _CRYPT_ENCRYPT_MESSAGE_PARA {
    DWORD                       cbSize;
    DWORD                       dwMsgEncodingType;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_ALGORITHM_IDENTIFIER  ContentEncryptionAlgorithm;
    void                        *pvEncryptionAuxInfo;
    DWORD                       dwFlags;
    DWORD                       dwInnerContentType;
} CRYPT_ENCRYPT_MESSAGE_PARA;
typedef CRYPT_ENCRYPT_MESSAGE_PARA  *PCRYPT_ENCRYPT_MESSAGE_PARA;

/* Cryptographic message decryption parameters */
typedef struct _CRYPT_DECRYPT_MESSAGE_PARA {
    DWORD       cbSize;
    DWORD       dwMsgAndCertEncodingType;
    DWORD       cCertStore;
    HCERTSTORE  *rghCertStore;
#ifdef CRYPT_DECRYPT_MESSAGE_PARA_HAS_EXTRA_FIELDS
    DWORD       dwFlags;
#endif
} CRYPT_DECRYPT_MESSAGE_PARA;
typedef CRYPT_DECRYPT_MESSAGE_PARA  *PCRYPT_DECRYPT_MESSAGE_PARA;

/* Cryptographic message hash parameters */
typedef struct _CRYPT_HASH_MESSAGE_PARA {
    DWORD                       cbSize;
    DWORD                       dwMsgEncodingType;
    HCRYPTPROV_LEGACY           hCryptProv;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    void                        *pvHashAuxInfo;
} CRYPT_HASH_MESSAGE_PARA;
typedef CRYPT_HASH_MESSAGE_PARA *PCRYPT_HASH_MESSAGE_PARA;

/* Cryptographic message key signing parameters */
typedef struct _CRYPT_KEY_SIGN_MESSAGE_PARA {
    DWORD                       cbSize;
    DWORD                       dwMsgAndCertEncodingType;
    union {
        HCRYPTPROV          hCryptProv;
        NCRYPT_KEY_HANDLE   hNCryptKey;
    };
    DWORD                       dwKeySpec;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    void                        *pvHashAuxInfo;
    CRYPT_ALGORITHM_IDENTIFIER  PubKeyAlgorithm;
} CRYPT_KEY_SIGN_MESSAGE_PARA;
typedef CRYPT_KEY_SIGN_MESSAGE_PARA *PCRYPT_KEY_SIGN_MESSAGE_PARA;

/* Cryptographic message key verification parameters */
typedef struct _CRYPT_KEY_VERIFY_MESSAGE_PARA {
    DWORD               cbSize;
    DWORD               dwMsgEncodingType;
    HCRYPTPROV_LEGACY   hCryptProv;
} CRYPT_KEY_VERIFY_MESSAGE_PARA;
typedef CRYPT_KEY_VERIFY_MESSAGE_PARA   *PCRYPT_KEY_VERIFY_MESSAGE_PARA;

/* Certificate chain */
typedef struct _CERT_CHAIN {
    DWORD               cCerts;
    PCERT_BLOB          certs;
    CRYPT_KEY_PROV_INFO keyLocatorInfo;
} CERT_CHAIN;
typedef CERT_CHAIN  *PCERT_CHAIN;

/* Cryptographic asynchronous callback */
typedef VOID (WINAPI *PFN_CRYPT_ASYNC_PARAM_FREE_FUNC)( LPSTR, LPVOID );

/* Cryptographic blob array */
typedef struct _CRYPT_BLOB_ARRAY {
    DWORD               cBlob;
    PCRYPT_DATA_BLOB    rgBlob;
} CRYPT_BLOB_ARRAY;
typedef CRYPT_BLOB_ARRAY    *PCRYPT_BLOB_ARRAY;

/* Cryptographic credentials */
typedef struct _CRYPT_CREDENTIALS {
    DWORD   cbSize;
    LPCSTR  pszCredentialsOid;
    LPVOID  pvCredentials;
} CRYPT_CREDENTIALS;
typedef CRYPT_CREDENTIALS   *PCRYPT_CREDENTIALS;

/* Cryptographic password credentials */
typedef struct _CRYPT_PASSWORD_CREDENTIALSA {
    DWORD   cbSize;
    LPSTR   pszUsername;
    LPSTR   pszPassword;
} CRYPT_PASSWORD_CREDENTIALSA;
typedef CRYPT_PASSWORD_CREDENTIALSA     *PCRYPT_PASSWORD_CREDENTIALSA;
typedef struct _CRYPT_PASSWORD_CREDENTIALSW {
    DWORD   cbSize;
    LPWSTR  pszUsername;
    LPWSTR  pszPassword;
} CRYPT_PASSWORD_CREDENTIALSW;
typedef CRYPT_PASSWORD_CREDENTIALSW     *PCRYPT_PASSWORD_CREDENTIALSW;
#ifdef UNICODE
typedef CRYPT_PASSWORD_CREDENTIALSW     CRYPT_PASSWORD_CREDENTIALS;
typedef PCRYPT_PASSWORD_CREDENTIALSW    PCRYPT_PASSWORD_CREDENTIALS;
#else
typedef CRYPT_PASSWORD_CREDENTIALSA     CRYPT_PASSWORD_CREDENTIALS;
typedef PCRYPT_PASSWORD_CREDENTIALSA    PCRYPT_PASSWORD_CREDENTIALS;
#endif

/* Scheme provider function templates */
typedef VOID (WINAPI *PFN_FREE_ENCODED_OBJECT_FUNC)( LPCSTR, PCRYPT_BLOB_ARRAY, LPVOID );

/* URL cache pre-fetch information */
typedef struct _CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    DWORD       cbSize;
    DWORD       dwObjectType;
    DWORD       dwError;
    DWORD       dwReserved;
    FILETIME    ThisUpdateTime;
    FILETIME    NextUpdateTime;
    FILETIME    PublishTime;
} CRYPTNET_URL_CACHE_PRE_FETCH_INFO;
typedef CRYPTNET_URL_CACHE_PRE_FETCH_INFO   *PCRYPTNET_URL_CACHE_PRE_FETCH_INFO;

/* URL cache flush information */
typedef struct _CRYPTNET_URL_CACHE_FLUSH_INFO {
    DWORD       cbSize;
    DWORD       dwExemptSeconds;
    FILETIME    ExpireTime;
} CRYPTNET_URL_CACHE_FLUSH_INFO;
typedef CRYPTNET_URL_CACHE_FLUSH_INFO   *PCRYPTNET_URL_CACHE_FLUSH_INFO;

/* URL cache response information */
typedef struct _CRYPTNET_URL_CACHE_RESPONSE_INFO {
    DWORD       cbSize;
    WORD        wResponseType;
    WORD        wResponseFlags;
    FILETIME    LastModifiedTime;
    DWORD       dwMaxAge;
    LPCWSTR     pwszETag;
    DWORD       dwProxyId;
} CRYPTNET_URL_CACHE_RESPONSE_INFO;
typedef CRYPTNET_URL_CACHE_RESPONSE_INFO    *PCRYPTNET_URL_CACHE_RESPONSE_INFO;

/* CryptRetrieveObjectByUrl() auxiliary information */
typedef struct _CRYPT_RETRIEVE_AUX_INFO {
    DWORD                               cbSize;
    FILETIME                            *pLastSyncTime;
    DWORD                               dwMaxUrlRetrievalByteCount;
    PCRYPTNET_URL_CACHE_PRE_FETCH_INFO  pPreFetchInfo;
    PCRYPTNET_URL_CACHE_FLUSH_INFO      pFlushInfo;
    PCRYPTNET_URL_CACHE_RESPONSE_INFO   *ppResponseInfo;
    LPWSTR                              pwszCacheFileNamePrefix;
    LPFILETIME                          pftCacheResync;
    BOOL                                fProxyCacheRetrieval;
    DWORD                               dwHttpStatusCode;
} CRYPT_RETRIEVE_AUX_INFO;
typedef CRYPT_RETRIEVE_AUX_INFO *PCRYPT_RETRIEVE_AUX_INFO;

/* Object retrieval cancellation callback */
typedef BOOL (WINAPI *PFN_CRYPT_CANCEL_RETRIEVAL)( DWORD, void * );

/* Asynchronous retrieval callback functions */
typedef VOID (WINAPI *PFN_CRYPT_ASYNC_RETRIEVAL_COMPLETION_FUNC)( LPVOID, DWORD, LPCSTR, LPSTR, LPVOID );
typedef BOOL (WINAPI *PFN_CANCEL_ASYNC_RETRIEVAL_FUNC)( HCRYPTASYNC );

/* Asynchronous retrieval completion information */
typedef struct _CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    PFN_CRYPT_ASYNC_RETRIEVAL_COMPLETION_FUNC   pfnCompletion;
    LPVOID                                      pvCompletion;
} CRYPT_ASYNC_RETRIEVAL_COMPLETION;
typedef CRYPT_ASYNC_RETRIEVAL_COMPLETION    *PCRYPT_ASYNC_RETRIEVAL_COMPLETION;

/* Cryptographic URL array */
typedef struct _CRYPT_URL_ARRAY {
    DWORD   cUrl;
    LPWSTR  *rgwszUrl;
} CRYPT_URL_ARRAY;
typedef CRYPT_URL_ARRAY *PCRYPT_URL_ARRAY;

/* Cryptographic URL information */
typedef struct _CRYPT_URL_INFO {
    DWORD   cbSize;
    DWORD   dwSyncDeltaTime;
    DWORD   cGroup;
    DWORD   *rgcGroupEntry;
} CRYPT_URL_INFO;
typedef CRYPT_URL_INFO  *PCRYPT_URL_INFO;

/* Certificate/CRL context pair */
typedef struct _CERT_CRL_CONTEXT_PAIR {
    PCCERT_CONTEXT  pCertContext;
    PCCRL_CONTEXT   pCrlContext;
} CERT_CRL_CONTEXT_PAIR;
typedef CERT_CRL_CONTEXT_PAIR       *PCERT_CRL_CONTEXT_PAIR;
typedef const CERT_CRL_CONTEXT_PAIR *PCCERT_CRL_CONTEXT_PAIR;

/* CryptGetTimeValidObject() extra information */
typedef struct _CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    DWORD                       cbSize;
    int                         iDeltaCrlIndicator;
    LPFILETIME                  pftCacheResync;
    LPFILETIME                  pLastSyncTime;
    LPFILETIME                  pMaxAgeTime;
    PCERT_REVOCATION_CHAIN_PARA pChainPara;
    PCRYPT_INTEGER_BLOB         pDeltaCrlIndicator;
} CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO;
typedef CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO  *PCRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO;

/* Cryptographic protection prompt structure */
typedef struct _CRYPTPROTECT_PROMPTSTRUCT {
    DWORD   cbSize;
    DWORD   dwPromptFlags;
    HWND    hwndApp;
    LPCWSTR szPrompt;
} CRYPTPROTECT_PROMPTSTRUCT;
typedef CRYPTPROTECT_PROMPTSTRUCT   *PCRYPTPROTECT_PROMPTSTRUCT;

/* Key identifier property enumeration callback */
typedef BOOL (WINAPI *PFN_CRYPT_ENUM_KEYID_PROP)( const CRYPT_HASH_BLOB *, DWORD, void *, void *, DWORD, DWORD *, void **, DWORD * );

/* Certificate chain engine configuration */
typedef struct _CERT_CHAIN_ENGINE_CONFIG {
    DWORD       cbSize;
    HCERTSTORE  hRestrictedRoot;
    HCERTSTORE  hRestrictedTrust;
    HCERTSTORE  hRestrictedOther;
    DWORD       cAdditionalStore;
    HCERTSTORE  *rghAdditionalStore;
    DWORD       dwFlags;
    DWORD       dwUrlRetrievalTimeout;
    DWORD       MaximumCachedCertificates;
    DWORD       CycleDetectionModulus;
#if (NTDDI_VERSION >= 0x06010000)
    HCERTSTORE  hExclusiveRoot;
    HCERTSTORE  hExclusiveTrustedPeople;
#endif
} CERT_CHAIN_ENGINE_CONFIG;
typedef CERT_CHAIN_ENGINE_CONFIG    *PCERT_CHAIN_ENGINE_CONFIG;

/* Certificate trust status */
typedef struct _CERT_TRUST_STATUS {
    DWORD   dwErrorStatus;
    DWORD   dwInfoStatus;
} CERT_TRUST_STATUS;
typedef CERT_TRUST_STATUS   *PCERT_TRUST_STATUS;

/* Certificate revocation information */
typedef struct _CERT_REVOCATION_INFO {
    DWORD                       cbSize;
    DWORD                       dwRevocationResult;
    LPCSTR                      pszRevocationOid;
    LPVOID                      pvOidSpecificInfo;
    BOOL                        fHasFreshnessTime;
    DWORD                       dwFreshnessTime;
    PCERT_REVOCATION_CRL_INFO   pCrlInfo;
} CERT_REVOCATION_INFO;
typedef CERT_REVOCATION_INFO    *PCERT_REVOCATION_INFO;

/* Certificate trust list information */
typedef struct _CERT_TRUST_LIST_INFO {
    DWORD           cbSize;
    PCTL_ENTRY      pCtlEntry;
    PCCTL_CONTEXT   pCtlContext;
} CERT_TRUST_LIST_INFO;
typedef CERT_TRUST_LIST_INFO    *PCERT_TRUST_LIST_INFO;

/* Certificate chain element */
typedef struct _CERT_CHAIN_ELEMENT {
    DWORD                   cbSize;
    PCCERT_CONTEXT          pCertContext;
    CERT_TRUST_STATUS       TrustStatus;
    PCERT_REVOCATION_INFO   pRevocationInfo;
    PCERT_ENHKEY_USAGE      pIssuanceUsage;
    PCERT_ENHKEY_USAGE      pApplicationUsage;
    LPCWSTR                 pwszExtendedErrorInfo;
} CERT_CHAIN_ELEMENT;
typedef CERT_CHAIN_ELEMENT          *PCERT_CHAIN_ELEMENT;
typedef const CERT_CHAIN_ELEMENT    *PCCERT_CHAIN_ELEMENT;

/* Certificate simple chain */
typedef struct _CERT_SIMPLE_CHAIN {
    DWORD                   cbSize;
    CERT_TRUST_STATUS       TrustStatus;
    DWORD                   cElement;
    PCERT_CHAIN_ELEMENT     *rgpElement;
    PCERT_TRUST_LIST_INFO   pTrustListInfo;
    BOOL                    fHasRevocationFreshnessTime;
    DWORD                   dwRevocationFreshnessTime;
} CERT_SIMPLE_CHAIN;
typedef CERT_SIMPLE_CHAIN       *PCERT_SIMPLE_CHAIN;
typedef const CERT_SIMPLE_CHAIN *PCCERT_SIMPLE_CHAIN;

/* Certificate chain context */
typedef struct _CERT_CHAIN_CONTEXT {
    DWORD                               cbSize;
    CERT_TRUST_STATUS                   TrustStatus;
    DWORD                               cChain;
    PCERT_SIMPLE_CHAIN                  *rgpChain;
    DWORD                               cLowerQualityChainContext;
    const struct _CERT_CHAIN_CONTEXT    *rgpLowerQualityChainContext;
    BOOL                                fHasRevocationFreshnessTime;
    DWORD                               dwRevocationFreshnessTime;
    DWORD                               dwCreateFlags;
    GUID                                ChainId;
} CERT_CHAIN_CONTEXT;
typedef CERT_CHAIN_CONTEXT          *PCERT_CHAIN_CONTEXT;
typedef const CERT_CHAIN_CONTEXT    *PCCERT_CHAIN_CONTEXT;

/* Certificate usage match */
typedef struct _CERT_USAGE_MATCH {
    DWORD               dwType;
    CERT_ENHKEY_USAGE   Usage;
} CERT_USAGE_MATCH;
typedef CERT_USAGE_MATCH    *PCERT_USAGE_MATCH;

/* CTL usage match */
typedef struct _CTL_USAGE_MATCH {
    DWORD       dwType;
    CTL_USAGE   Usage;
} CTL_USAGE_MATCH;
typedef CTL_USAGE_MATCH *PCTL_USAGE_MATCH;

/* Certificate chain parameters */
typedef struct _CERT_CHAIN_PARA {
    DWORD               cbSize;
    CERT_USAGE_MATCH    RequestedUsage;
#ifdef CERT_CHAIN_PARA_HAS_EXTRA_FIELDS
    CERT_USAGE_MATCH    RequestedIssuancePolicy;
    DWORD               dwUrlRetrievalTimeout;
    BOOL                fCheckRevocationFreshnessTime;
    DWORD               dwRevocationFreshnessTime;
    LPFILETIME          pftCacheResync;
#endif
} CERT_CHAIN_PARA;
typedef CERT_CHAIN_PARA *PCERT_CHAIN_PARA;

/* CRL revocation information */
typedef struct _CRL_REVOCATION_INFO {
    PCRL_ENTRY              pCrlEntry;
    PCCRL_CONTEXT           pCrlContext;
    PCCERT_CHAIN_CONTEXT    pCrlIssuerChain;
} CRL_REVOCATION_INFO;
typedef CRL_REVOCATION_INFO *PCRL_REVOCATION_INFO;

/* Certificate chain find callbacks */
typedef BOOL (WINAPI *PFN_CERT_CHAIN_FIND_BY_ISSUER_CALLBACK)( PCCERT_CONTEXT, void * );

/* Certificate chain find by issuer parameters */
typedef struct _CERT_CHAIN_FIND_BY_ISSUER_PARA {
    DWORD                                   cbSize;
    LPCSTR                                  pszUsageIdentifier;
    DWORD                                   dwKeySpec;
    DWORD                                   dwAcquirePrivateKeyFlags;
    DWORD                                   cIssuer;
    CERT_NAME_BLOB                          *rgIssuer;
    PFN_CERT_CHAIN_FIND_BY_ISSUER_CALLBACK  pfnFindCallback;
    void                                    *pvFindArg;
#ifdef CERT_CHAIN_FIND_BY_ISSUER_PARA_HAS_EXTRA_FIELDS
    DWORD                                   *pdwIssuerChainIndex;
    DWORD                                   *pdwIssuerElementIndex;
#endif
} CERT_CHAIN_FIND_ISSUER_PARA;
typedef CERT_CHAIN_FIND_ISSUER_PARA *PCERT_CHAIN_FIND_ISSUER_PARA;
typedef CERT_CHAIN_FIND_ISSUER_PARA CERT_CHAIN_FIND_BY_ISSUER_PARA;
typedef CERT_CHAIN_FIND_ISSUER_PARA *PCERT_CHAIN_FIND_BY_ISSUER_PARA;

/* Certificate chain policy parameters */
typedef struct _CERT_CHAIN_POLICY_PARA {
    DWORD   cbSize;
    DWORD   dwFlags;
    void    *pvExtraPolicyPara;
} CERT_CHAIN_POLICY_PARA;
typedef CERT_CHAIN_POLICY_PARA  *PCERT_CHAIN_POLICY_PARA;

/* Certificate chain policy status */
typedef struct _CERT_CHAIN_POLICY_STATUS {
    DWORD   cbSize;
    DWORD   dwError;
    LONG    lChainIndex;
    LONG    lElementIndex;
    void    *pvExtraPolicyStatus;
} CERT_CHAIN_POLICY_STATUS;
typedef CERT_CHAIN_POLICY_STATUS    *PCERT_CHAIN_POLICY_STATUS;

/* Authenticode extra certificate chain policy parameters */
typedef struct _AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    DWORD               cbSize;
    DWORD               dwRegPolicySettings;
    PCMSG_SIGNER_INFO   pSignerInfo;
} AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA;
typedef AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA   *PAUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA;

/* Authenticode extra certificate chain policy status */
typedef struct _AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    DWORD   cbSize;
    BOOL    fCommercial;
} AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS;
typedef AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS *PAUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS;

/* Authenticode TS extra certificate chain policy parameters */
typedef struct _AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    DWORD   cbSize;
    DWORD   dwRegPolicySettings;
    BOOL    fCommercial;
} AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA;
typedef AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA    *PAUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA;

/* HTTPS policy callback data */
typedef struct _HTTPSPolicyCallbackData {
    union {
        DWORD   cbStruct;
        DWORD   cbSize;
    };
    DWORD   dwAuthType;
    DWORD   fdwChecks;
    WCHAR   *pwszServerName;
} HTTPSPolicyCallbackData;
typedef HTTPSPolicyCallbackData *PHTTPSPolicyCallbackData;
typedef HTTPSPolicyCallbackData SSL_EXTRA_CERT_CHAIN_POLICY_PARA;
typedef HTTPSPolicyCallbackData *PSSL_EXTRA_CERT_CHAIN_POLICY_PARA;

/* EV extra certificate chain policy parameters */
typedef struct _EV_EXTRA_CERT_CHAIN_POLICY_PARA  {
    DWORD   cbSize;
    DWORD   dwRootProgramQualifierFlags;
} EV_EXTRA_CERT_CHAIN_POLICY_PARA;
typedef EV_EXTRA_CERT_CHAIN_POLICY_PARA *PEV_EXTRA_CERT_CHAIN_POLICY_PARA;

/* EV extra certificate chain policy status */
typedef struct _EV_EXTRA_CERT_CHAIN_POLICY_STATUS {
    DWORD   cbSize;
    DWORD   dwQualifiers;
    DWORD   dwIssuanceUsageIndex;
} EV_EXTRA_CERT_CHAIN_POLICY_STATUS;
typedef EV_EXTRA_CERT_CHAIN_POLICY_STATUS   *PEV_EXTRA_CERT_CHAIN_POLICY_STATUS;

/* PKCS-12 PBE parameters */
typedef struct _CRYPT_PKCS12_PBE_PARAMS {
    int     iIterations;
    ULONG   cbSalt;
} CRYPT_PKCS12_PBE_PARAMS;

/* Certificate server OCSP response context */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    DWORD   cbSize;
    BYTE    *pbEncodedOcspResponse;
    DWORD   cbEncodedOcspResponse;
} CERT_SERVER_OCSP_RESPONSE_CONTEXT;
typedef CERT_SERVER_OCSP_RESPONSE_CONTEXT       *PCERT_SERVER_OCSP_RESPONSE_CONTEXT;
typedef const CERT_SERVER_OCSP_RESPONSE_CONTEXT *PCCERT_SERVER_OCSP_RESPONSE_CONTEXT;
#endif

/* Certificate selection chain parameters */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CERT_SELECT_CHAIN_PARA {
    HCERTCHAINENGINE    hChainEngine;
    PFILETIME           pTime;
    HCERTSTORE          hAdditionalStore;
    PCERT_CHAIN_PARA    pChainPara;
    DWORD               dwFlags;
} CERT_SELECT_CHAIN_PARA;
typedef CERT_SELECT_CHAIN_PARA          *PCERT_SELECT_CHAIN_PARA;
typedef const CERT_SELECT_CHAIN_PARA    *PCCERT_SELECT_CHAIN_PARA;
#endif

/* Certificate selection criteria */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CERT_SELECT_CRITERIA {
    DWORD   dwType;
    DWORD   cPara;
    void    **ppPara;
} CERT_SELECT_CRITERIA;
typedef CERT_SELECT_CRITERIA        *PCERT_SELECT_CRITERIA;
typedef const CERT_SELECT_CRITERIA  *PCCERT_SELECT_CRITERIA;
#endif

/* Cryptographic timestamp request */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_REQUEST {
    DWORD                       dwVersion;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_DER_BLOB              HashedMessage;
    LPSTR                       pszTSAPolicyId;
    CRYPT_INTEGER_BLOB          Nonce;
    BOOL                        fCertReq;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} CRYPT_TIMESTAMP_REQUEST;
typedef CRYPT_TIMESTAMP_REQUEST *PCRYPT_TIMESTAMP_REQUEST;
#endif

/* Cryptographic timestamp response */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_RESPONSE {
    DWORD           dwStatus;
    DWORD           cFreeText;
    LPWSTR          *rgFreeText;
    CRYPT_BIT_BLOB  FailureInfo;
    CRYPT_DER_BLOB  ContentInfo;
} CRYPT_TIMESTAMP_RESPONSE;
typedef CRYPT_TIMESTAMP_RESPONSE    *PCRYPT_TIMESTAMP_RESPONSE;
#endif

/* Cryptographic timestamp accuracy */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_ACCURACY {
    DWORD   dwSeconds;
    DWORD   dwMillis;
    DWORD   dwMicros;
} CRYPT_TIMESTAMP_ACCURACY;
typedef CRYPT_TIMESTAMP_ACCURACY    *PCRYPT_TIMESTAMP_ACCURACY;
#endif

/* Cryptographic timestamp information */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_INFO {
    DWORD                       dwVersion;
    LPSTR                       pszTSAPolicyId;
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    CRYPT_DER_BLOB              HashedMessage;
    CRYPT_INTEGER_BLOB          SerialNumber;
    FILETIME                    ftTime;
    PCRYPT_TIMESTAMP_ACCURACY   pvAccuracy;
    BOOL                        fOrdering;
    CRYPT_DER_BLOB              Nonce;
    CRYPT_DER_BLOB              Tsa;
    DWORD                       cExtension;
    PCERT_EXTENSION             rgExtension;
} CRYPT_TIMESTAMP_INFO;
typedef CRYPT_TIMESTAMP_INFO    *PCRYPT_TIMESTAMP_INFO;
#endif

/* Cryptographic timestamp context */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_CONTEXT {
    DWORD                   cbEncoded;
    BYTE                    *pbEncoded;
    PCRYPT_TIMESTAMP_INFO   pTimeStamp;
} CRYPT_TIMESTAMP_CONTEXT;
typedef CRYPT_TIMESTAMP_CONTEXT *PCRYPT_TIMESTAMP_CONTEXT;
#endif

/* Cryptographic timestamp parameters */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _CRYPT_TIMESTAMP_PARA {
    LPCSTR              pszTSAPolicyId;
    BOOL                fRequestCerts;
    CRYPT_INTEGER_BLOB  Nonce;
    DWORD               cExtension;
    PCERT_EXTENSION     rgExtension;
} CRYPT_TIMESTAMP_PARA;
typedef CRYPT_TIMESTAMP_PARA    *PCRYPT_TIMESTAMP_PARA;
#endif

/* Functions in ADVAPI32.DLL */
WINADVAPI BOOL WINAPI   CryptAcquireContextA( HCRYPTPROV *, LPCSTR, LPCSTR, DWORD, DWORD );
WINADVAPI BOOL WINAPI   CryptAcquireContextW( HCRYPTPROV *, LPCWSTR, LPCWSTR, DWORD, DWORD );
WINADVAPI BOOL WINAPI   CryptContextAddRef( HCRYPTPROV, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptCreateHash( HCRYPTPROV, ALG_ID, HCRYPTKEY, DWORD, HCRYPTHASH * );
WINADVAPI BOOL WINAPI   CryptDecrypt( HCRYPTKEY, HCRYPTHASH, BOOL, DWORD, BYTE *, DWORD * );
WINADVAPI BOOL WINAPI   CryptDeriveKey( HCRYPTPROV, ALG_ID, HCRYPTHASH, DWORD, HCRYPTKEY * );
WINADVAPI BOOL WINAPI   CryptDestroyHash( HCRYPTHASH );
WINADVAPI BOOL WINAPI   CryptDestroyKey( HCRYPTKEY );
WINADVAPI BOOL WINAPI   CryptDuplicateHash( HCRYPTHASH, DWORD *, DWORD, HCRYPTHASH * );
WINADVAPI BOOL WINAPI   CryptDuplicateKey( HCRYPTKEY, DWORD *, DWORD, HCRYPTKEY * );
WINADVAPI BOOL WINAPI   CryptEncrypt( HCRYPTKEY, HCRYPTHASH, BOOL, DWORD, BYTE *, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptEnumProviderTypesA( DWORD, DWORD *, DWORD, DWORD *, LPSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptEnumProviderTypesW( DWORD, DWORD *, DWORD, DWORD *, LPWSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptEnumProvidersA( DWORD, DWORD *, DWORD, DWORD *, LPSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptEnumProvidersW( DWORD, DWORD *, DWORD, DWORD *, LPWSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptExportKey( HCRYPTKEY, HCRYPTKEY, DWORD, DWORD, BYTE *, DWORD * );
WINADVAPI BOOL WINAPI   CryptGenKey( HCRYPTPROV, ALG_ID, DWORD, HCRYPTKEY * );
WINADVAPI BOOL WINAPI   CryptGenRandom( HCRYPTPROV, DWORD, BYTE * );
WINADVAPI BOOL WINAPI   CryptGetDefaultProviderA( DWORD, DWORD *, DWORD, LPSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptGetDefaultProviderW( DWORD, DWORD *, DWORD, LPWSTR, DWORD * );
WINADVAPI BOOL WINAPI   CryptGetHashParam( HCRYPTHASH, DWORD, BYTE *, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptGetKeyParam( HCRYPTKEY, DWORD, BYTE *, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptGetProvParam( HCRYPTPROV, DWORD, BYTE *, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptGetUserKey( HCRYPTPROV, DWORD, HCRYPTKEY * );
WINADVAPI BOOL WINAPI   CryptHashData( HCRYPTHASH, CONST BYTE *, DWORD, DWORD );
WINADVAPI BOOL WINAPI   CryptHashSessionKey( HCRYPTHASH, HCRYPTKEY, DWORD );
WINADVAPI BOOL WINAPI   CryptImportKey( HCRYPTPROV, CONST BYTE *, DWORD, HCRYPTKEY, DWORD, HCRYPTKEY * );
WINADVAPI BOOL WINAPI   CryptSetProviderA( LPCSTR, DWORD );
WINADVAPI BOOL WINAPI   CryptSetProviderExA( LPCSTR, DWORD, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetProviderExW( LPCWSTR, DWORD, DWORD *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetProviderW( LPCWSTR, DWORD );
WINADVAPI BOOL WINAPI   CryptSignHashA( HCRYPTHASH, DWORD, LPCSTR, DWORD, BYTE *, DWORD * );
WINADVAPI BOOL WINAPI   CryptSignHashW( HCRYPTHASH, DWORD, LPCWSTR, DWORD, BYTE *, DWORD * );
WINADVAPI BOOL WINAPI   CryptVerifySignatureA( HCRYPTHASH, CONST BYTE *, DWORD, HCRYPTKEY, LPCSTR, DWORD );
WINADVAPI BOOL WINAPI   CryptVerifySignatureW( HCRYPTHASH, CONST BYTE *, DWORD, HCRYPTKEY, LPCWSTR, DWORD );
#if (NTDDI_VERSION >= 0x05010000)
WINADVAPI BOOL WINAPI   CryptReleaseContext( HCRYPTPROV, DWORD );
WINADVAPI BOOL WINAPI   CryptSetHashParam( HCRYPTHASH, DWORD, CONST BYTE *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetKeyParam( HCRYPTKEY, DWORD, CONST BYTE *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetProvParam( HCRYPTPROV, DWORD, CONST BYTE *, DWORD );
#else
WINADVAPI BOOL WINAPI   CryptReleaseContext( HCRYPTPROV, ULONG_PTR );
WINADVAPI BOOL WINAPI   CryptSetHashParam( HCRYPTHASH, DWORD, BYTE *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetKeyParam( HCRYPTKEY, DWORD, BYTE *, DWORD );
WINADVAPI BOOL WINAPI   CryptSetProvParam( HCRYPTPROV, DWORD, BYTE *, DWORD );
#endif

/* Functions in CRYPT32.DLL */
WINCRYPT32API BOOL WINAPI           CertAddCRLContextToStore( HCERTSTORE, PCCRL_CONTEXT, DWORD, PCCRL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddCRLLinkToStore( HCERTSTORE, PCCRL_CONTEXT, DWORD, PCCRL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddCTLContextToStore( HCERTSTORE, PCCTL_CONTEXT, DWORD, PCCTL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddCTLLinkToStore( HCERTSTORE, PCCTL_CONTEXT, DWORD, PCCTL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddCertificateContextToStore( HCERTSTORE, PCCERT_CONTEXT, DWORD, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddCertificateLinkToStore( HCERTSTORE, PCCERT_CONTEXT, DWORD, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddEncodedCRLToStore( HCERTSTORE, DWORD, const BYTE *, DWORD, DWORD, PCCRL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddEncodedCTLToStore( HCERTSTORE, DWORD, const BYTE *, DWORD, DWORD, PCCTL_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddEncodedCertificateToStore( HCERTSTORE, DWORD, const BYTE *, DWORD, DWORD, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertAddEncodedCertificateToSystemStoreA( LPCSTR, const BYTE *, DWORD );
WINCRYPT32API BOOL WINAPI           CertAddEncodedCertificateToSystemStoreW( LPCWSTR, const BYTE *, DWORD );
WINCRYPT32API BOOL WINAPI           CertAddEnhancedKeyUsageIdentifier( PCCERT_CONTEXT, LPCSTR );
WINCRYPT32API BOOL WINAPI           CertAddSerializedElementToStore( HCERTSTORE, const BYTE *, DWORD, DWORD, DWORD, DWORD, DWORD *, const void ** );
WINCRYPT32API BOOL WINAPI           CertAddStoreToCollection( HCERTSTORE, HCERTSTORE, DWORD, DWORD );
WINCRYPT32API LPCSTR WINAPI         CertAlgIdToOID( DWORD );
WINCRYPT32API BOOL WINAPI           CertCloseStore( HCERTSTORE, DWORD );
WINCRYPT32API BOOL WINAPI           CertCompareCertificate( DWORD, PCERT_INFO, PCERT_INFO );
WINCRYPT32API BOOL WINAPI           CertCompareCertificateName( DWORD, PCERT_NAME_BLOB, PCERT_NAME_BLOB );
WINCRYPT32API BOOL WINAPI           CertCompareIntegerBlob( PCRYPT_INTEGER_BLOB, PCRYPT_INTEGER_BLOB );
WINCRYPT32API BOOL WINAPI           CertComparePublicKeyInfo( DWORD, PCERT_PUBLIC_KEY_INFO, PCERT_PUBLIC_KEY_INFO );
WINCRYPT32API BOOL WINAPI           CertControlStore( HCERTSTORE, DWORD, DWORD, void const * );
WINCRYPT32API PCCRL_CONTEXT WINAPI  CertCreateCRLContext( DWORD, const BYTE *, DWORD );
WINCRYPT32API PCCTL_CONTEXT WINAPI  CertCreateCTLContext( DWORD, const BYTE *, DWORD );
WINCRYPT32API BOOL WINAPI           CertCreateCTLEntryFromCertificateContextProperties( PCCERT_CONTEXT, DWORD, PCRYPT_ATTRIBUTE, DWORD, void *, PCTL_ENTRY, DWORD * );
WINCRYPT32API BOOL WINAPI           CertCreateCertificateChainEngine( PCERT_CHAIN_ENGINE_CONFIG, HCERTCHAINENGINE * );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertCreateCertificateContext( DWORD, const BYTE *, DWORD );
WINCRYPT32API const void * WINAPI   CertCreateContext( DWORD, DWORD, const BYTE *, DWORD, DWORD, PCERT_CREATE_CONTEXT_PARA );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertCreateSelfSignCertificate( HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, PCERT_NAME_BLOB, DWORD, PCRYPT_KEY_PROV_INFO, PCRYPT_ALGORITHM_IDENTIFIER, PSYSTEMTIME, PSYSTEMTIME, PCERT_EXTENSIONS );
WINCRYPT32API BOOL WINAPI           CertDeleteCRLFromStore( PCCRL_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertDeleteCTLFromStore( PCCTL_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertDeleteCertificateFromStore( PCCERT_CONTEXT );
WINCRYPT32API PCCRL_CONTEXT WINAPI  CertDuplicateCRLContext( PCCRL_CONTEXT );
WINCRYPT32API PCCTL_CONTEXT WINAPI  CertDuplicateCTLContext( PCCTL_CONTEXT );
WINCRYPT32API PCCERT_CHAIN_CONTEXT WINAPI   CertDuplicateCertificateChain( PCCERT_CHAIN_CONTEXT );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertDuplicateCertificateContext( PCCERT_CONTEXT );
WINCRYPT32API HCERTSTORE WINAPI     CertDuplicateStore( HCERTSTORE );
WINCRYPT32API DWORD WINAPI          CertEnumCRLContextProperties( PCCRL_CONTEXT, DWORD );
WINCRYPT32API PCCRL_CONTEXT WINAPI  CertEnumCRLsInStore( HCERTSTORE, PCCRL_CONTEXT );
WINCRYPT32API DWORD WINAPI          CertEnumCTLContextProperties( PCCTL_CONTEXT, DWORD );
WINCRYPT32API PCCTL_CONTEXT WINAPI  CertEnumCTLsInStore( HCERTSTORE, PCCTL_CONTEXT );
WINCRYPT32API DWORD WINAPI          CertEnumCertificateContextProperties( PCCERT_CONTEXT, DWORD );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertEnumCertificatesInStore( HCERTSTORE, PCCERT_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertEnumPhysicalStore( const void *, DWORD, void *, PFN_CERT_ENUM_PHYSICAL_STORE );
WINCRYPT32API BOOL WINAPI           CertEnumSubjectInSortedCTL( PCCTL_CONTEXT, void **, PCRYPT_DER_BLOB, PCRYPT_DER_BLOB );
WINCRYPT32API BOOL WINAPI           CertEnumSystemStore( DWORD, void *, void *, PFN_CERT_ENUM_SYSTEM_STORE );
WINCRYPT32API BOOL WINAPI           CertEnumSystemStoreLocation( DWORD, void *, PFN_CERT_ENUM_SYSTEM_STORE_LOCATION );
WINCRYPT32API PCRYPT_ATTRIBUTE WINAPI   CertFindAttribute( LPCSTR, DWORD, CRYPT_ATTRIBUTE [] );
WINCRYPT32API PCCRL_CONTEXT WINAPI  CertFindCRLInStore( HCERTSTORE, DWORD, DWORD, DWORD, const void *, PCCRL_CONTEXT );
WINCRYPT32API PCCTL_CONTEXT WINAPI  CertFindCTLInStore( HCERTSTORE, DWORD, DWORD, DWORD, const void *, PCCTL_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertFindCertificateInCRL( PCCERT_CONTEXT, PCCRL_CONTEXT, DWORD, void *, PCRL_ENTRY * );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertFindCertificateInStore( HCERTSTORE, DWORD, DWORD, DWORD, const void *, PCCERT_CONTEXT );
WINCRYPT32API PCCERT_CHAIN_CONTEXT WINAPI   CertFindChainInStore( HCERTSTORE, DWORD, DWORD, DWORD, const void *, PCCERT_CHAIN_CONTEXT );
WINCRYPT32API PCERT_EXTENSION WINAPI    CertFindExtension( LPCSTR, DWORD, CERT_EXTENSION [] );
WINCRYPT32API PCERT_RDN_ATTR WINAPI CertFindRDNAttr( LPCSTR, PCERT_NAME_INFO );
WINCRYPT32API PCTL_ENTRY WINAPI     CertFindSubjectInCTL( DWORD, DWORD, void *,  PCCTL_CONTEXT, DWORD );
WINCRYPT32API BOOL WINAPI           CertFindSubjectInSortedCTL( PCRYPT_DATA_BLOB, PCCTL_CONTEXT, DWORD, void *, PCRYPT_DER_BLOB );
WINCRYPT32API BOOL WINAPI           CertFreeCRLContext( PCCRL_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertFreeCTLContext( PCCTL_CONTEXT );
WINCRYPT32API VOID WINAPI           CertFreeCertificateChain( PCCERT_CHAIN_CONTEXT );
WINCRYPT32API VOID WINAPI           CertFreeCertificateChainEngine( HCERTCHAINENGINE );
WINCRYPT32API BOOL WINAPI           CertFreeCertificateContext( PCCERT_CONTEXT );
WINCRYPT32API BOOL WINAPI           CertGetCRLContextProperty( PCCRL_CONTEXT, DWORD, void *, DWORD * );
WINCRYPT32API PCCRL_CONTEXT WINAPI  CertGetCRLFromStore( HCERTSTORE, PCCERT_CONTEXT, PCCRL_CONTEXT, DWORD * );
WINCRYPT32API BOOL WINAPI           CertGetCTLContextProperty( PCCTL_CONTEXT, DWORD, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertGetCertificateChain( HCERTCHAINENGINE, PCCERT_CONTEXT, LPFILETIME, HCERTSTORE, PCERT_CHAIN_PARA, DWORD, LPVOID, PCCERT_CHAIN_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertGetCertificateContextProperty( PCCERT_CONTEXT, DWORD, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertGetEnhancedKeyUsage( PCCERT_CONTEXT, DWORD, PCERT_ENHKEY_USAGE, DWORD * );
WINCRYPT32API BOOL WINAPI           CertGetIntendedKeyUsage( DWORD, PCERT_INFO, BYTE *, DWORD );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertGetIssuerCertificateFromStore( HCERTSTORE, PCCERT_CONTEXT, PCCERT_CONTEXT, DWORD * );
WINCRYPT32API DWORD WINAPI          CertGetNameStringA( PCCERT_CONTEXT, DWORD, DWORD, void *, LPSTR, DWORD );
WINCRYPT32API DWORD WINAPI          CertGetNameStringW( PCCERT_CONTEXT, DWORD, DWORD, void *, LPWSTR, DWORD );
WINCRYPT32API DWORD WINAPI          CertGetPublicKeyLength( DWORD, PCERT_PUBLIC_KEY_INFO );
WINCRYPT32API BOOL WINAPI           CertGetStoreProperty( HCERTSTORE, DWORD, void *, DWORD * );
WINCRYPT32API PCCERT_CONTEXT WINAPI CertGetSubjectCertificateFromStore( HCERTSTORE, DWORD, PCERT_INFO );
WINCRYPT32API BOOL WINAPI           CertGetValidUsages( DWORD, PCCERT_CONTEXT *, int *, LPSTR *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertIsRDNAttrsInCertificateName( DWORD, DWORD, PCERT_NAME_BLOB, PCERT_RDN );
WINCRYPT32API BOOL WINAPI           CertIsValidCRLForCertificate( PCCERT_CONTEXT, PCCRL_CONTEXT, DWORD, void * );
WINCRYPT32API DWORD WINAPI          CertNameToStrA( DWORD, PCERT_NAME_BLOB, DWORD, LPSTR, DWORD );
WINCRYPT32API DWORD WINAPI          CertNameToStrW( DWORD, PCERT_NAME_BLOB, DWORD, LPWSTR, DWORD );
WINCRYPT32API DWORD WINAPI          CertOIDToAlgId( LPCSTR );
WINCRYPT32API HCERTSTORE WINAPI     CertOpenStore( LPCSTR, DWORD, HCRYPTPROV_LEGACY, DWORD, const void * );
WINCRYPT32API HCERTSTORE WINAPI     CertOpenSystemStoreA( HCRYPTPROV_LEGACY, LPCSTR );
WINCRYPT32API HCERTSTORE WINAPI     CertOpenSystemStoreW( HCRYPTPROV_LEGACY, LPCWSTR );
WINCRYPT32API DWORD WINAPI          CertRDNValueToStrA( DWORD, PCERT_RDN_VALUE_BLOB, LPSTR, DWORD );
WINCRYPT32API DWORD WINAPI          CertRDNValueToStrW( DWORD, PCERT_RDN_VALUE_BLOB, LPWSTR, DWORD );
WINCRYPT32API BOOL WINAPI           CertRegisterPhysicalStore( const void *, DWORD, LPCWSTR, PCERT_PHYSICAL_STORE_INFO, void * );
WINCRYPT32API BOOL WINAPI           CertRegisterSystemStore( const void *, DWORD, PCERT_SYSTEM_STORE_INFO, void * );
WINCRYPT32API BOOL WINAPI           CertRemoveEnhancedKeyUsageIdentifier( PCCERT_CONTEXT, LPCSTR );
WINCRYPT32API void WINAPI           CertRemoveStoreFromCollection( HCERTSTORE, HCERTSTORE );
WINCRYPT32API BOOL WINAPI           CertResyncCertificateChainEngine( HCERTCHAINENGINE );
WINCRYPT32API BOOL WINAPI           CertRetrieveLogoOrBiometricInfo( PCCERT_CONTEXT, LPCSTR, DWORD, DWORD, DWORD, void *, BYTE **, DWORD *, LPWSTR * );
WINCRYPT32API BOOL WINAPI           CertSaveStore( HCERTSTORE, DWORD, DWORD, DWORD, void *, DWORD );
WINCRYPT32API BOOL WINAPI           CertSerializeCRLStoreElement( PCCRL_CONTEXT, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertSerializeCTLStoreElement( PCCTL_CONTEXT, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertSerializeCertificateStoreElement( PCCERT_CONTEXT, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CertSetCRLContextProperty( PCCRL_CONTEXT, DWORD, DWORD, const void * );
WINCRYPT32API BOOL WINAPI           CertSetCTLContextProperty( PCCTL_CONTEXT, DWORD, DWORD, const void * );
WINCRYPT32API BOOL WINAPI           CertSetCertificateContextPropertiesFromCTLEntry( PCCERT_CONTEXT, PCTL_ENTRY, DWORD );
WINCRYPT32API BOOL WINAPI           CertSetCertificateContextProperty( PCCERT_CONTEXT, DWORD, DWORD, const void * );
WINCRYPT32API BOOL WINAPI           CertSetEnhancedKeyUsage( PCCERT_CONTEXT, PCERT_ENHKEY_USAGE );
WINCRYPT32API BOOL WINAPI           CertSetStoreProperty( HCERTSTORE, DWORD, DWORD, const void * );
WINCRYPT32API BOOL WINAPI           CertStrToNameA( DWORD, LPCSTR, DWORD, void *, BYTE *, DWORD *, LPCSTR * );
WINCRYPT32API BOOL WINAPI           CertStrToNameW( DWORD, LPCWSTR, DWORD, void *, BYTE *, DWORD *, LPCWSTR * );
WINCRYPT32API BOOL WINAPI           CertUnregisterPhysicalStore( const void *, DWORD, LPCWSTR );
WINCRYPT32API BOOL WINAPI           CertUnregisterSystemStore( const void *, DWORD );
WINCRYPT32API BOOL WINAPI           CertVerifyCRLRevocation( DWORD, PCERT_INFO, DWORD, PCRL_INFO [] );
WINCRYPT32API LONG WINAPI           CertVerifyCRLTimeValidity( LPFILETIME, PCRL_INFO );
WINCRYPT32API BOOL WINAPI           CertVerifyCTLUsage( DWORD, DWORD, void *, PCTL_USAGE, DWORD, PCTL_VERIFY_USAGE_PARA, PCTL_VERIFY_USAGE_STATUS );
WINCRYPT32API BOOL WINAPI           CertVerifyCertificateChainPolicy( LPCSTR, PCCERT_CHAIN_CONTEXT, PCERT_CHAIN_POLICY_PARA, PCERT_CHAIN_POLICY_STATUS );
WINCRYPT32API BOOL WINAPI           CertVerifyRevocation( DWORD, DWORD, DWORD, PVOID [], DWORD, PCERT_REVOCATION_PARA, PCERT_REVOCATION_STATUS );
WINCRYPT32API BOOL WINAPI           CertVerifySubjectCertificateContext( PCCERT_CONTEXT, PCCERT_CONTEXT, DWORD * );
WINCRYPT32API LONG WINAPI           CertVerifyTimeValidity( LPFILETIME, PCERT_INFO );
WINCRYPT32API BOOL WINAPI           CertVerifyValidityNesting( PCERT_INFO, PCERT_INFO );
WINCRYPT32API BOOL WINAPI           CryptAcquireCertificatePrivateKey( PCCERT_CONTEXT, DWORD, void *, HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, DWORD *, BOOL * );
WINCRYPT32API BOOL WINAPI           CryptCloseAsyncHandle( HCRYPTASYNC );
WINCRYPT32API BOOL WINAPI           CryptCreateAsyncHandle( DWORD, PHCRYPTASYNC );
WINCRYPT32API BOOL WINAPI           CryptCreateKeyIdentifierFromCSP( DWORD, LPCSTR, const PUBLICKEYSTRUC *, DWORD, DWORD, void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptDecodeMessage( DWORD, PCRYPT_DECRYPT_MESSAGE_PARA, PCRYPT_VERIFY_MESSAGE_PARA, DWORD, const BYTE *, DWORD, DWORD, DWORD *, DWORD *, BYTE *, DWORD *, PCCERT_CONTEXT *, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptDecodeObject( DWORD, LPCSTR, const BYTE *, DWORD, DWORD, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptDecodeObjectEx( DWORD, LPCSTR, const BYTE *, DWORD, DWORD, PCRYPT_DECODE_PARA, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptDecryptAndVerifyMessageSignature( PCRYPT_DECRYPT_MESSAGE_PARA, PCRYPT_VERIFY_MESSAGE_PARA, DWORD, const BYTE *, DWORD, BYTE *, DWORD *, PCCERT_CONTEXT *, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptDecryptMessage( PCRYPT_DECRYPT_MESSAGE_PARA, const BYTE *, DWORD, BYTE *, DWORD *, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptEncodeObject( DWORD, LPCSTR, const void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptEncodeObjectEx( DWORD, LPCSTR, const void *, DWORD, PCRYPT_ENCODE_PARA, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptEncryptMessage( PCRYPT_ENCRYPT_MESSAGE_PARA, DWORD, PCCERT_CONTEXT [], const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptEnumKeyIdentifierProperties( const CRYPT_HASH_BLOB *, DWORD, DWORD, LPCWSTR, void *, void *, PFN_CRYPT_ENUM_KEYID_PROP );
WINCRYPT32API BOOL WINAPI           CryptEnumOIDFunction( DWORD, LPCSTR, LPCSTR, DWORD, void *, PFN_CRYPT_ENUM_OID_FUNC );
WINCRYPT32API BOOL WINAPI           CryptEnumOIDInfo( DWORD, DWORD, void *, PFN_CRYPT_ENUM_OID_INFO );
WINCRYPT32API BOOL WINAPI           CryptExportPKCS8( HCRYPTPROV, DWORD, LPSTR, DWORD, void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptExportPKCS8Ex( CRYPT_PKCS8_EXPORT_PARAMS *, DWORD, void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptExportPublicKeyInfo( HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, DWORD, DWORD, PCERT_PUBLIC_KEY_INFO, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptExportPublicKeyInfoEx( HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, DWORD, DWORD, LPSTR, DWORD, void *, PCERT_PUBLIC_KEY_INFO, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptFindCertificateKeyProvInfo( PCCERT_CONTEXT, DWORD, void * );
WINCRYPT32API LPCWSTR WINAPI        CryptFindLocalizedName( LPCWSTR );
WINCRYPT32API PCCRYPT_OID_INFO WINAPI   CryptFindOIDInfo( DWORD, void *, DWORD );
WINCRYPT32API BOOL WINAPI           CryptFormatObject( DWORD, DWORD, DWORD, void *, LPCSTR, const BYTE *, DWORD, void *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptFreeOIDFunctionAddress( HCRYPTOIDFUNCADDR, DWORD );
WINCRYPT32API BOOL WINAPI           CryptGetAsyncParam( HCRYPTASYNC, LPSTR, LPVOID *, PFN_CRYPT_ASYNC_PARAM_FREE_FUNC * );
WINCRYPT32API BOOL WINAPI           CryptGetDefaultOIDDllList( HCRYPTOIDFUNCSET, DWORD, WCHAR *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptGetDefaultOIDFunctionAddress( HCRYPTOIDFUNCSET, DWORD, LPCWSTR, DWORD, void **, HCRYPTOIDFUNCADDR * );
WINCRYPT32API BOOL WINAPI           CryptGetKeyIdentifierProperty( const CRYPT_HASH_BLOB *, DWORD, DWORD, LPCWSTR, void *, void *, DWORD * );
WINCRYPT32API HCERTSTORE WINAPI     CryptGetMessageCertificates( DWORD, HCRYPTPROV_LEGACY, DWORD, const BYTE *, DWORD );
WINCRYPT32API LONG WINAPI           CryptGetMessageSignerCount( DWORD, const BYTE *, DWORD );
WINCRYPT32API BOOL WINAPI           CryptGetOIDFunctionAddress( HCRYPTOIDFUNCSET, DWORD, LPCSTR, DWORD, void **, HCRYPTOIDFUNCADDR );
WINCRYPT32API BOOL WINAPI           CryptGetOIDFunctionValue( DWORD, LPCSTR, LPCSTR, LPCWSTR, DWORD *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptHashCertificate( HCRYPTPROV_LEGACY, ALG_ID, DWORD, const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptHashMessage( PCRYPT_HASH_MESSAGE_PARA, BOOL, DWORD, const BYTE * [], DWORD [], BYTE *, DWORD *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptHashPublicKeyInfo( HCRYPTPROV_LEGACY, ALG_ID, DWORD, DWORD, PCERT_PUBLIC_KEY_INFO, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptHashToBeSigned( HCRYPTPROV_LEGACY, DWORD, const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptImportPKCS8( CRYPT_PKCS8_IMPORT_PARAMS, DWORD, HCRYPTPROV *, void * );
WINCRYPT32API BOOL WINAPI           CryptImportPublicKeyInfo( HCRYPTPROV, DWORD, PCERT_PUBLIC_KEY_INFO, HCRYPTKEY * );
WINCRYPT32API BOOL WINAPI           CryptImportPublicKeyInfoEx( HCRYPTPROV, DWORD, PCERT_PUBLIC_KEY_INFO, ALG_ID, DWORD, void *, HCRYPTKEY * );
WINCRYPT32API HCRYPTOIDFUNCSET WINAPI   CryptInitOIDFunctionSet( LPCSTR, DWORD );
WINCRYPT32API BOOL WINAPI           CryptInstallDefaultContext( HCRYPTPROV, DWORD, const void *, DWORD, void *, HCRYPTDEFAULTCONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptInstallOIDFunctionAddress( HMODULE, DWORD, LPCSTR, DWORD, const CRYPT_OID_FUNC_ENTRY [], DWORD );
WINCRYPT32API LPVOID WINAPI         CryptMemAlloc( ULONG );
WINCRYPT32API VOID WINAPI           CryptMemFree( LPVOID );
WINCRYPT32API LPVOID WINAPI         CryptMemRealloc( LPVOID, ULONG );
WINCRYPT32API DWORD WINAPI          CryptMsgCalculateEncodedLength( DWORD, DWORD, DWORD, void const *, LPSTR, DWORD );
WINCRYPT32API BOOL WINAPI           CryptMsgClose( HCRYPTMSG );
WINCRYPT32API BOOL WINAPI           CryptMsgControl( HCRYPTMSG, DWORD, DWORD, void const * );
WINCRYPT32API BOOL WINAPI           CryptMsgCountersign( HCRYPTMSG, DWORD, DWORD, PCMSG_SIGNER_ENCODE_INFO );
WINCRYPT32API BOOL WINAPI           CryptMsgCountersignEncoded( DWORD, PBYTE, DWORD, DWORD, PCMSG_SIGNER_ENCODE_INFO, PBYTE, PDWORD );
WINCRYPT32API HCRYPTMSG WINAPI      CryptMsgDuplicate( HCRYPTMSG );
WINCRYPT32API BOOL WINAPI           CryptMsgEncodeAndSignCTL( DWORD, PCTL_INFO, PCMSG_SIGNED_ENCODE_INFO, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptMsgGetAndVerifySigner( HCRYPTMSG, DWORD, HCERTSTORE *, DWORD, PCCERT_CONTEXT *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptMsgGetParam( HCRYPTMSG, DWORD, DWORD, void *, DWORD * );
WINCRYPT32API HCRYPTMSG WINAPI      CryptMsgOpenToDecode( DWORD, DWORD, DWORD, HCRYPTPROV_LEGACY, PCERT_INFO, PCMSG_STREAM_INFO );
WINCRYPT32API HCRYPTMSG WINAPI      CryptMsgOpenToEncode( DWORD, DWORD, DWORD, void const *, LPSTR, PCMSG_STREAM_INFO );
WINCRYPT32API BOOL WINAPI           CryptMsgSignCTL( DWORD, BYTE *, DWORD, PCMSG_SIGNED_ENCODE_INFO, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptMsgUpdate( HCRYPTMSG, const BYTE *, DWORD, BOOL );
WINCRYPT32API BOOL WINAPI           CryptMsgVerifyCountersignatureEncoded( HCRYPTPROV_LEGACY, DWORD, PBYTE, DWORD, PBYTE, DWORD, PCERT_INFO );
WINCRYPT32API BOOL WINAPI           CryptMsgVerifyCountersignatureEncodedEx( HCRYPTPROV_LEGACY, DWORD, PBYTE, DWORD, PBYTE, DWORD, DWORD, void *, DWORD, void * );
WINCRYPT32API BOOL WINAPI           CryptProtectData( DATA_BLOB *, LPCWSTR, DATA_BLOB *, PVOID, CRYPTPROTECT_PROMPTSTRUCT *, DWORD, DATA_BLOB * );
WINCRYPT32API BOOL WINAPI           CryptProtectMemory( LPVOID, DWORD, DWORD );
WINCRYPT32API BOOL WINAPI           CryptQueryObject( DWORD, const void *, DWORD, DWORD, DWORD, DWORD *, DWORD *, DWORD *, HCERTSTORE *, HCRYPTMSG *, void ** );
WINCRYPT32API BOOL WINAPI           CryptRegisterDefaultOIDFunction( DWORD, LPCSTR, DWORD, LPCWSTR );                                                        
WINCRYPT32API BOOL WINAPI           CryptRegisterOIDFunction( DWORD, LPCSTR, LPCSTR, LPCWSTR, LPCSTR );
WINCRYPT32API BOOL WINAPI           CryptRegisterOIDInfo( PCCRYPT_OID_INFO, DWORD );
WINCRYPT32API BOOL WINAPI           CryptSetAsyncParam( HCRYPTASYNC, LPSTR, LPVOID, PFN_CRYPT_ASYNC_PARAM_FREE_FUNC );
WINCRYPT32API BOOL WINAPI           CryptSetKeyIdentifierProperty( const CRYPT_HASH_BLOB *, DWORD, DWORD, LPCWSTR, void *, const void * );
WINCRYPT32API BOOL WINAPI           CryptSetOIDFunctionValue( DWORD, LPCSTR, LPCSTR, LPCWSTR, DWORD, const BYTE *, DWORD );
WINCRYPT32API BOOL WINAPI           CryptSignAndEncodeCertificate( HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, DWORD, DWORD, LPCSTR, const void *, PCRYPT_ALGORITHM_IDENTIFIER, const void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptSignAndEncryptMessage( PCRYPT_SIGN_MESSAGE_PARA, PCRYPT_ENCRYPT_MESSAGE_PARA, DWORD, PCCERT_CONTEXT [], const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptSignCertificate( HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, DWORD, DWORD, const BYTE *, DWORD, PCRYPT_ALGORITHM_IDENTIFIER, const void *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptSignMessage( PCRYPT_SIGN_MESSAGE_PARA, BOOL, DWORD, const BYTE * [], DWORD [], BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptSignMessageWithKey( PCRYPT_KEY_SIGN_MESSAGE_PARA, const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptUninstallCancelRetrieval( DWORD, void * );
WINCRYPT32API BOOL WINAPI           CryptUninstallDefaultContext( HCRYPTDEFAULTCONTEXT, DWORD, void * );
WINCRYPT32API BOOL WINAPI           CryptUnprotectData( DATA_BLOB *, LPWSTR *, DATA_BLOB *, PVOID, CRYPTPROTECT_PROMPTSTRUCT *, DWORD, DATA_BLOB * );
WINCRYPT32API BOOL WINAPI           CryptUnprotectMemory( LPVOID, DWORD, DWORD );
WINCRYPT32API BOOL WINAPI           CryptUnregisterDefaultOIDFunction( DWORD, LPCSTR, LPCWSTR );
WINCRYPT32API BOOL WINAPI           CryptUnregisterOIDFunction( DWORD, LPCSTR, LPCSTR );
WINCRYPT32API BOOL WINAPI           CryptUnregisterOIDInfo( PCCRYPT_OID_INFO );
WINCRYPT32API BOOL WINAPI           CryptVerifyCertificateSignature( HCRYPTPROV_LEGACY, DWORD, const BYTE *, DWORD, PCERT_PUBLIC_KEY_INFO );
WINCRYPT32API BOOL WINAPI           CryptVerifyCertificateSignatureEx( HCRYPTPROV_LEGACY, DWORD, DWORD, void *, DWORD, void *, DWORD, void * );
WINCRYPT32API BOOL WINAPI           CryptVerifyDetachedMessageHash( PCRYPT_HASH_MESSAGE_PARA, BYTE *, DWORD, DWORD, const BYTE * [], DWORD [], BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptVerifyDetachedMessageSignature( PCRYPT_VERIFY_MESSAGE_PARA, DWORD, const BYTE *, DWORD, DWORD, const BYTE * [], DWORD [], PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptVerifyMessageHash( PCRYPT_HASH_MESSAGE_PARA, BYTE *, DWORD, BYTE *, DWORD *, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptVerifyMessageSignature( PCRYPT_VERIFY_MESSAGE_PARA, DWORD, const BYTE *, DWORD, BYTE *, DWORD *, PCCERT_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CryptVerifyMessageSignatureWithKey( PCRYPT_KEY_VERIFY_MESSAGE_PARA, PCERT_PUBLIC_KEY_INFO, const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           PFXExportCertStore( HCERTSTORE, CRYPT_DATA_BLOB *, LPCWSTR, DWORD );
WINCRYPT32API BOOL WINAPI           PFXExportCertStoreEx( HCERTSTORE, CRYPT_DATA_BLOB *, LPCWSTR, void *, DWORD );
WINCRYPT32API HCERTSTORE WINAPI     PFXImportCertStore( CRYPT_DATA_BLOB *, LPCWSTR, DWORD );
WINCRYPT32API BOOL WINAPI           PFXIsPFXBlob( CRYPT_DATA_BLOB * );
WINCRYPT32API BOOL WINAPI           PFXVerifyPassword( CRYPT_DATA_BLOB *, LPCWSTR, DWORD );
#if (NTDDI_VERSION >= 0x06000000)
WINCRYPT32API VOID WINAPI           CertAddRefServerOcspResponse( HCERT_SERVER_OCSP_RESPONSE );
WINCRYPT32API VOID WINAPI           CertAddRefServerOcspResponseContext( PCCERT_SERVER_OCSP_RESPONSE_CONTEXT );
WINCRYPT32API VOID WINAPI           CertCloseServerOcspResponse( HCERT_SERVER_OCSP_RESPONSE, DWORD );
WINCRYPT32API VOID WINAPI           CertFreeServerOcspResponseContext( PCCERT_SERVER_OCSP_RESPONSE_CONTEXT );
WINCRYPT32API PCCERT_SERVER_OCSP_RESPONSE_CONTEXT WINAPI    CertGetServerOcspResponseContext( HCERT_SERVER_OCSP_RESPONSE, DWORD, LPVOID );
WINCRYPT32API HCERT_SERVER_OCSP_RESPONSE WINAPI CertOpenServerOcspResponse( PCCERT_CHAIN_CONTEXT, DWORD, LPVOID );
WINCRYPT32API BOOL WINAPI           CryptHashCertificate2( LPCWSTR, DWORD, void *, const BYTE *, DWORD, BYTE *, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptImportPublicKeyInfoEx2( DWORD, PCERT_PUBLIC_KEY_INFO, DWORD, void *, BCRYPT_KEY_HANDLE * );
WINCRYPT32API BOOL WINAPI           CryptUpdateProtectedState( PSID, LPCWSTR, DWORD, DWORD *, DWORD * );
#endif
#if (NTDDI_VERSION >= 0x06010000)
WINCRYPT32API VOID WINAPI           CertFreeCertificateChainList( PCCERT_CHAIN_CONTEXT * );
WINCRYPT32API BOOL WINAPI           CertSelectCertificateChains( LPCGUID, DWORD, PCCERT_SELECT_CHAIN_PARA, DWORD, PCCERT_SELECT_CRITERIA, HCERTSTORE, PDWORD, PCCERT_CHAIN_CONTEXT ** );
WINCRYPT32API BOOL WINAPI           CryptExportPublicKeyInfoFromBCryptKeyHandle( BCRYPT_KEY_HANDLE, DWORD, LPSTR, DWORD, void *, PCERT_PUBLIC_KEY_INFO, DWORD * );
WINCRYPT32API BOOL WINAPI           CryptRetrieveTimeStamp( LPCWSTR, DWORD, DWORD, LPCSTR, const CRYPT_TIMESTAMP_PARA *, const BYTE *, DWORD, PCRYPT_TIMESTAMP_CONTEXT, PCCERT_CONTEXT *, HCERTSTORE * );
WINCRYPT32API BOOL WINAPI           CryptVerifyTimeStampSignature( const BYTE *, DWORD, const BYTE *, DWORD, HCERTSTORE, PCRYPT_TIMESTAMP_CONTEXT *, PCCERT_CONTEXT *, HCERTSTORE * );
#endif

/* Functions in CRYPT32.DLL for string/binary conversion */
WINCRYPT32STRINGAPI BOOL WINAPI CryptBinaryToStringA( CONST BYTE *, DWORD, DWORD, LPSTR, DWORD * );
WINCRYPT32STRINGAPI BOOL WINAPI CryptBinaryToStringW( CONST BYTE *, DWORD, DWORD, LPWSTR, DWORD * );
WINCRYPT32STRINGAPI BOOL WINAPI CryptStringToBinaryA( LPCSTR, DWORD, DWORD, BYTE *, DWORD *, DWORD *, DWORD * );
WINCRYPT32STRINGAPI BOOL WINAPI CryptStringToBinaryW( LPCWSTR, DWORD, DWORD, BYTE *, DWORD *, DWORD *, DWORD * );

/* Functions in CRYPTNET.DLL */
WINCRYPT32API BOOL WINAPI   CryptGetObjectUrl( LPCSTR, LPVOID, DWORD, PCRYPT_URL_ARRAY, DWORD *, PCRYPT_URL_INFO, DWORD *, LPVOID );
WINCRYPT32API BOOL WINAPI   CryptInstallCancelRetrieval( PFN_CRYPT_CANCEL_RETRIEVAL, const void *, DWORD, void * );
WINCRYPT32API BOOL WINAPI   CryptRetrieveObjectByUrlA( LPCSTR, LPCSTR, DWORD, DWORD, LPVOID *, HCRYPTASYNC, PCRYPT_CREDENTIALS, LPVOID, PCRYPT_RETRIEVE_AUX_INFO );
WINCRYPT32API BOOL WINAPI   CryptRetrieveObjectByUrlW( LPCWSTR, LPCWSTR, DWORD, DWORD, LPVOID *, HCRYPTASYNC, PCRYPT_CREDENTIALS, LPVOID, PCRYPT_RETRIEVE_AUX_INFO );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define CertAddEncodedCertificateToSystemStore  CertAddEncodedCertificateToSystemStoreW
    #define CertGetNameString           CertGetNameStringW
    #define CertNameToStr               CertNameToStrW
    #define CertOpenSystemStore         CertOpenSystemStoreW
    #define CertRDNValueToStr           CertRDNValueToStrW
    #define CertStrToName               CertStrToNameW
    #define CryptAcquireContext         CryptAcquireContextW
    #define CryptBinaryToString         CryptBinaryToStringW
    #define CryptEnumProviderTypes      CryptEnumProviderTypesW
    #define CryptEnumProviders          CryptEnumProvidersW
    #define CryptGetDefaultProvider     CryptGetDefaultProviderW
    #define CryptRetrieveObjectByUrl    CryptRetrieveObjectByUrlW
    #define CryptSetProvider            CryptSetProviderW
    #define CryptSetProviderEx          CryptSetProviderExW
    #define CryptSignHash               CryptSignHashW
    #define CryptStringToBinary         CryptStringToBinaryW
    #define CryptVerifySignature        CryptVerifySignatureW
#else
    #define CertAddEncodedCertificateToSystemStore  CertAddEncodedCertificateToSystemStoreA
    #define CertGetNameString           CertGetNameStringA
    #define CertNameToStr               CertNameToStrA
    #define CertOpenSystemStore         CertOpenSystemStoreA
    #define CertRDNValueToStr           CertRDNValueToStrA
    #define CertStrToName               CertStrToNameA
    #define CryptAcquireContext         CryptAcquireContextA
    #define CryptBinaryToString         CryptBinaryToStringA
    #define CryptEnumProviderTypes      CryptEnumProviderTypesA
    #define CryptEnumProviders          CryptEnumProvidersA
    #define CryptGetDefaultProvider     CryptGetDefaultProviderA
    #define CryptRetrieveObjectByUrl    CryptRetrieveObjectByUrlA
    #define CryptSetProvider            CryptSetProviderA
    #define CryptSetProviderEx          CryptSetProviderExA
    #define CryptSignHash               CryptSignHashA
    #define CryptStringToBinary         CryptStringToBinaryA
    #define CryptVerifySignature        CryptVerifySignatureA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __WINCRYPT_H__ */
