;*********************;
; SESSION Main Module ;
;    By Eric Tauck    ;
;*********************;

;***************************************************************************;
; SESSION is a fully functional communications program.  This program       ;
; demonstrates the use of many of the WASM library modules.                 ;
;                                                                           ;
; WASM does not allow nested INCLUDE files, thus all the files required by  ;
; SESSION are included in this, the main, source file.  The library files   ;
; are assumed to be in the ..\..\LIBRARY sudirectory.  The other SESSION    ;
; source files (INCLUDEed at the end of this file) are:                     ;                                      ;
;                                                                           ;
;   ANSI.ASM      ANSI terminal support                                     ;
;   BEEPS.ASM     sound effects                                             ;
;   COMMAND.ASM   string input and messages                                 ;
;   DISPLAY.ASM   display output and initialization                         ;
;   OPTIONS.ASM   command line options                                      ;
;   MACRO.ASM     macro support                                             ;
;   TERMINAL.ASM  terminal mode                                             ;
;   TRANSFER.ASM  file transfer                                             ;
;                                                                           ;
; SESSION is assembled with:                                                ;
;                                                                           ;
;   WASM session                                                            ;
;                                                                           ;
; Once assembled, SESSION is may be run by entering SESSION at the DOS      ;
; command line.  You are placed in terminal mode connected to serial port   ;
; one.  Every key you type is sent to the serial port and every character   ;
; received from the serial port is displayed to the screen.  The keyboard   ;
; commands to control SESSION are:                                          ;
;                                                                           ;
;  Control                      Transfer                                    ;
;  -------                      --------                                    ;
;                                                                           ;
;  ALT-A  abort file transfer   ALT-U  upload text file                     ;
;  ALT-C  clear screen          ALT-D  download text file                   ;
;  ALT-M  run macro             PgUp   upload binary file                   ;
;  ALT-R  reset screen          PgDn   download binary file                 ;
;  ALT-X  exit program                                                      ;
;  ALT-Z  system shell                                                      ;
;                                                                           ;
;  Configure                                                                ;
;  ---------                                                                ;
;                                                                           ;
;  ALT-E  toggle echo           ALT-B  toggle macro debugging               ;
;  ALT-S  toggle split screen                                               ;
;                                                                           ;
; Future improvements:                                                      ;
;                                                                           ;
;   * Trap BREAK to properly terminate the serial port connection           ;
;   * Trap critical DOS errors for the same reason as above                 ;
;                                                                           ;
; Versions changes:                                                         ;
;                                                                           ;
;   1.01  Fix ANSI sequences: alternate move is f not F, check for color    ;
;         out of range, row/column reversed for f and H, and 1J is clear    ;
;         from curor.                                                       ;
;                                                                           ;
;   1.02  Formfeed character clears the window.                             ;
;***************************************************************************;

        JUMP+
        UNUSED+

;--- some standard control characters

BEL     EQU     7       ;bell
BS      EQU     8       ;backspace
TAB     EQU     9       ;tab
LF      EQU     10      ;linefeed
FF      EQU     12      ;formfeed
CR      EQU     13      ;carriage return
;XON    EQU     17      ;DC1, restart flow (not used)
XOFF    EQU     19      ;DC3, stop flow
ESC     EQU     27      ;carriage return

;========================================
; User configuration.

COMM_SIZE       EQU     4096            ;size of communications buffer

MACRO_CODESIZE  EQU     4096            ;macro code and return segment size
MACRO_STACKSIZE EQU     4096            ;macro stack segment size
MACRO_SYMSIZE   EQU     2048            ;macro symbol table size

TEMP_TIMER      EQU     1               ;general timer for anything
PACE_TIMER      EQU     2               ;timer for pace count
MACRO_TIMER     EQU     3               ;timer for macros

ATTR_COUNT      EQU     11              ;number of attributes below

;--- monchrome adapter attributes

M_ATTR_INP1     EQU     (WHITE * 16) OR BLACK   ;input
M_ATTR_CONF     EQU     (WHITE * 16) OR BLACK   ;confirm something
M_ATTR_STAT     EQU     (WHITE * 16) OR BLACK   ;top line status
M_ATTR_TERM     EQU     (BLACK * 16) OR WHITE   ;terminal input
M_ATTR_LOC      EQU     (BLACK * 16) OR WHITE   ;local input
M_ATTR_REM      EQU     (BLACK * 16) OR WHITE   ;remote input
M_ATTR_LINE     EQU     (BLACK * 16) OR WHITE   ;center line in split
M_ATTR_HELP     EQU     (BLACK * 16) OR WHITE   ;help text
M_ATTR_ERROR    EQU     (WHITE * 16) OR BLACK   ;error message
M_ATTR_MESS     EQU     (BLACK * 16) OR WHITE   ;system terminal message
M_ATTR_DEBUG    EQU     (BLACK * 16) OR WHITE OR BOLD ;debug terminal message

;--- color adapter attributes

C_ATTR_INP1     EQU     (BLUE * 16) OR WHITE    ;input prompt
C_ATTR_CONF     EQU     (RED * 16) OR WHITE     ;confirm something
C_ATTR_STAT     EQU     (WHITE * 16) OR BLUE    ;top line status
C_ATTR_TERM     EQU     (BLACK * 16) OR WHITE   ;terminal input
C_ATTR_LOC      EQU     (BLACK * 16) OR GREEN   ;local input
C_ATTR_REM      EQU     (BLACK * 16) OR WHITE   ;remote input
C_ATTR_LINE     EQU     (BLACK * 16) OR BLUE    ;center line in split
C_ATTR_HELP     EQU     (BLACK * 16) OR WHITE   ;help text
C_ATTR_ERROR    EQU     (RED * 16) OR WHITE     ;error message
C_ATTR_MESS     EQU     (BLACK * 16) OR CYAN    ;system terminal mess
C_ATTR_DEBUG    EQU     (BLACK * 16) OR BROWN   ;debug terminal mess

;========================================
; Library modules.

        UNUSED-
        INCLUDE '..\..\library\start.asm'
        INCLUDE '..\..\library\buffer1.asm'
        INCLUDE '..\..\library\buffer2.asm'
        INCLUDE '..\..\library\buffer3.asm'
        INCLUDE '..\..\library\buffer4.asm'
        INCLUDE '..\..\library\case1.asm'
        INCLUDE '..\..\library\case2.asm'
        INCLUDE '..\..\library\check1.asm'
        INCLUDE '..\..\library\check3.asm'
        INCLUDE '..\..\library\convert.asm'
        INCLUDE '..\..\library\enviro.asm'
        INCLUDE '..\..\library\file.asm'
        INCLUDE '..\..\library\input.asm'
        INCLUDE '..\..\library\justify1.asm'
        INCLUDE '..\..\library\keybrd.asm'
        INCLUDE '..\..\library\macro1.asm'
        INCLUDE '..\..\library\macro2.asm'
        INCLUDE '..\..\library\memory.asm'
        INCLUDE '..\..\library\message1.asm'
        INCLUDE '..\..\library\parms.asm'
        INCLUDE '..\..\library\prompt.asm'
        INCLUDE '..\..\library\serial1.asm'
        INCLUDE '..\..\library\serial2.asm'
        INCLUDE '..\..\library\serial3.asm'
        INCLUDE '..\..\library\serial4.asm'
        INCLUDE '..\..\library\serial5.asm'
        INCLUDE '..\..\library\serial6.asm'
        INCLUDE '..\..\library\serial7.asm'
        INCLUDE '..\..\library\serial9.asm'
        INCLUDE '..\..\library\shell1.asm'
        INCLUDE '..\..\library\shell2.asm'
        INCLUDE '..\..\library\sound.asm'
        INCLUDE '..\..\library\stack.asm'
        INCLUDE '..\..\library\string.asm'
        INCLUDE '..\..\library\stringf.asm'
        INCLUDE '..\..\library\ticks.asm'
        INCLUDE '..\..\library\video1.asm'
        INCLUDE '..\..\library\video2.asm'
        INCLUDE '..\..\library\video3.asm'
        INCLUDE '..\..\library\video4.asm'
        INCLUDE '..\..\library\video5.asm'
        INCLUDE '..\..\library\video6.asm'
        INCLUDE '..\..\library\video7.asm'
        INCLUDE '..\..\library\video8.asm'
        INCLUDE '..\..\library\video9.asm'
        INCLUDE '..\..\library\xmodem1.asm'
        INCLUDE '..\..\library\xmodem2.asm'
        UNUSED+

;========================================
; Program entry point.

        mov     MacBug, 1       ;enable macro debugging
        call    Get_Options     ;process command line arguments
        mov     si, ax          ;save macro file

;--- allocate communications buffer

        mov     di, OFFSET srec ;serial port record address
        mov     ax, COMM_SIZE   ;byte for communications buffer
        mov     bx, di
        call    ComAll          ;allocate buffer
        jc      error1

;--- allocate macro buffer

        mov     ax, MACRO_CODESIZE
        mov     bx, MACRO_STACKSIZE
        mov     cx, MACRO_SYMSIZE
        call    MacAll          ;allocate buffers
        jc      error1

;--- initialize display

        call    Display_Init    ;initialize display

;--- enter terminal mode

        mov     ax, si
        call    Terminal        ;do terminal mode

;--- finished

        call    MacRel          ;release macro buffers
        mov     bx, di
        call    ComRel          ;release communications buffer
        call    Display_Done    ;terminate display
        mov     ax, 4C00H       ;terminate function
        int     21H             ;execute

;--- errors

error1  mov     ax, OFFSET mes1 ;error message

error2  call    MesPutL         ;display message (note: global entry point)
        mov     ax, 4CFFH       ;terminate function
        int     21H             ;execute

;========================================
; Declarations.

;--- other SESSION modules.

        INCLUDE 'ansi.asm'
        INCLUDE 'beeps.asm'
        INCLUDE 'command.asm'
        INCLUDE 'debug.asm'
        INCLUDE 'macro.asm'
        INCLUDE 'options.asm'
        INCLUDE 'display.asm'
        INCLUDE 'terminal.asm'
        INCLUDE 'transfer.asm'

;--- initialized data

banner  DB      '* Session Version 1.02',13,10,0
mes1    DB      'Not enough memory',0

pacetime DW     9               ;1/2 second pacing for text uploads

;--- communication parameters, must be word value for OPTIONS.ASM

c_port  DW      1               ;port
c_party DW      PARITY_NONE     ;parity
c_data  DW      8               ;data bits
c_stop  DW      1               ;stop bits
c_speed DW      2400            ;speed

;--- attribute arrays

attr_bw  DB     M_ATTR_INP1, M_ATTR_CONF, M_ATTR_STAT, M_ATTR_TERM
         DB     M_ATTR_LOC, M_ATTR_REM, M_ATTR_LINE, M_ATTR_HELP
         DB     M_ATTR_ERROR, M_ATTR_MESS, M_ATTR_DEBUG

attr_col DB     C_ATTR_INP1, C_ATTR_CONF, C_ATTR_STAT, C_ATTR_TERM
         DB     C_ATTR_LOC, C_ATTR_REM, C_ATTR_LINE, C_ATTR_HELP
         DB     C_ATTR_ERROR, C_ATTR_MESS, C_ATTR_DEBUG

;========================================
; Uninitialized data.

srec    ORG     +SERIAL_RECORD  ;serial record

;=== colors

attr_start      LABEL   BYTE

attr_inp1       LABEL   BYTE
                ORG     +1
attr_conf       LABEL   BYTE
                ORG     +1
attr_stat       LABEL   BYTE
                ORG     +1
attr_term       LABEL   BYTE
                ORG     +1
attr_loc        LABEL   BYTE
                ORG     +1
attr_rem        LABEL   BYTE
                ORG     +1
attr_line       LABEL   BYTE
                ORG     +1
attr_help       LABEL   BYTE
                ORG     +1
attr_error      LABEL   BYTE
                ORG     +1
attr_mess       LABEL   BYTE
                ORG     +1
attr_debug      LABEL   BYTE
                ORG     +1
 
;=== ANSI.ASM

a_MAX   EQU     10 + 1  ;maximum ANSI arguments (need one extra)

a_tab   LABEL   BYTE    ;ANSI sequence argument table
        ORG     +a_MAX

a_cnt   LABEL   WORD
        ORG     +2      ;number of arguments defined

;=== COMMAND.ASM

c_sav1  LABEL   WORD    ;saved cursor location
        ORG     +2
c_sav2  LABEL   BYTE    ;saved cursor state
        ORG     +1

s_sav   LABEL   WORD    ;screen save location
        ORG     +2
s_loc1  LABEL   WORD    ;upper left location
        ORG     +2
s_loc2  LABEL   WORD    ;lower right location
        ORG     +2

;=== DISPLAY.ASM

cols    LABEL   BYTE    ;screen columns
        ORG     +1
rows    LABEL   BYTE    ;screen rows
        ORG     +1
sattr   LABEL   BYTE    ;save attribute
        ORG     +1

window1 LABEL   BYTE    ;terminal window
        ORG     +W_SIZE
window2 LABEL   BYTE    ;local input window
        ORG     +W_SIZE
window3 LABEL   BYTE    ;remote input window
        ORG     +W_SIZE

loc_win LABEL   WORD    ;pointer to local window
        ORG     +2
rem_win LABEL   WORD    ;pointer to remote window
        ORG     +2
s_col   LABEL   BYTE    ;cursor column
        ORG     +1
;s_row  LABEL   BYTE    ;cursor row (loaded as word with s_col)
        ORG     +1
s_seg   LABEL   WORD    ;save data segment
        ORG     +2

;=== TERMINAL.ASM

t_ser   LABEL   WORD    ;terminal serial record address
        ORG     +2
t_cbyt  LABEL   BYTE    ;remote byte for terminal
        ORG     +1
t_kbyt  LABEL   WORD    ;local byte for terminal (actually keystroke word)
        ORG     +2

;=== TRANSFER.ASM

t_rec   ORG     +BUFFER_RECORD  ;text buffer record (TRANSFER.ASM)

t_cur   LABEL   WORD    ;current characters in write line
        ORG     +2
t_lin   LABEL   DWORD   ;write line buffer address
        ORG     +4
x_prom  LABEL   WORD    ;xmodem upload/download prompt
        ORG     +2
