;********************************;
; WASM TSR Support, Installation ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   Keep  install TSR            ;
;********************************;

;========================================
; Macro to install a TSR.
;
; In: endloc= ending offset of TSR
;    (TSR_END is used if not specified).

Keep    MACRO   endloc

;--- release environment

        IF TYPE(endloc)=TYPE(ax)
        push    ax
        ENDIF
        mov     ah, 49H                 ;release memory function
        mov     es, [002CH]             ;load segment
        int     21H                     ;execute
        IF TYPE(endloc)=TYPE(ax)
        pop     ax
        ENDIF

;--- install

  IF TYPE(endloc)=TYPE(ax)
        mov     dx, ax
  ELSEIF TYPE(endloc)=TYPE(dx)
    IF VALUE(endloc)=VALUE(dx)
        mov     ax, dx
    ELSE
        mov     ax, endloc
        mov     dx, ax
    ENDIF
  ELSE
    IF TYPE(endloc)=TYPE()
        mov     ax, OFFSET TSR_END
    ELSE
        mov     ax, OFFSET endloc
    ENDIF
        mov     dx, ax
  ENDIF
        mov     cl, 4                   ;bits to shift
        shr     dx, cl                  ;convert to paragraph
        test    al, 0FH                 ;check if round up
        jz      _keep1                  ;skip if not
        inc     dx                      ;round up
_keep1  mov     ax, 3100H               ;terminate and remain resident
        int     21H                     ;execute
        ENDM
