;*******************************;
; WASM Buffered File I/O, Input ;
; By Eric Tauck                 ;
;                               ;
; Defines:                      ;
;                               ;
;   GetByt  read a byte         ;
;   BufGet  read a buffer       ;
;                               ;
; Requires:                     ;
;                               ;
;   BUFFER1.ASM                 ;
;   FILE.ASM                    ;
;*******************************;

        jmps    _buffer2_end

;========================================
; Read a byte from a buffer.
;
; In: BX= buffer record address.
;
; Out: AL= byte or DOS error code; CY=
;      set if error

GetByt  PROC    NEAR

;--- read a byte from the buffer

        sub     WORD [bx + _BUFFER_BYTES], 1    ;decrement bytes in buffer
        jc      _gtbyt1                         ;jump if zero

        inc     WORD [bx + _BUFFER_CURRENT]     ;increment pointer
        push    bx
        push    ds
        lds     bx, [bx + _BUFFER_CURRENT]      ;load buffer location
        mov     al, [bx - 1]                    ;load byte from buffer
        pop     ds
        pop     bx

        clc
        ret

;--- buffer must be filled first

_gtbyt1 call    BufGet          ;read buffer
        jnc     GetByt          ;loop back if no error
        ret
        ENDP

;========================================
; Read as many bytes as possible into
; buffer.
;
; In: BX= buffer record address.
;
; Out: AL= DOS error code; CY= set if
;      error.

BufGet  PROC    NEAR
        push    bx
        mov     dx, [bx + _BUFFER_CURRENT + 2]  ;segment of buffer
        mov     ax, [bx + _BUFFER_BASE]         ;buffer base
        mov     [bx + _BUFFER_CURRENT], ax      ;reset pointer
        mov     cx, [bx + _BUFFER_SIZE]         ;size of buffer
        mov     bx, [bx + _BUFFER_HANDLE]       ;file handle
        call    FilRea                          ;read from file
        pop     bx
        jnc     _bfget1                         ;jump if no error
        or      al, al                          ;check if really error
        jnz     _bfget2                         ;jump if really error
        or      cx, cx                          ;check if any bytes read
        jz      _bfget2

_bfget1 mov     [bx + _BUFFER_BYTES], cx        ;save bytes read
        clc
        ret

_bfget2 mov     WORD [bx + _BUFFER_BYTES], 0    ;zero bytes in buffer
        stc
        ret
        ENDP

_buffer2_end
