/* arm.v4a-linux.elf-so_fold.h
   created from arm.v4a-linux.elf-so_fold.bin, 34341 (0x8625) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_SIZE    34341
#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_ADLER32 0x9ebb87d9
#define STUB_ARM_V4A_LINUX_ELF_SO_FOLD_CRC32   0x1264415b

unsigned char stub_arm_v4a_linux_elf_so_fold[34341] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  76, 35,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  38,  0, 35,  0,  0,240,255,255,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0040 */  35,  0,  0,234, 24,  0, 31,229, 14,240,160,225, 32, 16, 79,226,
/* 0x0050 */   4,  0,145,229,  0,  0, 80,227,  9,  0,  0, 10,  1,  0,128,224,
/* 0x0060 */  14,240,160,225, 56,192, 31,229, 12,192,192,225, 12,  0, 64,224,
/* 0x0070 */  12, 16,129,224,254,255,255,234, 76,192, 31,229, 12,192,192,225,
/* 0x0080 */  12,  0, 64,224, 12, 16,129,224,254,255,255,234, 96,192, 31,229,
/* 0x0090 */  12,192,192,225, 12,  0, 64,224, 12, 16,129,224,254,255,255,234,
/* 0x00a0 */ 116,192, 31,229, 12,192,192,225, 12,  0, 64,224, 12, 16,129,224,
/* 0x00b0 */   7,  0, 45,233,  0, 16,129,224,  0, 32,160,227,  2,  0, 15,239,
/* 0x00c0 */   7,  0,189,232,254,255,255,234,  2,220, 77,226, 13, 32,160,225,
/* 0x00d0 */ 254,255,255,235,  2,220,141,226,  0,224,160,225,  7,  0,189,232,
/* 0x00e0 */  91,112,160,227, 14,240,160,225, 15,  0,160,225, 14,240,160,225,
/* 0x00f0 */   0,112,160,227,  0,192,160,227,  4,240, 18,229,  0,  0, 82,227,
/* 0x0100 */   8,  0,  0, 10,  0,192,160,225,  1, 48,209,228,  1, 32, 82,226,
/* 0x0110 */   1, 48,192,228,  4,  0,  0, 26, 12,  0,160,225, 14,240,160,225,
/* 0x0120 */   0,  0, 82,227, 16,  0,  0, 10,  0,192,160,225,  1, 16,192,228,
/* 0x0130 */   1, 32, 82,226, 13,  0,  0, 26, 12,  0,160,225, 14,240,160,225,
/* 0x0140 */   0,  0, 82,227, 24,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,
/* 0x0150 */   1, 48,192,228, 20,  0,  0, 26, 14,240,160,225,254,255,255,234,
/* 0x0160 */ 129,  1,  0,239, 14,240,160,225,  6,  0,  0,239, 14,240,160,225,
/* 0x0170 */   1,  0,  0,239, 14,240,160,225,148,  0,  0,239, 14,240,160,225,
/* 0x0180 */ 118,  0,  0,239, 14,240,160,225, 93,  0,  0,239, 14,240,160,225,
/* 0x0190 */  20,  0,  0,239, 14,240,160,225, 19,  0,  0,239, 14,240,160,225,
/* 0x01a0 */  39,  0,  0,239, 14,240,160,225,125,  0,  0,239, 14,240,160,225,
/* 0x01b0 */ 144,  0,  0,239, 14,240,160,225, 91,  0,  0,239, 14,240,160,225,
/* 0x01c0 */   5,  0,  0,239, 14,240,160,225,  3,  0,  0,239, 14,240,160,225,
/* 0x01d0 */ 106,  0,  0,239, 14,240,160,225,122,  0,  0,239, 14,240,160,225,
/* 0x01e0 */  10,  0,  0,239, 14,240,160,225,  4,  0,  0,239, 14,240,160,225,
/* 0x01f0 */ 240,  1,240,231, 14,240,160,225, 48, 64, 45,233, 16, 80,157,229,
/* 0x0200 */  12, 64,157,229, 37, 86,160,225,  0,192,224,227, 12,198,160,225,
/* 0x0210 */  12,192,192,225, 12,  0, 64,224, 12, 16,129,224,192,  0,  0,239,
/* 0x0220 */  48,128,189,232,  2, 64, 64,  0,192,  1,  0,  0, 47,100,101,118,
/* 0x0230 */  47,115,104,109,  0,  0,  0,  0,240,  1,240,231, 32,  0, 79,226,
/* 0x0240 */   6,  0,176,232,  5,  0,  0,239, 14,240,160,225,240,  1,240,231,
/* 0x0250 */ 160,  0, 31,229, 14,240,160,225, 48, 64, 45,233, 34, 64,160,227,
/* 0x0260 */   0, 80,160,227,  4, 48,131,225,  0, 64,224,227, 68,  0,  0,234,
/* 0x0270 */ 255, 64, 45,233,240,  0,189,232, 13,  0,160,225,  6,112,213,225,
/* 0x0280 */ 106,  0,  0, 10,  7, 48, 77,224,  7,208,195,227,  4,  0, 45,229,
/* 0x0290 */   7, 32,160,225,  6, 16,  5,224,  4,  0,141,226,254,255,255,235,
/* 0x02a0 */   6,  0,  5,224,  7, 16,132,224,  3, 32,160,227, 16, 48,160,227,
/* 0x02b0 */ 254,255,255,235,  0, 80,160,225,  0,  0, 87,227,119,  0,  0, 10,
/* 0x02c0 */   5,  0,160,225,  4, 16,141,226,  7, 32,160,225,254,255,255,235,
/* 0x02d0 */   0,208,157,229,  5,  0,160,225,240,128,189,232,  0,  0, 77,224,
/* 0x02e0 */   7,  0,192,227,  0,208,160,225, 14,240,160,225,  0,192,160,225,
/* 0x02f0 */   1, 16, 65,224,  0, 32,160,225,128,  1,144,224,129, 17,161,224,
/* 0x0300 */ 162, 30,129,224,  0, 32,160,225,  0,  2,144,224,  1, 18,161,224,
/* 0x0310 */  34, 30,129,224,  0, 32,160,225,  0,  4,144,224,  1, 20,161,224,
/* 0x0320 */  34, 28,129,224,  0, 32,160,225,  0,  8,144,224,  1, 24,161,224,
/* 0x0330 */  34, 24,129,224,140, 15, 80,224,172, 16,193,224, 12,  0,144,224,
/* 0x0340 */   0,  0,161,226, 14,240,160,225,254,255,255,234,254,255,255,234,
/* 0x0350 */  63, 32,  0,226, 31, 48,  0,226, 26,  0, 83,227,  5,  0,  0,154,
/* 0x0360 */  32,  0, 16,227, 70, 32, 66, 18, 43, 32, 66,  2, 64,  0,130,226,
/* 0x0370 */  30,255, 47,225,  2,192,160,225, 17,  0,  0,234,  0, 32,208,229,
/* 0x0380 */  32, 32,130,227,  0, 48,209,229, 32, 48,131,227,  3, 32, 82,224,
/* 0x0390 */  21,  0,  0, 26,  1,  0,128,226,  1, 16,129,226,  1,192, 76,226,
/* 0x03a0 */   1,  0,124,227,  9,  0,  0, 26,  0, 32,160,227,  2,  0,160,225,
/* 0x03b0 */  30,255, 47,225,112, 64, 45,233, 64,208, 77,226,  0, 80,160,225,
/* 0x03c0 */   1, 96,160,225, 13,  0,160,225,255, 16,160,227, 64, 32,160,227,
/* 0x03d0 */ 254,255,255,235,  5,  0,160,225, 13, 16,160,225,254,255,255,235,
/* 0x03e0 */   0, 64, 80,226, 41,  0,  0,186,184, 48,221,225, 15, 58,  3,226,
/* 0x03f0 */   1,  9, 83,227,  0, 64,160,  3, 53,  0,  0,234,  2,  0,116,227,
/* 0x0400 */  47,  0,  0, 26,  5,  0,160,225,  7, 29,160,227,254,255,255,235,
/* 0x0410 */   0, 64,160,225,  0, 48, 86,226,  1, 48,160, 19,164, 63, 19,224,
/* 0x0420 */   5,  0,160, 17,  4, 16,160, 17,254,255,255, 27,  4,  0,160,225,
/* 0x0430 */  64,208,141,226,112,128,189,232,240, 65, 45,233,  0,112,160,225,
/* 0x0440 */   1, 96,160,225, 63,  0,  0,235, 47,100, 97,116, 97, 47,100, 97,
/* 0x0450 */ 116, 97, 47,  0, 14, 16,160,225, 11, 32,160,227,254,255,255,235,
/* 0x0460 */   0, 64,160,227,  0, 64,192,229,  7,  0,160,225,  1, 16,160,227,
/* 0x0470 */  23,  0,  0,235, 77,  0,  0,235, 47,112,114,111, 99, 47,115,101,
/* 0x0480 */ 108,102, 47, 99,109,100,108,105,110,101,  0,  0, 14,128,160,225,
/* 0x0490 */   8,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x04a0 */   0, 64,160,225,  6, 16,160,225,255, 46,160,227, 15, 32,130,226,
/* 0x04b0 */ 254,255,255,235,  0, 80,160,225,  4,  0,160,225,254,255,255,235,
/* 0x04c0 */   0,  0, 85,227,  8,  0,160,177,254,255,255,187,  0, 48,160,227,
/* 0x04d0 */   5, 48,198,231,  0, 48,214,229,  0,  0, 83,227,  6, 16,160,  1,
/* 0x04e0 */ 139,  0,  0, 10,  6, 16,160,225,  1, 48,241,229,  0,  0, 83,227,
/* 0x04f0 */ 100,  0,  0, 26,139,  0,  0,234,  1, 48,116,229, 47,  0, 83,227,
/* 0x0500 */ 104,  0,  0, 26,  1,128,100,224, 10,  0,135,226,  4, 16,160,225,
/* 0x0510 */   8, 32,160,225,254,255,255,235,  0, 80,160,225,  0, 96,160,227,
/* 0x0520 */   0, 96,192,229,  7,  0,160,225,  6, 16,160,225, 23,  0,  0,235,
/* 0x0530 */  13,  0,112,227,141,  0,  0, 26,126,  0,  0,235, 99,111,109, 46,
/* 0x0540 */ 116,101,114,109,117,120, 47,102,105,108,101,115,  0,  0,  0,  0,
/* 0x0550 */  14, 16,160,225, 11,  0,135,226, 16, 32,160,227,254,255,255,235,
/* 0x0560 */   4, 16,160,225,  8, 32,160,225,254,255,255,235,  0, 80,160,225,
/* 0x0570 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x0580 */ 141,  0,  0,234,  1, 64,160,225,104,  0,  0,234,144,  0,  0,235,
/* 0x0590 */  47, 99, 97, 99,104,101,  0,  0, 14, 16,160,225,  5,  0,160,225,
/* 0x05a0 */   6, 32,160,227,254,255,255,235,  0, 64,160,225,  0, 96,160,227,
/* 0x05b0 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x05c0 */ 157,  0,  0,235, 47,117,112,120,  0,  0,  0,  0, 14, 16,160,225,
/* 0x05d0 */   4,  0,160,225,  4, 32,160,227,254,255,255,235,  0, 64,160,225,
/* 0x05e0 */ 254,255,255,235,  0, 80,160,225,254,255,255,235,  0,  0,196,229,
/* 0x05f0 */  37,  3,160,225,254,255,255,235,  1,  0,196,229, 37,  6,160,225,
/* 0x0600 */ 254,255,255,235,  2,  0,196,229,  3, 96,196,229,  6,  0,160,225,
/* 0x0610 */ 240,129,189,232,240, 65, 45,233,  1,218, 77,226, 12,208, 77,226,
/* 0x0620 */   0,112,160,225,  1,128,160,225,  2, 96,160,225,183,  0,  0,235,
/* 0x0630 */ 117,112,120,  0, 14, 64,160,225,  4,  0,160,225, 16, 16,160,227,
/* 0x0640 */ 254,255,255,235,  0, 80,160,225, 22,  0,112,227,194,  0,  0, 26,
/* 0x0650 */   4,  0,160,225,  0, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0660 */   0,  0, 85,227,215,  0,  0,170,200,  0,  0,235, 47,100,101,118,
/* 0x0670 */  47,115,104,109,  0,  0,  0,  0, 14,  0,160,225,  1, 25,160,227,
/* 0x0680 */   2, 16,129,226,  1, 21,129,227,  7, 45,160,227,254,255,255,235,
/* 0x0690 */   0, 80, 80,226,215,  0,  0,170,213,  0,  0,235,109,101,109,102,
/* 0x06a0 */ 100, 95, 99,114,101, 97,116,101,  0,  0,  0,  0, 14,  0,160,225,
/* 0x06b0 */ 254,255,255,235, 12, 64,141,226,  4,  0,160,225,254,255,255,235,
/* 0x06c0 */ 220,  0,  0,235, 97,110,100,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x06d0 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 10,
/* 0x06e0 */ 228,  0,  0,235, 76,105,110,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x06f0 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 26,
/* 0x0700 */ 130, 48,212,229, 52,  0, 83,227,  1, 64,160,131, 16,  1,  0,138,
/* 0x0710 */   0,  0, 86,227,247,  0,  0, 26,254,255,255,235,  0, 96, 80,226,
/* 0x0720 */   2, 49,160,  3,  1, 42,141,  2, 12, 32,130,  2,195,105,194,  7,
/* 0x0730 */  12, 96,141,  2, 38,  0,117,227, 15,  1,  0, 26,  0,  0, 86,227,
/* 0x0740 */  15,  1,  0, 10,  0, 48,214,229,  0,  0, 83,227,  4,  1,  0, 26,
/* 0x0750 */   6,  0,160,225,  2, 27,141,226, 12, 16,129,226, 56,  0,  0,235,
/* 0x0760 */   0,  0, 80,227, 76,  1,  0,186,  6,  0,160,225,194, 16,160,227,
/* 0x0770 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226,  5,  0,160,177,
/* 0x0780 */  76,  1,  0,186,  6,  0,160,225,254,255,255,235,  0, 64,160,227,
/* 0x0790 */  16,  1,  0,234,  0, 64,160,227,  0,  0, 87,227, 23,  1,  0, 10,
/* 0x07a0 */ 254,255,255,235,  0,  0,224,225,  7,  0,  0,224,  7,112, 96,224,
/* 0x07b0 */   0,128,136,224,  0,  0, 88,227, 50,  1,  0, 10,  0,  0, 84,227,
/* 0x07c0 */  33,  1,  0, 10,  5,  0,160,225,  8, 16,160,225,254,255,255,235,
/* 0x07d0 */   0,  0, 80,227, 50,  1,  0,170, 76,  1,  0,234,  5,  0,160,225,
/* 0x07e0 */   1, 16, 72,226,  0, 32,160,227,254,255,255,235,  1, 26,224,227,
/* 0x07f0 */   0, 64,160,227,  1, 58,141,226, 12, 48,131,226,  1, 64,195,231,
/* 0x0800 */   5,  0,160,225,  1, 16,131,224,  1, 32,160,227,254,255,255,235,
/* 0x0810 */   5,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x0820 */   0,  0, 87,227,  1,192,160,  3, 62,  1,  0, 10,254,255,255,235,
/* 0x0830 */   0, 32,160,225,  0, 48,215,225, 74,  1,  0, 10,  5,  0,160,225,
/* 0x0840 */   7, 16,160,225,  0, 32, 98,226,254,255,255,235, 74,  1,  0,234,
/* 0x0850 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x0860 */   8, 16,160,225,  3, 32,160,227, 12, 48,160,225,254,255,255,235,
/* 0x0870 */   1, 10,112,227,  1, 48,133,146,  3,  0,128,145, 76,  1,  0,234,
/* 0x0880 */  17,192,160,227, 62,  1,  0,234, 12,208,141,226,  1,218,141,226,
/* 0x0890 */ 240,129,189,232,240, 64, 45,233,  8,208, 77,226,  0,112,160,225,
/* 0x08a0 */   1, 96,160,225,  4,  0,  0,235,117,112,120,  0, 14, 64,160,225,
/* 0x08b0 */   4,  0,160,225, 16, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x08c0 */  22,  0,112,227, 15,  0,  0, 26,  4,  0,160,225,  0, 16,160,227,
/* 0x08d0 */ 254,255,255,235,  0, 80,160,225,  0,  0, 85,227, 55,  0,  0,170,
/* 0x08e0 */  21,  0,  0,235, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x08f0 */  14,  0,160,225,  1, 25,160,227,  2, 16,129,226,  1, 21,129,227,
/* 0x0900 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226, 55,  0,  0,170,
/* 0x0910 */  21,  0,117,227,  5, 64,160, 17, 76,  0,  0, 26, 49,  0,  0,235,
/* 0x0920 */  85, 80, 88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,
/* 0x0930 */ 109,102,100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114,
/* 0x0940 */  32,110,101,101,100,115, 32, 47,100,101,118, 47,115,104,109, 40,
/* 0x0950 */  44, 79, 95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0,  0,  0,
/* 0x0960 */  14, 16,160,225,  2,  0,160,227, 61, 32,160,227,254,255,255,235,
/* 0x0970 */ 127,  0,160,227,254,255,255,235,  5,  0,160,225,  6, 16,160,225,
/* 0x0980 */ 254,255,255,235,  0,  0, 80,227,  0, 64,160,177, 76,  0,  0,186,
/* 0x0990 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x09a0 */   6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,  1, 48,160,  3,
/* 0x09b0 */  17, 48,160, 19,254,255,255,235,  0, 64,160,225,254,255,255,235,
/* 0x09c0 */   4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,  4,  0,160,225,
/* 0x09d0 */   8,208,141,226,240,128,189,232,255, 48,  3,226,  1, 48,195,227,
/* 0x09e0 */  80,  0, 83,227, 14,240,160, 17, 33, 17,176,225,  0,  0, 80, 19,
/* 0x09f0 */  14,240,160,  1,  1, 16, 65,226,  1, 33,144,231, 15, 52,  2,226,
/* 0x0a00 */  11,  4, 83,227, 15,  0,  0, 26,255, 52,  2,226,  1, 32, 66,224,
/* 0x0a10 */ 255, 36,194,227,  3, 32,130,225,  1, 33,128,231,  0,  0, 81,227,
/* 0x0a20 */   5,  0,  0, 26, 14,240,160,225,  0, 32,160,225,  0,  0,208,229,
/* 0x0a30 */   1, 16,210,229,  1,  4,128,225,  2, 16,210,229,  1,  8,128,225,
/* 0x0a40 */   3, 16,210,229,  1, 12,128,225, 14,240,160,225,255, 64, 45,233,
/* 0x0a50 */   8, 64,208,229,  0, 80,160,225,  8, 48,157,229,  4,  0,133,226,
/* 0x0a60 */  18,  0,  0,235,  0, 16,160,225,  4, 32,157,229, 12,  0,133,226,
/* 0x0a70 */  53,  0,  0,235,  0, 48,157,229, 10, 32,211,229,  9, 48,211,229,
/* 0x0a80 */   3,  0, 19,225, 46,  0,  0, 10,  4,  0,157,229,  8, 16,157,229,
/* 0x0a90 */   0, 16,145,229,254,255,255,235,  8, 16,157,229,  4,  0,157,229,
/* 0x0aa0 */   0, 16,145,229,  0, 16,129,224,  0,  0,160,227,  0,  0,141,229,
/* 0x0ab0 */ 255,128,189,232,  8,  0,189,232,  0,  0,160,225,  3,  0, 80,224,
/* 0x0ac0 */   3,  0,  0, 10,240,  1,240,231,  8,  0,189,232,  2,  0,189,232,
/* 0x0ad0 */   3, 32, 66,224,  8,  0,189,232,  0, 32,131,229, 14,240,160,225,
/* 0x0ae0 */   9,  0, 84,227, 69,  0,  0, 26,252, 64, 45,233,  0,112,129,224,
/* 0x0af0 */   0, 80,224,227,  2, 65,160,227, 16,  0,  0,234, 24,  0,189,232,
/* 0x0b00 */   7,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,240,128,189,232,
/* 0x0b10 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x0b20 */   1, 48,208,228,  1, 48,194,228,  4, 64,148,224, 10,  0,  0, 11,
/* 0x0b30 */  14,  0,  0, 42,  1, 16,160,227, 25,  0,  0,234,  1, 16, 65,226,
/* 0x0b40 */   4, 64,148,224, 10,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x0b50 */  10,  0,  0, 11,  1, 16,161,224,  4, 64,148,224, 10,  0,  0, 11,
/* 0x0b60 */  21,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227, 41,  0,  0, 58,
/* 0x0b70 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  5,  0,  0, 10,
/* 0x0b80 */ 197, 80,176,225, 56,  0,  0, 42, 44,  0,  0,234,  4, 64,148,224,
/* 0x0b90 */  10,  0,  0, 11, 56,  0,  0, 42,  1, 16,160,227,  4, 64,148,224,
/* 0x0ba0 */  10,  0,  0, 11, 56,  0,  0, 42,  4, 64,148,224, 10,  0,  0, 11,
/* 0x0bb0 */   1, 16,161,224,  4, 64,148,224, 10,  0,  0, 11, 48,  0,  0, 58,
/* 0x0bc0 */   4, 16,129,226, 60,  0,  0,234,  4, 64,148,224, 10,  0,  0, 11,
/* 0x0bd0 */   1, 16,161,224,  2, 16,129,226,  5, 12,117,227,  1, 16,129, 50,
/* 0x0be0 */   1, 48,130,224,  1, 48, 83,229,  5, 48,210,231,  1, 48,194,228,
/* 0x0bf0 */   1, 16, 81,226, 64,  0,  0, 26, 16,  0,  0,234,  6,  0, 84,227,
/* 0x0c00 */  64,  0,  0, 26,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0c10 */   2, 65,160,227, 16,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x0c20 */   3, 32, 66,224,  0, 32,132,229,240,128,189,232,  1, 64,208,228,
/* 0x0c30 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 48,208,228,
/* 0x0c40 */   1, 48,194,228,  4, 64,148,224, 10,  0,  0, 11, 14,  0,  0, 42,
/* 0x0c50 */   1, 16,160,227, 25,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,
/* 0x0c60 */  10,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 10,  0,  0, 11,
/* 0x0c70 */   1, 16,177,224,  4, 64,148,224, 10,  0,  0, 11, 21,  0,  0, 58,
/* 0x0c80 */   3, 48, 81,226,  0, 16,160,227, 40,  0,  0, 58,  1, 80,208,228,
/* 0x0c90 */   3, 84,133,225,  5, 80,240,225,  5,  0,  0, 10,197, 80,176,225,
/* 0x0ca0 */  42,  0,  0,234,  4, 64,148,224, 10,  0,  0, 11,  1, 16,177,224,
/* 0x0cb0 */   4, 64,148,224, 10,  0,  0, 11,  1, 16,177,224, 55,  0,  0, 26,
/* 0x0cc0 */   1, 16,160,227,  4, 64,148,224, 10,  0,  0, 11,  1, 16,177,224,
/* 0x0cd0 */   4, 64,148,224, 10,  0,  0, 11, 48,  0,  0, 58,  2, 16,129,226,
/* 0x0ce0 */   1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,  0, 48,210,229,
/* 0x0cf0 */   5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 59,  0,  0, 26,
/* 0x0d00 */  16,  0,  0,234,  3,  0, 84,227, 49,  0,  0, 26,  0, 16,129,224,
/* 0x0d10 */  62, 64, 45,233,  0, 80,224,227,  2, 65,160,227, 25,  0,  0,234,
/* 0x0d20 */  26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,
/* 0x0d30 */  48,128,189,232,  4, 64,148,224, 14,240,160, 17,  1, 64,208,228,
/* 0x0d40 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 16,160,227,
/* 0x0d50 */  14,192,160,225, 10,  0,  0,235,  1, 16,177,224, 10,  0,  0,235,
/* 0x0d60 */  18,  0,  0, 58, 12,240,160,225,  1, 48,208,228,  1, 48,194,228,
/* 0x0d70 */  10,  0,  0,235, 23,  0,  0, 42, 16,  0,  0,235,  3, 48, 81,226,
/* 0x0d80 */   0, 16,160,227, 35,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,
/* 0x0d90 */   5, 80,240,225,  5,  0,  0, 10, 10,  0,  0,235,  1, 16,177,224,
/* 0x0da0 */  10,  0,  0,235,  1, 16,177,224, 42,  0,  0, 26, 16,  0,  0,235,
/* 0x0db0 */   2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,
/* 0x0dc0 */   1, 16, 81,226,  1, 48,194,228, 44,  0,  0, 42, 25,  0,  0,234,
/* 0x0dd0 */  14,  0, 84,227,254,255,255, 26,  4,224, 45,229,  3,  0,  0,235,
/* 0x0de0 */  64,  4,  2,  6,  1,  5,  3,  7,  0,  0,  0,  0, 14, 48,160,225,
/* 0x0df0 */  24, 32,144,229,  7, 32,  2,226,  2,  0,211,231,  7,  0,  0,226,
/* 0x0e00 */   4,240,157,228,  4,224, 45,229,254,255,255,235,127,  0,160,227,
/* 0x0e10 */ 254,255,255,235,240, 64, 45,233,  0, 80,160,225,  1,112,160,225,
/* 0x0e20 */   2, 96,160,225, 24,  0,144,232,  2,  0, 83,225,  8,  0,160, 51,
/* 0x0e30 */   9,  0,  0, 59,  1, 48, 70,226,  1,  0,115,227, 32,  0,  0, 10,
/* 0x0e40 */   7, 16,160,225,  0, 32,160,227,  1,  0,131,226,  4, 48,210,231,
/* 0x0e50 */   1, 48,193,228,  1, 32,130,226,  0,  0, 82,225, 27,  0,  0, 26,
/* 0x0e60 */   4, 48,149,229,  6, 48,131,224,  4, 48,133,229,  0, 48,149,229,
/* 0x0e70 */   3, 48,102,224,  0, 48,133,229,240,128,189,232, 48, 64, 45,233,
/* 0x0e80 */  16,208, 77,226,  0, 80,160,225,  1, 64,160,225,  0, 48,145,229,
/* 0x0e90 */   0,  0, 83,227,117,  0,  0, 10,  5,  0,160,225, 13, 16,160,225,
/* 0x0ea0 */  12, 32,160,227, 13,  0,  0,235,  0, 48,157,229,  0,  0, 83,227,
/* 0x0eb0 */  64,  0,  0, 26,  4, 32,157,229,252, 48,159,229,  3,  0, 82,225,
/* 0x0ec0 */   2,  0,160, 19,  9,  0,  0, 27,  0, 48,149,229,  0,  0, 83,227,
/* 0x0ed0 */ 117,  0,  0, 10,  3,  0,160,227,  9,  0,  0,235,117,  0,  0,234,
/* 0x0ee0 */   4, 48,157,229,  0,  0, 83,227,  4,  0,160,  3,  9,  0,  0, 11,
/* 0x0ef0 */  12,  0,157,232,  2,  0, 83,225, 74,  0,  0,138,  0, 48,148,229,
/* 0x0f00 */   3,  0, 82,225, 76,  0,  0,154,  5,  0,160,227,  9,  0,  0,235,
/* 0x0f10 */  10,  0,157,232,  1,  0, 83,225,101,  0,  0, 42, 16, 32,141,226,
/* 0x0f20 */   4, 16, 34,229,  4,  0,149,229, 12,  0, 64,226,  4, 16,148,229,
/* 0x0f30 */ 254,255,255,235,  0,  0, 80,227, 91,  0,  0, 26,  0, 32,157,229,
/* 0x0f40 */  12, 48,157,229,  3,  0, 82,225, 93,  0,  0, 10,  7,  0,160,227,
/* 0x0f50 */   9,  0,  0,235,  4, 48,149,229,  4, 32,157,229,  2, 48,131,224,
/* 0x0f60 */   4, 48,133,229,  0, 48,149,229,  3, 48, 98,224,  0, 48,133,229,
/* 0x0f70 */ 108,  0,  0,234,  0, 48,149,229, 12, 48,131,226,  0, 48,133,229,
/* 0x0f80 */   5,  0,160,225,  4, 16,148,229,  4, 32,157,229, 13,  0,  0,235,
/* 0x0f90 */   4, 48,148,229,  0, 32,157,229,  2, 48,131,224,  4, 48,132,229,
/* 0x0fa0 */   0, 48,148,229,  3, 48, 98,224,  0, 48,132,229,  0,  0, 83,227,
/* 0x0fb0 */  46,  0,  0, 26, 16,208,141,226, 48,128,189,232, 85, 80, 88, 33,
/* 0x0fc0 */ 240, 65, 45,233,  1,217, 77,226,  4,208, 77,226,  0,112,160,225,
/* 0x0fd0 */   1, 96,160,225,  2, 64,  1,224,  1, 80,100,224,  5,128,160,225,
/* 0x0fe0 */   0,  0, 85,227,  4,  0,141, 18,  4, 16,160, 17,  5, 32,160, 17,
/* 0x0ff0 */ 254,255,255, 27,  4,  0,160,225,  7, 16,133,224,  0, 32,160,227,
/* 0x1000 */ 254,255,255,235,255, 62,160,227, 15, 48,131,226,  3, 32,  0,224,
/* 0x1010 */   3, 16,192,225,  1,112, 66,226,  1,  0, 84,225,150,  0,  0, 10,
/* 0x1020 */   0, 80,141,229, 73, 13,160,227, 34,  0,128,226,  4, 32,160,225,
/* 0x1030 */   6, 48,160,225,254,255,255,235,  0,  0, 88,227,  7,  0,160, 17,
/* 0x1040 */   4, 16,141, 18,  5, 32,160, 17,254,255,255, 27,  7,  0,160,225,
/* 0x1050 */   4,208,141,226,  1,217,141,226,240,129,189,232,240, 64, 45,233,
/* 0x1060 */   8,208, 77,226,  0, 80,160,225,  1, 64,160,225,  2, 96,160,225,
/* 0x1070 */   3,112,160,225, 24, 48,146,229,  1,  0, 19,227,188,  0,  0, 10,
/* 0x1080 */   1,  0,160,225,  5, 16,160,225,  4, 32,160,227,254,255,255,235,
/* 0x1090 */   4,  0,160,225,  5, 16,160,225,254,255,255,235,  6,  0,160,225,
/* 0x10a0 */ 254,255,255,235,  0, 32,160,225,  0,112,141,229,  0, 48,160,227,
/* 0x10b0 */   4, 48,141,229,  4,  0,160,225,  5, 16,160,225, 18, 48,131,226,
/* 0x10c0 */ 254,255,255,235,  7,  0,160,225,254,255,255,235,198,  0,  0,234,
/* 0x10d0 */   8, 48,146,229, 28, 64,157,229,  3, 64,132,224, 20, 80,146,229,
/* 0x10e0 */   2,  0,160,225,254,255,255,235,  0, 32,160,225,  4,  0,160,225,
/* 0x10f0 */   5, 16,160,225,254,255,255,235,  0,  0,160,227,  8,208,141,226,
/* 0x1100 */ 240,128,189,232,240, 79, 45,233,100,208, 77,226,  0, 64,160,225,
/* 0x1110 */   1,144,160,225,  2, 96,160,225,254,255,255,235, 16,  0,141,229,
/* 0x1120 */   0, 48,148,229,  4,176, 99,224, 84,192,141,226, 15,  0,148,232,
/* 0x1130 */  15,  0,140,232, 92, 32,157,229, 20, 32,141,229,  3, 80,139,224,
/* 0x1140 */   4,160,101,224, 12, 16,141,229,  0, 48,224,227,  0, 48,141,229,
/* 0x1150 */   0, 64,160,227,  4, 64,141,229,  4,  0,160,225, 10, 16,160,225,
/* 0x1160 */   3, 32,160,227, 35, 48,131,226,254,255,255,235,  0,128,160,225,
/* 0x1170 */   5, 16,160,225, 10, 32,160,225,254,255,255,235, 24, 32,136,226,
/* 0x1180 */  24, 48,152,229, 76, 48,141,229, 80, 96,141,229,  4, 48,146,229,
/* 0x1190 */  12, 48,131,226, 68, 48,141,229, 72, 32,141,229, 68,  0,141,226,
/* 0x11a0 */  76, 16,141,226, 39,  0,  0,235, 52,112,134,226,188, 50,214,225,
/* 0x11b0 */ 131, 98,135,224,  6,  0, 87,225, 24, 64,141, 37,133,  1,  0, 42,
/* 0x11c0 */   0, 48,160,227, 24, 48,141,229, 28, 48,141,229, 32, 48,141,229,
/* 0x11d0 */  93, 21,224,227,159, 27, 65,226,  3, 28, 65,226,  8, 16,141,229,
/* 0x11e0 */   7, 80,160,225,  0, 48,151,229,  1,  0, 83,227,130,  1,  0, 26,
/* 0x11f0 */  24, 48,151,229,  2,  0, 19,227,130,  1,  0, 26, 28, 32,157,229,
/* 0x1200 */   0,  0, 82,227,  8, 48,151,  5, 11, 48, 99,  0, 28, 48,141,  5,
/* 0x1210 */  16, 64,151,229,  8, 48,151,229,  3, 64,132,224, 12, 32,160,227,
/* 0x1220 */  68, 32,141,229, 68,  0,141,226, 48, 16,141,226, 13,  0,  0,235,
/* 0x1230 */  72, 48,157,229, 12, 48, 67,226, 72, 48,141,229, 52, 48,157,229,
/* 0x1240 */  68, 48,141,229, 48,  0,157,229, 76,  0,141,229, 28, 48,157,229,
/* 0x1250 */   4, 64,131,224,  4, 16, 96,224, 80, 16,141,229, 16, 48,151,229,
/* 0x1260 */   4, 32,151,229,  2, 48,131,224, 20, 32,157,229,  3,  0, 82,225,
/* 0x1270 */  42,  1,  0, 58, 32, 48,157,229,  0,  0, 83,227,  1, 16,160,  3,
/* 0x1280 */  32, 16,141,  5,130,  1,  0, 10, 24, 48,149,229,  1,  0, 19,227,
/* 0x1290 */  49,  1,  0, 10, 16, 32,157,229,254,255,255,235, 36,  0,141,229,
/* 0x12a0 */  53,  1,  0,234, 16, 32,157,229,254,255,255,235,  0, 32,160,227,
/* 0x12b0 */  36, 32,141,229, 80, 48,157,229, 40, 48,141,229, 76, 16,157,229,
/* 0x12c0 */  44, 16,141,229, 68,  0,141,226, 76, 16,141,226, 39,  0,  0,235,
/* 0x12d0 */  24, 32,157,229,  0,  0, 82,227,127,  1,  0, 26, 24, 48,149,229,
/* 0x12e0 */   1,  0, 19,227,127,  1,  0, 10, 80, 64,157,229,254,255,255,235,
/* 0x12f0 */  60,  0,141,229,  8, 48,157,229, 64, 48,141,229,  0, 48,149,229,
/* 0x1300 */   1,  0, 83,227,118,  1,  0, 26, 24, 48,149,229,  1,  0, 19,227,
/* 0x1310 */ 118,  1,  0, 10, 20, 16,133,226, 10,  0, 17,232,  1, 48, 67,224,
/* 0x1320 */   3, 32,132,224,  0, 48, 98,226, 16, 16,157,229,  1, 48,195,225,
/* 0x1330 */   7,  0, 83,227, 92,  1,  0,154,  3, 48,130,226,  3, 80,195,227,
/* 0x1340 */   0,  0,133,229, 64, 48,157,229,  4, 48,133,229,119,  1,  0,234,
/* 0x1350 */   0,  0,160,227,  8, 16,160,227,  0, 32,160,225,254,255,255,235,
/* 0x1360 */   0, 80,160,225,255, 78,160,227, 15, 64,132,226,  4, 64,  0,224,
/* 0x1370 */   1, 64, 68,226,  4,  0,160,225, 60, 16,141,226,  8, 32,160,227,
/* 0x1380 */ 254,255,255,235,  0, 64,141,229,  0, 48,160,227,  4, 48,141,229,
/* 0x1390 */   2,  1,160,227,192,  9,  5,224,  8, 16,160,227,  5, 32,160,227,
/* 0x13a0 */   2, 48,131,226,254,255,255,235,  0, 80,160,225,  4,  0,160,225,
/* 0x13b0 */ 254,255,255,235,119,  1,  0,234,  0, 80,160,227, 24, 80,141,229,
/* 0x13c0 */  28, 32,157,229,  0, 32,141,229, 44,  0,157,229, 40, 16,157,229,
/* 0x13d0 */   7, 32,160,225, 36, 48,157,229,254,255,255,235, 32, 48,157,229,
/* 0x13e0 */   1, 48,131,226, 32, 48,141,229, 32,112,135,226,  7,  0, 86,225,
/* 0x13f0 */   0,  1,  0,138,  8,  0,160,225, 10, 16,160,225,254,255,255,235,
/* 0x1400 */  12, 16,157,229,  1, 48,139,224,  7,  0,153,232, 15,224,160,225,
/* 0x1410 */  19,255, 47,225, 24,  0,157,229,100,208,141,226,240,143,189,232,
/* 0x1420 */   0, 72, 45,233,  0,176,208,229,  6,204,160,227,171,177,160,225,
/* 0x1430 */  28,203,160,225, 13,176,160,225, 58,205,140,226, 12,208, 77,224,
/* 0x1440 */   0,192,147,229,  8, 48,141,229,  4,192,141,229,  0, 32,141,229,
/* 0x1450 */  12, 48,141,226,  0,192,160,227,  4,192,131,228, 11,  0, 83,225,
/* 0x1460 */  12,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,  0, 16,160,225,
/* 0x1470 */   1,192,209,228,  7,192, 12,226, 18,192,205,229,  1,192,209,228,
/* 0x1480 */  44,  2,160,225, 17,  0,205,229, 15,192, 12,226, 16,192,205,229,
/* 0x1490 */  16,  0,141,226, 30,  0,  0,235, 11,208,160,225,  0,136,189,232,
/* 0x14a0 */ 240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,  0, 48,208,229,
/* 0x14b0 */   2, 80,208,229,  1,224,208,229,  0,192,157,229, 20, 48,141,229,
/* 0x14c0 */  92, 48,157,229,  0, 64,160,227,  0, 64,140,229,  0, 64,131,229,
/* 0x14d0 */  20,192,157,229,  1, 48,208,229,  3, 48,140,224,  3,204,160,227,
/* 0x14e0 */  28,195,160,225,  1, 48,160,227, 19,238,160,225, 19, 53,160,225,
/* 0x14f0 */ 115,206,140,226,  1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,
/* 0x1500 */   6,192,140,226,  4, 16,141,229, 12, 48,141,229, 16,224,141,229,
/* 0x1510 */   8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,
/* 0x1520 */ 176, 16,131,225, 12,  0, 84,225,132, 48,160,225,  1, 64,132,226,
/* 0x1530 */  28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,  2,144,131,224,
/* 0x1540 */   3,224,160,225,  6, 32,160,225,  4, 80,157,229,  9, 48,101,224,
/* 0x1550 */   3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,
/* 0x1560 */   1, 32,130,226,  5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,
/* 0x1570 */   0,176,160,227,  1,192,160,227, 11,112,160,225,  0,  0,224,227,
/* 0x1580 */  44,192,141,229, 24,176,141,229, 28,192,141,229, 32,192,141,229,
/* 0x1590 */  36,192,141,229, 57,  2,  0,234,255,132,224,227,  8,  0, 80,225,
/* 0x15a0 */  68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x15b0 */   0,  4,160,225,  6,100,131,225, 12, 16,157,229, 24, 32,157,229,
/* 0x15c0 */   1,160, 11,224,  2, 18,160,225,  1, 48,138,224,131, 80,160,225,
/* 0x15d0 */   8, 48,157,229,181,192,147,225,160, 53,160,225,156,  3,  4,224,
/* 0x15e0 */   4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226,
/* 0x15f0 */  87, 51,160,225, 16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,
/* 0x1600 */   8,  0,157,229,  6, 44,160,227,147,  2, 34,224, 24, 16,157,229,
/* 0x1610 */   2, 59,108,226,  6,  0, 81,227,195, 50,140,224,230,142,130,226,
/* 0x1620 */ 181, 48,128,225, 12,128,136,226,  4,  0,160,209,  1, 16,160,211,
/* 0x1630 */ 164,  0,  0,218, 44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,
/* 0x1640 */   3,112,213,231,  4,  0,160,225,  1, 16,160,227,135,112,160,225,
/* 0x1650 */   1, 92,  7,226,129,160,160,225,133, 48,136,224, 10, 48,131,224,
/* 0x1660 */   1,  4, 80,227,  2, 76,131,226,  1,192,129,226,119,  0,  0, 42,
/* 0x1670 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1680 */   6,100,131,225,176, 48,212,225,160, 37,160,225, 12, 16,129,224,
/* 0x1690 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x16a0 */ 163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,
/* 0x16b0 */ 176, 32,196,225, 10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,
/* 0x16c0 */ 164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,  6, 96,108,224,
/* 0x16d0 */   0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,
/* 0x16e0 */ 105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,
/* 0x16f0 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1700 */   6,100,131,225,180, 48,152,225,160, 37,160,225,147,  2, 12,224,
/* 0x1710 */   2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,194, 50,131,224,
/* 0x1720 */ 180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49,
/* 0x1730 */  12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,129, 64,160,225,
/* 0x1740 */   1, 48,129,226,143,  0,  0,218, 24,192,157,229,255,112,  1,226,
/* 0x1750 */   3,  0, 92,227, 84, 16,157,229,  0, 32,160,211, 11,112,193,231,
/* 0x1760 */   1,176,139,226, 24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,
/* 0x1770 */   9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194,
/* 0x1780 */  24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,
/* 0x1790 */   0, 32,100,224,  8,192,157,229,  8,  0, 82,225,181, 48,140,225,
/* 0x17a0 */   6, 96,100,224,197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x17b0 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225,  8,  0,157,229,
/* 0x17c0 */  24, 48,157,229,131,112,128,224,  6, 13,135,226,176,192,208,225,
/* 0x17d0 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42,
/* 0x17e0 */  24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,
/* 0x17f0 */ 102, 30,133,226,  3, 32,160,195, 32, 80,157,229,  0, 32,160,211,
/* 0x1800 */ 195, 50,140,224, 24, 32,141,229, 28,192,157,229, 44, 32,157,229,
/* 0x1810 */  36, 80,141,229,  4, 16,129,226,  4, 80,160,225, 32,192,141,229,
/* 0x1820 */  28, 32,141,229,176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,
/* 0x1830 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,  6, 96,100,224,
/* 0x1840 */ 236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1850 */   2, 36,160,225,  6,100,131,225,102, 95,135,226,176,192,213,225,
/* 0x1860 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,
/* 0x1870 */   2, 59,108,226,195, 50,140,224,  8,  0, 84,225,176, 48,197,225,
/* 0x1880 */ 252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1890 */   4, 68,160,225,  6,100,131,225,  8, 80,157,229,129, 48,133,224,
/* 0x18a0 */ 138, 48,131,224, 30, 30,131,226,176,192,209,225,164, 53,160,225,
/* 0x18b0 */ 156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,
/* 0x18c0 */   4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,
/* 0x18d0 */   0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10, 44,192,157,229,
/* 0x18e0 */  24, 16,157,229, 84,  0,157,229, 11, 48,108,224,  3,112,208,231,
/* 0x18f0 */   6,  0, 81,227, 11, 16,160,195,  9, 16,160,211, 24, 16,141,229,
/* 0x1900 */  11,112,192,231,  2,  0,160,225,  1,176,139,226, 57,  2,  0,234,
/* 0x1910 */   2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,
/* 0x1920 */   6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x1930 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225, 27, 30,135,226,
/* 0x1940 */ 176,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x1950 */  52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226, 28, 32,157,229,
/* 0x1960 */ 195, 50,140,224, 28, 80,141,229,  4, 80,160,225, 44, 32,141,229,
/* 0x1970 */ 176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,
/* 0x1980 */   8,  0, 82,225,176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,
/* 0x1990 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x19a0 */   6,100,131,225,114, 31,135,226,176,192,209,225,162, 53,160,225,
/* 0x19b0 */ 156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226,
/* 0x19c0 */  32, 32,157,229,195, 50,140,224, 44,  0,157,229, 28,192,157,229,
/* 0x19d0 */   4, 80,160,225, 32,192,141,229, 28,  0,141,229, 49,  1,  0,234,
/* 0x19e0 */ 172, 50, 76,224,176, 48,193,225, 44,192,157,229, 32, 16,141,226,
/* 0x19f0 */  10,  0,145,232,  2, 80,100,224, 28, 32,157,229, 36, 16,141,229,
/* 0x1a00 */  32, 32,141,229, 28,192,141,229, 44, 48,141,229,  6, 96,100,224,
/* 0x1a10 */  24, 32,157,229,  8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,
/* 0x1a20 */   8, 32,160,211,166, 30,128,226, 24, 32,141,229,  8, 16,129,226,
/* 0x1a30 */ 255,116,224,227,  7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225,
/* 0x1a40 */  73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,  6,100,131,225,
/* 0x1a50 */ 176,192,209,225,165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x1a60 */ 120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,
/* 0x1a70 */   4, 80,130,226,  4,  0,160,225,  3,160,160,227,  0,128,160,227,
/* 0x1a80 */ 176, 48,193,225,152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,
/* 0x1a90 */   7,  0, 82,225,  6, 96,100,224,176, 48,193,225,131,  1,  0,138,
/* 0x1aa0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x1ab0 */   6,100,131,225,178,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x1ac0 */   4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,
/* 0x1ad0 */ 195, 50,140,224, 65, 95,130,226,  4,  0,160,225,  3,160,160,227,
/* 0x1ae0 */   8,128,160,227,178, 48,193,225,152,  1,  0,234,172, 50, 76,224,
/* 0x1af0 */ 178, 48,193,225,  6, 96,100,224,  2,  0,100,224,129, 95,129,226,
/* 0x1b00 */   8,160,160,227, 16,128,160,227, 10,112,160,225,  1, 16,160,227,
/* 0x1b10 */   1, 48,129,226,  1,  4, 80,227,129, 64,160,225,  3, 16,129,224,
/* 0x1b20 */ 164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x1b30 */   1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,
/* 0x1b40 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x1b50 */ 163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,
/* 0x1b60 */ 180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,
/* 0x1b70 */ 154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,
/* 0x1b80 */   8, 48,131,224,  3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,
/* 0x1b90 */   8,192,157,229,  3,  0, 83,227,  3, 48,160,163,131, 51,140,224,
/* 0x1ba0 */  54, 94,131,226,  2,112,160,225,  6,128,160,227,  1, 48,135,226,
/* 0x1bb0 */   1,  4, 80,227,135, 64,160,225,  3,112,135,224,203,  1,  0, 42,
/* 0x1bc0 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x1bd0 */   6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,
/* 0x1be0 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x1bf0 */   0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,
/* 0x1c00 */   6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26,
/* 0x1c10 */  64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,
/* 0x1c20 */ 194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,
/* 0x1c30 */   2,192,131,227,  5, 64, 68,194,  8, 32,160,193,237,  1,  0,202,
/* 0x1c40 */  28, 87,160,225,  8, 16,157,229,133, 48,129,224,130, 48, 67,224,
/* 0x1c50 */  85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,
/* 0x1c60 */   1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x1c70 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,160,  0,160,225,
/* 0x1c80 */   0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,
/* 0x1c90 */   4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,
/* 0x1ca0 */   4, 64,132,226, 12, 82,160,225,  4,112,160,227,  1,160,160,227,
/* 0x1cb0 */  10,128,160,225,  1,  4, 80,227,136, 16,160,225,  1,192,136,226,
/* 0x1cc0 */  12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x1cd0 */   1, 48,222,228,  6,100,131,225,177, 48,148,225,160, 37,160,225,
/* 0x1ce0 */  12,128,136,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x1cf0 */ 194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49,
/* 0x1d00 */  12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,
/* 0x1d10 */   0,  0,108, 32,  1,112, 87,226,138,160,160,225,  3,  2,  0, 26,
/* 0x1d20 */   1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,
/* 0x1d30 */   7, 48,131,226, 24, 48,141,229, 44, 80,157,229, 11,  0, 85,225,
/* 0x1d40 */  73,  2,  0,138, 40,192,157,229, 84, 16,157,229, 11, 48,101,224,
/* 0x1d50 */   2, 32,140,226,  3, 64,129,224, 11,192,129,224,  1, 32, 82,226,
/* 0x1d60 */  88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,
/* 0x1d70 */   5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,
/* 0x1d80 */   0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26, 88,192,157,229,
/* 0x1d90 */  12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,
/* 0x1da0 */   9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,
/* 0x1db0 */   0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,
/* 0x1dc0 */   0, 48,129,229,  0,176,130,229, 74,  2,  0,234,  1,  0,160,227,
/* 0x1dd0 */  48,208,141,226,240,143,189,232,248, 79, 45,233,  1,192,130,224,
/* 0x1de0 */  40,144,157,229, 44,112,157,229,  1,128,160,225,  9,160,135,224,
/* 0x1df0 */   4,176,128,226,  0, 96,208,229,  1, 80,208,229,  2, 64,208,229,
/* 0x1e00 */   6,224,133,224,  0,112,224,227, 23, 85,224,225, 23, 68,224,225,
/* 0x1e10 */   1, 48,160,227,  1, 32,160,227,  1, 16,160,227,  1,  0,160,227,
/* 0x1e20 */ 255, 95, 45,233,  0, 96,160,227, 28, 96,141,229,  3, 44,160,227,
/* 0x1e30 */  18, 46,160,225, 54, 32,130,226,  7, 44,130,226, 11, 16,160,225,
/* 0x1e40 */   1, 11,160,227,  1,  3,128,227,  4,  0,129,228,  2, 32, 82,226,
/* 0x1e50 */  26,  0,  0,202,  5,  0,136,226,  5,  1,  0,235,  8,  0, 80,225,
/* 0x1e60 */  30,  0,  0, 26, 36, 48,157,229, 16, 32,157,229,  3, 64, 73,224,
/* 0x1e70 */   2,  0,  4,224, 44,  0,141,229,  6,  2,128,224,  0, 16,139,226,
/* 0x1e80 */   9,  1,  0,235, 80,  0,  0, 26, 20, 48,157,229, 24, 32,157,229,
/* 0x1e90 */   4, 48,  3,224, 28,  0,221,229, 19, 50,160,225,  8, 32, 98,226,
/* 0x1ea0 */  48, 50,131,224,108,160,139,226,131, 48,131,224, 14,172,138,226,
/* 0x1eb0 */   1,  0,160,227,131,164,138,224,  7,  0, 86,227, 69,  0,  0, 58,
/* 0x1ec0 */   0, 16,157,229,  1, 80, 89,231,133, 80,160,225,  2, 28,138,226,
/* 0x1ed0 */   1, 76,  5,226,132, 16,129,224, 11,  1,  0,235,  1, 48,  0,226,
/* 0x1ee0 */  36,  4, 83,225, 71,  0,  0, 26,  1, 12, 80,227, 58,  0,  0, 58,
/* 0x1ef0 */  73,  0,  0,234, 10, 16,160,225, 11,  1,  0,235,  1, 12, 80,227,
/* 0x1f00 */  69,  0,  0, 58,  6, 48,160,227, 10,  0, 86,227,  3, 48,160, 51,
/* 0x1f10 */   4,  0, 86,227,  6, 48,160, 49,  3, 96, 70,224,112,  0,  0,234,
/* 0x1f20 */   6, 29,139,226,  8,  1,  0,235, 95,  0,  0, 26,  8, 48,157,229,
/* 0x1f30 */   4, 32,157,229,  0, 16,157,229, 12, 48,141,229,  8, 32,141,229,
/* 0x1f40 */   4, 16,141,229,  7,  0, 86,227,  3, 96,160,227,  0, 96,160, 51,
/* 0x1f50 */ 100,160,139,226,  6,172,138,226,135,  0,  0,234,102, 31,139,226,
/* 0x1f60 */   8,  1,  0,235,114,  0,  0, 26, 44, 48,157,229, 30, 30,139,226,
/* 0x1f70 */   6,  2,131,224,  9,  1,  0,235,130,  0,  0, 26,  7,  0, 86,227,
/* 0x1f80 */  11, 96,160,227,  9, 96,160, 51, 36, 48,157,229,  0, 16,157,229,
/* 0x1f90 */   3, 64, 73,224,  1,  0, 84,225,253,  0,  0, 58,  1,  0, 89,231,
/* 0x1fa0 */   1,  0,201,228,237,  0,  0,234, 27, 30,139,226,  8,  1,  0,235,
/* 0x1fb0 */   4, 64,157,229,127,  0,  0, 10,114, 31,139,226,  8,  1,  0,235,
/* 0x1fc0 */   8, 64,157,229,125,  0,  0, 10,  8, 48,157,229, 12, 64,157,229,
/* 0x1fd0 */  12, 48,141,229,  4, 48,157,229,  8, 48,141,229,  0, 16,157,229,
/* 0x1fe0 */   0, 64,141,229,  4, 16,141,229,  7,  0, 86,227, 11, 96,160,227,
/* 0x1ff0 */   8, 96,160, 51,104,160,139,226, 10,172,138,226,  0, 16,138,226,
/* 0x2000 */  10,  1,  0,235,144,  0,  0, 26, 44, 48,157,229,  4, 80,138,226,
/* 0x2010 */   0, 32,160,227,  3, 82,133,224,  8, 64,160,227,156,  0,  0,234,
/* 0x2020 */   2, 16,138,226, 10,  1,  0,235,153,  0,  0, 26, 44, 48,157,229,
/* 0x2030 */  65, 95,138,226,  8, 32,160,227,  3, 82,133,224,  8, 64,160,227,
/* 0x2040 */ 156,  0,  0,234,129, 95,138,226, 16, 32,160,227,  1, 76,160,227,
/* 0x2050 */  52, 32,141,229,  1,  0,160,227,  5, 16,160,225, 11,  1,  0,235,
/* 0x2060 */   4, 48, 80,224,158,  0,  0, 58, 52, 80,157,229,  3, 80,133,224,
/* 0x2070 */  52, 80,141,229,  0, 16,157,229,  4,  0, 86,227,225,  0,  0, 42,
/* 0x2080 */   7, 96,134,226,  4,  0, 85,227,  3, 80,160, 35,133, 83,139,224,
/* 0x2090 */  54, 94,133,226,  1,  0,160,227, 64, 64,160,227,  5, 16,160,225,
/* 0x20a0 */  11,  1,  0,235,  4, 48, 80,224,175,  0,  0, 58, 44, 48,141,229,
/* 0x20b0 */   4,  0, 83,227,221,  0,  0, 58,163, 64,160,225,  1, 64, 68,226,
/* 0x20c0 */   1, 16,  3,226,  2, 16,129,227, 14,  0, 83,227,194,  0,  0, 42,
/* 0x20d0 */  17, 20,160,225, 94,160,139,226,  3, 48, 65,224,  5,172,138,226,
/* 0x20e0 */ 131,160,138,224,206,  0,  0,234,  4, 64, 68,226,255,  0,  0,235,
/* 0x20f0 */ 167,112,160,225,  7,  0, 92,225,  7,192, 76, 32,  1, 16,161,224,
/* 0x2100 */   1, 64, 84,226,195,  0,  0, 26, 68,160,139,226,  6,172,138,226,
/* 0x2110 */   1, 18,160,225,  4, 64,160,227,  0, 16,141,229,  1, 80,160,227,
/* 0x2120 */   1,  0,160,227, 10, 16,160,225, 11,  1,  0,235,  1,  0, 16,227,
/* 0x2130 */ 216,  0,  0, 10,  0, 16,157,229,  5, 16,129,225,  0, 16,141,229,
/* 0x2140 */ 133, 80,160,225,  1, 64, 84,226,209,  0,  0, 26,  0, 16,157,229,
/* 0x2150 */ 222,  0,  0,234, 44, 16,157,229,  1, 16,145,226,  0, 16,141,229,
/* 0x2160 */  52, 80,157,229, 36, 48,157,229,  2, 80,133,226,  3, 48, 73,224,
/* 0x2170 */   3,  0, 81,225,253,  0,  0,138, 40, 32,157,229,  1,  0, 89,231,
/* 0x2180 */   1,  0,201,228,  2,  0, 89,225,241,  0,  0, 42,  1, 80, 85,226,
/* 0x2190 */ 231,  0,  0, 26, 28,  0,205,229, 40, 32,157,229,  2,  0, 89,225,
/* 0x21a0 */  33,  0,  0, 58,255,  0,  0,235,  0,  0,160,227, 32, 32,157,229,
/* 0x21b0 */   2, 48, 72,224, 56, 32,157,229,  0, 48,130,229, 36, 32,157,229,
/* 0x21c0 */   2, 48, 73,224,104, 32,157,229,  0, 48,130,229, 60,208,141,226,
/* 0x21d0 */ 240,143,189,232,  1,  0,160,227,243,  0,  0,234,  1,  4, 87,227,
/* 0x21e0 */  14,240,160, 33, 48, 48,157,229,  7,116,160,225,  8,  0, 83,225,
/* 0x21f0 */ 253,  0,  0, 10,  1, 48,216,228, 12,196,131,225, 14,240,160,225,
/* 0x2200 */   6,  0,160,225,128, 16,129,224,  0,  0,160,227,128, 16,129,224,
/* 0x2210 */   1,  4, 87,227, 14, 32,160,225,  1,  1,  0, 59,176, 48,209,225,
/* 0x2220 */ 167,229,160,225,147, 14, 14,224, 14,  0, 92,225, 14,112,160, 49,
/* 0x2230 */  14,112, 71, 32,  2,235, 99, 50, 14,192, 76, 32,174, 50,131, 48,
/* 0x2240 */ 163, 50, 67, 32,  0,  0,176,224,176, 48,193,225,  2,240,160,225,
/* 0x2250 */   0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,
/* 0x2260 */   0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,108, 83,
/* 0x2270 */  79, 95, 72, 69, 65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0,
/* 0x2280 */  46,114,101,108, 83, 79, 95, 84, 65, 73, 76,  0, 46,114,101,108,
/* 0x2290 */  72, 85, 77, 70, 95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95,
/* 0x22a0 */  76,  0, 46,114,101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x22b0 */  68,  0, 46,114,101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0,
/* 0x22c0 */  46,114,101,108, 69, 88, 80, 95, 72, 69, 65, 68,  0, 46,114,101,
/* 0x22d0 */ 108, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,101,108, 78, 82,
/* 0x22e0 */  86, 50, 69,  0, 46,114,101,108, 78, 82, 86, 50, 68,  0, 46,114,
/* 0x22f0 */ 101,108, 78, 82, 86, 50, 66,  0, 46,114,101,108, 76, 90, 77, 65,
/* 0x2300 */  95, 68, 65, 73, 83, 89,  0, 46,114,101,108, 83, 79, 95, 77, 65,
/* 0x2310 */  73, 78,  0, 46,114,101,108, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x2320 */  48,  0, 46,114,101,108, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2330 */   0, 46,114,101,108, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0,
/* 0x2340 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  0,  0,  0,  0,  0,  0,
/* 0x2350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2370 */   0,  0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x2380 */   0,  0,  0,  0, 52,  0,  0,  0,180,  0,  0,  0,  0,  0,  0,  0,
/* 0x2390 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,
/* 0x23a0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,164, 47,  0,  0,
/* 0x23b0 */  56,  0,  0,  0, 36,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,
/* 0x23c0 */   8,  0,  0,  0, 39,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x23d0 */   0,  0,  0,  0,232,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x23e0 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,
/* 0x23f0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,240,  0,  0,  0,
/* 0x2400 */  88,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2410 */   0,  0,  0,  0, 48,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2420 */   0,  0,  0,  0,220, 47,  0,  0,104,  0,  0,  0, 36,  0,  0,  0,
/* 0x2430 */   4,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 64,  0,  0,  0,
/* 0x2440 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 72,  3,  0,  0,
/* 0x2450 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2460 */   0,  0,  0,  0, 60,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2470 */   0,  0,  0,  0, 68, 48,  0,  0,  8,  0,  0,  0, 36,  0,  0,  0,
/* 0x2480 */   6,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 75,  0,  0,  0,
/* 0x2490 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 76,  3,  0,  0,
/* 0x24a0 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0, 71,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x24c0 */   0,  0,  0,  0, 76, 48,  0,  0,  8,  0,  0,  0, 36,  0,  0,  0,
/* 0x24d0 */   8,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 86,  0,  0,  0,
/* 0x24e0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 80,  3,  0,  0,
/* 0x24f0 */  68,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2500 */   0,  0,  0,  0, 82,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */   0,  0,  0,  0, 84, 48,  0,  0,192,  2,  0,  0, 36,  0,  0,  0,
/* 0x2520 */  10,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,102,  0,  0,  0,
/* 0x2530 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,148,  8,  0,  0,
/* 0x2540 */  68,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2550 */   0,  0,  0,  0, 98,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2560 */   0,  0,  0,  0, 20, 51,  0,  0,128,  0,  0,  0, 36,  0,  0,  0,
/* 0x2570 */  12,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,116,  0,  0,  0,
/* 0x2580 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,216,  9,  0,  0,
/* 0x2590 */ 220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x25a0 */   0,  0,  0,  0,112,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x25b0 */   0,  0,  0,  0,148, 51,  0,  0, 48,  0,  0,  0, 36,  0,  0,  0,
/* 0x25c0 */  14,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,129,  0,  0,  0,
/* 0x25d0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,180, 10,  0,  0,
/* 0x25e0 */  44,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x25f0 */   0,  0,  0,  0,125,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */   0,  0,  0,  0,196, 51,  0,  0,  8,  0,  0,  0, 36,  0,  0,  0,
/* 0x2610 */  16,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,142,  0,  0,  0,
/* 0x2620 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,224, 10,  0,  0,
/* 0x2630 */  28,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2640 */   0,  0,  0,  0,138,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */   0,  0,  0,  0,204, 51,  0,  0,192,  0,  0,  0, 36,  0,  0,  0,
/* 0x2660 */  18,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,152,  0,  0,  0,
/* 0x2670 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,252, 11,  0,  0,
/* 0x2680 */   8,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2690 */   0,  0,  0,  0,148,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x26a0 */   0,  0,  0,  0,140, 52,  0,  0,160,  0,  0,  0, 36,  0,  0,  0,
/* 0x26b0 */  20,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,162,  0,  0,  0,
/* 0x26c0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  4, 13,  0,  0,
/* 0x26d0 */ 204,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x26e0 */   0,  0,  0,  0,158,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x26f0 */   0,  0,  0,  0, 44, 53,  0,  0,128,  0,  0,  0, 36,  0,  0,  0,
/* 0x2700 */  22,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,172,  0,  0,  0,
/* 0x2710 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,208, 13,  0,  0,
/* 0x2720 */   8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2730 */   0,  0,  0,  0,168,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2740 */   0,  0,  0,  0,172, 53,  0,  0,  8,  0,  0,  0, 36,  0,  0,  0,
/* 0x2750 */  24,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,187,  0,  0,  0,
/* 0x2760 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,216, 13,  0,  0,
/* 0x2770 */  72,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2780 */   0,  0,  0,  0,183,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */   0,  0,  0,  0,180, 53,  0,  0, 40,  2,  0,  0, 36,  0,  0,  0,
/* 0x27a0 */  26,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,199,  0,  0,  0,
/* 0x27b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32, 20,  0,  0,
/* 0x27c0 */ 128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x27d0 */   0,  0,  0,  0,195,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x27e0 */   0,  0,  0,  0,220, 55,  0,  0, 16,  0,  0,  0, 36,  0,  0,  0,
/* 0x27f0 */  28,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,214,  0,  0,  0,
/* 0x2800 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160, 20,  0,  0,
/* 0x2810 */  56,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2820 */   0,  0,  0,  0,210,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2830 */   0,  0,  0,  0,236, 55,  0,  0, 72,  2,  0,  0, 36,  0,  0,  0,
/* 0x2840 */  30,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,229,  0,  0,  0,
/* 0x2850 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,216, 29,  0,  0,
/* 0x2860 */ 120,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2870 */   0,  0,  0,  0,225,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */   0,  0,  0,  0, 52, 58,  0,  0,176,  1,  0,  0, 36,  0,  0,  0,
/* 0x2890 */  32,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,240,  0,  0,  0,
/* 0x28a0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 80, 34,  0,  0,
/* 0x28b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x28c0 */   0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */   0,  0,  0,  0, 80, 34,  0,  0,251,  0,  0,  0,  0,  0,  0,  0,
/* 0x28e0 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x28f0 */   2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 60, 41,  0,  0,
/* 0x2900 */  96,  4,  0,  0, 37,  0,  0,  0, 19,  0,  0,  0,  4,  0,  0,  0,
/* 0x2910 */  16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x2920 */   0,  0,  0,  0,156, 45,  0,  0,  7,  2,  0,  0,  0,  0,  0,  0,
/* 0x2930 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,
/* 0x2960 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  4,  0,  0,  0,  0,  0,
/* 0x2970 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 10,  0,  0,  0,  0,  0,
/* 0x2980 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,  0,  0,  0,  0,
/* 0x2990 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,
/* 0x29a0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,  0,  0,  0,  0,
/* 0x29b0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,  0,  0,  0,  0,
/* 0x29c0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 20,  0,  0,  0,  0,  0,
/* 0x29d0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 22,  0,  0,  0,  0,  0,
/* 0x29e0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 26,  0,  0,  0,  0,  0,
/* 0x29f0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 28,  0,  0,  0,  0,  0,
/* 0x2a00 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 30,  0,  0,  0,  0,  0,
/* 0x2a10 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 32,  0,  0,  0,  0,  0,
/* 0x2a20 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 34,  0,  0,  0,  0,  0,
/* 0x2a30 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,
/* 0x2a40 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  6,  0,  0,  0,  0,  0,
/* 0x2a50 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  8,  0,  0,  0,  0,  0,
/* 0x2a60 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 24,  0,  1,  0,  0,  0,
/* 0x2a70 */  48,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,  6,  0,  0,  0,
/* 0x2a80 */ 116,  0,  0,  0,  0,  0,  0,  0, 16,  0, 14,  0, 15,  0,  0,  0,
/* 0x2a90 */  16,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 29,  0,  0,  0,
/* 0x2aa0 */ 200,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 36,  0,  0,  0,
/* 0x2ab0 */  96,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 51,  0,  0,  0,
/* 0x2ac0 */ 160,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 58,  0,  0,  0,
/* 0x2ad0 */  44,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0, 74,  0,  0,  0,
/* 0x2ae0 */ 132,  2,  0,  0,168,  0,  0,  0, 18,  0, 26,  0, 87,  0,  0,  0,
/* 0x2af0 */  12,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 94,  0,  0,  0,
/* 0x2b00 */ 252,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,104,  0,  0,  0,
/* 0x2b10 */ 108,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,110,  0,  0,  0,
/* 0x2b20 */  80,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,118,  0,  0,  0,
/* 0x2b30 */ 152,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,128,  0,  0,  0,
/* 0x2b40 */ 168,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,134,  0,  0,  0,
/* 0x2b50 */ 196,  2,  0,  0,128,  2,  0,  0, 18,  0, 10,  0,158,  0,  0,  0,
/* 0x2b60 */   8,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,163,  0,  0,  0,
/* 0x2b70 */  92,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,177,  0,  0,  0,
/* 0x2b80 */   0,  0,  0,  0, 68,  1,  0,  0, 18,  0, 12,  0,199,  0,  0,  0,
/* 0x2b90 */   0,  0,  0,  0,  0,  0,  0,  0, 18,  0, 16,  0,203,  0,  0,  0,
/* 0x2ba0 */ 104,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,217,  0,  0,  0,
/* 0x2bb0 */ 232,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,223,  0,  0,  0,
/* 0x2bc0 */ 232,  1,  0,  0,156,  0,  0,  0, 18,  0, 26,  0,236,  0,  0,  0,
/* 0x2bd0 */ 248,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,242,  0,  0,  0,
/* 0x2be0 */   0,  0,  0,  0, 44,  0,  0,  0, 18,  0, 26,  0,253,  0,  0,  0,
/* 0x2bf0 */ 136,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,  7,  1,  0,  0,
/* 0x2c00 */   8,  0,  0,  0,  0,  1,  0,  0, 18,  0, 20,  0, 30,  1,  0,  0,
/* 0x2c10 */  24,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 45,  1,  0,  0,
/* 0x2c20 */ 112,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 58,  1,  0,  0,
/* 0x2c30 */ 216,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 63,  1,  0,  0,
/* 0x2c40 */ 240,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 70,  1,  0,  0,
/* 0x2c50 */ 128,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 79,  1,  0,  0,
/* 0x2c60 */  48,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0, 86,  1,  0,  0,
/* 0x2c70 */   8,  0,  0,  0,196,  0,  0,  0, 18,  0, 22,  0,109,  1,  0,  0,
/* 0x2c80 */ 192,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,115,  1,  0,  0,
/* 0x2c90 */  72,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,128,  1,  0,  0,
/* 0x2ca0 */ 236,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,138,  1,  0,  0,
/* 0x2cb0 */   0,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,146,  1,  0,  0,
/* 0x2cc0 */  88,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,155,  1,  0,  0,
/* 0x2cd0 */   8,  0,  0,  0, 20,  1,  0,  0, 18,  0, 18,  0,178,  1,  0,  0,
/* 0x2ce0 */ 144,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,184,  1,  0,  0,
/* 0x2cf0 */ 108,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,191,  1,  0,  0,
/* 0x2d00 */ 224,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,196,  1,  0,  0,
/* 0x2d10 */  68,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,203,  1,  0,  0,
/* 0x2d20 */ 128,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,208,  1,  0,  0,
/* 0x2d30 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 32,  0,219,  1,  0,  0,
/* 0x2d40 */ 208,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,224,  1,  0,  0,
/* 0x2d50 */ 252,  1,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,230,  1,  0,  0,
/* 0x2d60 */ 184,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,239,  1,  0,  0,
/* 0x2d70 */ 176,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,245,  1,  0,  0,
/* 0x2d80 */ 120,  0,  0,  0,  0,  0,  0,  0, 16,  0,  4,  0,251,  1,  0,  0,
/* 0x2d90 */  44,  3,  0,  0, 28,  3,  0,  0, 18,  0, 26,  0,  0, 80,109, 97,
/* 0x2da0 */ 112,  0,102, 95,101,120,112, 97,110,100,  0,103,101,116, 95,112,
/* 0x2db0 */  97,103,101, 95,109, 97,115,107,  0,109,117,110,109, 97,112,  0,
/* 0x2dc0 */ 103,101,116, 95,115,121,115, 95,109,117,110,109, 97,112,  0,103,
/* 0x2dd0 */ 101,116,112,105,100,  0,117,112,120, 95,109,109, 97,112, 95, 97,
/* 0x2de0 */ 110,100, 95,102,100,  0,102,105,110,105, 95, 83, 69, 76,105,110,
/* 0x2df0 */ 117,120,  0,109,101,109, 99,112,121,  0, 95, 95,117,100,105,118,
/* 0x2e00 */ 115,105, 51,  0, 80,115,121,110, 99,  0,109,101,109,112, 99,112,
/* 0x2e10 */ 121,  0,102,116,114,117,110, 99, 97,116,101,  0,108,115,101,101,
/* 0x2e20 */ 107,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,
/* 0x2e30 */ 100, 95, 97,110,100,114,111,105,100,  0,109,109, 97,112,  0, 95,
/* 0x2e40 */  95, 99,108,101, 97,114, 95, 99, 97, 99,104,101,  0,117,112,120,
/* 0x2e50 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,
/* 0x2e60 */ 117,120,  0,101,111,102,  0,109,109, 97,112, 95,112,114,105,118,
/* 0x2e70 */  97,110,111,110,  0,117,110, 97,109,101,  0,112,114,101,112, 95,
/* 0x2e80 */  83, 69, 76,105,110,117,120,  0,119,114,105,116,101,  0, 80, 70,
/* 0x2e90 */  95,116,111, 95, 80, 82, 79, 84,  0,102,100, 97,116, 97,115,121,
/* 0x2ea0 */ 110, 99,  0,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x2eb0 */ 111,109,112,114,101,115,115, 95, 56,  0,103,101,116, 95,117,112,
/* 0x2ec0 */ 120,102,110, 95,112, 97,116,104,  0,109,101,109,102,100, 95, 99,
/* 0x2ed0 */ 114,101, 97,116,101,  0,114,101, 97,100,  0,117,110,108,105,110,
/* 0x2ee0 */ 107,  0,117,110,100,101,114,108, 97,121,  0,109,101,109,115,101,
/* 0x2ef0 */ 116,  0,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,
/* 0x2f00 */ 109,112,114,101,115,115, 95, 56,  0,109,115,121,110, 99,  0,117,
/* 0x2f10 */ 112,120,102,100, 95, 99,114,101, 97,116,101,  0,109,121, 95, 97,
/* 0x2f20 */ 108,108,111, 99, 97,  0,109,121, 95, 98,107,112,116,  0, 80,112,
/* 0x2f30 */ 114,111,116,101, 99,116,  0,117, 99,108, 95,110,114,118, 50,101,
/* 0x2f40 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56,  0,102,115,
/* 0x2f50 */ 121,110, 99,  0, 80,119,114,105,116,101,  0,115,116, 97,116,  0,
/* 0x2f60 */  80,117,110,109, 97,112,  0,101,120,105,116,  0, 76,122,109, 97,
/* 0x2f70 */  68,101, 99,111,100,101,  0,111,112,101,110,  0,100,105,118, 49,
/* 0x2f80 */  48,  0,109,112,114,111,116,101, 99,116,  0,109,107,100,105,114,
/* 0x2f90 */   0, 99,108,111,115,101,  0,117,112,120, 95,115,111, 95,109, 97,
/* 0x2fa0 */ 105,110,  0,  0, 12,  0,  0,  0,  1,  1,  0,  0, 36,  0,  0,  0,
/* 0x2fb0 */   1,  1,  0,  0, 64,  0,  0,  0,  1, 34,  0,  0, 84,  0,  0,  0,
/* 0x2fc0 */   1, 22,  0,  0,104,  0,  0,  0,  1, 66,  0,  0,144,  0,  0,  0,
/* 0x2fd0 */   1, 52,  0,  0,156,  0,  0,  0,  1, 69,  0,  0, 16,  0,  0,  0,
/* 0x2fe0 */   1,  2,  0,  0, 36,  0,  0,  0,  1,  2,  0,  0, 52,  0,  0,  0,
/* 0x2ff0 */   1,  2,  0,  0, 68,  0,  0,  0,  1,  2,  0,  0, 84,  0,  0,  0,
/* 0x3000 */   1,  2,  0,  0,100,  0,  0,  0,  1,  2,  0,  0,108,  0,  0,  0,
/* 0x3010 */   1, 41,  0,  0,124,  1,  0,  0,  1,  2,  0,  0,144,  1,  0,  0,
/* 0x3020 */   1,  2,  0,  0,172,  1,  0,  0,  1, 27,  0,  0,192,  1,  0,  0,
/* 0x3030 */   1, 38,  0,  0,204,  1,  0,  0,  1,  2,  0,  0,220,  1,  0,  0,
/* 0x3040 */   1, 27,  0,  0,  0,  0,  0,  0,  1, 33,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   1, 36,  0,  0, 12,  0,  0,  0,  1,  3,  0,  0, 40,  0,  0,  0,
/* 0x3060 */   1,  3,  0,  0, 64,  0,  0,  0,  1,  3,  0,  0, 84,  0,  0,  0,
/* 0x3070 */   1,  3,  0,  0,128,  0,  0,  0,  1, 50,  0,  0,140,  0,  0,  0,
/* 0x3080 */   1, 60,  0,  0,148,  0,  0,  0,  1,  3,  0,  0,168,  0,  0,  0,
/* 0x3090 */   1,  3,  0,  0,176,  0,  0,  0,  1,  3,  0,  0,188,  0,  0,  0,
/* 0x30a0 */   1, 67,  0,  0,216,  0,  0,  0,  1, 55,  0,  0,244,  0,  0,  0,
/* 0x30b0 */   1,  3,  0,  0, 12,  1,  0,  0,  1, 30,  0,  0, 32,  1,  0,  0,
/* 0x30c0 */   1,  3,  0,  0, 36,  1,  0,  0,  1,  3,  0,  0, 76,  1,  0,  0,
/* 0x30d0 */   1, 64,  0,  0, 96,  1,  0,  0,  1, 47,  0,  0,108,  1,  0,  0,
/* 0x30e0 */   1, 68,  0,  0,120,  1,  0,  0,  1, 55,  0,  0,144,  1,  0,  0,
/* 0x30f0 */   1,  3,  0,  0,160,  1,  0,  0,  1,  3,  0,  0,164,  1,  0,  0,
/* 0x3100 */   1,  3,  0,  0,176,  1,  0,  0,  1,  3,  0,  0,196,  1,  0,  0,
/* 0x3110 */   1, 30,  0,  0,220,  1,  0,  0,  1,  3,  0,  0,228,  1,  0,  0,
/* 0x3120 */   1,  3,  0,  0,232,  1,  0,  0,  1,  3,  0,  0, 12,  2,  0,  0,
/* 0x3130 */   1, 30,  0,  0, 24,  2,  0,  0,  1, 30,  0,  0, 44,  2,  0,  0,
/* 0x3140 */   1,  3,  0,  0, 48,  2,  0,  0,  1,  3,  0,  0, 56,  2,  0,  0,
/* 0x3150 */   1,  3,  0,  0, 60,  2,  0,  0,  1,  3,  0,  0, 84,  2,  0,  0,
/* 0x3160 */   1, 30,  0,  0,108,  2,  0,  0,  1,  3,  0,  0,112,  2,  0,  0,
/* 0x3170 */   1,  3,  0,  0,136,  2,  0,  0,  1, 30,  0,  0,144,  2,  0,  0,
/* 0x3180 */   1, 24,  0,  0,152,  2,  0,  0,  1,  3,  0,  0,164,  2,  0,  0,
/* 0x3190 */   1,  3,  0,  0,176,  2,  0,  0,  1,  3,  0,  0,220,  2,  0,  0,
/* 0x31a0 */   1,  3,  0,  0,240,  2,  0,  0,  1, 46,  0,  0,252,  2,  0,  0,
/* 0x31b0 */   1,  3,  0,  0,  8,  3,  0,  0,  1, 46,  0,  0, 20,  3,  0,  0,
/* 0x31c0 */   1,  3,  0,  0, 24,  3,  0,  0,  1,  3,  0,  0, 60,  3,  0,  0,
/* 0x31d0 */   1, 64,  0,  0, 68,  3,  0,  0,  1,  3,  0,  0, 72,  3,  0,  0,
/* 0x31e0 */   1,  3,  0,  0, 96,  3,  0,  0,  1, 55,  0,  0,108,  3,  0,  0,
/* 0x31f0 */   1, 39,  0,  0,112,  3,  0,  0,  1,  3,  0,  0,132,  3,  0,  0,
/* 0x3200 */   1,  3,  0,  0,140,  3,  0,  0,  1,  3,  0,  0,144,  3,  0,  0,
/* 0x3210 */   1,  3,  0,  0,164,  3,  0,  0,  1,  3,  0,  0,172,  3,  0,  0,
/* 0x3220 */   1,  3,  0,  0,188,  3,  0,  0,  1,  3,  0,  0,196,  3,  0,  0,
/* 0x3230 */   1,  3,  0,  0,200,  3,  0,  0,  1, 45,  0,  0,232,  3,  0,  0,
/* 0x3240 */   1,  3,  0,  0,240,  3,  0,  0,  1,  3,  0,  0,252,  3,  0,  0,
/* 0x3250 */   1,  3,  0,  0, 12,  4,  0,  0,  1,  3,  0,  0, 20,  4,  0,  0,
/* 0x3260 */   1,  3,  0,  0, 36,  4,  0,  0,  1, 64,  0,  0, 48,  4,  0,  0,
/* 0x3270 */   1,  3,  0,  0, 56,  4,  0,  0,  1, 48,  0,  0, 64,  4,  0,  0,
/* 0x3280 */   1,  3,  0,  0, 76,  4,  0,  0,  1,  3,  0,  0, 80,  4,  0,  0,
/* 0x3290 */   1, 21,  0,  0,104,  4,  0,  0,  1,  3,  0,  0,112,  4,  0,  0,
/* 0x32a0 */   1,  3,  0,  0,124,  4,  0,  0,  1, 31,  0,  0,132,  4,  0,  0,
/* 0x32b0 */   1,  3,  0,  0,136,  4,  0,  0,  1,  3,  0,  0,152,  4,  0,  0,
/* 0x32c0 */   1, 32,  0,  0,188,  4,  0,  0,  1, 41,  0,  0,204,  4,  0,  0,
/* 0x32d0 */   1, 32,  0,  0,216,  4,  0,  0,  1,  3,  0,  0,220,  4,  0,  0,
/* 0x32e0 */   1, 21,  0,  0,232,  4,  0,  0,  1,  3,  0,  0,248,  4,  0,  0,
/* 0x32f0 */   1, 41,  0,  0,252,  4,  0,  0,  1,  3,  0,  0, 28,  5,  0,  0,
/* 0x3300 */   1, 34,  0,  0, 44,  5,  0,  0,  1,  3,  0,  0, 52,  5,  0,  0,
/* 0x3310 */   1,  3,  0,  0, 16,  0,  0,  0,  1,  4,  0,  0, 36,  0,  0,  0,
/* 0x3320 */   1, 46,  0,  0, 48,  0,  0,  0,  1,  4,  0,  0, 60,  0,  0,  0,
/* 0x3330 */   1, 46,  0,  0, 72,  0,  0,  0,  1,  4,  0,  0, 76,  0,  0,  0,
/* 0x3340 */   1,  4,  0,  0,112,  0,  0,  0,  1, 64,  0,  0,120,  0,  0,  0,
/* 0x3350 */   1,  4,  0,  0,132,  0,  0,  0,  1,  4,  0,  0,136,  0,  0,  0,
/* 0x3360 */   1,  4,  0,  0,216,  0,  0,  0,  1, 41,  0,  0,224,  0,  0,  0,
/* 0x3370 */   1, 62,  0,  0,236,  0,  0,  0,  1, 31,  0,  0,248,  0,  0,  0,
/* 0x3380 */   1,  4,  0,  0, 32,  1,  0,  0,  1, 34,  0,  0, 40,  1,  0,  0,
/* 0x3390 */   1, 21,  0,  0, 44,  0,  0,  0,  1,  5,  0,  0, 72,  0,  0,  0,
/* 0x33a0 */   1,  5,  0,  0,136,  0,  0,  0,  1,  5,  0,  0,152,  0,  0,  0,
/* 0x33b0 */   1,  5,  0,  0,172,  0,  0,  0,  1,  5,  0,  0,188,  0,  0,  0,
/* 0x33c0 */   1,  5,  0,  0, 12,  0,  0,  0,  1,  6,  0,  0,  4,  0,  0,  0,
/* 0x33d0 */   1,  7,  0,  0, 24,  0,  0,  0,  1,  7,  0,  0, 76,  0,  0,  0,
/* 0x33e0 */   1,  7,  0,  0, 80,  0,  0,  0,  1,  7,  0,  0, 88,  0,  0,  0,
/* 0x33f0 */   1,  7,  0,  0,100,  0,  0,  0,  1,  7,  0,  0,112,  0,  0,  0,
/* 0x3400 */   1,  7,  0,  0,124,  0,  0,  0,  1,  7,  0,  0,128,  0,  0,  0,
/* 0x3410 */   1,  7,  0,  0,140,  0,  0,  0,  1,  7,  0,  0,156,  0,  0,  0,
/* 0x3420 */   1,  7,  0,  0,164,  0,  0,  0,  1,  7,  0,  0,168,  0,  0,  0,
/* 0x3430 */   1,  7,  0,  0,176,  0,  0,  0,  1,  7,  0,  0,180,  0,  0,  0,
/* 0x3440 */   1,  7,  0,  0,192,  0,  0,  0,  1,  7,  0,  0,196,  0,  0,  0,
/* 0x3450 */   1,  7,  0,  0,204,  0,  0,  0,  1,  7,  0,  0,216,  0,  0,  0,
/* 0x3460 */   1,  7,  0,  0,220,  0,  0,  0,  1,  7,  0,  0,228,  0,  0,  0,
/* 0x3470 */   1,  7,  0,  0,236,  0,  0,  0,  1,  7,  0,  0, 20,  1,  0,  0,
/* 0x3480 */   1,  7,  0,  0, 24,  1,  0,  0,  1,  7,  0,  0,  4,  0,  0,  0,
/* 0x3490 */   1,  8,  0,  0, 24,  0,  0,  0,  1,  8,  0,  0, 76,  0,  0,  0,
/* 0x34a0 */   1,  8,  0,  0, 80,  0,  0,  0,  1,  8,  0,  0, 88,  0,  0,  0,
/* 0x34b0 */   1,  8,  0,  0,100,  0,  0,  0,  1,  8,  0,  0,112,  0,  0,  0,
/* 0x34c0 */   1,  8,  0,  0,124,  0,  0,  0,  1,  8,  0,  0,128,  0,  0,  0,
/* 0x34d0 */   1,  8,  0,  0,140,  0,  0,  0,  1,  8,  0,  0,156,  0,  0,  0,
/* 0x34e0 */   1,  8,  0,  0,164,  0,  0,  0,  1,  8,  0,  0,172,  0,  0,  0,
/* 0x34f0 */   1,  8,  0,  0,184,  0,  0,  0,  1,  8,  0,  0,192,  0,  0,  0,
/* 0x3500 */   1,  8,  0,  0,204,  0,  0,  0,  1,  8,  0,  0,216,  0,  0,  0,
/* 0x3510 */   1,  8,  0,  0,220,  0,  0,  0,  1,  8,  0,  0,  0,  1,  0,  0,
/* 0x3520 */   1,  8,  0,  0,  4,  1,  0,  0,  1,  8,  0,  0,  4,  0,  0,  0,
/* 0x3530 */   1,  9,  0,  0, 24,  0,  0,  0,  1,  9,  0,  0, 80,  0,  0,  0,
/* 0x3540 */   1,  9,  0,  0, 88,  0,  0,  0,  1,  9,  0,  0, 92,  0,  0,  0,
/* 0x3550 */   1,  9,  0,  0,108,  0,  0,  0,  1,  9,  0,  0,112,  0,  0,  0,
/* 0x3560 */   1,  9,  0,  0,116,  0,  0,  0,  1,  9,  0,  0,128,  0,  0,  0,
/* 0x3570 */   1,  9,  0,  0,144,  0,  0,  0,  1,  9,  0,  0,148,  0,  0,  0,
/* 0x3580 */   1,  9,  0,  0,156,  0,  0,  0,  1,  9,  0,  0,164,  0,  0,  0,
/* 0x3590 */   1,  9,  0,  0,168,  0,  0,  0,  1,  9,  0,  0,196,  0,  0,  0,
/* 0x35a0 */   1,  9,  0,  0,200,  0,  0,  0,  1,  9,  0,  0,  4,  0,  0,  0,
/* 0x35b0 */   1, 14,  0,  0,  4,  0,  0,  0,  1, 10,  0,  0, 48,  0,  0,  0,
/* 0x35c0 */   1, 55,  0,  0, 56,  0,  0,  0,  1, 62,  0,  0, 88,  0,  0,  0,
/* 0x35d0 */   1, 10,  0,  0,100,  0,  0,  0,  1, 10,  0,  0,132,  0,  0,  0,
/* 0x35e0 */   1, 10,  0,  0,188,  0,  0,  0,  1, 10,  0,  0,204,  0,  0,  0,
/* 0x35f0 */   1, 10,  0,  0,216,  0,  0,  0,  1, 10,  0,  0,236,  0,  0,  0,
/* 0x3600 */   1, 10,  0,  0,248,  0,  0,  0,  1, 10,  0,  0,  0,  1,  0,  0,
/* 0x3610 */   1, 10,  0,  0,  4,  1,  0,  0,  1, 10,  0,  0, 20,  1,  0,  0,
/* 0x3620 */   1, 10,  0,  0, 32,  1,  0,  0,  1, 10,  0,  0, 44,  1,  0,  0,
/* 0x3630 */   1, 10,  0,  0, 52,  1,  0,  0,  1, 10,  0,  0, 64,  1,  0,  0,
/* 0x3640 */   1, 10,  0,  0, 88,  1,  0,  0,  1, 20,  0,  0, 96,  1,  0,  0,
/* 0x3650 */   1, 10,  0,  0,112,  1,  0,  0,  1, 10,  0,  0,120,  1,  0,  0,
/* 0x3660 */   1, 10,  0,  0,152,  1,  0,  0,  1, 10,  0,  0,180,  1,  0,  0,
/* 0x3670 */   1, 10,  0,  0,216,  1,  0,  0,  1, 10,  0,  0, 24,  2,  0,  0,
/* 0x3680 */   1, 27,  0,  0, 40,  2,  0,  0,  1, 25,  0,  0, 68,  2,  0,  0,
/* 0x3690 */   1, 10,  0,  0, 92,  2,  0,  0,  1, 55,  0,  0,112,  2,  0,  0,
/* 0x36a0 */   1, 41,  0,  0,164,  2,  0,  0,  1, 10,  0,  0,180,  2,  0,  0,
/* 0x36b0 */   1, 29,  0,  0,192,  2,  0,  0,  1, 61,  0,  0,200,  2,  0,  0,
/* 0x36c0 */   1, 42,  0,  0,232,  2,  0,  0,  1, 19,  0,  0,240,  2,  0,  0,
/* 0x36d0 */   1, 68,  0,  0,244,  2,  0,  0,  1, 10,  0,  0, 12,  3,  0,  0,
/* 0x36e0 */   1, 42,  0,  0, 28,  3,  0,  0,  1, 56,  0,  0, 64,  3,  0,  0,
/* 0x36f0 */   1, 21,  0,  0,144,  3,  0,  0,  1, 34,  0,  0,160,  3,  0,  0,
/* 0x3700 */   1, 27,  0,  0,204,  3,  0,  0,  1, 10,  0,  0,228,  3,  0,  0,
/* 0x3710 */   1, 10,  0,  0, 20,  4,  0,  0,  1, 10,  0,  0, 32,  4,  0,  0,
/* 0x3720 */   1, 10,  0,  0, 84,  4,  0,  0,  1, 10,  0,  0,152,  4,  0,  0,
/* 0x3730 */   1, 10,  0,  0,172,  4,  0,  0,  1, 10,  0,  0,184,  4,  0,  0,
/* 0x3740 */   1, 10,  0,  0,192,  4,  0,  0,  1, 40,  0,  0,200,  4,  0,  0,
/* 0x3750 */   1, 10,  0,  0,208,  4,  0,  0,  1, 49,  0,  0,244,  4,  0,  0,
/* 0x3760 */   1, 10,  0,  0,  0,  5,  0,  0,  1, 10,  0,  0, 12,  5,  0,  0,
/* 0x3770 */   1, 10,  0,  0, 20,  5,  0,  0,  1, 23,  0,  0, 44,  5,  0,  0,
/* 0x3780 */   1, 10,  0,  0, 56,  5,  0,  0,  1, 10,  0,  0, 92,  5,  0,  0,
/* 0x3790 */   1, 10,  0,  0,116,  5,  0,  0,  1, 10,  0,  0,132,  5,  0,  0,
/* 0x37a0 */   1, 25,  0,  0,168,  5,  0,  0,  1, 41,  0,  0,204,  5,  0,  0,
/* 0x37b0 */   1, 34,  0,  0,216,  5,  0,  0,  1, 68,  0,  0,220,  5,  0,  0,
/* 0x37c0 */   1, 10,  0,  0,  0,  6,  0,  0,  1, 26,  0,  0, 24,  6,  0,  0,
/* 0x37d0 */   1, 10,  0,  0, 36,  6,  0,  0,  1, 61,  0,  0, 64,  0,  0,  0,
/* 0x37e0 */   1, 11,  0,  0,116,  0,  0,  0,  1, 11,  0,  0,116,  0,  0,  0,
/* 0x37f0 */   1, 12,  0,  0,144,  0,  0,  0,  1, 12,  0,  0,184,  0,  0,  0,
/* 0x3800 */   1, 12,  0,  0,204,  0,  0,  0,  1, 12,  0,  0,244,  0,  0,  0,
/* 0x3810 */   1, 12,  0,  0,  0,  1,  0,  0,  1, 12,  0,  0,  8,  1,  0,  0,
/* 0x3820 */   1, 12,  0,  0, 68,  1,  0,  0,  1, 12,  0,  0,144,  1,  0,  0,
/* 0x3830 */   1, 12,  0,  0,204,  1,  0,  0,  1, 12,  0,  0,216,  1,  0,  0,
/* 0x3840 */   1, 12,  0,  0,  4,  2,  0,  0,  1, 12,  0,  0, 24,  2,  0,  0,
/* 0x3850 */   1, 12,  0,  0, 32,  2,  0,  0,  1, 12,  0,  0, 52,  2,  0,  0,
/* 0x3860 */   1, 12,  0,  0, 60,  2,  0,  0,  1, 12,  0,  0, 64,  2,  0,  0,
/* 0x3870 */   1, 12,  0,  0, 76,  2,  0,  0,  1, 12,  0,  0, 88,  2,  0,  0,
/* 0x3880 */   1, 12,  0,  0,164,  2,  0,  0,  1, 12,  0,  0,200,  2,  0,  0,
/* 0x3890 */   1, 12,  0,  0,232,  2,  0,  0,  1, 12,  0,  0,  4,  3,  0,  0,
/* 0x38a0 */   1, 12,  0,  0, 12,  3,  0,  0,  1, 12,  0,  0, 60,  3,  0,  0,
/* 0x38b0 */   1, 12,  0,  0,136,  3,  0,  0,  1, 12,  0,  0,160,  3,  0,  0,
/* 0x38c0 */   1, 12,  0,  0,168,  3,  0,  0,  1, 12,  0,  0,204,  3,  0,  0,
/* 0x38d0 */   1, 12,  0,  0,224,  3,  0,  0,  1, 12,  0,  0,232,  3,  0,  0,
/* 0x38e0 */   1, 12,  0,  0, 36,  4,  0,  0,  1, 12,  0,  0, 56,  4,  0,  0,
/* 0x38f0 */   1, 12,  0,  0,108,  4,  0,  0,  1, 12,  0,  0,132,  4,  0,  0,
/* 0x3900 */   1, 12,  0,  0,140,  4,  0,  0,  1, 12,  0,  0,176,  4,  0,  0,
/* 0x3910 */   1, 12,  0,  0,212,  4,  0,  0,  1, 12,  0,  0,236,  4,  0,  0,
/* 0x3920 */   1, 12,  0,  0,244,  4,  0,  0,  1, 12,  0,  0, 24,  5,  0,  0,
/* 0x3930 */   1, 12,  0,  0, 60,  5,  0,  0,  1, 12,  0,  0,152,  5,  0,  0,
/* 0x3940 */   1, 12,  0,  0,160,  5,  0,  0,  1, 12,  0,  0,192,  5,  0,  0,
/* 0x3950 */   1, 12,  0,  0,228,  5,  0,  0,  1, 12,  0,  0,252,  5,  0,  0,
/* 0x3960 */   1, 12,  0,  0,  4,  6,  0,  0,  1, 12,  0,  0, 36,  6,  0,  0,
/* 0x3970 */   1, 12,  0,  0, 72,  6,  0,  0,  1, 12,  0,  0,128,  6,  0,  0,
/* 0x3980 */   1, 12,  0,  0,140,  6,  0,  0,  1, 12,  0,  0,208,  6,  0,  0,
/* 0x3990 */   1, 12,  0,  0,236,  6,  0,  0,  1, 12,  0,  0, 28,  7,  0,  0,
/* 0x39a0 */   1, 12,  0,  0, 40,  7,  0,  0,  1, 12,  0,  0,108,  7,  0,  0,
/* 0x39b0 */   1, 12,  0,  0,124,  7,  0,  0,  1, 12,  0,  0,156,  7,  0,  0,
/* 0x39c0 */   1, 12,  0,  0,184,  7,  0,  0,  1, 12,  0,  0,196,  7,  0,  0,
/* 0x39d0 */   1, 12,  0,  0,208,  7,  0,  0,  1, 12,  0,  0,244,  7,  0,  0,
/* 0x39e0 */   1, 12,  0,  0, 32,  8,  0,  0,  1, 12,  0,  0, 44,  8,  0,  0,
/* 0x39f0 */   1, 12,  0,  0,124,  8,  0,  0,  1, 12,  0,  0,136,  8,  0,  0,
/* 0x3a00 */   1, 12,  0,  0,160,  8,  0,  0,  1, 12,  0,  0,232,  8,  0,  0,
/* 0x3a10 */   1, 12,  0,  0,244,  8,  0,  0,  1, 12,  0,  0,252,  8,  0,  0,
/* 0x3a20 */   1, 12,  0,  0,  4,  9,  0,  0,  1, 12,  0,  0, 40,  9,  0,  0,
/* 0x3a30 */   1, 12,  0,  0,120,  0,  0,  0,  1, 13,  0,  0,128,  0,  0,  0,
/* 0x3a40 */   1, 13,  0,  0,136,  0,  0,  0,  1, 13,  0,  0,168,  0,  0,  0,
/* 0x3a50 */   1, 13,  0,  0,172,  0,  0,  0,  1, 13,  0,  0,228,  0,  0,  0,
/* 0x3a60 */   1, 13,  0,  0,  0,  1,  0,  0,  1, 13,  0,  0, 12,  1,  0,  0,
/* 0x3a70 */   1, 13,  0,  0, 20,  1,  0,  0,  1, 13,  0,  0, 24,  1,  0,  0,
/* 0x3a80 */   1, 13,  0,  0, 32,  1,  0,  0,  1, 13,  0,  0, 40,  1,  0,  0,
/* 0x3a90 */   1, 13,  0,  0, 68,  1,  0,  0,  1, 13,  0,  0, 76,  1,  0,  0,
/* 0x3aa0 */   1, 13,  0,  0, 80,  1,  0,  0,  1, 13,  0,  0,128,  1,  0,  0,
/* 0x3ab0 */   1, 13,  0,  0,136,  1,  0,  0,  1, 13,  0,  0,140,  1,  0,  0,
/* 0x3ac0 */   1, 13,  0,  0,156,  1,  0,  0,  1, 13,  0,  0,160,  1,  0,  0,
/* 0x3ad0 */   1, 13,  0,  0,192,  1,  0,  0,  1, 13,  0,  0,204,  1,  0,  0,
/* 0x3ae0 */   1, 13,  0,  0,212,  1,  0,  0,  1, 13,  0,  0,220,  1,  0,  0,
/* 0x3af0 */   1, 13,  0,  0,228,  1,  0,  0,  1, 13,  0,  0,236,  1,  0,  0,
/* 0x3b00 */   1, 13,  0,  0, 40,  2,  0,  0,  1, 13,  0,  0, 44,  2,  0,  0,
/* 0x3b10 */   1, 13,  0,  0, 68,  2,  0,  0,  1, 13,  0,  0, 76,  2,  0,  0,
/* 0x3b20 */   1, 13,  0,  0, 80,  2,  0,  0,  1, 13,  0,  0,104,  2,  0,  0,
/* 0x3b30 */   1, 13,  0,  0,132,  2,  0,  0,  1, 13,  0,  0,140,  2,  0,  0,
/* 0x3b40 */   1, 13,  0,  0,164,  2,  0,  0,  1, 13,  0,  0,200,  2,  0,  0,
/* 0x3b50 */   1, 13,  0,  0,208,  2,  0,  0,  1, 13,  0,  0,220,  2,  0,  0,
/* 0x3b60 */   1, 13,  0,  0,244,  2,  0,  0,  1, 13,  0,  0, 12,  3,  0,  0,
/* 0x3b70 */   1, 13,  0,  0, 20,  3,  0,  0,  1, 13,  0,  0, 44,  3,  0,  0,
/* 0x3b80 */   1, 13,  0,  0, 80,  3,  0,  0,  1, 13,  0,  0, 88,  3,  0,  0,
/* 0x3b90 */   1, 13,  0,  0,112,  3,  0,  0,  1, 13,  0,  0,120,  3,  0,  0,
/* 0x3ba0 */   1, 13,  0,  0,156,  3,  0,  0,  1, 13,  0,  0,176,  3,  0,  0,
/* 0x3bb0 */   1, 13,  0,  0,184,  3,  0,  0,  1, 13,  0,  0,200,  3,  0,  0,
/* 0x3bc0 */   1, 13,  0,  0,204,  3,  0,  0,  1, 13,  0,  0,  0,  4,  0,  0,
/* 0x3bd0 */   1, 13,  0,  0, 24,  4,  0,  0,  1, 13,  0,  0, 64,  4,  0,  0,
/* 0x3be0 */   1, 13,  0,  0,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x3bf0 */ 101,108,102, 51, 50, 45,108,105,116,116,108,101, 97,114,109, 10,
/* 0x3c00 */  10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78,
/* 0x3c10 */  97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,
/* 0x3c20 */ 101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32,
/* 0x3c30 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,
/* 0x3c40 */ 111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115,
/* 0x3c50 */  10, 32, 32, 48, 32, 83, 79, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x3c60 */  32, 32, 32, 48, 98, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x3c70 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3c80 */  83, 10, 32, 32, 49, 32,112,116,114, 95, 78, 69, 88, 84, 32, 32,
/* 0x3c90 */  32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,101,
/* 0x3ca0 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3cb0 */  83, 10, 32, 32, 50, 32, 83, 79, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x3cc0 */  32, 32, 32, 32, 48, 50, 53, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3cd0 */  48,102, 48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69,
/* 0x3ce0 */  78, 84, 83, 10, 32, 32, 51, 32, 72, 85, 77, 70, 95, 65, 32, 32,
/* 0x3cf0 */  32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3d00 */  48, 51, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3d10 */  69, 78, 84, 83, 10, 32, 32, 52, 32, 72, 85, 77, 70, 95, 76, 32,
/* 0x3d20 */  32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x3d30 */  32, 48, 51, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3d40 */  84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 85, 77, 70, 95, 65, 78,
/* 0x3d50 */  68, 82, 79, 73, 68, 32, 32, 32, 48, 53, 52, 52, 32, 32, 48, 32,
/* 0x3d60 */  32, 48, 32, 32, 48, 51, 53, 48, 32, 32, 50, 42, 42, 50, 32, 32,
/* 0x3d70 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 85, 77, 70,
/* 0x3d80 */  95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48, 49, 52, 52, 32,
/* 0x3d90 */  32, 48, 32, 32, 48, 32, 32, 48, 56, 57, 52, 32, 32, 50, 42, 42,
/* 0x3da0 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,
/* 0x3db0 */  69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x3dc0 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57,100, 56, 32, 32, 50,
/* 0x3dd0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3de0 */  56, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32,
/* 0x3df0 */  48, 50, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 98, 52, 32,
/* 0x3e00 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3e10 */  32, 32, 57, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e20 */  32, 32, 48, 49, 49, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97,
/* 0x3e30 */ 101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3e40 */  84, 83, 10, 32, 49, 48, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32,
/* 0x3e50 */  32, 32, 32, 32, 32, 48, 49, 48, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x3e60 */  32, 48, 98,102, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3e70 */  84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 78, 82, 86, 50, 66, 32,
/* 0x3e80 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 99, 32, 32, 48, 32, 32,
/* 0x3e90 */  48, 32, 32, 48,100, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3ea0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 76, 90, 77, 65,
/* 0x3eb0 */  95, 68, 65, 73, 83, 89, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32,
/* 0x3ec0 */  32, 48, 32, 32, 48,100,100, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3ed0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 83, 79, 95,
/* 0x3ee0 */  77, 65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48, 54, 52, 56, 32,
/* 0x3ef0 */  32, 48, 32, 32, 48, 32, 32, 48,100,100, 56, 32, 32, 50, 42, 42,
/* 0x3f00 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32,
/* 0x3f10 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 56,
/* 0x3f20 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 50, 48, 32, 32,
/* 0x3f30 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x3f40 */  49, 53, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x3f50 */  32, 48, 57, 51, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52,
/* 0x3f60 */  97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3f70 */  84, 83, 10, 32, 49, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3f80 */  48, 32, 32, 32, 32, 48, 52, 55, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x3f90 */  32, 48, 49,100,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3fa0 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32, 76, 90, 77, 65, 95,
/* 0x3fb0 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3fc0 */  32, 32, 48, 50, 50, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3fd0 */  79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84,
/* 0x3fe0 */  65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3ff0 */  32, 32, 32, 32,100, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48,
/* 0x4000 */  32, 83, 79, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4020 */  76, 32, 48, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70,
/* 0x4040 */  95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65,
/* 0x4050 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4060 */ 108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x4070 */  88, 32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x4080 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x4090 */  88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69,
/* 0x40a0 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x40b0 */  32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32, 69,
/* 0x40c0 */  88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x40e0 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x40f0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32,
/* 0x4100 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4110 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78,
/* 0x4120 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4130 */  32, 32, 32,100, 32, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 32,
/* 0x4140 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x4160 */  70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x4170 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4180 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76,
/* 0x4190 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x41a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x41b0 */  68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x41c0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x41d0 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48,
/* 0x41e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,112,116,114,
/* 0x4200 */  95, 78, 69, 88, 84, 32, 48, 32,112,116,114, 95, 78, 69, 88, 84,
/* 0x4210 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4220 */  32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85, 77, 70, 95,
/* 0x4230 */  65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4240 */ 100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32, 72, 85, 77, 70,
/* 0x4250 */  95, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4260 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 32, 48,
/* 0x4270 */  32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 10, 48, 48, 48, 48,
/* 0x4280 */  48, 48, 51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x4290 */  72, 69, 65, 68, 32, 48, 32, 80,109, 97,112, 10, 48, 48, 48, 48,
/* 0x42a0 */  48, 48, 55, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x42b0 */  95, 72, 69, 65, 68, 32, 48, 32,102, 95,101,120,112, 97,110,100,
/* 0x42c0 */  10, 48, 48, 48, 48, 48, 48, 49, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x42d0 */  32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32,103,101,116, 95,
/* 0x42e0 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x42f0 */  99, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x4300 */  73, 76, 32, 48, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4310 */  48, 49, 54, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x4320 */  84, 65, 73, 76, 32, 48, 32,103,101,116, 95,115,121,115, 95,109,
/* 0x4330 */ 117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32,103,
/* 0x4340 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x4350 */  32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48, 48, 50, 99,
/* 0x4360 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x4370 */  76, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x4380 */  95,102,100, 10, 48, 48, 48, 48, 48, 50, 56, 52, 32,103, 32, 32,
/* 0x4390 */  32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 97, 56,
/* 0x43a0 */  32,102,105,110,105, 95, 83, 69, 76,105,110,117,120, 10, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x43c0 */  79, 95, 84, 65, 73, 76, 32, 48, 32,109,101,109, 99,112,121, 10,
/* 0x43d0 */  48, 48, 48, 48, 48, 49,102, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x43e0 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 95, 95,117,100,105,
/* 0x43f0 */ 118,115,105, 51, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32,103, 32,
/* 0x4400 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32,
/* 0x4410 */  80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32,103,
/* 0x4420 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x4430 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x4440 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4450 */  76, 32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48,
/* 0x4460 */  48, 48, 48, 48, 97, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x4470 */  79, 95, 84, 65, 73, 76, 32, 48, 32,108,115,101,101,107, 10, 48,
/* 0x4480 */  48, 48, 48, 48, 50, 99, 52, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x4490 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 50, 56, 48,
/* 0x44a0 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x44b0 */  95, 97,110,100,114,111,105,100, 10, 48, 48, 48, 48, 48, 49, 48,
/* 0x44c0 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x44d0 */  76, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 49, 53,
/* 0x44e0 */  99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x44f0 */  76, 32, 48, 32, 95, 95, 99,108,101, 97,114, 95, 99, 97, 99,104,
/* 0x4500 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x4510 */  32, 70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 49, 52,
/* 0x4520 */  52, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,
/* 0x4530 */ 100, 95,108,105,110,117,120, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4540 */  32,103, 32, 32, 32, 32, 32, 70, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x4550 */  76, 32, 48, 32,101,111,102, 10, 48, 48, 48, 48, 48, 49, 54, 56,
/* 0x4560 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x4570 */  32, 48, 32,109,109, 97,112, 95,112,114,105,118, 97,110,111,110,
/* 0x4580 */  10, 48, 48, 48, 48, 48, 48,101, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x4590 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,117,110, 97,109,
/* 0x45a0 */ 101, 10, 48, 48, 48, 48, 48, 49,101, 56, 32,103, 32, 32, 32, 32,
/* 0x45b0 */  32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 57, 99, 32,112,
/* 0x45c0 */ 114,101,112, 95, 83, 69, 76,105,110,117,120, 10, 48, 48, 48, 48,
/* 0x45d0 */  48, 48,102, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x45e0 */  84, 65, 73, 76, 32, 48, 32,119,114,105,116,101, 10, 48, 48, 48,
/* 0x45f0 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79,
/* 0x4600 */  95, 77, 65, 73, 78, 32, 48, 50, 99, 32, 80, 70, 95,116,111, 95,
/* 0x4610 */  80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32,103, 32,
/* 0x4620 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x4630 */ 102,100, 97,116, 97,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68,
/* 0x4650 */  32, 48, 49, 48, 48, 32,117, 99,108, 95,110,114,118, 50,100, 95,
/* 0x4660 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48,
/* 0x4670 */  48, 48, 48, 49, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x4680 */  95, 72, 69, 65, 68, 32, 48, 32,103,101,116, 95,117,112,120,102,
/* 0x4690 */ 110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32,
/* 0x46a0 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x46b0 */  48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x46c0 */  48, 48, 48, 48, 48,100, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x46d0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,114,101, 97,100, 10, 48,
/* 0x46e0 */  48, 48, 48, 48, 48,102, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x46f0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,117,110,108,105,110,107,
/* 0x4700 */  10, 48, 48, 48, 48, 48, 49, 56, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x4710 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,117,110,100,101,
/* 0x4720 */ 114,108, 97,121, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,103, 32,
/* 0x4730 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x4740 */ 109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x4750 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66, 32, 48, 99,
/* 0x4760 */  52, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,
/* 0x4770 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x4780 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4790 */  76, 32, 48, 32,109,115,121,110, 99, 10, 48, 48, 48, 48, 48, 49,
/* 0x47a0 */  52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x47b0 */  73, 76, 32, 48, 32,117,112,120,102,100, 95, 99,114,101, 97,116,
/* 0x47c0 */ 101, 10, 48, 48, 48, 48, 48, 49,101, 99, 32,103, 32, 32, 32, 32,
/* 0x47d0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,121, 95,
/* 0x47e0 */  97,108,108,111, 99, 97, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32,
/* 0x47f0 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x4800 */  48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x4810 */  53, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 72, 69,
/* 0x4820 */  65, 68, 32, 48, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48,
/* 0x4830 */  48, 48, 48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 78,
/* 0x4840 */  82, 86, 50, 69, 32, 48, 49, 49, 52, 32,117, 99,108, 95,110,114,
/* 0x4850 */ 118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x4860 */  10, 48, 48, 48, 48, 48, 48, 57, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x4870 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,102,115,121,110,
/* 0x4880 */  99, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32,103, 32, 32, 32, 32,
/* 0x4890 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,119,114,
/* 0x48a0 */ 105,116,101, 10, 48, 48, 48, 48, 48, 48,101, 48, 32,103, 32, 32,
/* 0x48b0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,115,
/* 0x48c0 */ 116, 97,116, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32,103, 32, 32,
/* 0x48d0 */  32, 32, 32, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32, 80,
/* 0x48e0 */ 117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32,103,
/* 0x48f0 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x4900 */  32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x4910 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x4920 */  48, 32, 48, 32, 76,122,109, 97, 68,101, 99,111,100,101, 10, 48,
/* 0x4930 */  48, 48, 48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x4940 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,111,112,101,110, 10, 48,
/* 0x4950 */  48, 48, 48, 48, 49,102, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x4960 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,100,105,118, 49, 48, 10,
/* 0x4970 */  48, 48, 48, 48, 48, 48, 98, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4980 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,112,114,111,116,
/* 0x4990 */ 101, 99,116, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,103, 32, 32,
/* 0x49a0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,
/* 0x49b0 */ 107,100,105,114, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32,103, 32,
/* 0x49c0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x49d0 */  99,108,111,115,101, 10, 48, 48, 48, 48, 48, 51, 50, 99, 32,103,
/* 0x49e0 */  32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48,
/* 0x49f0 */  51, 49, 99, 32,117,112,120, 95,115,111, 95,109, 97,105,110, 10,
/* 0x4a00 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4a10 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 72, 69, 65, 68,
/* 0x4a20 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4a30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4a40 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65,
/* 0x4a50 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x4a60 */  79, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 50, 52, 32,
/* 0x4a70 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4a80 */  32, 32, 83, 79, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a90 */  52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4aa0 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x4ab0 */  53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4ac0 */  32, 32, 32, 32, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4ad0 */  48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4ae0 */  32, 32, 32, 32, 32, 32, 32,109,112,114,111,116,101, 99,116, 10,
/* 0x4af0 */  48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4b00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,115,121,110, 99,
/* 0x4b10 */  10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x4b20 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,
/* 0x4b30 */ 115,111, 95,109, 97,105,110, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4b40 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4b50 */  91, 83, 79, 95, 84, 65, 73, 76, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4b60 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b70 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4b80 */  48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4b90 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48,
/* 0x4ba0 */  48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4bb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4bc0 */  76, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 65, 82, 77,
/* 0x4bd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x4be0 */  84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95,
/* 0x4bf0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c00 */  83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 53, 52,
/* 0x4c10 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4c20 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48,
/* 0x4c30 */  48, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x4c40 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48,
/* 0x4c50 */  48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4c60 */  52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48,
/* 0x4c70 */  48, 48, 48, 48, 49, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x4c80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4c90 */  76, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77,
/* 0x4ca0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x4cb0 */  84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 49, 97, 99, 32, 82, 95,
/* 0x4cc0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4cd0 */ 109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 49, 99, 48, 32,
/* 0x4ce0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4cf0 */  32, 32,109,109, 97,112, 95,112,114,105,118, 97,110,111,110, 10,
/* 0x4d00 */  48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x4d10 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x4d20 */  73, 76, 10, 48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82,
/* 0x4d30 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x4d40 */ 109, 99,112,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4d50 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85,
/* 0x4d60 */  77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4d70 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d80 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x4da0 */  32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,
/* 0x4db0 */ 102,100, 95, 97,110,100,114,111,105,100, 10, 10, 82, 69, 76, 79,
/* 0x4dc0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4dd0 */  79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70,
/* 0x4de0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4df0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4e00 */  48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4e10 */  52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,
/* 0x4e20 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10, 10,
/* 0x4e30 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4e40 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x4e50 */  79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4e60 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e70 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x4e80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x4e90 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x4ea0 */  48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x4eb0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x4ec0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95,
/* 0x4ed0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ee0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x4ef0 */  48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4f00 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x4f10 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,
/* 0x4f20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x4f30 */ 109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95,
/* 0x4f40 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f50 */ 115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95,
/* 0x4f60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f70 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x4f80 */  48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x4f90 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x4fa0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82,
/* 0x4fb0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x4fc0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x4fd0 */  98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x4fe0 */  32, 32, 32, 32, 32,109,107,100,105,114, 10, 48, 48, 48, 48, 48,
/* 0x4ff0 */  48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x5000 */  32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48,
/* 0x5010 */  48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5020 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x5030 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x5040 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5050 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49, 50, 48,
/* 0x5060 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5070 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x5080 */  48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x5090 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x50a0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32, 82,
/* 0x50b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x50c0 */  32,111,112,101,110, 10, 48, 48, 48, 48, 48, 49, 54, 48, 32, 82,
/* 0x50d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x50e0 */  32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 54, 99, 32, 82,
/* 0x50f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5100 */  32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 49, 55, 56, 32,
/* 0x5110 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5120 */  32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 49,
/* 0x5130 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x5150 */  10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x5160 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x5170 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 52,
/* 0x5180 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5190 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x51a0 */  48, 48, 48, 48, 49, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x51b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x51c0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 99, 52, 32, 82,
/* 0x51d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x51e0 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49,100,
/* 0x51f0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5200 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x5210 */  48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5220 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x5230 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 56, 32,
/* 0x5240 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5250 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x5260 */  48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5270 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121,
/* 0x5280 */  10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x5290 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112,
/* 0x52a0 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65,
/* 0x52b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x52c0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x52d0 */  50, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x52e0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x52f0 */  68, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82, 77,
/* 0x5300 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x5310 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 51,
/* 0x5320 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5330 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x5340 */  48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5350 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,
/* 0x5360 */ 112,121, 10, 48, 48, 48, 48, 48, 50, 54, 99, 32, 82, 95, 65, 82,
/* 0x5370 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x5380 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x5390 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x53a0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x53b0 */  10, 48, 48, 48, 48, 48, 50, 56, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x53c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112,
/* 0x53d0 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 57, 48, 32, 82, 95, 65,
/* 0x53e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,
/* 0x53f0 */ 101,116,112,105,100, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32, 82,
/* 0x5400 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x5410 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x5420 */  48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x5430 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x5440 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 98, 48, 32, 82, 95, 65,
/* 0x5450 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x5460 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x5470 */  50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x5480 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x5490 */  68, 10, 48, 48, 48, 48, 48, 50,102, 48, 32, 82, 95, 65, 82, 77,
/* 0x54a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x54b0 */ 102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 50,
/* 0x54c0 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x54d0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x54e0 */  10, 48, 48, 48, 48, 48, 51, 48, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x54f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,
/* 0x5500 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 51, 49,
/* 0x5510 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5520 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x5530 */  48, 48, 48, 48, 48, 51, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5540 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x5550 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32,
/* 0x5560 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5570 */  32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 51, 52, 52, 32,
/* 0x5580 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5590 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x55a0 */  48, 48, 48, 51, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x55b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x55c0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 54, 48, 32, 82, 95,
/* 0x55d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x55e0 */ 109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 54, 99,
/* 0x55f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5600 */  32, 32, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 51, 55,
/* 0x5610 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5620 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x5630 */  48, 48, 48, 48, 48, 51, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5640 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x5650 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 99, 32,
/* 0x5660 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5670 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x5680 */  48, 48, 48, 51, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5690 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x56a0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 52, 32, 82, 95,
/* 0x56b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56c0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x56d0 */  48, 51, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x56e0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x56f0 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 98, 99, 32, 82, 95, 65, 82,
/* 0x5700 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x5710 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x5720 */  99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5730 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x5740 */  10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x5750 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x5760 */ 117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48,
/* 0x5770 */  51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x5780 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x5790 */  68, 10, 48, 48, 48, 48, 48, 51,102, 48, 32, 82, 95, 65, 82, 77,
/* 0x57a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x57b0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,102,
/* 0x57c0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x57d0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x57e0 */  48, 48, 48, 48, 48, 52, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x57f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x5800 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 49, 52, 32,
/* 0x5810 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5820 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x5830 */  48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5840 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x5850 */  48, 48, 48, 52, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5860 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x5870 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95,
/* 0x5880 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5890 */ 117,110,108,105,110,107, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32,
/* 0x58a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x58b0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x58c0 */  48, 48, 48, 52, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x58d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x58e0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 53, 48, 32, 82, 95,
/* 0x58f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5900 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x5910 */  48, 48, 48, 52, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5920 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x5930 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 55, 48, 32, 82, 95,
/* 0x5940 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5950 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x5960 */  48, 52, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x5970 */  32, 32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101,
/* 0x5980 */  10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x5990 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x59a0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 56, 56,
/* 0x59b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x59c0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x59d0 */  48, 48, 48, 48, 52, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x59e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,107, 10,
/* 0x59f0 */  48, 48, 48, 48, 48, 52, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x5a00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101,
/* 0x5a10 */  10, 48, 48, 48, 48, 48, 52, 99, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5a20 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,
/* 0x5a30 */ 107, 10, 48, 48, 48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77,
/* 0x5a40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x5a50 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,100,
/* 0x5a60 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5a70 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x5a80 */ 107, 10, 48, 48, 48, 48, 48, 52,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x5a90 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x5aa0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,102,
/* 0x5ab0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52,
/* 0x5ad0 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5ae0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x5af0 */  10, 48, 48, 48, 48, 48, 53, 49, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5b00 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112,
/* 0x5b10 */  10, 48, 48, 48, 48, 48, 53, 50, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5b20 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x5b30 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 51, 52,
/* 0x5b40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5b50 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 10,
/* 0x5b60 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5b70 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x5b80 */  88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5b90 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5ba0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95,
/* 0x5bb0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5bc0 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x5bd0 */  50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x5be0 */  32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x5bf0 */ 101, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x5c00 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x5c10 */  95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 51, 99, 32,
/* 0x5c20 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x5c30 */  32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x5c40 */  48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x5c50 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x5c60 */  78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65,
/* 0x5c70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x5c80 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x5c90 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5ca0 */  32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x5cb0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5cc0 */  32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x5cd0 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5ce0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78,
/* 0x5cf0 */  85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82,
/* 0x5d00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x5d10 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,100, 56,
/* 0x5d20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x5d30 */  32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x5d40 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5d50 */  32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x5d60 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5d70 */  32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48,
/* 0x5d80 */  48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5d90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78,
/* 0x5da0 */  85, 88, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82,
/* 0x5db0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109,
/* 0x5dc0 */  97,112, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82,
/* 0x5dd0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,
/* 0x5de0 */ 116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 10, 82, 69, 76,
/* 0x5df0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5e00 */  70, 79, 82, 32, 91, 69, 88, 80, 95, 72, 69, 65, 68, 93, 58, 10,
/* 0x5e10 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5e20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5e30 */  10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5e40 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x5e50 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95,
/* 0x5e60 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e70 */  69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x5e80 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x5e90 */  32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x5ea0 */  48, 48, 48, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x5eb0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x5ec0 */  10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x5ed0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x5ee0 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95,
/* 0x5ef0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f00 */  69, 88, 80, 95, 72, 69, 65, 68, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5f10 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5f20 */  32, 91, 69, 88, 80, 95, 84, 65, 73, 76, 93, 58, 10, 79, 70, 70,
/* 0x5f30 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5f40 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5f50 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x5f60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x5f70 */  76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5f80 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69,
/* 0x5f90 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5fb0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65,
/* 0x5fc0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5fd0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95,
/* 0x5fe0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ff0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82,
/* 0x6000 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6010 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32,
/* 0x6020 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6030 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 53, 56,
/* 0x6040 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6050 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x6060 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6070 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6080 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x6090 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x60a0 */  48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x60b0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x60c0 */  48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x60d0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x60e0 */  48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x60f0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x6100 */  48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6110 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x6120 */  48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6130 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x6140 */  48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6150 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x6160 */  10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x6170 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6180 */  69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77,
/* 0x6190 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x61a0 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82,
/* 0x61b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x61c0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65,
/* 0x61d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x61e0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95,
/* 0x61f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6200 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x6210 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6220 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 99, 32,
/* 0x6230 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6240 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101, 52,
/* 0x6250 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6260 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x6270 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6280 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49,
/* 0x6290 */  49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x62a0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x62b0 */  49, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x62c0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 10, 82, 69, 76,
/* 0x62d0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x62e0 */  70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70,
/* 0x62f0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6300 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6310 */  48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6320 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x6330 */  48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6340 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x6350 */  48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6360 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x6370 */  10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x6380 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6390 */  68, 10, 48, 48, 48, 48, 48, 48, 53, 56, 32, 82, 95, 65, 82, 77,
/* 0x63a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x63b0 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 52, 32, 82, 95, 65, 82,
/* 0x63c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x63d0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65,
/* 0x63e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x63f0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95,
/* 0x6400 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6410 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82,
/* 0x6420 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6430 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32,
/* 0x6440 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6450 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 99,
/* 0x6460 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6470 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x6480 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6490 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x64a0 */  97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x64b0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x64c0 */  48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x64d0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x64e0 */  48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x64f0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x6500 */  48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6510 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x6520 */  48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6530 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x6540 */  48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6550 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x6560 */  48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6570 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x6580 */  10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x6590 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x65a0 */  68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x65b0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66,
/* 0x65c0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x65d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x65e0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65,
/* 0x65f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6600 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95,
/* 0x6610 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6620 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82,
/* 0x6630 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6640 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 56, 32,
/* 0x6650 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6660 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 53, 99,
/* 0x6670 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6680 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x6690 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x66a0 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x66b0 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x66c0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x66d0 */  48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x66e0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x66f0 */  48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x6700 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x6710 */  48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6720 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x6730 */  48, 48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6740 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x6750 */  48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6760 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x6770 */  48, 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6780 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x6790 */  10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x67a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x67b0 */  66, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77,
/* 0x67c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x67d0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 65, 82,
/* 0x67e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x67f0 */  86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6800 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x6810 */  65, 95, 68, 65, 73, 83, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6820 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6830 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6840 */  48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6850 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x6860 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6870 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 77, 65, 73,
/* 0x6880 */  78, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6890 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x68a0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x68b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x68c0 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 51, 48,
/* 0x68d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x68e0 */  32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48,
/* 0x68f0 */  48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6900 */  32, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48,
/* 0x6910 */  48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6920 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x6930 */  48, 48, 48, 48, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6940 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78,
/* 0x6950 */  10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x6960 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77,
/* 0x6970 */  65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65,
/* 0x6980 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x6990 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32,
/* 0x69a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x69b0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48,
/* 0x69c0 */ 100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x69d0 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x69e0 */  48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x69f0 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10,
/* 0x6a00 */  48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6a10 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x6a20 */  73, 78, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82,
/* 0x6a30 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x6a40 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82,
/* 0x6a50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a60 */  32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 49,
/* 0x6a70 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6a80 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x6a90 */  48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x6aa0 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x6ab0 */  48, 48, 48, 48, 49, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6ac0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x6ad0 */  78, 10, 48, 48, 48, 48, 48, 49, 51, 52, 32, 82, 95, 65, 82, 77,
/* 0x6ae0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x6af0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 52, 48, 32, 82, 95,
/* 0x6b00 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b10 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 53, 56,
/* 0x6b20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6b30 */  32, 32, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48,
/* 0x6b40 */  48, 49, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x6b50 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x6b60 */  48, 48, 48, 48, 49, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6b70 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x6b80 */  78, 10, 48, 48, 48, 48, 48, 49, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x6b90 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x6ba0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 57, 56, 32, 82, 95,
/* 0x6bb0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bc0 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 49, 98, 52,
/* 0x6bd0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6be0 */  32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48,
/* 0x6bf0 */  49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6c00 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x6c10 */  48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6c20 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10,
/* 0x6c30 */  48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6c40 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,
/* 0x6c50 */ 109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48,
/* 0x6c60 */  50, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x6c70 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48,
/* 0x6c80 */  48, 48, 48, 50, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6c90 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116,
/* 0x6ca0 */  10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x6cb0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,
/* 0x6cc0 */ 101, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77,
/* 0x6cd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x6ce0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 50, 98, 52, 32, 82, 95,
/* 0x6cf0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d00 */  80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 50, 99, 48, 32, 82,
/* 0x6d10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d20 */  32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 50, 99, 56,
/* 0x6d30 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6d40 */  32, 32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48, 48,
/* 0x6d50 */  48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6d60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 80,109, 97,112, 10, 48, 48,
/* 0x6d70 */  48, 48, 48, 50,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x6d80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48,
/* 0x6d90 */  48, 48, 48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6da0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x6db0 */  78, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77,
/* 0x6dc0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 80, 70, 95,
/* 0x6dd0 */ 116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 51, 49, 99,
/* 0x6de0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x6df0 */  32, 32, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48,
/* 0x6e00 */  48, 51, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x6e10 */  32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x6e20 */ 109, 97,115,107, 10, 48, 48, 48, 48, 48, 51, 57, 48, 32, 82, 95,
/* 0x6e30 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e40 */ 109,109, 97,112, 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95,
/* 0x6e50 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e60 */ 109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32,
/* 0x6e70 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6e80 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 51,
/* 0x6e90 */ 101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x6ea0 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x6eb0 */  48, 48, 52, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x6ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10,
/* 0x6ed0 */  48, 48, 48, 48, 48, 52, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x6ee0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65,
/* 0x6ef0 */  73, 78, 10, 48, 48, 48, 48, 48, 52, 53, 52, 32, 82, 95, 65, 82,
/* 0x6f00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x6f10 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52, 57, 56, 32, 82,
/* 0x6f20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f30 */  32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52, 97,
/* 0x6f40 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x6f50 */  32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x6f60 */  48, 52, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x6f70 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48,
/* 0x6f80 */  48, 48, 48, 48, 52, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x6f90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,112,114,101,112, 95, 83,
/* 0x6fa0 */  69, 76,105,110,117,120, 10, 48, 48, 48, 48, 48, 52, 99, 56, 32,
/* 0x6fb0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x6fc0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 52,
/* 0x6fd0 */ 100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x6fe0 */  32, 32, 32, 32, 32,117,110,100,101,114,108, 97,121, 10, 48, 48,
/* 0x6ff0 */  48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7000 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78,
/* 0x7010 */  10, 48, 48, 48, 48, 48, 53, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x7020 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77,
/* 0x7030 */  65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 48, 99, 32, 82, 95, 65,
/* 0x7040 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x7050 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 49, 52, 32,
/* 0x7060 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x7070 */  32, 32,103,101,116, 95,115,121,115, 95,109,117,110,109, 97,112,
/* 0x7080 */  10, 48, 48, 48, 48, 48, 53, 50, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x7090 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 77,
/* 0x70a0 */  65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 51, 56, 32, 82, 95, 65,
/* 0x70b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x70c0 */  79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53, 53, 99, 32,
/* 0x70d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x70e0 */  32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 53,
/* 0x70f0 */  55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7100 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x7110 */  48, 48, 53, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x7120 */  32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112,
/* 0x7130 */  95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 53, 97, 56,
/* 0x7140 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7150 */  32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 53, 99,
/* 0x7160 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x7170 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 53,100,
/* 0x7180 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x7190 */  32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 53,
/* 0x71a0 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x71b0 */  32, 32, 32, 32, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48,
/* 0x71c0 */  48, 48, 54, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x71d0 */  32, 32, 32, 32, 32, 32, 32, 32,102,105,110,105, 95, 83, 69, 76,
/* 0x71e0 */ 105,110,117,120, 10, 48, 48, 48, 48, 48, 54, 49, 56, 32, 82, 95,
/* 0x71f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7200 */  83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 54, 50, 52,
/* 0x7210 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7220 */  32, 32, 32, 80,117,110,109, 97,112, 10, 10, 82, 69, 76, 79, 67,
/* 0x7230 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7240 */  82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10,
/* 0x7250 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7270 */  10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x7280 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x7290 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x72a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x72b0 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69,
/* 0x72c0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x72d0 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x72e0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x72f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x7300 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65,
/* 0x7310 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7320 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x7330 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7340 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7350 */  48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7360 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7370 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x7380 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7390 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x73a0 */  48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x73b0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x73c0 */  48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77,
/* 0x73d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x73e0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56,
/* 0x73f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7400 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7410 */  48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7420 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7430 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65,
/* 0x7440 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7450 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x7460 */  99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7470 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7480 */  48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7490 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x74a0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82,
/* 0x74b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x74c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x74d0 */  48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x74e0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x74f0 */  48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77,
/* 0x7500 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7510 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52,
/* 0x7520 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7530 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7540 */  48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7550 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7560 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65,
/* 0x7570 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7580 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x7590 */  52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x75a0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x75b0 */  48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x75c0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x75d0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82,
/* 0x75e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x75f0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7600 */  48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7610 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7620 */  48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x7630 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7640 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52,
/* 0x7650 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7660 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7670 */  48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7680 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7690 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65,
/* 0x76a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x76b0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x76c0 */  56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x76d0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x76e0 */  48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x76f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7700 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82,
/* 0x7710 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7720 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7730 */  48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7740 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7750 */  48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77,
/* 0x7760 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7770 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56,
/* 0x7780 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7790 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x77a0 */  48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x77b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x77c0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65,
/* 0x77d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x77e0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x77f0 */  54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7800 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7810 */  48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7820 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7830 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82,
/* 0x7840 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7850 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7860 */  48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7870 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7880 */  48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77,
/* 0x7890 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x78a0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99,
/* 0x78b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x78c0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x78d0 */  48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x78e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x78f0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65,
/* 0x7900 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7910 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x7920 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7930 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7940 */  48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7950 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7960 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82,
/* 0x7970 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7980 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7990 */  48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x79a0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x79b0 */  48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x79c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x79d0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99,
/* 0x79e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x79f0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7a00 */  48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7a10 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7a20 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65,
/* 0x7a30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7a40 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x7a50 */  52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7a60 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7a70 */  48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7a80 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7a90 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82,
/* 0x7aa0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7ab0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7ac0 */  48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7ad0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7ae0 */  48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77,
/* 0x7af0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7b00 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99,
/* 0x7b10 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7b20 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7b30 */  48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7b40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7b50 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65,
/* 0x7b60 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7b70 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x7b80 */  55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7b90 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7ba0 */  48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7bb0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7bc0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82,
/* 0x7bd0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7be0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7bf0 */  48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7c00 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7c10 */  48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77,
/* 0x7c20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7c30 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52,
/* 0x7c40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7c50 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7c60 */  48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7c70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7c80 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65,
/* 0x7c90 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7ca0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x7cb0 */  55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x7cc0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x7cd0 */  48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x7ce0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x7cf0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82,
/* 0x7d00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x7d10 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x7d20 */  48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x7d30 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x7d40 */  48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77,
/* 0x7d50 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x7d60 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99,
/* 0x7d70 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x7d80 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x7d90 */  48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x7da0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7db0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65,
/* 0x7dc0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x7dd0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x7de0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7df0 */  82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10,
/* 0x7e00 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7e10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7e20 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x7e30 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x7e40 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32,
/* 0x7e50 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x7e60 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x7e70 */  48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x7e80 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x7e90 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82,
/* 0x7ea0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x7eb0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x7ec0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x7ed0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x7ee0 */  48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x7ef0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x7f00 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95,
/* 0x7f10 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7f20 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x7f30 */  49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x7f40 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x7f50 */  10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x7f60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x7f70 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 56, 32,
/* 0x7f80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x7f90 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x7fa0 */  48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x7fb0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x7fc0 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82,
/* 0x7fd0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x7fe0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52,
/* 0x7ff0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x8000 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x8010 */  48, 48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x8020 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x8030 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 53, 48, 32, 82, 95,
/* 0x8040 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8050 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x8060 */  49, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x8070 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x8080 */  10, 48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x8090 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x80a0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 99, 32,
/* 0x80b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x80c0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x80d0 */  48, 48, 49, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x80e0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x80f0 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82,
/* 0x8100 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x8110 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99,
/* 0x8120 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x8130 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x8140 */  48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x8150 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x8160 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 52, 32, 82, 95,
/* 0x8170 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8180 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x8190 */  49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x81a0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x81b0 */  10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x81c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x81d0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101, 99, 32,
/* 0x81e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x81f0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x8200 */  48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x8210 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x8220 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65, 82,
/* 0x8230 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x8240 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52,
/* 0x8250 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x8260 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x8270 */  48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x8280 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x8290 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 53, 48, 32, 82, 95,
/* 0x82a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x82b0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x82c0 */  50, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x82d0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x82e0 */  10, 48, 48, 48, 48, 48, 50, 56, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x82f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x8300 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 99, 32,
/* 0x8310 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x8320 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x8330 */  48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x8340 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x8350 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82,
/* 0x8360 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x8370 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100,
/* 0x8380 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x8390 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x83a0 */  48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x83b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x83c0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,102, 52, 32, 82, 95,
/* 0x83d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x83e0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x83f0 */  51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x8400 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x8410 */  10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x8420 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x8430 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 50, 99, 32,
/* 0x8440 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x8450 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x8460 */  48, 48, 51, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x8470 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x8480 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 56, 32, 82, 95, 65, 82,
/* 0x8490 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x84a0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55,
/* 0x84b0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x84c0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x84d0 */  48, 48, 48, 48, 51, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x84e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x84f0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 57, 99, 32, 82, 95,
/* 0x8500 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8510 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x8520 */  51, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x8530 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x8540 */  10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x8550 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x8560 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32,
/* 0x8570 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x8580 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x8590 */  48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x85a0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x85b0 */  49, 48, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82, 95, 65, 82,
/* 0x85c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x85d0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 49,
/* 0x85e0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x85f0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x8600 */  48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x8610 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x8620 */  69, 67, 49, 48, 10
};
