{****************************************************************************}
{*                           Jednotka LACRT                                 *}
{*                                                                          *}
{* Toto je takove skladiste nejruznejsich, potencialne uzitecnych, drobnych *}
{* procedur a utilit pouzitelnych v jakemkoliv programu.                    *}
{* Rada zde deklarovanych funkci ma sve protejsky v jendotce SysUtils ve FPC*}
{* ale tato jednotka je plne obojzivelna a lze ji prelozit i pod TP/BP      *}
{*    Dalsi problem je, ze rade procedur by vice sluselo presunuti do       *}
{* specializovanych unitek. Pro prakticnost a primocarost to ale nechavam   *}
{* tak, jak to je.                                                          *}
{****************************************************************************}

{$N+}
{$IFDEF FPC}
   {$CALLING OLDFPCCALL}
   {$ASMMODE INTEL}
   {$H-}
   {$IFDEF VER2}{$DEFINE NEWFPC}{$ENDIF}
   {$IFDEF VER3}{$DEFINE NEWFPC}{$ENDIF}
{$ENDIF}
(*  {$M 24000,0,655360}  *)
unit Lacrt;

interface
uses Dos;



type
{ansistring = string;}
pstring = ^string;
{$IFNDEF FPC}ansistring = string;dword = longint;pbyte = ^byte;
   {$ELSE}
      {$IFNDEF ANSISTRINGROUTINES}
       {ansistring = string;}
      {$ENDIF}
   {$ENDIF}


{= KONVERZNI FUNKCE =========================================================}

Function Hex2Dec(s:string):longint;
Function Dec2Hex(l:longint):string;
Function HexStr(l:longint):string;
Function Dword2Real(d:longint):comp;
{Dword prevede na real. Predevsim resi problem s Turbo pascalem, ktery vnitrne
 dword nezna a ja ho jen emuluji pres longint. V takovem pripade se totiz
 muze stavat, ze vetsi hodnoty budou prtecena jako zaporna cisla a tak musime
 vymyslet figl, jak i je korektne prevest na real/comp}
Function NaPstring(s:string):pointer;      {ze stringu udela pstring na heapu}
Function ZrusPstring(p:pstring):pointer;   {zrusi pstring}
function MyVal(S:string):longint;
function MyStr(Cislo:longint):string;
{ciselnou hodnotu prevede na retezcovou}
function Mystr2(a:longint;nakolik:byte):string;
{to same, ale retezec je zleva zarovnan mezerami}
function Mystr3(a:longint;nakolik:byte):string;
{to same, ale retezec je zleva zarovnan nulami}
Procedure ExtVal(s:string;a,b:byte;var i:integer;var j:integer);
{nejaky specielni prevod retezce na cisla}
Function Prohod_Endianitu_Retezce(s:string):string;
{prohodi 1.znak s druhym, 3.znak se ctvrtym, 5.znak s sestym, a tak dale}
Procedure Prohod_Endianitu_Pcharu(p:pchar;d:longint);
{prohodi 1.znak s druhym, 3.znak se ctvrtym, 5.znak s sestym, a tak dale}
function SwapEndianW(AValue:Word):Word;
{provede konverzi endianity u wordu}
function SwapEndianL(AValue:longint):longint;
{provede konverzi endianity u longintu}
function SwapEndianD(AValue:DWord):DWord;
{provede konverzi endianity u dwordu}
Function StrPas(p:pchar):string;
{Provede konverzi z PCharu na pascalovsky string}
Function Word2String(w:word):string;
{word rozepise na jednobajtovy ci dvobajtovy retezec}
Procedure Byte2Pointer(b:byte;p:pointer);
{jednobajtovou hodnotu ulozi na adresu P}
Function Pointer2Byte(p:pointer):byte;
{Z adresy P vytahne jednobajtovou hodnotu}
Procedure Word2Pointer(w:word;p:pointer);
{dvojbajtovou hodnotu ulozi na adresu P}
Function Pointer2Word(p:pointer):word;
{Z adresy P vytahne jednobajtovou hodnotu}
Procedure Longint2Pointer(l:longint;p:pointer);
{ctyrbajtovou hodnotu ulozi na adresu P}
Function Pointer2Longint(p:pointer):longint;
{Z adresy P vytahne jednobajtovou hodnotu}
Procedure PripravPrevodniTabulky;
Procedure OpatrnePrevodniTabulky(b:boolean);
{pripravi DOSove tabulky k prevodu narodnich znaku}
Procedure ZjistiCodePage(var cp,ccode:word);

type ASCIIprevodni_tabulka = packed array[0..255] of char;
     pASCIIprevodni_tabulka=^ASCIIprevodni_tabulka;
     UNIprevodni_tabulka = packed array[0..2603] of byte;
     pUNIprevodni_tabulka = ^UNIprevodni_tabulka;

     putf8conv = ^utf8conv;
     utf8conv = packed array[128..255] of word;

     phighascii = ^highascii;
     highascii = packed array[128..255] of byte;

     putf8convinv = ^utf8convinv;
     utf8convinv = packed array[128..65535] of byte;

var
DOS_test_male_na_velke:ASCIIprevodni_tabulka;
DOS_test_velke_na_male:ASCIIprevodni_tabulka;
DOS_male_na_velke:ASCIIprevodni_tabulka;  {prevodni tabulky znaku z malych na velke}
DOS_velke_na_male:ASCIIprevodni_tabulka;  {a obracene}

male_na_velke:pASCIIprevodni_tabulka;
velke_na_male:pASCIIprevodni_tabulka;

const
{$I lacrt_mv.inc}
{$I lacrt_vm.inc}
UNI_male_na_velke:pUNIprevodni_tabulka = @_UNI_male_na_velke;
UNI_velke_na_male:pUNIprevodni_tabulka = @_UNI_velke_na_male;
UTF8_na_ascii_neznamy_znak:char = '_';
UTF8_2_ascii_error:longint = 0;
PSearch_error:longint = 0;
{}
oddelovac_tisicu:char = ' ';
oddelovac_desetitisicin:char = ' ';
desetinna_carka:char = '.';
skip_spaces_and_tab:boolean = true;
{Pouzivaji ji funkce "SkipBegSpaces, SkipEndSpaces a SkipAllspaces".
 Pokud je nastavena, tak vyrazuje i tabulatory}

{}
HexDigits:array[0..15] of char = '0123456789ABCDEF';
{----------------------------------------------------------------------------}


{= UNICODE ==================================================================}
Procedure pUTF8conv_to_pUTFconvinv(u:putf8conv;ui:putf8convinv);
Function Preklad_ascii_2_unicode(b:longint;u:putf8conv):longint;
Function Preklad_unicode_2_ascii(b:word;u:putf8conv;ui:putf8convinv;var err:boolean):byte;
Function Word2UTF8(w:longint):string;
Function UTF82longint(s:pchar;delka,poz:longint;var posun:byte):longint;
Function UTF8pchar_2_asciistring(p:pchar;pd:longint;u:putf8conv):string;
Function UTF8string_2_asciistring(s:string;u:putf8conv):string;
Function ASCIIpchar_2_UTF8pchar(p:pchar;u:putf8conv;var utf8_d:longint):pchar;
Function UNI_Convert_Up_or_down(tabulka:pUNIprevodni_tabulka;c:word):word;
Procedure NahrajUTF8Tabulku(s:string;var u:utf8conv);
Function UniLength(p:pchar):longint;
Function UniLengthPoz(p:pchar;delka:longint):longint;
Function UniLengthS(s:string):longint;
Function UniZnakVpred(p:pchar;i:longint):longint;
Function UniZnakZpet(p:pchar;i:longint):longint;
Function Je_unicode_sekvence(n:pointer;var posun:byte):byte;
Function UniConvert_Down(s:string):string;
Function UniConvert_Up(s:string):string;
Procedure Pchar2WidePchar(p:pchar;delka:longint;utf8:boolean;var u16:pchar;var u16_bajtu:longint);
Function Pchar2MegaWidePchar(p:pchar;del:longint;utf8:boolean;var u32:pchar;var u32_d:longint;var p_nad_ffff:longint):longint;
Procedure String2Widestring(s:string;utf8:boolean;var u16:string);
Procedure WidePChar2Pchar(p:pchar;delka:longint;utf8:boolean;var u8:pchar;var u8_bajtu:longint);
Procedure WidePChar2String(p:pchar;delka:longint;utf8:boolean;var u8:string);
Procedure SimpleString2WideString(s:string;var ws:string);


const default_uni_vm = 'UNI_VM.DAT';
      default_uni_mv = 'UNI_MV.DAT';
{0=nevim, 1=neni unicode, 2=je unicode}
{----------------------------------------------------------------------------}



{= RETEZCOVE FUNKCE =========================================================}
Function ZformatujUdaj(l:longint):string;
{z '35416384' udela '35 416 384'}
{Function FormatStr (const format: string; var params):string;}
Function FormatStr(const format:string;params:string):string;
{Zpracuje retezec Format stejne jako to delaji prekladace jazyka C}
  Function StrAdr(var p):string;
  {servisni funkce k FormatStr. Pomoci StrAdr se definuji parametry.
  pouziti: s:=FormatStr('Ziskavas %d bodu a jses %d-ty.',StrAdr(b)+StrAdr(n))}
Function DoplnRetezec(s:string;a:byte):string;
{retezec zprava doplni mezerami na delku A}
Function PocetRadu(l:longint):byte;
{z kolika cislic se sklada cislo I}
function Mid (S:ansistring;B,E:longint):string;
{vrati kus retezce od B do E}
Function PLength(p:pchar):longint;
{vrati delku PCharu}
Function Search(const Text:string;const S:string;Poz:longint):longint;
{hleda podretezec S v retezci Text}
function PSearch (Text:pchar;const S:string;Poz:longint):longint;
{to same, ale hleda uvnitr PCharu}
function SuperSearch (Text:ansistring;S:string;Poz:longint):longint;
Function Search2 (Text:string;const S1,S2:string;Poz:longint):longint;
function PSuperSearch(Text:pchar;S:string;Poz:longint):longint;
{$IFDEF FPC}
function SuperSearch (Text:ansistring;dt:longint;S:string;Poz:longint):longint;
{DT je delka textu. (Aby se to nemuselo zbytecne zjistovat znovu)}
function SuperSearch(Text:ansistring;dt:longint;S:string;Poz:longint;t:boolean):longint;
{Jestlize uz mame pripravenou tabulku znaku klice, tak ji muzem pouzit}
{Vytvorime ji procedurou KMP_INIT}
function PSuperSearch(Text:pchar;dt:longint;S:string;Poz:longint):longint;
function PSuperSearch(Text:pchar;dt:longint;S:string;Poz:longint;t:boolean):longint;
Procedure KMP_init(p:string);
{$ENDIF}
function BackSearch(text,s:string;pos:byte):byte;
{pos je pocet znaku od KONCE retezce. Vysledek dava taky od KONCE}
Function SearchBuf(p:pointer;len:longint;s:string):longint;
{Prohleda buffer pro retezec S. Pokud nenalezne, vraci -1}
Function Hmasis(text,s:string):byte;
{spocita, kolikrat je podretezec S v retezci TEXT}
Function SwapString(s:string):string;
{otoci retezec pozpatku}
Procedure Swap(var a,b:longint);
{prohodi cisla A a B}
Procedure Swaps(var a,b:string);
{prohodi retezce A a B}
Procedure NahradZnaky(var s:string;vych_znak,cil_znak:char);
{Vsechny znaky VYCH_ZNAK zameni za CIL_ZNAK}
Function KolikratZduplikovanyZnakNaPoz(var s:string;poz:byte):byte;
Function ReplaceStr(s:string;dindex:byte;t:string;sindex,delka:byte):string;
{vymeni kus retezce za jiny}
Function Char_Gb(c:char):char;
{zbavi ceske pismeno diakritiky (pouziva natvrdo zadanou tabulku)}
Function SimpleChar_Up(c:char):char;
Function SimpleChar_Down(c:char):char;
Procedure pConvert_Up(p,p2:pchar);
Function Convert_Up(s:string):string;
{prevede mala pismena na velka, vcetne narodnich znaku (pouzije tabulku DOS)}
Procedure pConvert_Down(p,p2:pchar);
Function Convert_Down(s:string):string;
{prevede velka pismena na mala, vcetne narodnich znaku (pouzije tabulku DOS)}
Function Same_after_lowcase(const s1,s2:string):boolean;
{S1 prevede na mala pismena a porovna ho s neupravovanym S2. Je tam provedena
 optimalizace, aby se do lowcase neprevadelo zbytecne}
Function Convert_Gb(s:string):string;
{zbavi ceska pismena diakritiky (pouziva natvrdo zadanou tabulku)}
Procedure PripravTridiciTabulku(t:string);
{Pripravi k pouziti definicni retezec pro abecedni razeni znaku}
Function CmpChar(a,b:char):shortint;
{Zjisti, ktery znak je dal v abecede (urcene definicnim retezcem (viz vyse))}
Function CmpString(var s1,s2:string):boolean;
{urci retezec co je dal v abecede (urcene definicnim retezcem (viz vyse))}
Function Xmezer(N:longint):string;
{retezec tvoreny N mezerami}
Function Xchar(n:longint;c:char):string;
{retezec tvoreny N znaky C}
Function SkipEndSpaces(S:ansistring):ansistring;
{zlikviduje uvodni mezery retezce}
Function SkipBegSpaces(S:ansistring):ansistring;
{zlikviduje koncove mezery retezce}
Function SkipBegEndSpaces(S:ansistring):ansistring;
{zlikviduje uvodni a koncove mezery retezce}
Function SkipAllSpaces(S:ansistring):ansistring;
{zlikviduje vsechny mezery v retezci}
Function PackSpaces(s:ansistring):ansistring;
{sekvence vice mezer za sebou nahradi jedinou mezerou}
Function Prvni_za_mezerami(p:pchar):longint;
{vrati index na prvni znak PCharu, co neni mezera ci tabulator}
Function Posledni_pred_mezerami(p:pchar;pd:longint):longint;
{vrati index na posledni znak PCharu, co neni mezera ci tabulator}
Function PocetSlov(s:string):integer;
{spocita pocet slov v retezci}
Function VratSlovo(s:string;n:byte):string;
{vrati N-te slovo z retezce}
Function IzolujSlovo(s:string;b:byte):string;
{izoluje slovo, ktere probiha pozici B v retezci S}
Function IzolujPrvniCislo(s:string):longint;
{izoluje prvni cislo z retezce}
Function Vysklonuj(a,b,c:string;n:longint):string;
{podle pravidel ceskeho jazyka vysklonuje podle poctu (1 pes, 2 psi, 5 psu)}
procedure SortDir (var s:array of string;N: Word);
{tridici funkce}
procedure QuickSort(var s:array of string;N: word);
{dalsi tridici funkce}
{----------------------------------------------------------------------------}



{= SYSTEMOVE FUNKCE =========================================================}
type
dpmiinfoblock = packed record  {ne vsechno info muze byt ziskano v TP (realnem modu)}
{0} major:byte;
{1} minor:byte;
{2} virtualizace:boolean;
{3} bits:byte;
{4} v86:boolean;
{5} dirtypagging:boolean;
{6} exceptions:boolean;
{7} mapdevices:boolean;
{8} baseremap:boolean;
{9} vendor_version_major:byte;
{A} vendor_version_minor:byte;
{B} present:boolean;
{C} in_protected_mode:boolean;
{D} vendor:string[126];
    end;

const _zachyt_nedostatku_pameti:procedure = nil;
      Pocet_cyklu_na_citac:longint=0;
      procesor_zna_cpuid:byte=255;    {jeste nevime, zda proc. zna CPUID}

var     {nastavi se automaticky po spusteni}
DOSprepinac:char;           {znak prepinace DOSu}
EXEdir:string;              {nazev adresare s EXE}
EXEname:string;             {nazev EXE}
{CommandLine:string;}         {cela prikazova radka}
{$IFNDEF FPC}
stdout,stderr:text;         {pro kompatibilitu s Freepascalem}
{$ENDIF}                    {definuji vystupy StdOut a StdErr}

Procedure FPC_Vypni_Signaly_pro_CTRL_c_a_CTRL_Break;
{Tyka se jen FPC - vypne otravne vyskakovani z programu po zmacknuti
 CTRL-C, CTRL-\ a CTRL-Break}

Function Test_CPUID:boolean;
{zjisi, zda procesor zna instrukci CPUID}
Function CallCPUID(par_eax:longint;var fax,fbx,fcx,fdx:longint):boolean;
{Pokud procesor zna CPUID, tak ho zavola, ulozi vysledky a vrati TRUE.
 Kdyz nezna, tak vrati FALSE}
Procedure MyGetMem(var p:pointer;l:longint);
{alokuje pamet na heapu a na konec bloku na ascii 0. Uzitecne pro Pchary}
Procedure GetDPMIinfo(var d:dpmiinfoblock);
{zjisti par informaci o pripadnem DPMI prostredi a pameti vseobecne}
Function DetectMemory:word;
{Zjisti velikost instalovane RAM (v megabajtech)}
Function DetectBaseMemory:word;
{Zjisti velikost konvencni pameti (v kilobajtech)}
Procedure MoveToHighMemory(var data;kam:dword;pocet:word);
{Zkopiruje DATA do presne dane adresy (linearni) v horni pameti}
Procedure MoveFromHighMemory(odkud:dword;var data;pocet:word);
{Z dane adresy v horni pameti zkopiruje POCET bajtu do DATA}
Function Detect_XMS:boolean;
{Zjisti, mame-li k dispozici XMS pamet}
Function Detect_EMS:boolean;
{Zjisti, mame-li k dispozici EMS pamet}
Function Detect_VCPI:boolean;
{Zjisti, mame-li k dispozici VCPI sluzby}
Function Detect_VDS:boolean;
{Zjisti, mame-li k dispozici VDS sluzby}
Function ZjistiPrepinac:char;
Function FromTimer:dword;
Procedure TimerDelay(i:word);
{Pocka zadany pocet tiku z citace na Seg0040:$6C}
Procedure Cekej1us(usecs:word);
{Ceka jednu mikrosekundu}
Procedure Cekej(ms:word);
{Pocka zadany pocet milisekund. Muze byt rozhozeno prenastavenim preruseni}
Function Multitask:boolean;
{v multitaskovuch prostredich nabidne procesorovy cas jinym procesum
 Pokud je funkce podporovana, tak vrati TRUE (jinak false}
Procedure SoundOn(frekvence:word);
{Jako Sound z unitu Crt}
Procedure SoundOff;
{Jako NoSound z unitu Crt}
Procedure Sound(hz,ms:word);
{$IFNDEF FPC}
   Procedure FillWord(var a;w,h:word);
   Procedure FindClose(var r:SearchRec);
{$ENDIF}
Function Wildcard(S1,S2:String):Boolean;
{S1 je nazev, S2 maska. Funguje jen pro kratke nazvy souboru.}
Function GetCommandLine:string;
{vrati presne zneni prikazove radky}
Function LFN_is_or_not:boolean;
{jsou dostupne funkce "long file names" - LFN?}
function LFNParamStr(s:string;n:byte):string;
{vrati argument prikazove radky. Umi korektne pracovat s uvozovkami}
function LFNParamCount(s:string):integer;
{pocet argumentu prikazove radky. Umi korektne pracovat s uvozovkami}
procedure SetMemTop(MemTop: Pointer);
{Pomucka pred a po volani Exec. Uvolni pamet dcerinemu procesu}
Function Get_Windows_version:byte;
{zjisti pod jakou rodinou windows jsme (DOS, win3.x, win 9x, winNT)}
Function Get_OS_Vendor_ID:byte;
{FreeDOS: $FD, MS-DOS: $FF, IBM-DOS: $00}
Function Get_OS_type:string;
{Vraci textovy retezec upresnujici pod kterym OS a jakou verzi bezime}
Function Get_FreeDOS_version_string:string;
{Pokud jsme pod FreeDOSem, tak vygeneruje retezec obsahuji verzi}
Function Get_CMOS_byte(index:byte):byte;
{Vrati zadany bajt z pameti CMOS}

{Blok funkci pro pouziti s windows 9x}
procedure Windows_SetFocusTo(id:word);
procedure Windows_SetFocus;
function Windows_GetVMID:word;
Function Windows_GetApplicationTitle:string;
Function Windows_GetVMTitle:string;
procedure Windows_SetApplicationTitle(s:string);
procedure Windows_SetVMTitle(s:string);
procedure Windows_AcknowledgeClose;
procedure Windows_CancelClose;
procedure Windows_EnableClose;
procedure Windows_DisableClose;
function Windows_QueryClose:byte;
{----------------------------------------------------------------------------}



{ = OBRAZOVKA (PREVAZNE V TEXTOVEM MODU) ====================================}
Function Je_TextovyRezim:boolean;
Function SirkaObrazovky:byte;
Function VyskaObrazovky:byte;
Procedure DirectWrite(x,y,g:byte;s:string);
Procedure Kurzor_On(x,y:byte);
Procedure Kurzor_Off;
Function TextAdressOffset(x,y:byte):word;
Function ZjistiZnak(x,y:byte):byte;
Function ZjistiBarvu(x,y:byte):byte;
Procedure VypniPaprsek;
Procedure ZapniPaprsek;
Procedure PovolBlikani(blik:boolean);
Procedure PosunDolu(a,b,c,d,pocet,barva:byte);
Procedure PosunNahoru(a,b,c,d,pocet,barva:byte);
Procedure ZnakyVx(a,b,s,pp,pz:byte;c:char);
Procedure ZnakyVy(a,b,s,pp,pz:byte;c:char);
Procedure EpesniPozadi(pp,pz,styl:byte);
Function Mon2stringX(x,y,d:byte):string;
Function Mon2stringY(x,y,d:byte):string;
Procedure SmazVyrez(a,b,c,d,color:byte);

var
    povol_blik:boolean;     { je-li true,je sedmy bit popisu barvy vyuzit na }
                            { blikani,je-li false,muze mit pozadi barvy }
                            { 0-15   (jooo).Prednastavene je true.      }

{----------------------------------------------------------------------------}



{= KLAVESNICE ===============================================================}
Function KeyPress:boolean;
Function KeyRead:word;
Procedure BufferOff;
Procedure PockejNaKlavesu;
Procedure PockejNaEnter;
{Procedure Input(var s:string);}

const
{kody nekterych klaves }
  Tab       = 9;  Esc       = 27; Enter     = 13; Space     = 32;
  BackSpace = 8;  Del       = 339;Ins       = 338;Doprava   = 333;
  Doleva    = 331;Nahoru    = 328;Dolu      = 336;PageUp    = 329;
  PageDown  = 337;F1        = 315;F2        = 316;F3        = 317;
  F10       = 324;F11       = 389;F12       = 390;Home      = 327;
  Endkey    = 335;
  ShNumdoleva   = 52;ShNumdoprava  = 54;
  ShNumdolu     = 50;ShNumnahoru   = 56;
{----------------------------------------------------------------------------}


{= MATEMATICKE FUNKCE =======================================================}
Function Mocnina(co,naco:byte):longint;
Function rad(x:real):real;
Function stupne(x:real):real;
Function Tg(x:real):real;
Function Cotg(x:real):real;
Function FormNum(a:real;d:byte):string;
Function Str2Ptr(s:string):pointer;
Procedure Pol2Kar(x,y:integer;v,u:real;var i,j:integer);
{prevede polarni souradnice na kartezske}
Procedure Kar2Pol(x,y,i,j:longint;var v,u:real);
{prevede kartezske souradnice na polarni}
Function ArcSin(x:real):real;
Function ArcCos(x:real):real;
Function Obsah3u(a,b,c:real):real;
Function Fac(i:integer):longint;
Function Distance(X1,Y1,X2,Y2:double):double;
Function Uvnitr(x,y,x1,y1,x2,y2:longint):boolean;
{je bod uvnitr obdelnika?}
Function Prunik(ax1,ay1,ax2,ay2,bx1,by1,bx2,by2:longint):boolean;
{protinaji se obdelniky A a B?}
Procedure Clipping(var x,y:longint;x1,y1,x2,y2:longint);
{----------------------------------------------------------------------------}



{= DISKOVE FUNKCE ===========================================================}
procedure SetDisk(disk:byte);
function MyGetDisk:Byte;
Function MyGetDir:string;
Function StripDrive(s:string):char;
Function StripPath(s:string):string;
Function StripName(s:string):string;
Function StripExt(s:string):string;
Function StripNameExt(s:string):string;
Function StripPathName(s:string):string;
Function Get_His_fantom(c:char):byte;
{zjisti, ma-li jednotka svuj fantomovy obraz}
Function Get_Fantom_Drive:char;
{zjisti, jaka jednotka na disku je fantomova}
function LogDisk:string;
{Vypize seznam instalovanych disku}
Function LogDiskPlus:string;
{Vypize seznam instalovanych disku, ale bez fantomovych jednotek}
Function OpravFantom(c:char):char;
{Zkontroluje, zda urceni jednotky (napr. B:) je fantom a ev. prevede na real}
Function IS_drive_ready(dsk:char):boolean;
Function ZkontrolujCestu(var s:string):boolean;
Function ExistDrive(c:char):boolean;
Function ExistDir(s:string):boolean;
Function ExistFile(s:string):boolean;
Function MyFExpand(s:string):string;
{Jako FExpand, ale pohlida si fantomove jednotky}
Function VyhledejSoubor(s:string):string;
{hleda umisteni souboru S v akt.adr, EXE adr. a PATH}
Function GetTempDir:string;
{najde adresar podle promenne prostredi TEMP, ev. TMP}
Function GetDirForTEMPfiles:string;
{navrhne vhodny adresar pro docasne soubory}
Function DriveReady(c:char):boolean;
Function MakeDir(s:string):byte;
Procedure CopyFile(s,t:string);
Procedure EraseFile(s:string);
Function DriveName(c:char):string;
Function PrechodCesty(cesta,s:string):string;
Function FATtype(drive:char):string;
Function SerioveCislodisku(dsk:char):string;
Function Get_IOCTL_disk_info(dsk:char;maj,min:byte;var buffer):word;
Function Get_IOCTL_Fyz_Drive(dsk:char):byte;
Function Je_disk_vymenitelny(dsk:char):boolean;
Function Je_disk_zapisovatelny(dsk:char):boolean;
Function Get_IOCTL_Drive_Type(dsk:char):byte;
{zjisti typ jednotky/media (disketa, harddisk,...)}
Function Get_IOCTL_Media(dsk:char):byte;
Procedure VytvorSoubor(s:string;velikost:dword);
{V mziku vytvori soubor o zadane delce (klidne i pres GB)}
Function NactiRadkuTextovehoSouboru(var f:text;var p:pchar):longint;
Function TotalDiskSpace(c:char):real;
{celkova kapacita disku, umi hodnoty pres 2GB}
Function FreeDiskSpace(c:char):real;
{volna kapacita disku, umi hodnoty pres 2GB}
Function Zjisti_typ_disketovky(d:byte):byte;
{Zjisti typ instalovane disketove mechaniky (ne media). D muze byt 0 nebo 1}
{----------------------------------------------------------------------------}



{= DEBUGGING ================================================================}

const dbg_log_file:string='debuglog.txt';
      debuglevel:byte=0;

Procedure Debug;
Procedure Beep;
Procedure DbgLog(s:string);   {zapise jen kdyz je definovan flag DEBUG}
Procedure DbgLogX(s:string);  {zapise vzdy}
{$IFDEF DEBUG}
Procedure GetMem(var p;vel:longint);
{$ENDIF}
{----------------------------------------------------------------------------}


implementation
{$IFDEF FPC}uses Go32,Ports;{$ENDIF}

const kmp_max = 50;
      prepared_GDT_for_move:boolean=false;

type
    TdskNumInfo=packed record
    Level:word;
    SerialNum:longint;
    VolumeLabel:array[0..10] of char;
    FatType:array[0..7] of char;
    end;

Pmementry = ^mementry;
mementry = packed record
  base:array[1..2] of longint;  {00}
  delka:array[1..2] of longint; {08}
  typ:longint;                  {16}
  fill:array[0..16] of byte;    {20}
end;

gdt_type = packed record
{Pouzivano procedurami MoveToHighMemory a MoveFromHighMemory}
    {uvodni balast}
{00}intbios1:array[0..3] of longint;
    {popis zdroje}
{16}src_sglimit:word;
{18}src_base_15_0:word;
{20}src_base_23_16:byte;
{21}src_access:byte;
{22}src_pglimit:byte;
{23}src_base_31_24:byte;
    {popis cilu}
{24}dst_sglimit:word;
{26}dst_base_15_0:word;
{28}dst_base_23_16:byte;
{29}dst_access:byte;
{30}dst_pglimit:byte;
{31}dst_base_31_24:byte;
    {zaverezny balast}
{32}intbios2:array[0..3] of longint;
    {konec}
end;


PsortTable=^TSortTable;             {bude pouzito pro razeni pismen v abecede}
TsortTable=array[0..256] of byte;


var oldportvalue:byte;
    kmp_jump:array[0..kmp_max] of integer;
    _sysTridiciTbl:TSortTable;
    sysTridiciTbl:PSortTable;
    sysTridiciStr:string;

    gdt:gdt_type;

    {$IFDEF FPC}
    djgpp_hwint_flags : longint;external name '___djgpp_hwint_flags';
    {$ENDIF}

{----------------------------------------------------------------------------}
{definicni retezce pro razeni pismen v abecede}
const
trid_spol = '__!!##$$--00112233445566778899';
trid__ch = #255#255;
trid_eng = trid_spol+'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVxXyYzZ';
trid_czlat2 = trid_spol+'aAbBcCdDeEطfFgGhH'+trid__ch+'iIjJkKlLm'+
                        'MnNoOpPqQrRsStTuUvVxXyYzZ';

trid_czkam = trid_spol+'aAbBcCdDeEfFgGhH'+trid__ch+'iIjJkKlLmMn'+
                       'NoOpPqQrRsStTuUvVxXyYzZ';

trid_czwin = trid_spol+'aAbBcCdDeEfFgGhH'+trid__ch+'iIjJkKlLmMn'+
                       'NoOpPqQrRsStTuUvVxXyYzZ';

{trid_rudos = trid_spol+'𦆧'+
                       ''+
                       'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVxXyYzZ';

trid_ruwin = trid_spol+''+
                       ''+
                       'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVxXyYzZ';}
{----------------------------------------------------------------------------}


Procedure GetMem(var p;vel:longint);
begin
system.GetMem(pointer(p),vel);
{$IFDEF FPC}
if pointer(p)=nil then
   if _zachyt_nedostatku_pameti<>nil then _zachyt_nedostatku_pameti();
{$ELSE}
if pointer(p)=nil then
   if @_zachyt_nedostatku_pameti<>nil then _zachyt_nedostatku_pameti;
{$ENDIF}
end;

Function StripPath(s:string):string;
var p:pathstr;
    n:namestr;
    e:extstr;
begin
Fsplit(s,p,n,e);
StripPath:=p;
end;

Function StripDrive(s:string):char;
var t:string;
begin
t:=StripPath(s);
StripDrive:=t[1];
end;


Function StripName(s:string):string;
var p:pathstr;
    n:namestr;
    e:extstr;
begin
Fsplit(s,p,n,e);
StripName:=n;
end;

Function StripExt(s:string):string;
var p:pathstr;
    n:namestr;
    e:extstr;
begin
Fsplit(s,p,n,e);
StripExt:=e;
end;

Function StripNameExt(s:string):string;
var p:pathstr;
    n:namestr;
    e:extstr;
begin
Fsplit(s,p,n,e);
StripNameExt:=n+e;
end;

Function StripPathName(s:string):string;
var p:pathstr;
    n:namestr;
    e:extstr;
begin
Fsplit(s,p,n,e);
StripPathName:=p+n;
end;


Function SwapString(s:string):string;
var a,b:byte;
      t:string;
begin
a:=Length(s);
t:='';
for b:=a downto 1 do t:=t+s[b];
SwapString:=t;
end;

Function Mocnina(co,naco:byte):longint;
{
var a:longint;
    c:byte;
begin
a:=co;
if co=0 then begin Mocnina:=0;Exit;end;
if naco=0 then begin Mocnina:=1;Exit;end;
for c:=1 to naco-1 do a:=a*co;
Mocnina:=a;
end;
}
begin
Mocnina:=Round(Exp(longint(co)*Ln(longint(naco))));
end;


{$IFDEF FPC}
Function FromTimer:dword;assembler;
asm
mov eax,fs:[$400+$6c]
end;
{$ELSE}
Function FromTimer:dword;
begin
FromTimer:=MemL[Seg0040:$6c];
end;
{$ENDIF}


Procedure TimerDelay(i:word);
var d:dword;
begin
d:=FromTimer;
repeat until (FromTimer>d+i) or (FromTimer<i);
end;

Function ZformatujUdaj(l:longint):string;
var s,t:string;
      a:byte;
begin
t:='';
s:=MyStr(l);
while Length(s)>3 do
  begin
  a:=Length(s);
  t:=' '+Copy(s,a-2,3)+t;      { vezmeme 3 posledni cislice       }
  Delete(s,a-2,3);             { a z puvodniho retezce je smazeme }
  end;
t:=s+t;
ZformatujUdaj:=t;
end;

function Mid (S: ansistring; B,E: longint): string;
{Vraci cast podretezce S pocinaje B-tym znakem a E-tym konce}
begin
Mid:=Copy(s,b,e-b+1);
end;

Function Wildcard(S1,S2:String):Boolean;
Var STmp1 : String[8];     { S1 je nazev, S2 maska }
    STmp2 : String[3];
    SS1, SS2 : String[12];
    I,J : Integer;
begin
  STmp1:=Copy(S1,1,Pos('.',S1+'.'))+'????????';
  If (Pos('.',S1)>1) then STmp2:=Copy(S1,Pos('.',S1)+1,3)+'???' else
STmp2:='???';  For I:=1 to 8 do If STmp1[I]='*' then For J:=I to 8 do
STmp1[J]:='?';  For I:=1 to 3 do If STmp2[I]='*' then For J:=I to 3 do
STmp2[J]:='?';  SS1:=STmp1+'.'+STmp2;
  STmp1:=Copy(S2,1,Pos('.',S2+'.'))+'????????';
  If (Pos('.',S2)>1) then STmp2:=Copy(S2,Pos('.',S2)+1,3)+'???' else
STmp2:='???';  For I:=1 to 8 do If STmp1[I]='*' then For J:=I to 8 do
STmp1[J]:='?';  For I:=1 to 3 do If STmp2[I]='*' then For J:=I to 3 do
STmp2[J]:='?';  SS2:=STmp1+'.'+STmp2; WildCard:=False;
  For I:=1 to 12 do If (UpCase(SS1[I])<>UpCase(SS2[I])) and (SS2[I]<>'?') then
Exit;  WildCard:=True;
end;


procedure SetMemTop(MemTop: Pointer); assembler;
{Pomucka pred a po volani Exec. Uvolni pamet dcerinemu procesu}
{Pred Exec zadej: SetmemTop(Ptr(BufHeapPtr,0)); a po Exec
                  SetmemTop(Ptr(BufHeapEnd,0)); }
asm
{$IFNDEF FPC}
mov BX,MemTop.Word[0]
add BX,15
mov CL,4
shr BX,CL
add BX,MemTop.Word[2]
mov AX,PrefixSeg
sub BX,AX
mov ES,AX
mov AH,4AH
int 21H
{$ENDIF}
end;



function pSearch (Text:pchar;const S:string;Poz:longint):longint;
{ Funkce hleda string S v textu Text od pozice Pos (vcetne)}
var i, N: longint;
    c:char;
    d:boolean;

begin {Search}
PSearch_error:=0;
if poz<1 then poz:=1;
dec(poz,2);
N:=Length(S);       {delka hledaneho retezce}
repeat
d:=true;
for i:=1 to N do
   begin
   c:=text[poz+i];
   if c=#0 then    {narazili jsme na konec?}
      if s=#0
         then begin pSearch:=poz+2;Exit;end {a je to konec, co jsme hledali?}
         else begin            {nebo jsme hledali neco jineho?}
         PSearch_error:=poz+2; {v tom pripade mame chybovy stav}
         pSearch:=0;
         Exit;
         end
      else if c<>s[i] then begin inc(poz);d:=false;Break;end;
   end;
if D then begin pSearch:=poz+2;Exit;end;
until false;
end;


Function Search(const Text:string;const S:string;Poz:longint):longint;
var c:char;
    d:boolean;
    i,j,n,TN:longint;

begin
TN:=Length(text);
N:=Length(S);       {delka hledaneho retezce}

repeat
d:=true;
for i:=1 to N do
    begin
    j:=poz+i-1;
    if j>TN then begin Search:=0;Exit;end;
    c:=text[j];
    if c<>s[i] then begin inc(poz);d:=false;Break;end;
    end;
until D=true;
Search:=poz;
end;


Function Search2 (Text:string;const S1,S2:string;Poz:longint):longint;
var r,v1,v2:longint;
begin
if s1<>'' then v1:=Search(text,s1,poz) else v1:=maxlongint;
if s2<>'' then v2:=Search(text,s2,poz) else v2:=maxlongint;
if v1=0 then v1:=maxlongint;
if v2=0 then v2:=maxlongint;
if v1<v2 then r:=v1 else r:=v2;
if r=maxlongint then r:=0;
Search2:=r;
end;


procedure kmp_init(p:string);
var i,j,m : integer;
begin
m:= length(p);
kmp_jump[0]:= -1;
i:= 0;
j:= -1;
repeat
   while ((j>=0) and (p[i+1]<>p[j+1])) do j:=kmp_jump[j];
   inc(i);
   inc(j);
   if (p[i+1] = p[j+1])
      then kmp_jump[i+1] := kmp_jump[j+1]
      else kmp_jump[i]:= j;
until i=m;
end;


function SuperSearch_jadro(var Text:ansistring;dt:longint;var S:string;Poz:longint;t:boolean):longint;
{Je pouzit algoritmus KMP}
var i,j,m,n : integer;
    deget:string;
    {f:file;}

begin
{
assign(f,'dbgfile.dat');
rewrite(f,1);
blockwrite(f,text[1],dt);
close(f);
}

m:= length(s);
n:= dt;
i:= poz-1;
j:= 0;
if T then kmp_init(s);
if dt=0 then begin SuperSearch_jadro:=0;Exit;end;
repeat
   while ((j>=0)and (text[i+1] <> s[j+1])) do j:= kmp_jump[j];
   if j = m-1 then
      begin
      SuperSearch_jadro:=i-j+1;
      Exit;
      end;
   inc(i);
   inc(j);
until i = n;
SuperSearch_jadro:=0;
end;

function SuperSearch(Text:ansistring;S:string;Poz:longint):longint;
var dt:longint;
begin
dt:=Length(text);
SuperSearch:=SuperSearch_jadro(text,dt,s,poz,true);
end;

function PSuperSearch(Text:pchar;S:string;Poz:longint):longint;
var t:ansistring;
    i:byte;
begin
{$IFDEF FPC}
t:=text;
{$ELSE}
i:=Plength(text);
t[0]:=char(i);
Move(text,t[1],i);
{$ENDIF}
PSuperSearch:=SuperSearch(t,s,poz);
end;

{$IFDEF FPC}
function SuperSearch(Text:ansistring;dt:longint;S:string;Poz:longint):longint;
begin
SuperSearch:=SuperSearch_jadro(text,dt,s,poz,true);
end;

function PSuperSearch(Text:pchar;dt:longint;S:string;Poz:longint):longint;
var t:ansistring;
    x:string;
    i:longint;
    {f:file;}

begin
t:=text;
if dt<0 then dt:=Length(t);
{
assign(f,'dbgdbg.dat');
rewrite(f,1);
blockwrite(f,text[0],dt);
close(f);
}

PSuperSearch:=SuperSearch(t,dt,s,poz);
end;

function SuperSearch(Text:ansistring;dt:longint;S:string;Poz:longint;t:boolean):longint;
{Jestlize uz mame pripravenou tabulku znaku klice, tak ji muzem pouzit}
begin
SuperSearch:=SuperSearch_jadro(text,dt,s,poz,t);
end;

function PSuperSearch(Text:pchar;dt:longint;S:string;Poz:longint;t:boolean):longint;
var u:ansistring;
{Jestlize uz mame pripravenou tabulku znaku klice, tak ji muzem pouzit}
begin
u:=text;
PSuperSearch:=SuperSearch(u,dt,s,poz,t);
end;
{$ENDIF}


function BackSearch(text,s:string;pos:byte):byte;
var lt,ls,i: byte;
begin
lt:=Length(text);
ls:=Length(s);
if pos-ls+1<0 then pos:=ls;
if pos>lt then begin BackSearch:=0;Exit;end;
i:=pos;
while i <= lt do
   begin
   if s = Copy(text,lt-i+1,ls) then
      begin
      BackSearch := i;
      exit;
      end;
   inc(i);
   end;
BackSearch:=0;
end;

Function Hmasis(text,s:string):byte;
{ Funkce povi,kolik podretezcu <s> je v retezci <t> }
var k,pos,x:byte;
begin
k:=0;
pos:=1;
repeat
x:=Search(text,s,pos);
if x>0 then begin inc(k);pos:=x+length(s);end;
until x=0;
Hmasis:=k;
end;

{$IFDEF FPC}
{$IFDEF NEWFPC}
Function PLength(p:pchar):longint;
begin
PLength:=Length(p);
end;
{$ELSE}
Function PLength(p:pchar):longint;assembler;
asm
xor eax,eax
mov esi,p
@znova:
cmp byte [esi],0
je @konec
inc esi
inc eax
jmp @znova
@konec:
end;
{$ENDIF}
{$ELSE}
Function PLength(p:pchar):longint;
var q:pchar;
    l:longint;
begin
l:=0;
q:=p;
while q^<>#0 do begin inc(q);inc(l);end;
PLength:=l;
end;
{$ENDIF}

function SkipBegSpaces (S: ansistring): ansistring;
{pouziva globalni promennou "skip_spaces_and_tab". Kdyz je "true", coz je
 defaultni, tak vyrazuje i znak tabulator}
var
  i, N: Byte;
  d:string;

begin { SkipBegSpaces }
  i := 1;
  N := Length (S);
  if N>0 then
     begin
     if skip_spaces_and_tab=true then
        while (i < N) and (S[i] in [' ',#0,#9]) do inc(i)
        else
        while (i < N) and (S[i] in [' ',#0]) do inc(i);
     d:=Mid (S, i, N);
     SkipBegSpaces := d;
     end
     else SkipBegSpaces:='';
end;  { SkipBegSpaces }


Function Prvni_za_mezerami(p:pchar):longint;
var i:longint;
begin
if p=nil then begin Prvni_za_mezerami:=-1;Exit;end;
for i:=0 to maxlongint do
    begin
    if p[i]=#0 then begin Prvni_za_mezerami:=-1;Exit;end;
    if skip_spaces_and_tab=true then
       if (p[i]<>' ') and (p[i]<>#9) then begin Prvni_za_mezerami:=i;Exit;end
       else else
       if (p[i]<>' ') then begin Prvni_za_mezerami:=i;Exit;end
    end;
end;


Function Posledni_pred_mezerami(p:pchar;pd:longint):longint;
var i:longint;
begin
if p=nil then begin Posledni_pred_mezerami:=-1;Exit;end;
for i:=pd-1 downto 0 do
    begin
    if p[i]=#0 then begin Posledni_pred_mezerami:=0;Exit;end;
    if skip_spaces_and_tab=true then
       if (p[i]<>' ') and (p[i]<>#9) then begin Posledni_pred_mezerami:=i;Exit;end
       else else
       if (p[i]<>' ') then begin Posledni_pred_mezerami:=i;Exit;end
    end;
Posledni_pred_mezerami:=-1;
end;



function SkipEndSpaces (S: ansistring): ansistring;
{pouziva globalni promennou "skip_spaces_and_tab". Kdyz je "true", coz je
 defaultni, tak vyrazuje i znak tabulator}
var
  i: Byte;
  d:string;

begin { SkipEndSpaces }
  i := Length (S);
  if i>0 then
     begin
     if skip_spaces_and_tab=true then
        while (i > 0) and (S[i] in [' ',#0,#9]) do dec(i)
        else
        while (i > 0) and (S[i] in [' ',#0]) do dec(i);
     d:=Mid (S,1,i);
     SkipEndSpaces := d;
     end
     else SkipEndSpaces:='';
end;  { SkipEndSpaces }


Function SkipBegEndSpaces(S:ansistring):ansistring;
{pouziva globalni promennou "skip_spaces_and_tab". Kdyz je "true", coz je
 defaultni, tak vyrazuje i znak tabulator}
begin
SkipBegEndSpaces:=SkipBegSpaces(SkipEndSpaces(s));
end;


function SkipAllSpaces (S: ansistring): ansistring;
{pouziva globalni promennou "skip_spaces_and_tab". Kdyz je "true", coz je
 defaultni, tak vyrazuje i znak tabulator}
var
  i, N: Byte;
  Pom : string;
begin { SkipAllSpaces }
  i := 1;
  N := Length (S);
  if N>0 then
     begin
     Pom := '';
     if skip_spaces_and_tab=true
        then for i := 1 to N do
             if not (S[i] in [' ',#0,#9]) then Pom := Pom + S[i] else
        else for i := 1 to N do
             if not (S[i] in [' ',#0]) then Pom := Pom + S[i];
     SkipAllSpaces := Pom;
     end
     else SkipAllSpaces:='';
end;  { SkipAllSpaces }


Function PackSpaces(s:ansistring):ansistring;
var i,l:longint;
    t:ansistring;
begin
l:=Length(s);
i:=1;
t:='';
if l=0 then
   begin
   PackSpaces:='';
   Exit;
   end;
repeat
if s[i]=' ' then
   begin
   t:=t+' ';
   while s[i]=' ' do
      begin
      inc(i);
      if i>l then begin PackSpaces:=t;Exit;end;
      end;
   end;
while s[i]<>' ' do
   begin
   t:=t+s[i];
   inc(i);
   if i>l then begin PackSpaces:=t;Exit;end;
   end;
if i>l then begin PackSpaces:=t;Exit;end;
until 1=2;
end;

Function DoplnRetezec(s:string;a:byte):string;
var b,i:byte;
begin
b:=length(s);
for i:=b to a-1 do s:=s+' ';
DoplnRetezec:=s;
end;


Function SearchBuf(p:pointer;len:longint;s:string):longint;
var a,b,m:longint;
    q,r:pchar;
    shoda:boolean;

begin
m:=Length(s);
if m>len then begin SearchBuf:=-1;Exit;end;

b:=0;

repeat
q:=p;
inc(q,b);
shoda:=true;
for a:=1 to m do
    if s[a]<>q^ then begin shoda:=false;Break;end else inc(q);
if shoda then
   begin SearchBuf:=b;Exit;end;
inc(b);
until b+m>len;
SearchBuf:=-1;
end;


Function NaVelke_DOSem(s:string):string;
var r:registers;
begin
{$IFDEF FPC}
CopyToDOS(s[1],Length(s));
r.DS:=tb_segment;
r.DX:=tb_offset;
{$ELSE}
r.DS:=seg(s);
r.DX:=ofs(s);
{$ENDIF}
r.AX:=$6521;
r.CX:=Length(s);
MsDos(r);
{$IFDEF FPC}CopyFromDOS(s[1],Length(s));{$ENDIF}
NaVelke_DOSem:=s;
end;


Procedure PripravPrevodniTabulky;
var s:string;
    i:byte;
    tabulka_radne_instalovana:boolean;
begin
s:='';
for i:=0 to 255 do s:=s+char(i);
s:=NaVelke_DOSem(s);

Move(s[1],DOS_male_na_velke,256);
s:=NaVelke_DOSem(#255);
DOS_male_na_velke[255]:=s[1];

for i:=0 to 64 do DOS_velke_na_male[i]:=char(i);
for i:=65 to 90 do DOS_velke_na_male[i]:=char(i+32);
for i:=91 to 127 do DOS_velke_na_male[i]:=char(i);

tabulka_radne_instalovana:=true;
for i:=128 to 255 do
   if byte(DOS_male_na_velke[i])<128 then
      begin
      tabulka_radne_instalovana:=false;
      Break;
      end;

fillchar(DOS_velke_na_male[128],127,0);
for i:=128 to 255 do
    if DOS_velke_na_male[i]=#0 then
       begin
       DOS_velke_na_male[i]:=char(i);
       if DOS_male_na_velke[i]=char(i) then DOS_velke_na_male[i]:=char(i) else
          if byte(DOS_male_na_velke[i])>127 then
             DOS_velke_na_male[byte(DOS_male_na_velke[i])]:=char(i);
       end;

Move(DOS_velke_na_male,DOS_test_velke_na_male,sizeof(DOS_velke_na_male));
Move(DOS_male_na_velke,DOS_test_male_na_velke,sizeof(DOS_male_na_velke));

if not tabulka_radne_instalovana then
   begin
   for i:=128 to 255 do
      begin
      DOS_test_velke_na_male[i]:=char(i);
      DOS_test_male_na_velke[i]:=char(i);
      end;
   end;
end;


Procedure OpatrnePrevodniTabulky(b:boolean);
begin
if B then
   begin
   male_na_velke:=@DOS_test_male_na_velke;
   velke_na_male:=@DOS_test_velke_na_male;
   end
   else begin
   male_na_velke:=@DOS_male_na_velke;
   velke_na_male:=@DOS_velke_na_male;
   end;
end;


Procedure  ZjistiCodePage(var cp,ccode:word);
{Zjisti kod statu a kod pouzivane znakove sady}
var i:word;
    {$IFDEF FPC}r:TRealregs;{$ENDIF}
    a:array[0..255] of byte;

begin
{$IFDEF FPC}
r.es:=tb_segment;
r.eax:=$6501;
r.edi:=tb_offset;
r.ebx:=$ffff;
r.edx:=$ffff;
r.ecx:=256;
RealIntr($21,r);
CopyFromDOS(a,256);
{$ELSE}
asm
 lea di,a
 push ss
 pop es
 mov bx,0ffffh
 mov dx,0ffffh
 mov cx,256
 mov ax,6501h
 int 21h
end;
{$ENDIF}
cp:=a[3]+a[4]*256;
ccode:=a[5]+a[6]*256;
end;


{$IFDEF FPC}
Function UTF82longint(s:pchar;delka,poz:longint;var posun:byte):longint;assembler;
asm
dec poz
mov edi,posun
mov esi,s
add esi,poz

movzx eax,byte [esi]
cmp al,128
jae @vetsi_nebo_rovno128
    {jednobajtovy}
    mov bl,1
    mov [edi],bl   {posun:=1}
    movzx eax,al
    jmp @konec
@vetsi_nebo_rovno128:

cmp al,240
jae @vetsi_nebo_rovno240

cmp al,224
jae @vetsi_nebo_rovno224
    {dvojbajtovy}
    mov bl,2
    mov [edi],bl
    mov ecx,poz
    inc ecx
    cmp ecx,delka
    jbe @neni_vetsi_nez_delka
    mov eax,63       {UTF82word:=63 (znak ?) - ochrana pred nekorektnimi daty}
    jmp @konec
@neni_vetsi_nez_delka:
    and eax,63
    shl eax,6
    inc esi
    mov bl,[esi]
    and bl,63
    add al,bl
    jmp @konec

@vetsi_nebo_rovno224:
    {trojbajtovy}
    mov bl,3
    mov [edi],bl
    mov ecx,poz
    add ecx,2
    cmp ecx,delka
    jbe @neni_vetsi_nez_delka2
    mov eax,21       {UTF82word:=21 (znak ) - ochrana pred nekorektnimi daty}
    jmp @konec
@neni_vetsi_nez_delka2:
    and eax,15
    shl eax,12
    inc esi
    movzx ebx,byte [esi]
    and ebx,63
    shl ebx,6
    add eax,ebx
    inc esi
    mov bl,[esi]
    and bl,63
    add al,bl
    jmp @konec

@vetsi_nebo_rovno240:
    {ctyrbajtovy}
    mov bl,4
    mov [edi],bl
    mov ecx,poz
    add ecx,3
    cmp ecx,delka
    jbe @neni_vetsi_nez_delka3
    mov eax,126       {UTF82word:=126 (znak ~) - ochrana pred nekorektnimi daty}
    jmp @konec
@neni_vetsi_nez_delka3:
    and eax,7
    shl eax,18
    inc esi
    movzx ebx,byte [esi]
    and ebx,63
    shl ebx,12
    add eax,ebx
    inc esi
    movzx ebx,byte [esi]
    and ebx,63
    shl ebx,6
    add eax,ebx
    inc esi
    movzx ebx,byte [esi]
    and ebx,63
    add eax,ebx

@konec:
end;
{$ELSE}
Function UTF82longint(s:pchar;delka,poz:longint;var posun:byte):longint;
var c:longint;
begin
dec(poz);
posun:=1;
if byte(s[poz])<128 then c:=byte(s[poz]) else {jednobajtovy znak}
   if byte(s[poz])<224 then
      begin                                  {dvojbajtovy znak}
      if poz+1>delka then c:=63 else{ochrana pred nekorektnimi retezci v UTF8}
      c:=(byte(s[poz]) and 63) shl 6+
          byte(s[poz+1]) and 63;
      posun:=2;
      end else


   if byte(s[poz])<240 then

      begin                             {trojbajtovy znak}
      if poz+2>delka then c:=21 else{ochrana pred nekorektnimi retezci v UTF8}
      c:=(byte(s[poz]) and 15) shl 12+
          byte(s[poz+1]) and 63 shl 6+
          byte(s[poz+2]) and 63;
      posun:=3;
      end else

   if byte(s[poz])<245 then             {ctyrbajtovy znak}
      begin
      if poz+3>delka then c:=126 else {ochrana pred nekorektnimi retezci v UTF8}
      c:=(byte(s[poz]) and 7) shl 18+
          byte(s[poz+1]) and 63 shl 12+
          byte(s[poz+2]) and 63 shl 6+
          byte(s[poz+3]) and 63;
      posun:=4;
      end
      else c:=byte(s[poz]);

Utf82longint:=c;
end;
{$ENDIF}
{$IFDEF FPC}
Function UNI_Convert_Up_or_down(tabulka:pUNIprevodni_tabulka;c:word):word;assembler;
asm
mov esi,tabulka
movzx eax,c
xor ebx,ebx
@smycka:
movzx ecx,word ds:[esi]          {velikost bloku}
mov dl,ds:[esi+2]                {typ bloku}
add ebx,ecx
add esi,3
dec ebx
cmp eax,ebx
ja @neni_v_bloku
{------BLOK-------}
cmp dl,0;jz @Konec
cmp dl,1;jnz @d1
  inc eax;jmp @Konec
@d1:
cmp dl,2;jnz @d2
  dec eax;jmp @konec
@d2:
cmp dl,3;jnz @d3
  mov bx,ds:[esi]
  sub ax,bx
  jmp @konec
@d3:
  mov bx,ds:[esi]
  add ax,bx
  jmp @konec
{-----------------}
@neni_v_bloku:
cmp dl,2
jbe @nic_nedelej
add esi,2
@nic_nedelej:
inc ebx
jmp @smycka
@konec:
end;
{$ELSE}
Function UNI_Convert_Up_or_down(tabulka:pUNIprevodni_tabulka;c:word):word;
var i,k:longint;
    typ:byte;
    w:word;
    q:pbyte;
begin
i:=0;
q:=pointer(tabulka);
repeat
move(q^,w,2);inc(q,2);      {velikost bloku}
typ:=q^;inc(q);             {typ bloku}
inc(i,w-1);
if c<=i then
   begin
   case typ of
      0:k:=0;
      1:k:=1;
      2:k:=-1;
      3:begin move(q^,w,2);inc(q,2);k:=-w;end;
      4:begin move(q^,w,2);inc(q,2);k:=w;end;
   end;
   UNI_Convert_Up_or_down:=c+k;
   Exit;
   end
   else if typ>2 then inc(q,2);
inc(i);
until false;
end;
{$ENDIF}


Procedure Pchar2WidePchar(p:pchar;delka:longint;utf8:boolean;var u16:pchar;var u16_bajtu:longint);
{Pozn.: sam alokuje pamet pro U16}
{UTF8 = false (neprovadej konverze UTF8 na wordy)
 UTF8 = true (provadej konverze UTF8 na wordy)}
var i,ii,m,o,r:longint;
    j:word;  {Nesmi byt Longint, protoze jinak by funkce "Hi" a "Lo" fungovaly chybne}
    n,lo_j,hi_j:byte;
begin
if UTF8=false then
   begin
   {jestlize neni nastaven unicode font, tak predpokladej, ze jde o ANSI text}
   u16_bajtu:=delka*2+1;
   GetMem(u16,u16_bajtu);
   for i:=0 to delka-1 do
       begin
       ii:=i*2;
       u16[ii]:=p[i];    {mene vyznamny bajt prvni, vyznamnejsi druhy}
       u16[ii+1]:=#0;    {(Inteli syntaxe)}
       end;
   end
   else begin
   {jestli piseme unicode fontem, tak predpokladej, ze text je v UTF-8}
   m:=UniLength(p);   {kolik retezec vlastne obsahuje znaku?}
   u16_bajtu:=m*2+1;
   GetMem(u16,u16_bajtu);
   i:=1;
   for o:=0 to {m-2}m-1 do
       begin
       j:=UTF82longint(p,delka,i,n);
       r:=o*2;
       lo_j:=Lo(j);
       hi_j:=Hi(j);
       u16[r]:=char(lo_j);
       u16[r+1]:=char(hi_j);
       inc(i,n);
       end;
   end;
u16[u16_bajtu-1]:=#0;
end;


Function Pchar2MegaWidePchar(p:pchar;del:longint;utf8:boolean;var u32:pchar;var u32_d:longint;var p_nad_ffff:longint):longint;

{Pozn.: sam alokuje pamet pro U16}
{UTF8 = false (neprovadej konverze UTF8 na wordy)
 UTF8 = true (provadej konverze UTF8 na wordy)}
var i,ii,m,o,r:longint;
    j:longint;
    jh,jl:word;
    n,j1,j2,j3,j4:byte;
    pocet_nad_ffff:longint;

begin
pocet_nad_ffff:=0;
p_nad_ffff:=0;
if UTF8=false then
   begin
   {jestlize neni nastaven unicode font, tak predpokladej, ze jde o ANSI text}
   u32_d:=del*4+1;
   GetMem(u32,u32_d);
   for i:=0 to del-1 do
       begin
       ii:=i*4;
       u32[ii]:=p[i];    {mene vyznamny bajt prvni, vyznamnejsi druhy}
       u32[ii+1]:=#0;    {(Inteli syntaxe)}
       u32[ii+2]:=#0;
       u32[ii+3]:=#0;
       end;
   end
   else begin
   {jestli piseme unicode fontem, tak predpokladej, ze text je v UTF-8}
   m:=UniLength(p);   {kolik retezec vlastne obsahuje znaku?}
   u32_d:=m*4+1;
   GetMem(u32,u32_d);
   i:=1;
   for o:=0 to {m-2}m-1 do
       begin
       j:=UTF82longint(p,del,i,n);
       r:=o*4;
       jl:=Lo(j);
       jh:=Hi(j);
       j1:=Lo(jl);
       j2:=Hi(jl);
       j3:=Lo(jh);
       j4:=Hi(jh);
       if jh>0 then
          begin
          if pocet_nad_ffff=0 then p_nad_ffff:=o;
          inc(pocet_nad_ffff);
          end;
       u32[r+0]:=char(j1);
       u32[r+1]:=char(j2);
       u32[r+2]:=char(j3);
       u32[r+3]:=char(j4);
       inc(i,n);
       end;
   end;
u32[u32_d-1]:=#0;

Pchar2MegaWidePchar:=pocet_nad_ffff;
end;



Procedure String2Widestring(s:string;utf8:boolean;var u16:string);
{UTF8 = false (neprovadej konverze UTF8 na wordy)
 UTF8 = true (provadej konverze UTF8 na wordy)}
var buf:pchar;
    buf_bajtu:longint;
begin
if s='' then begin u16:='';exit;end;
s:=s+#0;
Pchar2WidePchar(@s[1],Length(s)-1,utf8,buf,buf_bajtu);
u16[0]:=char(byte(buf_bajtu)*2);
Move(buf^,u16[1],byte(u16[0]));
FreeMem(buf,buf_bajtu);
end;


Procedure SimpleString2WideString(s:string;var ws:string);
{Znacne zjednodusena varianta predchoziho. Predpoklada, ze vsechny znaky jsou
 7-bitove a tudiz, ze neni treba resit zadne unicode}
var i,j,k:longint;
    c:char;
begin
j:=Length(s);
ws[0]:=char(j*2);
k:=1;
for i:=1 to j do
    begin
    c:=s[i];
    ws[k]:=c;
    ws[k+1]:=#0;
    inc(k,2)
    end;
end;


Procedure WidePchar2Pchar(p:pchar;delka:longint;utf8:boolean;var u8:pchar;var u8_bajtu:longint);
var q:pchar;
    i,ii,j,k,dz:longint;
    b:byte;
    w:word;
    s_utf8:string[4];

begin
dz:=delka div 2; {v DZ je pocet znaku, nikoliv bocet bajtu}
if utf8=false then
   begin      {1. varianta: zadne rozepisovani do UTF 8}
   u8_bajtu:=dz+1;      {vsechny znaky retezce plus terminator #0}
   GetMem(q,u8_bajtu);
   for i:=0 to dz-1 do
       begin
       b:=byte(p[i*2]); {vyssi bajt na [ii+1] resit nebudeme, protoze...}
                        {...u non-unicode maji byt znaky jen 0-255, tudiz...}
                         {...cokoliv vyssiho je stejne chyba}
       q[i]:=char(b);
       end;
   q[i+1]:=#0;          {terminator na konec PCharu}
   u8:=q;     {u8_bajtu uz jsme priradili o nekolik radek vyse}
   end
   else begin {2. varianta: prepisovani do UTF-8}
   GetMem(q,delka*2); {nejhorsi scenar: vsechno jsou 4-bajtove sekvence UTF-8}
                      {nasobime 2, nikoliv 4 proto, ze zpocatku je jeden znak 2 bajty}

   ii:=0;
   k:=0;
   for i:=0 to dz-1 do
       begin
       w:=word(p[ii])+word(p[ii+1])*256;
       inc(ii,2);
       s_utf8:=word2utf8(w);
       for j:=1 to Length(s_utf8) do
           begin
           q[k]:=s_utf8[j];
           inc(k);
           end;
       end;
   q[k]:=#0;            {terminator na konec PCharu}
   u8_bajtu:=k+1;

   {$IFDEF FPC}
   {FPC ma proceduru ReAlloc, diky ktere lze spolehlive zmenit velikost bloku
    pameti. Obzvlast z vetsi na mensi}
   ReAllocMem(q,u8_bajtu);
   u8:=q;
   {$ELSE}
   {Turbo pascal ReAlloc nema, tudiz musim alokovat novy blok a prekopirovat
    obsah ze stareho}
   GetMem(u8,u8_bajtu);
   Move(q^,u8^,u8_bajtu);
   FreeMem(q,delka*2);
   {$ENDIF}
   end;
end;


Procedure WidePChar2String(p:pchar;delka:longint;utf8:boolean;var u8:string);
{UTF8 = false (neprovadej konverze UTF8 na wordy)
 UTF8 = true (provadej konverze UTF8 na wordy)}
var buf:pchar;
    j,k,buf_bajtu:longint;
    b:byte;
begin
if delka=0 then begin u8:='';exit;end;
WidePchar2Pchar(p,delka,utf8,buf,buf_bajtu);
if buf_bajtu>255 then u8[0]:=#255 else u8[0]:=char(buf_bajtu);
{idealne by tu melo byt okrajovani s respektovanim UTF-8 sekvenci, ale zatim takto}

u8[0]:=char(buf_bajtu);
Move(buf^,u8[1],byte(u8[0]));
if (buf_bajtu>255) and (utf8=true) then
   if byte(u8[Length(u8)])>127 then
      begin
      {Radeji zkontrolujeme, jestli kdyz jsem na pozici 255 usekl retezec, tak
      jestli jsem v pulce nepresekl sekvenci UTF-8}
      j:=Length(u8);
      while byte(u8[j])<192 do dec(j);
      b:=byte(u8[j]);
      if b>240 then k:=j+3 else     {ctyrbajtovy znak}
      if b>224 then k:=j+2 else     {trojbajtovy znak}
      if b>192 then k:=j+1;         {dvojbajtovy znak}
      if k>255 then  {ajaj, sekvence UTF-8 byla rozseknuta v pulce}
         begin
         b:=j-1;
         u8[0]:=char(b);
         end;
      end;
FreeMem(buf,buf_bajtu);
end;


Procedure pConvert_Up(p,p2:pchar);
var a,c,l,m:longint;
    q:byte;
    n:pchar;
    t:string;
begin
if p[0]=#0 then
   begin
   p2[0]:=#0;
   Exit;
   end;
if male_na_velke<>pointer(UNI_male_na_velke) then
   begin
   l:=0;
   repeat
   p2[l]:=male_na_velke^[byte(p[l])];
   inc(l);
   until p[l]=#0;
   end
   else begin {unicode rezim}
   t:='';
   n:=p2;
   a:=1;
   l:=0;
   while p[l]<>#0 do inc(l);
   repeat
      c:=UTF82longint(p,l,a,q);
      c:=UNI_Convert_Up_or_down(UNI_male_na_velke,c);
      t:=Word2UTF8(c);
      for m:=1 to Length(t) do
          begin
          n^:=t[m];
          inc(n);
          end;
      inc(a,q);
   until {p[q]=#0;}a>l;
   end;
end;

Function Convert_Up(s:string):string;
var t:string;
    ss,tt:pchar;
begin
s:=s+#0;
t[0]:=s[0];
ss:=@s[1];
tt:=@t[1];
pConvert_Up(ss,tt);
dec(t[0]);
Convert_Up:=t;
end;

Procedure pConvert_Down(p,p2:pchar);
var a,c,l,m:longint;
    q:byte;
    n:pchar;
    t:string;
begin
if p[0]=#0 then
   begin
   p2[0]:=#0;
   Exit;
   end;
if velke_na_male<>pointer(UNI_velke_na_male) then
   begin      {ascii rezim}
   l:=0;
   repeat
   p2[l]:=velke_na_male^[byte(p[l])];
   inc(l);
   until p[l]=#0;
   end
   else begin {unicode rezim}
   t:='';
   n:=p2;
   a:=1;
   l:=0;
   while p[l]<>#0 do inc(l);
   repeat
      c:=UTF82longint(p,l,a,q);
      c:=UNI_Convert_up_or_down(UNI_velke_na_male,c);
      t:=Word2UTF8(c);
      for m:=1 to Length(t) do
          begin
          n^:=t[m];
          inc(n);
          end;
      inc(a,q);
   until {p[q]=#0;}a>l;
   end;
end;

Function Convert_Down(s:string):string;
var t:string;
    ss,tt:pchar;
begin
s:=s+#0;
t[0]:=s[0];
ss:=@s[1];
tt:=@t[1];
pConvert_Down(ss,tt);
dec(t[0]);
Convert_Down:=t;
end;


Function UniConvert_Down(s:string):string;
var u:pointer;
begin
u:=velke_na_male;
velke_na_male:=pointer(UNI_velke_na_male);
UniConvert_Down:=Convert_Down(s);
velke_na_male:=u;
end;


Function UniConvert_Up(s:string):string;
var u:pointer;
begin
u:=male_na_velke;
male_na_velke:=pointer(UNI_male_na_velke);
UniConvert_Up:=Convert_Up(s);
male_na_velke:=u;
end;


Function Same_after_lowcase(const s1,s2:string):boolean;
var t:string;
begin
if Length(s1)<>Length(s2) then begin Same_after_lowcase:=false;Exit;end;
t:=Convert_down(s1);
Same_after_lowcase:=t=s2;
end;


function Char_Gb(c:char):char;
{vyuziva nastavitelnou tabulku znaku, shodnou jako u CmpString}
var a,b,d,e:byte;
begin
if (byte(c)>=byte('a')) and (byte(c)<=byte('z')) then begin Char_GB:=c;Exit;end;
if (byte(c)>=byte('A')) and (byte(c)<=byte('Z')) then begin Char_GB:=c;Exit;end;

a:=Pos(c,sysTridiciStr);
if a=0 then begin Char_GB:=c;Exit;end
   else begin
   b:=a-1;
   repeat
      if (byte(sysTridiciStr[b])>=byte('A')) and (byte(sysTridiciStr[b])<=byte('Z')) then
         begin
         d:=byte(sysTridiciStr[b]);
         if odd(a) then inc(d,byte('a')-byte('A'));
         Char_Gb:=char(d);
         Exit;
         end;

   dec(b);
   until b<1;
   end;

Char_Gb:=c;
end;

Function Convert_Gb(s:string):string;
var i:integer;
begin
for i:=1 to Length(s) do s[i]:=Char_Gb(s[i]);
Convert_Gb:=s;
end;


Function SimpleChar_Up(c:char):char;
begin
SimpleChar_Up:=UpCase(c);
end;


Function SimpleChar_Down(c:char):char;
begin
if (c>#64) and (c<#91)
   then SimpleChar_Down:=char(byte(c)+32)
   else SimpleChar_Down:=c;
end;


Procedure PripravTridiciTabulku(t:string);
{Pripravi k pouziti definicni retezec pro abecedni razeni znaku}
var a,b:byte;
begin
b:=Length(t);
if odd(b) then begin dec(b);delete(t,b,1);end; {delka retezce musi byt suda}
for a:=1 to b do sysTridiciTbl^[byte(t[a])]:=(a-1) div 2;
sysTridiciStr:=t;
b:=b div 2;
for a:=0 to 255 do
    begin
    if Pos(char(a),t)=0 then
       begin
       sysTridiciTbl^[a]:=b;
       inc(b);
       if b>255 then
          b:=b;
       end;
    end;
if Pos(trid__ch,t)<>0 then
   sysTridiciTbl^[256]:=1 else sysTridiciTbl^[256]:=0;
end;


Function CmpChar(a,b:char):shortint;
var c,d:byte;
begin
c:=sysTridiciTbl^[byte(a)];
d:=sysTridiciTbl^[byte(b)];
if c<d then CmpChar:=1 else
if c>d then CmpChar:=-1 else CmpChar:=0;
end;


Function CmpNum(var s1,s2:string;var d:byte;c:byte):shortint;
{Bohuzel nelze snadno pouzit proceduru VAL - selhala by u cisel s vice rady
 nez pojme longint}
var a,b:byte;
    t1,t2:string;
    w1,w2:word;
    i1,i2:integer;
begin
a:=d;
repeat
t1:=Copy(s1,a,4);
t2:=Copy(s2,a,4);

Val(t1,w1,i1);
Val(t2,w2,i2);

if (i1=0) and (i2=0) then
   begin
   if w1>w2 then begin CmpNum:=-1;Exit;end;
   if w1<w2 then begin CmpNum:=1;Exit;end;
   end;

if i1=i2 then {zde uz vime, ze i1=i2<>0}
   begin
   t1:=Copy(s1,a,i1-1);
   t2:=Copy(s2,a,i2-1);
   Val(t1,w1,i1);
   Val(t2,w2,i2);
   if w1>w2 then begin CmpNum:=-1;Exit;end;
   if w1<w2 then begin CmpNum:=1;Exit;end;
   end;

if i1<>i2 then
   begin
   if i1<>0 then begin t1:=Copy(s1,a,i1-1);Val(t1,w1,i1);end;
   if i2<>0 then begin t2:=Copy(s2,a,i2-1);Val(t2,w2,i2);end;
   if w1>w2 then begin CmpNum:=-1;Exit;end;
   if w1<w2 then begin CmpNum:=1;Exit;end;

   CmpNum:=0;
   if i1<i2 then d:=i1 else d:=i2;
   Exit;
   end;
inc(a,4);
until 1=2;
end;


Function Nahrad_ch(var s:string;c:byte):boolean;
var a:byte;
    z:boolean;
begin
z:=false;
for a:=1 to c do
    if (s[a]='c') or (s[a]='C') then
       if (a<>c) and ((s[a+1]='h') or (s[a+1]='H')) then
          begin
          s[a]:=pchar(trid__ch)[1];
          z:=true;
          end;
Nahrad_ch:=z;
end;


Function CmpString(var s1,s2:string):boolean;
{kdyz je dle tridici tabulky s1<=s2 vrati true, jinak false}
var a,b,c,d:byte;
    e:shortint;
    z1,z2:boolean;
    poms1:string;
    poms2:string;

begin
a:=Length(s1);
b:=Length(s2);

if a<b then c:=a else c:=b; {budeme porovnavat pocet znaku v kratsim retezci}

if sysTridiciTbl^[256]=1 then  {zna tridici sada anomalii s CH?}
   begin
   poms1:=s1;
   poms2:=s2;
   z1:=Nahrad_ch(s1,c);        {"C" v "CH" nahradi zastupnym znakem}
   z2:=Nahrad_ch(s2,c);        {to same i v druhem retezci}
   end;

d:=1;
while d<=c do
    begin
    if (byte(s1[d])>=byte('0')) and (byte(s1[d])<=byte('9')) and
       (byte(s2[d])>=byte('0')) and (byte(s2[d])<=byte('9'))
       then e:=CmpNum(s1,s2,d,c)
       else e:=CmpChar(s1[d],s2[d]);
    if e<>0 then Break;
    inc(d);
    end;  {while}

if e=0
   then CmpString:=b>=a {kdyz i po projiti celeho useku jsou retezce ident.}
   else CmpString:=e>0;

if sysTridiciTbl^[256]=1 then
   begin
   if Z1 then s1:=poms1;       {probehla zamena u S1? Tak to vrat zpatky}
   if Z2 then s2:=poms2;       {to same v druem retezci}
   end;
end;



Function KillZeroes(s:string):string;
var a:byte;
begin
a:=1;
while (s[a]='0') and (a<Length(s)) do inc(a);
if s[a]='0' then KillZeroes:='0' else KillZeroes:=Copy(s,a,Length(s));
end;

Function Hex2Dec(s:string):longint;
var i:integer;
    b:longint;
begin
s:='$'+s;
Val(s,b,i);
if i=0 then Hex2Dec:=b else Hex2Dec:=0;
end;


Function HexStr(l:longint):string;
var a,b:longint;
    c,d:byte;
    s:string[32];
    p:^string;

begin
p:=@s[32];
a:=32;
repeat
s[a]:=HexDigits[l and 15];
dec(a);
l:=l div 16;
until l=0;
b:=32-a;
case b of
  1:c:=1;
  3:c:=1;
  5:c:=3;
  6:c:=2;
  7:c:=1;
  else c:=0;
end; {case}
for d:=a downto a-c+1 do s[d]:='0';
dec(a,c);
inc(b,c);
s[a]:=char(b);
p:=@s[a];
HexStr:=p^;
end;


(*
Function HexStr(l:longint):string;
var a:longint;
    s:string;
begin
s:='';
a:=0;
repeat
s:=s+HexDigits[l and 15];
l:=l div 16;
inc(a);
until l=0;
case Length(s) of
  1:s:=s+'0';
  3:s:=s+'0';
  5:s:=s+'000';
  6:s:=s+'00';
  7:s:=s+'0';
end; {case}
HexStr:=SwapString(s);
end;
*)

Function Dec2Hex(l:longint):string;
begin
Dec2Hex:=HexStr(l);
end;

Function Dword2Real(d:longint):comp;
{Dword prevede na real. Predevsim resi problem s Turbo pascalem, ktery vnitrne
 dword neznam a ja ho jen emuluji pres longint. V takovem pripade se totiz
 muze stavat, ze vetsi hodnoty budou pretecena jako zaporna cisla a tak musime
 vymyslet figl, jak i je korektne prevest na real/comp}
var r:comp;
begin
if d>=0 then Dword2Real:=d else
   begin
   r:=maxlongint;
   r:=r*2+2;
   r:=r+d;
   Dword2Real:=r;
   {Je potreba to nascitat a poodcitat takhle postupne, jinak si TP bude
    stezovat na prilis velkou konstantu}
   end;
end;

Procedure DirectWrite(x,y,g:byte;s:string);
var w:word;
    a:byte;
begin
w:=textadressoffset(x,y);
for a:=1 to Length(s) do
   begin
   Mem[SegB800:w]:=byte(s[a]);
   inc(w);
   Mem[SegB800:w]:=g;
   inc(w);
   end;
end;


Procedure TimerBalastProc;
begin
asm
xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;
xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;xchg ax,ax;nop;
xchg ax,ax;nop;xchg ax,ax;nop;
end;
end;


Function PocetRadu(l:longint):byte;
var a:byte;
begin
if l<0 then a:=2 else a:=1;
while (l div 10)<>0 do begin inc(a);l:=l div 10;end;
PocetRadu:=a;
end;


Function PocetSlov(s:string):integer;
var a,b:byte;
begin
s:=SkipBegSpaces(SkipEndSpaces(s));
if s='' then begin PocetSlov:=0;Exit;end;
a:=1;
b:=Pos(' ',s);
while b<>0 do
   begin
   inc(a);
   delete(s,1,b);
   s:=SkipBegSpaces(s);
   b:=Pos(' ',s);
   end;
PocetSlov:=a;
end;


Procedure NahradZnaky(var s:string;vych_znak,cil_znak:char);
var i:byte;
begin
for i:=1 to Length(s) do
    if s[i]=vych_znak then s[i]:=cil_znak;
end;


Function VratSlovo(s:string;n:byte):string;
var a,b,c:byte;
begin
s:=SkipBegSpaces(SkipEndSpaces(s));
if (n>PocetSlov(s)) or (n=0) then begin VratSlovo:='';Exit;end;
a:=1;
b:=1;
for c:=1 to n do
   begin
   while s[b]=' ' do inc(b);
   a:=b;
   b:=Search(s,' ',a);
   end;

if b=0 then b:=Length(s) else dec(b);
VratSlovo:=Mid(s,a,b);
end;


Function KolikratZduplikovanyZnakNaPoz(var s:string;poz:byte):byte;
var a,r:byte;
    c:char;
begin
r:=0;
if (poz>0) and (poz<=Length(s)) then
   begin
   c:=s[poz];
   for a:=poz to Length(s) do
       if s[a]=c then inc(r) else Break;
   end;
KolikratZduplikovanyZnakNaPoz:=r;
end;


function Xmezer(N: longint): string;
{ Fce vraci retezec obsahujici N mezer }
begin
if n<1 then begin XMezer:='';Exit;end;
if n>255 then n:=255;
XMezer:=XChar(n,' ');
end;

function Xchar(n:longint;c:char):string;
var s:string;
    a:byte;
begin
if n<1 then begin XChar:='';Exit;end;
if n>255 then n:=255;
s:='';
for a:=1 to n do s:=s+c;
XChar:=s;
end;

Function ReplaceStr(s:string;dindex:byte;t:string;sindex,delka:byte):string;
begin
delete(s,dindex,delka);
t:=Copy(t,sindex,delka);
insert(t,s,dindex);
ReplaceStr:=s;
end;


function MyVal (S: string): longint;
{ etzec --> slo}
var
  Pom2 : Integer;
  pom1 : longint;
begin { MyVal }
s:=skipallspaces(s);
  Val (S, Pom1, Pom2);
  MyVal := Pom1;
end;  { MyVal }


Procedure ExtVal(s:string;a,b:byte;var i:integer;var j:integer);
var d:integer;
begin
repeat
val(copy(s,a,b-a+1),i,j);
if j=1 then if a<b then inc(a) else begin j:=1;i:=0;Exit;end;
until j<>1;
if j=0 then d:=b-a+2 else d:=j;
val(copy(s,a,d-1),i,d);
end;

function MyStr (Cislo: longint): string;
{ slo --> etzec }
var
  Vysledek : string;
begin { MyStr }
  Str (Cislo, Vysledek);
  MyStr := Vysledek;
end;  { MyStr }

function Mystr2(a:longint;nakolik:byte):string;
var vysl:string;
Begin
str(a:nakolik,vysl);
Mystr2:=vysl;
End;{nastr2}

function MyStr3(a:longint;NaKolik:byte):string;
var vysl:string;
Begin
str(a,vysl);
while byte(vysl[0])<nakolik do vysl:='0'+vysl;
Mystr3:=vysl;
End;{nastr3}

Function NaPstring(s:string):pointer;
var p:pointer;
    l:longint;
begin
l:=Length(s)+1;
GetMem(p,l);
Move(s,p^,l);
NaPstring:=p;
end;

Function ZrusPstring(p:pstring):pointer;
var l:longint;
begin
if p<>nil then
   begin
   l:=Length(p^)+1;
   FreeMem(p,l);
   end;
ZrusPstring:=nil;
end;

Function Prohod_Endianitu_Retezce(s:string):string;
{prohodi 1.znak s druhym, 3.znak se ctvrtym, 5.znak s sestym, a tak dale}
{Puvodni retezec nemeni}
var a,b:byte;
    c:char;
begin
for a:=1 to Length(s) div 2 do
    begin
    b:=a*2;
    c:=s[b-1];
    s[b-1]:=s[b];
    s[b]:=c;
    end;
Prohod_Endianitu_Retezce:=s;
end;

Procedure Prohod_Endianitu_Pcharu(p:pchar;d:longint);
{prohodi 1.znak s druhym, 3.znak se ctvrtym, 5.znak s sestym, a tak dale}
{Meni puvodni retezec, zadny novy netvori}
var a,b:longint;
    c:char;
begin
for a:=0 to (d div 2)-1 do
    begin
    b:=a*2;
    c:=p[b+1];
    p[b+1]:=p[b];
    p[b]:=c;
    end;
end;



Function StrPas(p:pchar):string;
{Provede konverzi z PCharu na pascalovsky string}
var a:byte;
    s:string;
    c:char;
begin
for a:=0 to 255 do
    begin
    c:=p[a];
    if c<>#0 then s[a+1]:=c
       else begin
       s[0]:=char(a);
       StrPas:=s;
       Exit;
       end;
    end;
s[0]:=#255;
StrPas:=s;
end;


Function Word2String(w:word):string;
begin
if w<256 then Word2String:=char(w)
         else Word2String:=char(Lo(w))+char(Hi(w));
end;


Procedure Byte2Pointer(b:byte;p:pointer);
begin
pchar(p)^:=char(b);
end;


Function Pointer2Byte(p:pointer):byte;
var b:^byte;
begin
b:=p;
Pointer2Byte:=b^;
end;


Procedure Word2Pointer(w:word;p:pointer);
var t:^word;
begin
t:=p;
t^:=w;
end;


Function Pointer2Word(p:pointer):word;
var w:^word;
begin
w:=p;
Pointer2Word:=w^;
end;


Procedure Longint2Pointer(l:longint;p:pointer);
var t:^longint;
begin
t:=p;
t^:=l;
end;


Function Pointer2Longint(p:pointer):longint;
var l:^longint;
begin
l:=p;
Pointer2Longint:=l^;
end;


{$IFDEF FPC}
function SwapEndianW(AValue: Word): Word;
begin
SwapEndianW:=Word((AValue shr 8) or (AValue shl 8));
end;


function SwapEndianL(AValue: LongInt): LongInt;
begin
SwapEndianL:=(AValue shl 24)
           or ((AValue and $0000FF00) shl 8)
           or ((AValue and $00FF0000) shr 8)
           or (AValue shr 24);
end;


function SwapEndianD(AValue: DWord): DWord;
begin
SwapEndianD:=(AValue shl 24)
           or ((AValue and $0000FF00) shl 8)
           or ((AValue and $00FF0000) shr 8)
           or (AValue shr 24);
end;
{$ELSE}
function SwapEndianW(AValue: Word): Word;assembler;
asm
mov ax,AValue
xchg ah,al
end;

function SwapEndianL(AValue: LongInt): LongInt;assembler;
asm
mov ax,avalue.word[0]
mov dx,avalue.word[2]
end;

function SwapEndianD(AValue: LongInt): Dword;assembler;
asm
mov ax,avalue.word[0]
mov dx,avalue.word[2]
end;
{$ENDIF}


Function Je_TextovyRezim:boolean;
var a,b:byte;
begin
asm
mov ah,0fh
int 10h
mov a,al
end;
if a<=$13 then
   if a in [0,1,2,3,7] then Je_Textovyrezim:=true else Je_Textovyrezim:=false
   else begin  {a>$13}
   asm
   mov dx,3ceh
   mov al,6
   out dx,al
   inc dl
   in al,dx
   and al,1
   mov b,al
   end;
   Je_Textovyrezim:=b=0;
   end;
end;


Function SirkaObrazovky:byte;
begin
SirkaObrazovky:=MemW[Seg0040:$4a];
end;


Function VyskaObrazovky:byte;
var w1,w2:word;  {musim obchazet prapodivnou chybu Freepascalu 3.2.0}
begin
w1:=MemW[Seg0040:$4c];
w2:=MemW[Seg0040:$4a];
VyskaObrazovky:=w1 div w2 div 2;

{VyskaObrazovky:=word(MemW[Seg0040:$4c]) div word(MemW[Seg0040:$4a]) div 2;}
{z nejakeho duvodu to FPC 3.2.0 pri nekterych nastavenich prekladace nestravi}
end;


Procedure SoundOn(frekvence:word);
{Jako Sound z unitu Crt}
var val:longint;
    temp:byte;
begin
val:=((182*65535) div 10) div frekvence;
if val>65535 then val:=65535;
Port[$43]:=$0b6;
Port[$42]:=val and $ff;
Port[$42]:=val shr 8;
temp:=temp or 3;
Port[$61]:=temp;
end;


Procedure SoundOff;
{Jako NoSound z unitu Crt}
var temp:byte;
begin
temp:=Port[$61];
temp:=temp and $fc;
Port[$61]:=temp;
end;


Procedure Beep;
begin
lacrt.sound(400,20);
end;

Procedure Sound(hz,ms:word);
begin
SoundOn(hz);
Cekej(ms);
SoundOff;
end;


Function KeyPress:boolean;assembler;
asm
mov ah,11h
int 16h
mov ax,1
jnz @stisknuto
mov ax,0
@stisknuto:
end;


Function KeyRead:word;
{precte kod klacesy do wordu. Rozsirene kody klaves vrati najednou jako
 256+druhy kod klavesy}
var a:word;
begin
   asm
@znovu:
   mov ax,1100h
   int 16h
   jz @znovu             {cekej, nez se v bufferu neco objevi}
   mov bh,255
@opet:
   mov ax,0600h
   mov dl,0ffh
   int 21h
   inc bh
   cmp al,0
   jz @opet
   mov ah,bh
   mov a,ax
   end;
KeyRead:=a;
end;


Procedure BufferOff;
begin
while keypress do keyread;
end;


Procedure PockejNaKlavesu;
begin
BufferOff;
repeat until keypress;
BufferOff;
end;


Procedure PockejNaEnter;
var o:word;
begin
BufferOff;
repeat
o:=keyread;
until o=13;
BufferOff;
end;



Function Preklad_ascii_2_unicode(b:longint;u:putf8conv):longint;
begin
if u=nil then Preklad_ascii_2_unicode:=b else
   begin
   if (b<128) or (b>255) then Preklad_ascii_2_unicode:=b else Preklad_ascii_2_unicode:=u^[b];
   end;
end;


Function Preklad_unicode_2_ascii(b:word;u:putf8conv;ui:putf8convinv;var err:boolean):byte;
var aa:byte;
begin
err:=false;
if u=nil then
   begin
   if b<256 then Preklad_unicode_2_ascii:=b
      else begin
      err:=true;
      Preklad_unicode_2_ascii:=byte(UTF8_na_ascii_neznamy_znak);
      end;
   Exit;
   end;
if b<128 then Preklad_unicode_2_ascii:=b
   else begin
   aa:=ui^[b];    {jaka ASCII hodnota je pro J v inveznim poli?}
   if (aa>127) and (u^[aa]=b)
   {pokud ji muzeme potvrdit z puvodnoho pole, tak je vyhrano}
      then Preklad_unicode_2_ascii:=aa
      else begin
      err:=true;
      Preklad_unicode_2_ascii:=byte(UTF8_na_ascii_neznamy_znak);
      end;
   end;
end;


{$IFDEF FPC}
Function Word2UTF8(w:longint):string;assembler;
asm
mov edi,[ebp+8]  {adresa vysledku funkce}
mov ebx,w
cmp ebx,10FFFFh   {jsme <0 nebo >10FFFFh?...}
jna @ok_rozsah
mov ebx,0FFFDh    {...tak misto toho zakoduj zastupny znak FFFD}
@ok_rozsah:
cmp ebx,128
jae @vetsi_ci_rovno_nez_128
    mov eax,1                          {jednobajtovy znak}
    mov [edi],al;        {0.bajt retezce = delka, tedy zde 1}
    mov [edi+1],bl
    jmp @konec

@vetsi_ci_rovno_nez_128:
cmp ebx,2048
jae @vetsi_ci_rovno_nez_2048
    mov eax,2            {0.bajt retezce = delka, tedy zde 2}
    mov [edi],al
    mov eax,ebx
    shr ebx,6
    add ebx,192
    mov [edi+1],bl
    and eax,63
    add eax,128
    mov [edi+2],al
    jmp @konec

@vetsi_ci_rovno_nez_2048:
cmp ebx,65536
jae @vetsi_ci_rovno_nez_65536
    mov eax,3
    mov [edi],al         {0.bajt retezce = delka, tedy zde 3}
    mov eax,ebx
    mov ecx,ebx          {EAX=EBX=ECX=w}
    shr ebx,12
    add ebx,224
    mov [edi+1],bl
    shr eax,6
    and eax,63
    add eax,128
    mov [edi+2],al
    and ecx,63
    add ecx,128
    mov [edi+3],cl
    jmp @konec

@vetsi_ci_rovno_nez_65536:
    mov eax,4
    mov [edi],al         {0.bajt retezce = delka, tedy zde 4}
    mov eax,ebx
    mov ecx,ebx
    mov edx,ebx          {EAX=EBX=ECX=EDX=w}
    shr edx,18
    add edx,240
    mov [edi+1],dl
    shr ebx,12
    and ebx,63
    add ebx,224
    mov [edi+2],bl
    shr eax,6
    and eax,63
    add eax,128
    mov [edi+3],al
    and ecx,63
    add ecx,128
    mov [edi+4],cl
    jmp @konec


@konec:
end;
{$ELSE}
Function Word2UTF8(w:longint):string;
begin   {1-bajtovy znak}
if (w<0) or (w>$10FFFF) then w:=$FFFD;  {kontrola rozsahu}
if w<128 then Word2UTF8:=char(w) else
        {2-bajtovy}
if w<2048 then Word2UTF8:=char(192+w shr 6)+char(128+w and 63) else
        {3-bajtovy}
if w<65536 then Word2UTF8:=char(224+w shr 12)+char(128+(w shr 6) and 63)+char(128+w and 63) else
        {4-bajtovy}
   Word2UTF8:=char(240+w shr 18)+char(128+(w shr 12) and 63)+char(128+(w shr 6) and 63)+char(128+w and 63);
end;
{$ENDIF}

Function UniLengthPoz(p:pchar;delka:longint):longint;
var a,i:longint;
begin
if delka<=1 then begin UniLengthPoz:=1;Exit;end;
a:=0;
i:=0;
dec(delka);
while a<>delka do
   begin
   if p[a]=#0 then a:=delka else
   if p[a]<#128 then inc(a) else
   if p[a]<#224 then inc(a,2) else
   if p[a]<#240 then inc(a,3) else inc(a,4);
   inc(i);
   end;
UniLengthPoz:=i;
end;


Function UniLength(p:pchar):longint;
var a,i:longint;
begin
a:=0;
i:=0;
while p[a]<>#0 do
   begin
   if p[a]>#127 then
      if (p[a]<#224) then inc(a) else
         if (p[a]<#240) then inc(a,2) else inc(a,3);
   inc(a);
   inc(i);
   end;
UniLength:=i;
end;

Function UniLengthS(s:string):longint;
var p:pchar;
begin
s:=s+#0;
p:=@s;
UniLengthS:=UniLength(p);
end;


Function UniZnakVpred(p:pchar;i:longint):longint;
var j:longint;
begin
j:=1;
while (byte(p[i+j])>127) and (byte(p[i+j])<192) do inc(j);
UniZnakVpred:=j;
end;

Function UniZnakZpet(p:pchar;i:longint):longint;
var j:longint;
begin
j:=1;
if (byte(p[i-j])>=128) then
   while (byte(p[i-j])<192) do inc(j);
UniZnakZpet:=j;
end;



Function Je_unicode_sekvence(n:pointer;var posun:byte):byte;
{0=nelze rici, znak je v 0..127
 1=neni unicode
 2=je unicode}

var p:pchar;

begin
p:=n;
posun:=1;

if p[0]<#128 then begin Je_unicode_sekvence:=0;Exit;end;

Je_unicode_sekvence:=1;

if p[0]<#224 then
   begin
   if (p[1]>#127) and (p[1]<#192)
      then begin Je_unicode_sekvence:=2;posun:=2;end;
   Exit;
   end;

if p[0]<#240 then
   begin
   if (p[1]>#127) and (p[1]<#192) then
      if (p[2]>#127) and (p[2]<#192) then
         begin Je_unicode_sekvence:=2;posun:=3;end;
   Exit;
   end;

if p[0]<#245 then
   begin
   if (p[1]>#127) and (p[1]<#192) then
      if (p[2]>#127) and (p[2]<#192) then
         if (p[3]>#127) and (p[3]<#192) then
            begin Je_unicode_sekvence:=2;posun:=4;end;
   Exit;
   end;

{Zbyva varianta, ze v P[0] je znak #245 ci vyssi, coz neni kompat. s UTF-8}
{V tom pripade vrati POSUN=1 a RESULT=1}
end;


Procedure pUTF8conv_to_pUTFconvinv(u:putf8conv;ui:putf8convinv);
var a:byte;
    q:word;
begin
for a:=128 to 255 do  {vytvorime inverzni tabulku k U}
    begin      {zkusim optimalizaci, a to nedelat prvnotni nulovani pole}
    q:=u^[a];
    if q>127 then ui^[q]:=a;
    end;
end;

{$IFDEF FPC}
Function UTF8pchar_2_asciistring(p:pchar;pd:longint;u:putf8conv):string;
var i,j:longint;
    ps,a,aa:byte;
    err:boolean;
    q:word;
    r:string;
    ui:utf8convinv;

begin
if pd<1 then begin UTF8pchar_2_asciistring:='';Exit;end;
pUTF8conv_to_pUTFconvinv(u,@ui);

r:='';
i:=1;
UTF8_2_ascii_error:=0;
repeat
  j:=UTF82longint(p,pd,i,ps);
  aa:=Preklad_unicode_2_ascii(j,u,@ui,err);
  r:=r+char(aa);
  if UTF8_2_ascii_error=0 then
     if err=true then UTF8_2_ascii_error:=i;
  inc(i,ps);
until i>pd;
UTF8pchar_2_asciistring:=r;
end;
{$ELSE}
Function UTF8pchar_2_asciistring(p:pchar;pd:longint;u:putf8conv):string;
var i,j:longint;
    ps,a,aa:byte;
    r:string;

begin
if pd<1 then begin UTF8pchar_2_asciistring:='';Exit;end;
r:='';
i:=1;
UTF8_2_ascii_error:=0;
repeat
j:=UTF82longint(p,pd,i,ps);
if j<128 then r:=r+char(j)
   else begin
   aa:=0;
   for a:=128 to 255 do
       if u^[a]=j then begin aa:=a;Break;end;
   if aa=0
      then begin
      r:=r+UTF8_na_ascii_neznamy_znak;
      if UTF8_2_ascii_error=0 then UTF8_2_ascii_error:=i;
      end
      else r:=r+char(aa);

   end;
inc(i,ps);
until i>pd;
UTF8pchar_2_asciistring:=r;
end;
{$ENDIF}

Function UTF8string_2_asciistring(s:string;u:putf8conv):string;
var p:pchar;
    i:longint;
begin
p:=@s[1];
i:=Length(s);
UTF8string_2_asciistring:=UTF8pchar_2_asciistring(p,i,u);
end;


Function ASCIIpchar_2_UTF8pchar(p:pchar;u:putf8conv;var utf8_d:longint):pchar;
var i,j,k:longint;
      s:string;
      w1,w2:word;
      z,z2:Pchar;

begin
i:=0;
j:=0;
k:=0;
GetMem(z,32768);
repeat
   w1:=byte(p[i]);
   if w1<128 then
      begin
      z[k]:=char(w1);
      inc(k);
      end
      else begin
      w2:=Preklad_ascii_2_unicode(w1,u);
      s:=Word2UTF8(w2);
      for j:=1 to Length(s) do
          begin
          z[k]:=char(s[j]);
          inc(k);
          end;
      end;
   inc(i);
until w1=0;

z[k]:=#0;
utf8_d:=k;
GetMem(z2,utf8_d);
Move(z^,z2^,utf8_d);
FreeMem(z,32768);
ASCIIpchar_2_UTF8pchar:=z2;
end;


Procedure NahrajUTF8Tabulku(s:string;var u:utf8conv);
var f:file;
    p:pointer;
    q:pchar;
    l:longint;
begin
Assign(f,s);
Reset(f,1);
l:=FileSize(f);
GetMem(p,l);
BlockRead(f,p^,l);
Close(f);
q:=p;
while q^<>#10 do inc(q);
inc(q,2);
Move(q^,u,sizeof(utf8conv));
FreeMem(p,l);
end;

Procedure Kurzor_On(x,y:byte);
begin
asm
mov ah,01h
mov ch,[x]
mov cl,[y]
int 10h
end;
end;

Procedure Kurzor_Off;
begin
asm
mov ah,01h
mov ch,20h
mov cl,00h
int 10h
end;
end;

{$IFNDEF FPC}
Procedure FillWord(var a;w,h:word);
var x:^word;
    i:word;
begin
x:=@a;
for i:=1 to w do
  begin
  x^:=h;
  inc(x);
  end;
end;

Procedure FindClose(var r:SearchRec);
begin
{dummy}
end;
{$ENDIF}

Function TextAdressOffset(x,y:byte):word;
begin
TextAdressOffset:=((y-1)*SIRKAOBRAZOVKY+(x-1))*2;
end;

Function ZjistiZnak(x,y:byte):byte;
begin
ZjistiZnak:=Mem[Segb800:TextAdressOffset(x,y)];
end;

Function ZjistiBarvu(x,y:byte):byte;
begin
ZjistiBarvu:=Mem[Segb800:TextAdressOffset(x,y)+1];
end;


Function Mon2stringX(x,y,d:byte):string;
var s:string;
    a:byte;
begin
s:='';
for a:=x to x+d-1 do s:=s+chr(ZjistiZnak(a,y));
Mon2stringX:=s;
end;

Function Mon2stringY(x,y,d:byte):string;
var s:string;
    a:byte;
begin
s:='';
for a:=y to y+d-1 do s:=s+chr(ZjistiZnak(x,a));
Mon2stringY:=s;
end;


Procedure PosunDolu(a,b,c,d,pocet,barva:byte);
begin
a:=a-1;b:=b-1;c:=c-1;d:=d-1;
asm
mov ah,07h
mov ch,b
mov cl,a
mov dh,d
mov dl,c
mov al,pocet
mov bh,barva
int 10h
end;
end;

Procedure PosunNahoru(a,b,c,d,pocet,barva:byte);
begin
a:=a-1;b:=b-1;c:=c-1;d:=d-1;
asm
mov ah,06h
mov ch,b
mov cl,a
mov dh,d
mov dl,c
mov al,pocet
mov bh,barva
int 10h
end;
end;

Procedure ZnakyVx(a,b,s,pp,pz:byte;c:char);
var
l,d:byte;
h:word;
begin
l:=pz*16+pp;h:=TextAdressOffset(a,b);
for d:=a to a+s-1 do begin
Mem[SegB800:h]:=Ord(c);Mem[SegB800:h+1]:=l;
h:=h+2;
end;
end;


Procedure SmazVyrez(a,b,c,d,color:byte);
var x,y:byte;
      w:word;
begin
color:=color shl 4+7;
for y:=b to d do
  begin
  w:=textadressoffset(a,y);
  for x:=a to c do
    begin
    Mem[SegB800:w]:=byte(' ');
    Mem[SegB800:w+1]:=color;
    inc(w,2);
    end;
  end;
end;

Procedure ZnakyVy(a,b,s,pp,pz:byte;c:char);
var
l,d:byte;
h:word;
begin
l:=pz*16+pp;h:=TextAdressOffset(a,b);
for d:=b to b+s-1 do begin
Mem[SegB800:h]:=Ord(c);Mem[SegB800:h+1]:=l;
h:=h+160;
end;
end;

Procedure Debug;
begin PockejNaKlavesu;end;

Function Str2Ptr(s:string):pointer;
var a:byte;
begin
if s='' then Str2Ptr:=nil else
   begin
   for a:=byte(s[0]) downto 1 do s[a+1]:=s[a];
   s[1]:=#0;
   Str2Ptr:=@s;
   end;
end;

Procedure NactiSoubor(var p:pointer;s:string);
{Pro soubory do 64Kb. Pozor! V prvnich dvou bajtech bufferu je velikost
souboru, ne jeho obsah}
var f:file;
    i:longint;
    b:^byte;
begin
Assign(f,s);
Reset(f,1);
i:=filesize(f);
GetMem(p,i+2);
Move(i,p^,2);
b:=p;
inc(b,2);
BlockRead(f,b^,i);
Close(f);
end;


Procedure VytvorSoubor(s:string;velikost:dword);
var f:file;
    a:byte;
begin
Assign(f,s);
Rewrite(f,1);
a:=0;
if velikost>1 then Seek(f,velikost-1);
if velikost>0 then BlockWrite(f,a,1);
Close(f);
end;


Function NactiRadkuTextovehoSouboru(var f:text;var p:pchar):longint;
var s:string;
    h:pchar;
    i:byte;
    d:char;
    a:longint;

begin
GetMem(h,16384);   {maximalni delka radky}
a:=0;
if not eof(f) then
   begin
   if not eoln(f) then
   repeat
     read(f,s);
     i:=length(s);
     if i>0 then
        begin
        Move(s[1],h[a],i);
        inc(a,i);
        end;
   until eoln(f);
   Read(f,d);
   if eoln(f) then
      if d=#13 then Read(f,d);
  end;

GetMem(p,a+1);
p[a]:=#0;
if a>0 then Move(h[0],p[0],a);
FreeMem(h,16384);
NactiRadkuTextovehoSouboru:=a;
end;


Procedure EpesniPozadi(pp,pz,styl:byte);
var r:byte;
begin
if (styl<1) or (styl>3) then styl:=1;
case styl of
1:styl:=176;
2:styl:=177;
3:styl:=178;
4:styl:=32;
end;
for r:=1 to 25 do ZnakyVx(1,r,80,pp,pz,Chr(styl));
end;
{
Procedure SchovejObrazovku(var p);
begin
Move(Ptr(Segb800,0)^,p,4000);
end;

Procedure ObnovObrazovku(var p);
begin
Move(p,Ptr(Segb800,0)^,4000);
end;
}
Procedure Swap(var a,b:longint);
var p:longint;
begin
p:=a;a:=b;b:=p;
end;

Procedure Swaps(var a,b:string);
var p:string;
begin
p:=a;a:=b;b:=p;
end;


Function Vysklonuj(a,b,c:string;n:longint):string;
{ Funkce vysklonuje retezec podle hodnoty <n> }
{ napriklad: 1 soubor ... 2 soubory ... 600 souboru }
var s:string;
begin
if n=0 then s:=c else
   if abs(n)=1 then s:=a else
      if abs(n) in [2..4] then s:=b else
         s:=c;
Vysklonuj:=s;
end;

procedure SetDisk(disk:byte);
begin
asm
MOV BL,disk
DEC BL
MOV AH, 0EH
MOV DL,BL
INT 21H
end;
End;

function MyGetDisk:Byte;
begin
asm
MOV AH,19H
INT 21H
INC AL
MOV @Result,AL
end;
End;

Function MyGetDir:string;
var s:string;
begin
GetDir(MyGetDisk,s);
MyGetDir:=s;
end;

Function ExistDrive(c:char):boolean;
var p:byte;
    s:string;
begin
c:=UpCase(c);
s:=LogDisk;
p:=Pos(c,s);
if p=0 then ExistDrive:=false else ExistDrive:=true;
end;

Function ExistDir(s:string):boolean;
{Zjisti,zda dany adresar existuje }
var r:searchrec;
    a:byte;
begin
if s='' then begin ExistDir:=false;Exit;end;
if s[1]='\' then s:=Chr(MyGetDisk+65)+':'+s;
a:=Length(s);
if (s[0]+s[2]=#2':') or (s[0]+s[2]+s[3]=#3':\') then
   begin ExistDir:=ExistDrive(s[1]);Exit;end;
if Copy(s,a,1)='\' then dec(s[0]);
r.attr:=0;
if s[2]=':' then s[1]:=OpravFantom(s[1]);
FindFirst(s,directory,r);
if DosError=0 then
   begin
   if ExistFile(s+'\nul') then ExistDir:=true else ExistDir:=false;
   end else ExistDir:=false;
FindClose(r);
end;

Function ExistFile(s:string):boolean;
{Zjisti,zda dany soubor existuje }
var r:searchrec;
begin
if s='' then begin ExistFile:=false;Exit;end;
if s[2]=':' then s[1]:=OpravFantom(s[1]);
FindFirst(s,archive+hidden+readonly+sysfile,r);
if DosError=0 then ExistFile:=true else ExistFile:=false;
FindClose(r);
end;

Function DriveReady(c:char):boolean;
var f:file;
begin
if not ExistDrive(c) then begin DriveReady:=false;Exit;end;
c:=OpravFantom(c);
{$I-}
Assign(f,c+':\nul');
Reset(f);
if IOresult<>0 then
   begin
   DriveReady:=false;
   end else begin Close(f);DriveReady:=true;end;
{$I+}
end;

Function DriveName(c:char):string;
var di:SearchRec;
    s:string;
    a:byte;
begin
c:=OpravFantom(c);
 FindFirst(c+':\*.*',VolumeID,di);
 if DosError=0 then
    begin
    s:=di.name;
    a:=Pos('.',s);
    if a<>0 then delete(s,a,1);
    DriveName:=s;
    end
    else DriveName:='';
FindClose(di);
end;


Function MakeDir(s:string):byte;
var t:dirstr;
    a,b,c,d:byte;
begin
c:=1;
if s[length(s)]='\' then dec(char(s[0]));
MakeDir:=0;
a:=Hmasis(s,'\');
for b:=1 to a+1 do
   begin
   d:=Search(s,'\',c);
   if d=0 then d:=byte(s[0])+1;
   t:=Mid(s,1,d-1);
   if not ExistDir(t) then MkDir(t);
   MakeDir:=IOresult;
   c:=d+1;
   end;
end;

Procedure CopyFile(s,t:string);
const BLOCKSIZE = 22000;
var f1,f2:file;
    p:pointer;
    d1:dirstr;
    d2,e2:namestr;
    d3,e3:extstr;
    w:word;
begin
Fsplit(s,d1,d2,d3);     { chceme jmeno a priponu zdroje }
if t[length(t)]='\' then t:=t+d2+d3;
Fsplit(t,d1,e2,e3);     { chceme adresar, jmeno a priponu cile }
if not ExistDir(d1) then
   begin
   MakeDir(d1);  { testneme zacatek cesty }
   if Doserror<>0 then Exit;
   end;
if ExistDir(d1+e2+e3) then t:=t+'\'+d2+d3;  { adresar nebo soubor ? }

{       writeln(t);         }
GetMem(p,BLOCKSIZE);
Assign(f1,s);
Assign(f2,t);
Reset(f1,1);
if IOresult<>0 then Exit;
Rewrite(f2,1);
if IOresult<>0 then Exit;
repeat
BlockRead(f1,p^,BLOCKSIZE,w);
if w>0 then BlockWrite(f2,p^,w);
if IOresult<>0 then Exit;
until w<BLOCKSIZE;
Close(f1);
Close(f2);
FreeMem(p,BLOCKSIZE);
end;


Procedure EraseFile(s:string);
var f:file;
begin
Assign(f,s);
Erase(f);
end;


Function _PrechodCesty(cesta,s:string):string;
var c,j,k:string;
    i:byte;
begin
i:=BackSearch(cesta,'\',1);
cesta:=Copy(cesta,1,Length(cesta));
FSplit(s,c,j,k);
if c='' then
   begin
   _PrechodCesty:=cesta+j+k;
   Exit;
   end;
if Pos(':',c)<>0 then begin _PrechodCesty:=s;Exit;end;
if s[1]='\' then
   begin
   s:=cesta[1]+cesta[2]+s;
   _PrechodCesty:=s;
   Exit;
   end;
_PrechodCesty:=cesta+s;
end;


Function MyFExpand(s:string):string;
{Funguje jako FExpand, ale volani na fantomove jednotky nahradi volanim na}
{jejich realne ekvivalenty.}
var c:char;
begin
if (s[2]=':') then s[1]:=OpravFantom(s[1]);
MyfExpand:=FExpand(s);
end;


Function PrechodCesty(cesta,s:string):string;
var t:string;
begin
t:=_PrechodCesty(cesta,s);
PrechodCesty:=MyFExpand(t);
end;


Function rad(x:real):real;
{ Funkce prevede stupne na radiany }
begin
rad:=x*pi/180;
end;

Function stupne(x:real):real;
{ Funkce prevede radiany na stupne }
begin
stupne:=180*x/pi;
end;

Function Tg(x:real):real;
{ vraci tangens }
begin
Tg:=sin(x)/cos(x);
end;

Function Cotg(x:real):real;
begin
Cotg:=cos(x)/sin(x);
end;

Function Obsah3u(a,b,c:real):real;
begin
Obsah3u:=(c/2)*sqrt(sqr(a)-sqr(sqr(a)/(2*c)+c/2-sqr(b)/(2*c)));
end;


procedure SortDir (var s:array of string;N: Word);
{ Setridi polozky v poli Dir dle abecedy - pouzito bublinkoveho trideni }
var
  i,k: Byte;
  s1,s2 : string;
begin { SortDir }
  for i := n-2 downto 0 do
    for k := 0 to i do
       begin
       s1:=Convert_Down(Convert_GB(s[k]));s2:=Convert_Down(Convert_GB(s[k+1]));
       if s1>s2 then swaps(s[k],s[k+1]);
       end;
end;  { SortDir }

procedure _QuickSort(var s:array of string;L,R: word);
var
  I, J: word;
  X, Y: string;
begin
  I := L;
  J := R;
  X := s[(L + R) div 2];               { vyhmatne si polovinu }
  repeat
    while s[I]<X do Inc(I);
    while X<s[J] do Dec(J);
    if I <= J then
    begin
      Y := s[I];
      s[I] := s[J];
      s[J] := Y;
      Inc(I);
      Dec(J);
    end;
  until I > J;
  if L < J then _QuickSort(s,L, J);
  if I < R then _QuickSort(s,I, R);
end;


Procedure QuickSort(var s:array of string;N: word);
begin
_QuickSort(s,1,n);
end;



Function IS_drive_ready(dsk:char):boolean;
var di:SearchRec;
begin {dskReady}
FindFirst(dsk+':\*.*',sysfile+hidden+archive+directory,di);
IS_drive_ready:=DosError in [0,18];
FindClose(di);
end;

Function Get_His_fantom(c:char):byte;
var r:registers;
    b:byte;
begin
b:=byte(upcase(c))-64;
r.ax:=$440e;
r.bx:=b;
Intr($21,r);
if (r.flags and fCarry)<>0 then Get_His_Fantom:=0 else Get_His_Fantom:=r.al;
end;

Function Get_Fantom_Drive:char;
var b:byte;
begin
b:=Get_His_fantom('A');
if b=0 then Get_Fantom_Drive:='0' else
if b=1 then Get_Fantom_Drive:='B' else
if b=2 then Get_Fantom_Drive:='A' else Get_Fantom_Drive:='0';
end;


Function Existuje_Floppy_mechanika(disk:byte):boolean;
{Zjisti, zda je zapojena disketova mechanika 0 nebo 1}
var r:registers;
begin
if disk>1 then Existuje_Floppy_mechanika:=false
   else begin
   r.ah:=$15;
   r.dl:=disk;
   Intr($13,r);
   Existuje_Floppy_mechanika:=not(odd(r.flags)) and (r.ah in [1,2]);
   end;
end;

Function ZkontrolujCestu(var s:string):boolean;
{Nastavi vysledek podle toho, jestli je platna cesta. Pokud jednotka cesty
 odkazuje na fantomovou jednotku (jednotka B:), tak zmeni specifikaci
 jednotky na A:}
var t,l1,l2:string;
    b:boolean;
    c:byte;
    d:char;

begin
c:=Length(s);
if c<2 then begin ZkontrolujCestu:=false;Exit;end;
if c=2 then s:=s+'\';
t:=MyFExpand(s);
t:=StripPath(t);
ZkontrolujCestu:=ExistDir(t);
end;


function LogDisk:string;
var s:string;
    x:byte;
    akt:byte;
begin
s:='';akt:=MyGetDisk;
for x:=1 to 26 do
   begin
   SetDisk(x);
   if x=MyGetDisk then s:=s+(char(x+64));
   end;
SetDisk(akt);
LogDisk:=s;
end;

Function LogDiskPlus:string;
var s:string;
    a:byte;
    c:char;
begin
c:=Get_Fantom_Drive;
s:=LogDisk;
a:=Pos('A',s);
if a<>0 then if c='A' then delete(s,a,1);
a:=Pos('B',s);
if a<>0 then if c='B' then delete(s,a,1);
LogDiskPlus:=s;
end;


Function OpravFantom(c:char):char;
{Zkontroluje, jestli je C specifikace fantomove jednotky. Pokud ano, tak ho
 zameni za realny ekvivalent}
var s,t:string;
    d:char;
begin
d:=UpCase(c);
s:=logdisk;
t:=logdiskplus;
if Pos(d,s)<>0 then
   if Pos(d,t)=0 then
      if d='A' then c:='B' else if d='B' then c:='A';
OpravFantom:=c;
end;


Procedure NatahniTdskNumInfo(dsk:char;var t:TdskNumInfo);
var l:dword;
    a,b:word;
    c:byte;
    r:registers;

begin
 {TAKTO NE: "c:=Pos(UpCase(dsk),Logdisk);" (nechavam to tu jako vystrahu)}
 c:=byte(UpCase(dsk))-64;  {Takto je to spravne}
 {$IFDEF FPC}
 CopyToDOS(t,SizeOf(TdskNumInfo));
 r.ax:=$6900;
 r.bx:=c;
 r.ds:=tb_segment;
 r.dx:=tb_offset;
 MsDOS(r);
 CopyFromDOS(t,sizeof(TdskNumInfo));
 {$ELSE}
 asm
 mov ax,6900h
 mov bl,c
 xor bh,bh
 push si
 push ds
 lds di,t
 mov dx,di
 int 21h
 pop ds
 pop si
 end;
 {$ENDIF}
end;


Function SerioveCislodisku(dsk:char):string;
var t:tdsknuminfo;
    s:string;
begin
NatahniTdskNumInfo(dsk,t);
s:=Dec2Hex(t.serialnum);
s:=Xchar(8-Length(s),'0')+s;
Insert('-',s,5);
SerioveCislodisku:=s;
end;


Function FATtype(drive:char):string;
var a:byte;
    t:tdsknuminfo;
    s:string;
begin
NatahniTdskNumInfo(drive,t);
s:='';
for a:=0 to 7 do
    if not (t.fattype[a] in [#0,#32]) then s:=s+t.fattype[a] else Break;
FATtype:=s;
end;

{Funkce na zjisteni FAT12/16/32 volneho a celkoveho mista na disku}
{-----------------------------------------------------------------}
{V turbo pascalu to neni implementovane vubec, ve FPC 1.x.y chybne a az
 v FPC 2.x.y je to v poradku}

type
TExtendedFat32FreeSpaceRec = packed record
    RetSize           : word;      { $00 }
    Strucversion      : word;      { $02 }
    SecPerClus,                    { $04 }
    BytePerSec,                    { $08 }
    FreeClusters,                  { $0C }
    TotalClusters,                 { $10 }
    FreePhysSect,                  { $14 }
    TotalPhysSect,                 { $18 }
    FreeAllocUnits,                { $1C }
    TotalAllocUnits   : dword;     { $20 }
    Dummy,                         { $24 }
    Dummy2            : dword;     { $28 }
    DrivePchar:array[0..3] of char;{ $2C }
    {DriveChar neni oficialni soucast bloku, ale proste sem ulozim urceni
     jednotky.}
end;

Function Data_z_FAT16(c:char;free:boolean):real;
{Zjisti volne a celkove misto z disku s FAT12/16}
var b:byte;
    r:registers;
    rax,rbx,rcx,rdx:real;

begin
b:=ord(c)-64;
r.dl:=b;
r.ah:=$36;
intr($21,r);
if r.ax=$FFFF then begin Data_z_FAT16:=-1;Exit;end;

rax:=r.ax;
rbx:=r.bx;
rcx:=r.cx;
rdx:=r.dx;

if free then Data_z_FAT16:=rax*rbx*rcx
        else Data_z_FAT16:=rax*rcx*rdx;
end;


Function Data_z_FAT32(c:char;free:boolean):real;
var b:byte;
    r:registers;
    m:real;
    s:string;
    buf:TExtendedFat32FreeSpaceRec;
begin
s:=c+':\'+#0;
FillChar(buf,sizeof(TExtendedFat32FreeSpaceRec),0);

{$IFDEF FPC}
Move(s[1],buf.DrivePChar,4);
CopyToDos(buf,sizeof(TExtendedFat32FreeSpaceRec));
r.ax:=$7303;
r.cx:=sizeof(TExtendedFat32FreeSpaceRec);
r.ds:=tb_segment;
r.dx:=tb_offset+$2C;
r.es:=tb_segment;
r.di:=tb_offset;
Intr($21,r);
CopyFromDOS(buf,sizeof(TExtendedFat32FreeSpaceRec));

{$ELSE}
r.ax:=$7303;
r.cx:=sizeof(TExtendedFat32FreeSpaceRec);
r.ds:=Seg(s[1]);
r.dx:=Ofs(s[1]);
r.es:=Seg(buf);
r.di:=Ofs(buf);
Intr($21,r);
{$ENDIF}

if ((r.flags and fCarry)<>0) or (buf.BytePerSec=0) then
   begin {Nastaven CF? V tom pripade nebyla funkce uspesna.}
   Data_z_FAT32:=-1;
   Exit;
   end;

m:=buf.BytePerSec;    {budu nasobit postupne, abych nepretekl}
m:=m*buf.SecPerClus;  {a tak, aby mi to vzal i turbo pascal}

if free then m:=m*buf.FreeAllocUnits else m:=m*buf.TotalAllocUnits;
Data_z_FAT32:=m;
end;


Function Zjisti_FAT_Data(c:char;free:boolean):real;
var r:real;

begin
r:=Data_z_FAT32(c,free);
if r<0 then r:=Data_z_FAT16(c,free);
Zjisti_FAT_Data:=r;
end;


Function TotalDiskSpace(c:char):real;
begin
c:=UpCase(c);
TotalDiskSpace:=Zjisti_FAT_data(c,false);
end;

Function FreeDiskSpace(c:char):real;
begin

c:=UpCase(c);
FreeDiskSpace:=Zjisti_FAT_data(c,true);
end;


Function Get_IOCTL_disk_info(dsk:char;maj,min:byte;var buffer):word;
var r:registers;
    b:byte;
    s:string;
begin
dsk:=upcase(dsk);
b:=byte(dsk)-64;
r.ax:=$440d;
r.ch:=maj;
r.cl:=min;
r.bl:=b;
s[0]:=#255;
{$IFDEF FPC}
CopyToDOS(s,4);
r.ds:=tb_segment;
r.dx:=tb_offset;
Intr($21,r);
CopyFromDOS(buffer,255);
{$ELSE}
r.ds:=seg(s);
r.dx:=ofs(s);
Intr($21,r);
Move(s,buffer,255);
{$ENDIF}
if (r.flags and fCarry)=0
   then Get_IOCTL_disk_info:=0
   else Get_IOCTL_disk_info:=r.ax;
end;


Function Je_disk_vymenitelny(dsk:char):boolean;
var s:string[255];
    w:word;
begin
w:=Get_IOCTL_disk_info(dsk,$8,$60,s);
if w=0 then Je_disk_vymenitelny:=((byte(s[2]) and 1)=0) else Je_disk_vymenitelny:=false;
end;


Function Je_disk_zapisovatelny(dsk:char):boolean;
var s:string[24];
    f:text;
    i,j:longint;

begin
{$I-}
dsk:=UpCase(dsk);
s:=dsk+':\nul';
Assign(f,s);
Rewrite(f);
i:=IOresult;
Close(f);
j:=IOresult;
{$I+}
Je_disk_zapisovatelny:=i=0;
end;



Function Get_IOCTL_Drive_Type(dsk:char):byte;
{255 = CHYBA}
{0 = 5,25 DD (320/360KB) disk}
{1 = 5,25 HD (1,2MB) disk}
{3 = 8,0 disk, single density}
{4 = 8,0 disk, double density}
{5 = hard disk}
{6 = paskova jednotka}
{7 = 3,5 HD (1,44MB) disk}
{8 = opticky disk}
{9 = 3,5 disketa s kapacitou 2,88MB}
var s:string[255];
    w:word;
begin
w:=Get_IOCTL_disk_info(dsk,$8,$60,s);
if w=0 then Get_IOCTL_Drive_Type:=byte(s[1]) else Get_IOCTL_Drive_Type:=255;
end;


Function Get_IOCTL_Fyz_Drive(dsk:char):byte;
{Dle Interrupt listu funguje jen v MS-DOSu 7.0, ve skutecnosti ale musi i
 bezet windows}
var s:string[255];
    w:word;
begin
w:=Get_IOCTL_disk_info(dsk,$8,$6f,s);
if w=0 then Get_IOCTL_Fyz_Drive:=byte(s[3]) else Get_IOCTL_Fyz_Drive:=255;
end;


Function Get_IOCTL_Media(dsk:char):byte;
var s:string[255];
    w:word;
begin
w:=Get_IOCTL_disk_info(dsk,$8,$68,s);
if w=0 then Get_IOCTL_Media:=byte(s[1]) else Get_IOCTL_Media:=255;
end;


Function Get_CMOS_byte(index:byte):byte;assembler;
asm
mov dx,70h
mov al,index
out dx,al
inc dx
in al,dx
end;


Function Zjisti_typ_disketovky(d:byte):byte;
{B je bud 0 nebo 1}
{Vraci nasledujici hodnoty:
    0 = jednotka neexistuje
    1 = 360 KB 5.25 Drive
    2 = 1.2 MB 5.25 Drive
    3 = 720 KB 3.5 Drive
    4 = 1.44 MB 3.5 Drive
    5 = 2.88 MB 3.5 drive}
var a:byte;
begin
if d>1 then Zjisti_typ_disketovky:=0
   else begin
   a:=Get_CMOS_byte($10);
   if d=0 then a:=a shr 4 else a:=a and 15;
   Zjisti_typ_disketovky:=a;
   end;
end;


procedure Pol2Kar(x,y:integer;v,u:real;var i,j:integer);
{ Funkce provede prevod z polarnich souradnic na souradnice kartezske }
{ X,Y jsou souradnice vztazneho bodu,V je vzdalenost,U je svirajici uhel }
var a,b:real;
begin
u:=rad(u);                         { prevede uhel na radiany }
a:=cos(u)*v;b:=sin(u)*v;
i:=round(x+a);j:=round(y-b);
end;

Procedure Kar2Pol(x,y,i,j:longint;var v,u:real);
{ Prevede kartezske souradnice na polarni }
begin
x:=x-i;y:=y-j;
v:=sqrt(x*x+y*y);

if x=0 then u:=pi/2 else u:=ArcTan(abs(y)/abs(x));
u:=Stupne(u);
if (y>0) and (x>0) then u:=180-u else
   if (y<=0) and (x>0) then u:=180+u else
   if (y<0) and (x<=0) then u:=360-u;
end;

Function ArcSin(x:real):real;
begin ArcSin:= ArcTan (x/sqrt (1-sqr (x)));
end;

Function ArcCos(x:real):real;
begin ArcCos:= ArcTan (sqrt (1-sqr (x)) /x);
end;

Function Fac(i:integer):longint;
var a:integer;
    b:longint;
begin
if i=0 then Fac:=1 else
   begin
   b:=1;
   for a:=1 to i do b:=b*a;
   Fac:=b;
   end;
end;

Function FormNum(a:real;d:byte):string;
var x:real;
    i,j,k:byte;
    s,t:string;
begin
s:=MyStr(Trunc(a));
i:=Length(s);
j:=0;
repeat
if j=3 then begin Insert(oddelovac_tisicu,s,i+1);j:=0;end;
dec(i);inc(j);
until i=0;
x:=Frac(a);
for i:=1 to d do x:=x*10;
t:=MyStr(Trunc(x));
k:=Length(t)+1;
i:=0;
j:=0;
repeat
inc(j);inc(i);
if j=4 then begin Insert(oddelovac_desetitisicin,t,i);j:=0;end;
until i=k;
if d>0 then t:=desetinna_carka+t else t:='';
FormNum:=s+t;
end;


Procedure FPC_Vypni_Signaly_pro_CTRL_c_a_CTRL_Break;
{Tyka se jen FPC - vypne otravne vyskakovani z programu po zmacknuti
 CTRL-C, CTRL-\ a CTRL-Break}
begin
{$IFDEF FPC}
djgpp_hwint_flags:=3;
{$ENDIF}
end;


{$IFDEF FPC}
Function Test_CPUID:boolean;assembler;
{zjisti, zda pocitac instrukci CPUID vubec podporuje}
asm

PushfD
Pop eax
    Bt eax,21
    Setc dl
    Btc eax,21
Push eax
PopfD
PushfD
Pop eax
Bt eax,21
Setc cl
Mov ax,0
Cmp dl,cl
Je @konec
inc ax
@konec:
end;


Function CallCPUID(par_eax:longint;var fax,fbx,fcx,fdx:longint):boolean;
{Pokud procesor zna CPUID, tak ho zavola, ulozi vysledky a vrati TRUE.
 Kdyz nezna, tak vrati FALSE}
var gax,gbx,gcx,gdx:longint;
begin
if procesor_zna_cpuid=255 then
   if test_CPUID=true then procesor_zna_cpuid:=1 else procesor_zna_cpuid:=0;

if procesor_zna_cpuid=0 then
   begin
   CallCPUID:=false;
   Exit;
   end;

asm
mov eax,par_eax
cpuid
mov gax,eax
mov gbx,ebx
mov gcx,ecx
mov gdx,edx
end;
fax:=gax;
fbx:=gbx;
fcx:=gcx;
fdx:=gdx;
CallCPUID:=true;
end;


{$ELSE}

Function Test_CPUID:boolean;
{zjisti, zda pocitac instrukci CPUID vubec podporuje}
var res:boolean;
begin
inline($66/$9C/$66/$58/$66/$0F/$BA/$E0/$15/$0F/$92/$C2/$66/$0F/$BA/$F8/$15/$66/$50/$66/$9D/
       $66/$9C/$66/$58/$66/$0F/$BA/$E0/$15/$0F/$92/$C1);


{PushfD
Pop eax
    Bt eax,21
    Setc dl
    Btc eax,21
Push eax
PopfD
PushfD
Pop eax
    Bt eax,21
    Setc cl}
asm
    Mov ax,0
    Cmp dl,cl
  Je @konec
    inc ax
@konec:
mov res,al
end;
Test_CPUID:=res;
end;


Function CallCPUID(par_eax:longint;var fax,fbx,fcx,fdx:longint):boolean;
{Pokud procesor zna CPUID, tak ho zavola, ulozi vysledky a vrati TRUE.
 Kdyz nezna, tak vrati FALSE}
var gax,gbx,gcx,gdx:longint;
begin
if procesor_zna_cpuid=255 then
   if test_CPUID=true then procesor_zna_cpuid:=1 else procesor_zna_cpuid:=0;

if procesor_zna_cpuid=0 then
   begin
   CallCPUID:=false;
   Exit;
   end;
asm
db 66h;mov ax,par_eax.word
db 0fh;db 0a2h  {CPUID}
db 66h;mov gax.word,ax
db 66h;mov gbx.word,bx
db 66h;mov gcx.word,cx
db 66h;mov gdx.word,dx
end;
fax:=gax;
fbx:=gbx;
fcx:=gcx;
fdx:=gdx;
CallCPUID:=true;
end;
{$ENDIF}



Procedure MyGetMem(var p:pointer;l:longint);
var q:pchar;
begin
GetMem(p,l);
q:=p;
inc(q,l-1);
q^:=#0;
end;

Function IzolujSlovo(s:string;b:byte):string;
const oddelovace:set of char = [' ','.',',',';',#13,#10];
var a,c,d:byte;
begin
a:=b;
c:=b;
d:=Length(s)+1;
while (a>0) and (not (s[a] in oddelovace)) do dec(a);
while (c<d) and (not (s[c] in oddelovace)) do inc(c);
IzolujSlovo:=Copy(s,a+1,c-a-1);
end;


Function IzolujPrvniCislo(s:string):longint;
var a,b:byte;
    nalezeno:boolean;
    t:string;
begin
nalezeno:=false;
for a:=1 to Length(s) do
    if s[a] in ['0'..'9'] then
       begin
       for b:=a to Length(s) do
           if not (s[b] in ['0'..'9']) then begin nalezeno:=true;Break;end;
       if nalezeno then dec(b);
       t:=Copy(s,a,b-a+1);
       IzolujPrvniCislo:=MyVal(t);
       Exit;
       end;
IzolujPrvniCislo:=0;
end;



Procedure Wait250ns;assembler;
{ Chvili ceka }
{ Zachova registry. }
 asm
     push cx;mov cx,45;@1:nop;loop @1;pop cx;
 end;

Procedure PovolBlikani(blik:boolean);assembler;
{ V textmodu nastavi chovani 7.bitu atributu znaku.        }
{ Muze zpusobovat blikani nebo byt 4.bitem barvy pozadi.   }
{ Defaultne byva true, blikani.                            }
 asm
 pusha
     mov povol_blik,0
     mov dx,3dah;in al,dx
     mov dx,3c0h;mov al,30h;out dx,al
     inc dx
     in al,dx
     dec dx
     and al,11110111b
     cmp blik,false;jz @do
     or al,00001000b
     mov povol_blik,1
     @do:
     call wait250ns
     out dx,al
 popa
 end;

Procedure VypniPaprsek;assembler;
asm
pusha         { Vypne videosignal }
mov dx,3c4h
mov al,1
out dx,al
inc dx
in al,dx
mov oldportvalue,al
or al,20
out dx,al
popa
end;

Procedure ZapniPaprsek;assembler;
asm      { Zapne videosignal. Kdyz uz je ale predtim zapnuty, tak se to }
pusha    { silene posere, proto pozor !                                 }
mov dx,3c4h
mov al,1
out dx,al
inc dx
mov al,oldportvalue
out dx,al
popa
end;

Function ZjistiPrepinac:char;assembler;
asm
mov ax,3700h
int 21h
mov al,dl
end;

Function Uvnitr(x,y,x1,y1,x2,y2:longint):boolean;
begin
Uvnitr:=(x>=x1) and (x<=x2) and (y>=y1) and (y<=y2);
end;

Function Distance(X1,Y1,X2,Y2:double):double;
begin
{$IFDEF FPC}
asm
   FLD   X1
   FLD   X2
   FSUB
   FLD   st(0)
   FMUL
   FLD   Y1
   FLD   Y2
   FSUB
   FLD   st(0)
   FMUL
   FADD
   FSQRT
   FWAIT
end;
{$ELSE}
Distance := SQRT(SQR(X1-X2)+SQR(Y1-Y2));
{$ENDIF}
end;


Function Prunik(ax1,ay1,ax2,ay2,bx1,by1,bx2,by2:longint):boolean;
begin
Prunik:=(ax1<=bx2) and (ax2>=bx1) and (ay1<=by2) and (ay2>=by1);
end;


Procedure Clipping(var x,y:longint;x1,y1,x2,y2:longint);
begin
if x<x1 then x:=x1;
if y<y1 then y:=y1;
if x>x2 then x:=x2;
if y>y2 then y:=y2;
end;


Function GetCommandLine:string;
Var s:pstring;
    t1,t2:string;
    w,w2,lcl:word;
    r:registers;
begin
{$IFDEF FPC}
t1:=cmdline;      {CMDLINE : preddefinovana vnitrni promenna Freepascalu}
lcl:=Length(t1);
t2:='';
for w:=Length(ParamStr(0))+1 to LCL do {V CmdLine je obsazen i nazev EXE}
    if t1[w]>#32 then                  {...ten chceme odseparovat}
       begin
       t2:=Copy(t1,w,LCL-w+1);
       break;
       end;
GetCommandLine:=t2;
{$ELSE}
s:=Ptr(PrefixSeg,128);
GetCommandLine:=s^;
{$ENDIF}
end;


Function LFN_is_or_not:boolean;
{jsou dostupne funkce "long file names" - LFN?}
var r:registers;
    s,t:string;
    b:byte;
    w:word;

begin
{$IFDEF FPC}
LFN_is_or_not:=LFNsupport;
{$ELSE}
s:=Fexpand(ParamStr(0));
s:=Copy(s,1,3)+#0;          {zjistim disk ze ktereho je spusten nas program}
FillChar (R, SizeOf (R), 0);
R.AX:=$71a0;
R.flags:=R.flags or 1;  {nastavi CF}
R.DS:=Seg(s);
R.DX:=Ofs(s)+1;
R.ES:=Seg(t);
R.DI:=Ofs(t);
R.CX:=32;
MsDOS (R);
w:=r.flags and fCarry;
if w=0
   then LFN_is_or_not:=(r.bx and $4000)<>0
   else LFN_is_or_not:=false;
{$ENDIF}
end;


function LFNParamCount(s:string):integer;
   { Replaces standard "ParamCount" function }
   var b,o:boolean;
       c,x:byte;

   begin
   if s='' then begin LFNParamCount:=0;Exit;end;
   b:=false;
   o:=false;
   x:=1;
   for c:=1 to Length(s) do
       if s[c]='"' then begin if b=false then inc(x);b:=not b;end else
       if b=false then
          if s[c]=' ' then o:=false
                      else if o=false then
                              begin
                              inc(x);
                              o:=true;
                              end;

   if b=true then begin LFNParamCount:=-1;Exit;end;
   LFNParamCount:=x-1;
   end;

function LFNParamStr(s:string;n:byte):string;
   var b,o:boolean;
       c,d:byte;
       x:shortint;

   begin
   if s='' then begin LFNParamStr:='';Exit;end;
   b:=false;
   o:=false;
   x:=0;
   for c:=1 to Length(s) do
       if s[c]='"' then
          begin
          if b=false then
             begin
             inc(x);
             if x=n then
                begin
                d:=Search(s,'"',c+1);
                if d=0 then begin LFNParamStr:='';Exit;end;
                LFNParamStr:=Mid(s,c+1,d-1);
                Exit;
                end;
             end;
          b:=not b;
          end else
          if b=false then
             if s[c]=' ' then o:=false
             else if o=false then
                     begin
                     inc(x);
                     if x=n then
                        begin
                        d:=Search(s,' ',c);
                        if d=0 then d:=Length(s)+1;
                        LFNParamStr:=Mid(s,c,d-1);
                        Exit;
                        end;
                     o:=true;
                     end;
   LFNParamStr:='';
   end;

Procedure GetDPMIinfo(var d:dpmiinfoblock);
{dpmiinfoblock = record
0   major:byte;
1   minor:byte;
2   virtualizace:boolean;
3   bits:byte;
4   v86:boolean;
5   dirtypagging:boolean;
6   exceptions:boolean;
7   mapdevices:boolean;
8   baseremap:boolean;
9   vendor_version_major:byte;
10  vendor_version_minor:byte;
11  present:boolean
12  in_protected_mode:boolean;
13  vendor:string[126];
   end;}
const msd:pchar = 'MS-DOS';
var s:string;
    b:boolean;
    p:pchar;
    i,j:word;
    min,maj:byte;
    win:boolean;
    rdx:word;
    paddr:record pofs,pseg:word;end;
begin
fillChar(d,sizeof(dpmiinfoblock),0);
{Napred je potreba zkontrolovat, jestli je pritomno DPMI rozhrani. Problem
delaji windows, ktere chteji, aby tato kontrola byla v realnem modu. Kvuli
nim napred zkontroluju rezim procesoru. Kdyz nahlasi, ze je v DPMI protektu,
tak je jasne, ze je DPMI instalovano.}
asm
mov ax,1686h
int 2fh
mov i,ax
end;
d.present:=i=0;
d.in_protected_mode:=d.present;
if not d.in_protected_mode then
   begin        {pripad, kdy je DPMI instalovano, ale jsme v realu}
   asm          {muze nastat v TP, nikoliv ve FP}
   mov ax,1687h
   int 2fh
   mov j,si
   mov i,ax
   mov rdx,dx
   mov ax,es
   mov paddr.pseg,ax
   mov paddr.pofs,di
   end;
   d.present:=i=0;
   end;

if not d.present then Exit;
if not d.in_protected_mode then
   begin
   {DPMI server instalovany/ je, ale neni aktivni}
   d.major:=Hi(rdx);
   d.minor:=Lo(rdx);
   Exit;
   end;
{}
{$IFDEF FPC}
asm
mov ax,400h
int 31h
mov esi,d
mov [esi+0],ah
mov [esi+1],al
mov cx,bx
mov ch,16
and cl,1
shl ch,cl
mov [esi+3],ch
mov ax,bx
shr al,1
and al,1
xor al,1
mov [esi+4],al
mov ax,bx
shr al,2
and al,1
mov [esi+2],al

mov esi,msd
mov ax,168Ah
push es
push edi
int 2fh
pop edi
pop es
mov win,0
cmp al,0
jnz @nejsme_ve_windows
mov win,1
@nejsme_ve_windows:
mov esi,d

lea edi,s
mov ax,401h
int 31h
mov b,0
jc @konec
mov b,1
mov bl,1
test ax,1
je @a1
mov [esi+5],bl
@a1:
test ax,2
je @a2
mov [esi+6],bl
@a2:
test ax,4
je @a3
mov [esi+7],bl
@a3:
test ax,8
je @a4
mov [esi+8],bl
@a4:
@konec:
end;

{$ELSE}

asm
push ds
push si
lds si,d
mov al,0
cmp ds:[si+12],al
jnz @jsem_v_protektu
(*{------------ prepnuti do protektu --------------}
	mov	bx,j {allocate memory for DPMI data}
	mov	ah,48h
	int	21h
        mov	es,ax
	mov	ax,1
	call	far [paddr]    {prepnuti do protektu}

{------------------------------------------------}*)

@jsem_v_protektu:
mov ax,400h
int 31h
mov ds:[si+0],ah
mov ds:[si+1],al
mov cx,bx
mov ch,16
and cl,1
shl ch,cl
mov ds:[si+3],ch
mov ax,bx
shr al,1
and al,1
xor al,1
mov ds:[si+4],al
mov ax,bx
shr al,2
and al,1
mov ds:[si+2],al
pop si
pop ds


push ds
push es
push si
push di
lea di,s
mov ax,ds
mov es,ax
mov ax,401h

int 31h

lds si,d
mov b,0
jc @konec
mov b,1
mov bl,1
test ax,1
je @a1
mov [si+5],bl
@a1:
test ax,2
je @a2
mov [si+6],bl
@a2:
test ax,4
je @a3
mov [si+7],bl
@a3:
test ax,8
je @a4
mov [si+8],bl
@a4:

@konec:
pop di
pop si
pop es
pop ds
end;

{$ENDIF}

j:=Get_windows_version;
case j of
1,2:begin
    d.vendor:='Windows';
      asm
      mov ax,160ah
      int 2fh
      mov maj,bh
      mov min,bl
      end;
    d.vendor_version_major:=maj;
    d.vendor_version_minor:=min;
    end;

3: begin
      d.vendor:='Windows/NTVDM';
      d.vendor_version_major:=0;
      d.vendor_version_minor:=9;
   end;

else begin
   d.vendor_version_major:=byte(s[0]);
   d.vendor_version_minor:=byte(s[1]);
   p:=@s[2];
   i:=PLength(p);
   s[1]:=char(i);
   Move(s[1],d.vendor,i+1);
   end;
end;
end;



{$IFDEF FPC}
Function INTE820(var _ebx,_ecx:longint;buffer:pmementry):boolean;
var b:byte;
    d:dword;
    r:TRealRegs;
begin
buffer^.fill[0]:=1;
r.ebx:=_ebx;
r.edx:=$534D4150;
r.ecx:=24;
r.eax:=$0e820;
r.es:=tb_segment;
r.di:=tb_offset;
CopyToDOS(buffer^,sizeof(mementry));
RealIntr($15,r);
if (r.eax<>$534D4150) or ((r.flags and fcarry)<>0) then
   begin
   _ebx:=0;
   _ecx:=0;
   INTE820:=false;
   Exit;
   end;
_ecx:=r.ecx;
_ebx:=r.ebx;
CopyFromDOS(buffer^,sizeof(mementry));
INTE820:=true;
end;
{$ELSE}
Function INTE820(var _ebx,_ecx:longint;buffer:pmementry):boolean;assembler;
asm
push ds
push es
push si
push di
lds si,_ebx
db 66h;mov bx,ds:[si]                       {mov EBX,_ebx}
mov dx,534dh;db 66h;shl dx,16;mov dx,4150h  {mov EDX,534D4150h "SMAP"}
db 66h;xor cx,cx;mov cx,24                  {mov ECX,24}
db 66h;xor ax,ax;mov ax,1                   {mov EAX,1}
les di,buffer
db 66h;mov es:[di+20],ax
db 66h;xor ax,ax;mov ax,0e820h
int 15h

db 66h;mov ds:[si],bx


jc @chyba {pochopitelne se vztahuje k INT, ne k MOV}
mov dx,534dh;db 66h;shl dx,16;mov dx,4150h  {mov EDX,534D4150h "SMAP"}
db 66h;cmp ax,dx
jne @chyba

lds si,_ecx
db 66h;mov ds:[si],cx

mov al,1
jmp @konec

@chyba:

mov al,0
@konec:
pop di
pop si
pop es
pop ds
end;
{$ENDIF}


{$IFDEF FPC}
Function INTE801(var _ax,_bx,_cx,_dx:word):boolean;
var r:TRealRegs;
begin
r.eax:=$0e801;
RealIntr($15,r);
if (r.flags and fCarry)<>0 then INTE801:=false
   else begin
   _ax:=r.ax;
   _bx:=r.bx;
   _cx:=r.cx;
   _dx:=r.dx;
   INTE801:=true;
   end;
end;
{$ELSE}
Function INTE801(var _ax,_bx,_cx,_dx:word):boolean;assembler;
asm
clc
push es
push di
mov ax,0e801h
int 15h
jnc @ok

xor al,al
jmp @konec

@ok:
les di,_ax;mov es:[di],ax
les di,_bx;mov es:[di],bx
les di,_cx;mov es:[di],cx
les di,_dx;mov es:[di],dx
mov al,1

@konec:
pop di
pop es
end;
{$ENDIF}


Function DetectBaseMemory:word;assembler;
{Zjisti mnozstvi instalovane konvencni pameti v kilobajtech}
asm
clc
xor ax,ax
int 12h
jnc @konec
xor ax,ax
@konec:
end;



Function DetectExtendedMemory_88h:word;assembler;
{Archaicky zpysob pres INT15h/AH=88h}
asm
clc
mov ah, 88h
int 15h
jnc @konec
mov ax,0
@konec:
end;




Function DetectMemory_88h:word;
{Zachrana, pokud selze INTe820 i INTe801}
var w:word;
begin
w:=DetectExtendedMemory_88h;
if w=0 then w:=Get_CMOS_byte($17) + 256*longint(Get_CMOS_byte($18));

DetectMemory_88h:=DetectBaseMemory+W;
end;


Function DetectMemory:word;
{Zjisti celkove mnozstvi instalovane mapeti RAM. Detekuje i pamet nad 4GB.}
{Vysledek vraci v megabajtech}
var p:pmementry;
    ebx,ecx:longint;
    b,c,posl,konec:boolean;
    r1,r2,r,s:comp;
    ax,bx,cx,dx:word;
begin
New(p);
ebx:=0;
s:=0;
posl:=false;
konec:=false;
b:=IntE820(ebx,ecx,p);
if b=false then
   begin
   b:=INTE801(ax,bx,cx,dx);
   if b=true then
      begin
      if (ax=0) and (bx=0) then begin r1:=cx;r2:=dx;end
                           else begin r1:=ax;r2:=bx;end;
      r1:=r1+DetectBaseMemory;      {pripocitam dolni pamet}
      s:=r2*64+r1;
      detectmemory:=round(s/1024);
      end
      else begin
      s:=DetectMemory_88h;
      detectmemory:=round(s/1024);
      end;
   Exit;
   end;  {funkce nepodporovana}
repeat
if ecx<=20 then c:=true else c:=odd(p^.fill[0]);
   if C then
      begin
      if p^.typ=1 then
         begin
         r1:=Dword2Real(p^.delka[1]);
         r2:=Dword2Real(p^.delka[2]);
         r:=maxlongint;
         r:=r*2+2;
         r:=r2*r+r1;
         {r:=r2*$100000000+r1;}
         s:=s+r;
         end;
      end;

if posl=false
   then b:=IntE820(ebx,ecx,p)
   else konec:=true;
if ebx=0 then posl:=true;

until konec=true;
Dispose(p);
Detectmemory:=Round(s/1024/1024);
end;


Procedure Init_GDT_for_move;
begin
FillChar(gdt,sizeof(gdt_type),0);
with gdt do begin
src_sglimit:=$ffff;     {limit segmentu 15:0}
src_access:=$93;        {nastaveni pristupu, ring 0, povoleni pro zapis dat}
src_pglimit:=$cf;       {page-granular limit; 32-bit segment; limit 19:16}
dst_sglimit:=$ffff;
dst_access:=$93;
dst_pglimit:=$cf;
end;
prepared_GDT_for_move:=true;
end;

Procedure MoveToHighMemory(var data;kam:dword;pocet:word);
{$IFDEF FPC}
var zd:dword;
    dd:longint;
    r:registers;
begin
if not prepared_GDT_for_move then Init_GDT_for_move;
dd:=Global_DOS_Alloc(65536);
DOSMemPut(Word(dd shr 16),0,data,pocet);
zd:=Word(dd shr 16)*16;
gdt.src_base_15_0:=zd and 65535;             {nastavim zdroj}
gdt.src_base_23_16:=(zd shr 16) and 255;
gdt.src_base_31_24:=(zd shr 24);

gdt.dst_base_15_0:=kam and 65535;            {nastavim cil}
gdt.dst_base_23_16:=(kam shr 16) and 255;
gdt.dst_base_31_24:=(kam shr 24);
CopyToDOS(gdt,sizeof(gdt_type));
r.ax:=$8700;
r.cx:=pocet div 2;
r.es:=tb_segment;
r.si:=tb_offset;
RealIntr($15,r);
Global_DOS_Free(word(dd));
end;
{$ELSE}
begin
if not prepared_GDT_for_move then Init_GDT_for_move;
asm
les di,data  {realmodova adresa DATA do DS:SI}
mov ax,es    {vezmu segmentovou cast adresy}
mov dx,16
mul dx       {segmentovou cast adresy vynasobim 16 - prevod na liearni adresu}
add ax,di    {prictu offsetovou cast}
adc dx,0     {korekce pripadneho preteceni}

mov word [gdt +18],ax    {base_15_0}
mov byte [gdt +20],dl    {base_23_16}
mov byte [gdt +23],dh    {base_31_24}
{cilova adresa uz v linearnim tvaru je, neni treba delat konverzi}
mov ax,word [kam+0]
mov word [gdt + 26],ax    {base_15_0}
mov ax,word [kam+2]
mov byte [gdt + 28],al    {base_23_16}
mov byte [gdt + 31],ah    {base_31_24}
mov cx,pocet
shr cx,1                {pocet se udava ve wordech, ne v bajtech, proto / 2}
push ds
lea si,gdt
mov ax,ds
mov es,ax               {DSC do ES:SI}
pop ds
mov ah,87h              {pouzijeme funkci 87h}
int 15h                 {preruseni 15h - PRESUN!}
end;
end;
{$ENDIF}

Procedure MoveFromHighMemory(odkud:dword;var data;pocet:word);
{$IFDEF FPC}
var zd:dword;
    dd:longint;
    r:registers;
begin
if not prepared_GDT_for_move then Init_GDT_for_move;
dd:=Global_DOS_Alloc(65536);
zd:=Word(dd shr 16)*16;
gdt.src_base_15_0:=odkud and 65535;            {nastavim zdroj}
gdt.src_base_23_16:=(odkud shr 16) and 255;
gdt.src_base_31_24:=(odkud shr 24);
gdt.dst_base_15_0:=zd and 65535;             {nastavim cil}
gdt.dst_base_23_16:=(zd shr 16) and 255;
gdt.dst_base_31_24:=(zd shr 24);
CopyToDOS(gdt,sizeof(gdt_type));
r.ax:=$8700;
r.cx:=pocet div 2;
r.es:=tb_segment;
r.si:=tb_offset;
RealIntr($15,r);
DOSMemGet(Word(dd shr 16),0,data,pocet);
Global_DOS_Free(word(dd));
end;
{$ELSE}
begin
if not prepared_GDT_for_move then Init_GDT_for_move;
asm
les di,data  {realmodova adresa DATA do DS:SI}
mov ax,es    {vezmu segmentovou cast adresy}
mov dx,16
mul dx       {segmentovou cast adresy vynasobim 16 - prevod na liearni adresu}
add ax,di    {prictu offsetovou cast}
adc dx,0     {korekce pripadneho preteceni}

mov word [gdt + 26],ax    {base_15_0}
mov byte [gdt + 28],dl    {base_23_16}
mov byte [gdt + 31],dh    {base_31_24}

{zdrojova adresa uz v linearnim tvaru je, neni treba delat konverzi}
mov ax,word [odkud+0]
mov word [gdt + 18],ax    {base_15_0}
mov ax,word [odkud+2]
mov byte [gdt + 20],al    {base_23_16}
mov byte [gdt + 23],ah    {base_31_24}
mov cx,pocet
shr cx,1                {pocet se udava ve wordech, ne v bajtech, proto / 2}
push ds
lea si,gdt
mov ax,ds
mov es,ax               {DSC do ES:SI}
pop ds
mov ah,87h              {pouzijeme funkci 87h}
int 15h                 {preruseni 15h - PRESUN!}
end;
end;
{$ENDIF}


Function Detect_XMS:boolean;assembler;
{Zjisti, mame-li k dispozici XMS pamet}
asm
mov ax,$4300
int $2f          {zjisteni, jestli ovladac XMS existuje a funguje}
mov bl,1
cmp al,80h
jz @konec
dec bl
@konec:
mov al,bl
end;


Function Detect_EMS:boolean;
{Zjisti, mame-li k dispozici EMS pamet}
var f:file;
    b:boolean;
    i:byte;

begin
b:=ExistFile('EMMXXXX0');
if b=true then
   begin
   asm
   mov ax,4600h
   int 67h
   mov i,ah   {v pripade, ze AH=0, tak v AL je verze EMS}
   end;
   Detect_EMS:=i=0;
   end
   else Detect_EMS:=false;
end;


Function Detect_VCPI:boolean;
{Zjisti, mame-li k dispozici VCPI sluzby}
var f:file;
    b:boolean;
    i:byte;

begin
b:=ExistFile('EMMXXXX0');
if b=true then
   begin
   asm
   mov ax,$DE00
   int 67h
   mov i,ah   {v pripade, ze AH=0, tak v AL je verze EMS}
   end;
   Detect_VCPI:=i=0;
   end
   else Detect_VCPI:=false;
end;


Function Detect_VDS:boolean;assembler;
{Zjisti, mame-li k dispozici VDS sluzby}
asm
stc
mov ax,8102h
mov dx,0
int 4Bh
mov cx,0
jc @konec
cmp ax,0
jz @konec
inc cx
@konec:
mov ax,cx
end;


Function Get_Windows_version:byte;assembler;
{DOS=0, Win 3.x=1, Win9x=2, Win NT/2K/XP...=3}
asm
              mov    ax,1600h
              int    2fh
              or     al,al
              je     @NoWin95    {volani nepodporovano - DOS nebo WinNT}
                                 {pres tohle neprojde ani DOS s HX-DOS}

              mov    ax,160Ah
              int    2fh
              or     ax, ax
              jne    @NoWin95    {volani nepodporovano - DOS nebo WinNT}

              cmp    bx, 0395h   {starsi nez Win95?}
              jae    @Win3
	      mov    al, 1
	      jmp    @Done	 { Win 3.1 }
@Win3:        cmp    bh, 3       { Win 95 oder 98 }
              jz     @Win95
              cmp    bh, 4       { Win 95 oder 98 }
              jnz    @NoWin95
@Win95:       mov    al, 2
	      jmp    @Done       { Win 95/98/ME }
@NoWin95:     mov    ax, $3306   { Get True Version Number }
              int    $21
              cmp    bx, $3205   { Win NT/2000 DOS Box }
              jne    @NoWin
              mov    al,3
              jmp    @Done
@NoWin:
              mov al,0
@Done:
end;




Function Get_NT_type:string;
var s,t:string;
    f:file;
    p:pointer;
    q:pchar;
    l,m,n:longint;

begin
s:=GetEnv('SYSTEMROOT');
if s='' then begin Get_NT_type:='Windows NT';Exit;end;
if s[Length(s)]<>'\' then s:=s+'\';
s:=s+'SYSTEM32\ATTRIB.EXE';
if not ExistFile(s) then begin Get_NT_type:='Windows NT';Exit;end;
Assign(f,s);
Reset(f,1);
l:=FileSize(f);
if L=0 then begin Close(f);Get_NT_type:='Windows NT';Exit;end;
GetMem(p,l);
BlockRead(f,p^,l);
Close(f);

m:=SearchBuf(p,l,'P'#0'r'#0'o'#0'd'#0'u'#0'c'#0't'#0'V'#0'e'#0'r'#0's'#0'i'#0'o'#0'n');
if m=-1 then begin Close(f);Get_NT_type:='Windows NT';Exit;end;
q:=p;
inc(q,m);
Move(q^,s[1],48);
s[0]:=#48;
t:='';
for n:=1 to 48 do
    if odd(n) then t:=t+s[n];
delete(t,1,15);

if Copy(t,1,9)='5.00.2195' then Get_NT_type:='Windows 2000' else
if Copy(t,1,8)='5.1.2600' then Get_NT_type:='Windows XP' else
if Copy(t,1,8)='5.2.3700' then Get_NT_type:='Windows XP 64-bit' else
if Copy(t,1,8)='6.0.6001' then Get_NT_type:='Windows Vista' else
if Copy(t,1,8)='6.1.7600' then Get_NT_type:='Windows 7' else
if Copy(t,1,8)='6.1.7601' then Get_NT_type:='Windows 7 SP1'
   else Get_NT_type:='Windows NT';

end;


Function Get_OS_type:string;
   Function Get_OS_type_helper:string;
   var h:byte;
   begin
   h:=get_windows_version;
      if h=1 then Get_OS_type_helper:='Windows 3.x' else
      if h=2 then Get_OS_type_helper:='Windows 9x/ME' else
      if h=3 then Get_OS_type_helper:='Windows NT or newer'
         else Get_OS_type_helper:='unknown OS';
   end;

var s,s2,s3:string;
    t:text;
    w,x:byte;
begin
s:='';
if Get_windows_version=3 then
   begin Get_OS_type:=Get_NT_type;Exit;end;

s3:=GetDirForTEMPfiles+'$$temp$$.log';
SwapVectors;
Exec(GetEnv('COMSPEC'),'/C ver > '+s3);
SwapVectors;
if not ExistFile(s3) then begin Get_OS_type:='??';Exit;end;
Assign(t,s3);
Reset(t);
repeat
if Eof(t) then begin Get_OS_type:='??';Close(t);Erase(t);Exit;end;
readln(t,s2);
until skipallspaces(s2)<>'';
s:=Convert_UP(s2);
if pos('DOSBOX',s)<>0 then Get_OS_type:='Dosbox';

if pos('FREECOM',s)<>0 then {Ne FreeDOS, ale skutecne FreeCOM}
   begin
   Close(t);
   SwapVectors;
   Exec(GetEnv('COMSPEC'),'/C ver /r > '+s3);
   SwapVectors;
   Assign(t,s3);
   Reset(t);
   repeat
   if Eof(t) then begin Get_OS_type:='FreeDOS';Close(t);Erase(t);Exit;end;
   readln(t,s);
   s:=Convert_UP(s);
   until pos('KERNEL',s)<>0;
   s2:=MyStr(IzolujPrvniCislo(s));
   Get_OS_Type:='FreeDOS (kernel '+s2+')';
   Close(t);
   Erase(t);
   Exit;
   end;

if pos('WINDOWS',s)<>0 then
   begin
   w:=pos('[',s);
   if w=0 then  {nemelo by nikdy nastat}
      begin
      Get_OS_type:=Get_OS_type_helper;
      Close(t);
      Erase(t);
      Exit;
      end;
   s:=Copy(s,w+1,255);

   x:=0;
   for w:=1 to Length(s) do
       if s[w] in ['0'..'9'] then begin x:=w;Break;end;
   if x=0 then  {nemelo by nikdy nastat}
      begin
      Get_OS_type:=Get_OS_type_helper;
      Close(t);
      Erase(t);
      Exit;
      end;
   s:=copy(s,x,255);
   dec(byte(s[0]));
   if Copy(s,1,4)='4.10' then
      begin
      if s='4.10.2222' then Get_OS_type:='Windows 98SE'
         else Get_OS_type:='Windows 98';
      end
      else
   if Copy(s,1,4)='4.00' then Get_OS_type:='Windows 95' else
   if Copy(s,1,3)='4.9' then Get_OS_type:='Windows Me'
      else Get_OS_type:=Get_OS_type_helper;
   Close(t);
   Erase(t);
   Exit;
   end;

while (pos('DOS',s2)=0) and (Eof(t)=false) do readln(t,s2);
if pos('DOS',s2)<>0 then Get_OS_type:=s2 else Get_OS_type:='??';

Close(t);
Erase(t);
end;


Function Get_OS_Vendor_ID:byte;assembler;
asm
mov ax, $3000;
int $21;
mov al, bh;
end;


Procedure Get_FreeDOS_version_string_asm(var s,o:word);assembler;
asm
mov ax,33ffh
mov dx,0
int 21h
{$IFDEF FPC}
   push esi
   mov esi,s
   mov [esi],dx
   mov esi,o
   mov [esi],ax
   pop esi
{$ELSE}
push si
push ds
lds si,s
mov [si],dx
lds si,o
mov [si],ax
pop ds
pop si
{$ENDIF}
end;


Function Get_FreeDOS_version_string:string;
{Pokud jsme pod FreeDOSem, tak vygeneruje retezec obsahuji verzi}
var t:string;
    s,o:word;
    a,b:byte;
begin
a:=Get_OS_Vendor_ID;
if a<>$FD then begin Get_FreeDOS_version_string:='';Exit;end;
Get_FreeDOS_version_string_asm(s,o);
t:='';
for a:=0 to 254 do
    begin
    b:=Mem[s:o+a];
    if b=0 then break else
    if b>=32 then t:=t+char(b);
    end;
Get_FreeDOS_version_string:=t;
end;


procedure Windows_SetFocusTo(id:word);
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168B;
  R.BX:=id;
  DOSError:=0;
  Intr ($2F, R);
  if R.AL<>0 then DOSError:=$FF
end;


procedure Windows_SetFocus;
{Pravdepodobne funguje jen ve windows 9x}
begin
  Windows_SetFocusTo (0);
end;


function Windows_GetVMID:word;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$1683;
  Intr ($2F, R);
  Windows_GetVMID:=R.BX
end;


Function Windows_GetApplicationTitle:string;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
    s:string[255];
    p:pchar;
begin
  p:=@s[1];
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168E;
  R.CX:=80;
  R.DX:=2;
  R.DI:=Ofs (p^);
  R.ES:=Seg (p^);
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>1 then
     begin
     DOSError:=$FF;
     Windows_GetApplicationTitle:='';
     end
     else
     Windows_GetApplicationTitle:=s;
end;


Function Windows_GetVMTitle:string;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
    s:string[255];
    p:pchar;
begin
  p:=@s[1];
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168E;
  R.CX:=80;
  R.DX:=3;
  R.DI:=Ofs (p^);
  R.ES:=Seg (p^);
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>1 then
    begin
    Windows_GetVMTitle:='';
    DOSError:=$FF;
    end
    else
    Windows_GetVMTitle:=s;
end;


procedure Windows_SetApplicationTitle(s:string);
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
    p:pchar;
begin
  s:=s+#0;
  p:=@s[1];
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168E;
  R.CX:=80;
  R.DX:=0;
  R.DI:=Ofs (p^);
  R.ES:=Seg (p^);
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>1 then
    DOSError:=$FF
end;


procedure Windows_SetVMTitle(s:string);
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
    i:byte;
    p:pchar;
begin
  s:=s+#0;
  p:=@s[1];
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168E;
  R.CX:=80;
  R.DX:=1;
  R.DI:=Ofs (p^);
  R.ES:=Seg (p^);
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>1 then
    DOSError:=$FF
end;

procedure Windows_AcknowledgeClose;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168F;
  R.DX:=$200;
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>0 then
    DOSError:=$FF
end;

procedure Windows_CancelClose;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168F;
  R.DX:=$300;
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>0 then
    DOSError:=$FF
end;


procedure Windows_EnableClose;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168F;
  R.DX:=1;
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>0 then
    DOSError:=$FF
end;

procedure Windows_DisableClose;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168F;
  R.DX:=0;
  DOSError:=0;
  Intr ($2F, R);
  if R.AX<>0 then
    DOSError:=$FF
end;

function Windows_QueryClose:byte;
{Pravdepodobne funguje jen ve windows 9x}
var r:registers;
begin
  FillChar (R, SizeOf (R), 0);
  R.AX:=$168F;
  R.DX:=$100;
  DOSError:=0;
  Intr ($2F, R);
  if (R.AX<>0) and (R.AX<>1) then
    R.AX:=2;
  Windows_QueryClose:=R.AX;
end;


Procedure DbgLogX(s:string);
var f:text;
begin
Assign(f,dbg_log_file);
if ExistFile(dbg_log_file) then Append(f) else Rewrite(f);
writeln(f,s);
Close(f);
end;

Procedure DbgLog(s:string);
begin
{$IFDEF DEBUG}
DbgLogX(s);
{$ENDIF}
end;


Procedure NakalibrujDelay;
{Nakalibruje se podle standardniho BIOSoveho citace [Seg0040:$6c]}
var i:longint;
begin
Pocet_cyklu_na_citac:=0;
i:=Fromtimer;          {nacteme hodnotu z casovace}
while i=FromTimer do;  {a cekame, dokud casovac nepreskoci na novou hodnotu}
i:=Fromtimer;
repeat
inc(Pocet_cyklu_na_citac);
TimerBalastProc;
until i<>FromTimer;
Pocet_cyklu_na_citac:=pocet_cyklu_na_citac div 55;
end;


Procedure Cekej1us(usecs:word);
{Ceka jednu mikrosekundu}
var real_ticks:real;
    ticks:word;
begin
real_ticks:=0.596590*(usecs+1);
ticks:=word(round(real_ticks));
if ticks=0 then Exit;
asm
mov cx,ticks
mov bx,2
@waittrig:
in   al,41h
and  al,02h
cmp  al,bl
jz   @waittrig
xor  bl,02h
loop @waittrig
end; {asm}
end;


Procedure Cekej(ms:word);
var w,v,i:longint;
begin
for w:=1 to ms do
    begin
    i:=0;
    for v:=1 to pocet_cyklu_na_citac do
        begin
        inc(i);
        TimerBalastProc;
        end;
    end;
end;


Function Multitask:boolean;
{v multitaskovuch prostredich nabidne procesorovy cas jinym procesum
 Pokud je funkce podporovana, tak vrati TRUE (jinak false}
var b:byte;
begin
asm
mov ax,1680h
int 2fh
mov b,al
end;
Multitask:=b=0;
end;



Procedure InitLacrt;
var s,s2:string;
begin
DOSprepinac:=ZjistiPrepinac;
EXEname:=ParamStr(0);
s:=MyFExpand(EXEname);
FSplit(s,EXEdir,EXEname,s2);
{CommandLine:=GetCommandLine;}
sysTridiciTbl:=@_sysTridiciTbl;

PripravTridiciTabulku(trid_czlat2);
PripravPrevodniTabulky;
OpatrnePrevodniTabulky(true);
NakalibrujDelay;
{$IFDEF DEBUG}
if ExistFile('debuglog.txt') then EraseFile('debuglog.txt');
{$ENDIF}
{$IFNDEF FPC}
Assign(stdout,'');
Assign(stderr,'');
Rewrite(stdout);
Rewrite(stderr);
TextRec(stderr).Handle:=2;
TextRec(stderr).BufSize:=1;
{$ENDIF}
end;


Function VyhledejSoubor(s:string):string;
{prohleda aktualni adresar, adresar s EXE a cestu a pokusi se najit, kde je
 umisten soubor S}
var ss,home,nn,xx:string;
    n:byte;
begin
ss:=MyFExpand(ParamStr(0));
FSplit(ss,home,nn,xx);
if ExistFile(home+s) then begin VyhledejSoubor:=home;Exit;end;
getdir(0,home);
if home[length(home)]<>'\' then home:=home+'\';
if ExistFile(home+s) then begin VyhledejSoubor:=home;Exit;end;

ss:=GetEnv('PATH');
while ss<>'' do
   begin
   n:=Pos(';',ss);
   if n=0 then home:=ss else home:=Copy(ss,1,n-1);
   if home[length(home)]<>'\' then home:=home+'\';
   delete(ss,1,Length(home));
   if ExistFile(home+s) then begin VyhledejSoubor:=home;Exit;end;
   end;
VyhledejSoubor:='';
end;


Function GetTempDir:string;
{najde adresar podle promenne prostredi TEMP, ev. TMP}
var s:string;
begin
s:=GetEnv('TEMP');
if s<>'' then
   begin
   if s[Length(s)]<>'\' then s:=s+'\';
   if ExistDir(s) then begin GetTempDir:=s;Exit;end;
   end;
s:=GetEnv('TMP');
if s<>'' then
   begin
   if s[Length(s)]<>'\' then s:=s+'\';
   if ExistDir(s) then begin GetTempDir:=s;Exit;end;
   end;
GetTempDir:='';
end;


Function GetDirForTEMPfiles:string;
{navrhne vhodny adresar pro docasne soubory}
var s:string;
    ls:string[64];
    b:byte;

begin
s:=GetTempDir;
if s<>'' then     {napred zkusime adresar podle promenne TEMP ci TMP}
   if Je_disk_zapisovatelny(s[1]) then
      begin
      GetDirForTEMPfiles:=s;
      Exit;
      end;

{Selhalo? Zkusme adresar s nasim EXE}
s:=MyFExpand(ParamStr(0));
s:=StripPath(s);

if Je_disk_zapisovatelny(s[1]) then
      begin
      GetDirForTEMPfiles:=s;
      Exit;
      end;

{Selhalo? Zkusme prvni adresar zmineny v PATH}
s:=GetEnv('PATH');
b:=Pos(';',s);
if b<>0 then Delete(s,b,255);
if s[Length(s)]<>'\' then s:=s+'\';
If ExistDir(s) then
   if Je_disk_zapisovatelny(s[1]) then
      begin
      GetDirForTEMPfiles:=s;
      Exit;
      end;


{Zase selhalo? Tak proskenujeme vsechny disky v LogDisk (bez disketovek) a
 pokud jsou zapisovatelne, tak pouzijeme jejich korenovy adresar}
ls:=LogDiskPlus;
for b:=1 to Length(ls) do
    begin
    if not (ls[b] in ['A','B']) then
       if Je_disk_zapisovatelny(ls[b]) then
          begin
          GetDirForTEMPfiles:=ls[b]+':\';
          Exit;
          end;
    end;
{Ted jeste proskenujeme ty disketovky}
for b:=1 to Length(ls) do
    begin
    if (ls[b] in ['A','B']) then
       if Je_disk_zapisovatelny(ls[b]) then
          begin
          GetDirForTEMPfiles:=ls[b]+':\';
          Exit;
          end;
    end;
GetDirForTEMPfiles:='';  {varianta, kdy vsechno selhalo}
end;


Function valid_param_str(const s:string):boolean;
var b:byte;
    ok,mezera:boolean;
begin
if (s='') or (s[1]=' ') then begin valid_param_Str:=false;exit;end;
ok:=true;
mezera:=false;
for b:=1 to length(s) do
    begin
    if not (s[b] in ['0','1','2','3','4','5','6','7','8','9',' '])
       then ok:=false;

    if ok then
       if s[b]=',' then {zakazeme vysky dvou carek za sebou}
          if mezera then ok:=false else mezera:=true else mezera:=false;

    if ok=false then begin valid_param_Str:=false;exit;end;
    end;
valid_param_Str:=true;
end;


Function StrAdr(var p):string;
var i:pointer;
    j,k:longint;
begin
i:=addr(p);

move(i,k,4);

j:=longint(i);
StrAdr:=MyStr(j)+' ';
end;


Function FormatStr(const format:string;params:string):string;
{Naformatuje String podle dodatecnych parametru, podobne jako v C++
 Priklad pouziti:
   FormatStr('Nalezen mod c. %x (neboli %d dekadicky)', StrAdr(h)+StrAdr(d))

 Retezec "params" netvor manualne, ale zasadne jen z volani StrAdr.
 FormatStr rozeznava tyto entity:
 %% - interpretuje jako znak "%"
 %d - desitkove cislo
 %r - desetinne cislo. Predpoklada se 6-bajtovy typ real.
        Pokud uvedete jen "%r" tak vytiskne cislo v exponencialnim tvaru.
        Muzes ale jeste dotatecne pridat prodat parametr desetinneho odelovace
        a pocet desetinnych mist. Priklad: "%r.2" - za desetinnou teckou
        vypise dve desetinna mista. "%r,3" - za desetinnou carkou uda tri
        desetinna mista. Zapis "%r," znamena optimalni pocet desetinnych mist
        za carkou, ne vsak vice nez 4.
 %h - hexadecimalni cislo. Dava koncovku 'h'. Pokud je mensi nez FFh, tak se
        vytiskne na dve mista, t.j. napr. $C se vytiskne jako 0Ch.
        Pokud je vetsi nez FFh, tak se vytiskne na ctyri mista.
 %c - jednobajtovy znak
 %u - dvojbajtovy (unicode) znak - rozepise ho podle normy UTF-8
 %s - retezec

}

Function DekodujAdresu(ii:byte):pointer;
var ss:string;
    dd:dword;
begin
ss:=VratSlovo(params,ii);
if ss='' then DekodujAdresu:=nil else
   begin
   dd:=MyVal(ss);
   DekodujAdresu:=pointer(dd);
   end;
end;


Function ParamCislo(n:byte):string;
var i:^longint;
begin
i:=DekodujAdresu(n);
if i=nil then ParamCislo:='' else ParamCislo:=Mystr(i^);
end;


Function ParamHexaCislo(n:byte):string;
var i:^longint;
    d:dword;
    s:string;
begin
i:=DekodujAdresu(n);
if i=nil then ParamHexaCislo:=''
   else begin
   d:=i^;
   s:=HexStr(d);
   if (d>$FFFF) then s:=Xchar(8-Length(s),'0')+s else
   if (d>$FF) then s:=XChar(4-Length(s),'0')+s else s:=XChar(2-Length(s),'0')+s;
   ParamHexaCislo:=s+'h';
   end;
end;


Function ParamZnak(n:byte):string;
var c:^char;
begin
c:=DekodujAdresu(n);
if c=nil then ParamZnak:=''
   else ParamZnak:=c^;
end;


Function ParamRetezec(n:byte):string;
var s:^string;
begin
s:=DekodujAdresu(n);
if s=nil then ParamRetezec:=''
   else ParamRetezec:=s^;
end;


Function ParamUnicode(n:byte):string;
var i:^word;
begin
i:=DekodujAdresu(n);
if i=nil then ParamUnicode:=''
   else ParamUnicode:=Word2UTF8(i^);
end;


Function ParamReal(n:byte;znak:char;pmist:byte):string;
var r:^real;
    u:real;
    b,c:byte;
    t:string;
begin
r:=DekodujAdresu(n);
if r=nil then ParamReal:=''
   else begin
   u:=r^;
   if znak='E' then begin Str(u,t);t:=skipbegspaces(t);end else
      begin
      Str(u:20:9,t);
      t:=skipbegspaces(t);
      b:=Pos('.',t);
      if pmist<10 then
         begin
         delete(t,b+pmist+1,255);
         if t[length(t)]='.' then delete(t,length(t),1);
         end
         else begin
         c:=Length(t);
         while t[c]='0' do dec(c);
         t:=Mid(t,1,c);
         if t[length(t)]='.' then delete(t,length(t),1)
            else begin
            b:=Pos('.',t);
            if c-b>4 then c:=b+4;
            t:=Mid(t,1,c);
            end;
         end;

      if znak=',' then
         if Pos('.',t)<>0 then t[Pos('.',t)]:=',';
      end;
   ParamReal:=t;
   end;
end;


var a,l,p,pm:byte;
    c,rz:char;
    s:string;
begin

params:=skipBegspaces(skipEndSpaces(params))+' ';
if valid_param_str(params)=false then begin FormatStr:=format;Exit;end;
s:='';
a:=1;  {zacatek formatovaneho retezce}
p:=1;  {cislo parametru z parametroveho listu}
l:=Length(format);

while a<=L do
    begin
    if format[a]<>'%' then s:=s+format[a]
       else begin
       inc(a);      {posun za znak procento}
       if a>L then Break;
       c:=Upcase(format[a]);
       case C of
         '%': begin s:=s+'%';dec(p) {protoze pozdeji je "inc(p)"};end;
         'D': s:=s+ParamCislo(p);
         'H': s:=s+ParamHexaCislo(p);
         'C': s:=s+ParamZnak(p);
         'S': s:=s+ParamRetezec(p);
         'U': s:=s+ParamUnicode(p);
         'R': begin
              rz:='E';    {defaultni tvar zapisu bude exponencialni}
              if a<L then
                 begin
                 if (format[a+1]='.') or (format[a+1]=',') then
                    begin
                    rz:=format[a+1];
                    inc(a);
                    pm:=255;
                    if a<L then
                       if format[a+1] in ['0'..'9'] then
                          begin
                          pm:=MyVal(format[a+1]);
                          inc(a);
                          end;
                    end;

                 end;
              s:=s+ParamReal(p,rz,pm);
              end;
       else begin end;
       end; {case}
       inc(p);  {presun na dalsi parametr}
       end;
    inc(a);
    end;

FormatStr:=s;
end;



begin
{PovolBlikani(true);
SchovejAtributy;}
InitLacrt;
end.
