type
VESA_EDID = packed record
{00} padding:array[1..8] of byte;
{08} manufacturer:word;  {big-endian manufacturer ID (see #00136)}
                {
		bits 14-10: first letter (01h='A', 02h='B', etc.)
		bits 9-5: second letter
		bits 4-0: third letter
                }
{0a} edid_code:word;  {identifies monitor model}
{0C} serial_number:dword;
                {
                serial_number or FFFFFFFFh
		for "MAG", subtract 7000000 to get actual serial number
		for "OQI", subtract 456150000
		for "PHL", subtract ???
		for "VSC", subtract 640000000
                }
{10} week:BYTE; {week number of manufacture}
{11} year:BYTE; {manufacture year - 1990}
{12} edid_ver:BYTE;      {EDID version}
{13} edid_rev:BYTE;      {EDID revision}
{14} video_input:BYTE;   {video input type (see #00129)}
{15} max_horiz_size:BYTE;{maximum horizontal size in cm}
{16} max_vert_size:BYTE;
{17} gamma:BYTE;{gamma factor (gamma = 1.0 + factor/100, so max = 3.55)}
{18} DPMS_flags:BYTE;    {DPMS flags (see #00128)}
{19} ch_gr_xy:BYTE;    {chroma information: green X'/Y' and red X'/Y'}
{1A} ch_wb_xy:BYTE;    {chroma information: white X'/Y' and blue X'/Y'}
{1B} ch_red_y:BYTE;    {chroma information: red Y}
{1C} ch_red_x:BYTE;    {chroma information: red X}
{1D} ch_green_y:BYTE;  {chroma information: green Y}
{1E} ch_green_x:BYTE;  {chroma information: green X}
{1F} ch_blue_y:BYTE;   {chroma information: blue Y}
{20} ch_blue_x:BYTE;   {chroma information: blue X}
{21} ch_white_y:BYTE;  {chroma information: white Y}
{22} ch_white_x:BYTE;  {chroma information: white X}
{23} est_timings1:BYTE;{established timings 1 (see #00130)}
{24} est_timings2:BYTE;{established timings 2 (see #00131)}
{25} man_timings:BYTE; {manufacturer's reserved timing or 00h for none
		        bit 7: 1152x870 @ 75 Hz (Mac II, Apple)}
{26} std_tim_id:array[1..8] of word;
                {
                standard timing identification
		resolution (low byte) and vertical frequency (high byte) for
		  each of eight modes (see #00132)
		X resolution = (lowbyte + 31) * 8
                }
{36} det_tim_id1:array[1..18] of BYTE;
                {
                detailed timing description #1 (see #00133)
		(v1.1) alternately, text identification (see #00135)
                }
{48} det_tim_id2:array[1..18] of BYTE;
{5A} det_tim_id3:array[1..18] of BYTE;
{6C} det_tim_id4:array[1..18] of BYTE;
{7E} extension_flag:BYTE;
{7F} checksum:BYTE; {(radix-complement: 256-low byte of 16-bit sum of 00h-7Eh)}
end;


detailed_timing_description = packed record {table #00133}
{00} horiz_frequency_kHz:byte; {(if 00h, may be text)(see #00135)}
{01} vert_frequency_Hz:byte;
{02} horiz_active_time:byte; {(pixels) and X resolution}
{03} horiz_blanking_time:byte; {(pixels)}
{04} horiz_active_time_2:byte; {/ horiz blanking time 2}
{05} vert_active_time:byte; {(lines) and Y resolution}
{06} vert_blanking_time:byte; {(lines)}
{07} vert_active_time_2:byte; {/ vert blanking time 2}
{08} horiz_sync_offset:byte; {(pixels)}
{09} horiz_sync_pulsewidth:byte; {(pixels)}
{0A} vert_sync_offset:byte; {/ vert sync pulsewidth}
{0B} vert_horiz_sync_offset_2:byte; {/ vert/hor. sync pulsewidth 2}
{0C} horiz_img_size:byte; {(mm)}
{0D} vert_img_size:byte; {(mm)}
{0E} horiz_img_size_2:byte; {/ vert image size 2}
{0F} horiz_border:byte; {(pixels)}
{10} vert_border:byte; {(lines)}
{11} display_type:byte; {(see #00134)}
end;


EDID_text_identification = packed record {table #00135)}
{00} magic:array[1..3]of byte; {00h 00h 00h (to distinguish from detailed timing description)}
{03} text_identifier:byte;
                {
		FFh serial number
		FEh vendor name
		FDh vertical/horizontal frequency range
		FCh model name
                }
{---frequency range---}
{04} unused1:BYTE;  {00h ???}
{05} min_vert_refresh_hz:BYTE; {minimum vertical refresh frequency in Hz}
{06} max_vert_refresh_Hz:Byte;
{07} min_horiz_freq_kHz:byte;
{08} max_horiz_freq_kHz:byte;
{09} unused2:BYTE;  {FFh ???}
{---other---}
{0a} filler:array[1..14] of byte; {text, may be terminated with either a NUL (00h) or LF (0Ah)}
end;


var
