{
    Copyright (C) 2021 Jerome Shidel
    BSD 3-Clause License
}
unit DrvUtils;

interface

var
    DrvError : word;

    TotalFixedDrives : byte absolute $0040:$0075;

type
    PDriveParams = ^TDriveParams;
    TDriveParams = record
        Count, Kind : word;
        Heads, Sectors, Cylinders : word;
        ParamTable : Pointer;
    end;

const
    drfNoDirectIO   = $0200;
    drfIsRemote     = $1000;
    drfNeedMediaID  = $2000;
    drfIsSubst      = $8000;
    drfRemoteMask   = drfNoDIrectIO or drfIsRemote or drfNeedMediaID or
        drfIsSubst;

procedure SetDrvError (ErrorCode : word);
function GetDrvError : word;

function AsciizStr(const addr) : string;

function GetEquipmentList : word;
function GetDriveParams(Drive : word; var Info : TDriveParams ) : boolean;

function DriveRemovable (Drive :word) : boolean;
function DriveRemote (Drive :word) : word;

function CDDrive(Drive : Word) : boolean;

implementation

{$L DRVUTILS.OBJ}

procedure SetDrvError (ErrorCode : word); external;
function GetDrvError : word; external;

function AsciizStr(const addr) : string; external;

function GetEquipmentList : word; external;

function GetDriveParams(Drive : word; var Info : TDriveParams) : boolean; external;
function DriveRemovable (Drive :word) : boolean; external;
function DriveRemote (Drive :word) : word; external;

function CDDrive(Drive : Word) : boolean; external;

begin
    SetDrvError(0);
end.