/*
MIT License

Copyright (c) 2019-2025 Andre Seidelt <superilu@yahoo.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include <GL/gl.h>
#include "ogl.h"

//! push named GL_xxx value
#define OGL_PUSH_VALUE(n)          \
    {                              \
        js_pushnumber(J, GL_##n);  \
        js_setproperty(J, -2, #n); \
    }

/**
 * @brief copy all GL_ defines into GL. object in Javascript
 * Note: cat glext.txt | grep "GL_" | grep "#define" | cut -d " " -f 2 | cut -c 4- | awk '{ print "OGL_PUSH_VALUE(" $0 ");"}' >glext.c
 *
 * @param J VM state.
 */
void ogl_create_constants(js_State *J) {
    // opengl constants
    js_newobject(J);
    {
        js_pushnumber(J, OGL_WIDTH);
        js_setproperty(J, -2, "WIDTH");

        js_pushnumber(J, OGL_HEIGHT);
        js_setproperty(J, -2, "HEIGHT");

        OGL_PUSH_VALUE(1PASS_EXT);
        OGL_PUSH_VALUE(1PASS_SGIS);
        OGL_PUSH_VALUE(2_BYTES);
        OGL_PUSH_VALUE(2D);
        OGL_PUSH_VALUE(2PASS_0_EXT);
        OGL_PUSH_VALUE(2PASS_0_SGIS);
        OGL_PUSH_VALUE(2PASS_1_EXT);
        OGL_PUSH_VALUE(2PASS_1_SGIS);
        OGL_PUSH_VALUE(3_BYTES);
        OGL_PUSH_VALUE(3D_COLOR_TEXTURE);
        OGL_PUSH_VALUE(3D_COLOR);
        OGL_PUSH_VALUE(3D);
        OGL_PUSH_VALUE(4_BYTES);
        OGL_PUSH_VALUE(422_AVERAGE_EXT);
        OGL_PUSH_VALUE(422_EXT);
        OGL_PUSH_VALUE(422_REV_AVERAGE_EXT);
        OGL_PUSH_VALUE(422_REV_EXT);
        OGL_PUSH_VALUE(4D_COLOR_TEXTURE);
        OGL_PUSH_VALUE(4PASS_0_EXT);
        OGL_PUSH_VALUE(4PASS_0_SGIS);
        OGL_PUSH_VALUE(4PASS_1_EXT);
        OGL_PUSH_VALUE(4PASS_1_SGIS);
        OGL_PUSH_VALUE(4PASS_2_EXT);
        OGL_PUSH_VALUE(4PASS_2_SGIS);
        OGL_PUSH_VALUE(4PASS_3_EXT);
        OGL_PUSH_VALUE(4PASS_3_SGIS);
        OGL_PUSH_VALUE(ABGR_EXT);
        OGL_PUSH_VALUE(ACCUM_ALPHA_BITS);
        OGL_PUSH_VALUE(ACCUM_BLUE_BITS);
        OGL_PUSH_VALUE(ACCUM_BUFFER_BIT);
        OGL_PUSH_VALUE(ACCUM_CLEAR_VALUE);
        OGL_PUSH_VALUE(ACCUM_GREEN_BITS);
        OGL_PUSH_VALUE(ACCUM_RED_BITS);
        OGL_PUSH_VALUE(ACCUM);
        OGL_PUSH_VALUE(ACTIVE_TEXTURE_ARB);
        OGL_PUSH_VALUE(ACTIVE_VERTEX_UNITS_ARB);
        OGL_PUSH_VALUE(ADD_SIGNED_EXT);
        OGL_PUSH_VALUE(ADD);
        OGL_PUSH_VALUE(ALIASED_LINE_WIDTH_RANGE);
        OGL_PUSH_VALUE(ALIASED_POINT_SIZE_RANGE);
        OGL_PUSH_VALUE(ALL_ATTRIB_BITS);
        OGL_PUSH_VALUE(ALL_CLIENT_ATTRIB_BITS);
        OGL_PUSH_VALUE(ALLOW_DRAW_FRG_HINT_PGI);
        OGL_PUSH_VALUE(ALLOW_DRAW_MEM_HINT_PGI);
        OGL_PUSH_VALUE(ALLOW_DRAW_OBJ_HINT_PGI);
        OGL_PUSH_VALUE(ALLOW_DRAW_WIN_HINT_PGI);
        OGL_PUSH_VALUE(ALPHA_BIAS);
        OGL_PUSH_VALUE(ALPHA_BITS);
        OGL_PUSH_VALUE(ALPHA_MAX_CLAMP_INGR);
        OGL_PUSH_VALUE(ALPHA_MAX_SGIX);
        OGL_PUSH_VALUE(ALPHA_MIN_CLAMP_INGR);
        OGL_PUSH_VALUE(ALPHA_MIN_SGIX);
        OGL_PUSH_VALUE(ALPHA_SCALE);
        OGL_PUSH_VALUE(ALPHA_TEST_FUNC);
        OGL_PUSH_VALUE(ALPHA_TEST_REF);
        OGL_PUSH_VALUE(ALPHA_TEST);
        OGL_PUSH_VALUE(ALPHA);
        OGL_PUSH_VALUE(ALPHA12_EXT);
        OGL_PUSH_VALUE(ALPHA12);
        OGL_PUSH_VALUE(ALPHA16_EXT);
        OGL_PUSH_VALUE(ALPHA16);
        OGL_PUSH_VALUE(ALPHA4_EXT);
        OGL_PUSH_VALUE(ALPHA4);
        OGL_PUSH_VALUE(ALPHA8_EXT);
        OGL_PUSH_VALUE(ALPHA8);
        OGL_PUSH_VALUE(ALWAYS_FAST_HINT_PGI);
        OGL_PUSH_VALUE(ALWAYS_SOFT_HINT_PGI);
        OGL_PUSH_VALUE(ALWAYS);
        OGL_PUSH_VALUE(AMBIENT_AND_DIFFUSE);
        OGL_PUSH_VALUE(AMBIENT);
        OGL_PUSH_VALUE(AND_INVERTED);
        OGL_PUSH_VALUE(AND_REVERSE);
        OGL_PUSH_VALUE(AND);
        OGL_PUSH_VALUE(ARRAY_ELEMENT_LOCK_COUNT_EXT);
        OGL_PUSH_VALUE(ARRAY_ELEMENT_LOCK_FIRST_EXT);
        OGL_PUSH_VALUE(ASYNC_DRAW_PIXELS_SGIX);
        OGL_PUSH_VALUE(ASYNC_HISTOGRAM_SGIX);
        OGL_PUSH_VALUE(ASYNC_MARKER_SGIX);
        OGL_PUSH_VALUE(ASYNC_READ_PIXELS_SGIX);
        OGL_PUSH_VALUE(ASYNC_TEX_IMAGE_SGIX);
        OGL_PUSH_VALUE(ATTENUATION_EXT);
        OGL_PUSH_VALUE(ATTRIB_STACK_DEPTH);
        OGL_PUSH_VALUE(AUTO_NORMAL);
        OGL_PUSH_VALUE(AUX_BUFFERS);
        OGL_PUSH_VALUE(AUX0);
        OGL_PUSH_VALUE(AUX1);
        OGL_PUSH_VALUE(AUX2);
        OGL_PUSH_VALUE(AUX3);
        OGL_PUSH_VALUE(AVERAGE_EXT);
        OGL_PUSH_VALUE(AVERAGE_HP);
        OGL_PUSH_VALUE(BACK_LEFT);
        OGL_PUSH_VALUE(BACK_NORMALS_HINT_PGI);
        OGL_PUSH_VALUE(BACK_RIGHT);
        OGL_PUSH_VALUE(BACK);
        OGL_PUSH_VALUE(BGR_EXT);
        OGL_PUSH_VALUE(BGR);
        OGL_PUSH_VALUE(BGRA_EXT);
        OGL_PUSH_VALUE(BGRA);
        OGL_PUSH_VALUE(BIAS_BY_NEGATIVE_ONE_HALF_NV);
        OGL_PUSH_VALUE(BINORMAL_ARRAY_EXT);
        OGL_PUSH_VALUE(BINORMAL_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(BINORMAL_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(BINORMAL_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(BITMAP_TOKEN);
        OGL_PUSH_VALUE(BITMAP);
        OGL_PUSH_VALUE(BLEND_COLOR_EXT);
        OGL_PUSH_VALUE(BLEND_COLOR);
        OGL_PUSH_VALUE(BLEND_DST_ALPHA_EXT);
        OGL_PUSH_VALUE(BLEND_DST_RGB_EXT);
        OGL_PUSH_VALUE(BLEND_DST);
        OGL_PUSH_VALUE(BLEND_EQUATION_EXT);
        OGL_PUSH_VALUE(BLEND_EQUATION);
        OGL_PUSH_VALUE(BLEND_SRC_ALPHA_EXT);
        OGL_PUSH_VALUE(BLEND_SRC_RGB_EXT);
        OGL_PUSH_VALUE(BLEND_SRC);
        OGL_PUSH_VALUE(BLEND);
        OGL_PUSH_VALUE(BLUE_BIAS);
        OGL_PUSH_VALUE(BLUE_BITS);
        OGL_PUSH_VALUE(BLUE_MAX_CLAMP_INGR);
        OGL_PUSH_VALUE(BLUE_MIN_CLAMP_INGR);
        OGL_PUSH_VALUE(BLUE_SCALE);
        OGL_PUSH_VALUE(BLUE);
        OGL_PUSH_VALUE(BYTE);
        OGL_PUSH_VALUE(C3F_V3F);
        OGL_PUSH_VALUE(C4F_N3F_V3F);
        OGL_PUSH_VALUE(C4UB_V2F);
        OGL_PUSH_VALUE(C4UB_V3F);
        OGL_PUSH_VALUE(CALLIGRAPHIC_FRAGMENT_SGIX);
        OGL_PUSH_VALUE(CCW);
        OGL_PUSH_VALUE(CLAMP_TO_BORDER_SGIS);
        OGL_PUSH_VALUE(CLAMP_TO_EDGE_SGIS);
        OGL_PUSH_VALUE(CLAMP_TO_EDGE);
        OGL_PUSH_VALUE(CLAMP);
        OGL_PUSH_VALUE(CLEAR);
        OGL_PUSH_VALUE(CLIENT_ACTIVE_TEXTURE_ARB);
        OGL_PUSH_VALUE(CLIENT_ATTRIB_STACK_DEPTH);
        OGL_PUSH_VALUE(CLIENT_PIXEL_STORE_BIT);
        OGL_PUSH_VALUE(CLIENT_VERTEX_ARRAY_BIT);
        OGL_PUSH_VALUE(CLIP_FAR_HINT_PGI);
        OGL_PUSH_VALUE(CLIP_NEAR_HINT_PGI);
        OGL_PUSH_VALUE(CLIP_PLANE0);
        OGL_PUSH_VALUE(CLIP_PLANE1);
        OGL_PUSH_VALUE(CLIP_PLANE2);
        OGL_PUSH_VALUE(CLIP_PLANE3);
        OGL_PUSH_VALUE(CLIP_PLANE4);
        OGL_PUSH_VALUE(CLIP_PLANE5);
        OGL_PUSH_VALUE(CLIP_VOLUME_CLIPPING_HINT_EXT);
        OGL_PUSH_VALUE(CMYK_EXT);
        OGL_PUSH_VALUE(CMYKA_EXT);
        OGL_PUSH_VALUE(COEFF);
        OGL_PUSH_VALUE(COLOR_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(COLOR_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(COLOR_ARRAY_PARALLEL_POINTERS_INTEL);
        OGL_PUSH_VALUE(COLOR_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_POINTER);
        OGL_PUSH_VALUE(COLOR_ARRAY_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_SIZE);
        OGL_PUSH_VALUE(COLOR_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_STRIDE);
        OGL_PUSH_VALUE(COLOR_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(COLOR_ARRAY_TYPE);
        OGL_PUSH_VALUE(COLOR_ARRAY);
        OGL_PUSH_VALUE(COLOR_BUFFER_BIT);
        OGL_PUSH_VALUE(COLOR_CLEAR_VALUE);
        OGL_PUSH_VALUE(COLOR_INDEX);
        OGL_PUSH_VALUE(COLOR_INDEX1_EXT);
        OGL_PUSH_VALUE(COLOR_INDEX12_EXT);
        OGL_PUSH_VALUE(COLOR_INDEX16_EXT);
        OGL_PUSH_VALUE(COLOR_INDEX2_EXT);
        OGL_PUSH_VALUE(COLOR_INDEX4_EXT);
        OGL_PUSH_VALUE(COLOR_INDEX8_EXT);
        OGL_PUSH_VALUE(COLOR_INDEXES);
        OGL_PUSH_VALUE(COLOR_LOGIC_OP);
        OGL_PUSH_VALUE(COLOR_MATERIAL_FACE);
        OGL_PUSH_VALUE(COLOR_MATERIAL_PARAMETER);
        OGL_PUSH_VALUE(COLOR_MATERIAL);
        OGL_PUSH_VALUE(COLOR_MATRIX_SGI);
        OGL_PUSH_VALUE(COLOR_MATRIX_STACK_DEPTH_SGI);
        OGL_PUSH_VALUE(COLOR_MATRIX_STACK_DEPTH);
        OGL_PUSH_VALUE(COLOR_MATRIX);
        OGL_PUSH_VALUE(COLOR_SUM_CLAMP_NV);
        OGL_PUSH_VALUE(COLOR_SUM_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_ALPHA_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_ALPHA_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_BIAS_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_BIAS);
        OGL_PUSH_VALUE(COLOR_TABLE_BLUE_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_BLUE_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_FORMAT_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_FORMAT);
        OGL_PUSH_VALUE(COLOR_TABLE_GREEN_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_GREEN_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_INTENSITY_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_INTENSITY_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_LUMINANCE_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_LUMINANCE_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_RED_SIZE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_RED_SIZE);
        OGL_PUSH_VALUE(COLOR_TABLE_SCALE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_SCALE);
        OGL_PUSH_VALUE(COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_WIDTH_SGI);
        OGL_PUSH_VALUE(COLOR_TABLE_WIDTH);
        OGL_PUSH_VALUE(COLOR_TABLE);
        OGL_PUSH_VALUE(COLOR_WRITEMASK);
        OGL_PUSH_VALUE(COLOR);
        OGL_PUSH_VALUE(COLOR3_BIT_PGI);
        OGL_PUSH_VALUE(COLOR4_BIT_PGI);
        OGL_PUSH_VALUE(COMBINE_ALPHA_EXT);
        OGL_PUSH_VALUE(COMBINE_EXT);
        OGL_PUSH_VALUE(COMBINE_RGB_EXT);
        OGL_PUSH_VALUE(COMBINE4_NV);
        OGL_PUSH_VALUE(COMBINER_AB_DOT_PRODUCT_NV);
        OGL_PUSH_VALUE(COMBINER_AB_OUTPUT_NV);
        OGL_PUSH_VALUE(COMBINER_BIAS_NV);
        OGL_PUSH_VALUE(COMBINER_CD_DOT_PRODUCT_NV);
        OGL_PUSH_VALUE(COMBINER_CD_OUTPUT_NV);
        OGL_PUSH_VALUE(COMBINER_COMPONENT_USAGE_NV);
        OGL_PUSH_VALUE(COMBINER_INPUT_NV);
        OGL_PUSH_VALUE(COMBINER_MAPPING_NV);
        OGL_PUSH_VALUE(COMBINER_MUX_SUM_NV);
        OGL_PUSH_VALUE(COMBINER_SCALE_NV);
        OGL_PUSH_VALUE(COMBINER_SUM_OUTPUT_NV);
        OGL_PUSH_VALUE(COMBINER0_NV);
        OGL_PUSH_VALUE(COMBINER1_NV);
        OGL_PUSH_VALUE(COMBINER2_NV);
        OGL_PUSH_VALUE(COMBINER3_NV);
        OGL_PUSH_VALUE(COMBINER4_NV);
        OGL_PUSH_VALUE(COMBINER5_NV);
        OGL_PUSH_VALUE(COMBINER6_NV);
        OGL_PUSH_VALUE(COMBINER7_NV);
        OGL_PUSH_VALUE(COMPILE_AND_EXECUTE);
        OGL_PUSH_VALUE(COMPILE);
        OGL_PUSH_VALUE(COMPRESSED_ALPHA_ARB);
        OGL_PUSH_VALUE(COMPRESSED_INTENSITY_ARB);
        OGL_PUSH_VALUE(COMPRESSED_LUMINANCE_ALPHA_ARB);
        OGL_PUSH_VALUE(COMPRESSED_LUMINANCE_ARB);
        OGL_PUSH_VALUE(COMPRESSED_RGB_ARB);
        OGL_PUSH_VALUE(COMPRESSED_RGB_FXT1_3DFX);
        OGL_PUSH_VALUE(COMPRESSED_RGB_S3TC_DXT1_EXT);
        OGL_PUSH_VALUE(COMPRESSED_RGBA_ARB);
        OGL_PUSH_VALUE(COMPRESSED_RGBA_FXT1_3DFX);
        OGL_PUSH_VALUE(COMPRESSED_RGBA_S3TC_DXT1_EXT);
        OGL_PUSH_VALUE(COMPRESSED_RGBA_S3TC_DXT3_EXT);
        OGL_PUSH_VALUE(COMPRESSED_RGBA_S3TC_DXT5_EXT);
        OGL_PUSH_VALUE(COMPRESSED_TEXTURE_FORMATS_ARB);
        OGL_PUSH_VALUE(CONSERVE_MEMORY_HINT_PGI);
        OGL_PUSH_VALUE(CONSTANT_ALPHA_EXT);
        OGL_PUSH_VALUE(CONSTANT_ALPHA);
        OGL_PUSH_VALUE(CONSTANT_ATTENUATION);
        OGL_PUSH_VALUE(CONSTANT_BORDER_HP);
        OGL_PUSH_VALUE(CONSTANT_BORDER);
        OGL_PUSH_VALUE(CONSTANT_COLOR_EXT);
        OGL_PUSH_VALUE(CONSTANT_COLOR);
        OGL_PUSH_VALUE(CONSTANT_COLOR0_NV);
        OGL_PUSH_VALUE(CONSTANT_COLOR1_NV);
        OGL_PUSH_VALUE(CONSTANT_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_1D_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_1D);
        OGL_PUSH_VALUE(CONVOLUTION_2D_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_2D);
        OGL_PUSH_VALUE(CONVOLUTION_BORDER_COLOR_HP);
        OGL_PUSH_VALUE(CONVOLUTION_BORDER_COLOR);
        OGL_PUSH_VALUE(CONVOLUTION_BORDER_MODE_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_BORDER_MODE);
        OGL_PUSH_VALUE(CONVOLUTION_FILTER_BIAS_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_FILTER_BIAS);
        OGL_PUSH_VALUE(CONVOLUTION_FILTER_SCALE_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_FILTER_SCALE);
        OGL_PUSH_VALUE(CONVOLUTION_FORMAT_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_FORMAT);
        OGL_PUSH_VALUE(CONVOLUTION_HEIGHT_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_HEIGHT);
        OGL_PUSH_VALUE(CONVOLUTION_HINT_SGIX);
        OGL_PUSH_VALUE(CONVOLUTION_WIDTH_EXT);
        OGL_PUSH_VALUE(CONVOLUTION_WIDTH);
        OGL_PUSH_VALUE(COPY_INVERTED);
        OGL_PUSH_VALUE(COPY_PIXEL_TOKEN);
        OGL_PUSH_VALUE(COPY);
        OGL_PUSH_VALUE(CUBIC_EXT);
        OGL_PUSH_VALUE(CUBIC_HP);
        OGL_PUSH_VALUE(CULL_FACE_MODE);
        OGL_PUSH_VALUE(CULL_FACE);
        OGL_PUSH_VALUE(CULL_VERTEX_EXT);
        OGL_PUSH_VALUE(CULL_VERTEX_EYE_POSITION_EXT);
        OGL_PUSH_VALUE(CULL_VERTEX_IBM);
        OGL_PUSH_VALUE(CULL_VERTEX_OBJECT_POSITION_EXT);
        OGL_PUSH_VALUE(CURRENT_BINORMAL_EXT);
        OGL_PUSH_VALUE(CURRENT_BIT);
        OGL_PUSH_VALUE(CURRENT_COLOR);
        OGL_PUSH_VALUE(CURRENT_FOG_COORDINATE_EXT);
        OGL_PUSH_VALUE(CURRENT_INDEX);
        OGL_PUSH_VALUE(CURRENT_NORMAL);
        OGL_PUSH_VALUE(CURRENT_RASTER_COLOR);
        OGL_PUSH_VALUE(CURRENT_RASTER_DISTANCE);
        OGL_PUSH_VALUE(CURRENT_RASTER_INDEX);
        OGL_PUSH_VALUE(CURRENT_RASTER_NORMAL_SGIX);
        OGL_PUSH_VALUE(CURRENT_RASTER_POSITION_VALID);
        OGL_PUSH_VALUE(CURRENT_RASTER_POSITION);
        OGL_PUSH_VALUE(CURRENT_RASTER_TEXTURE_COORDS);
        OGL_PUSH_VALUE(CURRENT_SECONDARY_COLOR_EXT);
        OGL_PUSH_VALUE(CURRENT_TANGENT_EXT);
        OGL_PUSH_VALUE(CURRENT_TEXTURE_COORDS);
        OGL_PUSH_VALUE(CURRENT_VERTEX_WEIGHT_EXT);
        OGL_PUSH_VALUE(CURRENT_WEIGHT_ARB);
        OGL_PUSH_VALUE(CW);
        OGL_PUSH_VALUE(DECAL);
        OGL_PUSH_VALUE(DECR_WRAP_EXT);
        OGL_PUSH_VALUE(DECR);
        OGL_PUSH_VALUE(DEFORMATIONS_MASK_SGIX);
        OGL_PUSH_VALUE(DEPTH_BIAS);
        OGL_PUSH_VALUE(DEPTH_BITS);
        OGL_PUSH_VALUE(DEPTH_BUFFER_BIT);
        OGL_PUSH_VALUE(DEPTH_CLEAR_VALUE);
        OGL_PUSH_VALUE(DEPTH_COMPONENT);
        OGL_PUSH_VALUE(DEPTH_COMPONENT16_SGIX);
        OGL_PUSH_VALUE(DEPTH_COMPONENT24_SGIX);
        OGL_PUSH_VALUE(DEPTH_COMPONENT32_SGIX);
        OGL_PUSH_VALUE(DEPTH_FUNC);
        OGL_PUSH_VALUE(DEPTH_RANGE);
        OGL_PUSH_VALUE(DEPTH_SCALE);
        OGL_PUSH_VALUE(DEPTH_TEST);
        OGL_PUSH_VALUE(DEPTH_WRITEMASK);
        OGL_PUSH_VALUE(DEPTH);
        OGL_PUSH_VALUE(DETAIL_TEXTURE_2D_BINDING_SGIS);
        OGL_PUSH_VALUE(DETAIL_TEXTURE_2D_SGIS);
        OGL_PUSH_VALUE(DETAIL_TEXTURE_FUNC_POINTS_SGIS);
        OGL_PUSH_VALUE(DETAIL_TEXTURE_LEVEL_SGIS);
        OGL_PUSH_VALUE(DETAIL_TEXTURE_MODE_SGIS);
        OGL_PUSH_VALUE(DIFFUSE);
        OGL_PUSH_VALUE(DISCARD_NV);
        OGL_PUSH_VALUE(DISTANCE_ATTENUATION_EXT);
        OGL_PUSH_VALUE(DISTANCE_ATTENUATION_SGIS);
        OGL_PUSH_VALUE(DITHER);
        OGL_PUSH_VALUE(DOMAIN);
        OGL_PUSH_VALUE(DONT_CARE);
        OGL_PUSH_VALUE(DOT3_RGB_EXT);
        OGL_PUSH_VALUE(DOT3_RGBA_EXT);
        OGL_PUSH_VALUE(DOUBLE);
        OGL_PUSH_VALUE(DOUBLEBUFFER);
        OGL_PUSH_VALUE(DRAW_BUFFER);
        OGL_PUSH_VALUE(DRAW_PIXEL_TOKEN);
        OGL_PUSH_VALUE(DST_ALPHA);
        OGL_PUSH_VALUE(DST_COLOR);
        OGL_PUSH_VALUE(DUAL_ALPHA12_SGIS);
        OGL_PUSH_VALUE(DUAL_ALPHA16_SGIS);
        OGL_PUSH_VALUE(DUAL_ALPHA4_SGIS);
        OGL_PUSH_VALUE(DUAL_ALPHA8_SGIS);
        OGL_PUSH_VALUE(DUAL_INTENSITY12_SGIS);
        OGL_PUSH_VALUE(DUAL_INTENSITY16_SGIS);
        OGL_PUSH_VALUE(DUAL_INTENSITY4_SGIS);
        OGL_PUSH_VALUE(DUAL_INTENSITY8_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE_ALPHA4_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE_ALPHA8_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE12_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE16_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE4_SGIS);
        OGL_PUSH_VALUE(DUAL_LUMINANCE8_SGIS);
        OGL_PUSH_VALUE(DUAL_TEXTURE_SELECT_SGIS);
        OGL_PUSH_VALUE(E_TIMES_F_NV);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_EXT);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_POINTER);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY_STRIDE);
        OGL_PUSH_VALUE(EDGE_FLAG_ARRAY);
        OGL_PUSH_VALUE(EDGE_FLAG);
        OGL_PUSH_VALUE(EDGEFLAG_BIT_PGI);
        OGL_PUSH_VALUE(EMBOSS_CONSTANT_NV);
        OGL_PUSH_VALUE(EMBOSS_LIGHT_NV);
        OGL_PUSH_VALUE(EMBOSS_MAP_NV);
        OGL_PUSH_VALUE(EMISSION);
        OGL_PUSH_VALUE(ENABLE_BIT);
        OGL_PUSH_VALUE(EQUAL);
        OGL_PUSH_VALUE(EQUIV);
        OGL_PUSH_VALUE(EVAL_BIT);
        OGL_PUSH_VALUE(EXP);
        OGL_PUSH_VALUE(EXP2);
        OGL_PUSH_VALUE(EXPAND_NEGATE_NV);
        OGL_PUSH_VALUE(EXPAND_NORMAL_NV);
        OGL_PUSH_VALUE(EXTENSIONS);
        OGL_PUSH_VALUE(EYE_DISTANCE_TO_LINE_SGIS);
        OGL_PUSH_VALUE(EYE_DISTANCE_TO_POINT_SGIS);
        OGL_PUSH_VALUE(EYE_LINE_SGIS);
        OGL_PUSH_VALUE(EYE_LINEAR);
        OGL_PUSH_VALUE(EYE_PLANE_ABSOLUTE_NV);
        OGL_PUSH_VALUE(EYE_PLANE);
        OGL_PUSH_VALUE(EYE_POINT_SGIS);
        OGL_PUSH_VALUE(EYE_RADIAL_NV);
        OGL_PUSH_VALUE(FALSE);
        OGL_PUSH_VALUE(FASTEST);
        OGL_PUSH_VALUE(FEEDBACK_BUFFER_POINTER);
        OGL_PUSH_VALUE(FEEDBACK_BUFFER_SIZE);
        OGL_PUSH_VALUE(FEEDBACK_BUFFER_TYPE);
        OGL_PUSH_VALUE(FEEDBACK);
        OGL_PUSH_VALUE(FILL);
        OGL_PUSH_VALUE(FILTER4_SGIS);
        OGL_PUSH_VALUE(FLAT);
        OGL_PUSH_VALUE(FLOAT);
        OGL_PUSH_VALUE(FOG_BIT);
        OGL_PUSH_VALUE(FOG_COLOR);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_EXT);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(FOG_COORDINATE_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(FOG_COORDINATE_EXT);
        OGL_PUSH_VALUE(FOG_COORDINATE_SOURCE_EXT);
        OGL_PUSH_VALUE(FOG_DENSITY);
        OGL_PUSH_VALUE(FOG_DISTANCE_MODE_NV);
        OGL_PUSH_VALUE(FOG_END);
        OGL_PUSH_VALUE(FOG_FUNC_POINTS_SGIS);
        OGL_PUSH_VALUE(FOG_FUNC_SGIS);
        OGL_PUSH_VALUE(FOG_HINT);
        OGL_PUSH_VALUE(FOG_INDEX);
        OGL_PUSH_VALUE(FOG_MODE);
        OGL_PUSH_VALUE(FOG_OFFSET_SGIX);
        OGL_PUSH_VALUE(FOG_OFFSET_VALUE_SGIX);
        OGL_PUSH_VALUE(FOG_SPECULAR_TEXTURE_WIN);
        OGL_PUSH_VALUE(FOG_START);
        OGL_PUSH_VALUE(FOG);
        OGL_PUSH_VALUE(FRAGMENT_COLOR_EXT);
        OGL_PUSH_VALUE(FRAGMENT_COLOR_MATERIAL_FACE_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_COLOR_MATERIAL_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_DEPTH_EXT);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT0_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT1_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT2_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT3_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT4_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT5_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT6_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHT7_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_LIGHTING_SGIX);
        OGL_PUSH_VALUE(FRAGMENT_MATERIAL_EXT);
        OGL_PUSH_VALUE(FRAGMENT_NORMAL_EXT);
        OGL_PUSH_VALUE(FRAMEZOOM_FACTOR_SGIX);
        OGL_PUSH_VALUE(FRAMEZOOM_SGIX);
        OGL_PUSH_VALUE(FRONT_AND_BACK);
        OGL_PUSH_VALUE(FRONT_FACE);
        OGL_PUSH_VALUE(FRONT_LEFT);
        OGL_PUSH_VALUE(FRONT_RIGHT);
        OGL_PUSH_VALUE(FRONT);
        OGL_PUSH_VALUE(FULL_STIPPLE_HINT_PGI);
        OGL_PUSH_VALUE(FUNC_ADD_EXT);
        OGL_PUSH_VALUE(FUNC_ADD);
        OGL_PUSH_VALUE(FUNC_REVERSE_SUBTRACT_EXT);
        OGL_PUSH_VALUE(FUNC_REVERSE_SUBTRACT);
        OGL_PUSH_VALUE(FUNC_SUBTRACT_EXT);
        OGL_PUSH_VALUE(FUNC_SUBTRACT);
        OGL_PUSH_VALUE(GENERATE_MIPMAP_HINT_SGIS);
        OGL_PUSH_VALUE(GENERATE_MIPMAP_SGIS);
        OGL_PUSH_VALUE(GEOMETRY_DEFORMATION_BIT_SGIX);
        OGL_PUSH_VALUE(GEOMETRY_DEFORMATION_SGIX);
        OGL_PUSH_VALUE(GEQUAL);
        OGL_PUSH_VALUE(GLOBAL_ALPHA_FACTOR_SUN);
        OGL_PUSH_VALUE(GLOBAL_ALPHA_SUN);
        OGL_PUSH_VALUE(GREATER);
        OGL_PUSH_VALUE(GREEN_BIAS);
        OGL_PUSH_VALUE(GREEN_BITS);
        OGL_PUSH_VALUE(GREEN_MAX_CLAMP_INGR);
        OGL_PUSH_VALUE(GREEN_MIN_CLAMP_INGR);
        OGL_PUSH_VALUE(GREEN_SCALE);
        OGL_PUSH_VALUE(GREEN);
        OGL_PUSH_VALUE(HALF_BIAS_NEGATE_NV);
        OGL_PUSH_VALUE(HALF_BIAS_NORMAL_NV);
        OGL_PUSH_VALUE(HINT_BIT);
        OGL_PUSH_VALUE(HISTOGRAM_ALPHA_SIZE_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_ALPHA_SIZE);
        OGL_PUSH_VALUE(HISTOGRAM_BLUE_SIZE_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_BLUE_SIZE);
        OGL_PUSH_VALUE(HISTOGRAM_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_FORMAT_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_FORMAT);
        OGL_PUSH_VALUE(HISTOGRAM_GREEN_SIZE_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_GREEN_SIZE);
        OGL_PUSH_VALUE(HISTOGRAM_LUMINANCE_SIZE_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_LUMINANCE_SIZE);
        OGL_PUSH_VALUE(HISTOGRAM_RED_SIZE_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_RED_SIZE);
        OGL_PUSH_VALUE(HISTOGRAM_SINK_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_SINK);
        OGL_PUSH_VALUE(HISTOGRAM_WIDTH_EXT);
        OGL_PUSH_VALUE(HISTOGRAM_WIDTH);
        OGL_PUSH_VALUE(HISTOGRAM);
        OGL_PUSH_VALUE(IGNORE_BORDER_HP);
        OGL_PUSH_VALUE(IMAGE_CUBIC_WEIGHT_HP);
        OGL_PUSH_VALUE(IMAGE_MAG_FILTER_HP);
        OGL_PUSH_VALUE(IMAGE_MIN_FILTER_HP);
        OGL_PUSH_VALUE(IMAGE_ROTATE_ANGLE_HP);
        OGL_PUSH_VALUE(IMAGE_ROTATE_ORIGIN_X_HP);
        OGL_PUSH_VALUE(IMAGE_ROTATE_ORIGIN_Y_HP);
        OGL_PUSH_VALUE(IMAGE_SCALE_X_HP);
        OGL_PUSH_VALUE(IMAGE_SCALE_Y_HP);
        OGL_PUSH_VALUE(IMAGE_TRANSFORM_2D_HP);
        OGL_PUSH_VALUE(IMAGE_TRANSLATE_X_HP);
        OGL_PUSH_VALUE(IMAGE_TRANSLATE_Y_HP);
        OGL_PUSH_VALUE(INCR_WRAP_EXT);
        OGL_PUSH_VALUE(INCR);
        OGL_PUSH_VALUE(INDEX_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(INDEX_ARRAY_EXT);
        OGL_PUSH_VALUE(INDEX_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(INDEX_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(INDEX_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(INDEX_ARRAY_POINTER);
        OGL_PUSH_VALUE(INDEX_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(INDEX_ARRAY_STRIDE);
        OGL_PUSH_VALUE(INDEX_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(INDEX_ARRAY_TYPE);
        OGL_PUSH_VALUE(INDEX_ARRAY);
        OGL_PUSH_VALUE(INDEX_BIT_PGI);
        OGL_PUSH_VALUE(INDEX_BITS);
        OGL_PUSH_VALUE(INDEX_CLEAR_VALUE);
        OGL_PUSH_VALUE(INDEX_LOGIC_OP);
        OGL_PUSH_VALUE(INDEX_MATERIAL_EXT);
        OGL_PUSH_VALUE(INDEX_MATERIAL_FACE_EXT);
        OGL_PUSH_VALUE(INDEX_MATERIAL_PARAMETER_EXT);
        OGL_PUSH_VALUE(INDEX_MODE);
        OGL_PUSH_VALUE(INDEX_OFFSET);
        OGL_PUSH_VALUE(INDEX_SHIFT);
        OGL_PUSH_VALUE(INDEX_TEST_EXT);
        OGL_PUSH_VALUE(INDEX_TEST_FUNC_EXT);
        OGL_PUSH_VALUE(INDEX_TEST_REF_EXT);
        OGL_PUSH_VALUE(INDEX_WRITEMASK);
        OGL_PUSH_VALUE(INSTRUMENT_BUFFER_POINTER_SGIX);
        OGL_PUSH_VALUE(INSTRUMENT_MEASUREMENTS_SGIX);
        OGL_PUSH_VALUE(INT);
        OGL_PUSH_VALUE(INTENSITY_EXT);
        OGL_PUSH_VALUE(INTENSITY);
        OGL_PUSH_VALUE(INTENSITY12_EXT);
        OGL_PUSH_VALUE(INTENSITY12);
        OGL_PUSH_VALUE(INTENSITY16_EXT);
        OGL_PUSH_VALUE(INTENSITY16);
        OGL_PUSH_VALUE(INTENSITY4_EXT);
        OGL_PUSH_VALUE(INTENSITY4);
        OGL_PUSH_VALUE(INTENSITY8_EXT);
        OGL_PUSH_VALUE(INTENSITY8);
        OGL_PUSH_VALUE(INTERLACE_READ_INGR);
        OGL_PUSH_VALUE(INTERLACE_SGIX);
        OGL_PUSH_VALUE(INTERPOLATE_EXT);
        OGL_PUSH_VALUE(INVALID_ENUM);
        OGL_PUSH_VALUE(INVALID_OPERATION);
        OGL_PUSH_VALUE(INVALID_VALUE);
        OGL_PUSH_VALUE(INVERT);
        OGL_PUSH_VALUE(INVERTED_SCREEN_W_REND);
        OGL_PUSH_VALUE(IR_INSTRUMENT1_SGIX);
        OGL_PUSH_VALUE(IUI_N3F_V2F_EXT);
        OGL_PUSH_VALUE(IUI_N3F_V3F_EXT);
        OGL_PUSH_VALUE(IUI_V2F_EXT);
        OGL_PUSH_VALUE(IUI_V3F_EXT);
        OGL_PUSH_VALUE(KEEP);
        OGL_PUSH_VALUE(LEFT);
        OGL_PUSH_VALUE(LEQUAL);
        OGL_PUSH_VALUE(LESS);
        OGL_PUSH_VALUE(LIGHT_ENV_MODE_SGIX);
        OGL_PUSH_VALUE(LIGHT_MODEL_AMBIENT);
        OGL_PUSH_VALUE(LIGHT_MODEL_COLOR_CONTROL_EXT);
        OGL_PUSH_VALUE(LIGHT_MODEL_COLOR_CONTROL);
        OGL_PUSH_VALUE(LIGHT_MODEL_LOCAL_VIEWER);
        OGL_PUSH_VALUE(LIGHT_MODEL_SPECULAR_VECTOR_APPLE);
        OGL_PUSH_VALUE(LIGHT_MODEL_TWO_SIDE);
        OGL_PUSH_VALUE(LIGHT0);
        OGL_PUSH_VALUE(LIGHT1);
        OGL_PUSH_VALUE(LIGHT2);
        OGL_PUSH_VALUE(LIGHT3);
        OGL_PUSH_VALUE(LIGHT4);
        OGL_PUSH_VALUE(LIGHT5);
        OGL_PUSH_VALUE(LIGHT6);
        OGL_PUSH_VALUE(LIGHT7);
        OGL_PUSH_VALUE(LIGHTING_BIT);
        OGL_PUSH_VALUE(LIGHTING);
        OGL_PUSH_VALUE(LINE_BIT);
        OGL_PUSH_VALUE(LINE_LOOP);
        OGL_PUSH_VALUE(LINE_RESET_TOKEN);
        OGL_PUSH_VALUE(LINE_SMOOTH_HINT);
        OGL_PUSH_VALUE(LINE_SMOOTH);
        OGL_PUSH_VALUE(LINE_STIPPLE_PATTERN);
        OGL_PUSH_VALUE(LINE_STIPPLE_REPEAT);
        OGL_PUSH_VALUE(LINE_STIPPLE);
        OGL_PUSH_VALUE(LINE_STRIP);
        OGL_PUSH_VALUE(LINE_TOKEN);
        OGL_PUSH_VALUE(LINE_WIDTH_GRANULARITY);
        OGL_PUSH_VALUE(LINE_WIDTH_RANGE);
        OGL_PUSH_VALUE(LINE_WIDTH);
        OGL_PUSH_VALUE(LINE);
        OGL_PUSH_VALUE(LINEAR_ATTENUATION);
        OGL_PUSH_VALUE(LINEAR_CLIPMAP_LINEAR_SGIX);
        OGL_PUSH_VALUE(LINEAR_CLIPMAP_NEAREST_SGIX);
        OGL_PUSH_VALUE(LINEAR_DETAIL_ALPHA_SGIS);
        OGL_PUSH_VALUE(LINEAR_DETAIL_COLOR_SGIS);
        OGL_PUSH_VALUE(LINEAR_DETAIL_SGIS);
        OGL_PUSH_VALUE(LINEAR_MIPMAP_LINEAR);
        OGL_PUSH_VALUE(LINEAR_MIPMAP_NEAREST);
        OGL_PUSH_VALUE(LINEAR_SHARPEN_ALPHA_SGIS);
        OGL_PUSH_VALUE(LINEAR_SHARPEN_COLOR_SGIS);
        OGL_PUSH_VALUE(LINEAR_SHARPEN_SGIS);
        OGL_PUSH_VALUE(LINEAR);
        OGL_PUSH_VALUE(LINES);
        OGL_PUSH_VALUE(LIST_BASE);
        OGL_PUSH_VALUE(LIST_BIT);
        OGL_PUSH_VALUE(LIST_INDEX);
        OGL_PUSH_VALUE(LIST_MODE);
        OGL_PUSH_VALUE(LIST_PRIORITY_SGIX);
        OGL_PUSH_VALUE(LOAD);
        OGL_PUSH_VALUE(LOGIC_OP_MODE);
        OGL_PUSH_VALUE(LOGIC_OP);
        OGL_PUSH_VALUE(LUMINANCE_ALPHA);
        OGL_PUSH_VALUE(LUMINANCE);
        OGL_PUSH_VALUE(LUMINANCE12_ALPHA12_EXT);
        OGL_PUSH_VALUE(LUMINANCE12_ALPHA12);
        OGL_PUSH_VALUE(LUMINANCE12_ALPHA4_EXT);
        OGL_PUSH_VALUE(LUMINANCE12_ALPHA4);
        OGL_PUSH_VALUE(LUMINANCE12_EXT);
        OGL_PUSH_VALUE(LUMINANCE12);
        OGL_PUSH_VALUE(LUMINANCE16_ALPHA16_EXT);
        OGL_PUSH_VALUE(LUMINANCE16_ALPHA16);
        OGL_PUSH_VALUE(LUMINANCE16_EXT);
        OGL_PUSH_VALUE(LUMINANCE16);
        OGL_PUSH_VALUE(LUMINANCE4_ALPHA4_EXT);
        OGL_PUSH_VALUE(LUMINANCE4_ALPHA4);
        OGL_PUSH_VALUE(LUMINANCE4_EXT);
        OGL_PUSH_VALUE(LUMINANCE4);
        OGL_PUSH_VALUE(LUMINANCE6_ALPHA2_EXT);
        OGL_PUSH_VALUE(LUMINANCE6_ALPHA2);
        OGL_PUSH_VALUE(LUMINANCE8_ALPHA8_EXT);
        OGL_PUSH_VALUE(LUMINANCE8_ALPHA8);
        OGL_PUSH_VALUE(LUMINANCE8_EXT);
        OGL_PUSH_VALUE(LUMINANCE8);
        OGL_PUSH_VALUE(MAP_COLOR);
        OGL_PUSH_VALUE(MAP_STENCIL);
        OGL_PUSH_VALUE(MAP1_BINORMAL_EXT);
        OGL_PUSH_VALUE(MAP1_COLOR_4);
        OGL_PUSH_VALUE(MAP1_GRID_DOMAIN);
        OGL_PUSH_VALUE(MAP1_GRID_SEGMENTS);
        OGL_PUSH_VALUE(MAP1_INDEX);
        OGL_PUSH_VALUE(MAP1_NORMAL);
        OGL_PUSH_VALUE(MAP1_TANGENT_EXT);
        OGL_PUSH_VALUE(MAP1_TEXTURE_COORD_1);
        OGL_PUSH_VALUE(MAP1_TEXTURE_COORD_2);
        OGL_PUSH_VALUE(MAP1_TEXTURE_COORD_3);
        OGL_PUSH_VALUE(MAP1_TEXTURE_COORD_4);
        OGL_PUSH_VALUE(MAP1_VERTEX_3);
        OGL_PUSH_VALUE(MAP1_VERTEX_4);
        OGL_PUSH_VALUE(MAP2_BINORMAL_EXT);
        OGL_PUSH_VALUE(MAP2_COLOR_4);
        OGL_PUSH_VALUE(MAP2_GRID_DOMAIN);
        OGL_PUSH_VALUE(MAP2_GRID_SEGMENTS);
        OGL_PUSH_VALUE(MAP2_INDEX);
        OGL_PUSH_VALUE(MAP2_NORMAL);
        OGL_PUSH_VALUE(MAP2_TANGENT_EXT);
        OGL_PUSH_VALUE(MAP2_TEXTURE_COORD_1);
        OGL_PUSH_VALUE(MAP2_TEXTURE_COORD_2);
        OGL_PUSH_VALUE(MAP2_TEXTURE_COORD_3);
        OGL_PUSH_VALUE(MAP2_TEXTURE_COORD_4);
        OGL_PUSH_VALUE(MAP2_VERTEX_3);
        OGL_PUSH_VALUE(MAP2_VERTEX_4);
        OGL_PUSH_VALUE(MAT_AMBIENT_AND_DIFFUSE_BIT_PGI);
        OGL_PUSH_VALUE(MAT_AMBIENT_BIT_PGI);
        OGL_PUSH_VALUE(MAT_COLOR_INDEXES_BIT_PGI);
        OGL_PUSH_VALUE(MAT_DIFFUSE_BIT_PGI);
        OGL_PUSH_VALUE(MAT_EMISSION_BIT_PGI);
        OGL_PUSH_VALUE(MAT_SHININESS_BIT_PGI);
        OGL_PUSH_VALUE(MAT_SPECULAR_BIT_PGI);
        OGL_PUSH_VALUE(MATERIAL_SIDE_HINT_PGI);
        OGL_PUSH_VALUE(MATRIX_MODE);
        OGL_PUSH_VALUE(MAX_3D_TEXTURE_SIZE_EXT);
        OGL_PUSH_VALUE(MAX_3D_TEXTURE_SIZE);
        OGL_PUSH_VALUE(MAX_3D_TEXTURE_SIZE);
        OGL_PUSH_VALUE(MAX_4D_TEXTURE_SIZE_SGIS);
        OGL_PUSH_VALUE(MAX_ACTIVE_LIGHTS_SGIX);
        OGL_PUSH_VALUE(MAX_ASYNC_DRAW_PIXELS_SGIX);
        OGL_PUSH_VALUE(MAX_ASYNC_HISTOGRAM_SGIX);
        OGL_PUSH_VALUE(MAX_ASYNC_READ_PIXELS_SGIX);
        OGL_PUSH_VALUE(MAX_ASYNC_TEX_IMAGE_SGIX);
        OGL_PUSH_VALUE(MAX_ATTRIB_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_CLIENT_ATTRIB_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_CLIP_PLANES);
        OGL_PUSH_VALUE(MAX_CLIPMAP_DEPTH_SGIX);
        OGL_PUSH_VALUE(MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX);
        OGL_PUSH_VALUE(MAX_COLOR_MATRIX_STACK_DEPTH_SGI);
        OGL_PUSH_VALUE(MAX_COLOR_MATRIX_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_CONVOLUTION_HEIGHT_EXT);
        OGL_PUSH_VALUE(MAX_CONVOLUTION_HEIGHT);
        OGL_PUSH_VALUE(MAX_CONVOLUTION_WIDTH_EXT);
        OGL_PUSH_VALUE(MAX_CONVOLUTION_WIDTH);
        OGL_PUSH_VALUE(MAX_CUBE_MAP_TEXTURE_SIZE_ARB);
        OGL_PUSH_VALUE(MAX_CUBE_MAP_TEXTURE_SIZE_EXT);
        OGL_PUSH_VALUE(MAX_DEFORMATION_ORDER_SGIX);
        OGL_PUSH_VALUE(MAX_ELEMENTS_INDICES_EXT);
        OGL_PUSH_VALUE(MAX_ELEMENTS_INDICES);
        OGL_PUSH_VALUE(MAX_ELEMENTS_VERTICES_EXT);
        OGL_PUSH_VALUE(MAX_ELEMENTS_VERTICES);
        OGL_PUSH_VALUE(MAX_EVAL_ORDER);
        OGL_PUSH_VALUE(MAX_EXT);
        OGL_PUSH_VALUE(MAX_FOG_FUNC_POINTS_SGIS);
        OGL_PUSH_VALUE(MAX_FRAGMENT_LIGHTS_SGIX);
        OGL_PUSH_VALUE(MAX_FRAMEZOOM_FACTOR_SGIX);
        OGL_PUSH_VALUE(MAX_GENERAL_COMBINERS_NV);
        OGL_PUSH_VALUE(MAX_LIGHTS);
        OGL_PUSH_VALUE(MAX_LIST_NESTING);
        OGL_PUSH_VALUE(MAX_MODELVIEW_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_NAME_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_PIXEL_MAP_TABLE);
        OGL_PUSH_VALUE(MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT);
        OGL_PUSH_VALUE(MAX_PROJECTION_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_SHININESS_NV);
        OGL_PUSH_VALUE(MAX_SPOT_EXPONENT_NV);
        OGL_PUSH_VALUE(MAX_TEXTURE_LOD_BIAS_EXT);
        OGL_PUSH_VALUE(MAX_TEXTURE_MAX_ANISOTROPY_EXT);
        OGL_PUSH_VALUE(MAX_TEXTURE_SIZE);
        OGL_PUSH_VALUE(MAX_TEXTURE_STACK_DEPTH);
        OGL_PUSH_VALUE(MAX_TEXTURE_UNITS_ARB);
        OGL_PUSH_VALUE(MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV);
        OGL_PUSH_VALUE(MAX_VERTEX_HINT_PGI);
        OGL_PUSH_VALUE(MAX_VERTEX_UNITS_ARB);
        OGL_PUSH_VALUE(MAX_VIEWPORT_DIMS);
        OGL_PUSH_VALUE(MAX);
        OGL_PUSH_VALUE(MIN_EXT);
        OGL_PUSH_VALUE(MIN);
        OGL_PUSH_VALUE(MINMAX_EXT);
        OGL_PUSH_VALUE(MINMAX_FORMAT_EXT);
        OGL_PUSH_VALUE(MINMAX_FORMAT);
        OGL_PUSH_VALUE(MINMAX_SINK_EXT);
        OGL_PUSH_VALUE(MINMAX_SINK);
        OGL_PUSH_VALUE(MINMAX);
        OGL_PUSH_VALUE(MODELVIEW_MATRIX);
        OGL_PUSH_VALUE(MODELVIEW_STACK_DEPTH);
        OGL_PUSH_VALUE(MODELVIEW);
        OGL_PUSH_VALUE(MODELVIEW0_ARB);
        OGL_PUSH_VALUE(MODELVIEW0_EXT);
        OGL_PUSH_VALUE(MODELVIEW0_MATRIX_EXT);
        OGL_PUSH_VALUE(MODELVIEW0_STACK_DEPTH_EXT);
        OGL_PUSH_VALUE(MODELVIEW1_ARB);
        OGL_PUSH_VALUE(MODELVIEW1_EXT);
        OGL_PUSH_VALUE(MODELVIEW1_STACK_DEPTH_EXT);
        OGL_PUSH_VALUE(MODELVIEW10_ARB);
        OGL_PUSH_VALUE(MODELVIEW11_ARB);
        OGL_PUSH_VALUE(MODELVIEW12_ARB);
        OGL_PUSH_VALUE(MODELVIEW13_ARB);
        OGL_PUSH_VALUE(MODELVIEW14_ARB);
        OGL_PUSH_VALUE(MODELVIEW15_ARB);
        OGL_PUSH_VALUE(MODELVIEW16_ARB);
        OGL_PUSH_VALUE(MODELVIEW17_ARB);
        OGL_PUSH_VALUE(MODELVIEW18_ARB);
        OGL_PUSH_VALUE(MODELVIEW19_ARB);
        OGL_PUSH_VALUE(MODELVIEW2_ARB);
        OGL_PUSH_VALUE(MODELVIEW20_ARB);
        OGL_PUSH_VALUE(MODELVIEW21_ARB);
        OGL_PUSH_VALUE(MODELVIEW22_ARB);
        OGL_PUSH_VALUE(MODELVIEW23_ARB);
        OGL_PUSH_VALUE(MODELVIEW24_ARB);
        OGL_PUSH_VALUE(MODELVIEW25_ARB);
        OGL_PUSH_VALUE(MODELVIEW26_ARB);
        OGL_PUSH_VALUE(MODELVIEW27_ARB);
        OGL_PUSH_VALUE(MODELVIEW28_ARB);
        OGL_PUSH_VALUE(MODELVIEW29_ARB);
        OGL_PUSH_VALUE(MODELVIEW3_ARB);
        OGL_PUSH_VALUE(MODELVIEW30_ARB);
        OGL_PUSH_VALUE(MODELVIEW31_ARB);
        OGL_PUSH_VALUE(MODELVIEW4_ARB);
        OGL_PUSH_VALUE(MODELVIEW5_ARB);
        OGL_PUSH_VALUE(MODELVIEW6_ARB);
        OGL_PUSH_VALUE(MODELVIEW7_ARB);
        OGL_PUSH_VALUE(MODELVIEW8_ARB);
        OGL_PUSH_VALUE(MODELVIEW9_ARB);
        OGL_PUSH_VALUE(MODULATE);
        OGL_PUSH_VALUE(MULT);
        OGL_PUSH_VALUE(MULTISAMPLE_3DFX);
        OGL_PUSH_VALUE(MULTISAMPLE_ARB);
        OGL_PUSH_VALUE(MULTISAMPLE_BIT_3DFX);
        OGL_PUSH_VALUE(MULTISAMPLE_BIT_ARB);
        OGL_PUSH_VALUE(MULTISAMPLE_EXT);
        OGL_PUSH_VALUE(MULTISAMPLE_SGIS);
        OGL_PUSH_VALUE(N3F_V3F);
        OGL_PUSH_VALUE(NAME_STACK_DEPTH);
        OGL_PUSH_VALUE(NAND);
        OGL_PUSH_VALUE(NATIVE_GRAPHICS_BEGIN_HINT_PGI);
        OGL_PUSH_VALUE(NATIVE_GRAPHICS_END_HINT_PGI);
        OGL_PUSH_VALUE(NATIVE_GRAPHICS_HANDLE_PGI);
        OGL_PUSH_VALUE(NEAREST_CLIPMAP_LINEAR_SGIX);
        OGL_PUSH_VALUE(NEAREST_CLIPMAP_NEAREST_SGIX);
        OGL_PUSH_VALUE(NEAREST_MIPMAP_LINEAR);
        OGL_PUSH_VALUE(NEAREST_MIPMAP_NEAREST);
        OGL_PUSH_VALUE(NEAREST);
        OGL_PUSH_VALUE(NEVER);
        OGL_PUSH_VALUE(NICEST);
        OGL_PUSH_VALUE(NO_ERROR);
        OGL_PUSH_VALUE(NONE);
        OGL_PUSH_VALUE(NOOP);
        OGL_PUSH_VALUE(NOR);
        OGL_PUSH_VALUE(NORMAL_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(NORMAL_ARRAY_EXT);
        OGL_PUSH_VALUE(NORMAL_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(NORMAL_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(NORMAL_ARRAY_PARALLEL_POINTERS_INTEL);
        OGL_PUSH_VALUE(NORMAL_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(NORMAL_ARRAY_POINTER);
        OGL_PUSH_VALUE(NORMAL_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(NORMAL_ARRAY_STRIDE);
        OGL_PUSH_VALUE(NORMAL_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(NORMAL_ARRAY_TYPE);
        OGL_PUSH_VALUE(NORMAL_ARRAY);
        OGL_PUSH_VALUE(NORMAL_BIT_PGI);
        OGL_PUSH_VALUE(NORMAL_MAP_ARB);
        OGL_PUSH_VALUE(NORMAL_MAP_EXT);
        OGL_PUSH_VALUE(NORMAL_MAP_NV);
        OGL_PUSH_VALUE(NORMALIZE);
        OGL_PUSH_VALUE(NOTEQUAL);
        OGL_PUSH_VALUE(NUM_COMPRESSED_TEXTURE_FORMATS_ARB);
        OGL_PUSH_VALUE(NUM_GENERAL_COMBINERS_NV);
        OGL_PUSH_VALUE(OBJECT_DISTANCE_TO_LINE_SGIS);
        OGL_PUSH_VALUE(OBJECT_DISTANCE_TO_POINT_SGIS);
        OGL_PUSH_VALUE(OBJECT_LINE_SGIS);
        OGL_PUSH_VALUE(OBJECT_LINEAR);
        OGL_PUSH_VALUE(OBJECT_PLANE);
        OGL_PUSH_VALUE(OBJECT_POINT_SGIS);
        OGL_PUSH_VALUE(OCCLUSION_TEST_HP);
        OGL_PUSH_VALUE(OCCLUSION_TEST_RESULT_HP);
        OGL_PUSH_VALUE(ONE_MINUS_CONSTANT_ALPHA_EXT);
        OGL_PUSH_VALUE(ONE_MINUS_CONSTANT_ALPHA);
        OGL_PUSH_VALUE(ONE_MINUS_CONSTANT_COLOR_EXT);
        OGL_PUSH_VALUE(ONE_MINUS_CONSTANT_COLOR);
        OGL_PUSH_VALUE(ONE_MINUS_DST_ALPHA);
        OGL_PUSH_VALUE(ONE_MINUS_DST_COLOR);
        OGL_PUSH_VALUE(ONE_MINUS_SRC_ALPHA);
        OGL_PUSH_VALUE(ONE_MINUS_SRC_COLOR);
        OGL_PUSH_VALUE(ONE);
        OGL_PUSH_VALUE(OPERAND0_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND0_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND1_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND1_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND2_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND2_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND3_ALPHA_NV);
        OGL_PUSH_VALUE(OPERAND3_RGB_NV);
        OGL_PUSH_VALUE(OR_INVERTED);
        OGL_PUSH_VALUE(OR_REVERSE);
        OGL_PUSH_VALUE(OR);
        OGL_PUSH_VALUE(ORDER);
        OGL_PUSH_VALUE(OUT_OF_MEMORY);
        OGL_PUSH_VALUE(PACK_ALIGNMENT);
        OGL_PUSH_VALUE(PACK_CMYK_HINT_EXT);
        OGL_PUSH_VALUE(PACK_IMAGE_DEPTH_SGIS);
        OGL_PUSH_VALUE(PACK_IMAGE_HEIGHT_EXT);
        OGL_PUSH_VALUE(PACK_IMAGE_HEIGHT);
        OGL_PUSH_VALUE(PACK_IMAGE_HEIGHT);
        OGL_PUSH_VALUE(PACK_LSB_FIRST);
        OGL_PUSH_VALUE(PACK_RESAMPLE_SGIX);
        OGL_PUSH_VALUE(PACK_ROW_LENGTH);
        OGL_PUSH_VALUE(PACK_SKIP_IMAGES_EXT);
        OGL_PUSH_VALUE(PACK_SKIP_IMAGES);
        OGL_PUSH_VALUE(PACK_SKIP_IMAGES);
        OGL_PUSH_VALUE(PACK_SKIP_PIXELS);
        OGL_PUSH_VALUE(PACK_SKIP_ROWS);
        OGL_PUSH_VALUE(PACK_SKIP_VOLUMES_SGIS);
        OGL_PUSH_VALUE(PACK_SUBSAMPLE_RATE_SGIX);
        OGL_PUSH_VALUE(PACK_SWAP_BYTES);
        OGL_PUSH_VALUE(PARALLEL_ARRAYS_INTEL);
        OGL_PUSH_VALUE(PASS_THROUGH_TOKEN);
        OGL_PUSH_VALUE(PERSPECTIVE_CORRECTION_HINT);
        OGL_PUSH_VALUE(PERTURB_EXT);
        OGL_PUSH_VALUE(PHONG_HINT_WIN);
        OGL_PUSH_VALUE(PHONG_WIN);
        OGL_PUSH_VALUE(PIXEL_CUBIC_WEIGHT_EXT);
        OGL_PUSH_VALUE(PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS);
        OGL_PUSH_VALUE(PIXEL_FRAGMENT_RGB_SOURCE_SGIS);
        OGL_PUSH_VALUE(PIXEL_GROUP_COLOR_SGIS);
        OGL_PUSH_VALUE(PIXEL_MAG_FILTER_EXT);
        OGL_PUSH_VALUE(PIXEL_MAP_A_TO_A_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_A_TO_A);
        OGL_PUSH_VALUE(PIXEL_MAP_B_TO_B_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_B_TO_B);
        OGL_PUSH_VALUE(PIXEL_MAP_G_TO_G_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_G_TO_G);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_A_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_A);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_B_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_B);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_G_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_G);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_I_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_I);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_R_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_I_TO_R);
        OGL_PUSH_VALUE(PIXEL_MAP_R_TO_R_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_R_TO_R);
        OGL_PUSH_VALUE(PIXEL_MAP_S_TO_S_SIZE);
        OGL_PUSH_VALUE(PIXEL_MAP_S_TO_S);
        OGL_PUSH_VALUE(PIXEL_MIN_FILTER_EXT);
        OGL_PUSH_VALUE(PIXEL_MODE_BIT);
        OGL_PUSH_VALUE(PIXEL_SUBSAMPLE_2424_SGIX);
        OGL_PUSH_VALUE(PIXEL_SUBSAMPLE_4242_SGIX);
        OGL_PUSH_VALUE(PIXEL_SUBSAMPLE_4444_SGIX);
        OGL_PUSH_VALUE(PIXEL_TEX_GEN_MODE_SGIX);
        OGL_PUSH_VALUE(PIXEL_TEX_GEN_SGIX);
        OGL_PUSH_VALUE(PIXEL_TEXTURE_SGIS);
        OGL_PUSH_VALUE(PIXEL_TILE_BEST_ALIGNMENT_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_CACHE_INCREMENT_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_CACHE_SIZE_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_GRID_DEPTH_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_GRID_HEIGHT_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_GRID_WIDTH_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_HEIGHT_SGIX);
        OGL_PUSH_VALUE(PIXEL_TILE_WIDTH_SGIX);
        OGL_PUSH_VALUE(PIXEL_TRANSFORM_2D_EXT);
        OGL_PUSH_VALUE(PIXEL_TRANSFORM_2D_MATRIX_EXT);
        OGL_PUSH_VALUE(PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT);
        OGL_PUSH_VALUE(POINT_BIT);
        OGL_PUSH_VALUE(POINT_FADE_THRESHOLD_SIZE_EXT);
        OGL_PUSH_VALUE(POINT_FADE_THRESHOLD_SIZE_SGIS);
        OGL_PUSH_VALUE(POINT_SIZE_GRANULARITY);
        OGL_PUSH_VALUE(POINT_SIZE_MAX_EXT);
        OGL_PUSH_VALUE(POINT_SIZE_MAX_SGIS);
        OGL_PUSH_VALUE(POINT_SIZE_MIN_EXT);
        OGL_PUSH_VALUE(POINT_SIZE_MIN_SGIS);
        OGL_PUSH_VALUE(POINT_SIZE_RANGE);
        OGL_PUSH_VALUE(POINT_SIZE);
        OGL_PUSH_VALUE(POINT_SMOOTH_HINT);
        OGL_PUSH_VALUE(POINT_SMOOTH);
        OGL_PUSH_VALUE(POINT_TOKEN);
        OGL_PUSH_VALUE(POINT);
        OGL_PUSH_VALUE(POINTS);
        OGL_PUSH_VALUE(POLYGON_BIT);
        OGL_PUSH_VALUE(POLYGON_MODE);
        OGL_PUSH_VALUE(POLYGON_OFFSET_BIAS_EXT);
        OGL_PUSH_VALUE(POLYGON_OFFSET_EXT);
        OGL_PUSH_VALUE(POLYGON_OFFSET_FACTOR_EXT);
        OGL_PUSH_VALUE(POLYGON_OFFSET_FACTOR);
        OGL_PUSH_VALUE(POLYGON_OFFSET_FILL);
        OGL_PUSH_VALUE(POLYGON_OFFSET_LINE);
        OGL_PUSH_VALUE(POLYGON_OFFSET_POINT);
        OGL_PUSH_VALUE(POLYGON_OFFSET_UNITS);
        OGL_PUSH_VALUE(POLYGON_SMOOTH_HINT);
        OGL_PUSH_VALUE(POLYGON_SMOOTH);
        OGL_PUSH_VALUE(POLYGON_STIPPLE_BIT);
        OGL_PUSH_VALUE(POLYGON_STIPPLE);
        OGL_PUSH_VALUE(POLYGON_TOKEN);
        OGL_PUSH_VALUE(POLYGON);
        OGL_PUSH_VALUE(POSITION);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_ALPHA_BIAS_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_ALPHA_BIAS);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_ALPHA_SCALE_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_ALPHA_SCALE);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_BLUE_BIAS_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_BLUE_BIAS);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_BLUE_SCALE_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_BLUE_SCALE);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_COLOR_TABLE);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_GREEN_BIAS_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_GREEN_BIAS);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_GREEN_SCALE_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_GREEN_SCALE);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_RED_BIAS_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_RED_BIAS);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_RED_SCALE_SGI);
        OGL_PUSH_VALUE(POST_COLOR_MATRIX_RED_SCALE);
        OGL_PUSH_VALUE(POST_CONVOLUTION_ALPHA_BIAS_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_ALPHA_BIAS);
        OGL_PUSH_VALUE(POST_CONVOLUTION_ALPHA_SCALE_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_ALPHA_SCALE);
        OGL_PUSH_VALUE(POST_CONVOLUTION_BLUE_BIAS_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_BLUE_BIAS);
        OGL_PUSH_VALUE(POST_CONVOLUTION_BLUE_SCALE_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_BLUE_SCALE);
        OGL_PUSH_VALUE(POST_CONVOLUTION_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(POST_CONVOLUTION_COLOR_TABLE);
        OGL_PUSH_VALUE(POST_CONVOLUTION_GREEN_BIAS_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_GREEN_BIAS);
        OGL_PUSH_VALUE(POST_CONVOLUTION_GREEN_SCALE_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_GREEN_SCALE);
        OGL_PUSH_VALUE(POST_CONVOLUTION_RED_BIAS_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_RED_BIAS);
        OGL_PUSH_VALUE(POST_CONVOLUTION_RED_SCALE_EXT);
        OGL_PUSH_VALUE(POST_CONVOLUTION_RED_SCALE);
        OGL_PUSH_VALUE(POST_IMAGE_TRANSFORM_COLOR_TABLE_HP);
        OGL_PUSH_VALUE(POST_TEXTURE_FILTER_BIAS_RANGE_SGIX);
        OGL_PUSH_VALUE(POST_TEXTURE_FILTER_BIAS_SGIX);
        OGL_PUSH_VALUE(POST_TEXTURE_FILTER_SCALE_RANGE_SGIX);
        OGL_PUSH_VALUE(POST_TEXTURE_FILTER_SCALE_SGIX);
        OGL_PUSH_VALUE(PREFER_DOUBLEBUFFER_HINT_PGI);
        OGL_PUSH_VALUE(PREVIOUS_EXT);
        OGL_PUSH_VALUE(PRIMARY_COLOR_EXT);
        OGL_PUSH_VALUE(PRIMARY_COLOR_NV);
        OGL_PUSH_VALUE(PROJECTION_MATRIX);
        OGL_PUSH_VALUE(PROJECTION_STACK_DEPTH);
        OGL_PUSH_VALUE(PROJECTION);
        OGL_PUSH_VALUE(PROXY_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(PROXY_COLOR_TABLE);
        OGL_PUSH_VALUE(PROXY_HISTOGRAM_EXT);
        OGL_PUSH_VALUE(PROXY_HISTOGRAM);
        OGL_PUSH_VALUE(PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(PROXY_POST_COLOR_MATRIX_COLOR_TABLE);
        OGL_PUSH_VALUE(PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(PROXY_POST_CONVOLUTION_COLOR_TABLE);
        OGL_PUSH_VALUE(PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP);
        OGL_PUSH_VALUE(PROXY_TEXTURE_1D_EXT);
        OGL_PUSH_VALUE(PROXY_TEXTURE_1D);
        OGL_PUSH_VALUE(PROXY_TEXTURE_2D_EXT);
        OGL_PUSH_VALUE(PROXY_TEXTURE_2D);
        OGL_PUSH_VALUE(PROXY_TEXTURE_3D_EXT);
        OGL_PUSH_VALUE(PROXY_TEXTURE_3D);
        OGL_PUSH_VALUE(PROXY_TEXTURE_3D);
        OGL_PUSH_VALUE(PROXY_TEXTURE_4D_SGIS);
        OGL_PUSH_VALUE(PROXY_TEXTURE_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(PROXY_TEXTURE_CUBE_MAP_ARB);
        OGL_PUSH_VALUE(PROXY_TEXTURE_CUBE_MAP_EXT);
        OGL_PUSH_VALUE(Q);
        OGL_PUSH_VALUE(QUAD_ALPHA4_SGIS);
        OGL_PUSH_VALUE(QUAD_ALPHA8_SGIS);
        OGL_PUSH_VALUE(QUAD_INTENSITY4_SGIS);
        OGL_PUSH_VALUE(QUAD_INTENSITY8_SGIS);
        OGL_PUSH_VALUE(QUAD_LUMINANCE4_SGIS);
        OGL_PUSH_VALUE(QUAD_LUMINANCE8_SGIS);
        OGL_PUSH_VALUE(QUAD_STRIP);
        OGL_PUSH_VALUE(QUAD_TEXTURE_SELECT_SGIS);
        OGL_PUSH_VALUE(QUADRATIC_ATTENUATION);
        OGL_PUSH_VALUE(QUADS);
        OGL_PUSH_VALUE(R);
        OGL_PUSH_VALUE(R1UI_C3F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_C4F_N3F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_C4UB_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_N3F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_T2F_C4F_N3F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_T2F_N3F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_T2F_V3F_SUN);
        OGL_PUSH_VALUE(R1UI_V3F_SUN);
        OGL_PUSH_VALUE(R3_G3_B2);
        OGL_PUSH_VALUE(RASTER_POSITION_UNCLIPPED_IBM);
        OGL_PUSH_VALUE(READ_BUFFER);
        OGL_PUSH_VALUE(RECLAIM_MEMORY_HINT_PGI);
        OGL_PUSH_VALUE(RED_BIAS);
        OGL_PUSH_VALUE(RED_BITS);
        OGL_PUSH_VALUE(RED_MAX_CLAMP_INGR);
        OGL_PUSH_VALUE(RED_MIN_CLAMP_INGR);
        OGL_PUSH_VALUE(RED_SCALE);
        OGL_PUSH_VALUE(RED);
        OGL_PUSH_VALUE(REDUCE_EXT);
        OGL_PUSH_VALUE(REDUCE);
        OGL_PUSH_VALUE(REFERENCE_PLANE_EQUATION_SGIX);
        OGL_PUSH_VALUE(REFERENCE_PLANE_SGIX);
        OGL_PUSH_VALUE(REFLECTION_MAP_ARB);
        OGL_PUSH_VALUE(REFLECTION_MAP_EXT);
        OGL_PUSH_VALUE(REFLECTION_MAP_NV);
        OGL_PUSH_VALUE(REGISTER_COMBINERS_NV);
        OGL_PUSH_VALUE(RENDER_MODE);
        OGL_PUSH_VALUE(RENDER);
        OGL_PUSH_VALUE(RENDERER);
        OGL_PUSH_VALUE(REPEAT);
        OGL_PUSH_VALUE(REPLACE_EXT);
        OGL_PUSH_VALUE(REPLACE_MIDDLE_SUN);
        OGL_PUSH_VALUE(REPLACE_OLDEST_SUN);
        OGL_PUSH_VALUE(REPLACE);
        OGL_PUSH_VALUE(REPLACEMENT_CODE_ARRAY_POINTER_SUN);
        OGL_PUSH_VALUE(REPLACEMENT_CODE_ARRAY_STRIDE_SUN);
        OGL_PUSH_VALUE(REPLACEMENT_CODE_ARRAY_SUN);
        OGL_PUSH_VALUE(REPLACEMENT_CODE_ARRAY_TYPE_SUN);
        OGL_PUSH_VALUE(REPLACEMENT_CODE_SUN);
        OGL_PUSH_VALUE(REPLICATE_BORDER_HP);
        OGL_PUSH_VALUE(REPLICATE_BORDER);
        OGL_PUSH_VALUE(RESAMPLE_DECIMATE_SGIX);
        OGL_PUSH_VALUE(RESAMPLE_REPLICATE_SGIX);
        OGL_PUSH_VALUE(RESAMPLE_ZERO_FILL_SGIX);
        OGL_PUSH_VALUE(RESCALE_NORMAL_EXT);
        OGL_PUSH_VALUE(RESCALE_NORMAL);
        OGL_PUSH_VALUE(RESTART_SUN);
        OGL_PUSH_VALUE(RETURN);
        OGL_PUSH_VALUE(RGB_SCALE_EXT);
        OGL_PUSH_VALUE(RGB);
        OGL_PUSH_VALUE(RGB10_A2_EXT);
        OGL_PUSH_VALUE(RGB10_A2);
        OGL_PUSH_VALUE(RGB10_EXT);
        OGL_PUSH_VALUE(RGB10);
        OGL_PUSH_VALUE(RGB12_EXT);
        OGL_PUSH_VALUE(RGB12);
        OGL_PUSH_VALUE(RGB16_EXT);
        OGL_PUSH_VALUE(RGB16);
        OGL_PUSH_VALUE(RGB2_EXT);
        OGL_PUSH_VALUE(RGB4_EXT);
        OGL_PUSH_VALUE(RGB4);
        OGL_PUSH_VALUE(RGB5_A1_EXT);
        OGL_PUSH_VALUE(RGB5_A1);
        OGL_PUSH_VALUE(RGB5_EXT);
        OGL_PUSH_VALUE(RGB5);
        OGL_PUSH_VALUE(RGB8_EXT);
        OGL_PUSH_VALUE(RGB8);
        OGL_PUSH_VALUE(RGBA_MODE);
        OGL_PUSH_VALUE(RGBA);
        OGL_PUSH_VALUE(RGBA12_EXT);
        OGL_PUSH_VALUE(RGBA12);
        OGL_PUSH_VALUE(RGBA16_EXT);
        OGL_PUSH_VALUE(RGBA16);
        OGL_PUSH_VALUE(RGBA2_EXT);
        OGL_PUSH_VALUE(RGBA2);
        OGL_PUSH_VALUE(RGBA4_EXT);
        OGL_PUSH_VALUE(RGBA4);
        OGL_PUSH_VALUE(RGBA8_EXT);
        OGL_PUSH_VALUE(RGBA8);
        OGL_PUSH_VALUE(RIGHT);
        OGL_PUSH_VALUE(S);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_COVERAGE_ARB);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_MASK_EXT);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_MASK_SGIS);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_ONE_ARB);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_ONE_EXT);
        OGL_PUSH_VALUE(SAMPLE_ALPHA_TO_ONE_SGIS);
        OGL_PUSH_VALUE(SAMPLE_BUFFERS_3DFX);
        OGL_PUSH_VALUE(SAMPLE_BUFFERS_ARB);
        OGL_PUSH_VALUE(SAMPLE_BUFFERS_EXT);
        OGL_PUSH_VALUE(SAMPLE_BUFFERS_SGIS);
        OGL_PUSH_VALUE(SAMPLE_COVERAGE_ARB);
        OGL_PUSH_VALUE(SAMPLE_COVERAGE_INVERT_ARB);
        OGL_PUSH_VALUE(SAMPLE_COVERAGE_VALUE_ARB);
        OGL_PUSH_VALUE(SAMPLE_MASK_EXT);
        OGL_PUSH_VALUE(SAMPLE_MASK_INVERT_EXT);
        OGL_PUSH_VALUE(SAMPLE_MASK_INVERT_SGIS);
        OGL_PUSH_VALUE(SAMPLE_MASK_SGIS);
        OGL_PUSH_VALUE(SAMPLE_MASK_VALUE_EXT);
        OGL_PUSH_VALUE(SAMPLE_MASK_VALUE_SGIS);
        OGL_PUSH_VALUE(SAMPLE_PATTERN_EXT);
        OGL_PUSH_VALUE(SAMPLE_PATTERN_SGIS);
        OGL_PUSH_VALUE(SAMPLES_3DFX);
        OGL_PUSH_VALUE(SAMPLES_ARB);
        OGL_PUSH_VALUE(SAMPLES_EXT);
        OGL_PUSH_VALUE(SAMPLES_SGIS);
        OGL_PUSH_VALUE(SCALE_BY_FOUR_NV);
        OGL_PUSH_VALUE(SCALE_BY_ONE_HALF_NV);
        OGL_PUSH_VALUE(SCALE_BY_TWO_NV);
        OGL_PUSH_VALUE(SCISSOR_BIT);
        OGL_PUSH_VALUE(SCISSOR_BOX);
        OGL_PUSH_VALUE(SCISSOR_TEST);
        OGL_PUSH_VALUE(SCREEN_COORDINATES_REND);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_EXT);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_SIZE_EXT);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(SECONDARY_COLOR_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(SECONDARY_COLOR_NV);
        OGL_PUSH_VALUE(SELECT);
        OGL_PUSH_VALUE(SELECTION_BUFFER_POINTER);
        OGL_PUSH_VALUE(SELECTION_BUFFER_SIZE);
        OGL_PUSH_VALUE(SEPARABLE_2D_EXT);
        OGL_PUSH_VALUE(SEPARABLE_2D);
        OGL_PUSH_VALUE(SEPARATE_SPECULAR_COLOR_EXT);
        OGL_PUSH_VALUE(SEPARATE_SPECULAR_COLOR);
        OGL_PUSH_VALUE(SET);
        OGL_PUSH_VALUE(SHADE_MODEL);
        OGL_PUSH_VALUE(SHADOW_AMBIENT_SGIX);
        OGL_PUSH_VALUE(SHADOW_ATTENUATION_EXT);
        OGL_PUSH_VALUE(SHARED_TEXTURE_PALETTE_EXT);
        OGL_PUSH_VALUE(SHARPEN_TEXTURE_FUNC_POINTS_SGIS);
        OGL_PUSH_VALUE(SHININESS);
        OGL_PUSH_VALUE(SHORT);
        OGL_PUSH_VALUE(SIGNED_IDENTITY_NV);
        OGL_PUSH_VALUE(SIGNED_NEGATE_NV);
        OGL_PUSH_VALUE(SINGLE_COLOR_EXT);
        OGL_PUSH_VALUE(SINGLE_COLOR);
        OGL_PUSH_VALUE(SMOOTH_LINE_WIDTH_GRANULARITY);
        OGL_PUSH_VALUE(SMOOTH_LINE_WIDTH_RANGE);
        OGL_PUSH_VALUE(SMOOTH_POINT_SIZE_GRANULARITY);
        OGL_PUSH_VALUE(SMOOTH_POINT_SIZE_RANGE);
        OGL_PUSH_VALUE(SMOOTH);
        OGL_PUSH_VALUE(SOURCE0_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE0_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE1_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE1_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE2_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE2_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE3_ALPHA_NV);
        OGL_PUSH_VALUE(SOURCE3_RGB_NV);
        OGL_PUSH_VALUE(SPARE0_NV);
        OGL_PUSH_VALUE(SPARE0_PLUS_SECONDARY_COLOR_NV);
        OGL_PUSH_VALUE(SPARE1_NV);
        OGL_PUSH_VALUE(SPECULAR);
        OGL_PUSH_VALUE(SPHERE_MAP);
        OGL_PUSH_VALUE(SPOT_CUTOFF);
        OGL_PUSH_VALUE(SPOT_DIRECTION);
        OGL_PUSH_VALUE(SPOT_EXPONENT);
        OGL_PUSH_VALUE(SPRITE_AXIAL_SGIX);
        OGL_PUSH_VALUE(SPRITE_AXIS_SGIX);
        OGL_PUSH_VALUE(SPRITE_EYE_ALIGNED_SGIX);
        OGL_PUSH_VALUE(SPRITE_MODE_SGIX);
        OGL_PUSH_VALUE(SPRITE_OBJECT_ALIGNED_SGIX);
        OGL_PUSH_VALUE(SPRITE_SGIX);
        OGL_PUSH_VALUE(SPRITE_TRANSLATION_SGIX);
        OGL_PUSH_VALUE(SRC_ALPHA_SATURATE);
        OGL_PUSH_VALUE(SRC_ALPHA);
        OGL_PUSH_VALUE(SRC_COLOR);
        OGL_PUSH_VALUE(STACK_OVERFLOW);
        OGL_PUSH_VALUE(STACK_UNDERFLOW);
        OGL_PUSH_VALUE(STENCIL_BITS);
        OGL_PUSH_VALUE(STENCIL_BUFFER_BIT);
        OGL_PUSH_VALUE(STENCIL_CLEAR_VALUE);
        OGL_PUSH_VALUE(STENCIL_FAIL);
        OGL_PUSH_VALUE(STENCIL_FUNC);
        OGL_PUSH_VALUE(STENCIL_INDEX);
        OGL_PUSH_VALUE(STENCIL_PASS_DEPTH_FAIL);
        OGL_PUSH_VALUE(STENCIL_PASS_DEPTH_PASS);
        OGL_PUSH_VALUE(STENCIL_REF);
        OGL_PUSH_VALUE(STENCIL_TEST);
        OGL_PUSH_VALUE(STENCIL_VALUE_MASK);
        OGL_PUSH_VALUE(STENCIL_WRITEMASK);
        OGL_PUSH_VALUE(STENCIL);
        OGL_PUSH_VALUE(STEREO);
        OGL_PUSH_VALUE(STRICT_DEPTHFUNC_HINT_PGI);
        OGL_PUSH_VALUE(STRICT_LIGHTING_HINT_PGI);
        OGL_PUSH_VALUE(STRICT_SCISSOR_HINT_PGI);
        OGL_PUSH_VALUE(SUBPIXEL_BITS);
        OGL_PUSH_VALUE(T);
        OGL_PUSH_VALUE(T2F_C3F_V3F);
        OGL_PUSH_VALUE(T2F_C4F_N3F_V3F);
        OGL_PUSH_VALUE(T2F_C4UB_V3F);
        OGL_PUSH_VALUE(T2F_IUI_N3F_V2F_EXT);
        OGL_PUSH_VALUE(T2F_IUI_N3F_V3F_EXT);
        OGL_PUSH_VALUE(T2F_IUI_V2F_EXT);
        OGL_PUSH_VALUE(T2F_IUI_V3F_EXT);
        OGL_PUSH_VALUE(T2F_N3F_V3F);
        OGL_PUSH_VALUE(T2F_V3F);
        OGL_PUSH_VALUE(T4F_C4F_N3F_V4F);
        OGL_PUSH_VALUE(T4F_V4F);
        OGL_PUSH_VALUE(TABLE_TOO_LARGE_EXT);
        OGL_PUSH_VALUE(TABLE_TOO_LARGE);
        OGL_PUSH_VALUE(TANGENT_ARRAY_EXT);
        OGL_PUSH_VALUE(TANGENT_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(TANGENT_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(TANGENT_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(TEXCOORD1_BIT_PGI);
        OGL_PUSH_VALUE(TEXCOORD2_BIT_PGI);
        OGL_PUSH_VALUE(TEXCOORD3_BIT_PGI);
        OGL_PUSH_VALUE(TEXCOORD4_BIT_PGI);
        OGL_PUSH_VALUE(TEXTURE_1D_BINDING_EXT);
        OGL_PUSH_VALUE(TEXTURE_1D);
        OGL_PUSH_VALUE(TEXTURE_2D_BINDING_EXT);
        OGL_PUSH_VALUE(TEXTURE_2D);
        OGL_PUSH_VALUE(TEXTURE_3D_BINDING_EXT);
        OGL_PUSH_VALUE(TEXTURE_3D_EXT);
        OGL_PUSH_VALUE(TEXTURE_3D);
        OGL_PUSH_VALUE(TEXTURE_3D);
        OGL_PUSH_VALUE(TEXTURE_4D_BINDING_SGIS);
        OGL_PUSH_VALUE(TEXTURE_4D_SGIS);
        OGL_PUSH_VALUE(TEXTURE_4DSIZE_SGIS);
        OGL_PUSH_VALUE(TEXTURE_ALPHA_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_ALPHA_SIZE);
        OGL_PUSH_VALUE(TEXTURE_APPLICATION_MODE_EXT);
        OGL_PUSH_VALUE(TEXTURE_BASE_LEVEL_SGIS);
        OGL_PUSH_VALUE(TEXTURE_BASE_LEVEL);
        OGL_PUSH_VALUE(TEXTURE_BINDING_1D);
        OGL_PUSH_VALUE(TEXTURE_BINDING_2D);
        OGL_PUSH_VALUE(TEXTURE_BINDING_3D);
        OGL_PUSH_VALUE(TEXTURE_BINDING_CUBE_MAP_ARB);
        OGL_PUSH_VALUE(TEXTURE_BINDING_CUBE_MAP_EXT);
        OGL_PUSH_VALUE(TEXTURE_BIT);
        OGL_PUSH_VALUE(TEXTURE_BLUE_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_BLUE_SIZE);
        OGL_PUSH_VALUE(TEXTURE_BORDER_COLOR);
        OGL_PUSH_VALUE(TEXTURE_BORDER);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_CENTER_SGIX);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_DEPTH_SGIX);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_FRAME_SGIX);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_LOD_OFFSET_SGIX);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_OFFSET_SGIX);
        OGL_PUSH_VALUE(TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX);
        OGL_PUSH_VALUE(TEXTURE_COLOR_TABLE_SGI);
        OGL_PUSH_VALUE(TEXTURE_COLOR_WRITEMASK_SGIS);
        OGL_PUSH_VALUE(TEXTURE_COMPARE_OPERATOR_SGIX);
        OGL_PUSH_VALUE(TEXTURE_COMPARE_SGIX);
        OGL_PUSH_VALUE(TEXTURE_COMPONENTS);
        OGL_PUSH_VALUE(TEXTURE_COMPRESSED_ARB);
        OGL_PUSH_VALUE(TEXTURE_COMPRESSED_IMAGE_SIZE_ARB);
        OGL_PUSH_VALUE(TEXTURE_COMPRESSION_HINT_ARB);
        OGL_PUSH_VALUE(TEXTURE_CONSTANT_DATA_SUNX);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_POINTER);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_SIZE);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_STRIDE);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY_TYPE);
        OGL_PUSH_VALUE(TEXTURE_COORD_ARRAY);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_X_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_X_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_X_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_X_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_Y_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_Y_EXT);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_Z_ARB);
        OGL_PUSH_VALUE(TEXTURE_CUBE_MAP_POSITIVE_Z_EXT);
        OGL_PUSH_VALUE(TEXTURE_DEFORMATION_BIT_SGIX);
        OGL_PUSH_VALUE(TEXTURE_DEFORMATION_SGIX);
        OGL_PUSH_VALUE(TEXTURE_DEPTH_EXT);
        OGL_PUSH_VALUE(TEXTURE_DEPTH);
        OGL_PUSH_VALUE(TEXTURE_DEPTH);
        OGL_PUSH_VALUE(TEXTURE_ENV_BIAS_SGIX);
        OGL_PUSH_VALUE(TEXTURE_ENV_COLOR);
        OGL_PUSH_VALUE(TEXTURE_ENV_MODE);
        OGL_PUSH_VALUE(TEXTURE_ENV);
        OGL_PUSH_VALUE(TEXTURE_FILTER_CONTROL_EXT);
        OGL_PUSH_VALUE(TEXTURE_FILTER4_SIZE_SGIS);
        OGL_PUSH_VALUE(TEXTURE_GEN_MODE);
        OGL_PUSH_VALUE(TEXTURE_GEN_Q);
        OGL_PUSH_VALUE(TEXTURE_GEN_R);
        OGL_PUSH_VALUE(TEXTURE_GEN_S);
        OGL_PUSH_VALUE(TEXTURE_GEN_T);
        OGL_PUSH_VALUE(TEXTURE_GEQUAL_R_SGIX);
        OGL_PUSH_VALUE(TEXTURE_GREEN_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_GREEN_SIZE);
        OGL_PUSH_VALUE(TEXTURE_HEIGHT);
        OGL_PUSH_VALUE(TEXTURE_INDEX_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_INTENSITY_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_INTENSITY_SIZE);
        OGL_PUSH_VALUE(TEXTURE_INTERNAL_FORMAT);
        OGL_PUSH_VALUE(TEXTURE_LEQUAL_R_SGIX);
        OGL_PUSH_VALUE(TEXTURE_LIGHT_EXT);
        OGL_PUSH_VALUE(TEXTURE_LIGHTING_MODE_HP);
        OGL_PUSH_VALUE(TEXTURE_LOD_BIAS_EXT);
        OGL_PUSH_VALUE(TEXTURE_LOD_BIAS_R_SGIX);
        OGL_PUSH_VALUE(TEXTURE_LOD_BIAS_S_SGIX);
        OGL_PUSH_VALUE(TEXTURE_LOD_BIAS_T_SGIX);
        OGL_PUSH_VALUE(TEXTURE_LUMINANCE_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_LUMINANCE_SIZE);
        OGL_PUSH_VALUE(TEXTURE_MAG_FILTER);
        OGL_PUSH_VALUE(TEXTURE_MATERIAL_FACE_EXT);
        OGL_PUSH_VALUE(TEXTURE_MATERIAL_PARAMETER_EXT);
        OGL_PUSH_VALUE(TEXTURE_MATRIX);
        OGL_PUSH_VALUE(TEXTURE_MAX_ANISOTROPY_EXT);
        OGL_PUSH_VALUE(TEXTURE_MAX_LEVEL_SGIS);
        OGL_PUSH_VALUE(TEXTURE_MAX_LEVEL);
        OGL_PUSH_VALUE(TEXTURE_MAX_LOD_SGIS);
        OGL_PUSH_VALUE(TEXTURE_MAX_LOD);
        OGL_PUSH_VALUE(TEXTURE_MIN_FILTER);
        OGL_PUSH_VALUE(TEXTURE_MIN_LOD_SGIS);
        OGL_PUSH_VALUE(TEXTURE_MIN_LOD);
        OGL_PUSH_VALUE(TEXTURE_MULTI_BUFFER_HINT_SGIX);
        OGL_PUSH_VALUE(TEXTURE_NORMAL_EXT);
        OGL_PUSH_VALUE(TEXTURE_POST_SPECULAR_HP);
        OGL_PUSH_VALUE(TEXTURE_PRE_SPECULAR_HP);
        OGL_PUSH_VALUE(TEXTURE_PRIORITY_EXT);
        OGL_PUSH_VALUE(TEXTURE_PRIORITY);
        OGL_PUSH_VALUE(TEXTURE_RED_SIZE_EXT);
        OGL_PUSH_VALUE(TEXTURE_RED_SIZE);
        OGL_PUSH_VALUE(TEXTURE_RESIDENT_EXT);
        OGL_PUSH_VALUE(TEXTURE_RESIDENT);
        OGL_PUSH_VALUE(TEXTURE_STACK_DEPTH);
        OGL_PUSH_VALUE(TEXTURE_TOO_LARGE_EXT);
        OGL_PUSH_VALUE(TEXTURE_WIDTH);
        OGL_PUSH_VALUE(TEXTURE_WRAP_Q_SGIS);
        OGL_PUSH_VALUE(TEXTURE_WRAP_R_EXT);
        OGL_PUSH_VALUE(TEXTURE_WRAP_R);
        OGL_PUSH_VALUE(TEXTURE_WRAP_R);
        OGL_PUSH_VALUE(TEXTURE_WRAP_S);
        OGL_PUSH_VALUE(TEXTURE_WRAP_T);
        OGL_PUSH_VALUE(TEXTURE);
        OGL_PUSH_VALUE(TEXTURE0_ARB);
        OGL_PUSH_VALUE(TEXTURE1_ARB);
        OGL_PUSH_VALUE(TEXTURE10_ARB);
        OGL_PUSH_VALUE(TEXTURE11_ARB);
        OGL_PUSH_VALUE(TEXTURE12_ARB);
        OGL_PUSH_VALUE(TEXTURE13_ARB);
        OGL_PUSH_VALUE(TEXTURE14_ARB);
        OGL_PUSH_VALUE(TEXTURE15_ARB);
        OGL_PUSH_VALUE(TEXTURE16_ARB);
        OGL_PUSH_VALUE(TEXTURE17_ARB);
        OGL_PUSH_VALUE(TEXTURE18_ARB);
        OGL_PUSH_VALUE(TEXTURE19_ARB);
        OGL_PUSH_VALUE(TEXTURE2_ARB);
        OGL_PUSH_VALUE(TEXTURE20_ARB);
        OGL_PUSH_VALUE(TEXTURE21_ARB);
        OGL_PUSH_VALUE(TEXTURE22_ARB);
        OGL_PUSH_VALUE(TEXTURE23_ARB);
        OGL_PUSH_VALUE(TEXTURE24_ARB);
        OGL_PUSH_VALUE(TEXTURE25_ARB);
        OGL_PUSH_VALUE(TEXTURE26_ARB);
        OGL_PUSH_VALUE(TEXTURE27_ARB);
        OGL_PUSH_VALUE(TEXTURE28_ARB);
        OGL_PUSH_VALUE(TEXTURE29_ARB);
        OGL_PUSH_VALUE(TEXTURE3_ARB);
        OGL_PUSH_VALUE(TEXTURE30_ARB);
        OGL_PUSH_VALUE(TEXTURE31_ARB);
        OGL_PUSH_VALUE(TEXTURE4_ARB);
        OGL_PUSH_VALUE(TEXTURE5_ARB);
        OGL_PUSH_VALUE(TEXTURE6_ARB);
        OGL_PUSH_VALUE(TEXTURE7_ARB);
        OGL_PUSH_VALUE(TEXTURE8_ARB);
        OGL_PUSH_VALUE(TEXTURE9_ARB);
        OGL_PUSH_VALUE(TRANSFORM_BIT);
        OGL_PUSH_VALUE(TRANSFORM_HINT_APPLE);
        OGL_PUSH_VALUE(TRANSPOSE_COLOR_MATRIX_ARB);
        OGL_PUSH_VALUE(TRANSPOSE_MODELVIEW_MATRIX_ARB);
        OGL_PUSH_VALUE(TRANSPOSE_PROJECTION_MATRIX_ARB);
        OGL_PUSH_VALUE(TRANSPOSE_TEXTURE_MATRIX_ARB);
        OGL_PUSH_VALUE(TRIANGLE_FAN);
        OGL_PUSH_VALUE(TRIANGLE_LIST_SUN);
        OGL_PUSH_VALUE(TRIANGLE_STRIP);
        OGL_PUSH_VALUE(TRIANGLES);
        OGL_PUSH_VALUE(TRUE);
        OGL_PUSH_VALUE(UNPACK_ALIGNMENT);
        OGL_PUSH_VALUE(UNPACK_CMYK_HINT_EXT);
        OGL_PUSH_VALUE(UNPACK_CONSTANT_DATA_SUNX);
        OGL_PUSH_VALUE(UNPACK_IMAGE_DEPTH_SGIS);
        OGL_PUSH_VALUE(UNPACK_IMAGE_HEIGHT_EXT);
        OGL_PUSH_VALUE(UNPACK_IMAGE_HEIGHT);
        OGL_PUSH_VALUE(UNPACK_IMAGE_HEIGHT);
        OGL_PUSH_VALUE(UNPACK_LSB_FIRST);
        OGL_PUSH_VALUE(UNPACK_RESAMPLE_SGIX);
        OGL_PUSH_VALUE(UNPACK_ROW_LENGTH);
        OGL_PUSH_VALUE(UNPACK_SKIP_IMAGES_EXT);
        OGL_PUSH_VALUE(UNPACK_SKIP_IMAGES);
        OGL_PUSH_VALUE(UNPACK_SKIP_IMAGES);
        OGL_PUSH_VALUE(UNPACK_SKIP_PIXELS);
        OGL_PUSH_VALUE(UNPACK_SKIP_ROWS);
        OGL_PUSH_VALUE(UNPACK_SKIP_VOLUMES_SGIS);
        OGL_PUSH_VALUE(UNPACK_SUBSAMPLE_RATE_SGIX);
        OGL_PUSH_VALUE(UNPACK_SWAP_BYTES);
        OGL_PUSH_VALUE(UNSIGNED_BYTE_2_3_3_REV);
        OGL_PUSH_VALUE(UNSIGNED_BYTE_3_3_2_EXT);
        OGL_PUSH_VALUE(UNSIGNED_BYTE_3_3_2);
        OGL_PUSH_VALUE(UNSIGNED_BYTE);
        OGL_PUSH_VALUE(UNSIGNED_IDENTITY_NV);
        OGL_PUSH_VALUE(UNSIGNED_INT_10_10_10_2_EXT);
        OGL_PUSH_VALUE(UNSIGNED_INT_10_10_10_2);
        OGL_PUSH_VALUE(UNSIGNED_INT_2_10_10_10_REV);
        OGL_PUSH_VALUE(UNSIGNED_INT_8_8_8_8_EXT);
        OGL_PUSH_VALUE(UNSIGNED_INT_8_8_8_8_REV);
        OGL_PUSH_VALUE(UNSIGNED_INT_8_8_8_8);
        OGL_PUSH_VALUE(UNSIGNED_INT);
        OGL_PUSH_VALUE(UNSIGNED_INVERT_NV);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_1_5_5_5_REV);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_4_4_4_4_EXT);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_4_4_4_4_REV);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_4_4_4_4);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_5_5_5_1_EXT);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_5_5_5_1);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_5_6_5_REV);
        OGL_PUSH_VALUE(UNSIGNED_SHORT_5_6_5);
        OGL_PUSH_VALUE(UNSIGNED_SHORT);
        OGL_PUSH_VALUE(V2F);
        OGL_PUSH_VALUE(V3F);
        OGL_PUSH_VALUE(VARIABLE_A_NV);
        OGL_PUSH_VALUE(VARIABLE_B_NV);
        OGL_PUSH_VALUE(VARIABLE_C_NV);
        OGL_PUSH_VALUE(VARIABLE_D_NV);
        OGL_PUSH_VALUE(VARIABLE_E_NV);
        OGL_PUSH_VALUE(VARIABLE_F_NV);
        OGL_PUSH_VALUE(VARIABLE_G_NV);
        OGL_PUSH_VALUE(VENDOR);
        OGL_PUSH_VALUE(VERSION);
        OGL_PUSH_VALUE(VERTEX_ARRAY_COUNT_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_LIST_IBM);
        OGL_PUSH_VALUE(VERTEX_ARRAY_LIST_STRIDE_IBM);
        OGL_PUSH_VALUE(VERTEX_ARRAY_PARALLEL_POINTERS_INTEL);
        OGL_PUSH_VALUE(VERTEX_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_POINTER);
        OGL_PUSH_VALUE(VERTEX_ARRAY_RANGE_LENGTH_NV);
        OGL_PUSH_VALUE(VERTEX_ARRAY_RANGE_NV);
        OGL_PUSH_VALUE(VERTEX_ARRAY_RANGE_POINTER_NV);
        OGL_PUSH_VALUE(VERTEX_ARRAY_RANGE_VALID_NV);
        OGL_PUSH_VALUE(VERTEX_ARRAY_SIZE_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_SIZE);
        OGL_PUSH_VALUE(VERTEX_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_STRIDE);
        OGL_PUSH_VALUE(VERTEX_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(VERTEX_ARRAY_TYPE);
        OGL_PUSH_VALUE(VERTEX_ARRAY);
        OGL_PUSH_VALUE(VERTEX_BLEND_ARB);
        OGL_PUSH_VALUE(VERTEX_CONSISTENT_HINT_PGI);
        OGL_PUSH_VALUE(VERTEX_DATA_HINT_PGI);
        OGL_PUSH_VALUE(VERTEX_PRECLIP_HINT_SGIX);
        OGL_PUSH_VALUE(VERTEX_PRECLIP_SGIX);
        OGL_PUSH_VALUE(VERTEX_WEIGHT_ARRAY_EXT);
        OGL_PUSH_VALUE(VERTEX_WEIGHT_ARRAY_POINTER_EXT);
        OGL_PUSH_VALUE(VERTEX_WEIGHT_ARRAY_SIZE_EXT);
        OGL_PUSH_VALUE(VERTEX_WEIGHT_ARRAY_STRIDE_EXT);
        OGL_PUSH_VALUE(VERTEX_WEIGHT_ARRAY_TYPE_EXT);
        OGL_PUSH_VALUE(VERTEX_WEIGHTING_EXT);
        OGL_PUSH_VALUE(VERTEX23_BIT_PGI);
        OGL_PUSH_VALUE(VERTEX4_BIT_PGI);
        OGL_PUSH_VALUE(VIEWPORT_BIT);
        OGL_PUSH_VALUE(VIEWPORT);
        OGL_PUSH_VALUE(WEIGHT_ARRAY_ARB);
        OGL_PUSH_VALUE(WEIGHT_ARRAY_POINTER_ARB);
        OGL_PUSH_VALUE(WEIGHT_ARRAY_SIZE_ARB);
        OGL_PUSH_VALUE(WEIGHT_ARRAY_STRIDE_ARB);
        OGL_PUSH_VALUE(WEIGHT_ARRAY_TYPE_ARB);
        OGL_PUSH_VALUE(WEIGHT_SUM_UNITY_ARB);
        OGL_PUSH_VALUE(WIDE_LINE_HINT_PGI);
        OGL_PUSH_VALUE(WRAP_BORDER_SUN);
        OGL_PUSH_VALUE(XOR);
        OGL_PUSH_VALUE(YCRCB_422_SGIX);
        OGL_PUSH_VALUE(YCRCB_444_SGIX);
        OGL_PUSH_VALUE(YCRCB_SGIX);
        OGL_PUSH_VALUE(YCRCBA_SGIX);
        OGL_PUSH_VALUE(ZERO);
        OGL_PUSH_VALUE(ZOOM_X);
        OGL_PUSH_VALUE(ZOOM_Y);
#if LINUX != 1
        OGL_PUSH_VALUE(COLOR_TABLE_ALPHA_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_BLUE_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_FORMAT_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_GREEN_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_INTENSITY_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_LUMINANCE_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_RED_SIZE_EXT);
        OGL_PUSH_VALUE(COLOR_TABLE_WIDTH_EXT);
        OGL_PUSH_VALUE(DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX);
        OGL_PUSH_VALUE(DEPTH_PASS_INSTRUMENT_MAX_SGIX);
        OGL_PUSH_VALUE(DEPTH_PASS_INSTRUMENT_SGIX);
        OGL_PUSH_VALUE(FOG_SCALE_SGIX);
        OGL_PUSH_VALUE(FOG_SCALE_VALUE_SGIX);
        OGL_PUSH_VALUE(MODELVIEW_MATRIX1_EXT);
        OGL_PUSH_VALUE(OPERAND3_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND3_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND4_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND4_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND5_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND5_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND6_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND6_RGB_EXT);
        OGL_PUSH_VALUE(OPERAND7_ALPHA_EXT);
        OGL_PUSH_VALUE(OPERAND7_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE3_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE3_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE4_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE4_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE5_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE5_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE6_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE6_RGB_EXT);
        OGL_PUSH_VALUE(SOURCE7_ALPHA_EXT);
        OGL_PUSH_VALUE(SOURCE7_RGB_EXT);
#endif
    }
    js_setglobal(J, "GL");
}
