/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/unix/explode.c,v 1.1 1992/01/24 03:28:28 dvadura Exp $
-- SYNOPSIS -- Routines to explode dag if .SETDIR targets present.
-- 
-- DESCRIPTION
--	These routines are called by parallel dmake implementations to
--	explode the dmake DAG at .SETDIR targets so that parallel makes
--	can traverse common portions of the DAG in parallel.
-- 
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log: explode.c,v $
 * Revision 1.1  1992/01/24  03:28:28  dvadura
 * dmake Version 3.8, Initial revision
 *
*/

#include "extern.h"
#include "alloc.h"
#include "db.h"

CELLPTR
Explode_cell( cp, dir )
CELLPTR cp;
CELLPTR dir;
{
   int explode = FALSE;
   CELLPTR root;
   CELLPTR tcp;
   CELLPTR ocp;
   HOWPTR  fhow = NIL(HOW);


   if( cp == NIL(CELL) ) return(cp);

   ocp = cp;
   if( (root = cp->ce_name->CP_ROOT) != dir ) {
      if( cp->ce_name->CP_ROOT != NIL(CELL) ) {
	 HASHPTR name;

	 tcp  = Def_cell(cp->CE_NAME, dir);
	 name = tcp->ce_name;
	 *tcp = *cp;
	 tcp->ce_name = name;

	 cp = tcp;
	 explode = TRUE;
      }
   }
   else if( root && root == dir )
      return( cp );

   /* The code here is required, as it takes care of the .UPDATEALL common
    * targets. */
   tcp = cp;
   do {
      tcp->ce_name->CP_ROOT = dir;

      if( tcp->CE_HOW != fhow ) {
	 tcp->CE_HOW = Explode_how( tcp->CE_HOW, cp->ce_dir?cp:dir, explode );
	 if( tcp == cp ) fhow = tcp->CE_HOW;
      }

      if( explode && tcp->ce_all )
         if( tcp->ce_all != ocp ) {
	    CELLPTR ttcp = Def_cell( tcp->ce_all->CE_NAME, dir );
	    HASHPTR name = ttcp->ce_name;

	    *ttcp = *tcp->ce_all;
	    ttcp->ce_name = name;
	    tcp->ce_all   = ttcp;
	    ttcp->CE_HOW  = fhow;
	 }
	 else
	    tcp->ce_all = cp;

      tcp = tcp->ce_all;
   }
   while( tcp != NIL(CELL) && tcp != cp );

   return( cp );
}


HOWPTR
Explode_how( how, dir, copy )
HOWPTR  how;
CELLPTR dir;
int     copy;
{
   if( how == NIL(HOW) ) return( how );

   if( copy ) {
      HOWPTR thow;

      TALLOC( thow, 1, HOW );
      *thow = *how;
      how = thow;
   }

   how->hw_next = Explode_how( how->hw_next, dir, copy );
   how->hw_prq  = Explode_prq( how->hw_prq, dir, copy );

   return( how );
}


LINKPTR
Explode_prq( prq, dir, copy )
LINKPTR prq;
CELLPTR dir;
int     copy;
{
   if( prq == NIL(LINK) ) return(prq);

   if( copy ) {
      LINKPTR tprq;

      TALLOC( tprq, 1, LINK );
      *tprq = *prq;
      prq = tprq;
   }

   prq->cl_next = Explode_prq( prq->cl_next, dir, copy );
   prq->cl_prq  = Explode_cell( prq->cl_prq, dir );

   return( prq );
}
