/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _ABORT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void _abort(char *msg)

	Display the string onto stderr, then terminate the program with the
	standard exit code using the exit() function.

	Input:
		msg may be NULL

	Return:
		will never return

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		abort, exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/01/29 07:10:07  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <process.h>
#include <stdio.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _ABORT.C 1.3 1998/01/29 07:10:07 ska Exp $";
#endif

_CLibFunc void _abort(char const * const msg)
{	if(msg) fputs(msg, stderr);
	exit(_ABORT_STD_EXITCODE);
}
