/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ABORT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void abort(void)

	Display the standard "abnormal program termination" message
	and terminates the program with the standard error exit code.

	Input:
		<none>

	Return:
		will never return

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		_abort, exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:09:10  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_errstr.h>
#include <process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ABORT.C 1.1 1997/10/13 07:09:10 ska Exp $";
#endif

_CLibFunc void abort(void)
{	_abort(ERR_abort);
}
