/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _LTOA.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *_ltoa(long value, char_t *buf, int radix)

	Convert a (long int) value into a string.
	If radix == 10 && value < 0, the string is prefixed by '-'.
	buf must be large enough to hold the string, a maximum of
	(sizeof(long) * 8 + 1) characters can be generated by this
	function.

	Input:
		2 <= radix <= 36
		buf != NULL

	Return:
		buf

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_ultoa, itoa

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:40  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <stdlib.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _LTOA.C 1.1 1997/11/18 04:24:40 ska Exp $";
#endif

_CLibFunc char_t *
_ltoa(long value
	, char_t * const buf
	, const int radix)
{	assert(2 <= radix && radix <= 36);
	assert(buf != NULL);

	if(radix == 10 && value < 0) {
		*buf = '-';
		_ultoa(-value, buf + 1, radix);
		return buf;
	}

	return _ultoa(value, buf, radix);
}
