/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRSTR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strtsr(char_t *str, char_t *substr)

	Search for substr within str.

	Input:
		str != NULL
		substr != NULL

	Return:
		NULL if substr is no part of str
		str if substr == ""
		pointer to first appearance of substr in str, otherwise

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		strchr

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRSTR.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

/* We iterate using strchr() to find the first character of substr
	then verify the remaining characters of substr via memcmp */
_CLibFunc char_t ___PTR *strstr(REG char_t const ___PTR * str
 , char_t const ___PTR * const substr)
{	REG size_t length;		/* of substr */

	assert(str != NULL);
	assert(substr != NULL);

	/* Handle the special cases */
	if((length = strlen(substr)) == 0)
		return (char_t ___PTR *)str;
	if(length == 1)
		return strchr(str, *substr);

	--str;
	while((str = strchr(str + 1, *substr)) != NULL)
		if(memcmp(str, substr, length) == 0)
			return (char_t ___PTR *)str;

	return NULL;
}
