/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRCHR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strchr(char_t *str, int ch)

	Return the pointer to the first character ch in the string str.

	Input:
		str != NULL

	Return:
		NULL if (char_t)ch not in str
		pointer to first appearance, otherwise

	Note:
		The string is treated unsigned and ch is used (ch & 0xFF)

	Conforms to:
		ANSI C

	See also:

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRCHR.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strchr(char_t const ___PTR * s, const int ch)
{	REG unsigned c;

	assert(s != NULL);

	while((c = *(uchar_t const ___PTR *)s++) != (uchar_t)ch)
		if(!c) return NULL;

	return (char_t ___PTR *)s - 1;
}
