/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _TODIGIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int __todigit(int ch)

	Is equal to _todigit() free of side-effects.
	_todigit() returns the digit of the supplied character. ch may
	range from '0'..'9','A'..'Z','a'..'z', where _todigit() returns:
		'0' -> 0, '1' -> 1, ..., '9' -> 9,
		'A' -> 10, 'B' -> 11, ..., 'Z' -> 35,
		'a' -> 10, 'b' -> 11, ..., 'z' -> 35

	Input:
		isalnum(ch)

	Return:
		digit to represent the character

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_tochar

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:56  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <ctype.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _TODIGIT.C 1.1 1997/11/18 04:24:56 ska Exp $";
#endif

_CLibFunc int
__todigit(int ch)
{	assert(isalnum(ch));

	return isdigit(ch)? ch - '0': toupper(ch) - 'A' + 10;
}
