/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ISATTY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int isatty(int fd)

	Check if the file descriptor describes a TTY.

	Under DOS a TTY must match two conditions:
		1) it's a device,
		2) it's opened in cooked mode.

	Input:
		<none>

	Return:
		0: if fd is not opened or is no TTY
		else: otherwise

	Note:
		Under DOS one cannot assume that the fd is really connected
		to an interactive console.

	Conforms to:
		POSIX

	See also:

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:50  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ISATTY.C 1.1 1997/11/18 04:24:50 ska Exp $";
#endif

_CLibFunc int
isatty(int fd)
{	REG int mode;

	return !((mode = ioctl(fd, 0)) == -1		/* call failed -> no TTY */
	 		/* no device or in raw mode */
	 || (mode & ((1U << 15) | (1 << 5))) != (1U << 15));
}
