/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: IO.H 1.3 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	handle base IO functions

*/

#ifndef __IO_H
#define __IO_H

#include <stddef.h>

/*
 *	Constants for the 'whence' parameter of lseek()
 *	Value to be returned of failure of offset related functions
 */
#include <_seek.h>

/*
 *	Read / write mode condition for _rw()
 */
#define _READ_HANDLE 0x3F00
#define _WRITE_HANDLE 0x4000

/*
 *	IO error return value
 */
#define _IO_err ((size_t)-1)

/**SKIP**/
/*********** for testing purpose ************/
#ifndef _IN_OPEN
extern _CLibFunc int open(char const * const fnam, int mode, ...);
#define open __xxopen
#endif
#ifndef _IN_IOCTL
extern _CLibFunc int ioctl(int fd, int fct, ...);
#define ioctl __xxioctl
#endif
/*********** end for testing purpose ************/
/**NOSKIP**/

#include "..\\io\\prototyp"			/**EXPAND**/

/**SKIP**/
/*********** for testing purpose ************/
#undef open
#undef ioctl
/*********** end for testing purpose ************/
/**NOSKIP**/

#endif
