/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: FCNTL.H 1.1 1997/10/13 07:06:43 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	File control macros.

*/

#ifndef __FCNTL_H
#define __FCNTL_H

/********** open() modes */
/* mode requires exactly one of the following access flags: */
#define O_RDONLY		0x0000	/* open for read only */
#define O_WRONLY		0x0001	/* open for write only */
#define O_RDWR			0x0002	/* open for read & write */
#define O_SNOOP			0x0004	/* open for read only, but don't update last access time (Win95 only) */

/* mode may have none or one of the following share flags <DOS/Win95 only>: */
#define O_DENAYALL		0x0010	/* deny read & write access */
#define O_DENYWRITE		0x0020	/* deny write access only (default) */
#define O_DENYREAD		0x0030	/* deny read access only */
#define O_DENYNONE		0x0040	/* deny neither read nor write access */
#define O_DENYCOMP		0x0060	/* compatibly mode, O_DENYALL and cause Critical Error for other process */

/* options */
#define O_APPEND		0x0008	/* seek to end of file */
#define O_NOINHERIT		0x0080	/* don't pass handle to child */
#define O_UNBUFFERED 	0x0100	/* don't buffer (Win95 only, read/write in multiples of native size of volume) */
#define O_NOCOMPRESS	0x0200	/* don't compress if volume would (Win95 only) */
#define O_CREAT			0x0400	/* create file if not already exists */
#define O_EXCL			0x0800	/* if O_CREAT is set, but file exists, open() fails */
#define O_TRUNC			0x1000	/* overwrite file, truncate to zero length */
#define O_AUTOFAIL		0x2000	/* don't call Critical Error handler, just fail system call <DOS/Win95 only> */
#define O_AUTOCOMMIT	0x4000	/* flush system's buffer after each write <DOS/Win95 only> */
#define O_TEXT			0x8000	/* open in text mode <currently ignored> */
#define O_BINARY		0x0000	/* open in binary mode <currently ignored> (default) */
#define O_NDELAY		0x0000	/* don't delay, immediate return failure <ignored> */
	
#endif
