/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _STKLEN.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	unsigned _stklen

	Number of bytes to be reserved for the stack minimally.
	The local heap is part of the stack.

	_stklen cannot fall below HEAP_MARGAIN (currently 512 bytes).

	After the program's startup code has been executed, _stklen
	contains the length of the stack the startup code has installed.

	Input:
		<none>

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		<none>

	See also:

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>

#ifdef _IN_ALLOC == 0		/* we need this only once */

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _STKLEN.C 1.2 1998/02/11 07:40:34 ska Exp ska $";
#endif

_CLibVar unsigned _stklen = 2048;

#endif 
