/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _HPASPLI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void _heapalgnsplt(_heapNode *node, size_t size)

	As _heapsplit() but performs a check of alignment first,
	thus, the size parameter is modified so that the next
	node's data area falls onto an alignment boundary.

	If size becomes greater than node->length, no split
	is performed at all.

	Input:
		node != NULL; a valid node

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_heapsplit

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _HPASPLI.C 1.3 1998/02/11 07:40:34 ska Exp ska $";
#endif

#if __HEAP_ALIGN		/* Used only if alignment is active */

_CLibFunc void
_heapalgnsplt(_pHeapNode node, size_t size)
{	REG size_t size2;

	assert(node != NULL);

	size2 = padNode(size, nodeData(node));
	if(size2 < nodeLength(node))
		_heapsplit(node, size2);
}

#endif	/* __HEAP_ALIGN */
