/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: DBGFREE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int dbgHeapFreeCh

	Character that fills free()'ed dynamic memory if DEBUG_HEAP was
	defined while making the library.

	Default: 0xE5

	If zero (0, NUL, '\0'), no filling takes place.

	Input:
		<none>

	Return:
		<none>

	Note:
		Only available if DEBUG_HEAP was specified at compile time.

	Conforms to:
		<none>

	See also:
		free, realloc

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 05:43:32  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DBGFREE.C 1.1 1997/10/27 05:43:32 ska Exp $";
#endif

#ifdef DEBUG_HEAP
_CLibVar int dbgHeapFreeCh = 0xE5;
#endif
