/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: UNGETC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int ungetc(int c, FILE *fp)

	Put a character into a input stream to be read next.

	One character can be definitly ungetc()'ed.

	Input:
		fp != NULL, a valid FILE pointer

	Return:
		EOF: on error || c == EOF
		0..UCHAR_MAX: on success (c)

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		fgetc, fputc

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: UNGETC.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc int
ungetc(int c, FILE *fp)
{
	assert(fp != NULL);

	if(c == EOF)
		return EOF;

   if (fp->mode & __MODE_WRITING)
      fflush(fp);

   /* Can't read or there's been an error then return EOF */
   if ((fp->mode & (__MODE_READ | __MODE_ERR)) != __MODE_READ)
      return EOF;

   /* Can't do fast fseeks */
   fp->mode |= __MODE_UNGOT;

   if( fp->bufpos > fp->bufstart )
      return *--fp->bufpos = (unsigned char) c;
   else if( fp->bufread == fp->bufstart )
      return *fp->bufread++ = (unsigned char) c;

  return EOF;
}
