/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: TIMELFN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _lfnftime(word ftime, word fdate, qword lfntime)

	Transforms DOS-style file time/date into the LFN file time.
	The hundredth are assumed to be 0 (zero).

	Input:
		<none>

	Return:
		0: on success
		else: OS error code

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		findfirst, _dosftime

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dir.h>
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: TIMELFN.C 1.1 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
_lfnftime(word ftime
	, word fdate
	, qword lfntime)
{	struct REGPACK r;

	r.r_ax = 0x71A7;
	r.r_bx = 1;			/* hundredth := 0 */
	r.r_cx = ftime;
	r.r_dx = fdate;
	r.r_es = FP_SEG(lfntime);
	r.r_di = FP_OFF(lfntime);

	return _callDOS(&r);
}
