/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CHDIR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int chdir(char *pnam)

	Change directory.

	Input:
		pnam != NULL

	Return:
		0: on success
		else: on failure

	Note:
		Support LFN

	Conforms to:
		Posix

	See also:
		chdir, rmdir

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dir.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CHDIR.C 1.2 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
chdir(char const * const pnam)
{	assert(pnam != NULL);
	/*	Problem:	chdir("a:\\dir")
		DOS style: does not change drive
		Posix: change directory
		BUT: If a: != current disk ==> DOS style does not change
			the _current working_ directory!
								- 1997/09/03 ska*/
	return __dirAPI(0x3B, pnam);
}
