/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: _STRING.H 1.3 1998/02/11 07:40:44 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	Standard include for the string/memory functions

*/

#ifndef ___STRING_H
#define ___STRING_H

#include <stddef.h>

#include <string.h>
#include <values.h>

#include <assert.h>	/* all CLib functions support checking of prerequistes */

#ifdef ___PTR	/* this macro provides re-useability of the code */
#undef ___PTR	/* for various pointer types */
#endif
#define ___PTR	/* default: all pointers default to (char*) or (void*) */

#define NUL '\0'	/* string end character / terminator byte of C string */

extern char_t _CLibFunc *_strend(char_t const * const str);
extern size_t _CLibFunc _strnlen(char_t const * const str, size_t length);

#endif
