#
# Makefile for the FreeDOS C Library
# Common definitions for all makefiles
#

# Assume we are being included by a sub-directory

# Make definitions
include ..\make.mak

# Shell definitions
include ..\shell.mak

# Definitions
include ..\defines.mak

# Compiler definitions
include ..\compiler.mak

# Assembler definitions
include ..\assemble.mak

# Archiver / Librarian definitions
include ..\archive.mak

# Random definitions that make modifying the
# makefile slightly easier

# Copy program
CP=copy


# Implicit rules
# 'Old style' suffix rules. Easy to do, widely implemented.

# Convert .c -> .obj - sample invocations follow
# as for Convert .asm -> .obj - sample invocations follow
# For borland: bcc -c $(CFLAGS) -o$@ $<
#
.c.obj:
	$(CC) -c $(CFLAGS) $(CCOUTPUT) $<

.asm.obj:
	$(AS) $(ASFLAGS) $(ASDEFINE)$(ASM_MODEL) $< $(ASOBJ) $(ASLST) $(ASCRF)

