@ECHO OFF
REM
REM  cabextract/dos/test.in/dirp.bat: Unit tests for DOS.
REM

IF "%CABDIR%"==""   GOTO ERROR_CABDIR
IF "%CABEXT%"==""   GOTO ERROR_CABEXT
IF "%TEST_IN%"==""  GOTO ERROR_TEST_IN
IF "%TEST_OUT%"=="" GOTO ERROR_TEST_OUT

SET TEST_CAB=%CABDIR%\dir.cab
SET RESULT=%TEST_OUT%\dir.result

IF EXIST %RESULT% DEL %RESULT%

:TEST23
SET TEST=test23-dir-absolute-path
ECHO [33m%TEST%[0m
%CABEXT% --directory %TEST_OUT%\%TEST% %TEST_CAB%
SET TEST_RESULT=PASS
IF NOT EXIST %TEST_OUT%\%TEST%\PLAIN.C SET TEST_RESULT=FAIL
IF NOT EXIST %TEST_OUT%\%TEST%\1\2\3\4.C SET TEST_RESULT=FAIL
DELTREE /Y %TEST_OUT%\%TEST%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST24
SET TEST=test24-dir-current-path
ECHO [33m%TEST%[0m
MD %TEST_OUT%\%TEST%
PUSHD %TEST_OUT%\%TEST%
%CABEXT% %TEST_CAB%
SET TEST_RESULT=PASS
IF NOT EXIST PLAIN.C SET TEST_RESULT=FAIL
IF NOT EXIST 1\2\3\4.C SET TEST_RESULT=FAIL
POPD
DELTREE /Y %TEST_OUT%\%TEST%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST25
SET TEST=test25-dir-onedeep-relative-path
ECHO [33m%TEST%[0m
%CABEXT% --directory %TEST% %TEST_CAB%
SET TEST_RESULT=PASS
IF NOT EXIST %TEST%\PLAIN.C SET TEST_RESULT=FAIL
IF NOT EXIST %TEST%\1\2\3\4.C SET TEST_RESULT=FAIL
DELTREE /Y %TEST%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST26
SET TEST=test26-dir-twodeep-relative-path
ECHO [33m%TEST%[0m
%CABEXT% --directory %TEST%\%TEST% %TEST_CAB%
SET TEST_RESULT=PASS
IF NOT EXIST %TEST%\%TEST%\PLAIN.C SET TEST_RESULT=FAIL
IF NOT EXIST %TEST%\%TEST%\1\2\3\4.C SET TEST_RESULT=FAIL
DELTREE /Y %TEST%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST27
SET TEST=test27-dir-existing-relative-path
ECHO [33m%TEST%[0m
MD %TEST%
%CABEXT% --directory %TEST% %TEST_CAB%
SET TEST_RESULT=PASS
IF NOT EXIST %TEST%\PLAIN.C SET TEST_RESULT=FAIL
IF NOT EXIST %TEST%\1\2\3\4.C SET TEST_RESULT=FAIL
DELTREE /Y %TEST%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

GOTO END

:ERROR_CABDIR
ECHO ERROR: %%CABDIR%% is not set.
GOTO END

:ERROR_CABEXT
ECHO ERROR: %%CABEXT%% is not set.
GOTO END

:ERROR_TEST_IN
ECHO ERROR: %%TEST_IN%% is not set.
GOTO END

:ERROR_TEST_OUT
ECHO ERROR: %%TEST_OUT%% is not set.
GOTO END

:END
SET TEST=
SET TEST_CAB=
SET TEST_RESULT=
SET RESULT=
