@ECHO OFF
REM
REM  cabextract/dos/test.in/bugs.bat: Unit tests for DOS.
REM

IF "%CABDIR%"==""   GOTO ERROR_CABDIR
IF "%CABEXT%"==""   GOTO ERROR_CABEXT
IF "%TEST_IN%"==""  GOTO ERROR_TEST_IN
IF "%TEST_OUT%"=="" GOTO ERROR_TEST_OUT

SET RESULT=%TEST_OUT%\bugs.result
IF EXIST %RESULT% DEL %RESULT%

IF NOT EXIST %CABDIR%\..\BUGS\NUL GOTO END
PUSHD %CABDIR%\..\BUGS

:TEST01
SET TEST_CAB=cve-2010-2800-mszip-infinite-loop.cab
SET TEST=test01-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST02
REM  Recent cabext builds can unpack this file.
REM  Notice the errorlevel check for this test.
SET TEST_CAB=cve-2010-2801-qtm-flush.cab
SET TEST=test02-bugs-%TEST_CAB%
SET TEST_RESULT=PASS
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 1 SET TEST_RESULT=FAIL
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST03
SET TEST_CAB=cve-2014-9556-qtm-infinite-loop.cab
SET TEST=test03-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST04
SET TEST_CAB=cve-2014-9732-folders-segfault.cab
SET TEST=test04-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST05
SET TEST_CAB=cve-2015-4470-mszip-over-read.cab
SET TEST=test05-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST06
SET TEST_CAB=cve-2015-4471-lzx-under-read.cab
SET TEST=test06-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST07
SET TEST_CAB=filename-read-violation-1.cab
SET TEST=test07-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST08
SET TEST_CAB=filename-read-violation-2.cab
SET TEST=test08-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST09
SET TEST_CAB=filename-read-violation-3.cab
SET TEST=test09-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST10
SET TEST_CAB=filename-read-violation-4.cab
SET TEST=test10-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST11
SET TEST_CAB=lzx-main-tree-no-lengths.cab
SET TEST=test11-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST12
SET TEST_CAB=lzx-premature-matches.cab
SET TEST=test12-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

:TEST13
SET TEST_CAB=qtm-max-size-block.cab
SET TEST=test13-bugs-%TEST_CAB%
SET TEST_RESULT=FAIL
ECHO [33m%TEST%[0m
%CABEXT% --test %TEST_CAB%
IF ERRORLEVEL 2 SET TEST_RESULT=PASS
ECHO %TEST%:%TEST_RESULT% >>%RESULT%

POPD
GOTO END

:ERROR_CABDIR
ECHO ERROR: %%CABDIR%% is not set.
GOTO END

:ERROR_CABEXT
ECHO ERROR: %%CABEXT%% is not set.
GOTO END

:ERROR_TEST_IN
ECHO ERROR: %%TEST_IN%% is not set.
GOTO END

:ERROR_TEST_OUT
ECHO ERROR: %%TEST_OUT%% is not set.
GOTO END

:END
SET TEST=
SET TEST_CAB=
SET TEST_RESULT=
SET RESULT=
