unit Tools1;

Interface
  uses Yd, Crt, Windows, Mouse, DOS, MMenus;
Type
  ErrorType = record
     ErrorCode : Integer;
     ErrorStr  : String;
  End;
var
  RBk, RC : Byte;
  MsgColor, MaxMsgMusic : Byte;

Type
  MsgStyle = (Good, Bad, Normal, Non);

Const
  ScrlMovErr : ErrorType = (ErrorCode : 2;
                            ErrorStr : 'Scroll move error.');

Type
YScroll = object
  Buffer    : Array[1..20] of String;
  WFile     : String; {Words File}
  FromPos,
  ToPos     : Byte;
  ScrLines  : Byte;
  Saman     : Byte;
  X, Y      : Byte;
  FLines    : Longint;
  Result    : String;
  CanMovDn,
  CanMovUp  : Boolean;
  Procedure Init(PX, PY, PScrLines : Byte; SFile : String);
  Procedure LoadToBuffer(From_Where : Longint);
  Procedure MoveBuffer(UpDown : Boolean; How_Much : Byte);
  Procedure MoveSaman(UpDown : Boolean; How_Much : Byte);
  Procedure DispScreen;
  Procedure ClearScreen;
  Procedure Play;
End;


Procedure YRead2(var S:String; Max:Integer; Sade, Pas:Boolean);

Type
  PasswordBox = Object {2.4.97}
  W : Win;
  X, Y, Color, BColor : Byte;
  Pasw : String;
  Procedure Init(PX, PY, PColor, PBColor : Byte; PPasw : String);
  Procedure Lock;
End;

Procedure Message(X, Y, Color, BkColor : Byte;
                        Msg : String; D : Integer);  {3.4.97}


Procedure PutMsg(Msg : String;Style:MsgStyle);


Procedure LitleFont;


Procedure WHeb(var C: Char);


Procedure WHebStr(var S : String);


Procedure StrNegative(var S : String);


Procedure Display(S:String);


Procedure Display2(S:String);


Procedure Read2(var S:String; Max:Integer);


Procedure WWHeb(FName : String);

Function ClearNum(Num : LongInt) : String;

Procedure SendError(ErrorCode : Integer; ErrorStr : String);

Procedure SendErrorType(Error : ErrorType);

Function YGetDir : String;

Function OpenDialog(What_Kind : String) : String;

Function SaveDialog(What_Kind, Default : String) : String;

Function YMessage(Msg : String) : Boolean;

Function StrSpace(Len : Byte) : String;

Function DistanceXY(x1,y1,x2,y2 :integer) : integer;

Type
  Str1 = record
  S : String;
  X, Y : Byte;
End;

Type
  WinType = record
  X, Y, X1, Y1 : Byte;
  Color, Fill : Byte;
  Title  : String;
  Style  : BStyle;
End;

Const
  MemoryError : ErrorType = (ErrorCode : 1; ErrorStr : 'Not enought memory.');
  FileOpenError : ErrorType = (ErrorCode : 2; ErrorStr : 'Cannot open file.');


Type
  Desktop = Object {3.4.97}
  Windows : Array [1..20] of WinType;
  St      : Array [1..30] of Str1;
  WFile   : file of WinType;
  SFile   : file of Str1;
  CountW  : Byte;
  CountS  : Byte;
  IX      : Boolean;
  DBack   : Byte;
  Procedure Reset_Desk;

  Procedure Add_Window(X1, Y1, X2, Y2, Col, BCol : Byte;
                              Title : String; Style1 : BStyle);
  Procedure Add_Str(X, Y : Byte; S : String);

  Procedure Display_Desktop;

  Procedure Erase_Last_Window;

  Procedure Erase_Last_Str;

  Procedure Done;
End;

Procedure DMessage(X, Y, Color, BkColor : Byte; Msg : String; D : Integer;
                    var DD : Desktop);

Implementation
Procedure YRead2(var S:String; Max:Integer; Sade, Pas:Boolean);
var
  Ch    : Char;
  OK    : Boolean;
  C,I   : Integer;
  SX,SY : Integer;
  Str   : String;
Begin
   if Sade then
   Begin
      Write('[');
      Sx := WhereX;
      Sy := WhereY;
      for I := 1 to Max do Write('.');
      Write(']');
      GoToXY(Sx,Sy);
   End;
   if Pas then
   Begin
      Sx := WhereX;
      Sy := WhereY;
      for I := 1 to Max do Write('');
      GoToXY(Sx,Sy);
   End;
   C := Length(S);
   Str := S;
   Write(Str);
   repeat
     OK := True;
     Ch := ReadKey;
     if (Ch = Enter_Key) or (Ch = #0) or (Ch = Esc_Key)
           or (Ch = BackSpace) then OK := False;
     if Ch = #0 then
     Begin
        Ch := ReadKey;
        Ch := ' ';
     End;
     if (OK) and (C < Max) then
     Begin
        if Pas then
        Begin
           Write('*');
           Beep(700,100,0);
        End
       else Write(Ch);
        C := C + 1;
        Str := Str + Ch;
     End;
     if (Ch = BackSpace) and (C > 0) then
     Begin
        GoToXY(WhereX-1,WhereY);
        if (Sade) and (Not Pas) then Write('.')
       else if (Pas) then Write('')
       else Write(' ');
        GoToXY(WhereX-1,WhereY);
        C := C - 1;
        Delete(Str,Length(Str),1);
        if Pas then Beep(700,100,0);
     End;
   until Ch = Enter_Key;
   S := Str;
End;

Procedure PasswordBox.Init(PX, PY, PColor, PBColor : Byte; PPasw : String);
Begin
   X := PX;
   Y := PY;
   Color := PColor;
   BColor := PBColor;
   Pasw := PPasw;
End;

Procedure PasswordBox.Lock;
var
 P: String;
Begin
   P := '';
   W.Init(X, Y, X+Length(Pasw)+Length('Password: ')+3,Y+2,Color, BColor,
               '',Double);
   While P <> Pasw do
   Begin
      P := '';
      W.Draw;
      GoToXY(1,1);
      Write('Password: ');
      YRead2(P, Length(Pasw), False, True);
   End;
   W.Erase;
End;
Procedure Message(X, Y, Color, BkColor : Byte; Msg : String; D : Integer);
var
 W : Win;
Begin
   W.Init(X, Y, X+Length(Msg)+3, Y+2, Color, BkColor,'', Double);
   W.Draw;
   GoToXY(1,1);
   Write(' ' + Msg);
   if D > 0 then
   Begin
      Delay(D);
      W.Erase;
   End;
End;

Procedure DMessage(X, Y, Color, BkColor : Byte; Msg : String; D : Integer;
                       var DD: Desktop);
Begin
   DD.Add_Window(X, Y, X+Length(Msg)+3, Y+2, Color, BkColor,'', Double);
   DD.Display_Desktop;
   GoToXY(X+1,Y+1);
   Write(' ' + Msg);
   if D > 0 then
   Begin
      Delay(D);
      DD.Erase_Last_Window;
   End;
End;

Procedure Desktop.Add_Window(X1, Y1, X2, Y2, Col, BCol : Byte;
                                   Title : String; Style1 : BStyle);
{var
 {Tmp : File of WinType;
 TT  : WinType;     }
Begin
 {  Assign(WFile, 'windows.dsk');
   if Exist('windows.dsk') then
   Begin
      CopyF('windows.dsk','tmp.tmp');
      Rewrite(WFile);
      Assign(Tmp, 'tmp.tmp');
      Reset(Tmp);
      while not eof(Tmp) do
      Begin
         Read(Tmp, TT);
         Write(WFile, TT);
      End;
      Erase(Tmp);
   End
  else Rewrite(Wfile);   }
   if CountW < 20 then
   Begin
      CountW := CountW + 1;
      Windows[CountW].X := X1;
      Windows[CountW].X1 := X2;
      Windows[CountW].Y := Y1;
      Windows[CountW].Y1 := Y2;
      Windows[CountW].Color := Col;
      Windows[CountW].Fill := BCol;
      Windows[CountW].Title := Title;
      Windows[CountW].Style := Style1;
   End
  else
   Begin
      ClrScr;
      Writeln('Desktop: Stack overfolw error!');
      Halt;
   End;
  { Write(WFile, Windows);
   Close(Wfile);      }
End;

Procedure Desktop.Add_Str(X, Y : Byte; S : String);
{var
 Tmp : file of Str1;
 TT  : Str1; }
Begin
   {Assign(SFile, 'str.dsk');
   if Exist('str.dsk') then
   Begin
      CopyF('str.dsk','tmp.tmp');
      Rewrite(SFile);
      Assign(Tmp, 'tmp.tmp');
      Reset(Tmp);
      while not eof(Tmp) do
      Begin
         Read(Tmp, TT);
         Write(SFile, TT);
      End;
      Erase(Tmp);
   End
  else Rewrite(Sfile); }
   Inc(CountS);
   St[CountS].X := X;
   St[CountS].Y := Y;
   St[CountS].S := S;
   {Write(Sfile, St);
   Close(SFile);    }
End;

Procedure Desktop.Display_Desktop;
var
 I : Byte;
 W : Win;
Begin
     TextBackground(DBack);
     ClrScr;
     if CountW > 0 then for I := 1 to CountW do
     Begin
         W.Init(Windows[I].X,Windows[I].Y,Windows[I].X1,Windows[I].Y1,
                 Windows[I].Color,Windows[I].Fill,Windows[I].Title,
                           Windows[I].Style);
         W.Draw;
         Window(1,1,80,25);
         if IX then
         Begin
            GoToXY(Windows[I].X+3, Windows[i].Y);
            DispStr('[~~]');
         End
     End;
     for I := 1 to CountS do
     Begin
         GoToXY(St[I].X,St[I].Y);
         Write(St[I].S);
     End;

    End;

Procedure Desktop.Reset_Desk;
Begin
   CountW := 0;
   CountS := 0;
   {Assign(WFile, 'windows.dsk');
   Assign(Sfile, 'str.dsk');
   if Exist('windows.dsk') then Erase(WFile);
   if Exist('str.dsk') then Erase(Sfile);}
End;

Procedure Desktop.Erase_Last_Window;
{var
 Tmp : file of WinType;
 TT  : WinType;
 I   : Integer;}
Begin
   if CountW > 0 then
   Begin
      {Assign(WFile, 'windows.dsk');
      if Exist('windows.dsk') then
      Begin
         CopyF('windows.dsk','tmp.tmp');
         Rewrite(WFile);
         Assign(Tmp, 'tmp.tmp');
         Reset(Tmp);
         For I := 1 to CountW - 1 do
         Begin
            Read(Tmp, TT);
            Write(WFile, TT);
         End;
         Erase(Tmp);
         Close(WFile);
      End;   }
      CountW := CountW - 1;
      Display_Desktop;
   End
  else
   Begin
      ClrScr;
      Writeln('Desktop: Stack empty error!');
   End;
End;
Procedure Desktop.Erase_Last_Str;
{var
 Tmp : file of Str1;
 TT  : Str1;
 I   : Integer;}
Begin
   if CountS > 0 then
   Begin
      {CopyF('str.dsk','tmp.tmp');
      Rewrite(SFile);
      Assign(Tmp, 'tmp.tmp');
      Reset(Tmp);
      for I := 1 to CountS - 1 do
      Begin
         Read(Tmp, TT);
         Write(SFile, TT);
      End;
      Erase(Tmp);
      Close(SFile);  }
      CountS := CountS - 1;
      Display_Desktop;
   End;
End;

Procedure Desktop.Done;
Begin
   if Exist('windows.dsk') then Erase(WFile);
   if Exist('str.dsk') then Erase(Sfile);
End;


Procedure LitleFont;
Begin
   TextMode(Lo(LastMode)+Font8x8);
End;

{
-  -  -  -  -

-  -  -  -  -

-  -  -  -  -

-  -  -  -  -

-  -  -  -  -

-

}


Procedure WHeb(var C:Char);
Begin
   if ( (C >= '') and (C <= '')) then
           C := chr(ord(C) - ord('') + ord(''));
End;

Procedure WHebStr(var S : String);
var
 I : Integer;
Begin
   for I := 1 to Length(S) do WHeb(S[I]);
End;

Procedure StrNegative(var S : String);
var
 S2   : String;
 Ch   : Char;
 I, J, K, l, A : Integer;
Const
   NN : Set of Char = ['0'..'9','-'];
Begin
   S2 := S;
   S := '';
   J := Length(S2);
   for I := 1 to Length(S2) do
   Begin
      if S2[J] in NN then
      Begin
         K := J;
         Repeat
             K := K -1;
         until (not(S2[K] in NN) or (K < 1));
         K := K + 1;
         for A := K to J do
         Begin
            S := S + S2[A];
         End;
         I := I + J - K;
         J := K - 1;
      End
     else
      Begin
         S := S + S2[J];
         J := J - 1;
      End;
   End;
   S2 := S;

End;

Procedure Display(S:String);
var
 I, L : Integer;
 TStr : String;
 Ln : Boolean;
Begin
   Ln := False;
   Tstr := '';
   L := Length(S);
   I := 1;
   Repeat
      if (S[I] = '\') and (S[I+1] = 'n') then
      Begin
         Writeln;
         Tstr := '';
         I := I + 1;
      End
      else
      Begin
         Tstr := Tstr + S[I];
         Display2(Tstr);
         Beep(400,10,10);
      End;
      I := I + 1;
   Until I > L;
End;

Procedure Display2(S:String);
var
 Sy : Byte;
Begin
   Sy := WhereY;
   GoToXY(40 - (Length(S) div 2),Sy);
   Write(S);
End;

Procedure Read2(var S:String; Max:Integer);
var
  Ch    : Char;
  OK    : Boolean;
  C,I   : Integer;
  SX,SY : Integer;
  Str   : String;
Begin
   C := Length(S);
   Str := S;
   Write(Str);
   repeat
     OK := True;
     Ch := ReadKey;
     if (Ch = Enter_Key) or (Ch = #0) or (Ch = Esc_Key)
           or (Ch = BackSpace) then OK := False;
     if (OK) and (C < Max) then
     Begin
        C := C + 1;
        Str := Str + Ch;
        Display2(Str);
     End;
     if (Ch = BackSpace) and (C > 0) then
     Begin
        TextColor(RBk);
        Display2(Str);
        TextColor(RC);
        C := C - 1;
        Delete(Str,Length(Str),1);
        Display2(Str);
     End;
   until Ch = Enter_Key;
   S := Str;
   TextColor(RC);
End;

Procedure WWHeb(FName : String);
var
 F, F2 : Text;
 S : String;
Begin
   CopyF(FName,'Tmp.Tmp');
   Assign(F, FName);
   Assign(F2, 'Tmp.Tmp');
   Rewrite(F);
   Reset(F2);
   While not Eof(F2) do
   Begin
      Readln(F2, S);
      WHebStr(S);
      StrNegative(S);
      Writeln(F, S);
   End;
   Close(F);
   Close(F2);
End;

Procedure PutMsg(Msg : String;Style:MsgStyle);
var
 W : Win;
 I, J, X, Y : Integer;
Begin
   Y := 10;
   X := 40 - (Length(Msg));
   J := Length(Msg);
   for I := 1 to Length(Msg) div 2 + 3 do
   Begin
      W.Init(40-I, Y, 40+I, Y+4, 15, MsgColor, '',Double);
      W.Draw;
      Beep(300, 10, 10);
      J := J - 1;
      Window(1,1,80,25);
   End;
   GoToXY(40-I+3,Y+2);
   DispStr(Msg);
   I := 0;
   Repeat
       Inc(I);
       if Style = Good then
       Begin
          Beep(300, 200, 200);
          Beep(370, 200, 200);
          Beep(440, 200, 200);
       End;
       if Style = Bad then
       Begin
          Beep(200, 200, 200);
          Beep(120, 200, 200);
          Beep(100, 200, 200);
       End;
       if Style = Normal then
       Begin
          Beep(300, 200, 200);
       End;
       if Style = Non then
       Begin
          Delay(300);
       End;
   until (KeyPressed) or (I = MaxMsgMusic);
End;

Function ClearNum(Num : LongInt) : String;
var
 S : String;
 C, J, I : Byte;
Begin
   Str(Num, S);
   if Length(S) > 3 then
   Begin
      C := 1;
      J := Length(S);
      for I := 1 to Length(S) do
      Begin
         Inc(C);
         J := J -1;
         if (C = 3) and (J > 1) then
         Begin
            Insert(',',S,J);
            C := 0;
         End;
      End;
   End;
   ClearNum := S;
End;

Procedure SendError(ErrorCode : Integer; ErrorStr : String);
Begin
   Writeln('Error #',ErrorCode,': ',ErrorStr);
   Halt(1);
End;

Procedure SendErrorType(Error : ErrorType);
Begin
   Writeln('Error #',Error.ErrorCode,': ',Error.ErrorStr);
   Halt(1);
End;

Procedure YScroll.Init(PX, PY, PScrLines : Byte; SFile : String);
Const
 SFileOpenError : ErrorType = (ErrorCode : 1;
                               ErrorStr : 'Cannot open scroll file.');
var
 F : Text;
 S : String;
Begin
   X         :=   PX;
   Y         :=   PY;
   ScrLines  :=   PScrLines+1;
   WFile     :=   SFile;
   Saman     :=   1;
   FromPos   :=   1;
   ToPos     :=   FromPos+ScrLines;


   if not Exist(WFile) then
      SendErrorType(SFileOpenError);
   Assign(F, WFile);
   Reset(F);
   FLines := 0;
   While not eof(F) do
   Begin
      Readln(F, S);
      Inc(FLines);
   End;
   Close(F);
   FLines := FLines + 2;
   if FLines > ScrLines then
     CanMovDn := True
   else
     CanMovDn := False;
   CanMovUp := False;
End;

Procedure YScroll.LoadToBuffer(From_Where : Longint);

var
 F : Text;
 I : Longint;
 S : String;
Begin
   if From_Where > FLines then
      SendErrorType(ScrlMovErr);
   Assign(F, WFile);
   Reset(F);
   for I := 1 to From_Where do
     Readln(F, S);
   Buffer[1] := S;
   for I := 2 to ScrLines-1 do
     Readln(F, Buffer[I]);
   Close(F);
End;

Procedure YScroll.MoveBuffer(UpDown : Boolean; How_Much : Byte);
Begin
   if (UpDown = True) {Up} and (FromPos > 1) then
   Begin
      FromPos := FromPos - How_Much;
      ToPos   := FromPos + ScrLines;
      LoadToBuffer(FromPos);
   End;
   {Down} if (ToPos < FLines) and (UpDown = False) then
   Begin
      FromPos := FromPos + How_Much;
      ToPos   := FromPos + ScrLines;
      LoadToBuffer(FromPos);
   End;
End;

Procedure YScroll.MoveSaman(UpDown : Boolean; How_Much : Byte);
Begin
   if (UpDown = True)  then
   Begin
      if Saman <= 1 then MoveBuffer(UpDown, How_Much)
      else Saman := Saman - How_Much;
   End;
  {Down} if (UpDown = false)and(Saman < FLines-2) then
   Begin
      if Saman >= ScrLines-1 then MoveBuffer(UpDown, How_Much)
      else Saman := Saman + How_Much;
   End;
End;

Procedure YScroll.DispScreen;
var
 I : Byte;
Begin
   TextColor(15);
   GoToXY(X, Y);
   For I := 1 to ScrLines-1 do
   Begin
      GoToXY(X, Y+I-1);
      if I <> Saman then
      Begin
         TextColor(15);
         TextBackground(0);
      End
     else
      Begin
         TextColor(0);
         TextBackground(15);
      End;
      Write(Buffer[I]);
   End;
End;

Procedure YScroll.ClearScreen;
var
 I : Byte;
Begin
   GoToXY(X, Y);
   TextColor(0);
   TextBackground(0);
   For I := 1 to ScrLines-1 do
   Begin
      GoToXY(X, Y+I-1);
      Write(Buffer[I]);
   End;
End;

Procedure YScroll.Play;
var
 Ch : Char;
 Done : Boolean;
Begin
   LoadToBuffer(1);
   DispScreen;
   Done := False;
   Result := '';
   Repeat
   if KeyPressed then
   Begin
      Ch := ReadKey;
      if Ch = #0 then Ch := ReadKey;
      ClearScreen;
      if Ch = Esc_Key then Done := True;

      if Ch = Enter_Key then
      Begin
         Result := Buffer[Saman];
         Done := True;
      End;

      if Ch = Up_Key then MoveSaman(True, 1);
      if Ch = Down_Key then MoveSaman(False, 1);
      DispScreen;
   End;
   if ButtonDown then Done := True;
   Until Done;
   DispScreen;
End;

Function YGetDir : String;
var
 S:String;
Begin
   GetDir(0, S);
   if S[Length(S)] = '\' then
     Delete(S, Length(S), 1);
   YGetDir := S;
End;

Function OpenDialog(What_Kind : String) : String;
var
 W : Win;
 M : Menu3;
 Files, Dirs : YScroll;
 FilesF, DirsF : Text;
 DirInfo : SearchRec;
 F : File;
 Attr : Word;
 SvCurDir : String;
 FName : String;
 Done : Boolean;
 Esc : Boolean;
Const
  csName  = 21;
  csDirs  = 22;
  csFiles = 23;

Procedure DrawBox;
Begin
   W.Init(15,5,65,21,15,0,' Open Dialog ('+What_Kind+') ',Double);
   W.Draw;
   Window(1,1,80,25);
   W.Init(16,7,64,9,15,0,'',Single);
   W.Draw;
   Window(1,1,80,25);
   W.Init(16,11,39,19,15,0,' Files ',Single);
   W.Draw;
   Window(1,1,80,25);
   W.Init(41,11,64,19,15,0,' Directories ',Single);
   W.Draw;
   Window(1,1,80,25);
End;

Procedure FindFiles;
var
 W : Win;
 DNum, FNum : Longint;
Begin
   Assign(FilesF, 'C:\000.001');
   Assign(DirsF, 'C:\000.000');
   Rewrite(FilesF);
   Rewrite(DirsF);
   DNum := 0;
   FNum := 0;
   W.Init(18,9,40,13,15,0,' Scanning... ',Single);
   W.Draw;
   findfirst(What_Kind, anyfile, DirInfo);
   While DosError = 0 do
   Begin
      GoToXY(1,1);
      Writeln('Directories: ',DNum);
      Writeln('Files      : ',FNum);
      Assign(F, DirInfo.Name);
      GetFAttr(F, Attr);
      if ((Attr and Archive) <> 0) and
         ((DirInfo.Name <> '000.000')and(DirInfo.Name <> '000.001')) then
      Begin
         Writeln(FilesF, DirInfo.Name);
         Inc(FNum);
      End;
      findnext(DirInfo);
   End;
   findfirst('*.*', anyfile, DirInfo);
   While DosError = 0 do
   Begin
      GoToXY(1,1);
      Writeln('Directories: ',DNum);
      Writeln('Files      : ',FNum);
      Assign(F, DirInfo.Name);
      GetFAttr(F, Attr);
      if (Attr and Directory) <> 0 then
      Begin
         Writeln(DirsF, DirInfo.Name);
         Inc(DNum);
      End;
      findnext(DirInfo);
   End;
   Close(FilesF);
   Close(DirsF);
End;


Begin
   GetDir(0,SvCurDir);
   DrawBox;
   M.Init;
   M.Set_Items_Colors(Blue, 0, Yellow, 7);
   M.Add_Item('~N~ame', 'N', 17, 6, csName);
   M.Add_Item('~F~iles', 'F', 17, 10, csFiles);
   M.Add_Item('~D~irs', 'D', 42, 10, csDirs);
   M.Add_Item('~O~k', 'O', 26, 20, csOk);
   M.Add_Item('~C~ancel','C', 48, 20, csCancel);
   FindFiles;
   FName := '';
   Done  := False;
   Repeat
      DrawBox;
      Files.Init(17,12,7,'C:\000.001');
      Dirs.Init(42,12,7,'C:\000.000');
      Files.LoadToBuffer(1);
      Dirs.LoadToBuffer(1);
      Dirs.DispScreen;
      Files.DispScreen;
      GoToXY(17, 8); Write(YGetDir+'\'+FName);
      M.Play(False);
      if M.R = csFiles then
      Begin
        Files.Init(17,12,7,'C:\000.001');
        Files.Play;
        FName := Files.Result;
      End;
      if M.R = csDirs then
      Repeat
         Dirs.Init(42,12,7,'C:\000.000');
         Dirs.Play;
         if (Dirs.Result <> '') and (Dirs.Result <> '.') then
         Begin
            FName := '';
            Erase(FilesF);
            Erase(DirsF);
            ChDir(Dirs.Result);
            findfiles;
            DrawBox;
            M.Display_Items(0);
            GoToXY(17, 8); Write(YGetDir+'\'+FName);
            Files.Init(17,12,7,'C:\000.001');
            Dirs.Init(42,12,7,'C:\000.000');
            Files.LoadToBuffer(1);
            Dirs.LoadToBuffer(1);
            Dirs.DispScreen;
            Files.DispScreen;
         End;
      Until (ButtonDown) or (Dirs.Result = '');
      if M.R = csName then
      Begin
         {FName := '';}
         GoToXY(17,8);
         Write('                                            ');
         GoToXY(17,8);
         Write(YGetDir+'\');
         YRead(FName, 40, False);
         if (Pos('.',FName) = 0) and
            (What_Kind[Length(What_Kind)] <> '*') and
            (Pos(' ',FName) = 0) and (FName <> '') then
               FName := FName + Copy(What_Kind, 2, 4);
      End;
      if M.R = csCancel then
      Begin
         OpenDialog := '';
         Done := True;
         ChDir(SvCurDir);
      End;
      if M.R = csOk then
      if Exist(YGetDir+'\'+FName) then
      Begin
         OpenDialog := YGetDir+'\'+FName;
         Done := True;
         ChDir(SvCurDir);
      End
     else
      Begin
         W.Init(18,9,40,13,15,0,' System ',Single);
         W.Draw;
         Writeln;
         Writeln('File not found!');
         Repeat
            if ButtonDown then Break;
         Until KeyPressed;
      End;
   Until Done;
End;


Function SaveDialog(What_Kind, Default : String) : String;
var
 W : Win;
 M, M2 : Menu3;
 Files, Dirs : YScroll;
 FilesF, DirsF : Text;
 DirInfo : SearchRec;
 F : File;
 Attr : Word;
 SvCurDir : String;
 FName : String;
 Done : Boolean;
 Esc : Boolean;
Const
  csName  = 21;
  csDirs  = 22;
  csFiles = 23;

Procedure DrawBox;
Begin
   W.Init(15,5,65,21,15,0,' Save Dialog ('+What_Kind+') ',Double);
   W.Draw;
   Window(1,1,80,25);
   W.Init(16,7,64,9,15,0,'',Single);
   W.Draw;
   Window(1,1,80,25);
   W.Init(16,11,39,19,15,0,' Files ',Single);
   W.Draw;
   Window(1,1,80,25);
   W.Init(41,11,64,19,15,0,' Directories ',Single);
   W.Draw;
   Window(1,1,80,25);
End;

Procedure FindFiles;
var
 W : Win;
 DNum, FNum : Longint;
Begin
   Assign(FilesF, '000.001');
   Assign(DirsF, '000.000');
   Rewrite(FilesF);
   Rewrite(DirsF);
   DNum := 0;
   FNum := 0;
   W.Init(18,9,40,13,15,0,' Scanning... ',Single);
   W.Draw;
   findfirst(What_Kind, anyfile, DirInfo);
   While DosError = 0 do
   Begin
      GoToXY(1,1);
      Writeln('Directories: ',DNum);
      Writeln('Files      : ',FNum);
      Assign(F, DirInfo.Name);
      GetFAttr(F, Attr);
      if ((Attr and Archive) <> 0) and
         ((DirInfo.Name <> '000.000')and(DirInfo.Name <> '000.001'))  then
      Begin
         Writeln(FilesF, DirInfo.Name);
         Inc(FNum);
      End;
      findnext(DirInfo);
   End;
   findfirst('*.*', anyfile, DirInfo);
   While DosError = 0 do
   Begin
      GoToXY(1,1);
      Writeln('Directories: ',DNum);
      Writeln('Files      : ',FNum);
      Assign(F, DirInfo.Name);
      GetFAttr(F, Attr);
      if ((Attr and Directory) <> 0) then
      Begin
         Writeln(DirsF, DirInfo.Name);
         Inc(DNum);
      End;
      findnext(DirInfo);
   End;
   Close(FilesF);
   Close(DirsF);
End;


Begin
   FName := Default;
   GetDir(0,SvCurDir);
   DrawBox;
   M.Init;
   M.Set_Items_Colors(Blue, 0, Yellow, 7);
   M.Add_Item('~N~ame', 'N', 17, 6, csName);
   M.Add_Item('~F~iles', 'F', 17, 10, csFiles);
   M.Add_Item('~D~irs', 'D', 42, 10, csDirs);
   M.Add_Item('~O~k', 'O', 26, 20, csOk);
   M.Add_Item('~C~ancel','C', 48, 20, csCancel);
   FindFiles;
   Done  := False;
   Repeat
      DrawBox;
      Files.Init(17,12,7,'000.001');
      Dirs.Init(42,12,7,'000.000');
      Files.LoadToBuffer(1);
      Dirs.LoadToBuffer(1);
      Dirs.DispScreen;
      Files.DispScreen;
      GoToXY(17, 8); Write(YGetDir+'\'+FName);
      M.Play(False);
      if M.R = csFiles then
      Begin
        Files.Init(17,12,7,'000.001');
        Files.Play;
        FName := Files.Result;
      End;
      if M.R = csDirs then
      Repeat
         Dirs.Init(42,12,7,'000.000');
         Dirs.Play;
         if (Dirs.Result <> '') and (Dirs.Result <> '.') then
         Begin
            FName := '';
            Erase(FilesF);
            Erase(DirsF);
            ChDir(Dirs.Result);
            findfiles;
            DrawBox;
            M.Display_Items(0);
            GoToXY(17, 8); Write(YGetDir+'\'+FName);
            Files.Init(17,12,7,'000.001');
            Dirs.Init(42,12,7,'000.000');
            Files.LoadToBuffer(1);
            Dirs.LoadToBuffer(1);
            Dirs.DispScreen;
            Files.DispScreen;
         End;
      Until (ButtonDown) or (Dirs.Result = '');
      if M.R = csName then
      Begin
        { FName := '';}
         GoToXY(17,8);
         Write('                                            ');
         GoToXY(17,8);
         Write(YGetDir+'\');
         YRead(FName, 40, False);
         if (Pos('.',FName) = 0) and
            (What_Kind[Length(What_Kind)] <> '*') and
            (Pos(' ',FName) = 0) and (FName <> '') then
               FName := FName + Copy(What_Kind, 2, 4);
      End;
      if M.R = csCancel then
      Begin
         SaveDialog := '';
         Done := True;
         ChDir(SvCurDir);
      End;
      if M.R = csOk then
      if Exist(YGetDir+'\'+FName) then
      Begin
         W.Init(18,9,50,14,15,0,' System ',Single);
         W.Draw;
         DispStr('File allry exist! \n'+
                 'Overwrite?');
         Window(1,1,80,25);
         M2.Init;
         M2.Set_Items_Colors(Blue, 0, Yellow, 7);
         M2.Add_Item('~Y~es', 'O', 20, 13, 30);
         M2.Add_Item('~N~o', 'C', 40, 13, 31);
         M2.Play(False);
         if M2.R = 30 then
         Begin
            SaveDialog := YGetDir+'\'+FName;
            Done := True;
            ChDir(SvCurDir);
            Window(1,1,80,25);
            W.Init(18,9,50,13,15,0,' System ',Single);
            W.Draw;
            Writeln;
            Writeln('File save successful.');
            Repeat
               if ButtonDown then Break;
            Until KeyPressed;
         End;
      End
     else
      Begin
         Assign(F,YGetDir+'\'+FName);
         {$I-}Rewrite(F);{$I+}
         if IOResult <> 0 then
         Begin
            W.Init(18,9,50,13,15,0,' System ',Single);
            W.Draw;
            Writeln;
            Writeln('Cannot write to file.');
            Repeat
               if ButtonDown then Break;
            Until KeyPressed;
         End
        else
         Begin
            Close(F);
            SaveDialog := YGetDir+'\'+FName;
            Done := True;
            ChDir(SvCurDir);
            W.Init(18,9,50,13,15,0,' System ',Single);
            W.Draw;
            Writeln;
            Writeln('File save successful.');
            Repeat
               if ButtonDown then Break;
            Until KeyPressed;
         End;
      End;
   Until Done;
End;

Function YMessage(Msg : String) : Boolean;
var
 M : Menu3;
 W : Win;
 X,
 Y,
 X1,
 Y1 : Byte;
 L, Lns, I : Byte;
Begin
   for L := 1 to Length(Msg) do
    if (Msg[L] = '\') and (Msg[L+1] = 'l') then Break;
   L := L + 6;
   Lns := 0;
   for I := 1 to Length(Msg) do
    if (Msg[I] = '\') and (Msg[I+1] = 'l') then Inc(Lns);
   Lns := Lns + 4;
   X := (80 div 2) - (L div 2);
   Y := (25 div 2) - (Lns div 2);
   X1 := X + L;
   Y1 := Y + Lns;
   W.Init(X,Y,X1,Y1,White,Blue,' Message! ',Special1);
   W.Draw;
   Window(1,1,80,25);
   GoToXY(X+3,Y+1); DispStr(Msg);
   M.Set_Items_Colors(15,Blue,0,Green);
   M.Init;
   M.Add_Item('  ~O~k  ','O',X+3,Y1-1,csOk);
   M.Add_Item('~C~ancel','O',X1-7,Y1-1,csCancel);
   M.Play(False);
   if M.R = csOk then YMessage := True
  else YMessage := False;
End;

Function StrSpace(Len : Byte) : String;
var
 I : Byte;
 S : String;
Begin
   S := '';
   for I := 1 to Len do
    S := S + ' ';
   StrSpace := S;
End;

Function DistanceXY(x1,y1,x2,y2 :integer) : integer;
VAR
TMP:REAL;
Begin
   TMP :=   exp ( ln(abs(x1-x2)) * 2) + exp ( ln(abs(y1-y2))*2);
   DistanceXY := round ( EXP (LN (TMP) / 2));
end;


Begin
   InitHelpLine('Ready',English);
   RBk := 0;
   RC := 7;
   MaxMsgMusic := 5;
End.
