{DOS port of Neofetch}
{$E+}
{$M 16384,0,65535}
uses Dos,Crt,Lacrt;

const
maxlines = 25;
maxcol = 80;


type
TScrBuf = array[1..maxcol,1..maxlines] of char;
PScrBuf = ^TScrBuf;
str40 = string[40];

var
Hbuf:PScrBuf;
Abuf:PScrBuf;
maxy,maxx:byte;
isredir:boolean;
myout:text;

datastr:array[1..14] of str40;
helpstr:array[1..25] of string;

const
msg_ram1:str40 = 'Memory: ';
msg_ram2:str40 = 'MB RAM';
msg_disks:str40 = 'Installed disks: ';
msg_percfree:str40 = 'free';
msg_dosver:str40 = 'Reported DOS version: ';
msg_codepage:str40 = 'Code page and country code: ';
msg_free_conv_mem:str40 = 'Free conv. memory: ';
msg_fs_gb:str40 = 'GB';
msg_fs_mb:str40 = 'MB';
msg_fs_kb:str40 = 'KB';
msg_fs_B:str40 = 'bytes';
msg_newer_than_p3:str40 = 'CPU newer than Pentium III';

forcelang:string[3]='';
forcelogo:byte=0;
numhelpstr:byte=0;
onlywritehelp:boolean = false;

Function GetCPU_Type_386_486: Byte; Assembler;
Asm
  MOV DX, 2 {Cpu80386}
  {"DB 66h" indicates '386 extended instruction}
  DB 66h; MOV   BX, SP      {MOV EBX, ESP}
  DB 66h, 83h, 0E4h, 0FCh   {AND ESP, FFFC}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP AX            {POP EAX}
  DB 66h; MOV   CX, AX      {MOV ECX, EAX}
  DB 66h, 35h, 00h
  DB 00h, 04h, 00           {XOR EAX, 00040000}
  DB 66h; PUSH   AX     {PUSH EAX}
  DB 66h; POPF              {POPFD}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP   AX     {POP EAX}
  DB 66h, 25h, 00h
  DB 00h, 04h, 00h          {AND EAX, 00040000}
  DB 66h, 81h, 0E1h, 00h
  DB 00h, 04h, 00h          {AND ECX, 00040000}
  DB 66h; CMP   AX, CX      {CMP EAX, ECX}
  JE @Not486
  MOV DX, 3 {Cpu80486}
@Not486:
  DB 66h; PUSH   CX         {PUSH EXC}
  DB 66h; POPF              {POPFD}
  DB 66h; MOV   SP, BX      {MOV ESP, EBX}
@Out:
  MOV AX, DX
end;


Function CPU_Identification:string;
const
cpu8086 = 'CPU 8086/8088 (PC/XT)';
cpu286 = 'CPU 80286 (PC/AT)';
cpu386 = 'CPU 80386';
cpu486 = 'CPU 80486';
cpu586 = 'Pentium class';
cpuPentpro = 'Pentium Pro';
cpuPent2 = 'Pentium II';
cpuPent3 = 'Pentium III';


var i:byte;
    b:boolean;
    s,t:string;
    fax,fbx,fcx,fdx:longint;
    ffax,d:longint;
    mfam,mmod:byte;

begin
if Test8086>1 then i:=GetCPU_Type_386_486 else i:=Test8086;

case i of
  0:s:=cpu8086;
  1:s:=cpu286;
  2:s:=cpu386;
  3:s:=cpu486;
end; {case}

if i>2 then  {386 or better}
   begin
   b:=CallCPUID(0,fax,fbx,fcx,fdx); {try to obtain vendor string}
   if b=true then             {some 486's and all Pentiums know CPUID}
      begin
      t[0]:=#12;
      Move(fbx,t[1],4);
      Move(fdx,t[5],4);
      Move(fcx,t[9],4);
      ffax:=fax;

      CallCPUID($80000000,fax,fbx,fcx,fdx);

      if (fax>=$80000004) and (fax<>0) then
         begin
         t[0]:=#48;
         CallCPUID($80000002,fax,fbx,fcx,fdx);
         Move(fax,t[1],4);
         Move(fbx,t[5],4);
         Move(fcx,t[9],4);
         Move(fdx,t[13],4);

         CallCPUID($80000003,fax,fbx,fcx,fdx);
         Move(fax,t[17],4);
         Move(fbx,t[21],4);
         Move(fcx,t[25],4);
         Move(fdx,t[29],4);

         CallCPUID($80000004,fax,fbx,fcx,fdx);
         Move(fax,t[33],4);
         Move(fbx,t[37],4);
         Move(fcx,t[41],4);
         Move(fdx,t[45],4);
         for d:=1 to Length(t) do
             if t[d]=#0 then t[d]:=#32;
         s:=PackSpaces(t);
         end
         else
         begin

      if ffax>0 then
         begin
         CallCPUID(1,fax,fbx,fcx,fdx);
         d:=(fax shr 8) and 15;
         mfam:=d;

         d:=(fax shr 4) and 15;
         mmod:=d;

         if (mfam=6) or (mfam=15) then
            begin
            d:=(fax shr 16) and 15;
            mmod:=mmod + (d shl 4);
            end;

         case mfam of
         3:t:=cpu386;
         4:t:=cpu486;
         5:t:=cpu586;
         6:begin
           case mmod of
           0,1: t:=cpuPentpro;
           3,5,6: t:=cpuPent2;
           7,8,$a,$b: t:=cpuPent3;
           else t:=msg_newer_than_p3;
           end; {case}
           end;
         end; {case}

         s:=t;
         end;
         end;
      end;
   end;

CPU_Identification:=s;
end;


Function GetCursorParam:word;assembler;
asm
mov ah,3
mov bh,0
int 10h
mov ax,dx
end;


Function IsRedirectedOutPut:boolean;
var a1,a2:word;
begin
a1:=GetCursorParam;
write(stdout,' ');
a2:=GetCursorParam;
IsRedirectedOutPut:=a1=a2;
if a1<>a2 then write(stdout,char(8))
end;



Procedure InitBufs;
begin
maxy:=0;
maxx:=0;
New(Hbuf);
New(Abuf);
FillChar(Hbuf^,SizeOf(TScrBuf),32);
FillChar(Abuf^,SizeOf(TScrBuf),7);
isredir:=IsRedirectedOutPut;
end;


Procedure KillBufs;
begin
Dispose(Hbuf);
Dispose(Abuf);
Close(myout);
end;


Procedure WriteBufs(x,y:byte;s:string;col:byte);
var xs,ls,xsb,ms,a,b,mxs:byte;
    specbyte:boolean;
begin
xs:=x-1;
ls:=Length(s);

if y>maxy then maxy:=y;
if x+ls>maxcol then ms:=maxcol-x else ms:=ls;
mxs:=x+ms-1;
if mxs>maxx then maxx:=mxs;

specbyte:=false;
b:=1;

a:=1;

while a<=ls do
    begin
    if (s[a]=char(1)) and (specbyte=false) then
       begin
       specbyte:=true;
       end
       else
       if specbyte=false then
          begin
          xsb:=xs+b;
          if xsb<maxcol then
             begin
             HBuf^[xs+b,y]:=s[a];
             ABuf^[xs+b,y]:=char(col);
             end;
          inc(b);
          end
          else begin
          col:=byte(s[a]);
          specbyte:=false;
          end;
    inc(a);
    end;
end;




Procedure PrintBufs;
var x,y:byte;
    h:char;
    a:byte;
begin
for y:=1 to maxy do
    begin
    for x:=1 to maxx do
        begin
        h:=HBuf^[x,y];
        a:=byte(ABuf^[x,y]);
        TextColor(a and 15);
        write(myout,h);
        end;
    writeln(myout);
    end;
end;


Procedure Write_DOS_Logo;
var x,y,c:byte;
begin
x:=1;
y:=2;
c:=4;
WriteBufs(x,y+0,'8888888ba,  '#1#14'  ,ad888ba,   '#1#1'  ad88888ba  ',c);
WriteBufs(x,y+1,'88     `"8b '#1#14' d8"''   `"8b '#1#1' d8"     "8b ',c);
WriteBufs(x,y+2,'88       `8b'#1#14'd8''       `8b'#1#1' Y8,         ',c);
WriteBufs(x,y+3,'88        88'#1#14'88         88 '#1#1'`Y8aaaaa,   ',c);
WriteBufs(x,y+4,'88        88'#1#14'88         88 '#1#1'  `"""""8b, ',c);
WriteBufs(x,y+5,'88        8P'#1#14'Y8,       ,8P '#1#1'        `8b ',c);
WriteBufs(x,y+6,'88     .a8P '#1#14' Y8a.   .a8P  '#1#1'Y8a     a8P ',c);
WriteBufs(x,y+7,'8888888Y"'' '#1#14'  `"Y888Y"'' '#1#1'  "Y88888P"',c);
end;


Procedure Write_FreeDOS_Logo;
var x,y,c:byte;
begin
x:=1;
y:=2;
c:=11;

WriteBufs(x,y+0,' d''b',c);
WriteBufs(x,y+1,' 8',c);
WriteBufs(x,y+2,'o8P  oPYo. .oPYo. .oPYo.',c);
WriteBufs(x,y+3,' 8   8  `'' 8oooo8 8oooo8',c);
WriteBufs(x,y+4,' 8   8     8.     8.',c);
WriteBufs(x,y+5,' 8   8     `Yooo'' `Yooo',c);

c:=4;
WriteBufs(x,y+6,':::::::-. '#1#14'     ...   '#1#1'   .::::::.',c);
WriteBufs(x,y+7,' ;;,   `'';,'#1#14' .;;;;;;;.'#1#1'  ;;;`    `',c);
WriteBufs(x,y+8,' `[[     [['#1#14',[[     \[[,'#1#1'''[==/[[[[,',c);
WriteBufs(x,y+9,'  $$,    $$'#1#14'$$$,     $$$'#1#1'  ''''''    $',c);
WriteBufs(x,y+10,'  888_,o8P"'#1#14'888,_ _,88P'#1#1' 88b    dP',c);
WriteBufs(x,y+11,'  MMMMP"`'#1#14'    "YMMMMMP" '#1#1'  "YMmMY"',c);
end;


Procedure ReadLine(var t:text);
var g,h:string;
    b1,b2:byte;
    a:longint;

begin
readln(t,g);
if (Length(g)>2) and (g[1]='.') then
   begin
   b1:=Pos('{',g);
   b2:=Pos('}',g);
   if (b1>0) and (b2>b1) then
      begin
      if b2-b1=1 then h:='' else h:=Mid(g,b1+1,b2-1);
      if g[2]='H' then
         begin
         inc(numhelpstr);
         helpstr[numhelpstr]:=h;
         end
         else begin
         if g[2] in ['1'..'9'] then
            begin
            a:=IzolujPrvniCislo(g);
            if (a>0) and (a<15) then datastr[a]:=h;
            end;
         end;
      end;
   end;
end;


Procedure ZeSouboru(s:string);
var t:text;
    v:string;
begin
{$I-}
Assign(t,s);
Reset(t);
{$I+}
if IOresult<>0 then Exit;

while not Eof(t) do ReadLine(t);
Close(t);

msg_ram1:=datastr[1];
msg_ram2:=datastr[2];
msg_disks:=datastr[3];
msg_percfree:=datastr[4];
msg_dosver:=datastr[5];
msg_codepage:=datastr[6];
msg_free_conv_mem:=datastr[7];
msg_fs_gb:=datastr[8];
msg_fs_mb:=datastr[9];
msg_fs_kb:=datastr[10];
msg_fs_B:=datastr[11];
msg_newer_than_p3:=datastr[12];
end;


Procedure ReadMessages;
var nlspath,lang:string;
    n,a1,a3,prg:string;
begin
n:=FExpand(ParamStr(0));
FSplit(n,a1,prg,a3);

nlspath:=GetEnv('NLSPATH');

if forcelang=''
   then lang:=GetEnv('LANG')
   else begin
   lang:=forcelang;
   if nlspath='' then nlspath:=a1;
   end;


if nlspath<>'' then
   if nlspath[Length(nlspath)]<>'\' then nlspath:=nlspath+'\';

if (nlspath<>'') and (lang<>'') then
   begin
   n:=nlspath+prg+'.'+lang;
   ZeSouboru(n);
   end;
end;


Function Boo2Ch(b:boolean):char;
begin
if b=true then Boo2Ch:='+' else Boo2Ch:='-';
end;


Function DOSPosAlloc:longint;
var rbx:word;
begin
asm
mov ah,48h
mov bx,0ffffh
int 21h
mov rbx,bx
end;
DOSPosAlloc:=longint(rbx)*16;
end;


FUNCTION AvailableDosmem : LONGINT;

{----Returns Largest Free DOS memory as seen on the dos prompt by          }
{    CHKDSK and MEM.                                                       }

{----Records from The Programmer's PC Sourcebook by Thom Hogan, 1st Edition}

{    Only relevant field commented. Tuned by be equal to DR-DOS's 6.0}
{    MEM command. Works only if programs allocates all memory available}
{    so no max heaplimits to enable TP's Exec.}

Type
  MCBrec = RECORD
             location   : Char; {----'M' is normal block, 'Z' is last block }
             ProcessID,
             allocation : WORD; {----Number of 16 Bytes paragraphs allocated}
             reserved   : ARRAY[1..11] OF Byte;
           END;

  PSPrec = RECORD
             int20h,
             EndofMem        : WORD;
             Reserved1       : BYTE;
             Dosdispatcher   : ARRAY[1..5] OF BYTE;
             Int22h,
             Int23h,
             INT24h          : POINTER;
             ParentPSP       : WORD;
             HandleTable     : ARRAY[1..20] OF BYTE;
             EnvSeg          : WORD; {----Segment of Environment}
             Reserved2       : LONGINT;
             HandleTableSize : WORD;
             HandleTableAddr : POINTER;
             Reserved3       : ARRAY[1..23] OF BYTE;
             Int21           : WORD;
             RetFar          : BYTE;
             Reserved4       : ARRAY[1..9] OF BYTE;
             DefFCB1         : ARRAY[1..36] OF BYTE;
             DefFCB2         : ARRAY[1..20] OF BYTE;
             Cmdlength       : BYTE;
             Cmdline         : ARRAY[1..127] OF BYTE;
           END;

Var
  pmcb   : ^MCBrec;
  emcb   : ^MCBrec;
  psp    : ^PSPrec;
  dmem   : LONGINT;

  pa,ea:longint;

Begin
   psp:=PTR(PrefixSeg,0);      {----PSP given by TP var                }
  pmcb:=Ptr(PrefixSeg-1,0);    {----Programs MCB 1 paragraph before PSP}
  emcb:=Ptr(psp^.envseg-1,0);  {----Environment MCB 1 paragraph before envseg}

  pa:=longint(pmcb^.allocation);
  ea:=longint(emcb^.allocation);
  Availabledosmem:=LONGINT(pa+ea+1)*16+DOSposAlloc;
End;


Procedure InternalHelp;
begin
writeln(stdout,'MYSYSINF  (DOS implementation of Linux utility NEOFETCH)');
writeln(stdout,'version 1.2');
writeln(stdout,'written by Laaca');
writeln(stdout,'Laaca@seznam.cz');
writeln(stdout);
writeln(stdout,'Parameters:');
writeln(stdout,'/? /H /I : this help');
writeln(stdout);
writeln(stdout,'/G:1   : force to display FreeDOS logo ');
writeln(stdout,'/G:2   : force to display  general DOS logo ');
writeln(stdout);
writeln(stdout,'/L:<language code>');
writeln(stdout,'<language code> is a file with translated program messages.');
writeln(stdout,'Example: ');
writeln(stdout,'MYSYSINF /L:cz    Loads file MYSYSINF.CZ and switches');
writeln(stdout,'                  program messages to Czech language.');
writeln(stdout);
writeln(stdout,'This program is free software. You can redistribute and modify it under the');
writeln(stdout,'terms of the GNU GPL license.');
Halt(0);
end;


Procedure ExternalHelp;
var b:byte;
begin
for b:=1 to numhelpstr do
    writeln(stdout,helpstr[b]);
Halt(0);
end;


Procedure WriteHelp;
begin
if numhelpstr=0 then InternalHelp else ExternalHelp;
end;


Function Parser:byte;
var i:byte;
    s:string;
begin
forcelang:='';
for i:=1 to ParamCount do
    begin
    s:=Convert_Up(ParamStr(i));
    if (s='/?') or (s='/H') or (s='/I') then onlywritehelp:=true else

    if Copy(s,1,3)='/L:' then
       begin
       delete(s,1,3);
       s:=SkipAllSpaces(s);
       forcelang:=s;
       end else

    if Copy(s,1,4)='/G:1' then forcelogo:=1 else
    if Copy(s,1,4)='/G:2' then forcelogo:=2;
    end;
end;


{MAIN PROGRAM}


var a,b,yy:byte;
    w,cp,ccode:word;
    lds:str40;
    pds:str40;
    fdr:char;
    mgd:char;
    l:longint;
    i,j:array[1..2] of real;
    f:real;
    s:array[1..2] of string[15];
    xms,ems,jdpmi,vcpi,vds,lfn:boolean;
    posmem:longint;
    d:dpmiinfoblock;
    os_id:byte;
    fdlogo:boolean;


begin
Parser;
ReadMessages;

if onlywritehelp=true then WriteHelp;

xms:=Detect_XMS;
ems:=Detect_EMS;
vcpi:=Detect_VCPI;
vds:=Detect_VDS;
GetDPMIinfo(d);
jdpmi:=d.present;

InitBufs;
if isredir
   then Move(stdout,myout,SizeOf(text))
   else Move(output,myout,SizeOf(text));


ZjistiCodePage(ccode,cp);
lds:=LogDisk;
fdr:=Get_Fantom_Drive;

mgd:=char(MyGetDisk+64);
lfn:=LFN_is_or_not;
os_id:=Get_OS_Vendor_ID;

a:=Pos(fdr,lds);
if a>0 then
   begin
   Insert(')',lds,a+1);
   Insert('(',lds,a);
   end;

a:=Pos(mgd,lds);
if a>0 then
   begin
   Insert(#1#7,lds,a+1);
   Insert(#1#15,lds,a);
   end;

i[1]:=FreeDiskSpace(mgd);
i[2]:=TotaldiskSpace(mgd);

for b:=1 to 2 do
    if i[b]>1024*1024*1024 {GB} then begin j[b]:=i[b]/(1024*1024*1024);s[b]:=FormNum(j[b],2)+msg_fs_gb;end else
       if i[b]>1024*1024 {MB} then begin j[b]:=i[b]/(1024*1024);s[b]:=FormNum(j[b],2)+msg_fs_mb;end else
          if i[b]>1024 {KB} then begin j[b]:=i[b]/(1024);s[b]:=FormNum(j[b],2)+msg_fs_kb;end else
                          begin j[b]:=i[b];s[b]:=MyStr(round(j[b]))+msg_fs_b;end;

if i[2]=0
   then f:=0
   else f:=(i[1] / i[2] * 100);
l:=round(f);

pds:='['+mgd+']: '+#1#7+s[1]+' / '+s[2]+' ('+mystr(l)+'% '+msg_percfree+')';

WriteBufs(42,1,' ',7);


if os_id=$FD
   then fdlogo:=true else fdlogo:=false;
if forcelogo=1 then fdlogo:=true else
if forcelogo=2 then fdlogo:=false;

if fdlogo then begin Write_FreeDOS_Logo;yy:=4;end
          else begin Write_DOS_Logo;yy:=2;end;


WriteBufs(40,yy,Get_OS_type,7);inc(yy);
WriteBufs(40,yy,msg_dosver+#1#7+MyStr(Lo(DOSversion))+'.'+MyStr(Hi(DOSversion)),15);inc(yy);
WriteBufs(40,yy,msg_codepage+#1#7+MyStr(cp)+','+Mystr(ccode),15);inc(yy);

WriteBufs(40,yy,msg_disks+#1#7+lds+' '+#1#15'(LFN:'+Boo2Ch(lfn)+')',15);inc(yy);
WriteBufs(40,yy,pds,15);inc(yy);

w:=DetectMemory;
WriteBufs(40,yy,msg_ram1+#1#7+MyStr(w)+msg_ram2,15);inc(yy);
WriteBufs(40,yy,'XMS:'+Boo2Ch(xms)+'  '+'EMS:'+Boo2Ch(ems)+'  '+
                'DPMI:'+Boo2Ch(jdpmi)+'  '+'VCPI:'+Boo2Ch(vcpi)+'  '+'VDS:'+Boo2Ch(vds),15);inc(yy);

WriteBufs(40,yy,msg_free_conv_mem+#1#7+MyStr(AvailableDOSmem)+' '+msg_fs_B,15);inc(yy);

pds:=CPU_Identification;

WriteBufs(40,yy,pds,7);inc(yy);

PrintBufs;
KillBufs;
end.