#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <sys\stat.h>

#define STDOUT 1
#define STDERR 2

typedef char *charptr;

char  dumpall    = 0;
char  header[62] = "";
char  footer[62] = "";
int   offset     = 2;

int get_textattr(void) {
  struct text_info r;
  gettextinfo(&r);
  return(r.attribute);
  }

void get_screen(void) {
  int beg, end, i, j, k;
  unsigned char line[83];
  typedef struct {
    unsigned char c;
    unsigned char a;
    } scrchr;
  typedef union {
    unsigned int w;
    scrchr       b;
    } scrwrd;
  typedef scrwrd scrlin[80];
  scrlin screen[25];
  gettext(1,1,80,25,screen);
  if(dumpall) {
    beg = 0;
    end = 24;
    }
  else {
    end = wherey() - offset;
    for(beg=-1, i=end; i>0; i--)
      if((screen[i][0].w==243)&&(screen[i][1].w==224)&&(screen[i][2].w==242)) beg=i+1;
    if(beg < 0) beg = 0; else beg++;
    }
  for(i=beg; i <= end; i++) {
    for(j = 0; j < 80; j++) line[j] = screen[i][j].b.c;
    line[80] = '\0';
    for(k = 79; (k > 0) && (line[k] <= ' '); k--) line[k] = '\0';
    printf("%s\n", line);
    }
  }
char helptext[] = "\n\
 SCRDUMP 1.0 by Jrgen Hoffmann (2011) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: scrdump                           -  invisibly mark screen line\n\
    or: scrdump [ options ] > <filename>  -  dump screen between marked\n\
					     line and cursor line to file\n\
  valid options are:\n\
     /H /?    print this helptext\n\
     /A       (all) dump whole screen\n\
     /C       compensate for prompt\n\
     /B<text> print <text> before begin of screen output\n\
     /E<text> print <text> after  end   of screen output\n\n\
	      if <text> is exacly one character AND not alpha numeric\n\
	      then it is automatically expanded to 60 characters\n\n\
     example: scrdump\n\
	      ne1000 0x60 5 0x300\n\
	      scrdump > net\\ne1000.log\n";


void main (int argc, char* argv[]) {
  int   i,j,pr,qu,re,nul, txtattr;

  for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
    switch (toupper(argv[i][1])) {
      case 'A': dumpall = 1;                    break;
      case 'B': strncpy(header,&argv[i][2],60); break;
      case 'C': offset  = 4;                    break;
      case 'E': strncpy(footer,&argv[i][2],60); break;
      case 'H':
      case '?': printf(helptext); exit(0);
      }
    }

  if(stdout->flags&_F_TERM) {
    txtattr = get_textattr();
    cputs("\r");
    textattr(0x00);
    cputs("");
    textattr(txtattr);
    cputs("\r\n");
    }
  else {
    if(header[0]) {
      if(!header[1] && !isalnum(header[0])) {
	for(i=1; i<60; i++) header[i] = header[0];
	header[60] = '\0';
	}
      printf("%s\n",header);
      }
    get_screen();
    if(footer[0]) {
      if(!footer[1] && !isalnum(footer[0])) {
	for(i=1; i<60; i++) footer[i] = footer[0];
	footer[60] = '\0';
	}
      printf("%s\n",footer);
      }
    }
  }