'Font exporter

DEFINT A-Z

DECLARE SUB GetFontAddress (BPC, FontSeg, FontAdrs)
DECLARE SUB GetTextSize (TextHt, TextRows)

'---- Functions
DECLARE FUNCTION Exist% (Spec$)
DECLARE FUNCTION Monitor% ()

'---- Type definition required by CALL Interrupt
TYPE RegType
  AX    AS INTEGER
  BX    AS INTEGER
  CX    AS INTEGER
  DX    AS INTEGER
  BP    AS INTEGER
  SI    AS INTEGER
  DI    AS INTEGER
  Flags AS INTEGER
  DS    AS INTEGER
  ES    AS INTEGER
END TYPE

  DIM SHARED Registers AS RegType
  DIM SHARED MonType                  'Share MonType with ASCIIchart

  REDIM Font$(255)              'Create an array$() to hold the font
  REDIM Bit$(16), Out$(16)

  Lit$ = ""
  UnLit$ = " "
  Fout$ = "font.fnt"

  SC = 32: EC = 126: FLS = 1: FontH = 5

  SCREEN 0: MonType = Monitor%
  IF MonType < 3 THEN PRINT "This only works on EGA or VGA cards!": END

  CLS
  PRINT "Text-mode Font Exporter V1.1    (C)1996 Steve J. Gray "
  PRINT "(For SJGPlay 1.29 or higher)"
  PRINT STRING$(80, CHR$(205)): PRINT
  PRINT "Select a font; VGA (8 or 16) or EGA (14) pixels tall"
  INPUT "Which font (8/14/16)"; BPC
  IF (BPC <> 8) AND (BPC <> 16) AND (BPC <> 14) THEN PRINT "invalid entry.": END
  FontH = BPC

  PRINT
  PRINT "Export (N)ormal, (H)alf-block, or (S)JGPlay character set?"
  INPUT "Which set (N/H/S)"; Q$
  Q$ = UCASE$(Q$): Opt$ = ",,"
  SELECT CASE Q$
    CASE "N": Cout$ = UnLit$ + Lit$
    CASE "H": Cout$ = " ": FontH = BPC / 2
    CASE "S": Cout$ = " ߷": Opt$ = ",sjgfnt16.com,sjgfnt8.com"
    CASE ELSE: END
  END SELECT
  PRINT
  INPUT "Do you want to add a comment for each character (Y/N)"; QC$

  PRINT
  PRINT "** Values in brackets () are recommended values! **"
  PRINT
  PRINT "Enter character range to export (0 to 255):"
  INPUT "From (32):"; SC
  INPUT "To  (126):"; EC
  PRINT
  INPUT "Do you want to (D)isplay or (E)xport (D/E)"; Q2$: Q2$ = UCASE$(Q2$)
  IF Q2$ = "E" THEN
    PRINT "Enter Font name   : ";
    LINE INPUT Fout$: IF Fout$ = "" THEN END
  END IF

  INPUT "First scanline (1)"; FSL
  INPUT "Font Height    (5)"; FontH
  IF FontH < 1 OR FontH > 16 THEN PRINT "Must be 1 to 16!": END
  
  
  CALL GetFontAddress(BPC, FontSeg, FontAdrs)

  DEF SEG = FontSeg
  FOR Asci = 0 TO 255
    Font$(Asci) = ""
    TAdrs = FontAdrs + (Asci * BPC)
    FOR Byte = 0 TO BPC - 1
      Font$(Asci) = Font$(Asci) + CHR$(PEEK(Byte + TAdrs))
    NEXT
  NEXT

  IF Q2$ = "E" THEN
    OPEN Fout$ FOR OUTPUT AS 1
    PRINT #1, FontH; ","; (EC - SC) + 1; Opt$
    PRINT #1, "; Font for SJGPlay created by FONTEX (C)1996 Steve J. Gray"
  END IF

  FOR Asci = SC TO EC
    GOSUB MakeBits
    GOSUB ClearOut
    SELECT CASE Q$
      CASE "N": GOSUB Normal
      CASE "H": GOSUB Half
      CASE "S": GOSUB Custom
    END SELECT
    IF UCASE$(QC$) = "Y" THEN GOSUB Comment
    GOSUB PutOut
  NEXT Asci
  IF Q2$ = "E" THEN CLOSE : PRINT Fout$; " has been created!"
  END

'----------------------------------------------------------------------
MakeBits:
 FOR T = 1 TO 16: Bit$(T) = "": NEXT 'clear bit string
 FOR R = 1 TO BPC
   B = 128: L$ = ""
   FOR P = 1 TO 8
     V = ASC(MID$(Font$(Asci), R, 1))
     IF (V AND B) = 0 THEN L$ = L$ + UnLit$ ELSE L$ = L$ + Lit$
     B = B / 2
   NEXT P
   Bit$(R) = L$
 NEXT R
 RETURN

ClearOut: FOR A = 1 TO 16: Out$(A) = "": NEXT: O = 1: RETURN

Normal:
 FOR R = FSL TO BPC
  Out$(O) = Bit$(R): O = O + 1
 NEXT
 RETURN

Half:
 FOR R = FSL TO BPC STEP 2: L$ = ""
   FOR C = 1 TO 8
     V1 = 0: V2 = 0
     IF MID$(Bit$(R), C, 1) = Lit$ THEN V1 = 1
     IF MID$(Bit$(R + 1), C, 1) = Lit$ THEN V2 = 2
     L$ = L$ + MID$(Cout$, V1 + V2 + 1, 1)
   NEXT C
   Out$(O) = L$: O = O + 1
 NEXT
 RETURN

Custom:
 FOR R = FSL TO BPC STEP 2: L$ = ""
   FOR C = 1 TO 8 STEP 2
     V1 = 0: V2 = 0: V3 = 0: V4 = 0
     IF MID$(Bit$(R), C, 1) = Lit$ THEN V1 = 1
     IF MID$(Bit$(R), C + 1, 1) = Lit$ THEN V2 = 2
     IF MID$(Bit$(R + 1), C, 1) = Lit$ THEN V3 = 4
     IF MID$(Bit$(R + 1), C + 1, 1) = Lit$ THEN V4 = 8
     L$ = L$ + MID$(Cout$, V1 + V2 + V3 + V4 + 1, 1)
   NEXT C
   Out$(O) = L$: O = O + 1
 NEXT
 RETURN

Comment:
  L$ = "; ASCII" + STR$(Asci)
  IF (Asci > 31) AND (Asci < 127) AND (Asci <> 34) AND (Asci <> 44) THEN L$ = L$ + " - " + CHR$(Asci)
  IF Q2$ = "D" THEN PRINT L$;  ELSE PRINT #1, L$
  RETURN

PutOut:
 FOR A = 1 TO FontH
  IF Q2$ = "D" THEN
    PRINT Out$(A)
  ELSE
    PRINT #1, CHR$(34) + Out$(A) + CHR$(34)
  END IF
 NEXT A
 RETURN

SUB GetFontAddress (BPC, FontSeg, FontAdrs)

  'Returns the address of a specified character table in ROM based
  ' on BPC


  Registers.AX = &H1130            'Service 11H, subservice 30H

  SELECT CASE BPC
   CASE 16                         '16 byte, VGA 25-line mode
     Registers.BX = &H600          'BH = 06H gets 8x16 character set

   CASE 14                         '14 byte, EGA 25-line mode
     Registers.BX = &H200          'BH = 02H gets 8x14 character set

   CASE 8                          '8 byte, 43- or 50-line mode
     Registers.BX = &H300          'BH = 03H gets 8x8 character set

  END SELECT

  '---- Call Video BIOS interrupt &H10
  CALL InterruptX(&H10, Registers, Registers)

  FontSeg = Registers.ES           'Segment address of beginning of table
  FontAdrs = Registers.BP          'Offset address of beginning of table

END SUB

FUNCTION Monitor% STATIC

  ' Returns the adapter/monitor combination of the active display where:
  '
  '   1 = MDA, Hercules, or EGA adapter with monochrome TTL display
  '   2 = CGA or EGA adapter with CGA color TTL display
  '   3 = EGA adapter with EGA TTL color display
  '   4 = VGA adapter with analog color display
  '   5 = VGA adapter with analog monochrome display

  DEF SEG = 0
  IF PEEK(&H463) = &HB4 THEN MonType = 1 'If current base is monochrome
                                         ' assume TTL display

  Registers.AX = &H1A00                  'Test for VGA ROM
  CALL Interrupt(&H10, Registers, Registers)

  'If VGA adapter is present and if VGA is active
  IF (Registers.AX AND &HFF) = &H1A AND (PEEK(&H487) AND &H8) = 0 THEN

    IF MonType = 1 THEN         'Then monochrome would be
      MonType = 5               ' a monochrome VGA
    ELSE
      MonType = 4               'Otherwise it's a color VGA
    END IF

  ELSEIF MonType <> 1 THEN      'If monochrome is current, we're done

    MonType = 2                 'Assume a CGA or EGA adapter with CGA adapter
    Registers.AX = &H1200       'See if an EGA adapter is present
    Registers.BX = &H10
    CALL Interrupt(&H10, Registers, Registers)

    IF (Registers.BX AND &HFF) <> &H10 THEN  'If BL is changed, EGA is present
      EGAMonitor = Registers.CX AND &HFF     'If 6 or 9, monitor is enhanced
      IF (EGAMonitor = 6) OR (EGAMonitor = 9) THEN MonType = 3
    END IF

  END IF

  Monitor% = MonType            'Assign the function output

END FUNCTION

