#include "kernel.h"
#include "widget.h"
#include "slider.h"

l_ulong	AppVersion = ULONG_ID(0,0,0,1);
l_char	AppName[] = "Slider Widget";
l_uid	nUID = "slider";
l_uid NeededLibs[] = { "widget", "skin","" };

PSkin SkinSliderLine	= 0;
PSkin SkinSliderBackground	= 0;
PSkin SkinSliderButton	= 0;

#define DOING_DRAG 1

TPoint p;
l_int Doing = 0;

void SliderDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	DrawSkin(buffer, SkinSliderBackground, o->Absolute.a.x, o->Absolute.a.y, o->Absolute.b.x, o->Absolute.b.y);
	DrawSkin(buffer, SkinSliderLine, o->Absolute.a.x+10, o->Absolute.a.y+((o->Absolute.b.y-o->Absolute.a.y)/2-SkinSliderLine->Skin->h/2), o->Absolute.b.x-10, o->Absolute.a.y+((o->Absolute.b.y-o->Absolute.a.y)/2+SkinSliderLine->Skin->h/2));

	if (Doing){
		if (o->Absolute.a.x+10 + (((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps) + (Mouse->State.p.x-p.x) <= o->Absolute.b.x-10){

			if (o->Absolute.a.x+10 + (((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps) + (Mouse->State.p.x-p.x) >= o->Absolute.a.x+10)
				DrawSkin(buffer, SkinSliderButton, o->Absolute.a.x+10 +(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps) + (Mouse->State.p.x-p.x)-SkinSliderButton->Skin->w/2, o->Absolute.a.y+SkinSliderBackground->Top, o->Absolute.a.x+10 + (Mouse->State.p.x-p.x)+(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps)+SkinSliderButton->Skin->w/2, o->Absolute.b.y - SkinSliderBackground->Bottom);
			else
				DrawSkin(buffer, SkinSliderButton, o->Absolute.a.x+10-SkinSliderButton->Skin->w/2, o->Absolute.a.y+SkinSliderBackground->Top, o->Absolute.a.x+10+SkinSliderButton->Skin->w/2, o->Absolute.b.y-SkinSliderBackground->Bottom);
		}
		else
			DrawSkin(buffer, SkinSliderButton, o->Absolute.b.x-10-SkinSliderButton->Skin->w/2, o->Absolute.a.y+SkinSliderBackground->Top, o->Absolute.b.x-10+SkinSliderButton->Skin->w/2, o->Absolute.b.y - SkinSliderBackground->Bottom);
	}
	else
		DrawSkin(buffer, SkinSliderButton, o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps)-SkinSliderButton->Skin->w/2, o->Absolute.a.y+SkinSliderBackground->Top, o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps)+SkinSliderButton->Skin->w/2, o->Absolute.b.y - SkinSliderBackground->Bottom);
}

l_bool SliderEventHandler ( PWidget o, PEvent Ev )
{
	TRect tmp;

	if (Ev->Type == EV_MOUSE)
	{
		if (Mouse->State.b & BUTTON_LEFT && Doing == DOING_DRAG){
			WidgetDraw(o, NULL);
			return true;
		}

		if (Ev->Message == WEvMouseLUp){
			if (Doing){

				if (o->Absolute.a.x+10 + (((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps) + (Mouse->State.p.x-p.x) <= o->Absolute.b.x-10){
					if (o->Absolute.a.x+10 + (((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps) + (Mouse->State.p.x-p.x) >= o->Absolute.a.x+10)
					{//find closest step

					}
					else
						SLIDER(o)->Value = 0;
				}
				else
					SLIDER(o)->Value = SLIDER(o)->Steps;

				MasterWidget = NULL;
				Doing = 0;

				return true;
			}
		}

		if (Ev->Message == WEvMouseLDown)
		{
			RectAssign(&tmp, o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps)-SkinSliderButton->Skin->w/2, o->Absolute.a.y+((o->Absolute.b.y-o->Absolute.a.y)/2-SkinSliderButton->Skin->h/2), o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-20)*(SLIDER(o)->Value))/SLIDER(o)->Steps)+SkinSliderButton->Skin->w/2, o->Absolute.a.y+((o->Absolute.b.y-o->Absolute.a.y)/2+SkinSliderButton->Skin->h/2));
			if (CURSOR_IN_RECT(tmp)){
				p = Mouse->State.p;
				MasterWidget = o;
				Doing = DOING_DRAG;

				return true;
			}
			else if (Mouse->State.p.x < o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-10)*(SLIDER(o)->Value))/SLIDER(o)->Steps))
			{
				if ( (SLIDER(o)->Value - 1) != -1 )
				{
					SLIDER(o)->Value--;
					WidgetDraw(o, NULL);
					return true;
				}
			}
			else if (Mouse->State.p.x > o->Absolute.a.x+10+(((o->Absolute.b.x-o->Absolute.a.x-10)*(SLIDER(o)->Value))/SLIDER(o)->Steps))
			{
				if ( (SLIDER(o)->Value + 1) <= SLIDER(o)->Steps )
				{
					SLIDER(o)->Value++;
					WidgetDraw(o, NULL);
					return true;
				}
			}
		}
	}

	return false;
}

PSlider CreateSlider( PApplication App, TRect r, l_ulong Steps )
{
	PSlider p = malloc(sizeof(TSlider));

	if (!p) return NULL;

	memset(p, 0, sizeof(TSlider));

	p->Steps = Steps;

	IntialiseWidget(App, WIDGET(p), r, "Slider");

	WIDGET(p)->Draw = &SliderDraw;
	WIDGET(p)->EventHandler = &SliderEventHandler;

	return p;
}

l_bool LibMain ( l_text Args )
{
	/**
	*	Skin items sizes
	*/
	SkinSliderLine			= GetSkinItem("SliderLine");
	SkinSliderButton		= GetSkinItem("SliderButton");
	SkinSliderBackground	= GetSkinItem("SliderBackground");

	APPEXPORT(CreateSlider);
/*
	TRect r; RectAssign(&r, 750,300,1000,340);
	PSlider p = CreateSlider(&Me, r);
	InsertWidget(WIDGET(DeskTop), WIDGET(p));
	WidgetDraw(WIDGET(p), NULL);
*/
	return true;
}

void Close (void)
{

}
