/*
 * four-in-a-row game
 * Copyright (c) 2017-2018,2022 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* SPDX-License-Identifier: AGPL-3.0-or-later */

/*
For Unix, Windows and DOS
This is an exercise in retroprogramming.
The text version can be compiled for 16-bit DOS with bcc - Bruce's C compiler.
*/

#ifndef __ROW4_H
#define __ROW4_H

#define FALSE 0
#define TRUE 1

#define NONE 0
#define PLAYER1 1
#define PLAYER2 2
#define BOTH 3

#define MOD_VT100 0
#define MOD_ASCII 1
#define MOD_UTF8 2

#ifdef __STDC__
#define P_(x) x
#else /* no prototypes */
#define P_(x) ()
#define const
#define volatile
#endif

#define LANGUAGES 3

enum languages
{ unknown_language, english, deutsch, esperanto };

struct messages
{
  const char *title, *copyright, *license_text, *optionerror;
  const char *key, *win, *new_start, *language_name;
  const char *player_1, *player_2, *license, *quit;
  enum languages language;
};

typedef unsigned char byte;

extern struct messages msg;

/*
The board is defined as follows:
Positions are internally x: 0-6, y: 0-5, with 0,0 is bottom left.
The lower 2 bit are the chips, 1 or 2.
The next 2 bit are threats, 1 or 2 or 3 for both.
A field with a chip is never a threat.
*/
extern byte board[7][6], filled[7];
extern short int chips;

/* get player from definition */
#define get_player(x) ((x) & 3)
#define threatened(x) ((x) > 3)

/* is the position outside the board? */
#define outside(x,y)  (0 > (x) || (x) > 6 || 0 > (y) || (y) > 5)

/* is this slot full? */
#define full(x) (filled[x] >= 6)

/* convert between digit and ASCII (0-9) */
#define digit(x) ((x) ^ 0x30)

extern int run P_((int, char *[]));
extern void messages P_((enum languages));
extern void next_language P_((void));
extern enum languages system_language P_ ((void));


/*
 * logics
 */

/* initialize or clear board */
void reset_board P_((void));

/* make a move - returns y or -1 */
int drop P_((int player, int x));

/* check if last move wins - returns TRUE or FALSE */
int wincheck P_((void));

/* returns x or -1 */
int compute P_((int player));


/*
 * user interface
 */

/* initialize the output */
void initialize P_((int));

/* returns 1 or 2 */
int ask_players P_((void));

void draw_board P_((void));

/* puts chip for player in specified position */
void chip P_((int x, int y, int player));

/* returns slot number, or -1 */
int ask_slot P_((int player));

/* show that the player has won */
void win P_((int player));

#endif
