/*
 * four-in-a-row game: messages
 * Copyright (c) 2017-2019,2022,2023 Andreas K. Foerster
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* SPDX-License-Identifier: AGPL-3.0-or-later */

/*
 * Note: this is not used for the CGI-program.
 */

#include <stdlib.h>
#include <strings.h>
#include "row4.h"

struct messages msg;


extern void
next_language ()
{
  enum languages l;

  l = (msg.language + 1) % (LANGUAGES + 1);

  if (unknown_language == l)
    ++l;

  messages (l);
}


#if defined(_WIN32) || defined(__WIN32__) || defined(__WINDOWS__)
#include <winnls.h>

extern enum languages
system_language ()
{
  LANGID l;

  l = GetUserDefaultLangID ();

  switch (PRIMARYLANGID (l))
    {
    case LANG_ENGLISH:
      return english;

    case LANG_GERMAN:
      return deutsch;
    }

  return unknown_language;
}

#else /* not Windows */

/* this is the Unix way */
extern enum languages
system_language ()
{
  const char *l;

  if (!(l = getenv ("LC_ALL")) && !(l = getenv ("LC_MESSAGES"))
      && !(l = getenv ("LANG")))
    return unknown_language;

  if (!strncasecmp (l, "en", 2))
    return english;

  if (!strncasecmp (l, "de", 2))
    return deutsch;

  if (!strncasecmp (l, "eo", 2))
    return esperanto;

  return unknown_language;
}

#endif /* not Windows */
