/* SPDX-License-Identifier: CC0-1.0 */
/*
 * geschrieben von Andreas K. Foerster <http://akfoerster.de>
 * Lizenz: CC0
 * https://creativecommons.org/publicdomain/zero/1.0/deed.de
 */

#include <stdio.h>

int
main (int argc, char *argv[])
{
  FILE *d;
  unsigned int nr;
  int c;

  d = NULL;
  if (argc == 3)
    d = fopen (argv[2], "rb");

  if (!d)
    {
      fprintf (stderr, "%s name file\n", argv[0]);
      return 1;
    }

  printf ("const unsigned char %s[] = {", argv[1]);

  nr = 0;
  while ((c = getc (d)) != EOF)
    {
      if (nr != 0)
	putchar (',');

      if (nr % 18 == 0)
	putchar ('\n');

      printf ("%3d", c);
      ++nr;
    }

  fclose (d);
  printf ("\n};\nconst unsigned int %s_len = %u;\n\n", argv[1], nr);

  return 0;
}
