; Copyright (C) 2018 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; FORWARD -- Macro definitions
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

%idefine MAX_DRIVE_ATTEMPTS   3 ; Disk operation max retries, before error
                                ; DOS manual says try 3 times before failing

%imacro DriveMapToLetter 0-1 dl
    %ifnidni %1, dl
        push        dx
        mov         dl, %1
    %endif

        cmp         dl, 1
        jna         %%FloppyDrive
        sub         dl, 0x7e
    %%FloppyDrive:
        add         dl, 0x41

    %ifnidni %1, dl
        mov         %1, dl
        pop         dx
    %endif
%endmacro

%imacro DriveMapFromLetter 0-1 dl
    %ifnidni %1, dl
        push        dx
        mov         dl, %1
    %endif

        cmp         dl, 0x4a
        jna         %%UpperCase
        sub         dl, 0x20
    %%UpperCase:
        cmp         dl, 0x41
        jb          %%Invalid
        cmp         dl, 0x5a
        jna         %%ValidLetter
    %%Invalid:
        mov         dl, 0x41
    %%ValidLetter:
        sub         dl, 0x41
        cmp         dl, 1
        jna         %%FloppyDrive
        add         dl, 0x7e
    %%FloppyDrive:


    %ifnidni %1, dl
        mov         %1, dl
        pop         dx
    %endif
%endmacro

%imacro DriveGetParams 0-1 dl
    %ifnidni    %1, dl
        mov     dl, %1
    %endif
    mov         ah, 0x08
    int         0x13
    ; CF = 1 if error, 0 if successful
    ; AH = Status Code
    ; BL = Drive Type
    ; CH = Cylinders 0-1023 (2-high bits of CL)
    ; CL = Sectors per track (6-bits)
    ; DH = Sides
    ; DL = Number of drives attached
    ; ES:DI = Pointer to Disk Base Table
%endmacro

%imacro DriveTestReady 0-1 dl
    %ifnidni    %1, dl
        mov     dl, %1
    %endif
    mov         ah, 0x10
    int         0x13
    ; CF = 1 if error, 0 if successful
    ; AH = Status Code
%endmacro

%imacro DriveReset 0-1 dl
    %ifnidni    %1, dl
        mov     dl, %1
    %endif
    mov         ah, 0x00
    int         0x13
%endmacro

; db Drive, db Head, dw Track, db Sector, db Count, dw Buffer
%imacro ReadDriveSector 6

    %idefine REQUIRE_ReadDriveSector
    mpush       bx, cx, dx

;   AH = 02
;   AL = count of sectors to read
;	ES:BX = pointer to buffer

    xor         ax, ax
    mov         [DATA_ReadDriveSector], ax
%%DriveRead:
    mov         dl, %1
    mov         dh, %2
    mov         ax, %3
    xchg        al, ah
    mov         cl, 0x06
    shl         al, cl
    mov         cl, %4
    inc         cl
    xor         ch, ch
    or          cx, ax
    mov         al, %5
    mov         bx, %6
    mov         ah, 0x02
    int         0x13
    jnc         %%DriveReadDone
    pushf
    push        ax
    mov         ax, [DATA_ReadDriveSector]
    inc         ax
    mov         [DATA_ReadDriveSector], ax
    cmp         ax, MAX_DRIVE_ATTEMPTS
    pop         ax
    ja          %%DriveReadFailed
    popf
    mov         ah, 0x00
    int         0x13
    jmp         %%DriveRead
%%DriveReadFailed:
    popf
%%DriveReadDone:
    mpop        bx, cx, dx

%endmacro

%endif

; -----------------------------------------------------------------------------
; CODE - Forward macro support code
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_CODE


%endif

; -----------------------------------------------------------------------------
; String and general resource area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_RESOURCES

%endif

; -----------------------------------------------------------------------------
; Miscellaneous data area for built in macros
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_DATA

%endif

; -----------------------------------------------------------------------------
; Begin uninitialized data section
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_BSS

%ifdef REQUIRE_ReadDriveSector
DATA_ReadDriveSector:
    db 0
%endif

%endif
