;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Store_Date                  ;
; Store the time and date to DATE_BUFF given    ;
; hours and minutes in AX, month and day in DX, ;
; and year in CX. All values should be set as   ;
; returned by the DOS date and time function    ;
; calls.                                        ;
;===============================================;

Store_Date Proc Near
 Push Ax
 Push Cx
 Push Dx

 Mov Di,Date_Buff       ;storage
 Inc Di                 ;room for length

;----- time

;----- hours

 Mov Bp,Sp
 Mov Al,[Bp+5]          ;hours

 Or Al,Al               ;check if 12am to 12:59am
 Jnz Sthourok1          ;jump if not
 Mov Al,12              ;set to 12

Sthourok1 Cmp Al,13     ;check if next half
 Jb Sthourok2           ;jump if not
 Sub Al,12              ;reset half

Sthourok2 Sub Ah,Ah     ;clear high part
 Mov Cx,10              ;base ten
 Call Store_Num         ;store number

 Mov Al,':'             ;colon
 Stosb

;----- minutes

 Mov Bp,Sp
 Mov Al,[Bp+4]          ;minutes
 Sub Ah,Ah              ;clear high part
 Mov Cx,10              ;base ten
 Mov Dx,0230h           ;length 2, buffer with '0' (30H)
 Call Store_Fnum        ;store number

 Mov Al,' '             ;space
 Stosb                  ;store

;----- am/pm

 Mov Bp,Sp
 Mov Al,[Bp+5]          ;hours
 Mov Si,Offset Pm_String ;pm
 Cmp Al,12              ;check after noon
 Jae Ampmstor           ;jump if so
 Mov Si,Offset Am_String ;am

Ampmstor Store_Str      ;move string

 Mov Ax,202ch           ;comma and space
 Stosw                  ;store

;----- date

;----- month

 Mov Bp,Sp
 Mov Bl,[Bp+1]          ;month
 Sub Bh,Bh
 Dec Bx                 ;make scale 0 to 11
 Shl Bx                 ;relative offset
 Mov Si,[Headmonth+Bx]  ;month location
 Store_Str              ;move string

 Mov Al,' '             ;space
 Stosb                  ;store

;----- day

 Mov Bp,Sp
 Mov Al,[Bp]            ;day
 Sub Ah,Ah              ;clear high part
 Mov Cx,10              ;base ten
 Call Store_Num         ;store number

 Mov Ax,202ch           ;comma and space
 Stosw                  ;store

;----- year

 Mov Bp,Sp
 Mov Ax,[Bp+2]          ;year
 Mov Cx,10              ;base ten
 Call Store_Num         ;store number

;----- finished

 Mov Ax,Date_Buff       ;string location
 Mov Si,Ax
 Sub Di,Ax              ;length including length byte
 Dec Di                 ;remove length byte
 Mov Ax,Di
 Mov [Si],Al            ;store length

 Pop Dx
 Pop Cx
 Pop Ax
 Ret

;----- data

Pm_String Db 2,'pm'
Am_String Db 2,'am'

Headmonth Dw Offset Month01,Offset Month02,Offset Month03
 Dw Offset Month04,Offset Month05,Offset Month06
 Dw Offset Month07,Offset Month08,Offset Month09
 Dw Offset Month10,Offset Month11,Offset Month12

Month01 Db 7,'January'
Month02 Db 8,'February'
Month03 Db 5,'March'
Month04 Db 5,'April'
Month05 Db 3,'May'
Month06 Db 4,'June'
Month07 Db 4,'July'
Month08 Db 6,'August'
Month09 Db 9,'September'
Month10 Db 7,'October'
Month11 Db 8,'November'
Month12 Db 8,'December'
 Endp                   ;Store_Date

;===============================================;
;                  Store_Hnum                   ;
; Store the number in BX to DI given the type   ;
; in AX. Four hexadecimal digits, right         ;
; justified, buffered zeros, checks for         ;
; undefined type (makes number "????" if so).   ;
;===============================================;

Store_Hnum Proc Near
 Test Ax,Undef          ;check if undefined
 Jnz Hnundef

;----- normal value

 Mov Ax,Bx
 Mov Cx,16              ;base 16
 Mov Dx,0430h           ;length 4, buffer with '0'
 Call Store_Fnum        ;formated number output
 Ret

;----- undefined value

Hnundef Mov Al,'?'      ;question mark for undefined value
 Mov Cx,4               ;one for each digit
 Rep
 Stosb                  ;store
 Ret
 Endp                   ;Store_Hnum

;===============================================;
;                  Store_Fnum                   ;
; Outputs the ASCII characters representing     ;
; the (unsigned) number in AX to the location   ;
; in DI. The number is formatted with the       ;
; character in DL and the total length of the   ;
; output string must be in DH and the base in   ;
; CX.                                           ;
;===============================================;

Store_Fnum Proc Near
 Push Si

;----- translate number

 Push Di
 Push Dx
 Call Number_Con        ;make into ASCII string
 Pop Dx
 Pop Di

;----- store buffer characters

 Mov Si,Num_Buff        ;number string location
 Lodsb                  ;get length
 Mov Ah,Al              ;save length in AH

 Mov Cl,Dh              ;total length
 Sub Cl,Al              ;subtract number length
 Sub Ch,Ch              ;CX has bytes to buffer

 Mov Al,Dl              ;buffer character
 Rep
 Stosb                  ;store characters

;----- move string

 Mov Cl,Ah
 Sub Ch,Ch              ;CX has length
 Rep
 Movsb                  ;move string

 Pop Si
 Ret
 Endp                   ;Store_Fnum

;===============================================;
;                   Store_Num                   ;
; Store the number in AX as its ASCII form to   ;
; DI. CX must contain number base. DL returns   ;
; length.                                       ;
;===============================================;

Store_Num Proc Near
 Push Di
 Call Number_Con        ;make into ASCII string
 Pop Di

 Mov Si,Num_Buff        ;string location
 Mov Dl,[Si]            ;length
 Store_Str              ;move string
 Ret
 Endp                   ;Store_Num

;===============================================;
;                  Number_Con                   ;
; Converts the number in AX to an ASCII string. ;
; The base is in CX, the string (preceeded by   ;
; the length) is put in NUM_BUFF.               ;
;===============================================;

Number_Con Proc Near
 Mov Bx,Offset Hexbase  ;ASCII digits
 Mov Di,Num_Buff        ;number buffer location
 Mov Si,Di
 Inc Di

;----- loop for each digit

Numloop Sub Dx,Dx
 Div Ax,Cx              ;divide to get remainder
 Push Ax                ;quotient
 Mov Al,Dl              ;remainder
 Xlat                   ;get character
 Stosb                  ;store it
 Pop Ax                 ;restore quotient
 Or Ax,Ax
 Jnz Numloop

;----- done with number

 Dec Di                 ;last digit
 Mov Ax,Di
 Sub Ax,Si              ;AX has length
 Xchg Si,Di             ;SI points to end, DI points to beginning
 Stosb                  ;store length

 Mov Cl,Al
 Sub Ch,Ch              ;length in CX
 Shr Cx                 ;CX/2
 Jz Numdon

;----- reverse digits

Nrevloop Mov Al,[Di]    ;load front character
 Xchg Al,[Si]           ;swap with end character
 Stosb                  ;store new front character
 Dec Si                 ;back up
 Loop Nrevloop          ;loop back for each digit
Numdon Ret
 Endp                   ;Number_Con

;===============================================;
;                   Tab_Look                    ;
; Looks through the table at DI for the string  ;
; at SI. If found BX returns number in table    ;
; and carry is set. The table is a list of      ;
; strings preceded byte a byte length. The      ;
; table is ended with a byte 0.                 ;
;===============================================;

Tab_Look Proc Near
 Push Si
 Sub Bx,Bx
 Mov Ch,Bh              ;clear CH too
 Mov Bp,Si              ;SI saved in BP

;----- loop until match is found or end of table

Tabloop Mov Cl,[Di]     ;length
 Or Cl,Cl               ;check for zero (end)
 Jz Nottab              ;jump if end
 Inc Cx                 ;characters to compare

 Repe
 Cmpsb                  ;compare

 Je Tabop               ;jump if found
 Inc Bx                 ;next entry
 Add Di,Cx              ;add remaining characters
 Mov Si,Bp              ;restore SI
 Jmps Tabloop           ;back to try next one

;----- not found

Nottab Pop Si
 Clc                    ;clear carry
 Ret

;----- found

Tabop Pop Si
 Stc                    ;set carry
 Ret
 Endp                   ;Tab_Look

;===============================================;
;                   Comp_Astr                   ;
; Compare the two strings at ES:DI and DS:SI    ;
; alphabetically. The flags are returned as if  ;
; the two strings could be compared:            ;
;          CMP STRING [DI],STRING [SI]          ;
; Underscores are ignored, thus 'A_A' and 'AA'  ;
; would be considered equal.                    ;
;===============================================;

Comp_Astr Proc Near
 Push Di
 Push Si

 Seg Es                 ;ES segment
 Mov Ch,[Di]            ;load length
 Inc Di                 ;increment pointer
 Mov Cl,[Si]            ;load length
 Inc Si                 ;increment pointer

;----- get next character at DI

Cachkdi Or Ch,Ch        ;check if done
 Jnz Nocadidon          ;jump if not
 Mov Ah,' '             ;make space
 Jmps Cachksi

Nocadidon Seg Es        ;ES segment
 Mov Ah,[Di]            ;load next character
 Inc Di                 ;increment pointer
 Dec Ch                 ;decrement characters remaining

 Cmp Ah,'_'             ;check if underscore
 Je Cachkdi             ;jump if so, get next character

;----- get next character at SI

Cachksi Or Cl,Cl        ;check if done
 Jnz Nocasidon          ;jump if not
 Mov Al,' '             ;make space
 Jmps Cacmp

Nocasidon Mov Al,[Si]   ;load next character
 Inc Si                 ;increment pointer
 Dec Cl                 ;decrement characters remaining

 Cmp Al,'_'             ;check if underscore
 Je Cachksi             ;jump if so, get next character

;----- compare characters

Cacmp Cmp Ah,Al         ;compare
 Je Caequal             ;jump if equal, try next characters
 Pop Si
 Pop Di
 Ret

;----- characters equal

Caequal Or Cx,Cx        ;check if no bytes remaining
 Jnz Cachkdi            ;next bytes if not
 Cmp Al,Al              ;reset flags to equal
 Pop Si
 Pop Di
 Ret
 Endp                   ;Comp_Astr

