;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                    Pmacro                     ;
; Handles start macro definition (MACRO)        ;
; pseudo-op. Begins a macro definition.         ;
;===============================================;

Pmacro Proc Near
 Or Mac_Stat,Mac_Def    ;flag on
 And Oprnd_Stat,Not Oprnd_End ;clear end of operand, only bit used
 Cmp Pass,0             ;check if pre-assembly
 Jne Macaeloop          ;jump if not, just check for flag

;----- pre-assembly, advance data pointer

 Mov Ax,Mac_Point       ;start of data
 Mov Mac_End,Ax         ;save
 Inc Ax
 Inc Ax                 ;skip a word for the pointer to the end
 Mov Mac_Point,Ax       ;save pointer

;----- load arguments

 Sub Bx,Bx              ;initial argument number

Macarloop Push Bx
 Call Get_Oprnd         ;get operand
 Pop Bx
 Jc Macardel            ;jump if delimiter
 Jz Macardone           ;jump if no operand returned

 Push Bx
 Mov Si,Tempbuff        ;source
 Call Mac_PLabel        ;make unique
 Call Add_Sym           ;into symbol table
 Pop Bx

 Mov Ax,Mlabel+Marg     ;type
 Sub Cx,Cx              ;size not used
 Call Put_Sym2          ;reset symbol
 Jmps Macarloop

;----- special delimiter

Macardel Cmp Al,','     ;check if comma
 Jne Macarloop          ;jump if not, illegal delimiter ignored
 Inc Bx                 ;increment argument number
 Jmps Macarloop

Macardone Ret

;----- flag any errors in argument list and advance symbol pointers

Macaeloop Call Get_Oprnd ;get operand
 Jc Macaedel            ;jump if delimiter
 Jz Macaedone           ;jump if no operand returned

;----- advance symbol table pointer

 Push Ds
 Mov Di,Osym_Point      ;symbol pointer
 Mov Ds,Sym_Seg         ;symbol table segment

 Mov Al,[Di]            ;length
 Sub Ah,Ah
 Add Di,Ax              ;pointer past symbol
 Inc Di                 ;include length byte

 Mov Dx,[Di+4]          ;get type

 Pop Ds
 Add Di,6               ;skip data
 Mov Osym_Point,Di      ;save pointer

 Cmp Pass,2             ;check if pass two
 Jne Macaeloop          ;jump if not, only test on pass two

;----- test label

 Test Dx,Badsym         ;test if invalid symbol
 Jnz Minverror
Mgpechkc Test Dx,Dupdef ;test if duplicate definition
 Jnz Mduperror
 Jmps Macaeloop

;----- invalid character in symbol error

Minverror Mov Si,Tempbuff ;source location
 Mov Ax,0488h           ;error 136
 Call Error             ;error routine
 Jmps Mgpechkc          ;jump back to check for duplicate def.

;----- duplicate definition error

Mduperror Mov Si,Tempbuff ;source location
 Mov Ax,043ch           ;error 60
 Call Error             ;error routine
 Jmps Macaeloop

;----- special delimiter

Macaedel Cmp Al,','     ;check if comma
 Je Macaeloop           ;jump if so, otherwise illegal character

 Mov Dl,Al              ;illegal character
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Jmps Macaeloop

;----- check for label

Macaedone And Line_Stat,Not Loc_Flag ;no location display, even though symbol
 Test Line_Stat,Label_Flag ;check if label
 Jz Maclaber            ;jump if none
 Ret

;----- missing label

Maclaber Mov Ax,008bh   ;error 139
 Call Error             ;error routine
 Ret
 Endp                   ;Pmacro

;===============================================;
;                     Pendm                     ;
; Handles end macro definition (ENDM)           ;
; pseudo-op. Ends a macro definition.           ;
;===============================================;

Pendm Proc Near
 Test Mac_Stat,Mac_Def  ;check if defining
 Jz Endmerr             ;jump if not

 Cmp Pass,0             ;check if pre-assembly
 Jne Noemac             ;jump if not

;----- set end of macro pointer in macro table

 Mov Ax,Mac_Point       ;present pointer value
 Mov Bx,Mac_End         ;saved start of data
 Push Ds
 Mov Ds,Mac_Seg         ;macro data segment
 Mov [Bx],Ax            ;save end of data to first word
 Pop Ds

Noemac And Mac_Stat,Not Mac_Def ;clear definition flag
 Inc Mac_Number1        ;increment definition number for next macro
 Ret

;----- not presently defining

Endmerr Mov Ax,0089h    ;error 137
 Call Error             ;error routine
 Ret
 Endp                   ;Pendm

;===============================================;
;                   Init_Mac                    ;
; Initialize macro call. Gets operands          ;
; (passed parameters) to the macro.             ;
;===============================================;

Init_Mac Proc Near
 Call Push_Mac          ;push macro level
 Jc Mgmacerr            ;jump if too deep

 Test Optype1,Start_Cmac ;test if conditional macro
 Jz Imacnoc             ;jump if not
 Mov Prt_Flag,Hide      ;hide line
 And Opt_Stat,Not Exp_Flag ;no expansion

Imacnoc Mov Bx,Omac_Loc ;look up table
 Mov Di,Omac_Max        ;maximum table entries
 Shl Di                 ;two bytes for each entry
 Add Di,Bx              ;parameter data area
 Sub Cx,Cx              ;initial operand count
 Push Bx                ;save start of macro table

;----- loop for each field found after the macro invocation

Macinitl Push Bx
 Push Cx
 Push Di
 Call Get_Mfield        ;get macro field
 Pop Di
 Pop Cx
 Pop Bx
 Jc Macinitdon

;----- put field into data table

 Cmp Cx,Omac_Max        ;check if too many operands
 Je Maciniterr          ;jump if so

 Mov [Bx],Di            ;save look up location
 Inc Bx
 Inc Bx                 ;advance table pointer
 Inc Cx                 ;anther field

 Push Cx
 Mov Si,Mac_Buff        ;source location
 Copy_Str               ;move string
 Pop Cx
 Jmps Macinitl

;----- macros nested too deep

Mgmacerr Mov Bx,Nmac_Max ;max nest level
 Mov Ax,0206h           ;error 6
 Call Error             ;error routine
 Clc                    ;clear carry
 Ret

;----- finished with parameters

Macinitdon Pop Bx
 Mov Omac_Table,Bx      ;set parameter table
 Mov Omac_Num,Cx        ;save number of operands
 Mov Omac_Loc,Di        ;save parameter data pointer

;----- set definition and expansion numbers

 Mov Ax,Macro_Num       ;get definition number
 Mov Mac_Number1,Ax     ;set
 Mov Ax,Mac_Number3     ;expansion number
 Inc Ax                 ;increment
 Mov Mac_Number3,Ax     ;save
 Mov Mac_Number2,Ax     ;set present

;----- start new macro

 Or Mac_Stat,Mac_Flag   ;set flag
 Or Line_Stat,Mac_Line  ;set macro line flag

 Mov Si,Macro_Sta       ;get start location
 Push Ds
 Mov Ds,Mac_Seg         ;macro segment
 Lodsw                  ;load end of macro location
 Pop Ds

 Mov Mac_Loc,Si         ;start of macro
 Mov Mac_End,Ax         ;end of macro
 Ret

;----- too many operands

Maciniterr Mov Bx,Cx
 Mov Ax,0203h           ;error 3
 Call Error             ;error routine
 Jmps Macinitdon
 Endp                   ;Init_Mac

;===============================================;
;                   Push_Mac                    ;
; Push a macro expansion level. Carry is set    ;
; if error (macro cannot be expanded).          ;
;===============================================;

Push_Mac Proc Near
 Mov Ax,Nmac_Num        ;level to push
 Cmp Ax,Nmac_Max        ;check if to deep
 Je Pumerr              ;jump if so

 Inc Ax                 ;increment level
 Mov Nmac_Num,Ax        ;save

;----- save present macro data first

 Mov Di,Nmac_Loc        ;data location

 Mov Ax,Mac_Loc         ;data location
 Stosw
 Mov Ax,Omac_Table      ;data table location
 Stosw
 Mov Ax,Omac_Num        ;number of table entries
 Stosw
 Mov Ax,Mac_End         ;end of data
 Stosw
 Mov Ax,Mac_Number1     ;definition number
 Stosw
 Mov Ax,Mac_Number2     ;expansion number
 Stosw
 Mov Ax,Omac_Loc        ;local parameter area
 Stosw
 Mov Al,Opt_Stat        ;expand status
 Stosb

 Mov Nmac_Loc,Di        ;save data location
 Clc
 Ret

;----- macros nested too deep

Pumerr Stc
 Ret
 Endp                   ;Push_Mac

;===============================================;
;                    Pop_Mac                    ;
; Pop a macro expansion level. The macro flag   ;
; is set on exit.                               ;
;===============================================;

Pop_Mac Proc Near
 Mov Ax,Nmac_Num        ;level to pop
 Dec Ax                 ;increment level
 Mov Nmac_Num,Ax        ;save

;----- reload pushed macro

 Pushf
 Std                    ;go in reverse
 Mov Si,Nmac_Loc        ;data location
 Dec Si                 ;point to last byte

 Lodsb
 And Al,Mac_Preserve    ;isolate bits to set
 And Opt_Stat,Not Mac_Preserve ;clear relevant bits
 Or Opt_Stat,Al         ;set bits

 Dec Si                 ;previous word
 Lodsw
 Mov Omac_Loc,Ax        ;local parameter area
 Lodsw
 Mov Mac_Number2,Ax     ;expansion number
 Lodsw
 Mov Mac_Number1,Ax     ;definition number
 Lodsw
 Mov Mac_End,Ax         ;end of data
 Lodsw
 Mov Omac_Num,Ax        ;number of table entries
 Lodsw
 Mov Omac_Table,Ax      ;data table location
 Lodsw
 Mov Mac_Loc,Ax         ;data location

 Inc Si
 Inc Si                 ;point back to top of stack
 Mov Nmac_Loc,Si        ;save data location
 Popf

 Mov Ax,Nmac_Num        ;get present level
 Or Ax,Ax               ;check if empty
 Jz Popemp              ;jump if so
 Or Mac_Stat,Mac_Flag   ;set macro on
 Ret

;----- stack empty

Popemp And Mac_Stat,Not Mac_Flag   ;set macro off
 Ret
 Endp                   ;Pop_Mac

;===============================================;
;                       Pif                     ;
; Handles IF.                                   ;
;===============================================;

Pif Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction
 Mov Ax,Dtype           ;type
 Mov Cx,Dval            ;value

 Call Push_If           ;push IF level
 Ret
 Endp                   ;Pif

;===============================================;
;                   Push_If                     ;
; Push IF level.  Carry is set if too deep.     ;
;===============================================;

Push_If Proc Near
 Mov Ax,Ifnum           ;present nest level
 Cmp Ax,Ifmax           ;compare to max
 Je Puiferr             ;jump if too many

 Mov Bx,Ax
 Add Bx,Iftab           ;absolute location
 Mov Dl,If_Stat         ;get present if status
 Mov [Bx],Dl            ;save present status
 Inc Ax                 ;another level
 Mov Ifnum,Ax           ;save

 Cmp Dl,If_None         ;check if first conditional statement
 Je Iftrue              ;jump if so
 Cmp Dl,If_True         ;check if presently true
 Je Iftrue              ;jump if so

;----- skip remaining expression

 Mov If_Stat,If_Skip    ;set to skip
 Clc
 Ret

;----- result is possibly true

Iftrue
 Or Cx,Cx               ;check if value is zero
 Jz Iffalse             ;jump if so

 Mov If_Stat,If_True    ;set to true
 Clc
 Ret

;----- result is false

Iffalse
 Mov If_Stat,If_False  ;set to false
 Ret

;----- IF's are nested too deep

Puiferr
 Mov Bx,Ifmax           ;max nest level
 Mov Ax,020ah           ;error 10
 Call Error             ;error routine
 Ret
 Endp                   ;Push_If

;===============================================;
;                    Pelseif                    ;
; Handles ELSEIF.                               ;
;===============================================;

Pelseif Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction
 Mov Ax,Dval            ;value
 Mov Dx,Dtype           ;type

 Cmp If_Stat,If_False   ;check if previously false
 Je Elitrue             ;jump if so
 Cmp If_Stat,If_None    ;check if not in IF
 Je Poelierr            ;jump if so

;----- skip remaining conditional code

 Mov If_Stat,If_Skip    ;set to skip
 Ret

;----- result is possibly true, check operand

Elitrue Or Ax,Ax        ;check if value is false
 Jz Elifalse            ;jump if so

 Mov If_Stat,If_True    ;set to true
 Ret

;----- result is false

Elifalse Mov If_Stat,If_False ;set to false
 Ret

;----- missing IF

Poelierr Mov Ax,0008h   ;error 8
 Call Error             ;error routine
 Ret
 Endp                   ;Pelseif

;===============================================;
;                    Pnextif                    ;
; Handles NEXTIF.                               ;
;===============================================;

Pnextif Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction
 Mov Ax,Dval            ;value
 Mov Dx,Dtype           ;type

 Cmp If_Stat,If_Skip    ;check if skipping
 Je Nxiskip             ;jump if so
 Cmp If_Stat,If_None    ;check if not in IF
 Je Ponxierr            ;jump if so

;----- result is possibly true, check operand

 Or Ax,Ax               ;check if value is false
 Jz Nxifalse            ;jump if so

 Mov If_Stat,If_True    ;set to true
 Ret

;----- skip remaining conditional code

Nxiskip Mov If_Stat,If_Skip ;set to skip
 Ret

;----- result is false

Nxifalse Mov If_Stat,If_False ;set to false
 Ret

;----- missing IF

Ponxierr Mov Ax,0008h   ;error 8
 Call Error             ;error routine
 Ret
 Endp                   ;Pnextif

;===============================================;
;                     Pelse                     ;
; Handles ELSE.                                 ;
;===============================================;

Pelse Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction

 Cmp If_Stat,If_False   ;check if previously false
 Je Eltrue              ;jump if so
 Cmp If_Stat,If_None    ;check if not in IF
 Je Poelerr             ;jump if so

;----- skip remaining conditional code

 Mov If_Stat,If_Skip    ;set to skip (not necessary, already set)
 Ret

;----- previous IF was false, set to true

Eltrue Mov If_Stat,If_True ;set to true
 Ret

;----- missing IF

Poelerr Mov Ax,0008h    ;error 8
 Call Error             ;error routine
 Ret
 Endp                   ;Pelse

;===============================================;
;                      Pendif                   ;
; Handles ENDIF.                                ;
;===============================================;

Pendif Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction
 Call Pop_If            ;pop IF level
 Ret
 Endp                   ;Pendif

;===============================================;
;                    Pop_If                     ;
; Pop IF level.                                 ;
;===============================================;

Pop_If Proc Near
 Cmp If_Stat,If_None    ;check if not in IF
 Je Poiferr             ;jump if so

;----- get previous IF status

 Mov Bx,Ifnum           ;present nest level
 Dec Bx                 ;lower level
 Mov Ifnum,Bx           ;save
 Add Bx,Iftab           ;absolute location
 Mov Dl,[Bx]            ;save present status
 Mov If_Stat,Dl         ;set status
 Ret

;----- not in IF

Poiferr
 Mov Ax,0008h           ;error 8
 Call Error             ;error routine
 Ret
 Endp                   ;Pop_If

;===============================================;
;                    Pexpon                     ;
; Handles EXPAND+.                              ;
;===============================================;

Pexpon Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopexpon           ;jump if not

 Or Opt_Stat,Exp_Flag   ;set flag
Nopexpon Ret
 Endp                   ;Pexpon

;===============================================;
;                   Pexpoff                     ;
; Handles EXPAND-.                              ;
;===============================================;

Pexpoff Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopexpoff          ;jump if not

 And Opt_Stat,Not Exp_Flag ;clear flag
Nopexpoff Ret
 Endp                   ;Pexpoff

;===============================================;
;                    Pjmpon                     ;
; Handles JUMP+.                                ;
;===============================================;

Pjmpon Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopjmpon           ;jump if not

 Or Opt_Stat,Jmp_Flag   ;set flag
Nopjmpon Ret
 Endp                   ;Pjmpon

;===============================================;
;                   Pjmpoff                     ;
; Handles JUMP-.                                ;
;===============================================;

Pjmpoff Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopjmpoff          ;jump if not

 And Opt_Stat,Not Jmp_Flag ;clear flag
Nopjmpoff Ret
 Endp                   ;Pjmpoff

;===============================================;
;                    Puseon                     ;
; Handles UNUSED+                               ;
;===============================================;

Puseon Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopuseon           ;jump if not

 Or Opt_Stat,Used_Flag  ;set flag
Nopuseon Ret
 Endp                   ;Puseon

;===============================================;
;                   Puseoff                     ;
; Handles UNUSED-.                              ;
;===============================================;

Puseoff Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopuseoff          ;jump if not

 And Opt_Stat,Not Used_Flag ;clear flag
Nopuseoff Ret
 Endp                   ;Puseoff

;===============================================;
;                    Psymon                     ;
; Handles SYMDUMP+.                             ;
;===============================================;

Psymon Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopsymon           ;jump if not

 Or Opt_Stat,Symtab_Flag ;set flag
Nopsymon Ret
 Endp                   ;Psymon

;===============================================;
;                   Psymoff                     ;
; Handles SYMDUMP-.                             ;
;===============================================;

Psymoff Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopsymoff          ;jump if not

 And Opt_Stat,Not Symtab_Flag ;clear flag
Nopsymoff Ret
 Endp                   ;Psymoff

;===============================================;
;                    Pallon                     ;
; Handles FLAGALL+.                             ;
;===============================================;

Pallon Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopallon           ;jump if not

 Or Opt_Stat,All_Undef  ;set flag
Nopallon Ret
 Endp                   ;Pallon

;===============================================;
;                   Palloff                     ;
; Handles FLAGALL-.                             ;
;===============================================;

Palloff Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Nopalloff          ;jump if not

 And Opt_Stat,Not All_Undef ;clear flag
Nopalloff Ret
 Endp                   ;Palloff

;===============================================;
;                    Perror                     ;
; Handles ERROR. User defined error.            ;
;===============================================;

Perror Proc Near
 Cmp Pass,2             ;check if pass two
 Jne Noperror           ;jump if not

;----- check if header needed

 Inc Error_Num          ;increment number of errors
 Test List_Stat,First_Head ;see if already done
 Jz Perrnh              ;jump if so
 Call Header            ;output header

;----- display error message

Perrnh Mov Di,Lst_Buffer ;output buffer
 Mov Si,Offset Begerr   ;borrow error message from error routine
 Store_Str              ;store
 Mov Si,Str_Buff        ;string storage
 Store_Str              ;store
 Call Error_File        ;any special error info
 Call Lst_Send          ;send to output
 Mov Prt_Flag,Hide      ;hide instruction

Noperror Ret
 Endp                   ;Perror

;===============================================;
;                     Presetc                   ;
; Handles RESETC.  Resets byte counter and      ;
; checksum.                                     ;
;===============================================;

Presetc Proc Near

;----- set byte counter

 Mov Counter_Num,0      ;reset counter
 Test Dtype,None        ;test if no operand
 Jnz Nprescoun
 Mov Ax,Dval            ;get value
 Mov Counter_Num,Ax     ;save

;----- set byte checksum

Nprescoun
 Mov Counter_Chk,0      ;reset checksum
 Test Stype,None        ;test if no operand
 Jnz Npreschk
 Mov Ax,Sval            ;get checksum
 Mov Counter_Chk,Al     ;save

Npreschk Ret
 Endp                   ;Presetc

;===============================================;
;                      Pifn                     ;
; Handles IFN (if-not).                         ;
;===============================================;

Pifn Proc Near
 Mov Prt_Flag,Hide      ;hidden instruction
 Mov Ax,Dtype           ;type
 Mov Cx,Dval            ;value

;----- invert value: if not zero, set to zero, otherwise set to FFFFH;
;----- cannot just NOT, since NOT will only work if 0 or FFFFH

 Or Cx,Cx               ;check if zero
 Jz Pifzer              ;jump if so

 Sub Cx,Cx
 Jmps Pifst

Pifzer  Not Cx          ;make not zero

;----- push level

Pifst Call Push_If      ;push IF level
 Ret
 Endp                   ;Pifn

;===============================================;
;                    Penter                     ;
; Handles encoding the 286 ENTER instruction.   ;
;===============================================;

Penter Proc Near
 Mov Ax, 4              ;always four bytes
 Add Loctr,Ax           ;update location counter
 Add Counter_Num,Ax     ;byte counter
 Add Obj_Count,Ax       ;total byte count

 Cmp Pass,2             ;which pass
 Jne Pentdone           ;jump if not pass two

 Mov Obj_Length,Ax      ;number of bytes to write
 Mov Cx, Ax             ;save byte count

 Mov Di,Obj_Buffer      ;object buffer location
 Mov Al, 0c8h           ;op code
 Stosb
 Mov Ax, Dval           ;first operand
 Stosw
 Mov Al,Byte Sval       ;second operand
 Stosb
 Call New_Chksum        ;calculate checksum
Pentdone Ret
 Endp                   ;Penter

;===============================================;
;                   Pimul                       ;
; Handles encoding the 80286 extensions to the  ;
; IMUL instruction.                             ;
;===============================================;

Pimul Proc Near
 Test Stype, Immed      ;check if already loaded immediate
 Jz Pimlex

;--- save immediate and copy destination to source

 Push Stype             ;
 Push Sval              ;-- save these for end
 Push Ssize             ;
 Mov Ax, Dtype
 Mov Stype, Ax          ;type
 Mov Ax, Dval
 Mov Sval, Ax           ;value
 Mov Ax, Dsize
 Mov Ssize, Ax          ;size
 Jmps Pimenc

;--- load extra (third) operand

Pimlex Mov Ax, None     ;type if error
 Cmp Line_Rem,0         ;check if no line remaining
 Je Pimzlin
 Call Eval_Oprnd        ;get and evaluate operand
Pimzlin Push Ax
 Push Bx
 Push Cx

;----- update location counter only

Pimenc
 Mov Opval, 69h         ;replace opcode

 Cmp Pass,1             ;which pass
 Jne Pimul1             ;other routine on pass two
 Call Update_Lct        ;update location counter
 Jmps Pimaddi

;----- update location counter and generation obj code

Pimul1 Mov Di,Obj_Buffer        ;place to put obj code
 Call Build_Obj                 ;update and generate

;--- add data onto end

Pimaddi Pop Cx          ;
 Pop Bx                 ;-- restore third operand
 Pop Ax                 ;

 Test Ax,Immed                  ;check if immediate data
 Jz Pimulerr
 Test Cx, S8bit OR S16bit       ;check size of data
 Jz Pimulerr

Pimrec Mov Di,Obj_Buffer        ;place to put obj code
 Cmp Bx, 127                    ;check if greater than signed byte
 Jg Pimword
 Cmp Bx, -128                   ;check if less than signed byte
 Jl Pimword

;----- byte of data

 Or BYTE [di], Data_Flag        ;set s bit
 Add Di, Obj_Length             ;skip over current code
 Mov Al, Bl
 Stosb                          ;store data
 Mov Dl, Al                     ;checksum additive
 Mov Ax, 1                      ;bytes to increment
 Jmps Pimcont

;---- word of data

Pimword Add Di, Obj_Length      ;skip over current code
 Mov Ax, Bx
 Stosw                          ;store data
 Mov Dl, Al
 Add Dl, Ah                     ;checksum additive
 Mov Ax, 2                      ;bytes to increment

;--- update object code information

Pimcont Add Obj_Length,Ax       ;increment bytes of object code
 Add Loctr,Ax                   ;update location counter
 Add Counter_Num,Ax             ;byte counter
 Add Obj_Count,Ax               ;total byte count

 Cmp Pass,2             ;check if pass 2
 jne Pimuldon
 Add Counter_Chk, Dl    ;add in counter checksum
 Add Program_Chk, Dl    ;add in program checksum
Pimuldon Ret

;--- error in data

Pimulerr
 Mov Ax,0016h                   ;error 22
 Call Error                     ;error routine
 Mov Ax, Immed                  ;type
 Sub Bx, Bx                     ;value
 Mov Cx, S8bit OR S16bit        ;size
 Jmps Pimrec                    ;jump back
 Endp                   ;Pimul
