;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Operands                    ;
; Evaluates the specified number of operands    ;
; for the instruction (no more than the first   ;
; two). The type, value and size are saved in   ;
; DTYPE, DVAL, DSIZE, STYPE, SVAL, and SSIZE.   ;
; Note that the number of operands are are set  ;
; previously by the operation type.             ;
;===============================================;

Operands Proc Near

;----- evaluate operands

 Mov Al,Oprnd_Num       ;number of operands
 Or Al,Al
 Jz Noopeval            ;jump for none
 Dec Al
 Jz Singopval           ;jump for single

;----- destination

 Call Eval_Oprnd        ;get and evaluate operand
 Mov Dtype,Ax           ;type
 Mov Dval,Bx            ;value
 Mov Dsize,Cx           ;size

;----- source

 Call Eval_Oprnd        ;get and evaluate operand
 Mov Stype,Ax           ;type
 Mov Sval,Bx            ;value
 Mov Ssize,Cx           ;size
 Ret

;----- single operand evaluation

Singopval
 Call Eval_Oprnd        ;get and evaluate operand
 Mov Dtype,Ax           ;type
 Mov Dval,Bx            ;value
 Mov Dsize,Cx           ;size
 Mov Ax,None            ;type
 Mov Stype,Ax
 Sub Ax,Ax              ;value
 Mov Sval,Ax
 Mov Ssize,Ax
 Ret

;----- no operand evaluation

Noopeval Mov Ax,None    ;type
 Mov Dtype,Ax
 Mov Stype,Ax
 Sub Ax,Ax              ;value
 Mov Dval,Ax
 Mov Sval,Ax
 Mov Dsize,Ax
 Mov Ssize,Ax
 Ret
 Endp                   ;Operands

;===============================================;
;                  Eval_Oprnd                   ;
; Single operand look up. Gets, looks up, and   ;
; fully evaluates the next operand in the       ;
; source line. Returns type in AX, value in     ;
; BX, and size in CX.                           ;
;===============================================;

Eval_Oprnd Proc Near
 Mov Para_Lev,0         ;initialize parenthesis level
 Mov Oprnd_Flg,0        ;init (carry) flag for parenthesis match
 Mov Oprnd_Lev,0        ;initalize nest level
 Mov Ax,Oprnd_Tab       ;start of table
 Mov Oprnd_Poi,Ax       ;initalize table pointer
 Mov Oprnd_Stat,Reset_Oprnd ;reset operand status

 Call Eval_Expr         ;get next expression

;----- check for parenthesis nested too deep

 Test Oprnd_Stat, Nest_Err ;check if nested too deep
 Jz Evoppchk            ;jump if not

 Push Ax
 Mov Ax,0090h           ;error 144
 Call Error             ;error routine
 Pop Ax

;----- check if error in parenthesis
 
Evoppchk
 Test Oprnd_Flg,1       ;test if carry set
 Jnz Noolpmat           ;jump if so (para. count went below 0)
 Cmp Para_Lev,0         ;make sure parenthesis matched
 Jne Noolpmat           ;jump if not (missing right parenthesis)
 Ret

;----- error in parenthesis

Noolpmat Push Ax
 Mov Ax,0001h           ;error 1
 Call Error             ;error routine
 Pop Ax
 Ret
 Endp                   ;Eval_Oprnd

;===============================================;
;                   Eval_Expr                   ;
; Single expression look up. Gets, looks up,    ;
; and fully evaluates the next expression in    ;
; the source line. Returns type in AX, value    ;
; in BX, and size in CX.                        ;
;===============================================;

Eval_Expr Proc Near

;----- get first operand

 Call Next_Oprnd        ;get and evaluate next operand field
 Jc Nexexbapo           ;jump if special character
 Test Oprnd_Stat,Oprnd_End ;see if finished with operand
 Jnz Nexexdon           ;jump if so

;----- get first operator

 Push Ax
 Push Bx
 Push Cx
 Push Fe_Start
 Push Fe_Stop

 Call Get_Oprnd         ;get next operand, should be operator
 Mov Dl,Al
 Mov Di,Fe_Stop         ;save stop if not end of expression

 Pop Fe_Stop
 Pop Fe_Start
 Pop Cx
 Pop Bx
 Pop Ax
 Jnc Nexexbado          ;jump if no operator

Evexfocon Cmp Dl,','    ;check if end of operand
 Je Nexexdonc           ;jump if so
 Cmp Dl,')'             ;check if explicit end of expression
 Jne Neexop             ;jump if not

;----- end of expression after first operand

 Mov Fe_Stop,Di         ;new end of operand
 Dec Para_Lev           ;lower parenthesis level
 Pushf                  ;flags on stack
 Pop Bp                 ;into BP
 Or Oprnd_Flg,Bp        ;set flags for parenthesis check
 Ret

;----- operator returned in place of first operand

Nexexbapo Cmp Al,')'    ;check if parenthesis
 Jne Nexexnotp          ;jump if not

;----- parenthesis, must be () so return none

 Dec Para_Lev           ;lower parenthesis level
 Pushf                  ;flags on stack
 Pop Ax                 ;into AX
 Or Oprnd_Flg,Ax        ;set flags for parenthesis check

 Mov Ax,None            ;type
 Sub Bx,Bx              ;value
 Mov Cx,Bx              ;size
 Ret

;----- operator returned in place of first operand is illegal

Nexexnotp Mov Dl,Al     ;parenthesis or bracket
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Jmps Eval_Expr         ;jump if not, try again

;---- finished after first operand

Nexexdonc Or Oprnd_Stat,Oprnd_End ;set flag
Nexexdon Ret

;----- initial operator not returned

Nexexbado Jnz Nexexfie  ;jump if field returned
 Ret

;----- field found instead of operator

Nexexfie Push Ax
 Push Bx
 Push Cx
 Call Oper_Sub          ;look for substitution
 Pop Cx
 Pop Bx
 Pop Ax
 Jc Evexfocon           ;jump if found
 Jmp Nexexbfop          ;illegal field

;----- start extended operand

Neexop
 Test Ax,Immed Or Addr Or Neart Or Fart Or Undef ;test if legal types
 Jz Nexexbadt           ;jump if error

 Mov Fe_Stop,Di         ;new end of operand
 Mov Pres_Op,Dl         ;save operator

 Call Push_Oprnd        ;push operand
 Jc Nexextd             ;jump if too deep

;----- get the next operand

Nexexlop
 Push Fe_Start
 Mov Dl,Pres_Op
 Push Dx

 Call Next_Oprnd        ;get next operand
 Mov Si,Fe_Start        ;save start in case of error

 Pop Dx
 Mov Pres_Op,Dl
 Pop Fe_Start
 Jc Nexexnoop           ;jump if operator returned

 Test Oprnd_Stat,Oprnd_End ;test if finished with operand
 Jnz Nexexop            ;jump if so
 Test Ax,Immed Or Undef ;test if immediate data, must be
 Jz Nexexbnt            ;jump if not

 Call Push_Oprnd        ;push operand
 Jc Nexextdp            ;jump if too deep

;----- evaluate

 Call Evaluate          ;evaluate
 Call Push_Oprnd        ;result back on stack

;----- get operator

Nexexcont
 Push Fe_Start
 Push Fe_Stop
 Call Get_Oprnd         ;get next operand, should be operator
 Pop Di
 Pop Fe_Start
 Jnc Nexexpdon          ;jump if no operator

Evexfocon2
 Cmp Al,')'             ;check if end of present expression
 Je Nexexdonpp
 Cmp Al,','             ;check if end of operand
 Je Nexexdonoe
 Mov Pres_Op,Al         ;set operator
 Jmps Nexexlop

;----- illegal expression type, first operand, flag operator

Nexexbadt
 Push Ax
 Push Bx
 Push Cx
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Call Skip_Expr         ;skip rest of expression
 Pop Cx
 Pop Bx
 Pop Ax
 Ret

;----- parenthesis too deep, return zero for expression

Nexextdp
 Call Pop_Oprnd         ;pop operand
Nexextd
 Or Oprnd_Stat, Nest_Err ;set nest error flag

 Call Skip_Expr         ;skip rest of expression
 Mov Ax,Immed           ;type
 Sub Bx,Bx              ;value
 Mov Cx,S8bit+S16bit    ;size
 Ret

;----- found bracket or parenthesis instead of operand

Nexexnoop
 Cmp Al,')'             ;check if parenthesis
 Je Nexexnoopp          ;jump if so
 Mov Pres_Op,Al         ;set operand for error
 Jmps Nexexop

Nexexnoopp
 Dec Para_Lev           ;lower parenthesis level
 Pushf                  ;flags on stack
 Pop Ax                 ;into AX
 Or Oprnd_Flg,Ax        ;set flags for parenthesis check

;----- missing operand after operator

Nexexop
 Mov Dl,Pres_Op         ;operator
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Call Pop_Oprnd         ;pop operand
 Ret

;----- illegal expression type, not first

Nexexbnt
 Push Fe_Start
 Mov Fe_Start,Si        ;set start of operand
 Mov Ax,017bh           ;error 123
 Call Error             ;error routine
 Pop Fe_Start
 Jmps Nexexcont         ;continue with next operand

;----- no operator returned

Nexexpdon
 Jz Nexexdonoe          ;jump if end of expression
 Call Oper_Sub          ;look for substitution
 Mov Al,Dl              ;need operator in AL
 Jc Evexfocon2          ;jump if found
 Jmps Nexexbfop         ;illegal field

;----- extended operand terminated by closing parenthesis

Nexexdonpp Dec Para_Lev ;lower parenthesis level
 Pushf                  ;flags on stack
 Pop Ax                 ;into AX
 Or Oprnd_Flg,Ax        ;set flags for parenthesis check
 Call Pop_Oprnd         ;pop operand
 Ret

;----- finished and done with operand

Nexexdonoe
 Mov Fe_Stop,Di         ;skip last field in any error display
 Call Pop_Oprnd         ;pop operand
 Or Oprnd_Stat,Oprnd_End ;set flag
 Ret

;----- illegal field returned, error and skip rest

Nexexbfop Push Ax
 Push Bx
 Push Cx
 Push Fe_Start

 Mov Si,Tempbuff        ;source
 Mov Ax,0462h           ;error 98
 Call Error             ;error routine

 Call Skip_Expr         ;skip remaining expression
 Pop Fe_Start
 Pop Cx
 Pop Bx
 Pop Ax
 Ret
 Endp                   ;Eval_Expr

;===============================================;
;                   Oper_Sub                    ;
; Try to interpret the field operator in        ;
; TEMPBUFF. Carry is set and DL returns the     ;
; substitution character if successful.         ;
;===============================================;

Oper_Sub Proc Near
 Push Di

 Mov Di,Offset Opttab   ;table location
 Mov Si,Tempbuff        ;source
 Call Tab_Look          ;table look up
 Jnc Optnof             ;jump if not found
 Mov Dl,[Bx+Optsub]     ;load operator substitution
 Stc

Optnof Pop Di
 Ret

;----- data

Optsub Db 'AOX\'        ;substitution table
Opttab Label Byte       ;look up table
 Db 3,'AND'
 Db 2,'OR'
 Db 3,'XOR'
 Db 3,'MOD'
 Db 0
 Endp                   ;Oper_Sub

;===============================================;
;                   Skip_Expr                   ;
; Skip following (or remaining) expression.     ;
;===============================================;

Skip_Expr Proc Near
 Mov Dx,1               ;initial parenthesis level

;----- loop until end of expression

Skexloop Push Dx
 Push Fe_Start
 Push Fe_Stop
 Call Get_Oprnd         ;get next operand
 Pop Di
 Pop Fe_Start
 Pop Dx
 Jc Skexspecd           ;jump if special operand
 Jnz Skexloop           ;loop back if normal field
 Ret

;----- special delimiter

Skexspecd Cmp Al,','    ;check if comma
 Je Skexdone
 Cmp Al,'('             ;check if open parenthesis
 Je Skexpul
 Cmp Al,')'             ;check if close parenthesis
 Jne Skexloop

;----- pop a level

 Dec Para_Lev
 Pushf                  ;flags on stack
 Pop Ax                 ;into AX
 Or Oprnd_Flg,Ax        ;set flags for parenthesis check
 Dec Dx                 ;down a level
 Jnz Skexloop           ;jump if more
 Ret

;----- push a level

Skexpul Inc Dx          ;another level up
 Inc Para_Lev
 Jmps Skexloop

;----- comma, done with operand

Skexdone
 Mov Fe_Stop,Di         ;do not include comma in field
 Or Oprnd_Stat,Oprnd_End ;set operand done flag
 Ret
 Endp                   ;Skip_Expr

;===============================================;
;                  Next_Oprnd                   ;
; Single operand field look up. Gets and looks  ;
; up the next individual operand field. The     ;
; type, value, and size are returned in AX,     ;
; BX, and CX respectively. Carry is set if a    ;
; right bracket or parenthesis is found and AL  ;
; returns the character.                        ;
;===============================================;

Next_Oprnd Proc Near
 Mov Pres_Si,' '        ;initialize sign

Nexoploop
 Call Get_Oprnd         ;get operand
 Jc Nospecd             ;jump if sign
 Jz Nonulop             ;jump if no operand
 Mov Si,Tempbuff        ;source
 Call Oprnd_Look        ;look up
 Mov Dl,Pres_Si         ;get sign

;----- finished with operand, expects returned sign in DL

Nochksi Cmp Dl,' '      ;check if blank
 Jne Nobadsi            ;jump if not
 Clc
 Ret

;----- sign returned in front of operand

Nobadsi
 Test Ax,Immed Or Undef ;check if immed
 Jz Norbadsi            ;jump if not, illegal sign

 Cmp Dl,'-'             ;check if minus
 Jne Nochkplu           ;jump if not
 Or Ax,Signed           ;set signed
 Neg Bx                 ;negate value
 Clc
 Ret

Nochkplu
 Cmp Dl,'+'             ;check if plus
 Jne Norbadsi           ;jump if not
 Or Ax,Signed           ;set signed
 Clc
 Ret

;----- illegal sign

Norbadsi
 Push Ax
 Mov Dl,Pres_Si
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Mov Pres_Si,' '        ;clear sign
 Pop Ax
 Clc
 Ret

;----- no operand

Nonulopd
 Or Oprnd_Stat,Oprnd_End ;finished with operand

Nonulop
 Mov Ax,None            ;type
 Sub Bx,Bx              ;value
 Mov Cx,Bx              ;size
 Clc
 Ret

;----- preceding special delimiter

Nospecd Cmp Al,','      ;comma
 Je Nonulopd
 Cmp Al,'['             ;bracket
 Je Noindmem
 Cmp Al,'-'             ;minus
 Je Noprecsi
 Cmp Al,'+'             ;plus
 Je Noprecsi
 Cmp Al,'('             ;left parenthesis
 Je Nopusex
 Cmp Al,')'             ;right parenthesis
 Je Nounexp
 Cmp Al,']'             ;right bracket
 Je Nounexp

;----- illegal preceding special delimiter

Nobadpsp Mov Dl,Al
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Jmps Nexoploop

;----- indirect memory reference

Noindmem
 Test Oprnd_Stat,Mem_Flag ;check if already defining
 Jnz Nobadpsp           ;jump if so

 Mov Dl,Pres_Si
 Push Dx
 Push Fe_Start
 Call Mem_Look          ;memory operand
 Pop Fe_Start
 Pop Dx
 Jmp Nochksi

;----- sign preceding operand

Noprecsi Xchg Al,Pres_Si ;set sign, and load any previous sign
 Cmp Al,' '             ;make sure original sign is blank
 Jne Nobadpsp           ;jump if not
 Jmp Nexoploop

;----- left parenthesis, start of expression

Nopusex
 Inc Para_Lev           ;another level
 Mov Dl,Pres_Si
 Push Dx
 Push Fe_Start
 Call Eval_Expr         ;get next expression
 Pop Fe_Start
 Pop Dx
 Jmp Nochksi

;----- right parenthesis or bracket

Nounexp Stc
 Ret
 Endp                   ;Next_Oprnd

;===============================================;
;                   Push_Oprnd                  ;
; Push operand nest level. Carry set if too     ;
; deep. AX, BX, and CX should contain the       ;
; present operand data.                         ;
;===============================================;

Push_Oprnd Proc Near
 Mov Dx,Oprnd_Lev       ;present level
 Cmp Dx,Oprnd_Max       ;check if level
 Je Puoper              ;jump if so

 Inc Dx                 ;another level
 Mov Oprnd_Lev,Dx       ;save
 Mov Di,Oprnd_Poi       ;pointer

 Stosw                  ;store type
 Mov Ax,Bx
 Stosw                  ;store value
 Mov Ax,Cx
 Stosw                  ;store size

 Mov Oprnd_Poi,Di
 Clc
 Ret

;----- too deep

Puoper Stc
 Ret
 Endp                   ;Push_Oprnd

;===============================================;
;                    Pop_Oprnd                  ;
; Pop operand nest level. Carry set if none on  ;
; stack. AX, BX, and CX return the operand      ;
; data.                                         ;
;===============================================;

Pop_Oprnd Proc Near
 Mov Ax,Oprnd_Lev       ;present level
 Or Ax,Ax               ;check if zero
 Jz Pooper              ;jump if so

 Dec Ax                 ;another level
 Mov Oprnd_Lev,Ax       ;save

 Mov Si,Oprnd_Poi       ;pointer
 Dec Si
 Dec Si                 ;point to end word
 Pushf
 Std

 Lodsw                  ;load size
 Mov Cx,Ax
 Lodsw                  ;load value
 Mov Bx,Ax
 Lodsw                  ;load type

 Inc Si
 Inc Si                 ;point past new end word
 Mov Oprnd_Poi,Si
 Popf
 Clc
 Ret

;----- operand stack empty

Pooper Stc
 Ret
 Endp                   ;Pop_Oprnd

;===============================================;
;                   Evaluate                    ;
; Evaluate present operand expression.          ;
; Combines the top two operands and pop         ;
; operand stack twice. AX, BX, and CX return    ;
; the type, value, and size. Note that the      ;
; operand types are not checked, they are       ;
; assumed to be immediate data.                 ;
;===============================================;

Evaluate Proc Near
 Call Pop_Oprnd         ;pop first operand
 Push Ax
 Push Bx
 Push Cx                ;save first operand values on stack
 Call Pop_Oprnd         ;pop second operand

 Mov Bp,Sp              ;stack

;----- set type

 Mov Dx,[Bp+4]          ;get first operand type
 And Dx,Ax              ;get common bits
 And Dx,True_Const      ;mask out stability bit

 Or Ax,[Bp+4]           ;combine types
 And Ax,Neart Or Fart Or Addr Or Signed Or Undef ;get special bits
 Test Ax,Neart Or Fart Or Addr Or Undef ;test if any addresses
 Jnz Evnoim             ;jump if so, not immed
 Or Ax,Immed            ;make immed

Evnoim Or Ax,Dx         ;reset stability bit (if set in both)
 Mov [Bp+4],Ax          ;save types

;----- evaluate

 Mov Ax,[Bp+2]          ;second value
 Mov Dl,Pres_Op         ;get operator

 Cmp Dl,'+'             ;make sure is plus
 Je Evplu
 Cmp Dl,'-'             ;check if minus
 Je Evmin
 Cmp Dl,'*'             ;check if multiply
 Je Evmul
 Cmp Dl,'/'             ;check if divide
 Je Evdiv
 Cmp Dl,'\'             ;check if mod
 Je Evdiv
 Cmp Dl,And_Op          ;check if and
 Je Evand
 Cmp Dl,Or_Op           ;check if or
 Je Evor
 Cmp Dl,Xor_Op          ;check if xor
 Je Evxor
 Jmp Evboolchk          ;check for boolean operators

;----- add

Evplu Add Ax,Bx         ;add
 Mov Bx,Ax
 Pushf
 Jmps Evaopcon          ;jump to size checking

;----- subtract

Evmin Sub Bx,Ax         ;subtract first from the second
 Pushf
 Jmps Evaopcon          ;jump to size checking

;----- multiply

Evmul Sub Dx,Dx         ;clear DX for multiply
 Test Word [Bp+4],Signed ;test if either is signed
 Jnz Evsmul             ;jump if so, signed multiply

;----- unsigned multiply

 Mul Ax,Bx              ;unsigned multiply
 Mov Bx,Ax              ;save value
 Pushf
 Jmps Evaopcon          ;jump if OK

;----- signed multiply

Evsmul Imul Ax,Bx       ;multiply
 Mov Bx,Ax              ;save value
 Pushf
 Jmps Evaopcon          ;jump if OK

;----- divide

Evdiv Or Ax,Ax          ;check if divide by zero
 Jnz Evdiv2             ;jump if OK

 Mov Ax,0086h           ;error 134
 Call Error             ;error routine
 Mov Ax,1               ;divide by one instead

Evdiv2 Test Word [Bp+4],Signed ;test if either is signed
 Jnz Evsdiv             ;jump if so, signed divide

;----- unsigned divide

 Xchg Ax,Bx
 Sub Dx,Dx              ;clear DX for divide
 Div Ax,Bx              ;divide

 Cmp Pres_Op,'\'        ;check if mod
 Je Evdivnr             ;jump if so
 Mov Bx,Ax              ;save normal result
 Jmps Evsiset           ;no overflow check (can't happen)

Evdivnr Mov Bx,Dx       ;save modulus
 Jmps Evsiset           ;no overflow check (can't happen)

;----- signed divide

Evsdiv Xchg Ax,Bx
 Cwd                    ;make dividend double word
 Sub Cl, Cl             ;CL used to signal divide by zero
 Idiv Ax,Bx             ;signed divide
 Dec Cl                 ;sets overflow if divide by zero
 Pushf

 Cmp Pres_Op,'\'        ;check if mod
 Je Evdivsm             ;jump if so
 Mov Bx,Ax              ;save normal result
 Jmps Evaopcon

Evdivsm Mov Bx,Dx       ;save modulus
 Jmps Evaopcon

;----- and

Evand And Bx,Ax         ;and
 Jmps Evldone           ;jump to size checking
;----- or

Evor Or Bx,Ax           ;or
 Jmps Evldone           ;jump to size checking

;----- xor

Evxor Xor Bx,Ax         ;xor
 Jmps Evldone           ;jump to size checking

;----- check for overflow/carry

Evaopcon
 Test Word [Bp+4],Signed ;test if either is signed
 Jnz Evsschk            ;jump if so

 Popf                   ;restore flags from operation
 Jnc Evsiset            ;jump if no carry, result OK
 Jmps Eveover           ;carry set, result too big

Evsschk Popf            ;restore flags from operation
 Jno Evsiset            ;jump if no overflow, result OK

;----- error, overflow

Eveover
 Test Word [Bp+4],Undef ;test if undefined
 Jnz Evsiset            ;jump if so, no error
 Mov Ax,0025h           ;error 37, overflow
 Call Error             ;error routine

;----- set operand size

Evsiset
 Mov Ax,[Bp+4]          ;types
 Test Ax,Neart Or Fart Or Addr Or Undef ;test if any addresses
 Jnz Evdone             ;jump if so, not immed

 Sub Cx,Cx              ;clear size before set
 Mov Si,Offset Nul_Str  ;do not know operand (in case of error)
 Call Num_Set           ;set size

;----- finished

Evdone Add Sp,6         ;throw away operand data
 Ret

;----- finished with logical operation

Evldone Mov Ax,[Bp+4]   ;types
 And Ax,Not Signed      ;clear any sign
 Mov Cx,S8bit+S16bit    ;either size
 Add Sp,6               ;throw away operand data
 Ret

;----- check for boolean operators

Evboolchk Cmp Dl,'='    ;check if equal
 Je Evequ
 Cmp Dl,'>'             ;check if greater than
 Je Evgre
 Cmp Dl,'<'             ;check if less than
 Je Evles

;----- illegal operator, error message and add

 Push Ax
 Mov Ax,2019h           ;error 25
 Call Error             ;error routine
 Pop Ax
 Jmp Evplu

;----- equal

Evequ Cmp Bx,Ax         ;compare
 Je Evboolt
 Jmps Evboolf

;----- greater than

Evgre
 Test Word [Bp+4],Signed ;test if either is signed
 Jnz Evgres             ;jump if so

 Cmp Bx,Ax              ;compare
 Ja Evboolt
 Jmps Evboolf

;----- greater than (signed)

Evgres Cmp Bx,Ax        ;compare
 Jg Evboolt
 Jmps Evboolf

;----- less than

Evles
 Test Word [Bp+4],Signed ;test if either is signed
 Jnz Evless             ;jump if so

 Cmp Bx,Ax              ;compare
 Jb Evboolt
 Jmps Evboolf

;----- less than (signed)

Evless Cmp Bx,Ax        ;compare
 Jl Evboolt
 Jmps Evboolf

;----- return boolean result

Evboolf Mov Bx,False    ;false
 Jmps Evbool

Evboolt Mov Bx,True     ;true

Evbool Mov Ax,[Bp+4]    ;types
 And Ax,Undef           ;preserve error bits
 Or Ax,Immed+Signed     ;make signed immediate data
 Mov Cx,S8bit+S16bit    ;either size

 Add Sp,6               ;throw away operand data
 Ret
 Endp                   ;Evaluate

;===============================================;
;                   Int_Zero                    ;
; Routine to service interrupt 0 (division by   ;
; zero). Interrupt occurs for what is really    ;
; overflow, when -32768 is divided by -1.       ;
;===============================================;

Int_Zero Proc Far
 Sub Ax, Ax
 Cwd                    ;clear DX:AX, try to avoid more errors
 mov Cl, -128           ;maximum negative value
 Iret                   ;return
 Endp                   ;Int_Zero

;===============================================;
;                   Oprnd_Look                  ;
; Complete look up of operand at SI. The type,  ;
; value, and size are returned in AX, BX, and   ;
; CX respectively. Handles special operands.    ;
;===============================================;

Oprnd_Look Proc Near
 Call Reg_Look          ;register
 Jc Ordfound

 Call Num_Look          ;number
 Jc Ordfound

 Call Char_Look         ;character
 Jc Ordfound

 Call Dchar_Look        ;double character
 Jc Ordfound

 Call Str_Look          ;string
 Jc Ordfound

 Call Ques_Look         ;question mark lookup
 Jc Ordfound

 Call Const_Look        ;constant lookup
 Jc Ordfound

 Call Spec_Look         ;special operand
 Jc Ordfound

 Call Sym_Look          ;in symbol table
 Jnc Ocunrec            ;jump if not found, undefined symbol
 Test Ax,Undef          ;test if previously undefined
 Jnz Ocunrerr           ;jump if so, error
 Test Ax,Macrot         ;make sure is not macro symbol
 Jnz Pomacerr           ;jump if so, error

 And Ax,Not Non_Sym     ;clear non symbol bits

Ordfound Ret

;----- unrecognized operand on pass two, flag and put into symbol table

Ocunrec
 Cmp Pass,2             ;check if pass 2
 Jne Posymerr           ;jump if not

 Push Si
 Call Add_Sym           ;put into symbol table
 Pop Si

 Mov Ax,Undef           ;undefined
 Sub Bx,Bx              ;value
 Mov Cx,Bx              ;size
 Call Put_Sym2          ;new symbol info

 Mov Ax,0412h           ;error 18
 Call Error             ;error routine
 Jmps Posymerr

;----- recognized undefined symbol on pass two, flag if flagging all

Ocunrerr
 Test Opt_Stat,All_Undef ;check if flagging all occurences
 Jz Posymerr

 Mov Ax,0412h           ;error 18
 Call Error             ;error routine
 Jmps Posymerr

;----- tried to access macro symbol

Pomacerr Mov Ax,048fh   ;error 143
 Call Error             ;error routine

;----- return undefined symbol

Posymerr Mov Ax,Undef   ;undefined
 Sub Bx,Bx              ;no value
 Mov Cx,Bx              ;no size
 Ret
 Endp                   ;Oprnd_Look

